<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: showimage.php                                                    ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################

define('THIS_SCRIPT', 'showimage');
define('GET_IMGTYPE_ARRAY', true);
define('GET_EDIT_TEMPLATES', true);
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################

// get special phrase groups
$phrasegroups = array(
	'adv_gallery_showimg',
	'postbit',
	'showthread',
	'album',
	'posting',
	'inlinemod'
);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache',
	'bookmarksitecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'ADV_GALLERY_SHOWIMAGE',
	'adv_gallery_showimage_custombits',
	'adv_gallery_showimage_exifbits',
	'adv_gallery_showimage_filmthumb',
	'adv_gallery_showimage_keywordbit',
	'editor_clientscript',
	'im_aim',
	'im_yahoo',
	'im_icq',
	'im_msn',
	'im_skype',
	'navbar_main',
	'bbcode_video',
	'adv_gallery_postbit_ip',
	'postbit_onlinestatus',
	'showthread_quickreply',
	'adv_gallery_memberaction',
	'adv_gallery_comment_form',
	'adv_gallery_comment',
	'adv_gallery_comment_ignore',
	'adv_gallery_bookmarks',
	'showthread_bookmarksite',
	'adv_gallery_imgbit_simple',
	'adv_gallery_showimage_sidebar',
	'adv_gallery_category_jump',
	'adv_gallery_category_jump_link',
	'adv_gallery_category_jump_subforum'
);

// ####################### PRE-BACK-END ACTIONS ##########################
function exec_postvar_call_back()
{
	// remove pagenumber if we just deleted a message..
	if($_REQUEST['del'] AND $_REQUEST['page']>1)
	{
		$_REQUEST['page'] = 1;
	}
	if($_REQUEST['anchor'] == 1)
	{
		define('VB_URL_SCHEME', false);
//print "<pre>";		print_r($_SERVER['REQUEST_URI']);exit;
	}
	
}

// ######################### REQUIRE BACK-END ############################

require_once('./gallery_global.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/class_socialmessageparser.php');
require_once(DIR . '/includes/class_bbcode_alt.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

($hook = vBulletinHook::fetch_hook('ppgal_showimage_start')) ? eval($hook) : false;

// function only needed in showimage...
function resize_vid($desc, $type=0)
{
	if($type==1)
	{
		return stripslashes($desc);
	}
	$desc = (int)$desc/2;
	$desc = round($desc, 0);
	return $desc;
}

/*###### orderby FIX for future addons like Hot or NOT ### */
// default if order by rating or views
if(($_REQUEST['orderby'] == 'rating' OR $_REQUEST['orderby'] == 'views') AND (!$_REQUEST['direction'] OR empty($_REQUEST['direction'])))
{
	$_REQUEST['direction'] = 'DESC';
}

$postid = $vbulletin->input->clean_gpc('r', 'postid', TYPE_INT);
$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);
$goto = $vbulletin->input->clean_gpc('r', 'goto', TYPE_NOHTML);
$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
$imageuser = $vbulletin->input->clean_gpc('r', 'imageuser', TYPE_INT);
$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);
$original = $vbulletin->input->clean_gpc('r', 'original', TYPE_INT);
$noignore = $vbulletin->input->clean_gpc('r', 'noignore', TYPE_INT);
$cutoffdate = $vbulletin->input->clean_gpc('r', 'cutoffdate', TYPE_NOHTML);
$anchor = $vbulletin->input->clean_gpc('r', 'anchor', TYPE_INT);


// Request Image ID  for Post 
if ($postid AND !$imageid AND !$goto)
{
	$getimageid = $db->query_first("SELECT imageid FROM " . TABLE_PREFIX . "ppgal_posts WHERE postid = '$postid'");
	$ni_string = ($noignore == 1) ? "&amp;noignore=$postid" : '';

	$adv_sorturl = construct_adv_sort_url();
	
	exec_header_redirect_jump('showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $getimageid['imageid'] . $ni_string . $adv_sorturl, 'post' . $postid);
}
else if($anchor == 1 AND $postid > 0 AND $imageid > 0)
{
	$adv_sorturl = construct_adv_sort_url();
	$url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid .  $adv_sorturl;

	exec_header_redirect_jump($url, "post$postid");
}

// Request Last Post
if ($goto == 'lastpost')
{
	if (!$imageid AND $postid)
	{
		$getpostid = $db->query_first("SELECT posts.postid, posts.imageid, images.catid
			FROM " . TABLE_PREFIX . "ppgal_posts AS posts
			LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (images.imageid = posts.imageid)
			WHERE postid = '$postid' ORDER BY posts.dateline DESC");

			$url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $getpostid['imageid'] . '&amp;c=' . $getpostid['catid'];
			
			exec_header_redirect_jump($url, 'post'.$getpostid['postid']);
	}
	else if ($imageid AND !$postid)
	{
		$getpostid = $db->query_first("SELECT posts.postid, posts.imageid, images.catid 
			FROM " . TABLE_PREFIX . "ppgal_posts AS posts
			LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (images.imageid = posts.imageid)		
			WHERE imageid = '$imageid' ORDER BY posts.dateline DESC");

			$url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $getpostid['imageid'] . '&amp;c=' . $getpostid['catid'];

			exec_header_redirect_jump($url, 'post' . $getpostid['postid']);
	}
}

check_image_id($imageid);

$limit = '';

$ppg_vars['albumclass'] = ($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1) ? '_alt' : '';

$wherequery = array();

// Only show images that not moderated
$wherequery[] = 'valid = 1';

// Check to ignore list
$ignquery = fetch_ignored_users($image['catid']);
if ($ignquery)
{
	$wherequery[] = 'images.userid NOT IN(' . $ignquery . ')';
}

// Previous link, Next link, Filmstrip
if ($goto == 'next' OR $goto == 'previous' OR $ppg_options['gallery_filmstrip'])
{
	if(isset($_REQUEST['userid']) AND intval($_REQUEST['userid']) > 0)
	{
		$userid = intval($_REQUEST['userid']);
		$wherequery[] = 'images.userid = ' . $userid;
	}

	if ($catid == 'searchresults')
	{
		$search = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_search WHERE searchid = '$searchid'");
		$orderby = $search['orderby'];
		$direction = $search['direction'];
    		if (!$search['searchid'])
    		{
    			standard_error(fetch_error('searchnoresults', ''));
    		}
	}
	$doorderby = construct_orderby();

	if ($orderby == 'rating')
	{
		$votequery = 'IF(votenum >= ' . iif($catid == 'popimages', $ppg_options['gallery_popimages_votelimit'], $vbulletin->options['showvotes']) . ', votenum, 0) AS votenum, IF(votenum >= ' . iif($catid == 'popimages', $ppg_options['gallery_popimages_votelimit'], $vbulletin->options['showvotes']) . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
	}

	// Figure out which category we're dealing with
	switch ($catid)
	{
		// User Favorites
		case 'favorites':

			$favquery = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_favorites AS favorites USING (imageid)';
			$wherequery[] = 'favorites.userid = \'' . $vbulletin->userinfo['userid'] . '\'';
			break;

		// Popular images
		case 'popimages':
			$limit = $ppg_options['gallery_popimagelimit'];
			if ($orderby == 'rating')
			{
				$doorderby = 'voteavg DESC, votenum';
				$wherequery[] = 'votenum >= ' . $ppg_options['gallery_popimages_votelimit'];
			}
			$direction = 'DESC';
			break;

		// New Images
		case 'newimages':
			$doorderby = 'dateline';
			$direction = 'DESC';
			if ($cutoffdate)
			{
				$wherequery[] = 'images.dateline > ' . iif($cutoffdate == 'lastvisit', $vbulletin->userinfo['lastvisit'], (time() - ($cutoffdate * 86400)));
			}
			else
			{
				$limit = $ppg_options['gallery_newhomeimages'];
			}

			break;

		// New Posts
		case 'newposts':
			$wherequery[] = 'images.posts != 0 AND images.lastpostdateline > ' . iif(!$cutoffdate OR $cutoffdate == 'lastvisit', $vbulletin->userinfo['lastvisit'], (time() - ($cutoffdate * 86400)));;
			$doorderby = 'images.lastpostdateline';
			$direction = 'DESC';
			break;

		// Member Search
		case 'member':
			$wherequery[] = 'userid = \'' . $imageuser . '\'';
			break;
		// Member Search
		case 'subscriptions':
		//		$condition['fromtable'] = 'ppgal_subscribeimage AS subscribeimage';
			
			$wherequery[] = 'subscribeimage.userid = ' . $vbulletin->userinfo['userid'];
			$show['subscribe'] = true;

			$subjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_subscribeimage AS subscribeimage ON (subscribeimage.imageid = images.imageid AND subscribeimage.userid = ' . $vbulletin->userinfo['userid'] . ')';

			break;
		case 'searchresults':
			$wherequery[] = 'imageid IN (' . $search['imageids'] . ')';
			break;

		// Category ID
		default:
			$cat = intval($catid);

			// In case of a reply, there won't be a catid... Assume we're in a category
			// fixed that... but we keep this just in case.. (the query should not be called)
			if (!$cat)
			{
				$getcat = $db->query_first("SELECT catid FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");
				$cat = $getcat['catid'];
				$_REQUEST['catid'] = intval($cat);
			}

			$wherequery[] = 'catid = \'' . $cat . '\'';
	}


	if ($privatecatids = fetch_private_categories())
	{
		$wherequery[] = 'images.catid NOT IN(' . $privatecatids . ')';
	}

	if (!in_array($direction, array('DESC', 'ASC')))
	{
		$direction = $ppg_options['gallery_defdirection'];
	}

	if (in_array($goto, array('next', 'previous')))
	{
		$counter = 0;
		$imagearray = array();
		$getids = $db->query_read("
				SELECT $votequery images.imageid
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				$favquery
				$subjoin
				WHERE " . implode(' AND ', $wherequery) . "
				ORDER BY $doorderby $direction, images.imageid
				" . iif($limit, 'LIMIT ' . $limit)
		);
		while($prevnext = $vbulletin->db->fetch_array($getids))
		{
			$counter ++;
			$imagearray[] = $prevnext['imageid'];
		}

		$db->free_result($getids);
		unset($prevnext);

		$key = array_search($imageid, $imagearray);
		if ($goto == 'next')
		{
			$imageid = iif(isset($imagearray[$key+1]), $imagearray[$key+1], $imagearray[0]);
		}
		else
		{
			$imageid = iif(isset($imagearray[$key-1]), $imagearray[$key-1], $imagearray[$counter-1]);
		}
	}
}

// Show user favorites
if ($vbulletin->userinfo['userid'] AND $ppg_options['gallery_allowfav'])
{
	$query['favfields'] = ',NOT ISNULL(favorites.imageid) AS favid';
	$query['favjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_favorites AS favorites ON (favorites.imageid = images.imageid AND favorites.userid = ' . $vbulletin->userinfo['userid'] . ')';
}

// Show if subscribe
if ($show['subscribe'])
{
	$query['subfields'] = ',NOT ISNULL(subscribeimage.imageid) AS issubscribed';
	$query['subjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_subscribeimage AS subscribeimage ON (subscribeimage.imageid = images.imageid AND subscribeimage.userid = ' . $vbulletin->userinfo['userid'] . ')';
}

// Show EXIF data
if ($ppg_options['gallery_showexif'])
{
	$query['exiffields'] = ', exifinfo';
	$query['exifjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_exif AS exif ON (images.imageid = exif.imageid)';
}


$image = $db->query_first("
		SELECT categories.title AS cattitle, categories.description AS catdesc, images.imageid, username, images.userid, images.title, images.catid, dateline, images.description, keywords, filename, thumbname, width, height, extension, filesize, originalname, originalfilesize, originalwidth, originalheight, views, visitors, posts, valid, open, sticky, votenum, votetotal, options, catimage, catuserid, membercat, useroptions, adv_setting, customfields.*
		$query[favfields]
		$query[subfields]
		$query[exiffields]
		FROM " . TABLE_PREFIX . "ppgal_images AS images
		LEFT JOIN " . TABLE_PREFIX ."ppgal_categories AS categories ON (images.catid = categories.catid)
		LEFT JOIN " . TABLE_PREFIX . "ppgal_customfields_entries AS customfields ON (images.imageid = customfields.imgid)
		$query[favjoin]
		$query[subjoin]
		$query[exifjoin]
		WHERE images.imageid = '$imageid'
");

$adv_options = unserialize($image['adv_setting']);

// Check is image is set to watermark
if ($adv_options['gallery_watermark'] AND !$ppg_options['gallery_permwatermark'])
{
	$ppg_options['gallery_echoimage'] = true;
}

// Check if the image is not valid and user is not category mod no permission
if (!$image['valid'] AND !is_category_mod($image['catid']))
{
	print_no_permission();
}

// Check if user can see the image
$categoryperms = fetch_category_perms();
//print "<pre>";print_r($categoryperms);exit;
check_image_view($image, 'showimage');

if (!$categoryperms["$image[catid]"]['canvieworiginal'] AND $original)
{
	print_no_permission();
}




/*
#################################
######## javascript resizer #####
#################################
*/
$show['resize_inline'] = false;
if ($categoryperms["$image[catid]"]['canvieworiginal'] AND !$original AND $ppg_options['gallery_resize_inline'])
{
	$show['resize_inline'] = true;
}

// Create previous link, next link
$adv_sorturl = construct_adv_sort_url();

$prevurl = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . '&amp;goto=previous' . $adv_sorturl;
$nexturl = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . '&amp;goto=next' . $adv_sorturl;

// Filmstrip
if ($ppg_options['gallery_filmstrip'])
{

	if ($image['membercat'] AND (intval($catid) OR !$catid))
	{
		$wherequery[] = 'images.userid = ' . intval($image['userid']);
	}
	$imagearray = array();
	$filmcache = array();
	$getids = $db->query_read("
			SELECT $votequery images.imageid, images.title, images.userid, images.thumbname, extension
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			$favquery
			$subjoin
			WHERE " . implode(' AND ', $wherequery) . "
			ORDER BY $doorderby $direction, images.imageid DESC
			" . iif($limit, 'LIMIT ' . $limit)
	);

	while($prevnext = $vbulletin->db->fetch_array($getids))
	{
		$imagearray[] = $prevnext['imageid'];
		$filmcache["$prevnext[imageid]"] = $prevnext;
	}

	$db->free_result($getids);
	unset($prevnext);

	$idsize = sizeof($imagearray);

	$key = array_search($imageid, $imagearray);

	$filmstrip = array();
	$halfcount = ceil($ppg_options['gallery_filmstrip'] / -2);
	$nextcount = 0;
	$prevcount = 0;
	$startsub = 0;
	$idcount = 0;
	while ($idcount < $ppg_options['gallery_filmstrip'])
	{
		$imgid = $imagearray[$key+$halfcount];

		if ($halfcount == -1)
		{
			$prevurl = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . iif($imgid, $imgid, $imagearray[$idsize-1]) . $adv_sorturl;
		}
		if ($halfcount == 1)
		{
			$nexturl = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . iif ($imgid, $imgid, $imagearray[0]) . $adv_sorturl;
		}

		if ($imgid)
		{
			$filmstrip["$imgid"] = $filmcache["$imgid"];
			if ($halfcount == 0)
			{
				$filmstrip["$imgid"]['filmarrow_r'] = '';
				$filmstrip["$imgid"]['filmarrow_l'] = '';
			}
			else if ($halfcount > 0)
			{
				$filmstrip["$imgid"]['left_arrow']=false;				
				$filmstrip["$imgid"]['right_arrow']=true;
				$filmstrip["$imgid"]['filmarrow_r'] = str_repeat('&rsaquo;', abs($halfcount));
				$filmstrip["$imgid"]['filmarrow_l'] = str_repeat('&nbsp;', abs($halfcount));
			}
			else
			{
				$filmstrip["$imgid"]['left_arrow']=true;
				$filmstrip["$imgid"]['right_arrow']=false;
				$filmstrip["$imgid"]['filmarrow_l'] = str_repeat('&lsaquo;', abs($halfcount));
				$filmstrip["$imgid"]['filmarrow_r'] = str_repeat('&nbsp;', abs($halfcount));
			}
		}

		$idcount++;
		$halfcount++;
	}

	unset($filmcache, $imagearray);

	if (!empty($filmstrip))
	{
		$filmcellwidth = round(100 / sizeof($filmstrip)) . '%';
		$show['filmstrip'] = true;
		foreach ($filmstrip AS $imgid => $imginfo)
		{
			$imginfo['albumbitclass'] = $ppg_vars['albumclass'];
			$imginfo['url'] = construct_image_url($imginfo, 'thumbname');
			$templater = vB_Template::create('adv_gallery_showimage_filmthumb');
			$templater->register('imginfo', $imginfo);
			$templater->register('filmcellwidth', $filmcellwidth);
			$templater->register('imgid', $imgid);
			$templater->register('imageid', $imageid);
			$templater->register('adv_sorturl', $adv_sorturl);				
			$filmstripthumbs .= $templater->render();
		}
	}
}




$catopts = construct_cat_opts($image['catid'], $image['options']);

if ($image['catuserid'])
{
	$useroptions = construct_cat_user_opts($image['catid'], $image['useroptions']);
}

// Rating
if ($categoryperms["$image[catid]"]['canrateimages'] AND $catopts['allow_ratings'] AND $ppg_options['gallery_allowrating'] AND ($useroptions['allow_rating'] OR !$image['catuserid']))
{
	if ($image['votenum'])
	{
		$image['voteavg'] = vb_number_format($image['votetotal'] / $image['votenum'], 2);
	}
	$show['ratelink'] = true;
}
// new... galrating: if rating allowed but for example disallowed for guest... guest will still see the rating of the image but no dropdown menu available..
$show['galrating'] = $ppg_options['gallery_allowrating'];
// new... already_rated: todo but template and phrase prepared
$show['already_rated'] = false;
// we parse bbcode like picture comments.. (as we do allowed bbcode there)

$bbcode_parser = new  vB_BbCodeParser($vbulletin, fetch_tag_list());

$show['modopts'] = is_category_mod($image['catid']);

/*	last visitors hack.. vbulletin uses a huge query to get last visitors..
	we dont put it in a class.. but we cache it.. (wont be as fancy, without buddies, friends, mods etc.. but less strain)
	AND, most important.. NO extra query! 

	maximum settings...for last visitors Are NOT in ACP to prevent confusion
	maximum was also hardcoded in vbulletin 
	We need the max vars, otherwise the counts wont display
	So do NOT move to ACP !!!
*/
$ppg_options['gallery_display_visitors_pop_max'] = 50;
$ppg_options['gallery_display_visitors_max'] = 20;


// make sure admin entered number
$ppg_options['gallery_display_visitors_pop'] = intval($ppg_options['gallery_display_visitors_pop']);
$ppg_options['gallery_display_visitors'] = intval($ppg_options['gallery_display_visitors']);

// make sure we dont go over max..
$ppg_options['gallery_display_visitors_pop'] = ($ppg_options['gallery_display_visitors_pop']>$ppg_options['gallery_display_visitors_pop_max'])? $ppg_options['gallery_display_visitors_pop_max'] : $ppg_options['gallery_display_visitors_pop']; 


$ppg_options['gallery_display_visitors'] = ($ppg_options['gallery_display_visitors']>$ppg_options['gallery_display_visitors_max']) ? $ppg_options['gallery_display_visitors_max'] : $ppg_options['gallery_display_visitors']; 

// check for popup link
$show['lastvisitpop'] = ($ppg_options['gallery_display_visitors_pop'])? true : false;

if($ppg_options['gallery_display_visitors'] > 0) 
{
	$visitors=array();
	if(!empty($image['visitors']) OR ($image['visitors'] != '')) 
	{ 
		$visitors = unserialize($image['visitors']); 
	} 
	unset($image['visitors']);
	$show['recent_visitors'] = true;
}
else
{
	if(($image['userid'] != $vbulletin->userinfo['userid']) OR ($image['views'] == 0))
	{
		$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_images SET views = views + 1 WHERE imageid = '$image[imageid]'");
		// we also add 1 to imageviews so the display will include this visit
		$image['views'] = $image['views'] + 1;
	}
	$show['recent_visitors'] = false;
}

if($ppg_options['gallery_display_visitors'] > 0) 
{ 
	// visiting user is a guest .. we update views and dont worry about writing to db and adding whatsoever
	if(!$vbulletin->userinfo['userid'])
	{
		$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_images SET views = views + 1 WHERE imageid = '$image[imageid]'");
		// we also add 1 to imageviews so the display will include this visit
		$image['views'] = $image['views'] + 1;
	}
	else
	{
		// case of a registered user.. we check the visitorlist
		// todo: set a shorter array name
		$tmparray = Array(); 
		$tmparray['usercount'] = count($visitors); 

		// we update the user dateline if he was allready here
		$tmparray['updated_dateline'] = false;
		for($i=0;$i<$tmparray['usercount'];$i++) 
		{ 
			if($vbulletin->userinfo['userid']==$visitors[$i]['userid']) 
			{ 
				$visitors[$i]['dateline'] = TIMENOW; 
				$tmparray['updated_dateline'] = true;
			} 
		} 

		// if we didnt update dateline.. its a new user for the list
		if(!$tmparray['updated_dateline']) 
		{ 
			$usertmparray=Array();
			// we got a new user for list.. 
			$usertmparray[0]['userid'] = $vbulletin->userinfo['userid']; 
			$usertmparray[0]['username'] = $vbulletin->userinfo['username'];         
			$usertmparray[0]['dateline'] = TIMENOW;
			// makesure we have enough users for popup

			if($tmparray['usercount'] >= $ppg_options['gallery_display_visitors_pop_max']) 
			{ 
				// visitorlist is full so we remove oldest entry.. thats why we sort it before saving ;)
				$tmparray['dummy'] = array(); // declaration not really needed.. but better.
				$tmparray['dummy'] = array_pop($visitors); 
				//and add new entry 
				$visitors = array_merge((array)$usertmparray, (array)$visitors);             
			} 
			else 
			{ 
				// we just add new entry 
				$visitors = array_merge((array)$usertmparray, (array)$visitors);
				$tmparray['usercount'] = $tmparray['usercount'] + 1;
			}
			unset($usertmparray);
		}
		// array is ok for saving and display now.. BUT.. we have to sort by dateline to use array_pop (above)..
		// SortByDate_desc has been added to functions and can be used on other occasions..
		usort($visitors,  'SortByDate_desc'); 
		$viewers = serialize($visitors);
		$countviews = (($vbulletin->userinfo['userid'] != $image['userid']) OR ($image['views'] == 0))? 1 : 0;
		$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_images SET views = views + $countviews, visitors = '" . $db->escape_string($viewers) . "' WHERE imageid = '$image[imageid]'");  

		// we add the view to imageviews
		$image['views'] = $image['views'] + $countviews;
		unset($viewers, $countviews); 
		$visitorcount = $tmparray['usercount'];
		unset($tmparray);
	}
	// we display the visitors..

	if(!empty($visitors))
	{
		// we recount for guests or ...

		$visitorcount = (intval($visitorcount)<1) ? count($visitors) : $visitorcount;
		$show['visitlink'] = true;
		
		$lastusers = '';
		$vcomma=', ';
		$vcount = 0;
		$vdetails = array();

		for($i=0; $i<$visitorcount;$i++) 
		{
			if(!empty($visitors[$i])) 
			{
				$vcount++;
				if($vcount>$ppg_options['gallery_display_visitors'])
				{
					$vcount = $ppg_options['gallery_display_visitors'];
					break;
				}

				$vdetails['name'] = htmlspecialchars_uni($visitors[$i]['username']); 
				$vdetails['userid'] =  intval($visitors[$i]['userid']);
				$vdetails['url'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $vdetails['userid'], 'username' =>  $vdetails['name']));
				if($i>0)
				{
					$vdetails['comma'] = $vcomma;
					$vdetails['vclass'] = '';
				}
				else
				{
					$vdetails['vclass'] = ' style="padding-left:2px;"';
					$vdetails['comma'] = '';
				}

				$lastusers .= '<li' . $vdetails['vclass'] . ' class="visit">' . $vdetails['comma'] . '<a href="' . $vdetails['url'] . '">' . $vdetails['name'] . '</a></li>';
				
			}
		}
		unset($vdetails);
		$ppg_vars['visitorcount'] = $vcount;
		$ppg_vars['visitors'] = $lastusers;
	}
	else
	{
		// there are no visitors to display...
		$show['visitlink'] = false;
		$ppg_vars['visitorcount'] = 0;
		$ppg_vars['visitors'] = '<li style="padding:2px;">' . $vbphrase['none'] . '</li>';
	}

}
// ######### end userviews...

$image['title'] = stripslashes($image['title']);
if (!$image['title'])
{
	$image['title'] = $image['filename'];
}


$image['views'] = vb_number_format($image['views']);
$image['posts'] = iif(!$categoryperms["$image[catid]"]['canviewreplies'], 0, vb_number_format($image['posts']));
$image['keywords'] = stripslashes($image['keywords']);
$image['dateadded'] = vbdate($vbulletin->options['dateformat'], $image['dateline']);
$image['timeadded'] = vbdate($vbulletin->options['timeformat'], $image['dateline']);
$image['username'] = stripslashes($image['username']);
$image['filesize'] = vb_number_format($image['filesize'], 1, true);
$image['originalfilesize'] = vb_number_format($image['originalfilesize'], 1, true);
$image['folderstring'] = fetch_folder_url($image);
$image['url'] = construct_image_url($image, iif($original, 'originalname', 'filename'));
$imagecode = construct_image_url($image, iif($original, 'originalname', 'filename'), true);



/*
#################################
######## description block  #####
#################################
*/

if($image['description'] AND $image['description'] != '')
{


	$image['description_clean'] = htmlspecialchars_uni(strip_bbcode(strip_tags($image['description']), false, true));
	$image['description_clean'] = str_replace(array("\r\n", "\r", "\n", chr(10), chr(13)), " ", $image['description_clean']);
	$image['description_clean'] = preg_replace("/(\s){2,}/",'$1', $image['description_clean']);

	if(strpos($image['description'], '[video') !== false) 
	{
		$dataman =& datamanager_init('PictureComment', $vbulletin, ERRTYPE_ARRAY);
		// we parse only video with dataman
		$dataman->setr('pagetext', $image['description']);
		$parsevid = true;
	}
	$image['description'] = $bbcode_parser->do_parse(stripslashes($image['description']), $catopts['allow_desc_html'], $catopts['allow_desc_smilies'], $catopts['allow_desc_bbcode'], $catopts['allow_desc_bbimgcode']);

	if($parsevid AND $ppg_options['gallery_small_vid'])
	{
		// resize video
		$image['description'] = preg_replace('%<object(.*?)width="(.*?)"(.*?)height="(.*?)"%e', "'<object' . resize_vid('\\1', 1) . ' width=\"' . resize_vid('\\2', 0) . '\"' . resize_vid('\\3', 1) . ' height=\"' .  resize_vid('\\4', 0) . '\"'", $image['description']);
	}

	// we need the users avatar
	require_once(DIR . '/includes/functions_user.php');
	$imageuserinfo = fetch_userinfo($image['userid'], FETCH_USERINFO_AVATAR);

	fetch_avatar_from_userinfo($imageuserinfo, true, true);
	if(strpos($imageuserinfo['avatarurl'], $vbulletin->options['bburl']) === false) 
	{
		$imageuserinfo['avatarurl'] = $vbulletin->options['bburl'] . '/' . $imageuserinfo['avatarurl'];
	}
	$show['imguseravatar'] = ($image['description'])?true:false;
}

// end description block
/* ################################# */
if($show['resize_inline'])
{
	$ppg_vars['big_image_code'] = addslashes_js(construct_image_url($image, 'originalname'));
	$ppg_vars['small_image_code'] = addslashes_js(construct_image_url($image, 'filename'));
	// lets add the javascript phrases here..
	$vbphrase['js_plus_larger_image'] = addslashes_js($vbphrase['plus_larger_image']);
	$vbphrase['js_minus_smaller_image'] = addslashes_js($vbphrase['minus_smaller_image']);
}

$image['thumbnail'] = construct_image_url($image, 'thumbname');
$image['catimage'] = unserialize($image['catimage']);
$catinfo['title'] = $image['cattitle'];
$catinfo['description'] = $image['catdesc'];

if ($ppg_options['gallery_fileurl'] . '/' . $image['catimage']['url'] == $image['thumbnail'])
{
	$show['removecatimage'] = true;
}

if ($ppg_options['gallery_watermark'] AND $ppg_options['gallery_originalwindow'])
{
	$image['originalurl'] = 'displayimage.php?imageid=' . $image['imageid'] . '&original=1' . $adv_sorturl;
}
else if ($ppg_options['gallery_originalwindow'])
{
	$image['originalurl'] = $image['folderstring'] . '/' . $image['originalname'];
}
else
{
	$image['originalurl'] = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . '&amp;original=1';
}

$show['ecard'] = iif($categoryperms["$image[catid]"]['cansendecard'] AND $ppg_options['gallery_enableecards'], true, false);

if ($searchid)
{
	$search = $db->query_first("SELECT string, sfields, wholeword FROM " . TABLE_PREFIX . "ppgal_search WHERE searchid = '$searchid'");

	$sfields = explode(',', $search['sfields']);

	if (in_array('description', $sfields))
	{
		$image['description'] = highlight_keywords($image['description'], $search['string'], $search['wholeword']);
	}
}

// Show keywords
if ($image['keywords'])
{
    // Lets make <meta> tag keywords from image keywords
    // ** need to add option to count total keywords and trim off default site keywords if needed to not exceed meta tag limit.
   /*
	$image['keywords_meta'] = explode(' ', trim($image['keywords']));
    $image['keywords_meta'] = implode(",", $image['keywords_meta']);

	*/
	
	$image['keywords_meta'] = array();
	if(strpos($image['keywords'], ',') !== false) 
	{
		$image['keywords_meta'] = explode(',', trim($image['keywords']));
	}
	else
	{
		$image['keywords_meta'] = explode(' ', trim($image['keywords']));
	}


    // convert keywords to links
    if ($ppg_options['gallery_convertkeywords'])
	{
		$kwords = explode(' ', trim($image['keywords']));
		$image['keywords'] = '';
		foreach ($kwords AS $keyword)
		{
			if ($keywords)
			{
				$comma = ',';
			}

			if ($searchid)
			{
				if (in_array('keywords', $sfields))
				{
					$image['keyword'] = highlight_keywords($keyword, $search['string'], $search['wholeword']);
				}
			}
			$templater = vB_Template::create('adv_gallery_showimage_keywordbit');
			$templater->register('keyword', $keyword);
			$image['keywords'] .=  $templater->render();
		}
	}
}
else
{
	$image['keywords'] = $vbphrase['none'];
}

// Show ownership of a categories
$plurals = '';
if($ppg_options['gallery_use_plurals_s'])
{			
	if (substr($image['username'], -1) != 's')
	{
		$plurals = $vbphrase['plural_s'];
	}
}
else
{
	$plurals = $vbphrase['plural_s'];
}
$ppg_vars['plurals'] = $plurals;
// Show the correct OLD / NEW statusicon image
$image['statusicon'] = iif($image['dateline'] > $vbulletin->userinfo['lastvisit'], 'new', 'old');

// Show True Rating
$image['truerating'] = 0;
if ($image['votetotal'])
{
	$image['truerating'] = vb_number_format($image['votetotal'] / $image['votenum'], 2);
	$image['roundrating'] = round($image['truerating']);
}

// Show Customfields
$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields ORDER BY displayorder");
if ($db->num_rows($customfields))
{
	while ($field = $vbulletin->db->fetch_array($customfields))
	{
		$thisfield = 'field' . $field['fieldid'];
		if (!$image["$thisfield"])
		{
			continue;
		}

		$show['customfields'] = true;
		$bgclass = exec_switch_bg();

		$field['value'] = $bbcode_parser->do_parse($image["$thisfield"], $catopts['allow_custom_html'], $catopts['allow_custom_smilies'], $catopts['allow_custom_bbcode'], $catopts['allow_custom_bbimgcode']);
		if ($searchid)
		{
			if (in_array($thisfield, $sfields))
			{
				$field['value'] = highlight_keywords($image["$thisfield"], $search['string'], $search['wholeword']);
			}
		}
		//eval('$customfieldbits .= "' . fetch_template('adv_gallery_showimage_custombits') . '";');
			$templater = vB_Template::create('adv_gallery_showimage_custombits');
			$templater->register('field', $field);
			$customfieldbits .=  $templater->render();

	}
}
$db->free_result($customfields);
unset($field);


// Show EXIF tables
$image['exifinfo'] = unserialize($image['exifinfo']);

if (!empty($image['exifinfo']) AND $ppg_options['gallery_exiffields'])
{
	$counter = 0;
	$exif['display'] = explode("\r\n", $ppg_options['gallery_exiffields']);

	$show['camerainfo'] = true;

	foreach ($image['exifinfo'] AS $title => $value)
	{
		if (is_array($value))
		{
			foreach ($value AS $title => $value)
			{

				if ($title AND in_array($title, $exif['display']))
				{
					$templater = vB_Template::create('adv_gallery_showimage_exifbits');
					$templater->register('value', $value);
					$templater->register('title', $title);
					$exifrows .=  $templater->render();
				}
			}
		}
		else
		{
			if (in_array($title, $exif['display']))
			{

				$templater = vB_Template::create('adv_gallery_showimage_exifbits');
				$templater->register('value', $value);
				$templater->register('title', $title);
				$exifrows .=  $templater->render();
			}
		}
	}
	//$exifrows .= construct_empty_cellbits(2, 2);
	//print $exifrows; exit;
}



// Check to see if reply link should be shown
if ($ppg_options['gallery_allowreplies'] AND $categoryperms["$image[catid]"]['canreplytoimages'] AND $catopts['open_for_posts'] != 0  AND $catopts['allow_replies'])
{
	$show['replylink'] = true;
}

// Check to see if send to a friend
if ($categoryperms["$image[catid]"]['cansendimagetofriend'])
{
	$show['sendtofriend'] = true;
}

// Check to see if user can edit
if ($vbulletin->userinfo['userid'] AND (($image['userid'] == $vbulletin->userinfo['userid'] AND $categoryperms["$image[catid]"]['caneditimages']) OR $categoryperms["$image[catid]"]['caneditothersimages'] OR is_category_mod($image['catid'])))
{
	$show['editlink'] = true;
}

$show['inlinemod'] = false;
if($categoryperms["$image[catid]"]['candeleteothersposts'] OR is_category_mod($image['catid']))
{
			$show['inlinemod'] = true;
}


// ######################### Replies to Image aka comments #############################
/// see tests for new stuff at bottom of this section.....
if ($ppg_options['gallery_allowreplies'] AND $categoryperms["$image[catid]"]['canviewreplies'] AND $catopts['allow_replies'])
{
	/*
	#################################
	######## comment sortorder  #####
	#################################
	*/

	$show['switch_sortorder'] = false;
	$sqlsortorder = 'ASC';
	$ppg_options['comment_sortorder'] = 'asc';
	if($ppg_options['gallery_switch_sortorder'])
	{

		$show['switch_sortorder'] = true;

		$cookiesort = $vbulletin->input->clean_gpc('c',	COOKIE_PREFIX . 'ppgpostsort', TYPE_UINT);
		$ppg_options['comment_sortorder'] = (intval($cookiesort) == 1) ? 'desc' : 'asc';

		$psort = $vbulletin->input->clean_gpc('r', 'psort', TYPE_NOHTML);
			
		if(($psort == 'asc' OR $psort == 'desc') AND $psort != $ppg_options['comment_sortorder'])
		{
			if($psort == 'desc')
			{
				$ppg_options['comment_sortorder'] = 'desc';
				vbsetcookie('ppgpostsort', 1);
			}
			else
			{
				$ppg_options['comment_sortorder'] = 'asc';
				vbsetcookie('ppgpostsort', 0);
			}
		}
		$show['sortorder'] = $ppg_options['comment_sortorder'];
		$sqlsortorder = ($ppg_options['comment_sortorder'] == 'desc') ? 'DESC' : 'ASC';
	}

	$show['imagecomments'] = true;
	require_once(DIR . '/includes/class_postbit.php');
	require_once(DIR . '/includes/functions_user.php');

	$ignarray = array();
	

	if ($vbulletin->userinfo['ignorelist'])
	{
		$ignarray = explode(' ', $vbulletin->userinfo['ignorelist']);
	}

	if ($vbulletin->userinfo['maxposts'] != -1)
	{
		$perpage = $vbulletin->userinfo['maxposts'];
	}

	if (!intval($perpage))
	{
		$perpage = $ppg_options['gallery_repliesperpage'];
	}

	if ($_REQUEST['p'])
	{
		$postid = intval($_REQUEST['p']);
	}
	$newpostcount = 0;
	if ($postid)
	{
		if ($ppg_options['comment_sortorder'] == 'desc')
		{
			// Newest first
			$pages = $db->query_first("SELECT COUNT(postid) AS count FROM " . TABLE_PREFIX . "ppgal_posts AS posts WHERE postid > '$postid' AND imageid = '$image[imageid]' AND visible = 1");
		}
		else
		{
			$pages = $db->query_first("SELECT COUNT(postid) AS count FROM " . TABLE_PREFIX . "ppgal_posts AS posts WHERE postid < '$postid' AND imageid = '$image[imageid]' AND visible = 1");
		}

		$pagenumber = ceil(($pages['count'] + 1) / $perpage);

		$newpostcount = $pages['count'] + 1;
		//$pagenumber = ceil(($pages['count']) / $perpage);
	}
	
	if (intval($pagenumber)<1)
	{
	 	$pagenumber = 1;
	}
	
	$counter = 0;
	$perpage = intval($perpage);
	$lowerlimit = ($pagenumber-1) * $perpage + 1;
	$upperlimit = ($pagenumber) * $perpage;

	$countreplies = $db->query_first("SELECT COUNT(postid) AS count FROM " . TABLE_PREFIX . "ppgal_posts AS posts WHERE imageid = '$image[imageid]' AND visible = 1");


// sanitize page number if posts got deleted... and postid still in url... to get correct postcount
	if($newpostcount != $countreplies['count'])
	{
		if ($pagenumber > ceil(($countreplies['count']) / $perpage))
		{
			$pagenumber = ceil(( $countreplies['count']) / $perpage);
		}
	}
	$postcount = ($pagenumber - 1) * $perpage;




	if ($ppg_options['comment_sortorder'] == 'desc')
	{
		// Newest first
		$postcount = $countreplies['count'] - $postcount + 1;
	}

	//print $newpostcount . ' - ' . $countreplies['count'] . ' - ' . $pagenumber . ' - ' . $postcount; exit;

	if ($countreplies['count'] > 0)
	{
		if ($upperlimit > $countreplies['count'])
		{
			$upperlimit = $countreplies['count'];
			if ($lowerlimit > $countreplies['count'])
			{
				$lowerlimit = $countreplies['count'] - $perpage;
			}
		}
		if ($lowerlimit <= 0)
		{
			$lowerlimit = 1;
		}

		$pagenav = construct_page_nav($pagenumber, $perpage, $countreplies['count'], 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i='. $image['imageid'] . $adv_sorturl, '', 'comments');

		$counter = 0;
		

	
		$show['postheader'] = true;

		if ($ppg_options['gallery_showquickreply'] AND $show['replylink'] AND $image['open'])
		{
			$SHOWQUICKREPLY = true;
		}

		// Icons
		if ($ppg_options['gallery_allowposticons'])
		{
			$query['iconfields'] = ',icon.title as icontitle, icon.iconpath';
			$query['iconjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'icon AS icon ON (posts.iconid = icon.iconid)';
		}

		 //Avatars   	
		if ($vbulletin->options['avatarenabled'])
		{

            $query['avatarfields'] = ',avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth,customavatar.height AS avheight,avatarrevision';
            
			$query['avatarjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'avatar AS avatar ON (avatar.avatarid = user.avatarid)
            LEFT JOIN ' . TABLE_PREFIX . 'customavatar AS customavatar ON (customavatar.userid = user.userid)';

		}
		

		//$postbittemplatename = iif($vbulletin->options['legacypostbit'], 'postbit_legacy', 'postbit');
		$postbittemplatename = 'adv_gallery_comment';



		$vbulletin->templatecache['postbit_ignore'] = str_replace(
			array(
				'"member.php',
				'"profile.php',
				'showpost.php?'
			),
			array(
				'"' . $vbulletin->options['bburl'] . '/member.php',
				'"' . $vbulletin->options['bburl'] . '/profile.php',
				'showimage.php?noignore=1&amp;'
			),
			$vbulletin->templatecache['postbit_ignore']
		);

		$posts = $db->query_read("
				SELECT 
				posts.postid, posts.pagetext, posts.title, posts.userid, posts.username AS postusername,
                posts.dateline, posts.ipaddress AS ip, posts.iconid, posts.allowsmilie, posts.showsignature, user.*, userfield.*, ppgal_user.*
				$query[iconfields]
				$query[avatarfields] 
				FROM " . TABLE_PREFIX . "ppgal_posts AS posts
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (posts.userid = user.userid)
                LEFT JOIN " . TABLE_PREFIX . "ppgal_user AS ppgal_user ON (ppgal_user.userid = user.userid)
                LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid)
     			LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (user.userid = usertextfield.userid)
                $query[avatarjoin]
				$query[iconjoin]
				WHERE imageid = '$image[imageid]' AND posts.visible = 1
				ORDER BY posts.dateline $sqlsortorder
				LIMIT " . ($lowerlimit - 1) . ", $perpage
		");
		$show['quote'] = false;
		if ($categoryperms["$image[catid]"]['canreplytoimages'])
		{
			$show['quote'] = true;
		}	


		// we dont really use the dataman... just for parsing videos..
		if(!$dataman)
		{
			$dataman =& datamanager_init('PictureComment', $vbulletin, ERRTYPE_ARRAY);
		}

		$vbphrase['message_hidden_x_on_ignore_list'] = str_replace('"profile.php', '"'.$vbulletin->options['bburl'] . '/profile.php', $vbphrase['message_hidden_x_on_ignore_list']);
		$perpagecount = 0;
		$tmp_vars = array();
		$tmp_vars['add_keywords'] = '';
		$tmp_vars['add_desc'] = '';
		while ($post = $vbulletin->db->fetch_array($posts))
		{
			$tmp_vars['add_keywords'] .= ' ' . $post['title'] . ' ' . $post['pagetext'];
			
			
			$tmp_vars['add_desc'] .= ' ' . $post['pagetext'] . '. ';
			$show['reportlink'] = false;
			$show['edit'] = false;
			if (($categoryperms["$image[catid]"]['caneditposts'] AND $post['userid'] == $vbulletin->userinfo['userid'] AND $vbulletin->userinfo['userid']) OR ($categoryperms["$image[catid]"]['caneditothersposts'] AND $vbulletin->userinfo['userid']))
			{
				$show['edit'] = true;
			}
		
			$parsevid = false;
			if(strpos($post['pagetext'], '[video') !== false) 
			{
				// as we dont have time to rewrite everything.. we use dataman to parse video only
				$dataman->setr('pagetext', $post['pagetext']);
				$parsevid = true;
			}

			$post['message'] = $bbcode_parser->do_parse($post['pagetext'], 0, $post['allowsmilie'], 1, 1);

			if($parsevid AND $ppg_options['gallery_small_vid'])
			{
				// resize video
				$post['message'] = preg_replace('%<object(.*?)width="(.*?)"(.*?)height="(.*?)"%e', "'<object' . resize_vid('\\1', 1) . ' width=\"' . resize_vid('\\2', 0) . '\"' . resize_vid('\\3', 1) . ' height=\"' .  resize_vid('\\4', 0) . '\"'", $post['message']);
			}


			$post['title'] = htmlspecialchars_uni(trim(stripslashes($post['title'])));
			if($post['title'] != '')
			{
				$post['message'] = '<b>' . $post['title'] . '</b><br />' . $post['message'];
			}
		    $post['date'] = vbdate($vbulletin->options['dateformat'], $post['dateline'], true);
		    $post['time'] = vbdate($vbulletin->options['timeformat'], $post['dateline'], true);
			$show['detailedtime'] = true; // could be removed in template or we add an option in acp

			if (empty($checkperms["$post[userid]"]))
			{
				$checkperms["$post[userid]"] = cache_permissions($post, false);
			}

			if ($searchid)
			{
				if (in_array('pagetext', $sfields))
				{
					$post['message'] = highlight_keywords($post['message'], $search['string'], $search['wholeword']);
				}
			}

			$show['postcount'] = true;
			if($ppg_options['comment_sortorder']=='desc')
			{
				$post['postcount'] = --$postcount;
			}
			else
			{
				$post['postcount'] = ++$postcount;
			}
			$perpagecount++;
			if($perpagecount == 1)
			{
				$ppg_vars['first_post'] = $post['postcount'];
				$ppg_vars['last_post'] = $post['postcount'];
			}
			else
			{
				$ppg_vars['last_post'] = $post['postcount'];
			}
			// Status Icon
			$post['statusicon'] = 'old';
			if ($post['dateline'] > $vbulletin->userinfo['lastvisit'])
			{
				$post['statusicon'] = 'new';
			}

			if ($show['replylink'] AND $image['open'])
			{
				$post['replylink'] = 'newreply.php?' . $vbulletin->session->vars['sessionurl'] . 'p=' . $post['postid'];
			}

			// Show IP address
			$post['iplogged'] = '';

			if ($post['ip'])
			{
				if ($vbulletin->options['logip'] == 2)
				{
					$show['ip'] = true;
					$templater = vB_Template::create('adv_gallery_postbit_ip');
					$templater->register('post', $post);
					$post['iplogged'] .=  $templater->render();
				}
				else if ($vbulletin->options['logip'] == 1 AND is_category_mod($post['catid']))
				{
					$show['ip'] = false;
					$templater = vB_Template::create('adv_gallery_postbit_ip');
					$templater->register('post', $post);
					$post['iplogged'] .=  $templater->render();
				}
			}

			if ($post['userid'])
			{
				// Post was by a user
				$post = array_merge($post, convert_bits_to_array($post['options'], $vbulletin->bf_misc_useroptions));

				$post['musername'] = fetch_musername($post);


				// Report link
				
				if (($vbulletin->userinfo['userid'] != $post['userid']) AND $vbulletin->userinfo['userid'])
				{
					$show['reportlink'] = true;
				}


				// Online Status
				fetch_online_status($post, true);

				//$post['onlinestatus'] = str_replace('"images', '"' . $vbulletin->options['bburl'] . '/images', $post['onlinestatus']);
				// Im Icons

				

				construct_im_icons($post);
				
				// AVATAR
				$show['galavatar'] = false;

				if (in_array($post['userid'], $ignarray) AND (!$noignore OR $noignore != $post['postid']))
				{
					if($vbulletin->options['avatarenabled'])
					{
						$post['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/unknown.gif";
						$show['galavatar'] = true;
					}
					$post['musername'] = htmlspecialchars_uni($post['musername']);
					$post['userurl'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $post['userid'], 'username' =>  $post['musername']));


				}
				else 
				{
					if($vbulletin->options['avatarenabled'])
					{
						
						fetch_avatar_from_userinfo($post, true, true);
						if(strpos($post['avatarurl'], $vbulletin->options['bburl']) === false) 
						{
							$post['avatarurl'] = $vbulletin->options['bburl'] . '/' . $post['avatarurl'];
						}
						$show['galavatar'] = true;
					}
					// memberaction dropdown
					$vbulletin->templatecache['memberaction_dropdown'] = $vbulletin->templatecache['adv_gallery_memberaction'];
					$memberaction_dropdown = construct_memberaction_dropdown($post);
				}

			}
			else
			{
				// Guest Post
				$post['posts'] = $vbphrase['n_a'];
				
				$post['username'] = $post['postusername'];
				$post['musername'] = fetch_musername($post);

				if($post['musername'] == '' OR $post['musername'] == $vbphrase['unregistered'] OR !$post['musername'] OR !$post['username'] OR  $post['username'] == '' OR $post['username'] == $vbphrase['unregistered'])
				{
					$post['musername'] = $vbphrase['guest'];
				}
				$post['usertitle'] = $vbphrase['guest'];

				$show['galavatar'] = false;
				if($vbulletin->options['avatarenabled']){
					$post['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/unknown.gif";

					$show['galavatar'] = true;
				}

			}

			// Print the postbit
            if (in_array($post['userid'], $ignarray) AND (!$noignore OR $noignore != $post['postid']))
			{
				//eval('$postbit .= "' . fetch_template('postbit_ignore') . '";');
					$templater = vB_Template::create('adv_gallery_comment_ignore');
					//		$templater->register('item', $item);
					

			}
			else
			{
				
				//eval('$postbit .= "' . fetch_template($postbittemplatename) . '";');
				$templater = vB_Template::create($postbittemplatename);

					
			}
			$templater->register('post', $post);
			$templater->register('adv_sorturl', $adv_sorturl);
			$templater->register('page', $pagenumber);
			$templater->register('memberaction_dropdown', $memberaction_dropdown);
			$postbit .=  $templater->render();
			
		}
		$db->free_result($posts);
		
		unset($query, $post, $dataman);
	}
}

// #########################################################
// ################# NEW QUICK REPLY #######################
// #########################################################

	$show['quickreply']  = ($categoryperms["$image[catid]"]['canreplytoimages'] AND $ppg_options['gallery_showquickreply'] AND $show['replylink'] AND $image['open']);
	$show['quickcomment'] = $show['quickreply'];// needed as we use the image comments.. quick editor..

	$show['commentlink']  = ($categoryperms["$image[catid]"]['canreplytoimages'] AND !$ppg_options['gallery_showquickreply'] AND $show['replylink'] AND $image['open']);

	//we switch off ajax.. as it only works on first page, but we want to modify sortorder, in that case the newest could be pages away... we will though, maybe use ajax for pagination.. in that case we could also post with ajax.. (flagged for next version, get this running first.)

	if ($show['quickreply'])
	{
		$show['allow_ajax_qc'] = 0; // ajax off

		$vbulletin->options['allowbbcode'] = $catopts['allow_post_bbcode'];
		$vbulletin->options['allowbbimagecode'] = $catopts['allow_post_bbimgcode'];
		$vbulletin->options['allowsmilies'] = $catopts['allow_post_smilies'];

		$threadedmode = 0;
		$qrpostid = 'who cares';
		$show['qr_require_click'] = 0;

		// add javascript for quickreply
		$cr = "\n";
		$qr_javascript = '<script type="text/javascript">' . $cr;
		$qr_javascript .= 'var require_click = 0;' . $cr;
		$qr_javascript .= 'var is_last_page = "' . iif(ceil($countimages['count'] / $perpage) == $pagenumber, 1, 0) . '";' . $cr;
		$qr_javascript .= 'var allow_ajax_qr = 0;' . $cr;
		$qr_javascript .= 'var ajax_last_post = "";' . $cr;
		$qr_javascript .= '</script>' . $cr;
		$qr_javascript .= '<script type="text/javascript" src="'.$vbulletin->options['bburl'] . '/clientscript/vbulletin_quick_reply.js"></script>'. $cr;

		$headinclude .= $qr_javascript;
		unset($qr_javascript);

		$vbulletin->templatecache['editor_clientscript'] = str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['editor_clientscript']);
		require_once(DIR . '/includes/functions_editor.php');
		
		$show['allow_ajax_qc'] = (($pagenumber == ceil($countreplies['count'] / $perpage)) AND $countreplies['count']) ? 1 : 0;
		//$show['wysiwyg'] = ($catopts['allow_post_bbcode'] ? is_wysiwyg_compatible() : 0);
		$_REQUEST['wysiwyg'] = ($catopts['allow_post_bbcode'] ? is_wysiwyg_compatible(-1, 'qr_small') : 0);
		$editorid = construct_edit_toolbar(
			'',
			false,
			'picturecomment',
			$vbulletin->options['allowsmilies'],
			true,
			false,
			'qr_small'
		);

	}
	else
	{
		$editorid = '';
	}


	if ($editorid)
	{
		$templater = vB_Template::create('adv_gallery_comment_form');
		$templater->register('image', $image);
		$templater->register('allowed_bbcode', $allowed_bbcode);
		$templater->register('editorid', $editorid);
		$templater->register('qrpostid', $qrpostid);
		$templater->register('messagearea', $messagearea);
		$templater->register('adv_sorturl', $adv_sorturl);
		$templater->register('vBeditTemplate', $vBeditTemplate);
		$messagearea = $templater->render();
		$messagearea = str_replace('"images/','"' . $vbulletin->options['bburl'] . '/images/', $messagearea);

	}
	else
	{
		$messagearea = '';
	}


/* ############### build user images ############ */
// todo... do this first then -> serialize then -> save in userinfo

$show['more_images_by'] = ($ppg_options['gallery_moreimagesblock']) ? true : false;
if($show['more_images_by'])
{
	$getrand = $db->query_read("
		SELECT imageid, userid, username, title, filename, width, height, thumbname, originalname, extension, catid
		FROM " . TABLE_PREFIX . "ppgal_images AS images
		WHERE $privcatids images.valid = 1 AND userid = ".$image['userid']." AND imageid <> " . $image['imageid'] . " 
		ORDER BY RAND()
		LIMIT $ppg_options[gallery_newhomeimages]
	");
	$ppg_vars['extra_imgs'] = '';
	if ($db->num_rows($getrand))
	{
		$counter = 0;
		while ($extra_img = $vbulletin->db->fetch_array($getrand))
		{
			$counter++;
			$linecounter++;
			$user_sorturl = '&amp;c=' . $extra_img['catid'];
			$extra_img['url'] = construct_image_url($extra_img, 'thumbname');
			$extra_img['albumbitclass'] = $ppg_vars['albumclass'];
			$extra_img['link'] = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $extra_img['imageid'] . $user_sorturl;
			$templater = vB_Template::create('adv_gallery_imgbit_simple');
			$templater->register('image', $extra_img);
			$ppg_vars['extra_imgs'] .= $templater->render();
		}
	}
	else
	{
		$ppg_vars['extra_imgs'] = $vbphrase['n_a'];
	}
	$db->free_result($getrand);
	unset($extra_img);
}


// do title here so we can use pagetitle in social bookmarks
$ppg_vars['gallery_titletag'] = $image['title'] . ' - ' . $ppg_options['gallery_title'];

/* ############### Build Social Bookmark Links ############ */
// no need to check permissions because if someone cannot view image, he doesnt get this far.

$show['social_bookmarks'] = false;

if($ppg_options['gallery_socialbookmarks'])
{
	// switch social bookmarks on if needed and possible
	$vbulletin->options['socialbookmarks'] = ($ppg_options['gallery_socialbookmarks'] AND is_array($vbulletin->bookmarksitecache) AND !empty($vbulletin->bookmarksitecache)) ? true : false;
	$ppg_options['internal_socialbookmarks'] = ($ppg_options['gallery_show_facebook'] OR $ppg_options['gallery_show_twitter']) ? true :false;
	$show['social_bookmarks'] = ($ppg_options['internal_socialbookmarks'] OR $vbulletin->options['socialbookmarks']) ? true : false ;
}


if ($show['social_bookmarks'])
{
	$show['twitter'] = $ppg_options['gallery_show_twitter'];
	$show['facebook'] = $ppg_options['gallery_show_facebook'];
	// we optimize if we show facebook link
	$ppg_options['facebook_opt'] = ($show['facebook'])? true : false;
	$bookmarksite = array();
	$ppg_vars['gal_bookmarks'] = '';
	if($show['facebook'])
	{
		$show['galicons'] = true;
		$bookmarksite['iconpath'] = 'images/sb_icons/facebook.png';
		$bookmarksite['jslink'] = 'onclick="social_share(\'fb\');return false;"';
		$bookmarksite['title'] = 'Facebook';
		$bookmarksite['link'] = '#';
		$templater = vB_Template::create('adv_gallery_bookmarks');
		$templater->register('bookmarksite', $bookmarksite);
		$ppg_vars['gal_bookmarks'] .= $templater->render();
	}
	if($show['twitter'])
	{
		$show['galicons'] = true;
		// todo add tiny url in acp
		$bookmarksite['iconpath'] = 'images/sb_icons/twitter.png';
		$bookmarksite['jslink'] = 'onclick="social_share(\'tw\');return false;"';
		$bookmarksite['title'] = 'Twitter';
		$bookmarksite['link'] = '#';
		$templater = vB_Template::create('adv_gallery_bookmarks');
		$templater->register('bookmarksite', $bookmarksite);
		$ppg_vars['gal_bookmarks'] .= $templater->render();

	}	
	$show['galicons'] = false;
	foreach($vbulletin->bookmarksitecache AS $bookmarksite)
	{
		// we strip facebook and twitter as they have been added above
		if(($show['twitter'] AND strpos(strtolower($bookmarksite['url']),'twitter') !== false) OR ($show['facebook'] AND strpos(strtolower($bookmarksite['url']),'facebook') !== false))
		{
			continue;
		}
		$bookmarksite['link'] = str_replace(
			array('{URL}', '{TITLE}'),
			array(urlencode($ppg_options['gallery_url'] . '/showimage.php?i=' . $imageid), urlencode($ppg_vars['gallery_titletag'])),
			$bookmarksite['url']
		);
		$templater = vB_Template::create('adv_gallery_bookmarks');
		$templater->register('bookmarksite', $bookmarksite);
		$ppg_vars['gal_bookmarks'] .= $templater->render();
	}

}

$show['code_links'] = false;
if($ppg_options['gallery_imagelinkcode'] OR $ppg_options['gallery_imagebbcode'] OR $ppg_options['gallery_imagetagcode'])
{
	$show['code_links'] = true;
	$ppg_vars['gallery_imagelinkcode'] = $ppg_options['gallery_imagelinkcode'];
	$ppg_vars['gallery_imagebbcode'] = $ppg_options['gallery_imagebbcode'];
	$ppg_vars['gallery_imagetagcode'] = $ppg_options['gallery_imagetagcode'];
}


if (!intval($catid))
{
	$catnavarray = construct_dir_navbits($categorycache["$image[catid]"]['parentlist']);
	if ($categorycache["$image[catid]"]['membercat'])
	{
		$catnavarray['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$image[catid]&amp;userid=$image[userid]"] = construct_phrase($vbphrase['usernames_images'], $image['username'], iif(substr($image['username'], -1) != 's', $vbphrase['plural_s'])) . ' ('.$post['ppicount'].')';
	}

	foreach ($catnavarray AS $link => $navtext)
	{
		$catnavbits .= iif($gt, '&rsaquo;') . ' <a href="' . $link . '">' . $navtext . '</a> ';
		$gt = 1;
	}
}
$ppg_vars['catnavbits'] = $catnavbits;
$ppg_vars['gallery_allowreplies'] = $ppg_options['gallery_allowreplies'];
$ppg_vars['gallery_url'] = $ppg_options['gallery_url'];
// #####################################################################
// ################# Side bar (beside comments and desc)
// #####################################################################
$show['sidebar'] = false;

//$ppg_options['gallery_showimage_sidebar'] = 1;
//$ppg_options['gallery_showimage_sidebarposition'] = 1;

$ppg_vars['showimage_sidebarposition'] = $ppg_options['gallery_showimage_sidebarposition'];

if($vbulletin->stylevars['left']['string'] == 'right' AND $ppg_options['gallery_showimage_sidebar_corr'])
{
	$ppg_vars['showimage_sidebarposition'] = ($ppg_vars['showimage_sidebarposition'] == 1) ? 0 :1;
}

$ppg_vars['showimage_sidebar_anim'] = $ppg_options['gallery_showimage_sidebar_anim'];

$ppg_vars['gallery_showuserratings'] = $ppg_options['gallery_showuserratings'];

if ($ppg_options['gallery_showimage_sidebar'])
{

		$ppg_vars['imageid'] = $image['imageid'];
		$ppg_vars['imageuserid'] = $image['userid'];
		$ppg_vars['imgusername'] = $image['username'];
		$ppg_vars['views'] = $image['views'];

		$templater = vB_Template::create('adv_gallery_showimage_sidebar');
		$templater->register('ppg_vars', $ppg_vars);
		$templater->register('exifrows', $exifrows);
		$templater->register('image', $image);
		$sidebar = $templater->render();


	if ($sidebar)
	{
		$show['sidebar'] = true;
	}
}

// ################# Sidebar /end #########################################


$ppg_options['nav_gallery_url']	  =  $ppg_options['gallery_url'] . '/index.php' .  $vbulletin->session->vars['sessionurl_q'];
$navbits["$ppg_options[nav_gallery_url]"] = $vbphrase['gallery'];
switch($catid)
{
	case 'favorites':
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "do=favorites"] = $vbphrase['my_favorites'];
		if($_REQUEST['u'] AND !empty($_REQUEST['u']))
		{
			$jumptitle = $vbphrase['favorites'];
		}
		else
		{
			$jumptitle = $vbphrase['my_favorites'];
		}
		break;

	case 'newimages':
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "do=newimages"] = $vbphrase['whats_new'];
		$jumptitle = $vbphrase['whats_new'];
		break;

	case 'popimages':
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "do=popimages"] = $vbphrase['whats_popular'];
		$jumptitle = $vbphrase['whats_popular'];
		break;

	case 'subscriptions':
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "do=subscriptions"] = $vbphrase['my_subscriptions'];
		$jumptitle = $vbphrase['my_subscriptions'];
		break;

	case 'searchresults':
		$navbits["search.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchresults&amp;searchid=$searchid"] = $vbphrase['search_results'];
		$jumptitle = $vbphrase['search'];
		break;

	case 'member':
		$jumptitle = construct_phrase($vbphrase['usernames_images'], $image['username'], $plurals);
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "do=member&amp;imageuser=$image[userid]"] = $jumptitle;

		break;

	default:
		$navbits = construct_dir_navbits($categorycache["$image[catid]"]['parentlist']);
		$jumptitle = $catinfo['title'];
		if ($categorycache["$image[catid]"]['membercat'])
		{
			if($ppg_options['gallery_use_plurals_s'])
			{
				$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$image[catid]&amp;userid=$image[userid]"] = construct_phrase($vbphrase['usernames_images'], $image['username'], iif(substr($image['username'], -1) != 's', $vbphrase['plural_s']));
			}
			else
			{
				$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$image[catid]&amp;userid=$image[userid]"] = construct_phrase($vbphrase['usernames_images'], $image['username'], $vbphrase['plural_s']);
			}
		}
	}

if ($ppg_options['gallery_showcatdesc'])
{
	require_once(DIR . '/includes/functions_wysiwyg.php');
	$catinfo['description'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($catinfo['description']));
}

$navbits[''] = $image['title'];
$navbits = construct_navbits($navbits);

($hook = vBulletinHook::fetch_hook('ppgal_showimage_complete')) ? eval($hook) : false;

$navbar = render_navbar_template($navbits);

/* ### Add announcement if active */
if($ppgal_announcement)
{
	$navbar = $navbar . $ppgal_announcement;
}

if (!isset($catid))
{
	$catid = $image['catid'];
}

/* ##############  4.0 Category Jump ################################# */
if($ppg_options['gallery_enablecatjump'])
{

	$navpopup = array(
		'id'    => 'bi_navpopup',
		'title' => $jumptitle,
		'link'  => 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $catid
	);
	$categoryjump =  print_galquick_jump($navpopup);
}
/* ##############  /4.0 Category Jump ################################# */

// ####### meta tags  
// this is not final.. dont forget to add fields..
// the final will be ready in couple of weeks
$metakeyw = $image['kw_meta'] = '';
if($image['keywords_meta'] AND !empty($image['keywords_meta']))
{
	$image['kw_meta'] = implode(",", $image['keywords_meta']);
	$image['kw_meta'] .= ',';
}




$metakeyw .= $image['kw_meta'] .  $image['title'] . ' ' . $image['description'] . ' ' . $catinfo['title'] . ' ' . $catinfo['description'] . ' ' . $tmp_vars['add_keywords'];
$metadesc = $image['title'] .': ' . $image['description'] . '. ' . $catinfo['title'] . ' - ' . $catinfo['description'] . ' - ' . $tmp_vars['add_desc'];
unset($tmp_vars);
if($ppg_options['facebook_opt'])
{
	// needed before construct metatags!!!
	$thumburl = $image['thumbnail'];
	$thumbtitle = $image['title'];
}
$headinclude = construct_metatags($headinclude, $metakeyw, $metadesc);

$ppg_vars['prevurl'] = $prevurl;
$ppg_vars['nexturl'] = $nexturl;

$ppg_vars['gallery_allowfav'] = $ppg_options['gallery_allowfav'];
$ppg_vars['gallery_allowsubscribe'] = $ppg_options['gallery_allowsubscribe'];
$ppg_vars['gallery_originalwindow'] = $ppg_options['gallery_originalwindow'];
$ppg_vars['original'] = $original;
$ppg_vars['catnavbits'] = $catnavbits;

// goes to acp!!!!
$show['inline_links'] =true;
$show['description'] = false;

if($pagenav)
{
	//pagenav graphs are hardcoded.. will be fixed in vbulletin not before 6 months (says vbulletin)
	$pagenav = str_replace('"images/','"' . $vbulletin->options['bburl'] . '/images/', $pagenav);
}

$templater = vB_Template::create('ADV_GALLERY_SHOWIMAGE');
	$templater->register_page_templates();
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('navbar', $navbar);
	$templater->register('imagecode', $imagecode);
	$templater->register('image', $image);
	$templater->register('catid', $catid);
	$templater->register('adv_sorturl', $adv_sorturl);
	$templater->register('imageuser', $imageuser);
	$templater->register('orderby', $orderby);
	$templater->register('direction', $direction);
	$templater->register('searchid', $searchid);
	$templater->register('cutoffdate', $cutoffdate);
	$templater->register('userid', $userid);
	$templater->register('perpage', $perpage);
	$templater->register('pagenumber', $pagenumber);
	$templater->register('filmstripthumbs', $filmstripthumbs);
	$templater->register('customfieldbits', $customfieldbits);
	$templater->register('categoryjump', $categoryjump);
	$templater->register('keyword', $keyword);
	$templater->register('imageuserinfo', $imageuserinfo);
// tests for message area
	$templater->register('postbit', $postbit);
	$templater->register('messagearea', $messagearea);
	$templater->register('sidebar', $sidebar);
	$templater->register('pagenav', $pagenav);
	print_output($templater->render());
?>