<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: search.php                                                       ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################

define('THIS_SCRIPT', 'gallery_search');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('search');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
		'ADV_GALLERY_SEARCH',
		'adv_gallery_search_custombits',
		'ADV_GALLERY_RESULTS',
		'adv_gallery_imagebit',
		'adv_gallery_search_sidebar',
		'humanverify_question',
		'humanverify_image',
		'humanverify_recaptcha'

);

// pre-cache templates used by specific actions
$actiontemplates = array();


// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$_REQUEST['username'] = $_REQUEST['user_name'];

if ($_REQUEST['do'] == 'searchresults')
{
	$from_forumsearch = $vbulletin->input->clean_gpc('r', 'f', TYPE_INT);
	if($from_forumsearch == 'f')
	{
		if(isset($_REQUEST['q']) OR isset($_REQUEST['u']))
		{
			$_REQUEST['string'] = $_REQUEST['q'];
			$_REQUEST['username'] = $_REQUEST['u'];
			$_REQUEST['exactusername'] = $_REQUEST['e'];
			$_REQUEST['quicksearch'] = 1;
			$_REQUEST['catids'] = array(0);
		}
	}
}
if (!isset($_REQUEST['do']) OR !$_REQUEST['do'])
{
	$_REQUEST['do'] = 'search';
}

if (!$galleryperms['cansearchimages'])
{
	print_no_permission();
}

($hook = vBulletinHook::fetch_hook('ppgal_search_start')) ? eval($hook) : false;

if($_REQUEST['do'] == 'searchresults')
{
	$errors = array();
	if (fetch_require_hvcheck('search'))
	{
		$humanverify = $vbulletin->input->clean_gpc('p', 'humanverify', TYPE_ARRAY);
		require_once(DIR . '/includes/class_humanverify.php');
		$verify =& vB_HumanVerify::fetch_library($vbulletin);
		if (!$verify->verify_token($humanverify))
		{
			$errors[] = $verify->fetch_error();
		}
	}

	if($_REQUEST['searchid'])
	{
		$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);
		if (!empty($errors))
		{
			$_REQUEST['do'] = 'search';
		}
		else
		{
			$vbulletin->url = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=searchresults&amp;searchid=' . $searchid;
			eval(print_standard_redirect('search'));
		}
	}		 

	/* Check for missing data / we check again later.. but we want output on search page so we do it first here */

	$string = $vbulletin->input->clean_gpc('r', 'string', TYPE_NOHTML);
	$username = $vbulletin->input->clean_gpc('r', 'username', TYPE_NOHTML);
	$exactusername = $vbulletin->input->clean_gpc('r', 'exactusername', TYPE_INT);

	//print "<pre>";print_r($_POST); exit;
	if (!$string AND !$username AND (!$_REQUEST['tsearch'] AND !$_REQUEST['searchid']))
	{
		$errors[] = 'searchspecifyterms';
	}
	else if (!$exactusername AND vbstrlen($username) < 3 AND vbstrlen($username) > 0)
	{
		$errors[] = 'searchnametooshort';
	}

	// we output errors
	if (!empty($errors))
	{
	
		$show['errors'] = true;
		$_REQUEST['do'] = 'search';
	}
	else
	{
		$show['errors'] = false;
	}
}







// ############################### Search results ###############################
if ($_REQUEST['do'] == 'searchresults')
{
	require_once(DIR . '/includes/functions_search.php');
	require_once(DIR . '/includes/functions_misc.php');

	($hook = vBulletinHook::fetch_hook('ppgal_search_results')) ? eval($hook) : false;

	$catids = $vbulletin->input->clean_gpc('r', 'catids', TYPE_ARRAY_STR);
    $cfields = $vbulletin->input->clean_gpc('r', 'cfields', TYPE_ARRAY_STR);
    $fields = $vbulletin->input->clean_gpc('r', 'fields', TYPE_ARRAY_STR);
    $dateline = $vbulletin->input->clean_gpc('r', 'dateline', TYPE_INT);
	$string = $vbulletin->input->clean_gpc('r', 'string', TYPE_NOHTML);
	$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
	$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
	$subcats = $vbulletin->input->clean_gpc('r', 'subcats', TYPE_INT);
	$username = $vbulletin->input->clean_gpc('r', 'username', TYPE_NOHTML);
	$exactusername = $vbulletin->input->clean_gpc('r', 'exactusername', TYPE_INT);
	$quicksearch = $vbulletin->input->clean_gpc('r', 'quicksearch', TYPE_INT);

	$condor = $vbulletin->input->clean_gpc('r', 'condor', TYPE_INT);
	$tsearch = $vbulletin->input->clean_gpc('r', 'tsearch', TYPE_INT);
	$ts = $vbulletin->input->clean_gpc('r', 'ts', TYPE_NOHTML);
    $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);
	$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);



// #############################################################################
	// start search timer
	$starttimecounter = microtime();

    // check for flood search
	/*
    if ($vbulletin->options['searchfloodtime'])
	{
		if ($checksearch = $db->query_first("SELECT dateline FROM " . TABLE_PREFIX . "ppgal_search WHERE userid = '" . $vbulletin->userinfo['userid'] . "' AND dateline > " . (TIMENOW - $vbulletin->options['searchfloodtime']) . ""))
		{
			standard_error(fetch_error('searchfloodcheck', $vbulletin->options['searchfloodtime'], ($vbulletin->options['searchfloodtime'] - (TIMENOW - $checksearch['dateline']))));
		}
	}
	*/
	$flood = true;
	//if we don't have a search limit then skip check
	if ($vbulletin->options['searchfloodtime'] == 0)
	{
		$flood = false;

	}
	else if (($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
	{
		$flood = false;
	}
	else
	{

		if($vbulletin->userinfo['userid'])
		{
			$userfilter = "userid = " . intval($vbulletin->userinfo['userid']);
		}
		else
		{
			$userfilter =  "ipaddress ='" . $db->escape_string(IPADDRESS) . "'";
			
		}
		$checksearch = $db->query_first("
			SELECT dateline 
			FROM " . TABLE_PREFIX . "ppgal_search 
			WHERE $userfilter 
			AND dateline > " . (TIMENOW - $vbulletin->options['searchfloodtime']) . "
			LIMIT 1
			");

		if($checksearch)
		{

			standard_error(fetch_error('searchfloodcheck', $vbulletin->options['searchfloodtime'], ($vbulletin->options['searchfloodtime'] - (TIMENOW - $checksearch['dateline']))));
		}

	}



	if(intval($tsearch) == 1)
	{
		$quicksearch = true;
		$tagsearch = false;
		$string = urldecode($ts);
		$catid = '0';
		$no_update_tags = true;
		
	}
	else if(intval($tsearch) == 2)
	{
		$quicksearch = false;
		$tagsearch = true;
		$string = urldecode($ts);
		$catid = '0';
		$no_update_tags = true;
	}
    
	if($tagsearch)
	{
		$fields = array('keywords');
		if($catid == '0'){$catids = 0;}
		$subcats = 1;
	}
 
    else if($quicksearch)
	{
       // Quick search from navbar and within a category
		$fields = array('title', 'keywords', 'description');
	    // check if in a category
	    if($catid == '0'){$catids = 0;}
	    $subcats = 1;
    }

    // Check for missing data
    if (!$string AND !$username)
    {
		standard_error(fetch_error('searchspecifyterms'));
	}

	if (empty($fields) AND empty($cfields))
	{
		standard_error(fetch_error('adv_gallery_error_no_search_fields'));
	}

	if (!empty($fields))
	{
		$sfields = $fields;
	}

	if (!empty($cfields))
	{
		$sfields = array_merge((array)$sfields, (array)$cfields);
		$cfjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_customfields_entries AS customfields ON (images.imageid = customfields.imgid)';
	}

	$fields = implode(',', $sfields);

	if ($string)
	{
		$temp_search = str_replace(array('%','*',' and ',' not ', ' or '), ' ', $string);
		$string = str_replace('  ', ' ', $temp_search);
		$searchstring = explode(' ', $string);


		$condition = '(';
		$strcount = 0;
		foreach ($searchstring AS $sstring)
		{
			$concount = 0;
			$strcount++;
			if ($strcount > 1)
			{

				if($condor == 1)
				{
					$condition .= ') OR ';
				}
				else
				{
					$condition .= ') AND ';
				}
				$condition .= '(';
			}



			foreach ($sfields AS $value)
			{
				$concount++;
				if ($concount > 1)
				{
					$condition .= ' OR ';
				}

				if ($value == 'title')
				{
					$value = 'images.title';
				}

				if ($_REQUEST['matchwholeword'])
				{
					$condition .= "$value LIKE '% " . sanitize_word_for_sql($sstring) . " %'";
				}
				else
				{
					$condition .= "$value LIKE '%" . sanitize_word_for_sql($sstring) . "%'";
				}
			}

			

		}
		$condition .= ') AND ';
	}

	if (in_array('pagetext', $sfields))
	{
		$postjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_posts AS posts ON (posts.imageid = images.imageid)';
	}

	if ($username)
	{
		if (!$exactusername AND vbstrlen($username) < 3)
		{
			standard_error(fetch_error('searchnametooshort'));
		}

		$searchusername = sanitize_word_for_sql($username);

		$getuserids = $db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE username " . iif($exactusername, '= \'' . $searchusername . '\'', 'LIKE \'%' . $searchusername . '%\''));
		if ($db->num_rows($getuserids))
		{
			$users = array();
			while ($userinfo = $vbulletin->db->fetch_array($getuserids))
			{
				$users["$userinfo[userid]"] = $userinfo['username'];
			}
	
			$userids = implode(',', array_keys($users));
			if (implode(',', $sfields) == 'pagetext')
        		{
            			$condition .= ' posts.userid IN(' . $userids . ') AND ';
        		}
			else
			{
            			$condition .= ' (images.userid IN(' . $userids . ')' . iif (in_array('pagetext', $sfields), ' OR posts.userid IN(' . $userids . ')') . ') AND ';
        		} 
		}
		else
		{

			//eval(standard_error(fetch_error('invalidid', $vbulletin->options['bburl'] . '/' . $vbulletin->options['contactuslink']  .  $vbulletin->session->vars['sessionurl_q'], $vbphrase['user'])));
			//eval(standard_error(fetch_error('invalidid', $vbphrase['user'], $vbulletin->options['bburl'] . '/' . $vbulletin->options['contactuslink']  .  $vbulletin->session->vars['sessionurl_q'])));

			$errors[] = 'username_no_exist';
			//$_REQUEST['username'] = '' ;

			$_REQUEST['do'] = 'search' ;
			//print "errror"; print_r($errors);exit;
		}

	}
	if(empty($errors))
	{
		if ($dateline)
		{
			if ($_POST['new_old'] == 'older')
			{
				$arr = '<=';
			}
			else
			{
				$arr = '>=';
			}

			if ($dateline == 'lastvisit')
			{
				$condition .= ' images.dateline ' . $arr . ' ' . $vbulletin->userinfo['lastvisit'] . ' AND ';
			}
			else
			{
				$cutoffdate = time() - ($dateline * 86400);
				$condition .= ' images.dateline ' . $arr . ' ' . $cutoffdate . ' AND ';
			}
			unset($arr);
		}
		if ($_POST['replycount'] OR $_POST['leastmost'] == 'most')
		{
			if ($_POST['leastmost'] == 'least')
			{
				$arr = '>=';
			}
			else
			{
				$arr = '<=';
			}
			$condition .= ' posts ' . $arr . ' ' . intval($_POST['replycount']) . ' AND ';
		}

		if (empty($catids) AND $catids != 0)
		{
			standard_error(fetch_error('adv_gallery_search_nocat'));
		}

		$categoryperms = fetch_category_perms(); // check if needed?????
		if ($privatecatids = fetch_private_categories())
		{
			$condition .= ' images.catid NOT IN(' . $privatecatids . ') AND ';
		}

		if (!empty($catids) AND in_array('favorites', $catids))
		{
			$searchquery = "
					SELECT images.imageid
					FROM " . TABLE_PREFIX . "ppgal_favorites AS favorites
					LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid)
					$postjoin
					$cfjoin
					WHERE $condition valid = 1
			";
		}
		else
		{
			
			if (!empty($catids) AND $catids != array(0))
			{
				if ($subcats)
				{
					$newcatinfo = array();
					foreach ($catids AS $scats)
					{
						$newcatinfo[] = implode(',', fetch_category_children($scats));
					}
					$cids = implode(',', $newcatinfo);
				}
				else
				{
					$cids = implode(',', $catids);
				}

				$condition .= " images.catid IN($cids) AND ";
			}

			$searchquery = "
				SELECT DISTINCT images.imageid
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				$postjoin
				$cfjoin
				WHERE $condition valid = 1
			";
	}

	// Get Images
	$getimages = $db->query_read($searchquery);

	if ($debug)
	{
		$gallerynav .= '<table width="100%"><tr><td>' . $searchquery . '</td></tr></table><br />';
	}

	if ($db->num_rows($getimages))
	{
		$imagecount = 0;
		while ($images = $vbulletin->db->fetch_array($getimages))
		{
			$imagecount++;
			$imageidarray[] = $images['imageid'];
		}

		$countimages['count'] = $imagecount;

		
		unset($images);

	}
	else
	{
	
		//eval(standard_error(fetch_error('searchnoresults', '')));
		//eval(standard_error(fetch_error('searchnoresults', '')));
		//print $vbphrase['searchnoresults'];exit;
		$errors[] = 'searchnoresults_gal';
			//	$errors[] = 'searchnoresults';
	//	$_REQUEST['username'] = '' ;
	//	$_REQUEST['string'] = '' ;
		$_REQUEST['do'] = 'search' ;


		$show['errors'] = true;



				$errorlist = '';
		foreach(array_map('fetch_error', $errors) AS $error)
		{
			$errorlist .= "<li>$error</li>";
		}
		

	}
	$db->free_result($getimages);
	


	if (!empty($imageidarray))
	{
		$imagearray = implode(',', $imageidarray);

		if(is_array($searchstring) AND !empty($searchstring) AND !$no_update_tags)
		{
			
			foreach ($searchstring as $key => $value) 
			{
				$strlen = vbstrlen($value);
				if($strlen >2 AND $strlen < 50)
				{

					$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_searchtags (stag, timestamp) VALUES ('" . $db->escape_string($value) . "', '" . TIMENOW . "')");				
				}
			}
		}

		if (!empty($users))
		{
			$usernames = serialize($users);
		} 

		$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_search (string, username, sfields, catids, dateline, userid, ipaddress, imageids, orderby, direction, wholeword, numresults, searchtime) VALUES ('" . $db->escape_string($string) . "', '" . $db->escape_string($usernames) . "', '$fields', '$cids', '" . TIMENOW . "', '" . $vbulletin->userinfo['userid'] . "', '" . $db->escape_string(IPADDRESS) . "', '$imagearray', '" . $db->escape_string($orderby) . "', '" . $db->escape_string($direction) . "', '$_REQUEST[matchwholeword]', '$imagecount', '" .  vb_number_format(fetch_microtime_difference($starttimecounter), 3) . "')");

		$searchid = $db->insert_id();

		$vbulletin->url = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=searchresults&amp;searchid=' . $searchid;
		eval(print_standard_redirect('search'));
	}
	else
	{
	

	}

	}

}
if(!empty($errors) AND $errorlist == '')
{
	$show['errors'] = true;
	foreach(array_map('fetch_error', $errors) AS $error)
	{
		$errorlist .= "<li>$error</li>";
	}	
}

// ############################### Main search page ###############################
if ($_REQUEST['do'] == 'search')
{
	if ($ppg_options['gallery_allowreplies'])
	{
		$counter = 1;
	}
	else
	{
		$counter = 0;
	}

	$customfields = $db->query_read("
			SELECT fieldid, title
			FROM " . TABLE_PREFIX . "ppgal_customfields
			WHERE searchable = 1
			ORDER BY displayorder
	");
	while ($field = $vbulletin->db->fetch_array($customfields))
	{
		$counter++;
		if ($counter == 2)
		{
			//$customfieldboxes .= '</tr><tr>';
			$counter = 0;
		}
		//eval('$customfieldboxes .= "' . fetch_template('adv_gallery_search_custombits') . '";');

		$templater = vB_Template::create('adv_gallery_search_custombits');
		$templater->register('field', $field);
		$customfieldboxes .= $templater->render();
	}

	if (!$catid)
	{
		$selected[0] = 'selected="selected"';
	}

	$categorylist = print_cat_select($catid, 'search');

	
// image verification here because we need active status for cloud and last 10 searches
	if (fetch_require_hvcheck('search'))
	{

		require_once(DIR . '/includes/class_humanverify.php');
		$verification =& vB_HumanVerify::fetch_library($vbulletin);
		$human_verify = $verification->output_token();
		$human_verify = str_replace(
			array(
				'"clientscript',
				'"image.php'
			),
			array(
				'"' . $vbulletin->options['bburl'] . '/clientscript',
				'"' . $vbulletin->options['bburl'] . '/image.php'
			),
			$human_verify
		);
	}
	else
	{
		// needed for cloud
		$human_verify = '';
	}

	// #############################################################################
	// sidebar
	$show['sidebar'] = true;

	$ppg_options['last_searches'] = 10;



	$vbulletin->options['search_tag_cutoff'] = 1;
	$vbulletin->options['search_tag_max'] = 50;


	$ppg_options['cloud_maxsize'] = 180; // max/min font size in %
	$ppg_options['cloud_minsize'] = 80;
	$ppg_options['tagcloud'] = 1;

	if($show['sidebar'])
	{

		$hvc = ($human_verify != '')? ' title="'. htmlspecialchars_uni($vbphrase['sorry_disabled_for_guests']) . '" onclick="return false;" ':'';
		
		$show['tagcloud'] = $ppg_options['tagcloud'];
		// ############################# get search cloud ################################################
		$tagssearch = $db->query_read("SELECT stag AS tag, COUNT(timestamp) AS quantity FROM " . TABLE_PREFIX . "ppgal_searchtags
			GROUP BY stag
			ORDER BY RAND() DESC
			LIMIT 500
				");
		$gal_tag_cloud = '';
		$mytags = array();
		$tagcount = 0;

		while ($stags = $vbulletin->db->fetch_array($tagssearch))
		{
			if($tagcount>$vbulletin->options['search_tag_max'])
			{
				break;
			}
			if($stags['quantity']>$vbulletin->options['search_tag_cutoff'])
			{
				$tagcount++;
				$mytags[$stags['tag']] = $stags['quantity'];
			}
		}
		$db->free_result($tagssearch);
		unset($stags);	
		if($tagcount<1)
		{
			$show['tagcloud'] = false;
		}
		if($show['tagcloud'])
		{
			// change font sizes
			$max_size = $ppg_options['cloud_maxsize']; // max font size in %
			$min_size = $ppg_options['cloud_minsize']; 

			// largest and smallest array values
			$max_qty = max(array_values($mytags));
			$min_qty = min(array_values($mytags));

			// find the range of values
			$spread = $max_qty - $min_qty;
			$spread = ($spread == 0) ? 1 : $spread; // we don't want to divide by zero
			// determine the font-size increment
			// this is the increase per tag quantity (times used)
			$step = ($max_size - $min_size)/($spread);
			// loop through our tag array
			
			foreach ($mytags as $key => $value) {

				 
				$size = $min_size + (($value - $min_qty) * $step);
				$size = ceil($size);
				$gal_tag_cloud .= '<a ' . $hvc . 'href="'.'search.php?'. $vbulletin->session->vars['sessionurl'] . 'do=searchresults&amp;tsearch=1&amp;ts=' . urlencode($key) . '" style="font-size: ' . $size . '%"';
				$key = htmlspecialchars_uni($key);
				$gal_tag_cloud .= ' title="' . $vbphrase['search_for'] . ' ' . $key . '"';
				$gal_tag_cloud .= '>' . $key . '</a> ';
				// space at the end of the link !!!!
			}
			unset($mytags,$key,$value);
		}
// ##################### get last 10 searches ###################
		// get last 10 searchresults
		$thissearch = $db->query_read("SELECT searchid, string,	username, sfields, numresults FROM " . TABLE_PREFIX . "ppgal_search
			ORDER BY dateline DESC
				LIMIT 100
			");
			
		if ($db->affected_rows($thissearch) == 0)
		{
			$lastresults = 'No searches to display...';
		}
		else
		{
			$counter=0;
			$lastresults = '';
			$doubleuserid = array();
			$doublekw = array();
				
			while ($lastsearches = $db->fetch_array($thissearch))
			{ 
				$comma = '';
				if(!empty($lastsearches['string']))
				{
					$searchkeywords = '';
					$lastsearches['keywords'] = explode(' ', $lastsearches['string']);
					$tmpkw = '';
					$comma = '';
					foreach ($lastsearches['keywords'] AS $mykey => $mykeyword)
					{
						if ($mykey > 0)
						{
							$comma = ',';
						}
						$searchkeywords .= "$comma <b>$mykeyword</b>";
						$tmpkw .=  "$comma <b>$mykeyword</b>";
					}
					if(in_array($tmpkw,$doublekw))
					{
						continue;
					}

						$doublekw[] = $tmpkw;
						$search_field = $searchkeywords;
						$search_prefix = $vbphrase['key_words'];
					
				}
				else
				{
					continue;
				}
				$counter++;

				$lastresults .=	'<li><a ' . $hvc . ' href="search.php?' . $vbulletin->session->vars['sessionurl'] . 'do=searchresults&searchid='.intval($lastsearches['searchid']).'">'.$search_field.'</a> ('. $lastsearches['numresults'].')</li>';

				if($counter >= 10)
				{
					//continue;
					break;
				}
			}		
		}		
		unset($lastsearches);
			
		$db->free_result($thissearch);

		unset($doubleuserid, $doublekw);
		unset($tmpkw);

		$searchcounter = $counter;

			

		// amount of  last searches
	
		$ppg_options['search_sidebarposition'] = 1;

		$ppg_vars['searches'] = $ppg_options['last_searches'];
		if($vbulletin->stylevars['textdirection']['string'][0] == 'l')
		{
			$ppg_vars['search_sidebarposition'] = $ppg_options['search_sidebarposition'] ;
		}
		else if($vbulletin->stylevars['textdirection']['string'][0] == 'r')
		{
			$ppg_vars['search_sidebarposition'] = ($ppg_options['search_sidebarposition'] == 1)? 0 : 1;
		}
		$show['artsearch'] = $vbulletin->products['vbcms'];
		$show['blogsearch'] = $vbulletin->products['vbblog'];
		$templater = vB_Template::create('adv_gallery_search_sidebar');
		$templater->register('ppg_vars', $ppg_vars);
		$templater->register('gal_tag_cloud', $gal_tag_cloud);
		$templater->register('adv_sorturl', $adv_sorturl);
		$templater->register('lastresults', $lastresults);

		$templater->register('image', $image);
		$sidebar = $templater->render();
	}





	$navbits[$ppg_options['gallery_url'] . '/index.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['gallery'];
	
	$navbits[''] = $vbphrase['search'];
	$navbits = construct_navbits($navbits);

    ($hook = vBulletinHook::fetch_hook('ppgal_search_complete')) ? eval($hook) : false;

	
		
	
	$string2 = $vbulletin->input->clean_gpc('r', 'string', TYPE_NOHTML);
	$username2 = $vbulletin->input->clean_gpc('r', 'username', TYPE_NOHTML);
	$keyw_search = urldecode($string2);
	$user_search = urldecode($username2);
	if(empty($keyw_search))
	{
		
	}



	$navbar = render_navbar_template($navbits);

	/* ### Add announcement if active */
	if($ppgal_announcement)
	{
		$navbar = $navbar . $ppgal_announcement;
	}
	$headinclude = construct_metatags($headinclude);
	$headinclude = NOROBOTS . "\n" . $headinclude;


// #############################################################################
// output page

	$ppg_vars['gallery_title'] = $ppg_options['gallery_title'];
	$ppg_vars['gallery_allowreplies'] = $ppg_options['gallery_allowreplies'];


	$templater = vB_Template::create('ADV_GALLERY_SEARCH');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('selected', $selected);
	$templater->register('categorylist', $categorylist);
	$templater->register('sidebar', $sidebar);
	$templater->register('human_verify', $human_verify);
	$templater->register('keyw_search', $keyw_search);
	$templater->register('user_search', $user_search);
	$templater->register('errorlist', $errorlist);
	$templater->register('customfieldboxes', $customfieldboxes);

	print_output($templater->render());


}

?>