<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: newreply.php                                                     ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'gallery_newreply');
define('CSRF_PROTECTION', true);
if (isset($_POST['fromquickreply']))
{	// Don't update Who's Online for Quick Comments since it will get stuck on that until the user goes somewhere else
	define('LOCATION_BYPASS', 1);
}

// ################### PRE-CACHE TEMPLATES AND DATA ######################

// get special phrase groups
$phrasegroups = array(
	'posting',
	'threadmanage',
	'album'
);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache',
	'iconcache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'ADV_GALLERY_REPLY',
	'adv_gallery_conformation',
	'newreply_reviewbit',
	'adv_gallery_bbcode_video',
	'bbcode_video'
);

// pre-cache templates used by specific actions
// $actiontemplates = array();
$actiontemplates = array(
		'newpost_usernamecode',
		'reportitem',
		'picturecomment_editor'
);

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');
require_once(DIR . '/includes/functions_newpost.php');
require_once(DIR . '/includes/functions_misc.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

($hook = vBulletinHook::fetch_hook('ppgal_newreply_start')) ? eval($hook) : false;
/*	resize video to 50%; done in template... needed because we have sidebar... original size would break layout on fixed width layout
	adjust template if vbulletin adds new providers... rem out here and in showimage to have full size video
*/
$vbulletin->templatecache['bbcode_video'] = $vbulletin->templatecache['adv_gallery_bbcode_video'];

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'reply';
}

// ############# Function To Rate Images #####################
function rate_image($vote, $imageid, $redirpage = '')
{
	global $db, $vbulletin, $newpostid, $galleryperms, $imageinfo, $adv_sorturl;

	// got to put this one in ACP

	if (empty($imageinfo))
	{
		$imageinfo = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");
	}

	check_image_id($imageinfo['imageid']);

	if (empty($categoryperms))
	{
		$categoryperms = fetch_category_perms($imageinfo['catid']);
	}

	if (!$categoryperms['canrateimages'])
	{
		print_no_permission();
	}

	if ($vote < 1 or $vote > 10)
	{
		standard_error(fetch_error('invalidvote'));
	}

	switch ($redirpage)
	{
		//TODO: Add newpostid to input
		case 'post':
			$redirurl = 'showimage.php?' . $vbulletin->session->vars['sessionurl']  . '&amp;postid=' . $newpostid . '#post' . $newpostid . $adv_sorturl;
			break;
		default:
			$redirurl = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid . $adv_sorturl;
	}

	// Check For cookie Duplicates

	if (fetch_bbarray_cookie('rating_imageid', $imageid))
	{
		if(!$vbulletin->userinfo['userid'])
		{
			standard_error(fetch_error('adv_gallery_imageratevoted'));
		}
		else if(!$vbulletin->options['votechange'])
		{
			standard_error(fetch_error('adv_gallery_imageratevoted'));
		}
	}
	// no cookie so we check manually
	// ATTENTION WE DO NOT ALLOW VOTECHANGING FOR GUESTS!!!! (even if enabled in vbulletin)
	// because i could rate as user.. and then logout and vote again!!!!
	if ($rating = $db->query_first("SELECT rateid, rating FROM " . TABLE_PREFIX . "ppgal_rate WHERE imageid = '$imageid' AND " . iif($vbulletin->userinfo['userid'], "userid = '" . $vbulletin->userinfo['userid'] . "'", "ipaddress = '" . $db->escape_string(IPADDRESS) . "'") . ""))
	{
		if($vbulletin->userinfo['userid'] AND $vbulletin->options['votechange'])
		{
			if ($vote != $rating['rating'])
			{
				$newvote = $vote - $rating['rating'];
				$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_rate SET dateline = '" . TIMENOW . "', rating = '$vote' WHERE rateid = '$rating[rateid]'");
				$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_images SET votetotal = votetotal + $newvote WHERE imageid = '$imageid'");
			}
			$vbulletin->url = $redirurl;
			eval(print_standard_redirect('adv_gallery_imagerate_update'));
		}
		else
		{
			standard_error(fetch_error('adv_gallery_imageratevoted'));
		}
	}
	else
	{
		// No duplicates, so insert the rating
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_rate (dateline, imageid, rating, userid, ipaddress) VALUES ('" . TIMENOW . "', '$imageid', '$vote', '" . $vbulletin->userinfo['userid'] . "', '" . $db->escape_string(IPADDRESS) . "')");
		$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_images SET votetotal = votetotal + $vote, votenum = votenum + 1 WHERE imageid = '$imageid'");
		set_bbarray_cookie('rating_imageid', $imageid, $vote, 1);

		$vbulletin->url = $redirurl;
		eval(print_standard_redirect('redirect_threadrate_add'));
	}
}
$_POST['iconid'] = 0;

$vbulletin->options['showdeficon'] = false;
// ########################## Do Reply to Image #############################
if (in_array($_POST['do'], array('doreply', 'doedit')))
{

($hook = vBulletinHook::fetch_hook('ppgal_do_reply_start')) ? eval($hook) : false;

	$imageid = $vbulletin->input->clean_gpc('p', 'imageid', TYPE_INT);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_INT);
	$postid = $vbulletin->input->clean_gpc('p', 'postid', TYPE_INT);
	$vote = $vbulletin->input->clean_gpc('p', 'vote', TYPE_INT);
	$wysiwyg = $vbulletin->input->clean_gpc('p', 'wysiwyg', TYPE_BOOL);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
	$sorturl = $vbulletin->input->clean_gpc('p', 'sorturl', NO_HTML);
	//$ajax = $vbulletin->input->clean_gpc('p', 'message', TYPE_BOOL);


		

	$ajax_lastpost = $vbulletin->input->clean_gpc('p', 'ajax_lastpost', TYPE_INT);
	
	


	$imageinfo = $db->query_first("
			SELECT imageid, images.title, images.catid, categories.title AS cattitle, options, newpostemail
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			WHERE imageid = '$imageid'
	");



	$categoryperms = fetch_category_perms($imageinfo['catid']);
	$catopts = construct_cat_opts($imageinfo['catid'], $imageinfo['options']);


	if (!$categoryperms['canreplytoimages'] OR !$catopts['open_for_posts'] OR !$catopts['allow_replies'])
	{
		
		print_no_permission();
	}

	$post['title'] = htmlspecialchars_uni(fetch_censored_text($_POST['title']));
	$post['username'] = $username = $vbulletin->input->clean_gpc('p', 'username', TYPE_NOHTML);
//print $post['username']; exit;
  // WYSIWYG
	if ($wysiwyg)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$post['message'] = convert_wysiwyg_html_to_bbcode($message, $imageinfo['allowhtml']);
	}

	// Normal editor
	else
	{
		$post['message'] = $message;
	}
	

	if ($ajax)
	{
		// posting via ajax so we need to handle those %u0000 entries
		$post['message'] = convert_urlencoded_unicode($post['message']);
	}

	// Quote from quickreply
	if ($vbulletin->GPC['quickreply'])
	{
		$postinfo = $db->query_first("SELECT username, title, pagetext FROM " . TABLE_PREFIX . "ppgal_posts WHERE postid = '$postid'");

        $vbulletin->options['quotetitle'] = 0;
		if ($ppg_options['images_quotetitle'] AND !$post['title'])
		{
			$vbulletin->options['quotetitle'] = 1;
		}
		$post['title'] = fetch_quote_title($post['title'], $postinfo['title']);

		$originalposter = fetch_quote_username($postinfo['username']);
		$pagetext = trim(strip_quotes($postinfo['pagetext']));

        ($hook = vBulletinHook::fetch_hook('ppgal_newreply_post_quote')) ? eval($hook) : false;

	//	eval('$quotemessage = "' . fetch_template('newpost_quote', 1, 0) . '";');
		$post['message'] = "$quotemessage $post[message]";
	}

	// Insert title if necessary
	if (!$post['title'] AND $_POST['fromquickreply'] AND $ppg_options['gallery_quotetitle'])
	{
		$vbulletin->options['quotetitle'] = 1;
		$post['title'] = fetch_quote_title($post['title'], $imageinfo['title']);
	}

	// Smilies
	$post['disablesmilies'] = $vbulletin->input->clean_gpc('p', 'disablesmilies');

	$post['enablesmilies'] = 0;
	if (!$post['disablesmilies'])
	{
		$post['enablesmilies'] = 1;
	}

	// Check for errors
	$errors = array();



	$postlength = vbstrlen($post['message']);

	// Check message length
	if (!$post['message'])
	{
		$errors[] = fetch_error('nosubject');
	}

	if ($vbulletin->options['postminchars'] AND $postlength < $vbulletin->options['postminchars'])
	{
		$errors[] = fetch_error('tooshort', $postlength, $vbulletin->options['postminchars']);
	}
	else if ($vbulletin->options['postmaxchars'] AND $postlength > $vbulletin->options['postmaxchars'])
	{
		$errors[] = fetch_error('toolong', $postlength, $vbulletin->options['postmaxchars']);
	}

	// Guest username check
	if (!$vbulletin->userinfo['userid'])
	{
		if (!$post['username'])
		{
			$errors[] = fetch_error('nousername');
		}
		else if (strlen($post['username']) < $vbulletin->options['minuserlength'])
		{
			$errors[] = fetch_error('usernametooshort', $vbulletin->options['minuserlength']);
		}
		else if (strlen($post['username']) > $vbulletin->options['maxuserlength'])
		{
			$errors[] = fetch_error('usernametoolong', $vbulletin->options['maxuserlength']);
		}
		else if ($dupecheck = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . addslashes(htmlspecialchars($post['username'])) . "'"))
		{
			$tmperror = fetch_error('usernametaken', $vbulletin->GPC['username'], $vbulletin->session->vars['sessionurl']);
			$errors[] = str_replace('"login.php', '"' . $vbulletin->options['bburl'] . '/login.php', $tmperror);
		}
		
	}


	// Duplicate post / flood check
	if ($_REQUEST['do'] == 'doreply' AND $vbulletin->userinfo['userid'])
	{
		$lpost = $db->query_first("SELECT postid, title, pagetext, dateline FROM " . TABLE_PREFIX . "ppgal_posts WHERE userid = '" . $vbulletin->userinfo['userid'] . "' ORDER BY dateline DESC LIMIT 1");

		// Have the same post, so just redirect the user
		if ($post['message'] == $lpost['pagetext'] AND $post['title'] == $lpost['title'])
		{
			$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imagei . '&amp;postid=' . $lpost['postid'] . '#post' . $lpost['postid'];
			eval(print_standard_redirect('redirect_postthanks'));
		}

		// Have flooding, so display error
		if ($vbulletin->options['floodchecktime'] AND !$_POST['preview'] AND (TIMENOW - $lpost['dateline']) <= $vbulletin->options['floodchecktime'])
		{
			$errors[] = fetch_error('gallery_postfloodcheck', $vbulletin->options['floodchecktime'], ($vbulletin->options['floodchecktime'] - (TIMENOW - $lpost['dateline'])));
		}
	}

	if ($vbulletin->options['maximages'])
	{
		require_once(DIR . '/includes/class_bbcode_alt.php');
		$bbcode_parser = new vB_BbCodeParser_ImgCheck($vbulletin, fetch_tag_list());

		$imagecount = fetch_character_count($bbcode_parser->parse($post['message'], 'nonforum', $post['enablesmilies'], true), '<img');
		if ($imagecount > $vbulletin->options['maximages'])
		{
			$errors[] = fetch_error('toomanyimages', $imagecount, $vbulletin->options['maximages']);
		}
	}
// check allowed bb code from piccomment as we use the bbcode from vbulletin piccomment

	// no error from qr
		if ($_POST['fromquickreply'] AND $_POST['preview'])
		{
			$errors = array();
		}


//print $post['message'] . '<br /><br /><br /><br />';
		require_once(DIR . '/includes/class_socialmessageparser.php');
		$bbcode_parser = new vB_PictureCommentParser($vbulletin, fetch_tag_list());
		$bbcode_parser->parse($post['message']);
//$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
//$bbcode_parser->parse($post['message']);

//print $post['message'];exit;
		if ($error_num = count($bbcode_parser->errors))
		{
			foreach ($bbcode_parser->errors AS $tag => $error_phrase)
			{
				$errors[] = fetch_error($error_phrase, $tag);
			}
		}



	
	// Errors!

//$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());

//	print "<pre>". $postlength;print_r($_POST); print $post['message']; exit;
	if ($errors)
	{

		$postpreview = construct_errors($errors);
		construct_checkboxes($_POST);
		//$newpost['message'] = htmlspecialchars($post['message']);
		$newpost['message'] = $post['message'];
		$_REQUEST['i'] = $imageid;


		if ($_POST['do'] == 'doedit')
		{
			$_REQUEST['do'] = 'editpost';
		}
		else
		{
			$_REQUEST['do'] = 'reply';
		}
	}

	// Just previewing
	else if ($_POST['preview'])
	{


	$post['message'] = fetch_censored_text($post['message']);



		$newpost['message'] = $post['message'];
		unset($post['iconid']);
		require_once(DIR . '/includes/functions_picturecomment.php');
		/*	get video
			We dont have time to rewrite everything.. so we just parse the video through dataman
		*/
		$dataman =& datamanager_init('PictureComment', $vbulletin, ERRTYPE_ARRAY);
		$dataman->setr('pagetext', $post['message']);
		unset($dataman); // dunno if needed;
		if ($_POST['parseurl'])
		{
			$post['message'] = convert_url_to_bbcode($post['message']);
		}


		$postpreview = process_picture_comment_preview($post);

		construct_checkboxes($_POST);

		$_REQUEST['i'] = $imageid;
		if ($_POST['do'] == 'doedit')
		{
			$_REQUEST['postid'] = $postid;
			$_REQUEST['do'] = 'editpost';
		}
		else
		{
			$_REQUEST['do'] = 'reply';
		}
	}
	else
	{
		// Everything's good, so get ready to insert
		if ($_REQUEST['do'] == 'doreply')
		{
			if ($categoryperms['moderateposts'])
			{
				$visible = 0;
			}
			else
			{
				$visible = 1;
				send_subscribed_posts($imageinfo['imageid']);
			}

			if($vbulletin->userinfo['username'] == $vbphrase['unregistered'])
			{
				$vbulletin->userinfo['username'] = $vbphrase['guest'];
			}

			if ($_POST['parseurl'])
			{
				$post['message'] = convert_url_to_bbcode($post['message']);
			}

//print $db->escape_string(htmlspecialchars_uni($post['message'])); exit;
			// Insert the post
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_posts (imageid, title, pagetext, userid, username, dateline, ipaddress, iconid, allowsmilie, showsignature, visible) VALUES ('$imageid', '" . $db->escape_string($post['title']) . "', '" . $db->escape_string($post['message']) . "', '" . $vbulletin->userinfo['userid'] . "', '" . $db->escape_string($vbulletin->userinfo['username']) . "', '" . time() . "', '" . $db->escape_string(IPADDRESS) . "', '" . intval($_POST['iconid']) . "', '$post[enablesmilies]', '" . intval($_POST['signature']) . "', '$visible')");

			$newpostid = $db->insert_id();

			if (!$visible OR $ppg_options['gallery_newimageemail'] OR $imageinfo['newpostemail'])
			{
				if ($imageinfo['newpostemail'])
				{
					$sendmailto = explode(',', $imageinfo['newpostemail']);
				}

				if (!empty($sendmailto))
				{
					$imageinfo['cattitle'] = stripslashes($imageinfo['cattitle']);
					foreach ($sendmailto AS $email)
					{
						eval(fetch_email_phrases('adv_gallery_newpost'));
						vbmail(trim($email), $subject, $message);
					}
				}
			}

			if ($visible == 1)
			{
				// Update image info
				$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_images SET posts = posts+1, lastpostuserid = '" . $vbulletin->userinfo['userid'] . "', lastpostusername = '" . addslashes($vbulletin->userinfo['username']) . "', lastpostdateline = '" . time() . "' WHERE imageid = '$imageid'");

				// Update category info
				$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_categories SET postcount = postcount+1, lastpostid = '$newpostid', lastpostimagetitle = '" . addslashes($imageinfo['title']) . "', lastpostuserid = '" . $vbulletin->userinfo['userid'] . "', lastpostusername = '" . addslashes($vbulletin->userinfo['username']) . "', lastpostdateline = '" . TIMENOW . "' WHERE catid = '$imageinfo[catid]'");

				// Update user post counts
                $vbulletin->db->query_write("
                        UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_user
                        SET pppcount = pppcount+1, lastpostid= $newpostid, lastposttitle = '" . addslashes($post['title']) . "', lastpostdate = '" . time() . "'
                        WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
                        ");

            }
			// Add vote if necessary
			if ($_REQUEST['vote'] > 0)
			{
				rate_image($vote, $_POST['imageid'], 'post');
			}
		}
		else
		{
			if ($_POST['parseurl'])
			{
				$post['message'] = convert_url_to_bbcode($post['message']);
			}
			// We're editing, so update the post
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_posts SET title = '" . addslashes($post['title']) . "', pagetext = '" . addslashes($post['message']) . "', iconid = '$_POST[iconid]', allowsmilie = '$post[enablesmilies]', showsignature = '$_POST[signature]' WHERE postid = '$_POST[postid]'");
			$newpostid = $vbulletin->input->clean_gpc('p', 'postid', TYPE_INT);
		}

        ($hook = vBulletinHook::fetch_hook('ppgal_newreply_post_complete')) ? eval($hook) : false;

		$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid . construct_adv_sort_url() . '&amp;postid=' . $newpostid . '&amp;anchor=1';

		if ($_POST['do'] == 'doreply')
		{
			eval(print_standard_redirect('redirect_postthanks'));
		}
		else
		{
      			eval(print_standard_redirect('redirect_editthanks'));
		}
	}
}

// ########################## Reply to Image #############################
if (in_array($_REQUEST['do'], array('reply', 'editpost')))
{

	if(($_GET['postid'] OR $_GET['p']))
	{
		$postid = $vbulletin->input->clean_gpc('r', 'postid', TYPE_INT);
		$p = $vbulletin->input->clean_gpc('r', 'p', TYPE_INT);
		$sorturl = $vbulletin->input->clean_gpc('r', 'sorturl', NO_HTML);
	}
	

	if (isset($p))
	{
		$postid = $p;
	}


	// Get post info for quoting or editing
	if (intval($postid) AND !$_POST['preview'])
	{
		$post = $db->query_first("SELECT postid, imageid, title, pagetext, username, userid, allowsmilie, showsignature FROM " . TABLE_PREFIX . "ppgal_posts WHERE postid = '$postid'");
		$imageid = $post['imageid'];
	}

	// Get image info
	$image = $db->query_first("
			SELECT imageid, userid, images.title, filename, thumbname, extension, open, images.catid, parentlist, options
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (images.catid = categories.catid)
			WHERE imageid = '$imageid'
	");

	$categoryperms = fetch_category_perms();
	$catopts = construct_cat_opts($image['catid'], $image['options']);

	check_image_view($image);

	if ((!$categoryperms["$image[catid]"]['canreplytoimages'] OR !$catopts['open_for_posts'] OR !$catopts['allow_replies']) AND $_REQUEST['do'] != 'editpost')
	{
		print_no_permission();
	}
	$image['url'] = construct_image_url($image, 'thumbname');
	if (!empty($post) AND empty($errors))
	{
		$show['edit'] = false;
		if ($_REQUEST['do'] == 'editpost')
		{
			$show['edit'] = true;
			if (($vbulletin->userinfo['userid'] != $post['userid'] AND !$categoryperms["$image[catid]"]['caneditothersposts']) OR !$categoryperms["$image[catid]"]['caneditposts'])
			{
				print_no_permission();
			}

			$show['editpost'] = true;

			if (!$_REQUEST['preview'])
			{
				$newpost['message'] = $post['pagetext'];
				if (!$post['allowsmilie'])
				{
					$checked['disablesmilies'] = 'checked="checked"';
				}
				if ($post['showsignature'])
				{
					$checked['signature'] = 'checked="checked"';
				}
				else
				{
					$checked['signature'] = '';
				}
			}
		}
		else
		{
			// Go Advanced
			if ($_REQUEST['preview'])
			{
				$pagetext = $post['pagetext'];
			}
			// Quote from quickreply
			else if (!$_REQUEST['quickreply'])
			{
				$originalposter = fetch_quote_username($post['username']);
				$pagetext = $post['pagetext'];
				$tmpval = $vbulletin->options['addtemplatename'];
				$vbulletin->options['addtemplatename'] = 0;

				$templater = vB_Template::create('newpost_quote');
				$templater->register('originalposter', $originalposter);
				$templater->register('pagetext', $pagetext);
				$newpost['message'] =  $templater->render();
				$vbulletin->options['addtemplatename'] = $tmpval;
				//eval('$newpost[\'message\'] = "' . fetch_template('newpost_quote', 1, 0) . '";');
			}
		}
	}

	if (!$image['title'])
	{
		$image['title'] = $image['filename'];
	}

	if (!isset($post['title']))
	{
		$post['title'] = $image['title'];
	}

	// Check to see if it's open
	if (!is_category_mod($image['catid']) AND !$image['open'])
	{
		print_no_permission();
	}

	$category = stripslashes($image['title']);
	$image['title'] = stripslashes($image['title']);

	$image['url'] = construct_image_url($image, 'thumbname');

	// Construct voting box for preview
	$votesel = array();
	$vote = $vbulletin->input->clean_gpc('p', 'vote', TYPE_INT);
	$votesel["$vote"] = 'selected="selected"';

	require_once(DIR . '/includes/functions_editor.php');
	//$textareacols = fetch_textarea_width();

	//$iconbits = construct_icons(intval($_POST['iconid']), iif($ppg_options['gallery_allowposticons'] AND $catopts['allow_post_icons'], 1, 0));
	//$selectedicon['src'] = str_replace($vbulletin->options['cleargifurl'], $vbulletin->options['bburl'] . '/' . $vbulletin->options['cleargifurl'], $selectedicon['src']);

	// Editor & message area

	//$vbulletin->options['allowbbcode'] = $catopts['allow_post_bbcode'];
    //$vbulletin->options['allowbbimagecode'] = $catopts['allow_post_bbimgcode'];
    //$vbulletin->options['allowsmilies'] = $catopts['allow_post_smilies'];
	//$editor_type = 'fe';
	//$_REQUEST['wysiwyg'] = ($catopts['allow_post_bbcode'] ? is_wysiwyg_compatible(-1, $editor_type) : 0);
		
		
		$vbulletin->userinfo['showvbcode'] = 2;

		$editorid = construct_edit_toolbar(
			$newpost['message'],
			false,
			'picturecomment',
			$catopts['allow_post_smilies'],
			true,
			false,
			'fe'

			
		);
//function construct_edit_toolbar($text = '', $ishtml = false, $forumid = 0, $allowsmilie = true, $parsesmilie = true, $can_attach = false, $editor_type = 'fe', $force_editorid = '', $attachinfo = array())



	$messagearea = str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $messagearea);

	//eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');
	$usernamecode = vB_Template::create('newpost_usernamecode')->render();

	$ppg_options['nav_gallery_url']	  =  $ppg_options['gallery_url'] . '/index.php' .  $vbulletin->session->vars['sessionurl_q'];
	$navbits["$ppg_options[nav_gallery_url]"] = $vbphrase['gallery'];
	
	$navbits = construct_dir_navbits($image['parentlist']);
	$navbits['showimage.php?' . $vbulletin->session->vars['sessionurl'] . "i=$image[imageid]"] = $image['title'];

	// Check URL box if isn't set
	if (!isset($checked['parseurl']))
	{
		$checked['parseurl'] = 'checked="checked"';
	}

	// Signature check box
	if (trim($vbulletin->userinfo['signature']) AND !$preview AND !isset($checked['signature']))
	{
		$checked['signature'] = 'checked="checked"';
	}
		$show['delete']=false;
	if ($_REQUEST['do'] == 'editpost')
	{
		$show['delete']=true;
		$navbits[''] = $vbphrase['edit_image_comment'];

		if (($categoryperms["$image[catid]"]['candeleteposts'] AND $vbulletin->userinfo['userid'] == $post['userid']) OR $categoryperms["$image[catid]"]['candeleteothersposts'] OR is_category_mod($image['catid']))
		{
			$itemname = 'postid';
			$itemid = $post['postid'];
			$formaction = 'newreply';
			$dovalue = 'dodeletepost';
			$titlephrase = $vbphrase['delete_this_message'];
			$buttonphrase = $vbphrase['delete_this_message'];
			$confirmphrase = $vbphrase['delete_message_check_appropriate_option'];

			//eval('$deletepost = "' . fetch_template('adv_gallery_conformation') . '";');
		}
	}
	else
	{
		// Get title if necessary
		$vbulletin->options['quotetitle'] = 0;
		if ($ppg_options['gallery_quotetitle'])
		{
			$vbulletin->options['quotetitle'] = 1;
		}
		$post['title'] = fetch_quote_title($post['title'], $image['title']);

		$navbits[''] = $vbphrase['post_new_image_comment'];

		// Rating option
		if ($categoryperms["$image[catid]"]['canrateimages'] AND $catopts['allow_ratings'] AND $ppg_options['gallery_allowrating'])
		{
			$show['ratingopts'] = true;
		}

		// Get replies for topic review
		if ($categoryperms["$image[catid]"]['canviewreplies'])
		{
			$countposts = $db->query_first("SELECT COUNT(postid) AS count FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid = '$imageid'");
		}

		/*if ($countposts['count'])
		{
			$getposts = $db->query_read("
					SELECT pagetext, username, dateline, allowsmilie
					FROM " . TABLE_PREFIX . "ppgal_posts
					WHERE imageid = '$imageid' AND visible != 0
					ORDER BY dateline DESC
					LIMIT " . $vbulletin->options['maxposts']);
			if ($db->num_rows($getposts))
			{
				$show['reviewbits'] = true;

				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());

				while ($posts = $vbulletin->db->fetch_array($getposts))
				{
					$posttime = vbdate($vbulletin->options['timeformat'], $posts['dateline']);
					$postdate = vbdate($vbulletin->options['dateformat'], $posts['dateline']);
					$username = $posts['username'];
					$reviewmessage = $bbcode_parser->parse($posts['pagetext'], 0, $posts['allowsmilie']);

                    ($hook = vBulletinHook::fetch_hook('ppgal_newreply_form_reviewbit')) ? eval($hook) : false;

					//eval('$reviewbits .= "' . fetch_template('newreply_reviewbit') . '";');
				}
			}
			if ($countposts['count'] > $vbulletin->options['maxposts'])
			{
				$show['reviewmore'] = true;
			}
			$db->free_result($getposts);
			unset($posts);
			
		}*/
	}

// replace smilies
$messagearea = str_replace('"images/','"' . $vbulletin->options['bburl'] . '/images/', $messagearea);

	$navbits = construct_navbits($navbits);
//	eval('$navbar = "' . fetch_template('navbar') . '";');
$navbar = render_navbar_template($navbits);

$ppg_vars['postid'] = $postid;
$ppg_vars['sorturl'] = $sorturl;
($hook = vBulletinHook::fetch_hook('ppgal_newreply_form_complete')) ? eval($hook) : false;

	$templater = vB_Template::create('ADV_GALLERY_REPLY');
	$templater->register_page_templates();
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('editorid', $editorid);
	$templater->register('messagearea', $messagearea);
	$templater->register('navbar', $navbar);
	$templater->register('post', $post);
	$templater->register('image', $image);
	$templater->register('postpreview', $postpreview);
	$templater->register('checked', $checked);
	$templater->register('usernamecode', $usernamecode);
	$templater->register('votesel', $votesel);
	$templater->register('disablesmiliesoption', $disablesmiliesoption);
	print_output($templater->render());
	//eval('print_output("' . fetch_template('ADV_GALLERY_REPLY') . '");');
}

// ############################## Delete Post #############################
if ($_POST['do'] == 'dodeletepost')
{
	$postid = $vbulletin->input->clean_gpc('p', 'postid', TYPE_INT);
	$deletepost = $vbulletin->input->clean_gpc('p', 'deletepost', TYPE_INT);

	if ($_POST['doaction'] != 1)
	{
		eval(standard_error(fetch_error('adv_gallery_nodelete')));
	}

	$post = $db->query_first("SELECT postid, posts.userid, posts.imageid, images.catid, parentlist
			FROM " . TABLE_PREFIX . "ppgal_posts AS posts
			INNER JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid)
			INNER JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			WHERE postid = '$postid'
	");

	if (!$post['postid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['post'], $vbulletin->options['contactuslink'])));
	}

	$categoryperms = fetch_category_perms();
	if ((($post['userid'] != $vbulletin->userinfo['userid'] AND !$categoryperms["$post[catid]"]['candeleteothersposts']) OR !$categoryperms["$post[catid]"]['candeleteposts'] AND $post['userid'] == $vbulletin->userinfo['userid']) AND !is_category_mod($post['catid']))
	{
		print_no_permission();
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_posts WHERE postid = '$post[postid]'");

	$lastpost = $db->query_first("SELECT dateline, username, userid FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid = '$post[imageid]' ORDER BY dateline DESC LIMIT 1");

	$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_images SET posts = posts-1, lastpostdateline = '$lastpost[dateline]', lastpostuserid = '$lastpost[userid]', lastpostusername = '$lastpost[username]' WHERE imageid = '$post[imageid]'");
	$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_user SET pppcount = pppcount-1 WHERE userid = '" . $vbulletin->userinfo['userid'] . "'");

    $catimids = array();
	$getimageids = $db->query_read("SELECT imageid FROM " . TABLE_PREFIX . "ppgal_images WHERE catid = '$post[catid]'");
	while ($imageids = $vbulletin->db->fetch_array($getimageids))
	{
		$catimids[] = $imageids['imageid'];
	}

	$lastcatpost = $db->query_first("
			SELECT postid, images.title, posts.imageid, posts.dateline, posts.userid, posts.username
			FROM " . TABLE_PREFIX . "ppgal_posts AS posts
			LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid)
			WHERE posts.imageid IN(" . implode(',', $catimids) . ") AND visible = 1
			ORDER BY posts.dateline DESC
	");

	$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_categories SET postcount = postcount-1, lastpostid = '$lastcatpost[postid]', lastpostimagetitle = '" . addslashes($lastcatpost['title']) . "', lastpostuserid = '$lastcatpost[userid]', lastpostusername = '" . addslashes($lastcatpost['username']) . "', lastpostdateline = '$lastcatpost[dateline]' WHERE catid = '$post[catid]'");

($hook = vBulletinHook::fetch_hook('ppgal_newreply_delete_post')) ? eval($hook) : false;

	$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $post['imageid'];
	eval(print_standard_redirect('adv_gallery_post_deleted'));
}

// ############################### Do Rate Image ###############################
if ($_POST['do'] == 'rate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'vote'		=> TYPE_INT,
		'imageid'	=> TYPE_INT,
		'redirpage'	=> TYPE_NOHTML,
		'langid'=> TYPE_INT
	));
	
	$adv_sorturl = construct_adv_sort_url();
	rate_image($vbulletin->GPC['vote'], $vbulletin->GPC['imageid'], $vbulletin->GPC['redirpage']);
}

?>