<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: moderate.php                                                     ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################

define('THIS_SCRIPT', 'gallery_moderate');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
    'ADV_GALLERY_MODERATE',
    'adv_gallery_moderate_imagebits',
    'adv_gallery_moderate_postbits',
    'adv_gallery_upload_custombits',
    'ADV_GALLERY_MODOPTS',
    'adv_gallery_conformation',
    'ADV_GALLERY_MASSDELETE_POSTS',
    'threadadmin_postbit'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################



// Stick Image 
if ($_POST['do'] == 'stickimage')
{
	$image = $db->query_first("
			SELECT imageid, images.title, images.catid, sticky
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			WHERE imageid = '$imageid'
	");

	if (!is_category_mod($image['catid']) AND (!$image['catuserid'] OR $image['catuserid'] != $vbulletin->userinfo['userid']))
	{
		print_no_permission();
	}

	$image['title'] = stripslashes($image['title']);

	if ($image['sticky'])
	{
		$stick = 0;
		$redirectmessage = 'adv_gallery_unstuck';
	}
	else
	{
		$stick = 1;
		$redirectmessage = 'adv_gallery_stuck';
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET sticky = '$stick' WHERE imageid = '$imageid'");
	$adv_sorturl = construct_adv_sort_url();

	$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid . $adv_sorturl;;
	eval(print_standard_redirect($redirectmessage));
}

// ###################### Close image ###########################
if ($_POST['do'] == 'closeimage')
{
	$image = $db->query_first("
			SELECT imageid, images.title, images.catid, open
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			WHERE imageid = '$imageid'
	");

	check_image_id($image['imageid']);

	if (!is_category_mod($image['catid']) AND (!$image['catuserid'] OR $image['catuserid'] != $vbulletin->userinfo['userid']))
	{
		print_no_permission();
	}

	$image['title'] = stripslashes($image['title']);

	if ($image['open'])
	{
		$closeit = 0;
		$redirectmessage = 'adv_gallery_closed';
	}
	else
	{
		$closeit = 1;
		$redirectmessage = 'adv_gallery_opened';
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET open = '$closeit' WHERE imageid = '$imageid'");

	$adv_sorturl = construct_adv_sort_url();
	$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid . $adv_sorturl;
	eval(print_standard_redirect($redirectmessage));
}

// ################################ Delete Image ##############################
if ($_POST['do'] == 'deleteimage')
{
	$image = $db->query_first("
			SELECT imageid, images.title, userid, images.catid, parentlist
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			WHERE imageid = '$imageid'
	");

	check_image_id($image['imageid']);



	$categoryperms = fetch_category_perms();
	if (((!$categoryperms["$image[catid]"]['candelete'] AND $vbulletin->userinfo['userid'] == $image['userid']) OR ($categoryperms["$image[catid]"]['candeleteothers'] AND $vbulletin->userinfo['userid'] != $image['userid'])) AND !is_category_mod($image['catid']))
	{
		print_no_permission();
	}

	$post_sorturl = $vbulletin->input->clean_gpc('r', 'psurl', TYPE_NOHTML);

	$navname = $vbphrase['delete_this_image'];
	$image['title'] = stripslashes($image['title']);

	$itemname = 'imageid';
	$itemid = $image['imageid'];
	$formaction = 'moderate';
	$dovalue = 'dodeleteimage';
	$itemtitle = stripslashes($image['title']);
	$titlephrase = $vbphrase['delete_this_image'];
	$buttonphrase = $vbphrase['delete'];
	$confirmphrase = $vbphrase['to_delete_check_appropriate_box'];

	//eval('$content = "' . fetch_template('adv_gallery_conformation') . '";');

			$templater = vB_Template::create('adv_gallery_conformation');
			$templater->register('image', $image);
			$templater->register('itemid', $itemid);
			$templater->register('formaction', $formaction);
			$templater->register('dovalue', $dovalue);
			$templater->register('itemtitle', $itemtitle);
			$templater->register('titlephrase', $titlephrase);
			$templater->register('buttonphrase', $buttonphrase);
			$templater->register('confirmphrase', $confirmphrase);
			$content = $templater->render();

	$ppg_options['nav_gallery_url']	  =  $ppg_options['gallery_url'] . '/index.php' .  $vbulletin->session->vars['sessionurl_q'];
	$navbits["$ppg_options[nav_gallery_url]"] = $vbphrase['gallery'];
	$navbits = construct_dir_navbits($image['parentlist']);


	$navbits['showimage.php?' . $vbulletin->session->vars['sessionurl'] . "i=$image[imageid]" . $post_sorturl] = $image['title'];
	$navbits[''] = $vbphrase['delete_this_image'];
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	//eval('$navbar = "' . fetch_template('navbar') . '";'); 
	//eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

//	eval('print_output("' . fetch_template('ADV_GALLERY_MODOPTS') . '");');

$templater = vB_Template::create('ADV_GALLERY_MODOPTS');
	$templater->register_page_templates();
	$templater->register('content', $content);
	$templater->register('navbar', $navbar);
	print_output($templater->render());
}

// ############################### Do Delete Image ###############################
if ($_POST['do'] == 'dodeleteimage')
{

	$imageid = $vbulletin->input->clean_gpc('p', 'imageid', TYPE_INT);
	$doaction = $vbulletin->input->clean_gpc('p', 'doaction', TYPE_INT);
	$source = $vbulletin->input->clean_gpc('p', 'source', TYPE_NOHTML);

	if($doaction != 1)
	{
		eval(standard_error(fetch_error('adv_gallery_nodelete')));
	}




	$tempuserarray = array();
	$templastimgarray = array();
	$userpostsarray = array(); 
	$userlastimgarray = array();

	$image = $db->query_first("
			SELECT images.imageid, images.catid ,images.title, images.userid, images.filename, images.thumbname, images.originalname, images.posts, images.valid, categories.lastpostid AS lastpostid, categories.lastimageid  AS lastimageid, categories.catimage AS catimage, user.lastimageid AS userlastimageid, user.lastpostid AS userlastpostid
			FROM " . TABLE_PREFIX . "ppgal_images AS images 
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			LEFT JOIN " . TABLE_PREFIX . "ppgal_user AS user ON (user.userid = images.userid)
			WHERE imageid = '$imageid'
				
	");

	$categoryperms = fetch_category_perms();
	if (!is_category_mod($image['catid']) AND ((!$categoryperms["$image[catid]"]['candelete'] AND $vbulletin->userinfo['userid'] == $image['userid']) OR (!$categoryperms["$image[catid]"]['candeleteothers'] AND $vbulletin->userinfo['userid'] != $image['userid'])))
	{
		print_no_permission();
	}

	// check if catimage
	$image['iscatimage'] = false;
	if($image['catimage'] OR $image['catimage'] != '')
	{
		$image['iscatimage'] = true;
		$catimage =	unserialize($image['catimage']);
		$image['catimage'] = $ppg_options['gallery_fileurl'] . '/' . $catimage['url'];
		unset($catimage);
	}


	if ($image['iscatimage'] AND (fetch_folder_url($image) . '/' . $image['thumbname'] == $image['catimage']))
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET catimage = '' WHERE catid = '$image[catid]'");
	}

	// check if its users lastimage 
	if($image['lastimageid']==$imageid)
	{
		$templastimgarray[] = $image['userid'];
	}

	// get users that have posted on that image

	$userposts = $db->query_read("
		SELECT userid FROM " . TABLE_PREFIX . "ppgal_posts
		WHERE imageid = $imageid AND visible=1
	");
			
	while ($userpost = $vbulletin->db->fetch_array($userposts))
	{
		$tempuserarray[] = $userpost['userid'];
	}
	$vbulletin->db->free_result($userposts);
	unset($userpost);

	if(!empty($tempuserarray))
	{
		$userpostsarray = array_unique(array_merge($userpostsarray,$tempuserarray));
	}

	if(!empty($templastimgarray))
	{
		$userlastimgarray = array_unique(array_merge($userlastimgarray,$templastimgarray));
	}

/*
	$deletearray["$imageid"]['catid'] = $image['catid'];
	$deletearray["$imageid"]['userid'] = $image['userid'];
	$deletearray["$imageid"]['filename'] = $image['filename'];
	$deletearray["$imageid"]['thumbname'] = $image['thumbname'];
	$deletearray["$imageid"]['originalname'] = $image['originalname'];
	$deletearray["$imageid"]['posts'] = $image['posts'];
*/
	if (intval($imageid) > 0)
	{
		// we only have 1 image
		//	delete_images('', $deletearray);
		delete_images($imageid);
		// update last image and lastpost for cats
	

		update_count_lite($image['catid']);

		// update last image and lastpost for users
		// posts
		if(!empty($userpostsarray))
		{
			
			foreach($userpostsarray AS $posterid)
			{
				
				if($posterid < 1)
				{
					continue;
				}

				$vbg_tp = $db->query_first("SELECT COUNT(postid) AS postcount FROM " . TABLE_PREFIX . "ppgal_posts WHERE userid = $posterid AND visible = 1");
				$vbg_lp = $db->query_first("SELECT postid, title, dateline, visible FROM " . TABLE_PREFIX . "ppgal_posts WHERE userid = $posterid AND visible = 1 ORDER BY dateline DESC");

        		$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user
					SET
					pppcount = '$vbg_tp[postcount]',
					lastpostdate = '$vbg_lp[dateline]',
					lastpostid = '$vbg_lp[postid]',
					lastposttitle = '" . $db->escape_string($vbg_lp['title']) . "'
					WHERE userid = '$posterid'
				");

			}
			unset($userpostsarray, $posterid, $vbg_tp, $vbg_lp);
		}
		// lastimage
		if(!empty($userlastimgarray))
		{
			
			foreach($userlastimgarray AS $posterid)
			{
				
				if($posterid < 1)
				{
					continue;
				}
				$vbg_ti = $db->query_first("SELECT COUNT(imageid) AS imagecount FROM " . TABLE_PREFIX . "ppgal_images WHERE userid = $posterid AND valid = 1");
                $vbg_li = $db->query_first("SELECT imageid, title, dateline, valid FROM " . TABLE_PREFIX . "ppgal_images WHERE userid = $posterid AND valid = 1 ORDER BY dateline DESC");

       			$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user
					SET
					ppicount = '$vbg_ti[imagecount]',
					lastimagedate = '$vbg_li[dateline]',
					lastimageid = '$vbg_li[imageid]',
					lastimagetitle = '" . $db->escape_string($vbg_li['title']) . "'
					WHERE userid = '$posterid'
				");
			}
			unset($userlastimgarray, $posterid, $vbg_ti, $vbg_li);
		}
			
	}

	$source = $vbulletin->input->clean_gpc('p', 'source', TYPE_NOHTML);

	if($source=='editor')
	{	
		if($vbulletin->userinfo['userid'] == $image['userid'])
		{
			$vbulletin->url =  $vbulletin->options['bburl'] . '/profile.php?' . $vbulletin->session->vars['sessionurl'] . 'do=vbgeditimages';
		}
		else
		{
			$vbulletin->url = $vbulletin->options['bburl'] . '/profile.php?' . $vbulletin->session->vars['sessionurl'] . 'do=vbgeditimages&amp;u=' . $image['userid'];
		}
	}
	else if($source=='editimage')
	{
		$vbulletin->url = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=member&amp;imageuser=' . $image['userid'];
	}
	else
	{
		$vbulletin->url = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $image['catid'];
	}
	($hook = vBulletinHook::fetch_hook('ppgal_mod_delete_image')) ? eval($hook) : false;

	eval(print_standard_redirect('adv_gallery_editimage_removed'));
}

// ########################### Delete Posts ##############################
if ($_POST['do'] == 'deleteposts')
{
require_once(DIR . '/includes/class_bbcode.php');
$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list()); 
	$imageid = $vbulletin->input->clean_gpc('p', 'imageid', TYPE_INT);

	$posts = $db->query_read("
			SELECT postid, posts.title, posts.imageid, pagetext, posts.username, posts.userid, posts.dateline, images.title AS imagetitle, images.catid, categories.title AS cattitle, parentlist
			FROM " . TABLE_PREFIX . "ppgal_posts AS posts
			LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid)
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			WHERE posts.imageid = '$imageid'
			ORDER BY posts.dateline
	");
	if ($db->num_rows($posts))
	{
		while ($post = $vbulletin->db->fetch_array($posts))
		{
			$image['title'] = stripslashes($post['imagetitle']);
			$post['postdate'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
			$post['posttime'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);
			$categoryid = $post['catid'];
			$parentlist = $post['parentlist'];
			$post['pagetext'] = $bbcode_parser->do_parse($post['pagetext']);
                eval('$postbits .= "' . fetch_template('threadadmin_postbit') . '";');
		}
	}

	if (!is_category_mod($categoryid))
	{
		print_no_permission();
	}

	$navbits = construct_dir_navbits($parentlist);
	$navbits['showimage.php?' . $vbulletin->session->vars['sessionurl'] . "i=$imageid"] = $image['title'];
	$navbits[''] = $vbphrase['delete_posts'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

	eval('print_output("' . fetch_template('ADV_GALLERY_MASSDELETE_POSTS') . '");');
}

// ######################### Do Delete Posts #############################
if ($_POST['do'] == 'dodeleteposts')
{
	$imageid = $vbulletin->input->clean_gpc('p', 'imageid', TYPE_INT);
	$checkpost = $vbulletin->input->clean_gpc('p', 'checkpost', TYPE_ARRAY_STR);

	$delcount = 0;
	if (is_array($checkpost))
	{
		$postids = array();
		foreach ($checkpost AS $key => $val)
		{
			if ($checkpost["$key"])
			{
				$delcount++;
				$postids[] = $key;
			}
		}

		$delpost = implode(',', $postids);

		$category = $db->query_first("
				SELECT images.catid, lastpostid
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				LEFT JOIN " . TABLE_PREFIX . "ppgal_categories USING (catid)
				WHERE imageid = '$imageid'
		");
		if (!is_category_mod($category['catid']))
		{
			print_no_permission();
		}

		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_posts WHERE postid IN($delpost)");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET posts = posts-$delcount WHERE imageid = '$imageid'");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET postcount = postcount-$delcount WHERE catid = '$category[catid]'");

		$posts = $db->query_first("SELECT userid, dateline, username FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid = '$imageid' ORDER BY dateline DESC");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET lastpostdateline = '$posts[dateline]', lastpostuserid = '$posts[userid]', lastpostusername = '$posts[username]' WHERE imageid = '$imageid'");

		if (in_array($category['lastpostid'], $postids))
		{

			$lastpost = $db->query_first("
					SELECT postid, posts.userid, posts.username, posts.dateline, images.title
					FROM " . TABLE_PREFIX . "ppgal_posts AS posts
					LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (posts.imageid = images.imageid)
					WHERE images.catid = '$category[catid]' AND visible = 1
					ORDER BY images.dateline ASC
			");

			$cats = array();
			$cats['lastpostid'] = $lastpost['postid'];
			$cats['lastpostuserid'] = $lastpost['userid'];
			$cats['lastpostusername'] = $lastpost['username'];
			$cats['lastpostdateline'] = $lastpost['dateline'];
			$cats['lastpostimagetitle'] = $lastpost['title'];

			$db->query_read(fetch_query_sql($cats, 'ppgal_categories', 'WHERE catid = ' . $category['catid']));
		}
	}

	$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid;

    ($hook = vBulletinHook::fetch_hook('ppgal_mod_delete_post')) ? eval($hook) : false;

	eval(print_standard_redirect('adv_gallery_posts_deleted'));
}

// ####################### Set as Category Image ###########################
if (in_array($_POST['do'], array('setascatimage', 'removecatimage')))
{
	$image = $db->query_first("
			SELECT imageid, images.title, images.catid, userid, thumbname, catuserid
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			WHERE imageid = '$imageid'
	");

	if (!is_category_mod($image['catid']) AND (!$image['catuserid'] OR $image['catuserid'] != $vbulletin->userinfo['userid']))
	{
		print_no_permission();
	}

	$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'];

	if ($_POST['do'] == 'removecatimage')
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET catimage = '' WHERE catid = '$image[catid]'");
		eval(print_standard_redirect('adv_gallery_set_as_cat_image'));
	}
	else
	{
		$image['title'] = stripslashes($image['title']);

		$catimage['url'] = fetch_folder_url($image, true) . '/' . $image['thumbname'];

		$thumbinfo = @getimagesize($ppg_options['gallery_filedirectory'] . '/' . $catimage['url']);
		$catimage['w'] = $thumbinfo[0];
		$catimage['h'] = $thumbinfo[1];

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET catimage = '" . addslashes(serialize($catimage)) . "' WHERE catid = '$image[catid]'");

		eval(print_standard_redirect('adv_gallery_set_as_cat_image'));
	}
}

// ########################### IP Address For Post ############################
if ($_REQUEST['do'] == 'getip')
{

$postid = $vbulletin->input->clean_gpc('r', 'p', TYPE_INT);

	if ($imageid)
	{
		$postinfo = $db->query_first("
				SELECT images.ipaddress, catid
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				WHERE imageid = '$imageid'
		");
	}
	else
	{
		$postinfo = $db->query_first("
				SELECT posts.ipaddress, images.catid
				FROM " . TABLE_PREFIX . "ppgal_posts AS posts
				LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid)
				WHERE postid = '$postid'
		");
	}

	if (!is_category_mod($postinfo['catid']))
	{
		print_no_permission();
	}

	eval(standard_error(fetch_error('thread_displayip', $postinfo['ipaddress'], @gethostbyaddr($postinfo['ipaddress']))));
}

// ########################## Validate/unvalidate Single Image ###########################
if (in_array($_POST['do'], array('validateimage', 'unvalidateimage')))
{
	$image = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");
	if (!is_category_mod($image['catid']))
	{
		print_no_permission();
	}


	$title["$image[imageid]"] = $image['title'];
	$desc["$image[imageid]"] = $image['description'];
	$keywords["$image[imageid]"] = $image['keywords'];
	$views["$image[imageid]"] = $image['views'];
	$catid["$image[imageid]"] = $image['catid'];
	$notes["$image[imageid]"] = $image['notes'];
	// double?
	$title["$image[imageid]"] = $image['title'];
	if($_POST['do'] == 'unvalidateimage')
	{
		$validateimage["$image[imageid]"] = 3;
	}
	else
	{
		$validateimage["$image[imageid]"] = 1;
	}

	validate_new_images($validateimage);
	// Create previous link, next link
	$adv_sorturl = construct_adv_sort_url();

	$type = $vbphrase['images'];
	$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $adv_sorturl;
	eval(print_standard_redirect('adv_gallery_new_x_validated'));
}

// ############################### Moderate New ###############################
if ($_REQUEST['do'] == 'moderate')
{
	$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_NOHTML);

	if (!$show['modoptions'])
	{
		print_no_permission();
	}

	if ($type != 'posts')
	{
		$type = 'images';
	}
	if ($type == 'images')
	{
		$custominfo = array();
		$show['topmail'] = true;
		$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields ORDER BY displayorder");
		while ($field = $vbulletin->db->fetch_array($customfields))
		{
			$custominfo[] = $field;
		}
		$db->free_result($customfields);
		unset($field);

		$images = $db->query_read("
				SELECT images.*, user.email, cf_entries.*
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (images.userid = user.userid)
				LEFT JOIN " . TABLE_PREFIX . "ppgal_customfields_entries AS cf_entries ON (images.imageid = cf_entries.imgid)
				WHERE valid = 0
				ORDER BY imageid
		");
		if ($db->num_rows($images))
		{
			$modcount = 0;
			$show['validate'] = true;
			$albumclass = ($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1) ? '_alt' : '';
			while ($image = $vbulletin->db->fetch_array($images))
			{
				if (!is_category_mod($image['catid']))
				{
					continue;
				}
				$modcount++;
				$image['firstclass'] = ' topsep';
				if($modcount == 1)
				{
					$image['firstclass'] = '';
				}
				$image['name'] = stripslashes($image['name']);
				$image['userurl'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $image['userid'], 'username' =>  $image['username']));
				$image['filesize'] = vb_number_format($image['filesize'], 1, true);
				$image['originalfilesize'] = iif($image['originalfilesize'], vb_number_format($image['originalfilesize'], 1, true));
				$image['username'] = stripslashes($image['username']);
				$image['dateadded'] = vbdate($vbulletin->options['dateformat'], $image['dateline']);
				$image['timeadded'] = vbdate($vbulletin->options['timeformat'], $image['dateline']);
				$image['url'] = construct_image_url($image, 'thumbname');
				$image['fileurl'] = fetch_folder_url($image) . '/' . $image['filename'];
				$catoptions = print_cat_select($image['catid'], 'upload');
				$image['albumbitclass'] = $albumclass;
				$customfieldbits = construct_custom_fieldbits($image, $custominfo, true, false, true);
				
				$templater = vB_Template::create('adv_gallery_moderate_imagebits');
				$templater->register('catoptions', $catoptions);
				$templater->register('customfieldbits', $customfieldbits);
				$templater->register('image', $image);
				$templater->register('modcount', $modcount);
				$moderationbits .= $templater->render();
			}
		}
		if($modcount==0)
		{
			$show['validate'] = false;
		}
	}
	else
	{
		$show['topmail'] = false;
		$posts = $db->query_read("
	  		SELECT posts.*, images.title AS imagetitle, catid
	  		FROM " . TABLE_PREFIX . "ppgal_posts AS posts
	  		LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid) 
				WHERE visible = 0
	  		ORDER BY postid
		");
		if ($db->num_rows($posts))
		{
			$modcount = 0;
			$show['validate'] = true;
			while ($post = $vbulletin->db->fetch_array($posts))
			{
				if (!is_category_mod($post['catid']))
				{
					continue;
				}
				$modcount++;
				$post['title'] = stripslashes($post['title']);
				$post['username'] = stripslashes($post['username']);

				$post['userurl'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $post['userid'], 'username' =>  $post['username']));

				$post['dateadded'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
				$post['timeadded'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);
				$post['pagetext'] = htmlspecialchars(stripslashes($post['pagetext']));
				$post['title'] = stripslashes($post['title']);

				$templater = vB_Template::create('adv_gallery_moderate_postbits');


				$templater->register('post', $post);
				$templater->register('modcount', $modcount);
				$moderationbits .= $templater->render();

			}
		}
		if($modcount==0)
		{
			$show['validate'] = false;
		}
	}

	$ppg_options['nav_gallery_url']	  =  $ppg_options['gallery_url'] . '/index.php' .  $vbulletin->session->vars['sessionurl_q'];
	$navbits["$ppg_options[nav_gallery_url]"] = $vbphrase['gallery'];

	$navbits[''] = $vbphrase['moderate_new'];
	$navbits = construct_navbits($navbits);


	/* ### Finish redering  navbar */
	$templater = vB_Template::create('navbar');
	$navbar = $templater->render();
	$navbar = render_navbar_template($navbits);

	/* ### Add announcement if active */
	if($ppgal_announcement)
	{
		$navbar = $navbar . $ppgal_announcement;
	}
	$ppg_vars['gallery_title'] = $ppg_options['gallery_title'];
	if (!$show['validate'])
	{
		$nonemessage = construct_phrase($vbphrase['no_x_awaiting_moderation'], iif($type == 'images', $vbphrase['images'], $vbphrase['posts']));
	}

	$templater = vB_Template::create('ADV_GALLERY_MODERATE');
	$templater->register_page_templates();
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('type', $type);
	$templater->register('navbar', $navbar);
	$templater->register('moderationbits', $moderationbits);
	$templater->register('nonemessage', $nonemessage);
	print_output($templater->render());
	exit; // not needed but...


   // eval('print_output("' . fetch_template('ADV_GALLERY_MODERATE') . '");');

}

// ########################## Do Validate New Images ##########################
if ($_POST['do'] == 'dovalidateimages')
{
	$email = $vbulletin->input->clean_gpc('p', 'email', TYPE_ARRAY_STR);
	$dateline = $vbulletin->input->clean_gpc('p', 'dateline', TYPE_ARRAY_STR);
	$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_ARRAY_STR);
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_ARRAY_STR);
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_ARRAY_STR);
	$desc = $vbulletin->input->clean_gpc('p', 'desc', TYPE_ARRAY_STR);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_ARRAY_STR);
	$keywords = $vbulletin->input->clean_gpc('p', 'keywords', TYPE_ARRAY_STR);
	$views = $vbulletin->input->clean_gpc('p', 'views', TYPE_ARRAY_STR);
	$notes = $vbulletin->input->clean_gpc('p', 'notes', TYPE_ARRAY_STR);
	$sendmail = $vbulletin->input->clean_gpc('p', 'sendmail', TYPE_ARRAY_STR);
	$validateimage = $vbulletin->input->clean_gpc('p', 'validateimage', TYPE_ARRAY_STR);
	$thumbname = $vbulletin->input->clean_gpc('p', 'thumbname', TYPE_ARRAY_STR);
	$filename = $vbulletin->input->clean_gpc('p', 'filename', TYPE_ARRAY_STR);

	if (!$show['modoptions'])
	{
		print_no_permission();
	}

	validate_new_images($validateimage);

	$type = $vbphrase['images'];
	$vbulletin->url = 'moderate.php?' . $vbulletin->session->vars['sessionurl'] . 'do=moderate';
	eval(print_standard_redirect('adv_gallery_new_x_validated'));
}

// ########################### Do Validate New Posts ##########################
if ($_POST['do'] == 'dovalidateposts')
{

	$imageid = $vbulletin->input->clean_gpc('p', 'imageid', TYPE_ARRAY_STR);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_ARRAY_STR);
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_ARRAY_STR);
	$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_ARRAY_STR);
	$dateline = $vbulletin->input->clean_gpc('p', 'dateline', TYPE_ARRAY_STR);
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_ARRAY_STR);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_ARRAY_STR);
	$validatepost = $vbulletin->input->clean_gpc('p', 'validatepost', TYPE_ARRAY_STR);
	$imagetitle = $vbulletin->input->clean_gpc('p', 'imagetitle', TYPE_ARRAY_STR);

	if (!$show['modoptions'])
	{
		print_no_permission();
	}

	validate_new_posts();

	$type = $vbphrase['posts'];
	$vbulletin->url = 'moderate.php?' . $vbulletin->session->vars['sessionurl'] . 'do=moderate&amp;type=posts';
	eval(print_standard_redirect('adv_gallery_new_x_validated'));
}

?>