<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: misc_light.php                                                   ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'gallery_misc_light');
define('VBGLITE', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('messaging');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
'ADV_GALLERY_SHOWIMAGE_VISITORS',
'adv_gallery_showimage_visitorbits'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
	require_once('./gallery_global.php');
	unset($vbulletin->debug, $GLOBALS['DEVDEBUG']);

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################


if (empty($_REQUEST['do']))
{

	standard_error(fetch_error('invalid_action'));
}

// ########################### View Visitors ############################
if ($_REQUEST['do'] == 'viewvisitors')
{
	if(!$ppg_options['gallery_display_visitors_pop'])
	{
		print_no_permission();
	}

	if(intval($imageid) < 1)
	{
		standard_error(fetch_error('noid', $vbphrase['image'], $vbulletin->options['contactuslink']));
	}

	$image = $db->query_first("SELECT imageid, title, catid, userid, visitors FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");

	check_image_id($image['imageid']);

	$categoryperms = fetch_category_perms($image['catid']);
	$show['ismoderator'] = is_category_mod($image['catid']);


	$visitors = Array(); 
	$userviews = Array(); 
	// we first get the userviews 
	if(!empty($image['visitors'])) 
	{ 
		$userviews = unserialize($image['visitors']); 
	} 
	unset($image['visitors']);
	$visitors['usercount'] = count($userviews); 
	$icount = 0;
	$visitorbits = '';
	if($visitors['usercount'] > 0) 
	{ 

		
		for($i=0; $i<$visitors['usercount'];$i++) 
		{ 
			if(!empty($userviews[$i])) 
			{ 
				$bg = exec_switch_bg();
				$bg = 'table'.$bg;
				$visitors['bgclass'] = $bg;
				$icount++;

				$visitors['dateviewed'] = vbdate($vbulletin->options['dateformat'], $userviews[$i]['dateline'],true); 
				$visitors['timeviewed'] = vbdate($vbulletin->options['timeformat'], $userviews[$i]['dateline'],true); 
				$visitors['dateline'] = $visitors['dateviewed'] . ' - <span class="time">' . $visitors['timeviewed'] . '</span>';
				$visitors['username'] =  htmlspecialchars_uni($userviews[$i]['username']); 
				$visitors['userid'] =  intval($userviews[$i]['userid']); 
				$visitors['visitorurl'] = fetch_seo_url('member', array('userid' => $visitors['userid'], 'username' =>  $visitors['username']));
				
				$templater = vB_Template::create('adv_gallery_showimage_visitorbits');
				$templater->register('visitors', $visitors);
				$visitorbits .=  $templater->render();
			} 
		} 
		
		unset($userviews, $visitors); 
	}
	else
	{
		$visitorbits .=  '<tr class="tablealt1"><td colspan="2" align="center"><b>' . $vbphrase['n_a'] . '</b></td></tr>';
	}

	$vbphrase['title'] = $vbphrase['recent_visitors'];
	$vbphrase['title2'] = htmlspecialchars_uni(stripslashes($image['title']));
	$vbphrase['rating'] = $vbphrase['date_time_visit'];
	$vbphrase['view_visitors'] = '<b>'.$vbphrase['recent_visitors'] . ' (' . $icount . ')</b>';
	$headinclude = construct_metatags($headinclude, '', '');
	$templater = vB_Template::create('ADV_GALLERY_SHOWIMAGE_VISITORS');
	$templater->register_page_templates();
	$templater->register('visitorbits', $visitorbits);
	print_output($templater->render());
	exit;
}
// ########################### View Member Ratings ############################
if ($_REQUEST['do'] == 'viewratings')
{
	($hook = vBulletinHook::fetch_hook('ppgal_misc_view_ratings')) ? eval($hook) : false;

	if (!$ppg_options['gallery_showuserratings'])
	{
		print_no_permission();
	}
	$rating = Array(); 
	$icount = 0;
	$getratings = $db->query_read("
			SELECT rate.userid, rate.rating, rate.dateline, images.title as title, user.username as username
			FROM " . TABLE_PREFIX . "ppgal_rate AS rate
			LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (rate.imageid = images.imageid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (rate.userid = user.userid)
			WHERE rate.imageid = '$imageid'
			ORDER BY dateline DESC
	");
	while ($rating = $vbulletin->db->fetch_array($getratings))
	{
		$icount++;
		$bg = exec_switch_bg();
		$bg = 'table'.$bg;
		$rating['bgclass'] = $bg;

		
		$rating['dateviewed'] = vbdate($vbulletin->options['dateformat'], $rating['dateline'],true); 
		$rating['timeviewed'] = vbdate($vbulletin->options['timeformat'], $rating['dateline'],true); 
		$rating['dateline'] = $rating['dateviewed'] . ' - <span class="time">' . $rating['timeviewed'] . '</span>';

		$rating['username'] =  htmlspecialchars_uni($rating['username']); 
		$rating['userid'] =  intval($rating['userid']); 
		$rating['userurl'] = fetch_seo_url('member', array('userid' => $rating['userid'], 'username' =>  $rating['username']));
		

        ($hook = vBulletinHook::fetch_hook('ppgal_misc_view_ratings_bit')) ? eval($hook) : false;
				
		$templater = vB_Template::create('adv_gallery_showimage_ratingbits');
		$templater->register('rating', $rating);
		$ratingbits .=  $templater->render();

		$vbphrase['title2'] = htmlspecialchars_uni($rating['title']);
	}
	$db->free_result($getratings);

	unset($rating);
	$vbphrase['title'] = htmlspecialchars_uni($vbphrase['view_other_members_ratings']);
	$vbphrase['view_other_members_ratings'] = '<b>'.$vbphrase['view_other_members_ratings'] . ' (' . $icount . ')</b>';

($hook = vBulletinHook::fetch_hook('ppgal_misc_view_ratings_complete')) ? eval($hook) : false;
$headinclude = construct_metatags($headinclude, '', '');
	$templater = vB_Template::create('ADV_GALLERY_SHOWIMAGE_RATINGS');
	$templater->register_page_templates();
	$templater->register('ratingbits', $ratingbits);
	print_output($templater->render());

}
?>