<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: index.php                                                        ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
// #################### DEFINE IMPORTANT CONSTANTS #######################
// other definitions in gallery_global
define('THIS_SCRIPT', 'gallery_index');
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'ADV_GALLERY',
	'adv_gallery_categorybit_level1',
	'adv_gallery_categorybit_level2',
	'adv_gallery_categorybit_main',
	'adv_gallery_categorybit_subcat',
	'adv_gallery_nodisplay',
    'adv_gallery_home_loggedinuser',
    'adv_gallery_newimages',
	'adv_gallery_imagebit',
	'adv_gallery_imagebit_lite',
    'adv_gallery_randomimages',
	'adv_gallery_moderator',
	'adv_gallery_category_jump',
	'adv_gallery_category_jump_link',
	'adv_gallery_category_jump_subforum'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################


($hook = vBulletinHook::fetch_hook('ppgal_home_start')) ? eval($hook) : false;

$categoryperms = fetch_category_perms();

if (!intval($catid))
{
	// Get category info to print the categories and make the stats
	$getcats = $db->query_read("
			SELECT catid, styleid, title, description, parent, parentlist, catimage, imagecount, postcount, lastimageid, lastimagetitle, lastimageuserid, lastimageusername, lastimagedateline, lastpostid, lastpostuserid, lastpostusername, lastpostimagetitle, lastpostdateline, styleoverride
			FROM " . TABLE_PREFIX ."ppgal_categories
			ORDER BY $ppg_options[gallery_catsorderby] $ppg_options[gallery_catsdirection]
	");
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		if ($categories['parent'] AND !$categorycache["$categories[parent]"]['active'])
		{
			$categorycache["$categories[catid]"]['active'] = 0;
			continue;
		}
		if ($categoryperms["$categories[catid]"]['canviewimages'] OR $ppg_options['gallery_showimagecount'])
		{
			$stats['categories']++;
			$stats['images'] += $categories['imagecount'];
			$stats['posts'] += $categories['postcount'];

			$categorycache["$categories[catid]"]['description'] = $categories['description'];
			$categorycache["$categories[catid]"]['catimage'] = $categories['catimage'];

			if ($categories['lastimagedateline'] > $categorycache["$categories[catid]"]['lastimagedateline'])
			{
				$categorycache["$categories[catid]"]['lastimagedateline'] = $categories['lastimagedateline'];
				$categorycache["$categories[catid]"]['lastimagetitle'] = $categories['lastimagetitle'];
				$categorycache["$categories[catid]"]['lastimageid'] = $categories['lastimageid'];
				$categorycache["$categories[catid]"]['lastimageusername'] = $categories['lastimageusername'];
				$categorycache["$categories[catid]"]['lastimageuserid'] = $categories['lastimageuserid'];
			}
			if ($categories['lastpostdateline'] > $categorycache["$categories[catid]"]['lastpostdateline'])
			{
				$categorycache["$categories[catid]"]['lastpostdateline'] = $categories['lastpostdateline'];
				$categorycache["$categories[catid]"]['lastpostimagetitle'] = $categories['lastpostimagetitle'];
				$categorycache["$categories[catid]"]['lastpostid'] = $categories['lastpostid'];
				$categorycache["$categories[catid]"]['lastpostusername'] = $categories['lastpostusername'];
				$categorycache["$categories[catid]"]['lastpostuserid'] = $categories['lastpostuserid'];
			}

			if ($categorycache["$categories[catid]"]['level'] >= $ppg_options['gallery_catdepth'] AND $ppg_options['gallery_showsubcats'])
			{
				$categorycache["$categories[parent]"]['subcats']["$categories[catid]"]['title'] = $categories['title'];
				$categorycache["$categories[parent]"]['subcats']["$categories[catid]"]['lastimagedateline'] = $categories['lastimagedateline'];
				$categorycache["$categories[parent]"]['subcats']["$categories[catid]"]['lastpostdateline'] = $categories['lastpostdateline'];
			}

			if ($categories['parentlist'])
			{
				foreach (explode(',', $categories['parentlist']) AS $parid)
				{
					$categorycache["$parid"]['imagecount'] += $categories['imagecount'];
					$categorycache["$parid"]['postcount'] += $categories['postcount'];

					if ($categories['lastimagedateline'] > $categorycache["$parid"]['lastimagedateline'])
					{
						$categorycache["$parid"]['lastimagedateline'] = $categories['lastimagedateline'];
						$categorycache["$parid"]['lastimagetitle'] = $categories['lastimagetitle'];
						$categorycache["$parid"]['lastimageid'] = $categories['lastimageid'];
						$categorycache["$parid"]['lastimageusername'] = $categories['lastimageusername'];
						$categorycache["$parid"]['lastimageuserid'] = $categories['lastimageuserid'];
					}

					if ($categories['lastpostdateline'] > $categorycache["$parid"]['lastpostdateline'])
					{
						$categorycache["$parid"]['lastpostdateline'] = $categories['lastpostdateline'];
						$categorycache["$parid"]['lastpostimagetitle'] = $categories['lastpostimagetitle'];
						$categorycache["$parid"]['lastpostid'] = $categories['lastpostid'];
						$categorycache["$parid"]['lastpostusername'] = $categories['lastpostusername'];
						$categorycache["$parid"]['lastpostuserid'] = $categories['lastpostuserid'];
					}
				}
			}
		}
	}
	$db->free_result($getcats);
	unset($categories);
}

if ($ppg_options['gallery_allowreplies'])
{
	$show['replycells'] = true;
	$ppg_options['alt_imagecount'] = 'alt2';
	$ppg_options['alt_moderator'] = 'alt2';
	
}
else
{
	$ppg_options['alt_imagecount'] = 'alt1';
	$ppg_options['alt_moderator'] = 'alt2';
}

$ppg_options['gallery_catdepth'] = $ppg_options['gallery_catdepth_index'];

// Print the categories
// changes from 2.5

// globalize so we can populate in print categories..
global $metabits; $metabits = array();global $thiscat_description; $thiscat_description = ''; $thiscat_description_clean = '';

$categorybits = print_categories(intval($catid), iif(!intval($catid), $categorycache));

require_once(DIR . '/includes/functions_bigthree.php');

$ignusers = fetch_ignored_users();

if ($ignusers)
{
	$ignquery = 'AND images.userid NOT IN(' . $ignusers . ')';
}


if (!$catid)
{
	
	// cant remember what this was for.. (but i added it) remove if dummy
	$show['taglevel'] = true;

	// these are needed
	$show['subcats'] = false;
	$show['directoryhead'] = true;

	$show['category'] = iif($showfields['category'], true, false);

	if ($ppg_options['gallery_newhomeimages'] OR $ppg_options['gallery_randomhomeimages'])
	{
		include_once('./includes/class_bbcode.php');

		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());

		$query = fetch_image_fields();
		$cellwidth = round(100 / $ppg_options['gallery_columns']) . '%';
		// for tablefree, cellwidth calc goes here...


		if ($privatecatids = fetch_private_categories())
		{
			$privatecatids = explode(',', $privatecatids);
		}

		if ($ppg_options['gallery_homeexcats'])
        {
            $ppg_options['gallery_homeexcats'] = explode(',', $ppg_options['gallery_homeexcats']);
            if(empty($privatecatids))
            {
                $privatecatids = $ppg_options['gallery_homeexcats'];
            }
            else
            {
                $privatecatids = array_merge((array)$privatecatids, (array)$ppg_options['gallery_homeexcats']);
            }
        }

		if (!empty($privatecatids))
		{
			$privcatids = 'images.catid NOT IN(' . implode(',', $privatecatids) . ') AND ';
		}
	}

	// ### Get active users browsing #################################################
	$activeusers = '';

	if (($ppg_options['gallery_displayloggedin'] == 1 OR $ppg_options['gallery_displayloggedin'] == 2 OR ($ppg_options['gallery_displayloggedin'] > 2 AND $vbulletin->userinfo['userid'])) AND !$show['search_engine'])
	{
		$datecut = TIMENOW - $vbulletin->options['cookietimeout'];
		$show['activeusers'] = iif(!$show['search_engine'], true, false);

		// Don't put the ingallery value in the WHERE clause as it might not be the newest location!
		$imageusers = $db->query_read_slave("
			SELECT
				user.username, (user.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible, user.usergroupid,
				session.userid, session.badlocation, session.inforum, session.lastactivity,
				IF(displaygroupid=0, user.usergroupid, displaygroupid) AS displaygroupid, infractiongroupid
			FROM " . TABLE_PREFIX . "session AS session
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = session.userid)
			WHERE session.lastactivity > $datecut " . iif($ppg_options['gallery_displayloggedin_local'] == 1, "AND badlocation ='600'") . "
			" . iif($ppg_options['gallery_displayloggedin'] == 1 OR $ppg_options['gallery_displayloggedin'] == 3, "ORDER BY username ASC") . "
		");
		$numbervisible = 0;
		$numberguest = 0;
		$numberregistered = 0;
		$doneuser = array();
		$show['comma_leader'] = false; // we need it, cause it was set to true by categorybits
		if ($vbulletin->userinfo['userid'])
		{
			$vbulletin->userinfo['joingroupid'] = iif($vbulletin->userinfo['displaygroupid'], $vbulletin->userinfo['displaygroupid'], $vbulletin->userinfo['usergroupid']);
			$loggedin = array(
				'userid' => $vbulletin->userinfo['userid'],
				'username' => $vbulletin->userinfo['username'],
				'invisible' => $vbulletin->userinfo['invisible'],
				'invisiblemark' => $vbulletin->userinfo['invisiblemark'],
				'inforum' => 0,
				'lastactivity' => TIMENOW,
				'musername' => fetch_musername($vbulletin->userinfo, 'joingroupid'),
				'lastvisit'         => $vbulletin->userinfo['lastvisit'],
				'usergroupid'       => $vbulletin->userinfo['usergroupid'],
				'displaygroupid'    => $vbulletin->userinfo['displaygroupid'],
				'infractiongroupid' => $vbulletin->userinfo['infractiongroupid'],
			);
			$numberregistered = 1;
			$numbervisible = 1;
			fetch_online_status($loggedin);
			$templater = vB_Template::create('adv_gallery_home_loggedinuser');
			$templater->register('loggedin', $loggedin);
			$activeusers = $templater->render();
			$doneuser["{$vbulletin->userinfo['userid']}"] = 1;
		}

		// OLD COMMENT: this requires the query to have lastactivity ordered by DESC so that the latest location will be the first encountered.
		// NEW COMMENT: I think we should check that out...



		while ($loggedin = $db->fetch_array($imageusers))
		{
			if (empty($doneuser["$loggedin[userid]"]))
			{
				if ($loggedin['userid'] == 0) // Guest
				{
					$numberguest++;
				}
				else
				{
					$loggedin['musername'] = fetch_musername($loggedin);
					$numberregistered++;

					if (fetch_online_status($loggedin))
					{
						$show['comma_leader'] = ($activeusers != '');
						$templater = vB_Template::create('adv_gallery_home_loggedinuser');
						$templater->register('loggedin', $loggedin);
						$activeusers .= $templater->render();
					}
				}
				if ($loggedin['userid'])
				{
					$doneuser["$loggedin[userid]"] = 1;
				}
			}
		}

		if (!$vbulletin->userinfo['userid'])
		{
			$numberguest = ($numberguest == 0) ? 1 : $numberguest;
			if ($numberregistered == 0)
			{
				$activeusers = '&nbsp;';
			}
		}

		$totalonline = $numberregistered + $numberguest;

		$db->free_result($imageusers);
		unset($userinfos, $userid, $userinfo, $loggedin, $imageusers, $datecut);
	}

	/* ##############  Newest image block ################################# */
	// TODO : store the X newest images imageinfo in datastore.. so we dont need a query here..
	// this will not be possible with random images, but we can counteract this.. by putting the sticky images in datastore
	// and getting them randomly.. todo -> next version

	if ($ppg_options['gallery_newhomeimages'])
	{
       ($hook = vBulletinHook::fetch_hook('ppgal_home_newimages_query')) ? eval($hook) : false;

        $newhomeimages_datecut = TIMENOW - (86400*$ppg_options['gallery_newhomecutoff']);

		$show['newimages'] = true;
		$counter = 0;
		$adv_sorturl = '&amp;catid=newimages';
		$getnew = $db->query_read("
				SELECT imageid, images.title, filename, thumbname, originalname, extension, images.catid $query[fields]
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				$query[tables]
				WHERE $privcatids valid = 1 $ignquery
" . iif(!empty($ppg_options['gallery_newhomecutoff']), "AND dateline >= $newhomeimages_datecut") . "
                ORDER BY dateline DESC
				LIMIT $ppg_options[gallery_newhomeimages]
		");

		
		if ($db->num_rows($getnew))
		{
			while ($images = $vbulletin->db->fetch_array($getnew))
			{
				$counter++;
				$newimagebits .= construct_imagebits($images, '', 'block');
			}

			if ($ppg_options['gallery_newhomeimages'] >= $ppg_options['gallery_columns'])
            {
                $newimagebits .= construct_empty_cellbits($ppg_options['gallery_columns']);
            }
		}
		else
		{
			$templater = vB_Template::create('adv_gallery_nodisplay');
			$newimagebits = $templater->render();
		}
		$db->free_result($getnew);
		unset($images);
		
		$ppg_vars['gallery_columns'] = $ppg_options['gallery_columns'];
		$ppg_vars['gallery_newhomeimages'] = $ppg_options['gallery_newhomeimages'];

  		$templater = vB_Template::create('adv_gallery_newimages');
		
		$templater->register('ppg_vars', $ppg_vars);
		$templater->register('cellwidth', $cellwidth);
		$templater->register('newimagebits', $newimagebits);

		$template_hook['galleryhome_'. $newhomepos] .= $templater->render();
		unset($newimagebits);
		// old with str_replace in templatecache (yuck !!)
//		$search_text = $newhomepos;
//		$vbulletin->templatecache['ADV_GALLERY'] = str_replace($search_text,
//		$search_text.fetch_template('adv_gallery_newimages'),$vbulletin->templatecache['ADV_GALLERY']);


    }

/* ##############  Random image block ################################# */	
	

	if ($ppg_options['gallery_randomhomeimages'])
	{
       ($hook = vBulletinHook::fetch_hook('ppgal_home_randimages_query')) ? eval($hook) : false;

       $randomhomeimages_datecut = TIMENOW - (86400*$ppg_options['gallery_randomhomecutoff']);

        $show['randomimages'] = true;
		$counter = 0;
		$getrand = $db->query_read("
				SELECT imageid, images.title, filename, thumbname, originalname, extension, images.catid $query[fields]
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				$query[tables]
				WHERE $privcatids valid = 1 $ignquery
" . iif(!empty($ppg_options['gallery_randomhomecutoff']), "AND dateline >= $randomhomeimages_datecut") . "
                ORDER BY RAND()
				LIMIT $ppg_options[gallery_randomhomeimages]
		");
		if ($db->num_rows($getrand))
		{
			while ($images = $vbulletin->db->fetch_array($getrand))
			{
				$counter++;
				$adv_sorturl = '&amp;catid=' . $images['catid'];
				$randomimagebits .= construct_imagebits($images, '', 'block');
			}
			if ($ppg_options['gallery_randomhomeimages'] >= $ppg_options['gallery_columns'])
            {
                $randomimagebits .= construct_empty_cellbits($ppg_options['gallery_columns']);
            }
		}
		else
		{
			$templater = vB_Template::create('adv_gallery_nodisplay');
			$randomimagebits = $templater->render();
		//	eval('$randomimagebits = "' . fetch_template('adv_gallery_nodisplay') . '";');
		}
		$db->free_result($getrand);
		unset($images);
		$ppg_vars['gallery_columns'] = $ppg_options['gallery_columns'];
		
	
		$templater = vB_Template::create('adv_gallery_randomimages');
		
		$templater->register('ppg_vars', $ppg_vars);
		$templater->register('cellwidth', $cellwidth);
		$templater->register('randomimagebits', $randomimagebits);

		$template_hook['galleryhome_'. $ranhomepos] .=  $templater->render();

    }



/* ##############  Sticky - Showcase image block ################################# */
// will be done in 3.2

	 
/* ##############  Meta Keywords and Description ################################# */

// start building Multilanguage compatiple metakeywords and meta description...
// using vbchop and vbstrlen to support foreign chars
	$metakeyw = '';	
	$metadesc = '';
// prepare metatags
 
 	foreach ($categorycache AS $navcat)
	{
		$metakeyw .= ',' . $navcat['title_clean'];
		$metadesc .=  $navcat['title_clean'] . ', ';
		if(!empty($navcat['lastimagetitle']) AND $navcat['lastimagetitle'] != '')
		{
		   $metakeyw .= ',' . $navcat['lastimagetitle'];
		}
		if(!empty($navcat['description']) AND $navcat['description'] != '')
		{
		   $metadesc .= vbchop($navcat['description'], 80) . '... ';
		}
		if(vbstrlen($metakeyw)>300 AND vbstrlen($metadesc)>600){
			break;
		}
	}
// end of prepare metatags
	
	$navbits[''] = $vbphrase['gallery'];
	$navbits = construct_navbits($navbits);
	$pagetitle = false;

} // end if(!$catid)
else
{
	// we have a catid !!!
	$show['subcats'] = true;
	$show['taglevel'] = false;
	/* ##############  Get cat description as we dont have it in datastore ##### */
	
	if(trim($thiscat_description) == '')
	{
		if(intval($catid)>0)
		{
			$thiscat = $db->query_first("
				SELECT description, description_clean
				FROM " . TABLE_PREFIX . "ppgal_categories 
				WHERE catid = '$catid'
			");
		}
	}
	else
	{
		$thiscat = array();
		$thiscat['description'] = $thiscat_description;
		$thiscat['description_clean'] = $thiscat_description_clean;
	}



// build navcats !!! including metatags
	$metakeyw = '';	
	$metadesc = '';

	foreach ($categorycache AS $navcat)
	{
 		$metakeyw .= ',' . $navcat['title_clean'];
		
		if ($navcat['catid'] == $catid)
		{
			$navinfo['title'] = stripslashes($navcat['title']);
			$navinfo['parentlist'] = $navcat['parentlist'];
			$parent_catid = $navcat['parent'];
			$navinfo['title_clean'] = $navcat['title_clean'];
		}
		
		if(!empty($navcat['lastimagetitle']) AND $navcat['lastimagetitle'] != '')
		{
		   $metakeyw .= ',' . $navcat['lastimagetitle'];
		}
	}					  

	$pagetitle = $navinfo['title'];
	$metakeyw_raw = htmlspecialchars_uni(strip_tags(stripslashes($metakeyw_raw )));

	$ppg_options['nav_gallery_url']	  =  $ppg_options['gallery_url'] . '/index.php' .  $vbulletin->session->vars['sessionurl_q'];
	$navbits["$ppg_options[nav_gallery_url]"] = $vbphrase['gallery'];

	$navbits = construct_dir_navbits($navinfo['parentlist']);
//	print_r($navbits);exit;
//	Array ( [http://localhost/vb4test/gallery/index.php] => Gallery [browseimages.php?c=5] => Main test Category )
	$navbits = construct_navbits($navbits);



	/* ##############  4.0 Category Jump ################################# */
	$navpopup = array(
		'id'    => 'index_navpopup',
		'title' => $navinfo['title_clean'],
		'link'  => 'index.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $catid
	);
	$categoryjump = ($ppg_options['gallery_enablecatjump']) ? print_galquick_jump($navpopup) : '';
	/* ##############  /4.0 Category Jump ################################# */


	
} // end else of if(!$catid)



/* ### Finish redering  navbar */
$templater = vB_Template::create('navbar');
$navbar = $templater->render();
$navbar = render_navbar_template($navbits);
	

if ($ppg_options['gallery_showstats'])
{
	$stats['images'] = vb_number_format($maximages);
	$stats['views'] = vb_number_format($maxviews);
	// what was following line for??????? remove if not used
	$totalcache['categories'] = vb_number_format($maxcategories);
	$stats['cards'] = vb_number_format($maxcards);
	$stats['posts'] = vb_number_format($maxposts);
	$stats['diskspace'] = vb_number_format($maxfilesize + $maxorigfilesize, 1, true);
	$stats['categories'] = $totalcache['categories'];
	$show['stats'] = true;
}	
  

if ($ppg_options['gallery_navbarhomelink'])
{
	// not needed as the little house always goes home...
	// we could use this setting for logo link... OR maybe for forum only users....
}



if($ppgal_announcement)
{
	$navbar = $navbar . $ppgal_announcement;
}

// we need the sessionurl on wol link
$wollink = 	 $vbulletin->options['bburl'] . '/online.php' . $vbulletin->session->vars['sessionurl_q'];

// populate $ppg_vars // so we save mem .. no need to register $ppg_options and other single vars!!
// todo.. move all other small vars (not arrays) to $ppg_vars

// construct pagetitle
if($show['subcats'])
{
	$ppg_vars['topcategory_desc'] = '';
	$ppg_vars['gallery_title'] = $pagetitle;
	$ppg_vars['gallery_titletag'] = htmlspecialchars_uni(strip_tags($pagetitle . ' - ' . $ppg_options['gallery_title']));
	$ppg_vars['meta_gallery_title'] = $ppg_options['gallery_title'] . ',' . $pagetitle; 
	if(trim($thiscat['description']))
	{
		$ppg_vars['topcategory_desc'] = $thiscat['description_clean'];
		// activate smilies

		require_once(DIR . '/includes/functions_wysiwyg.php');
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
		$ppg_vars['topcategory_desc'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($ppg_vars['topcategory_desc']));
	}
	// construct parent arrow link
	if(intval($parent_catid)>0)
	{
		$ppg_vars['gallery_parent_url'] = $ppg_options['gallery_url'] . '/index.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . intval($parent_catid);
	}
	else
	{
		$ppg_vars['gallery_parent_url'] = $ppg_options['gallery_url'] . '/index.php' . $vbulletin->session->vars['sessionurl_q'];
	}
	// get metatag params
	$ppg_vars['meta_gallery_desc'] = construct_phrase($vbphrase['welcome_to_the_x'], $ppg_vars['gallery_title']) . ' ' . $ppg_vars['topcategory_desc'] . '. '. $vbphrase['categories'] . ': ';
 
	if(!empty($metabits))
	{
		$metadesc =  ' ';
	   foreach($metabits AS $metabit)
		{

		  $metadesc .=  $metabit['title'] . ' - ' . $metabit['description'];
		  if(!empty($metabit['lastimagetitle']))
			{

				 $metadesc .=  ' (' . $metabit['lastimagetitle'] . '). ';
			}
			else
			{
				$metadesc .=  '. ';
			}

		}
		unset($metabit);
		
	}
}
else
{
	$ppg_vars['gallery_title'] = $ppg_options['gallery_title'];
	$ppg_vars['gallery_titletag'] = htmlspecialchars_uni($ppg_options['gallery_title']); 
	$ppg_vars['meta_gallery_title'] = $ppg_options['gallery_title'];
	$ppg_vars['meta_gallery_desc'] = construct_phrase($vbphrase['welcome_to_the_x'], $ppg_options['gallery_title']) . ' ';
}
// todo Redo title stuff for metatags !!!




($hook = vBulletinHook::fetch_hook('ppgal_home_complete')) ? eval($hook) : false;

// ########### Finish Metatags ##################
$headinclude = construct_metatags($headinclude, $metakeyw, $metadesc);

$ppg_vars['gallery_showonoff'] =  $ppg_options['gallery_showonoff'];
$ppg_vars['gallery_allowreplies'] = $ppg_options['gallery_allowreplies'];


$show['gallery_stats_active'] = $ppg_options['gallery_stats_active'];
$show['gallery_allowreplies'] = $ppg_options['gallery_allowreplies'];

// #################################################
// ########### Print out templates #################
// #################################################

$templater = vB_Template::create('ADV_GALLERY');
	$templater->register_page_templates();
	// is registering template hooks necessary??????
	$templater->register('template_hook', $template_hook);
	
	$templater->register('navbar', $navbar);
		
	$templater->register('categorybits', $categorybits);
	$templater->register('stats', $stats);
	$templater->register('ppg_vars', $ppg_vars);

	if($show['subcats'])
	{
		// register vars for index category page only (not for homepage)
		$templater->register('categoryjump', $categoryjump);
	}
	else
	{ 
		// register vars for index only (not for category page)
		$templater->register('wollink', $wollink);
		$templater->register('totalonline', $totalonline);
		$templater->register('numberregistered', $numberregistered);
		$templater->register('numberguest', $numberguest);
		$templater->register('activeusers', $activeusers);
	}

print_output($templater->render());
exit; // not needed but...
?>