<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: gallery_global.php                                               ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/


// ####################### SET PHP ENVIRONMENT ###########################


error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('PP_SCRIPT', 'vBGallery');
define('VB_AREA', 'vBGallery');
if(!defined('THIS_SCRIPT')){exit;}
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array_merge(array('adv_gallery'), (array)$phrasegroups);

// get special data templates from the datastore
// removed adv_gallery_opt. they are loaded in main plugin Fetch Datastore.. 'adv_gallery_opt'
$specialtemplates = array_merge(
	array(
		'gallery_c_cache',
		'gal_mod_cache',
		
		'gallery_ugroups',
        'ppg_stats'
	),
	(array)$specialtemplates
);

// pre-cache templates used by all actions

 
$globaltemplates = array_merge(
	array(
        'adv_gallery_announcement',
        'adv_gallery_navbar',
		'adv_gallery_categoryjump',
		'adv_gallery_footer',
		'adv_gallery_navbar_newestbits' 
	),
	(array)$globaltemplates
);

// we do not need replacements and extra stuff when we load popups
// so we define LITEPAGE for those pages
// TODO: skip replacements and breadcrumb stuff for those pages
// skip css include for those pages.. (add adv_gallery_lite.css instead)


/* ################################### */
/* ##### Pre CSS stuff ############### */
/* ################################### */

// the base gallery css is adv_gallery.css
// we define it so it cant be changed by plugin from 3rd party etc...
define('MAINGALCSS', 'adv_gallery.css');
define('LITECSS', 'adv_gallery_lite.css');
// declare pages where extra css is needed (a template must exist..starting with adv_gallery)
$ppg_extra_css = array('gallery_index','gallery_upload', 'browseimages', 'showimage', 'showimage_inlinemod', 'gallery_newreply', 'editimage', 'gallery_search', 'gallery_misc', 'gallery_stats', 'gallery_managecats');
if(in_array(THIS_SCRIPT, $ppg_extra_css))
{
	$extra_css = (strpos(THIS_SCRIPT, "gallery") !== false) ? 'adv_' . THIS_SCRIPT . '.css' : 'adv_gallery_' . THIS_SCRIPT . '.css';
	define('EXTRAGALCSS', $extra_css);
}
$ppg_extra_css = array('gallery_search', 'gallery_stats','gallery_upload','showimage','editimage');
if(in_array(THIS_SCRIPT, $ppg_extra_css))
{
	$sidebar_css = (strpos(THIS_SCRIPT, "gallery") !== false) ? 'adv_' . THIS_SCRIPT . '_sidebar.css' : 'adv_gallery_' . THIS_SCRIPT . '_sidebar.css';
	define('SIDEBARCSS', $sidebar_css);
}
unset($ppg_extra_css,$sidebar_css,$extra_css);
// add pagespecific css file at bottom of this file
// TODO: once gallery finished remove css templates that are not needed 

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_config.php');
chdir($forumpath);
require_once('./global.php');

//display_errors = off
// before functions...
if ($redirect) {header("Location: $redirect");	exit; }

// if product is disabled.. do not go further...

if(!$vbulletin->products['ppvbgallery'])
{
	eval(standard_error('Product vBGallery is not active - <a href="'.$vbulletin->options['bburl'].'/'. $vbulletin->session->vars['sessionurl_q'] .'">'.$vbulletin->options['bbtitle'].'</a>'));
}

require_once(DIR . '/includes/functions_gallery.php');
				
// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

define('NOROBOTS', '<meta name="robots" content="noindex,nofollow" />');


// basics vbstuff
// we turn external rss off in gallery.. we will add a gallery_externalrss later sometime..
$vbulletin->options['externalrss'] = 0;
$vbulletin->options['useforumjump'] = false;
// optional phrase replacements

// dropdown still has a bug with guest pm.. if you didnt set pmquota to 0 for guests (or the user didnt disable the pms) the pm link will appear..
// can be removed when fixed by vb
if(!$vbulletin->userinfo['userid'] AND  $vbulletin->userinfo['permissions']['pmquota']>0)
{
	$vbulletin->userinfo['permissions']['pmquota'] = 0;
}
// declare template var
// ppg_vars is used for small vars in templates.. so we dont have to declare 20 or 30 small single vars
// example: if you only need 2 elements from ppg_options and 10 or 12 small others vars.. ppg_vars is declared for templates containing all of them
// no need to declare all of ppg_options if you only need 1 true or false...
// DO NOT ADD ARRAYS TO $ppg_vars!!!
global $ppg_vars;
$ppg_vars = array();

// Datastore stuff

// Set Options Array
$ppg_options =& $vbulletin->adv_gallery_opt;
unset($vbulletin->adv_gallery_opt);
// Set Permissions Array
$gallery_permissions =& $vbulletin->gallery_ugroups;
unset($vbulletin->gallery_ugroups);
// Set Stats Array
$totalcache =& $vbulletin->ppg_stats;
unset($vbulletin->ppg_stats);


// todo: get newest images and sticky images  from datastore
// will be there as soon as we get everything else running
// advantage.. no queries and can be shown on every page...
// only random images get pulled from database
// saves at least 1 query on index and on every page where they are needed
// other idea.. add the users newest images to a cache in his userinfo.. for profile and blog display...

// globalize gallery title (no declaration needed)
 $vbphrase['gallery_title'] = $ppg_options['gallery_title'];

// ######################## Gallery Permissions #########################
$vbulletin->userinfo['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

if (empty($vbulletin->userinfo['usergrouparray']))
{
	$vbulletin->userinfo['usergrouparray'] = array(1);
}

foreach ($vbulletin->userinfo['usergrouparray'] AS $usergroupid)
{
	if (empty($gallery_permissions["$usergroupid"]))
	{
		$usergroupid = 1;
	}

	foreach ($gallerypermissionsbit AS $option => $value)
	{
		if (in_array($option, array('moderateimages', 'moderateposts')) AND $galleryperms["$option"] == 0 AND isset($galleryperms["$option"]))
		{
			continue;
		}
		if (!$galleryperms["$option"] OR in_array($option, array('moderateimages', 'moderateposts')))
		{
			$galleryperms["$option"] = 0;
			if ($gallery_permissions["$usergroupid"]['gallery_perms'] & $value)
			{
				$galleryperms["$option"] = 1;
			}
		}
	}

	foreach ($gallery_permissions["$usergroupid"] AS $option => $value)
	{
		if (($option == 'gallery_maxcats' AND !($gallery_permissions["$usergroupid"]['gallery_perms'] & $gallerypermissionsbit['cancreatecategories'])) OR ($option == 'gallery_maxdiskspace' AND !($gallery_permissions["$usergroupid"]['gallery_perms'] & $gallerypermissionsbit['canuploadimages'])))
		{
			continue;
		}
		if (((($value > $galleryperms["$option"] AND $galleryperms["$option"] != '0') OR !$value) AND $option != 'gallery_perms'))
		{
			$galleryperms["$option"] = $value;
		}
	}
}
//print "<pre>";print_r($galleryperms);exit;
// TODO Clean files using gallery global... sometimes we fetch perms a second time...!!!!!
// Check main permissions
if (!$galleryperms['canviewgallery'])
{
	print_no_permission();
}

// ######################## Gallery ON / OFF #########################
// we cannot display now.. because templates are not there yet .. so we define ADMIN WARNING...
if (!$ppg_options['gallery_active'])
{
	if (($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
	{
		define(ADMIN_WARNING,true);
	}
	else
	{
		eval(standard_error($ppg_options['gallery_closedmessage']));
	}
}

// ############################### Common Globals #############################
$imageid = $vbulletin->input->clean_gpc('r', 'imageid', TYPE_INT);
$i = $vbulletin->input->clean_gpc('r', 'i', TYPE_INT);

if (!isset($_POST['catid']))
{
	$catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_NOHTML);
	$c = $vbulletin->input->clean_gpc('r', 'c', TYPE_NOHTML);
}

if (isset($i) AND $i != 0)
{
	$imageid = $i;
}
if ($c)
{
	$catid = $c;
}

$categorycache =& $vbulletin->gallery_c_cache;
unset($vbulletin->gallery_c_cache);

// ########################### Show Variables #################################
// check if blog is installed !!!! 
$show['isuserblog'] = $vbulletin->products['vbblog'];

if ($ppg_options['gallery_showstats']){	$show['stats'] = true;}

if ($galleryperms['cansearchimages']){$show['search'] = true;}
if ($galleryperms['cansendimagetofriend']){	$show['sendtofriend'] = true;}
if ($ppg_options['gallery_showmodcolumn']){	$show['modcolumn'] = true;}
if ($ppg_options['gallery_allowsubscribe'] AND $vbulletin->userinfo['userid']){ $show['subscribe'] = true;}
if ($ppg_options['gallery_allowfav'] AND $vbulletin->userinfo['userid']){$show['favorites'] = true;}
if ($galleryperms['cancreatecategories']){$show['catmanager'] = true;}
if ($ppg_options['gallery_showcatdesc'] AND in_array(THIS_SCRIPT, array('showimage', 'browseimages')))
{
	$show['catdesc'] = true;
}

$gallery_modcache =& $vbulletin->gal_mod_cache;
//unset($vbulletin->gal_mod_cache); not possible

if ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
{
	$show['modoptions'] = true;
}
else if (!empty($gallery_modcache))
{
	foreach ($gallery_modcache AS $moderator)
	{
		if ($moderator['userid'] == $vbulletin->userinfo['userid'])
		{
			$show['modoptions'] = true;
		}
	}
}

// ######################### Gallery Stats ##############################
// TODO only get stats if displayed on page.. IF THIS SCRIPT clause...
$total = array();
foreach ($totalcache AS $totals)
{
	$total[] = $totals;
}
$maximages = $total['0']['images'];
$maxviews = $total['0']['views'];
$maxposts = $total['0']['posts'];
$maxfilesize = $total['0']['filesize'];
$maxorigfilesize = $total['0']['origfilesize'];
$maxcategories = $total['1']['categories'];
$maxmembercat = $total['1']['membercat'];
$maxcards = $total['2']['cards'];
unset($total, $totalcache);

// start hook, after permission check before replacements
($hook = vBulletinHook::fetch_hook('ppgal_galleryglobal_start')) ? eval($hook) : false;
													 
// ######################### Replacements ##############################

 // ATTENTION header, footer, and headinclude only seem to be there AFTER first template has started to render..
// so we render the copyright footer first.. if its removed.. the replacement will not be done correctly ;-)
// as they are not rendered... we can declare them here
$replacement_list = array();
$headinclude = '';
$headinclude_bottom = '';
$header = '';
$footer = '';


// ###################### replace smileys if needed  ###################

if(is_array($vbulletin->smiliecache) AND !empty($vbulletin->smiliecache))
{
	foreach($vbulletin->smiliecache AS $a => $b)
	{
		if(strpos($vbulletin->smiliecache[$a]['smiliepath'], "http://") === false)
		{
			$vbulletin->smiliecache[$a]['smiliepath'] = $vbulletin->options['bburl'] . '/' . $vbulletin->smiliecache[$a]['smiliepath'];
		}
	}
	unset($a,$b);
}



// footer PRE-replacements... (as template has not been rendered yet !!!)

// logo with homelink replacements ... only works if you respected the vbulletin template coding...
//	<div><a name="top" href="{vb:raw vboptions.forumhome}.php{vb:raw session.sessionurl_q}" class="logo-image"><img src="{vb:stylevar titleimage}" alt="{vb:rawphrase x_powered_by_vbulletin, {vb:raw vboptions.bbtitle}}" /></a></div>

$tmp_vars = array();
$tmp_vars['forumhome'] = $vbulletin->options['forumhome'];

$ppg_vars['titleclass'] = ($ppg_options['layout_page_title'] == 1)? 'blogtitle' : (($ppg_options['layout_page_title'] == 2) ? 'cmstitle' : 'forumtitle');

// we calculate the class for the pagetitle as we are on index.php
if($ppg_options['layout_index_title']>0 AND THIS_SCRIPT == 'gallery_index')
{
	$ppg_vars['titleclass'] = ($ppg_options['layout_index_title'] ==1)? 'forumtitle' :(($ppg_options['layout_index_title'] ==2) ? 'blogtitle' : 'cmstitle');
}


if($vbulletin->stylevars['ppg_title_customstyle']['numeric'] != 1)
{
	if($vbulletin->products['vbcms'])
	{
		$ppg_vars['titleclass'] = $ppg_vars['titleclass'] . ' ppnocustom';
	}
	else if($vbulletin->products['vbblog'])
	{
		$ppg_vars['titleclass'] = $ppg_vars['titleclass'] . ' ppnocustombl';
	}
	else
	{
		$ppg_vars['titleclass'] = $ppg_vars['titleclass'] . ' ppnocustomfo';
	}
}
// ################################ Logo Link replacements ##############################
// if user named his forumhome: 'index' there can be a confusion with gallery 'index'
// but as the system linksback automatically to forum home by default... no need to do anything ;-)

if($tmp_vars['forumhome'] != 'index' AND $ppg_options['layout_gallery_logo_link']>1)
{
	// 0 and 1 not needed as they would redirect automatically to forum home...
	if($ppg_options['layout_gallery_logo_link'] == 2)
	{
	   $vbulletin->options['forumhome'] = $ppg_options['gallery_url'] . '/index';
	}
	else if($ppg_options['layout_gallery_logo_link'] == 3)
	{
		$tmp_vars['slash'] = (substr($vbulletin->options['homeurl'], -1) != '/') ? '/' : '';
		$vbulletin->options['forumhome'] = $vbulletin->options['homeurl'] . $tmp_vars['slash'] . 'index';
	}
}
if($ppg_options['layout_gallery_logo'])
{
	$tmp_vars['old_logophrase'] = construct_phrase($vbphrase['x_powered_by_vbulletin'], $vbulletin->options['bbtitle']);
	$tmp_vars['new_logophrase'] = $ppg_options['gallery_title'] . ' - Powered by Photopost vBGallery';
}
// ################################ Logo File replacements ##############################

if($ppg_options['layout_gallery_logo'])
{
	$vbulletin->stylevars['titleimage']['url'] = $ppg_options['gallery_url'] . '/' . $vbulletin->stylevars['ppg_logo_dir']['url'] . '/' . trim(stripslashes($ppg_options['layout_gallery_logo_file']));
}
else
{
	// check if logo has http://, if yes do nothing, if no, then prefix)
	if(strpos($vbulletin->stylevars['titleimage']['url'], "http://") === false)
	{
		$vbulletin->stylevars['titleimage']['url'] = $vbulletin->options['bburl'] . '/' . $vbulletin->stylevars['titleimage']['url'];
	}
}

// replacement list so that we know what we have replaced..

if(!empty($vbulletin->stylevars['yuipath']['string']) AND strpos($vbulletin->stylevars['yuipath']['string'],'http://')===false){
	$vbulletin->stylevars['yuipath']['string'] = $vbulletin->options['bburl'] . '/' . $vbulletin->stylevars['yuipath']['string'];
}

// prefix the imgdirs in stylevars before parsing..
// the stylevars imagedir_xx will be available in all of vbgallery....

/* ##################################################
/* ############ IMPORTANT TODO ######################
/* ##################################################
*/
/*
!!! Michael... remove the imagedir replacements in installer!!!!
Most of the stuff is done here..




still problems with:
(Hard coded imagefiles in pagenav... will be fixed in 6 months :-0)
see for this: http://www.vbulletin.com/forum/project.php?issueid=32809
For the moment we fix manually in pages only when pagination is called...

*/
/* ##################################################
/* ########### Per style special settings ###########
/* ##################################################
*/

$vbulletin->options['cache'] = TIMENOW;

// vbulletin album style thumbnails

$ppg_vars['albumclass'] = '';
if($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1)
{
	$ppg_vars['albumclass'] = '_alt';
}


$ppg_vars['gridspacing'] = 1;
if($vbulletin->stylevars['ppg_thumb_hidegrid']['numeric'] == 1)
{
	$ppg_vars['hidegridclass'] = ' hidegrid';
	// needed for IE
	$ppg_vars['gridspacing'] = 0;
}

// use forum statusicons

$ppg_options['use_forum_statusicons'] = $vbulletin->stylevars['ppg_use_forum_statusicons']['numeric'];

$imgdirs = array('imgdir_attach','imgdir_button','imgdir_cms','imgdir_editor', 'imgdir_statusicon', 'imgdir_misc','imgdir_polls','imgdir_rating','imgdir_reputation', 'imgdir_searchresults', 'imgdir_siteicons');

for($i=0;$i<count($imgdirs);$i++)
{
	if($imgdirs[$i] == 'imgdir_statusicon' AND !$ppg_options['use_forum_statusicons'])
	{
		$vbulletin->stylevars[$imgdirs[$i]]['imagedir'] = $ppg_options['gallery_url'] . '/' . $vbulletin->stylevars[$imgdirs[$i]]['imagedir'];
	}
	else
	{
		$vbulletin->stylevars[$imgdirs[$i]]['imagedir'] = $vbulletin->options['bburl'] . '/' . $vbulletin->stylevars[$imgdirs[$i]]['imagedir'];
	}
}
unset($imgdirs);


// get vbulletins clear.gif
$vbulletin->options['cleargifurl'] = $vbulletin->options['bburl'] . '/' .$vbulletin->options['cleargifurl'];

// prefix the optionvars before parsing.. if new ones appear.. we can add them here to array
$optvars = array('tosurl','privacyurl','contactuslink','forumhome');

 for($i=0;$i<count($optvars);$i++)
 {
	if(!empty($vbulletin->options[$optvars[$i]]) AND strpos($vbulletin->options[$optvars[$i]],'http://')===false){
		$replacement_list[] = $vbulletin->options[$optvars[$i]];
		$vbulletin->options[$optvars[$i]] = $vbulletin->options['bburl'] . '/' . $vbulletin->options[$optvars[$i]];
	}
 }
 unset($optvars);

/*	######### modcpdir and admincpdir ######  */
 $tmp_vars['tm']=$vbulletin->config['Misc']['modcpdir'];

/*	// leave this comment...
	if You are working on multiple servers.. and admincp is on https server, you would have to change the line below to:
	if(!empty($vbulletin->config['Misc']['modcpdir']) AND (strpos($vbulletin->config['Misc']['modcpdir'],'http://')===false OR strpos($vbulletin->config['Misc']['modcpdir'],'https://')===false)){
	Do the same for admincpdir
*/
if(!empty($vbulletin->config['Misc']['modcpdir']) AND strpos($vbulletin->config['Misc']['modcpdir'],'http://')===false){
	$replacement_list[] = $vbulletin->config['Misc']['modcpdir'];
	$vbulletin->config['Misc']['modcpdir'] = $vbulletin->options['bburl'] . '/' . $vbulletin->config['Misc']['modcpdir'];
}

$tmp_vars['ta']=$vbulletin->config['Misc']['admincpdir'];
if(!empty($vbulletin->config['Misc']['admincpdir']) AND strpos($vbulletin->config['Misc']['admincpdir'],'http://')===false){
	$replacement_list[] = $vbulletin->config['Misc']['admincpdir'];
	$vbulletin->config['Misc']['admincpdir'] = $vbulletin->options['bburl'] . '/' . $vbulletin->config['Misc']['admincpdir'];
}


$cr = "\n";
$css_file = $cr;
$cssstart = '<link rel="stylesheet" type="text/css" href="';

if($vbulletin->options['storecssasfile'])
{
	// TODO when vbulletin has code finished... see details in class_core.php around line 3852
	$vbcsspath = $vbulletin->options['bburl'] . '/clientscript/vbulletin_css/style' . str_pad($style['styleid'], 5, '0', STR_PAD_LEFT) . $vbulletin->stylevars['textdirection']['string'][0] . '/';

	$css_file .= '<link rel="icon" href="' . $ppg_options['gallery_url'] . '/favicon.ico?v='.TIMENOW.'" type="image/x-icon" />' . $cr;
	$css_file .= '<link rel="shortcut icon" href="' . $ppg_options['gallery_url'] . '/favicon.ico?v='.TIMENOW.'" type="image/x-icon" />' . $cr;
	if(!defined('VBGLITE'))
	{
		//main css
		$css_file .= $cssstart . $vbcsspath . MAINGALCSS . '" ' . '/>' . $cr;
		//extra css
		if(defined('EXTRAGALCSS'))
		{
			$css_file .= $cssstart . $vbcsspath . EXTRAGALCSS . '" ' . '/>' . $cr;
		}
		if(defined('SIDEBARCSS'))
		{
			$css_file .= $cssstart . $vbcsspath .SIDEBARCSS . '" ' . '/>' . $cr;
		}
	}
	else
	{
		$css_file .= $cssstart . $vbcsspath . LITECSS . '" ' . '/>' . $cr;
	}
	$template_hook['custom_css_links'] .= $css_file;
}
else
{
	// as the following change on every page... we add them on an extra hook;
	// construct internal css MAINGALCSS and EXTRAGALCSS
	$vbcsspath = $vbulletin->options['bburl'] . '/css.php?styleid=' . $vbulletin->userinfo['styleid'] . '&amp;langid=' . LANGUAGEID . '&amp;d=' . $style['dateline'] . '&amp;td=' . $vbulletin->stylevars['textdirection']['string'] . '&amp;sheet=';
	if(!defined('VBGLITE'))
	{
		$template_hook['custom_css_list'] .= ',' . MAINGALCSS;
		//extra css
		if(defined('EXTRAGALCSS'))
		{
			$css_file .= $cssstart . $vbcsspath . EXTRAGALCSS . '" ' . '/>' . $cr;
		}
		if(defined('SIDEBARCSS'))
		{
			$css_file .= $cssstart . $vbcsspath . SIDEBARCSS . '" ' . '/>' . $cr;
		}
	}
	else
	{
		$css_file .= $cssstart . $vbcsspath . LITECSS . '" ' . '/>' . $cr;
	}
	$template_hook['headinclude_css'] .= $css_file;
}

// add the shortcut icon
$shortcutfile = '<link rel="icon" href="' . $ppg_options['gallery_url'] . '/favicon.ico?v='.TIMENOW.'" type="image/x-icon" />' . $cr;
$shortcutfile .= '<link rel="shortcut icon" href="' . $ppg_options['gallery_url'] . '/favicon.ico?v='.TIMENOW.'" type="image/x-icon" />' . $cr;
$template_hook['headinclude_css'] .= $shortcutfile . gallery_head();




/**** we render first template..  ****/


// speedup for popups.. 
if(defined('VBGLITE'))
{
	// we save mem for popups
	$templater = vB_Template::create('adv_gallery_footer');

	$headinclude = str_replace(array('"css.php','"clientscript/vbulletin_css/style'),array('"'.$ppg_options['gallery_url'] . '/cssdummy.php','"'.$ppg_options['gallery_url'] . '/clientscript/style'),$headinclude);
	$header = '';
	$footer = '';
	$vbulletin->templatecache['navbar'] = '';
	$templater->register('galversion', $ppg_options['gallery_version']);
	$footer = $templater->render() . trim_c(PP_SCRIPT,THIS_SCRIPT); 
}


// ###################### Gallery Navbar ###########################

if ($ppg_options['gallery_newimagelimit'] AND !defined('VBGLITE'))
{
	foreach (explode(',', $ppg_options['gallery_newimagelimit']) AS $ndatecut)
	{
		$show['newimagenav'] = true;
		$dayphrase = construct_phrase($vbphrase['last_x_days'], $ndatecut);

		$templater = vB_Template::create('adv_gallery_navbar_newestbits');
		
		$templater->register('ndatecut', $ndatecut);
		$templater->register('dayphrase', $dayphrase);
		$template_hook['vbg_newimagenavbits'] .= $templater->render();  

		$show['newimagenav'] = false;
		$templater = vB_Template::create('adv_gallery_navbar_newestbits');
		$templater->register('ndatecut', $ndatecut);
		$templater->register('dayphrase', $dayphrase);
		$template_hook['vbg_newpostnavbits'] .= $templater->render();  	
	}

}
// globalize vars using $vbulletin->options with prefix vbg (saves registering)
if(!defined('VBGLITE'))
{	
	
	$vbulletin->options['vbg_popimagelimit'] = $ppg_options['gallery_popimagelimit'];
	$vbulletin->options['vbg_newimagelimit'] = $ppg_options['gallery_newimagelimit'];
	$vbulletin->options['vbg_allowreplies'] = $ppg_options['gallery_allowreplies'];
	$vbulletin->options['vbg_images_popimagelimit'] = $ppg_options['images_popimagelimit'];
	$vbulletin->options['vbg_stats_active'] = $ppg_options['gallery_stats_active'];

// the hidden powered by photopost is also rendered now... ATTENTION we need the trim_c function for that.. I added this function in functions_gallery.php


//print $vbulletin->templatecache['header']; 

	$templater = vB_Template::create('adv_gallery_footer');
	$templater->register('galversion', $ppg_options['gallery_version']);
	$footer = $templater->render() . $footer . trim_c(PP_SCRIPT,THIS_SCRIPT); 


	// hook for populating gallery menu with template_hooks
	($hook = vBulletinHook::fetch_hook('ppgal_galleryglobal_menu')) ? eval($hook) : false;

	/* render gallery navbar menu */
	$templater = vB_Template::create('adv_gallery_navbar');
	$navcatid = intval($catid);
	$templater->register('navcatid', $navcatid);
	$galmenu = $templater->render();

	$template_hook[$vbulletin->options[gallery_menu_hook]] = str_replace('|||XXXPP_GAL_MENUXXX|||', $galmenu, $template_hook[$vbulletin->options[gallery_menu_hook]]);

}
// ##########################################################################			
// ######### Replacements for headinclude, header and footer ################
// ##########################################################################

// add replaced files to array
// we can add any file here... that will be parsed by default
// acp files will only be added if not in here...
// $replacement_list Array has been created before... has already been populated for footer..
// so we do footer replacements FIRST

// ################################ footer Replacements ##############################


$footerreplace = array();

$replacement_list[] = 'profile.php';
$footerreplace['find'][] = '"profile.php';
$footerreplace['replace'][] = '"'.$vbulletin->options['bburl'] . '/profile.php';

// should handle pm popups
$replacement_list[] = 'private.php';
$footerreplace['find'][] = '"private.php';
$footerreplace['replace'][] = '"'.$vbulletin->options['bburl'] . '/private.php';

$replacement_list[] = 'archive';
$replacement_list[] = 'archive/';
$replacement_list[] = 'archive/index.php';
$footerreplace['find'][] = '"archive';
$footerreplace['replace'][] = '"'.$vbulletin->options['bburl'] . '/archive';


$replacement_list[] = 'cron.php';
$footerreplace['find'][] = '"cron.php';
$footerreplace['replace'][] = '"'.$vbulletin->options['bburl'] . '/cron.php';


// now we check if there are any other files added in acp by the user...
$footer_acp_replacearray = array();
$footer_acp_replacearray = explode("\r\n", $ppg_options['gallery_footer_replace']);
if(!empty($footer_acp_replacearray))
{
	foreach($footer_acp_replacearray as $rp)
	{
		if(!in_array($rp, $replacement_list) AND (strpos($rp, "test_") === false))
		{
			if(trim($rp))
			{
				$rp=trim($rp);
				$footerreplace['find'][] = '"' . $rp;
				$footerreplace['replace'][] = '"' . $vbulletin->options['bburl'] . '/'.$rp;
			}
		}
	}
	unset ($rp);
}
$footer = str_replace($footerreplace['find'], $footerreplace['replace'], $footer);
unset($footerreplace, $footer_acp_replacearray, $replacement_list);

// !!! Remove this function construct_replacement_array from gallery_functions.php:
//$footerreplace = construct_replacement_array($footerreplacearray, $footerreplace);

// ##################### headinclude Replacements ##############################


$headinc = array();
// replacements
$headinc['find'][] = 'url(images/';
$headinc['replace'][] = 'url(' . $vbulletin->options['bburl'] . '/images/';
$headinc['find'][] = 'url("images/';
$headinc['replace'][] = 'url("' . $vbulletin->options['bburl'] . '/images/';
$headinc['find'][] = 'url(\'images/';
$headinc['replace'][] = 'url(\'' . $vbulletin->options['bburl'] . '/images/';

$headinc['find'][] = '"css.php?';
$headinc['replace'][] = '"'.$vbulletin->options['bburl'] . '/css.php?';

// there should be NO more clientscript... if it is true.. then we remove these lines..
$headinc['find'][] = '"clientscript/';
$headinc['replace'][] = '"'.$vbulletin->options['bburl'] . '/clientscript/';

$headinc['find'][] = 'name="generator" content="';
$headinc['replace'][] = 'name="generator" content="PhotoPost vBGallery, ';

// replace baseurl
$headinc['find'][] = '<base href="'.$vbulletin->options['bburl'].'/" />';
$headinc['replace'][] = '<base href="'.$ppg_options['gallery_url'].'/" />';

// no need to replace external.php, because it is allready prefixed in vb4 beta AND we disabled it...

$headinclude = str_replace($headinc['find'], $headinc['replace'], $headinclude);
unset($headinc);
// ################################ headerinclude_botttom ##############################

$headinclude_bottom = str_replace(array('"css.php?','"clientscript/'), array('"'.$vbulletin->options['bburl'] . '/css.php?', '"'.$vbulletin->options['bburl'] . '/clientscript/'), $headinclude_bottom);

// ################################ header and navbar Replacements ##############################
// we use the same array names as above

$headerfile = array();

$headerfile['find'][] = '"private.php';
$headerfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/private.php';

$headerfile['find'][] = '"usercp.php';
$headerfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/usercp.php';

$headerfile['find'][] = '"register.php';
$headerfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/register.php';

$headerfile['find'][] = '"login.php';
$headerfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/login.php';

$headerfile['find'][] = '"faq.php';
$headerfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/faq.php';

$headerfile['find'][] = '"member.php';
$headerfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/member.php';

$replacement_list[] = '"clientscript';
$headerfile['find'][] = '"clientscript';
$headerfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/clientscript';

$headerfile['find'][] = '"images/';
$headerfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/images/';

// this is just for the main logo... at first run..
// when user renames his logo and edits template.. then there is no remplacement..
if($ppg_options['layout_gallery_logo'])
{
	$headerfile['find'][] = '"'.$tmp_vars['old_logophrase'];
	$headerfile['replace'][] = '"'.$tmp_vars['new_logophrase'];
}

// now we check if there are any other files added in acp by the user...
$header_acp_replacearray = array();
$header_acp_replacearray = explode("\r\n", $ppg_options['gallery_header_replace']);
if(!empty($header_acp_replacearray))
{
	foreach($header_acp_replacearray as $rp)
	{
		if(!in_array($rp, $headerfile['find']) AND (strpos($rp, "test_") === false))
		{
			if(trim($rp))
			{
				$rp=trim($rp);
				$headerfile['find'][] = '"' . $rp;
				$headerfile['replace'][] = '"' . $vbulletin->options['bburl'] . '/'.$rp;
			}
		}
	}
	unset ($rp);
}

$header = str_replace($headerfile['find'], $headerfile['replace'], $header);
unset($headerfile, $header_acp_replacearray);

// ################### Navbar and NavTab Replacements ###################

// Navbar and NavTab Replacements
// not rendered yet, but we can access the template hooks
					// usercp.php	private.php	register.php  login.php	  faq.php  clientscript	blog

$navbarfile = array();
$navbarfile['find'][] = '"images/';
$navbarfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/images/';
$navbarfile['find'][] = '"profile.php';
$navbarfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/profile.php';
$navbarfile['find'][] = '"private.php';
$navbarfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/private.php';
$navbarfile['find'][] = '"register.php';
$navbarfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/register.php';
$navbarfile['find'][] = '"search.php';
$navbarfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/search.php';
$navbarfile['find'][] = '"blog.php';
$navbarfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/blog.php';
$navbarfile['find'][] = '"content.php';
$navbarfile['replace'][] = '"'.$vbulletin->options['bburl'] . '/content.php';

// now we check if there are any other files added in acp by the user...
$navbar_acp_replacearray = array();
$navbar_acp_replacearray = explode("\r\n", $ppg_options['gallery_navbar_replace']);
if(!empty($navbar_acp_replacearray))
{
	foreach($navbar_acp_replacearray as $rp)
	{
		if(!in_array($rp, $navbarfile['find']) AND (strpos($rp, "test_") === false))
		{
			if(trim($rp))
			{
				$rp=trim($rp);
				$navbarfile['find'][] = '"' . $rp;
				$navbarfile['replace'][] = '"' . $vbulletin->options['bburl'] . '/'.$rp;
			}
		}
	}
	unset ($rp);
}

$vbulletin->templatecache['navbar'] = str_replace($navbarfile['find'], $navbarfile['replace'], $vbulletin->templatecache['navbar']);
$template_hook['navtab_middle'] = str_replace($navbarfile['find'], $navbarfile['replace'], $template_hook['navtab_middle']);
$template_hook['navtab_start'] = str_replace($navbarfile['find'], $navbarfile['replace'], $template_hook['navtab_start']);
$template_hook['navtab_end'] = str_replace($navbarfile['find'], $navbarfile['replace'], $template_hook['navtab_end']);
unset($navbarfile, $navbar_acp_replacearray);


/*
// This seems not to be needed !!!! (any clues?)
// we fixed standard error in plugin.. the login there is also fixed...
// TODO check following.. if needed
$vbulletin->templatecache['modifypassword'] = str_replace( '"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['modifypassword']);
$vbulletin->templatecache['register'] = str_replace( '"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['register']);



$vbulletin->templatecache['STANDARD_ERROR_LITE'] = str_replace( '"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['STANDARD_ERROR_LITE']);
$vbulletin->templatecache['STANDARD_ERROR_LOGIN'] = str_replace( '"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['STANDARD_ERROR_LOGIN']);


  

// $navbar replacement
$navreplacearray = explode("\r\n", $ppg_options['gallery_navbar_replace']);

// echo $vbulletin->templatecache['navbar'];

$navreplace['find'] = array(
	'"clientscript',
	'\'misc.php',
	'$GLOBALS[\'vbulletin\']->options[\'bbtitle\']',
	'$GLOBALS[\'vbulletin\']->options[\'forumhome\'] . ".php'
);

$navreplace['replace'] = array(
	'"' . $vbulletin->options['bburl'] . '/clientscript',
	'\'' . $vbulletin->options['bburl'] . '/misc.php',
    iif($ppg_options['gallery_navbarhomelink'], '$GLOBALS[\'vbulletin\']->options[\'hometitle\']', '$GLOBALS[\'ppg_options\'][\'gallery_title\']'),
    iif($ppg_options['gallery_navbarhomelink'], '$GLOBALS[\'vbulletin\']->options[\'homeurl\'] . "', '$GLOBALS[\'ppg_options\'][\'gallery_url\'] . "/index.php')
);

$vbulletin->templatecache['navbar'] = str_replace($navreplace['find'], $navreplace['replace'], $vbulletin->templatecache['navbar']);

 */									 


$vbphrase['private_messages_nav'] = str_replace('"private.php', '"' . $vbulletin->options['bburl'] . '/private.php', $vbphrase['private_messages_nav']);

// we get our original mod and admincp dirs back
$vbulletin->config['Misc']['admincpdir']=$tmp_vars['ta'];
$vbulletin->config['Misc']['modcpdir']= $tmp_vars['tm'];
$vbulletin->options['forumhome'] = $vbulletin->options['bburl'] . '/' . $tmp_vars['forumhome'];

//dont forget the first breadcrumb... the little house..
 $vbulletin->templatecache['navbar'] = str_replace( '"index.php', '"' . $vbulletin->options['bburl'] . '/index.php', $vbulletin->templatecache['navbar']);


// still need tests to see if this is needed
if ($shownewpm)
{
	// $shownewpm is now $newpm and only available in bootstrap.php. the template is rendered there and added to footer. 
	// we allready have replaced private.php in footer, so it seems it is not needed !!!

	//	eval('$pmscript = "' . fetch_template('pm_popup_script') . '";');
	//	$footer .= str_replace('"private.php', '"' . $vbulletin->options['bburl'] . '/private.php', $pmscript);
}

 unset($tmp_vars);
// ########################## Navbar and other header stuff #############################

// we add admin warning here.. as it was not possible before (templates not rendered yet)
if(defined('ADMIN_WARNING'))
{
	$warning = $vbphrase['alert_gallery_turned_off'];
	$header = $warning . $header;
	$footer .= $warning;
}
// First element of Breadcrumbs
//if (THIS_SCRIPT != 'gallery_index' AND $ppg_options['gallery_navbarhomelink'])
//{
	// $navbits["$ppg_options[gallery_url]"] = $ppg_options['gallery_title'];
	//$navbits["$ppg_options[gallery_url]"] = $vbphrase['gallery'];
//}
if (THIS_SCRIPT == 'gallery_index')
{
	//ATTENTION DO NOT MODIFY .. THIS USES global TEMPLATE HOOKS
	// the pos1 -> pos8 are part of the template hook names !!!

	$ppg_options['gallery_imagebitdisplay'] = $ppg_options['gallery_imagebitdisplay_index'];
		// seo stuff: if new or random images is above pagetitle(<h1>)
		// it does not have a <h2> tag.. but only span


	// define the hook positions
	if ($ppg_options['gallery_newhomeimages'])
	{
		if($ppg_options['gallery_newhomepos']<=3)
		{
			$ppg_vars['nonewh2'] = true;
		}
		$newhomepos = $ppg_options['gallery_newhomepos'];
		switch ($newhomepos){
			case 1: $newhomepos = 'pos1';  break;
			case 2: $newhomepos = 'pos2';  break;
			case 3: $newhomepos = 'pos3';  break;
			case 4: $newhomepos = 'pos4';  break;
			case 5: $newhomepos = 'pos5';  break;
			case 6: $newhomepos = 'pos6';  break;
			case 7: $newhomepos = 'pos7';  break;
			case 8: $newhomepos = 'pos8';  break;
			default:
				$newhomepos = 'pos4';
		}
    }

    if ($ppg_options['gallery_randomhomeimages'])
	{
		if($ppg_options['gallery_randomhomepos']<=3)
		{
			$ppg_vars['norandh2'] = true;
		}
		$ranhomepos = $ppg_options['gallery_randomhomepos'];
		switch ($ranhomepos){
			case 1: $ranhomepos = 'pos1';  break;
			case 2: $ranhomepos = 'pos2';  break;
			case 3: $ranhomepos = 'pos3';  break;
			case 4: $ranhomepos = 'pos4';  break;
			case 5: $ranhomepos = 'pos5';  break;
			case 6: $ranhomepos = 'pos6';  break;
			case 7: $ranhomepos = 'pos7';  break;
			case 8: $ranhomepos = 'pos8';  break;
			default:
				$ranhomepos = 'pos6';
      }
    }
}

if ($ppg_options['gallery_imagebitdisplay'])
{
	$showfield = explode(',', $ppg_options['gallery_imagebitdisplay']);
}

if (!empty($showfield))
{
	$showfields = array();
	foreach ($showfield AS $field)
	{
		$showfields["$field"] = 1;
	}
}


// ######################### Gallery Announcement ##########################
if ($ppg_options['gallery_announcement'])
{
	// todo make it multilanguage with customphrases.....
	function announcement_gallery($announcement_in)
	{
		extract ($GLOBALS);
		
		while (preg_match("/\[\[(.*)\]\](.*)\[\[(\/\\1)\]\]/siU", $announcement_in, $matches14))
		{
			@eval ('if ('.stripslashes($matches14[1]).') { $eval_deger= "1"; } else { $eval_deger= "0"; }');
			if ($eval_deger == 1)	//if conditional applied
			{
				
				$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
				$matches14[2] = $parser->do_parse($matches14[2], 1, 1, 1, 1, 1, 1);
				return $matches14[2];
			}
			else //conditional not applied so let's delete it so that it wont be matched in preg_match again..
			{
				$announcement_in = str_replace($matches14[0], '', $announcement_in);
			}
		}

		// no conditional found or applied, so return whatever exists/remains in announcement box
		$matches14[2] = trim($announcement_in);

		if (trim($matches14[2]))
		{
			$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
			$matches14[2] = $parser->do_parse($matches14[2], 1, 1, 1, 1, 1, 1);
		}

		return $matches14[2];
	}

	require_once(DIR . '/includes/class_bbcode_alt.php');

	$vboptions      =& $vbulletin->options;
	$technicalemail =& $vbulletin->config['Database']['technicalemail'];
	$bbuserinfo		=& $vbulletin->userinfo;
	$date           = date('l, F jS Y @ h:i:s A');
	$scriptpath     = str_replace('&amp;', '&', $vbulletin->scriptpath);
	$referer        = REFERRER;
	$ipaddress      = IPADDRESS;

  	eval('$announcement_in = "' . addslashes($ppg_options['gallery_announcement']) . '";');
	
	$announcement_in = str_replace("\\'", "'", $announcement_in);
	$ppgal_announcement = ''; 
	$ppgal_announcement = announcement_gallery($announcement_in);
		 
	if (trim($ppgal_announcement) != '')
	{
 		$templater = vB_Template::create('adv_gallery_announcement');
		$templater->register('ppgal_announcement', $ppgal_announcement);
        $ppgal_announcement = $templater->render(); 
 	}
}

// displayimage.php	(echo)
if ($ppg_options['gallery_watermark'] AND !$ppg_options['gallery_permwatermark'])
{
	$ppg_options['gallery_echoimage'] = true;
}

// ######################### WOL Bypass ##########################
if (THIS_SCRIPT == 'gallery_index' OR THIS_SCRIPT == 'gallery_search' OR THIS_SCRIPT == 'gallery_misc')
{
	$vbulletin->userinfo['badlocation'] = 500;
}


($hook = vBulletinHook::fetch_hook('ppgal_galleryglobal_complete')) ? eval($hook) : false;
// end of global..
?>