<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: editimage.php                                                    ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
if(isset($_REQUEST['do']) AND ($_REQUEST['do'] == 'doreplaceimage' OR $_REQUEST['do'] == 'domanipulate'))
{
	ini_set("memory_limit", "128M");
	ini_set("max_execution_time", 0);
	ini_set('post_max_size','30M');
	ini_set('upload_max_filesize','30M');
}
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################

define('THIS_SCRIPT', 'editimage');
define('GET_IMGTYPE_ARRAY', true);
define('CSRF_PROTECTION', true);


// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'adv_gallery_editimg'
);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'ADV_GALLERY_EDITIMAGE',
	'adv_gallery_upload_custombits',
	'adv_gallery_conformation',
	'adv_gallery_editimage_sidebar'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');
require_once(DIR . '/includes/functions_gallery_imageedit.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################
// add to acp
/*
$ppg_options['gallery_edit_size'] = 400;
$ppg_options['gallery_set_img_avatar'] = 1;
$ppg_options['gallery_lockimage'] = 1;

$ppg_options['gallery_editimg_sidebar_pos'] = 0;
$ppg_options['gallery_editimg_sidebar_cor'] = 0;

*/
if (!isset($_REQUEST['do']))
{
	$_REQUEST['do'] = 'edit';
}


// ############################### General stuff #########################
if (in_array($_POST['do'], array('doeditimage','doreplaceimage', 'domanipulate')))
{
	$image = $vbulletin->input->clean_gpc('p', 'image', TYPE_ARRAY_STR);
	$image['imageid'] = intval($image['imageid']);
	$image['catid'] = intval($image['catid']);

	if (!$image['catid'])
	{
		standard_error(fetch_error('adv_gallery_must_choose_category'));
	}

	check_image_id($image['imageid']);

	$imageinfo = $db->query_first("
			SELECT imageid, catid, userid, filename, thumbname, originalname, width, height, originalwidth, originalheight, notes
			FROM " . TABLE_PREFIX . "ppgal_images
			WHERE imageid = '$image[imageid]'
	");
	$categoryperms = fetch_category_perms();

	$iscatmod = is_category_mod($image['catid']);

	$catopts = construct_cat_opts($imageinfo['catid'], $categorycache["$imageinfo[catid]"]['options']);

	if ((!$vbulletin->userinfo['userid'] OR ($imageinfo['userid'] != $vbulletin->userinfo['userid'] AND !$categoryperms["$imageinfo[catid]"]['caneditothersimages']) OR ($imageinfo['userid'] == $vbulletin->userinfo['userid'] AND !$categoryperms["$imageinfo[catid]"]['caneditimages'])) AND !$iscatmod)
	{
		print_no_permission();
	}

	$userid = $imageinfo['userid'];
}

if($_REQUEST['do'] == 'domanipulate')
{

	$rotate = $vbulletin->input->clean_gpc('p', 'rotate', TYPE_INT);
	$rotate = intval($rotate);
	$flip = $vbulletin->input->clean_gpc('p', 'flip', TYPE_ARRAY_STR);
	$update_done = false;
	if(in_array($rotate, array(90,180,270)))
	{
		require_once(DIR . '/includes/functions_gallery_imageedit.php');
		$folderstring = fetch_folder_path($imageinfo);
		rotate_image($imageinfo, $rotate);

		if (in_array($rotate, array(90, 270)))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET width = '$imageinfo[height]', height = '$imageinfo[width]', originalwidth = '$imageinfo[originalheight]', originalheight = '$imageinfo[originalwidth]' WHERE imageid = '$imageinfo[imageid]'");

		}
		$update_done = true;
	}

	if (!empty($flip))
	{
		$folderstring = fetch_folder_path($imageinfo);
		require_once(DIR . '/includes/functions_gallery_imageedit.php');
		flip_image($imageinfo);
		$update_done = true;
	}
	if($update_done)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET dateline_mod = '" . TIMENOW . "' WHERE imageid = '$imageinfo[imageid]'");
	}


	$adv_sorturl = construct_adv_sort_url();
	$vbulletin->url = 'editimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $adv_sorturl;
	eval(print_standard_redirect('adv_gallery_edit_success'));

}

// ############################### Do lock/unlock comments #########################

if($_REQUEST['do'] == 'lockcomments' OR $_REQUEST['do'] == 'unlockcomments')
{
	$image = array();
	$image['imageid'] = $vbulletin->input->clean_gpc('r', 'i', TYPE_INT);
	$image['imageid'] = intval($image['imageid']);
	check_image_id($image['imageid']);
	$imageinfo = $db->query_first("
			SELECT imageid, catid, userid, filename, thumbname, originalname, width, height, originalwidth, originalheight, open
			FROM " . TABLE_PREFIX . "ppgal_images
			WHERE imageid = '$image[imageid]'
	");
	// check permissions
	$categoryperms = fetch_category_perms();

	$iscatmod = is_category_mod($image['catid']);

	$catopts = construct_cat_opts($imageinfo['catid'], $categorycache["$imageinfo[catid]"]['options']);

	if ((!$vbulletin->userinfo['userid'] OR ($imageinfo['userid'] != $vbulletin->userinfo['userid'] AND !$categoryperms["$imageinfo[catid]"]['caneditothersimages']) OR ($imageinfo['userid'] == $vbulletin->userinfo['userid'] AND !$categoryperms["$imageinfo[catid]"]['caneditimages'])) AND !$iscatmod)
	{
		print_no_permission();
	}
	if($_REQUEST['do'] == 'lockcomments' AND $imageinfo['open'] == 1)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET open = 0 WHERE imageid = '$imageinfo[imageid]'");

	}
	else if($_REQUEST['do'] == 'unlockcomments' AND $imageinfo['open'] != 1)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET open = 1 WHERE imageid = '$imageinfo[imageid]'");
	}


	$adv_sorturl = construct_adv_sort_url();
	$vbulletin->url = 'editimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $adv_sorturl;
	eval(print_standard_redirect('adv_gallery_edit_success'));


}

// ############################### Do replace Image #########################
if ($_POST['do'] == 'doreplaceimage')
{
	$file = $vbulletin->input->clean_gpc('f', 'userfile1', TYPE_FILE);
	$folderstring = fetch_folder_path($imageinfo);

	if (!empty($file['name']))
	{
		$oldimagename = $imageinfo['filename'];
		$oldthumbname = $imageinfo['thumbname'];
		$oldoriginalname = $imageinfo['originalname'];

		$filetypes = fetch_cat_ext_info();
		$userid = $imageinfo['userid'];

		$imageinfo = fetch_image_info($file['tmp_name'], $file['name'], 0);

		$errors["$imageinfo[saveas]"] = check_upload_errors();

		if (!empty($errors["$imageinfo[saveas]"]))
		{
			$show['errors'] = true;
		}
		else
		{
			unset($imageinfo['thumbname']);

			@move_uploaded_file($file['tmp_name'], $imageinfo['saveto'] . '/' . $imageinfo['saveas']);
			$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
			process_upload(false, false);
			$imageinfo = resize_image($ppg_options['gallery_thumbsize'], $ppg_options['gallery_thumbsize']);
			@unlink($folderstring . '/' . $oldimagename);
			@unlink($folderstring . '/' . $oldthumbname);
			@unlink($folderstring . '/' . $oldoriginalname);
		}
	}
	
	
	
	$adv_sorturl = construct_adv_sort_url();
	if ($show['errors'])
	{
		$imageid = $imageinfo['imageid'];
		$_REQUEST['do'] = 'editerrors';
	}
	else
	{
		$vbulletin->url = 'editimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $adv_sorturl;
		eval(print_standard_redirect('adv_gallery_edit_success'));
	}
}



// ############################### Do Edit Image #########################
if ($_POST['do'] == 'doeditimage')
{
	
	$image = $vbulletin->input->clean_gpc('p', 'image', TYPE_ARRAY_STR);
//	$rotate = $vbulletin->input->clean_gpc('p', 'rotate', TYPE_INT);
//	$flip = $vbulletin->input->clean_gpc('p', 'flip', TYPE_ARRAY_STR);
	$valid = $vbulletin->input->clean_gpc('p', 'valid', TYPE_INT);

	$image['imageid'] = intval($image['imageid']);
	$image['catid'] = intval($image['catid']);
	$image['imagecat'] = intval($image['imagecat']);
	if (!$image['catid'])
	{
		standard_error(fetch_error('adv_gallery_must_choose_category'));
	}

	$imageinfo = $db->query_first("
			SELECT imageid, catid, userid, title, filename, extension, thumbname, originalname, width, height, originalwidth, originalheight, notes, cropid
			FROM " . TABLE_PREFIX . "ppgal_images
			WHERE imageid = '$image[imageid]'
	");

	$categoryperms = fetch_category_perms();

	$iscatmod = is_category_mod($image['catid']);

	$catopts = construct_cat_opts($imageinfo['catid'], $categorycache["$imageinfo[catid]"]['options']);

	if ($catopts['allow_desc_links'])
	{
		require_once(DIR . '/includes/functions_newpost.php');
		$image['description'] = convert_url_to_bbcode($image['description']);
	}

	if ((!$vbulletin->userinfo['userid'] OR ($imageinfo['userid'] != $vbulletin->userinfo['userid'] AND !$categoryperms["$imageinfo[catid]"]['caneditothersimages']) OR ($imageinfo['userid'] == $vbulletin->userinfo['userid'] AND !$categoryperms["$imageinfo[catid]"]['caneditimages'])) AND !$iscatmod)
	{
		print_no_permission();
	}

	$userid = $imageinfo['userid'];

// Grab custom fields to display
	$custominfo = array();
	$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields ORDER BY displayorder");
	while ($field = $vbulletin->db->fetch_array($customfields))
	{
		$custominfo[] = $field;
	}
	$db->free_result($customfields);
	unset($field);

	$errors["$imageinfo[title]"] = check_edit_errors();
	if (!empty($errors["$imageinfo[title]"]))
	{
			$show['errors'] = true;
	}

	if ($show['errors'])
	{
		$imageid = $imageinfo['imageid'];
		$_REQUEST['do'] = 'edit';
	}
	else
	{


		if (!$iscatmod)
		{
			$image['notes'] = $imageinfo['notes'];
		}
		/******** Croptool **********/
		$savecrop = false;


		if($ppg_options['gallery_squarethumbs'] AND $ppg_options['gallery_croptool'])
		{
			
			$cropid = $vbulletin->input->clean_gpc('p', 'cropid', TYPE_INT);
			//quickcheck cropid

			if($cropid>=1 AND $cropid<=3)
			{
			
				// check for gif support..
				if (function_exists('imagegif') AND function_exists('imagecreatefromgif'))
				{
					$giftype = 'gif';
				}
				else 
				{
					$giftype = 'nogif';
				}
				
				$imgtp = strtolower($imageinfo['extension']);
			
				if(in_array($imgtp, array($giftype, 'jpg', 'jpeg', 'png')) )	
				{
						
					if($cropid != $imageinfo['cropid'])
					{
						$imageinfo['cropid'] = $cropid;
						$savecrop = true;
						require_once(DIR . '/includes/functions_gallery_crop.php');
					}
				}
			}
		}
		/******** /Croptool **********/

		construct_customfields_sql($_POST, $imageinfo['imageid'], false);

		$image['notes'] .= ' ' . $vbphrase['last_updated'] . ' ' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], TIMENOW) . ' ' . $vbphrase['by'] . ' ' . $vbulletin->userinfo['username'];

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET  title = '" . $db->escape_string($image['title']) . "', description = '" . $db->escape_string($image['description']) . "', keywords = '" . $db->escape_string($image['keywords']) . "', catid = '$image[catid]', dateline_mod = '" . TIMENOW . "', notes = '" . $db->escape_string($image['notes']) . "' " . iif($savecrop, ", cropid = '" . $cropid . "' ", '') . "  WHERE imageid = '$imageinfo[imageid]'");

		if ($imageinfo['catid'] != $image['catid'])
		{
			update_count($image['imagecat']);
			update_count($image['catid']);
		}

		$adv_sorturl = construct_adv_sort_url();
		$vbulletin->url = 'editimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $adv_sorturl;
		eval(print_standard_redirect('adv_gallery_edit_success'));
	}
}

// ############################### Edit Image ######################################
if ($_REQUEST['do'] == 'edit' OR $_REQUEST['do'] == 'editerrors')
{
	// Print out any initial errors
	if (!empty($errors))
	{
		$uploaderrors =  '<ul style="padding:10px;margin-left:20px;">';
		
		foreach ($errors AS $filename => $error)
		{
			if (!empty($error))
			{
				$show['errors'] = true;
				$uploaderrors .= '<li style="margin-left:-10px;">' . $vbphrase['errors'] . '</li>';
				foreach ($error AS $varname => $text)
				{
					$uploaderrors .= '<li style="list-style-type:disc;padding-left:{vb:stylevar padding}">' . $text . '</li>';
				}
			}
		}
		$uploaderrors .=  '</ul>';
		if($_REQUEST['do'] == 'edit')
		{
			$postimage = $image; // DO NOT USE =& HERE!
		}
	}

	$image = $db->query_first("
			SELECT images.*, customfields.*, categories.title AS cattitle, parentlist
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_customfields_entries AS customfields ON (images.imageid = customfields.imgid)
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (images.catid = categories.catid)
			WHERE imageid = '$imageid'
	");

	
	check_image_id($image['imageid']);

	$categoryperms = fetch_category_perms();

	$show['ismoderator'] = is_category_mod($image['catid']);

	if ((!$vbulletin->userinfo['userid'] OR ($image['userid'] != $vbulletin->userinfo['userid'] AND !$categoryperms["$image[catid]"]['caneditothersimages']) OR ($image['userid'] == $vbulletin->userinfo['userid'] AND !$categoryperms["$image[catid]"]['caneditimages'])) AND !$show['ismoderator'])
	{
		print_no_permission();
	}



	if(!empty($postimage['description']))
	{
		$image['description'] = $postimage['description'];
	}
	if(intval($postimage['catid']) != 0)
	{
		$image['catid'] = $postimage['catid'];
	}
	if(!empty($postimage['title']))
	{
		$image['title'] = $postimage['title'];
	}
	if(!empty($postimage['keywords']))
	{
		$image['keywords'] = $postimage['keywords'];
	}
	if(!empty($postimage['notes']))
	{
		$image['notes'] = $postimage['notes'];
	}

	$image['description'] = $image['description'];
	$image['description'] = str_replace('&amp;', '&', $image['description']);
	



	$show['delete_img'] = false;
	if (($categoryperms["$image[catid]"]['candelete'] AND $vbulletin->userinfo['userid'] == $image['userid']) OR $categoryperms["$image[catid]"]['candeleteothers'] OR $show['ismoderator'])
	{
		$show['delete_img'] = true;
	}
	$show['imgpreview'] = false;
	if(in_array(strtolower($image['extension']), array('jpg','jpeg','png','gif')))
	{
		// this is for imagepreview
		$show['imgpreview'] = true;
        switch ($ppg_options['gallery_resizemethod'])
        {
			
            // Using ImageMagick TODO: restrict filetypes BMP and TIFF and swf are in $imgtypearray!!!!!! (dont have it installed)
            case 'IM':
                $show['manipulation'] = true;
                break;
            // Using GD
            case 'GD1':
            case 'GD2':
                if(function_exists('imagerotate'))
                {
					$show['manipulation'] = true;
                    if(strtolower($image['extension']) == 'gif' AND (!function_exists('imagecreatefromgif') OR !function_exists('imagegif')) )
                    {
						$show['manipulation'] = false;
                    }
                }
                break;
        }
    }

	if (!$image['title'])
	{
		$image['title'] = $image['filename'];
	}

	$image['url'] = construct_image_url($image, 'thumbname');


	if($show['imgpreview'])
	{
		$image['bigurl'] = construct_image_url($image, 'filename');
		$image['dispwidth'] = $image['width'];
		$image['dispheight'] = $image['height'];
		if($image['width']>$ppg_options['gallery_edit_size'] OR $image['height']>$ppg_options['gallery_edit_size'])
		{
			if($image['width']>$image['height'])
			{
				$image['dispwidth'] = $ppg_options['gallery_edit_size'];
				$image['dispheight'] = round( $ppg_options['gallery_edit_size'] / ($image['width']/$image['height'])); 
			}
			else
			{
				$image['dispheight'] = $ppg_options['gallery_edit_size'];
				$image['dispwidth'] = round( $ppg_options['gallery_edit_size'] / ($image['height']/$image['width']));

			}
		
		}
		else
		{
			$image['dispwidth'] = $image['width'];
			$image['dispheight'] = $image['height'];

		}
		$show['origlink'] = false;
		if($image['originalname'])
		{
			$image['origurl'] = construct_image_url($image, 'originalname');
			$show['origlink'] = true;

		}
	}
	$catoptions = print_cat_select($image['catid'], 'upload');


	//$customfieldbits = construct_custom_fieldbits($image, '', true);
	$customfieldbits = construct_custom_fieldbits($image);

//


/* ##########################################
   ########### Sidebar Content ##############
   ##########################################
*/

	$show['sidebar'] = true;
	$show['validwarn'] = iif($categoryperms["$image[catid]"]['moderateimages'], true, false);



$image['dateadded'] = vbdate($vbulletin->options['dateformat'], $image['dateline'], true);
$image['timeadded'] = vbdate($vbulletin->options['timeformat'], $image['dateline'], true);

	if($image['dateline_mod'])
	{
		$image['datemodded'] = vbdate($vbulletin->options['dateformat'], $image['dateline_mod'], true);
		$image['timemodded'] = vbdate($vbulletin->options['timeformat'], $image['dateline_mod'], true);
	}
	else
	{
		$image['datemodded'] = $vbphrase['never'];
		$image['timemodded'] = '';
	}

	$image['filesize'] = vb_number_format($image['filesize'], 1, true);

	$image['originalfilesize'] = vb_number_format($image['originalfilesize'], 1, true);
	$image['originalurl'] = $image['origurl'];
	if($ppg_options['gallery_set_img_avatar'])
	{
		$show['setavatar'] = true;
		$userinfo = fetch_userinfo($image['userid']);
		cache_permissions($userinfo, false);
		if (!($userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar']))
		{
			$show['setavatar'] = false;
		}
	}
	$show['lockimage'] = $ppg_options['gallery_lockimage'] ? true : false;

	$show['esettings'] = ($show['lockimage'] OR $show['setavatar']) ? true : false;

	$vbphrase['js_you_must_select_file'] = addslashes_js($vbphrase['you_must_select_file']);
	$vbphrase['js_sorry_before_proceed'] = addslashes_js($vbphrase['sorry_before_proceed']);
	$vbphrase['js_confirm_delete_single'] = addslashes_js($vbphrase['confirm_delete_single']);
	$vbphrase['js_check_before_proceeding'] = addslashes_js($vbphrase['check_before_proceeding']);

	$ppg_vars['editimage_sidebarposition'] = $ppg_options['gallery_editimg_sidebar_pos'];

	$ppg_vars['gallery_url'] = $ppg_options['gallery_url'];
	$ppg_vars['imageid'] = $image['imageid'];
	$ppg_vars['imageuserid'] = $image['userid'];
	$ppg_vars['imgusername'] = $image['username'];
	$ppg_vars['views'] = $image['views'];

	$edit = $vbulletin->input->clean_gpc('r', 'edit', TYPE_INT);
	$catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_INT);
	if($edit == 1)
	{
		$image['source'] = 'editor';

	}
	else if($catid == 'member')
	{
		$image['source'] = 'editimage';
	}
	else
	{
		$image['source'] = 'single';
	}

	if($_REQUEST['do'] != 'editerrors')
	{
		$adv_sorturl = construct_adv_sort_url();
	}

	($hook = vBulletinHook::fetch_hook('ppgal_editimage')) ? eval($hook) : false;

	$templater = vB_Template::create('adv_gallery_editimage_sidebar');
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('adv_sorturl', $adv_sorturl);
	$templater->register('image', $image);
	$sidebar = $templater->render();

	// ######  END Sidebar ######################


	$show['croptool'] = ($ppg_options['gallery_squarethumbs'] AND $ppg_options['gallery_croptool']) ? true :false;

	if($show['croptool'])
	{
		$landscape = ($image['width']>$image['height']) ? true : false;
		if($landscape)
		{
			if(!$image['cropid'])
			{
				$image['cropid'] = 2;
			}
		}
		else
		{
			if(!$image['cropid'])
			{
				if($ppg_options['gallery_autocrop'])
				{
					$image['cropid'] = 1;
				}
				else
				{
					$image['cropid'] = 2;
				}				
			}
		}
		switch ($image['cropid'])
		{
			case 1:
				$image['cropcheck1'] = ' checked="checked" ';
				break;
			case 2:
				$image['cropcheck2'] = ' checked="checked" ';
				break;

			case 3:
				$image['cropcheck3'] = ' checked="checked" ';
				break;
			default:
				$image['cropcheck2'] = ' checked="checked" ';

		}




	}

	$ppg_vars['albumclass'] = ($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1) ? '_alt' : '';
	$ppg_vars['cache'] = '?cache=' . TIMENOW;

	$navbits[$ppg_options['gallery_url'] . '/index.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['gallery'];
	$navbits = construct_dir_navbits($image['parentlist']);
	$navbits['showimage.php?' . $vbulletin->session->vars['sessionurl'] . "i=$image[imageid]" . $adv_sorturl] = $image['title'];
	$navbits[''] = $vbphrase['edit_image'];


	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);


		$headinclude = construct_metatags($headinclude);
		$headinclude = NOROBOTS . "\n" . $headinclude;


	$templater = vB_Template::create('ADV_GALLERY_EDITIMAGE');

	$templater->register_page_templates();
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('navbar', $navbar);
	$templater->register('sidebar', $sidebar);
	$templater->register('uploaderrors', $uploaderrors);
	$templater->register('deleteoption', $deleteoption);
	$templater->register('image', $image);
	$templater->register('adv_sorturl', $adv_sorturl);
	$templater->register('validcheck', $validcheck);
	$templater->register('catoptions', $catoptions);
	$templater->register('customfieldbits', $customfieldbits);

	print_output($templater->render());
}

?>