<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: crop_thumb.php                                                   ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
// #################### DEFINE IMPORTANT CONSTANTS #######################

define('THIS_SCRIPT', 'easy_crop');
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################

// get special phrase groups
$phrasegroups = array();
$specialtemplates = array();
$globaltemplates = array();
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');


// ***********************************************************
// ********** Configuration part *****************************
// ***********************************************************

$ppg_options['crop_thumbsize'] = 80; //not to big for ressources -  smaller than thumbnailsize
$ppg_options['sharpen'] = 0; // mini should be sharpened or not ^^ Ressources !!!!

// ****************** end config *******************************

// ****************** image error function *********************

function img_error($errormess = 0){
	$error_img = 'error' . $errormess. '.gif';
	header('Content-disposition: inline; filename=crop_error.gif');
	header('Content-transfer-encoding: binary');
	header('Content-Type: image/gif');
	readfile(DIR . '/includes/vbgallery/errors/' . $error_img);

	exit;
}

// ######################### start work ############################



$imageid = intval($_REQUEST['i']);

$crop = intval($_REQUEST['crop']);
if($crop < 1 OR $crop > 3)
{
	img_error(1);
}

if(!isset($imageid) OR $imageid < 1)
{
	img_error(2);
}
$original = false;

$pragma=true;


// get the image information
$imageinfo = $db->query_first("SELECT imageid, catid, userid, originalname, originalfilesize, filename, width, height, filesize, extension FROM " . TABLE_PREFIX . "ppgal_images AS images WHERE imageid = '$imageid'");





$imageinfo['filename'] = $imageinfo['filename'];
$imageinfo['location'] = fetch_folder_path($imageinfo) . '/' . $imageinfo['filename'];
$imageinfo['extension'] = strtolower($imageinfo['extension']);

if (!in_array($imageinfo['extension'], array('gif','png','jpeg','jpg')))
{
	img_error(3);
}
else if(!file_exists($imageinfo['location']))
{
	img_error(4);
}

//we check permissions for user.. same as edit image..

$categoryperms = fetch_category_perms($imageinfo['catid']);
$iscatmod = is_category_mod($imageinfo['catid']);

if ( (!$vbulletin->userinfo['userid'] OR ($imageinfo['userid'] != $vbulletin->userinfo['userid'] AND !$categoryperms['caneditothersimages']) OR ($imageinfo['userid'] == $vbulletin->userinfo['userid'] AND !$categoryperms['caneditimages'])) AND !$iscatmod)
{
		img_error(5);
}

// all checks done... start working
$ppg_options['gallery_resizemethod'] = 'GD2';
// override resize method...


switch ($ppg_options['gallery_resizemethod'])
{
	// Use GD to Resize
	case 'GD1':
		img_error(6);
	break;
	case 'GD2':

	//********** Apply autocrop routine depending on crop id *****************

	// check for gif support
	if($imageinfo['extension'] == 'gif' AND (!function_exists('imagegif') OR !function_exists('imagecreatefromgif')) )
	{
		img_error(7);
	}

	switch ($imageinfo['extension'])
	{
		case jpeg:
		case jpg:
			$src=imagecreatefromJpeg($imageinfo['location']);
			break;
		case png:
			$src=imagecreatefromPng($imageinfo['location']);
			break;
		case gif:
			$src=imagecreatefromGif($imageinfo['location']);
			break;
		default:
			$src=imagecreatefromJpeg($imageinfo['location']);
			// we use jpg as default
			break;
	}

	// error if it didn't workout
	if(!$src OR ($src == null))
	{
		img_error(8);
	}

	// we first check if its landscape or not
	$ox = @ImageSX($src); 
	$oy = @ImageSY($src); 
	$landscape = false;
	if($ox > $oy)
	{
		$landscape = true;
		$y = $ppg_options['crop_thumbsize'];
		$x = round($ppg_options['crop_thumbsize'] / ($oy/$ox));
	}
	else
	{
		$x = $ppg_options['crop_thumbsize'];
		$y = round($ppg_options['crop_thumbsize'] / ($ox/$oy));
	}

	$imgFinal1 = @ImageCreateTrueColor($x, $y);
	
	@ImageCopyResampled($imgFinal1, $src, 0, 0, 0, 0, $x, $y, $ox, $oy); 

	@imagedestroy($src);


	if($landscape)
	{
		$y1 = 0;
		$y2 = $ppg_options['crop_thumbsize'];
		if($crop == 1)
		{
			$x1 = 0;
			$x2 = $ppg_options['crop_thumbsize'];
		}
		else if($crop == 2)
		{
			$x1 = round(($x - $ppg_options['crop_thumbsize'])/2);
			$x2 = $x1 + $ppg_options['crop_thumbsize'];
		}
		else
		{
			$x1 = $x - $ppg_options['crop_thumbsize'];
			$x2 = $x;
		}
	}
	else
	{
		$x1 = 0;
		$x2 = $ppg_options['crop_thumbsize'];
		if($crop == 1)
		{
			$y1 = 0;
			$y2 = $ppg_options['crop_thumbsize'];
		}
		else if($crop == 2)
		{
			$y1 = round(($y - $ppg_options['crop_thumbsize'])/2);
			$y2 = $y1 + $ppg_options['crop_thumbsize'];
		}
		else
		{
			$y1 = $y - $ppg_options['crop_thumbsize'];
			$y2 = $y;
		}
	}

	$nx = $x2 - $x1;
	$ny = $y2 - $y1;

	if ($imgFinal1 == null OR !$imgFinal1)
	{
		img_error(9);
	}

	$imgFinal2 =  @ImageCreateTrueColor($nx, $ny);

	@ImageCopyResampled($imgFinal2, $imgFinal1, 0, 0, $x1, $y1, $nx, $ny, $nx, $ny);
	@imagedestroy($imgFinal1);


	if($ppg_options['sharpen'] == 1)
	{
		require_once(DIR . '/includes/vbgallery/xba_unsharp_mask.php');
		$imgFinal2 = sharpen($imgFinal2, 6);
	}

	// we show the file as jpg

	header('Content-disposition: inline; filename=crop_image.jpg');
	header('Content-transfer-encoding: binary');
	header('Content-Type: image/jpeg');


	@imagejpeg($imgFinal2, '', 66);

	@imagedestroy($imgFinal2);
	exit;
	break;

	// Use ImageMagick to Resize
	case 'IM':
		if ($vbulletin->options['safeupload'])
		{
			$tmpname = $vbulletin->options['tmppath'] . '/' . md5(uniqid(microtime()) . $vbulletin->userinfo['userid']);
		}
		else
		{
			if (!($tmpname = @tempnam(ini_get('upload_tmp_dir'), 'vb')))
			{
				echo 'Could not create temporary file.';
				exit;
			}
		}

		$quality = 66;

  		// we sharpen only jpgs
		$sharpen = ($imageinfo['extension'] == 'jpg' AND $ppg_options['sharpen']) ? " -sharpen 0x1 " : '';

		$w= $imageinfo['width'];
		$h= $imageinfo['height'];


		$thumbRatio = 1; // square
		$inRatio = $w/$h;   
		$isLandscape = $inRatio > $thumbRatio;   
		$size = ($isLandscape ? '1000x'  .$ppg_options['crop_thumbsize'] : $ppg_options['crop_thumbsize'] . 'x1000');
		if($isLandscape)
		{
			$yoff = 0;
			$x = round($ppg_options['crop_thumbsize'] / ($h/$w));
			switch ($crop)
			{
				case 1:
					$xoff = 0;
					break;
				
				case 2:
					$xoff = round(($x - $ppg_options['crop_thumbsize'])/2);
					break;

				case 3:
					$xoff = $x - $ppg_options['crop_thumbsize'];
					break;

				default:
					$xoff = round(($x - $ppg_options['crop_thumbsize'])/2);

			}
		}
		else
		{
			$xoff = 0;
			$y = round($ppg_options['crop_thumbsize'] / ($w/$h));
			switch ($crop)
			{
				case 1:
					$yoff = 0;
					break;
				
				case 2:
					$yoff = round(($y - $ppg_options['crop_thumbsize'])/2);
					break;

				case 3:
					$yoff = $y - $ppg_options['crop_thumbsize'];
					break;

				default:
					$yoff = round(($y - $ppg_options['crop_thumbsize'])/2);

			}
		}

		$IMcommand = '"' . $ppg_options['gallery_programpath'] . 'convert" ' . $imageinfo['location'] . iif(($imageinfo['extension'] == 'gif'), '[0]') . ' -thumbnail ' . $size . ' -crop ' . $ppg_options['crop_thumbsize'] . 'x' . $ppg_options['crop_thumbsize'] . '+' . $xoff . '+'. $yoff . ' -colorspace RGB -strip ' . $sharpen . iif($quality, ' -quality ' . $quality) . ' ' . $tmpname;

		exec($IMcommand);

		if (!in_array($IMerror, array(0, 1)))
		{
			@unlink($tmpname);
			img_error(10);
		}
		else
		{
			header('Content-disposition: inline; filename=crop_image.' . $imageinfo['extension']);
			header('Content-transfer-encoding: binary');
			header('Content-Type: image/' . iif($imageinfo['extension'] == 'jpg', 'jpeg', $imageinfo['extension']));
			// added this if from vbulletin !!!!
			if ($filesize = @filesize($tmpname))
			{
				header("Content-Length: $filesize");
			}
			// end add
			readfile($tmpname);
			@unlink($tmpname);		
		}
		break;
	}
	exit;



?>