<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: browseimages.php                                                 ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/


// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'browseimages');
define('CSRF_PROTECTION', true);
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'forumdisplay',
	'search'
);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
    'ADV_GALLERY_BROWSEIMAGES',
	'adv_gallery_browseimages_perpageopts',
	'adv_gallery_categorybit_level1',
	'adv_gallery_categorybit_level2',
	'adv_gallery_categorybit_main',
	'adv_gallery_categorybit_subcat',
	'adv_gallery_categorybitmain',
	'adv_gallery_imagebit',
	'adv_gallery_imagebit_lite',
	'adv_gallery_letter',
	'adv_gallery_nodisplay',
	'adv_gallery_upload_custombits',
	'adv_gallery_moderator',
	'adv_gallery_category_jump',
	'adv_gallery_category_jump_link',
	'adv_gallery_category_jump_subforum'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ####################### PRE-BACK-END ACTIONS ##########################
function exec_postvar_call_back()
{
	// we clean the option's and the category jump urls so that they dont contain ugly, empty and not needed vars...
	// ATTENTION.. we mainly use $_GET ... instead of clean_array_gpc..
	// it is faster and doesnt affect security as the vars will be recleaned after the redirect !
	// if there is a drawback.. we still can use $vbulletin->input->clean instead...
	// that works here, but the sessionurl does not yet..
//array('jump', 'newposts','newimages', 'popimages', 'favorites', 'subscriptions', 'member', 'searchresults')
//Array ( [stickyorder] => sticky DESC, [fromtable] => ppgal_images AS images [doorderby] => images.dateline [direction] => DESC [limit] => 0,15 ) 
//print_r($condition); exit;




	$goto = '';
	if(intval($_GET['urlcleaner']) == 1)
	{
		$newurl = '';
		// no need to clean gpc, because we are using raw page.. var cleaning is done later
		// and we are only removing stuff...

		if(!empty($_GET['do']))
		{
			if($_GET['do'] != 'browseimages')
			{
				$newurl .= 'do=' . $_GET['do'] . '&amp;';
			}
		}

		if(!empty($_GET['catid']))
		{
			$newurl .= 'catid=' . $_GET['catid'] . '&amp;';
		}
		if(!empty($_GET['imageuser']))
		{
			$newurl .= 'imageuser=' . $_GET['imageuser'] . '&amp;';
		}
		if(!empty($_GET['userid']))
		{
			$newurl .= 'userid=' . $_GET['userid'] . '&amp;';
		}
		if(!empty($_GET['searchid']))
		{
			$newurl .= 'searchid=' . $_GET['searchid'] . '&amp;';
		}
		// these cannot be empty
		$newurl .= 'orderby=' . $_GET['orderby'] . '&amp;';
		$newurl .= 'direction=' . $_GET['direction'] . '&amp;';
		$newurl .= 'cutoffdate=' . $_GET['cutoffdate'];
	
		$file = 'browseimages.php?';
		if (!empty($vbulletin->session->vars['sessionurl_js']))
		{
			exec_header_redirect($file  . $vbulletin->session->vars['sessionurl_js'] . '&amp;' . $newurl);
		}
		else
		{
			if(!empty($_GET['s']))
			{
				exec_header_redirect($file . 's=' . $_GET['s'] . '&amp;' . $newurl);
			}
			else
			{
				exec_header_redirect($file . $newurl);
			}
		}
	}
	// jump from catjump (TODO!! when catjump is active - for the moment do=doit so it wont trigger)
	// not needed anymore... as jump has been removed...
	else if($vbulletin->GPC['doit'] == 'jump' AND $vbulletin->GPC['catid'])
	{
		$goto = '';
		switch ($vbulletin->GPC['catid'])
		{
			case 'home':
				exec_header_redirect('index.php' . $vbulletin->session->vars['sessionurl_q']);
				break;
			case 'search':
				exec_header_redirect('search.php' . $vbulletin->session->vars['sessionurl_q']);
				break;
			case 'favorites':
			case 'showcase':
			case 'subscriptions':
			case 'newimages':
			case 'popimages':
				$catid = $vbulletin->GPC['catid'];
				if($catid == 'newimages')
				{
					$ccoff = '&amp;cutoffdate=100';
				}

//// ooops we dont have sessionurl yet...TODO=>>>>>
				exec_header_redirect("browseimages.php?" . $vbulletin->session->vars['sessionurl'] . 'do=' . $catid . $ccoff);
				break;
			default:
				$catid = intval($vbulletin->GPC['catid']);	
				exec_header_redirect("browseimages.php?" . $vbulletin->session->vars['sessionurl'] . 'c=' . $catid);
				
		}
	}
}
if(!empty($_REQUEST['do']) AND !in_array($_REQUEST['do'], array('jump', 'browseimages', 'newimages', 'newposts','popimages', 'favorites', 'subscriptions', 'member', 'searchresults','enterpassword')))
{
	$_REQUEST['do'] = 'browseimages';
}

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');
require_once(DIR . '/includes/functions_bigthree.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

($hook = vBulletinHook::fetch_hook('ppgal_browse_start')) ? eval($hook) : false;

// #################### TODO ##########################
//$ppg_options['gallery_showquickupload'] = true;
// upload button on pagination level IF->



$show['parentcat'] = true; // needed;

if ($_REQUEST['catid'] AND $_REQUEST['do'] == 'jump')
{
    switch($_REQUEST['catid'])
    {
        case 'home':
            exec_header_redirect('index.php' . $vbulletin->session->vars['sessionurl']);
            break;
        case 'search':
            exec_header_redirect('search.php' . $vbulletin->session->vars['sessionurl']);
            break;
        case 'favorites':
        case 'subscriptions':
        case 'newimages':
        case 'popimages':
            $catid = $_REQUEST['catid'];
            break;
        default:
            $catid = intval($_REQUEST['catid']);
    }
}


if (in_array($catid, array('newimages', 'popimages', 'favorites', 'subscriptions', 'member', 'searchresults')) AND (!isset($_REQUEST['do']) OR $_REQUEST['do'] == 'jump'))
{
    $_REQUEST['do'] = $catid;

}

if (empty($_REQUEST['do']) OR $_REQUEST['do'] == 'jump')
{
	$_REQUEST['do'] = 'browseimages';

}



// Enter password for category
if ($_POST['do'] == 'enterpassword')
{
	
	$catpassword = $vbulletin->input->clean_gpc('p', 'catpassword', TYPE_NOHTML);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_INT);
	$parentlist = explode(',', $categorycache["$catid"]['parentlist']);

	$catopts["$catid"] = construct_cat_opts($categorycache["$catid"]['catid'], $categorycache["$catid"]['options']);

	if ($catopts["$catid"]["$catid"]['canhavepassword'] AND !$categorycache["$catid"]['password'])
	{
		if (!empty($parentlist))
		{
			foreach ($parentlist AS $parentcatid)
			{
				$catopts["$catid"] = construct_cat_opts($parentcatid, $categorycache["$parentcatid"]['options']);
				if ($categorycache["$parentcatid"]['password'] AND $catopts["$catid"]['childpass'] AND $catpassword == $categorycache["$parentcatid"]['password'])
				{
					set_bbarray_cookie('catpassword', $parentcatid, md5($vbulletin->userinfo['userid'] . $catpassword), 1);
					$_REQUEST['do'] = 'browseimages';
				}
			}
		}
	}
	else
	{
		if ($categorycache["$catid"]['password'] == $catpassword)
		{
			set_bbarray_cookie('catpassword', $categorycache["$catid"]['catid'], md5($vbulletin->userinfo['userid'] . $catpassword), 1);
			$_REQUEST['do'] = 'browseimages';
		}
	}
}

$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);
$page = $vbulletin->input->clean_gpc('r', 'page', TYPE_INT);
$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_INT);
$imageuser = $vbulletin->input->clean_gpc('r', 'imageuser', TYPE_INT);
$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);
$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
$cutoffdate = $vbulletin->input->clean_gpc('r', 'cutoffdate', TYPE_NOHTML);
$ltr = $vbulletin->input->clean_gpc('r', 'ltr', TYPE_NOHTML);
$postid = $vbulletin->input->clean_gpc('r', 'postid', TYPE_NOHTML);


if ($cutoffdate != 'lastvisit')
{
	$cutoffdate = intval($cutoffdate);
}

$condition = array();
$wherequery = array();
$letter_all_url = '';
$wherequery[] = 'valid = 1';

$show['category'] = true;

$categoryperms = fetch_category_perms();

if ($_REQUEST['do'] != 'browseimages')
{
	if ($privatecatids = fetch_private_categories())
	{
		$wherequery[] = 'images.catid NOT IN(' . $privatecatids . ')';
	}
}

$ignusers = fetch_ignored_users(intval($catid));
if ($ignusers)
{
	$wherequery[] = 'images.userid NOT IN(' . $ignusers . ')';
}

// Classes for categories
if ($ppg_options['gallery_allowreplies'])
{
	$show['replycells'] = true;
	$stylevar['imagecount'] = 'alt2';
	$stylevar['moderator'] = 'alt2';
}
else
{
	$stylevar['imagecount'] = 'alt1';
	$stylevar['moderator'] = 'alt2';
}


if ($ppg_options['gallery_allowreplies'])
{
	$show['replycells'] = true;
	$ppg_options['alt_imagecount'] = 'alt2';
	$ppg_options['alt_moderator'] = 'alt2';
	
}
else
{
	$ppg_options['alt_imagecount'] = 'alt1';
	$ppg_options['alt_moderator'] = 'alt2';
}



// Let's figure out what we're doing here...
switch ($_REQUEST['do'])
{
	// New Images
	case 'newimages':
		$ppg_vars['top_h1_desc'] = construct_phrase($vbphrase['most_recent_uploads_in_x'], $ppg_options['gallery_title']);
		$catinfo['title'] = $vbphrase['new_images'] . ': ' . iif($cutoffdate == 'lastvisit', $vbphrase['since_your_last_visit'], construct_phrase($vbphrase['last_x_days'], $cutoffdate));
		$catinfo['catid'] = 'newimages';
		$navname = $vbphrase['whats_new'];
		$show['newimages'] = true;
		$show['disableimagedisplay'] = true;
	break;

	// New Posts
	case 'newposts':
		$ppg_vars['top_h1_desc'] = $vbphrase['unread_comments'];
		if (!empty($categoryperms))
		{
			$noreplies = array();
			foreach ($categoryperms AS $catid => $perms)
			{
				if (!$perms['canviewreplies'])
				{
					$noreplies[] = $catid;
				}
			}
		}

		$wherequery[] = 'images.posts != 0';

		if (!empty($noreplies))
		{
			$wherequery[] = 'images.catid NOT IN(' . implode(',', $noreplies) . ')';
		}

		$catinfo['title'] = $vbphrase['new_comments'] . ': ' . iif($cutoffdate == 'lastvisit', $vbphrase['since_your_last_visit'], construct_phrase($vbphrase['last_x_days'], $cutoffdate));
		$catinfo['catid'] = 'newposts';
		$navname = $vbphrase['whats_new'];
		$show['newposts'] = true;
		$show['disableimagedisplay'] = true;

	break;

	// Popular Images
	case 'popimages':
		$ppg_vars['top_h1_desc'] = $vbphrase['most_popular_uploads'];
		switch ($orderby)
		{
			case 'posts':
				$catinfo['title'] = construct_phrase($vbphrase['top_x_replied_to_images'], $ppg_options['gallery_popimagelimit']);
				$condition['doorderby'] = 'posts';
			break;
			case 'rating':
				$condition['votequery'] = 'IF(votenum >= ' . $ppg_options['gallery_popimages_votelimit'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $ppg_options['gallery_popimages_votelimit'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
				$condition['doorderby'] = 'voteavg DESC, votenum';
				$wherequery[] = 'votenum >= ' . $ppg_options['gallery_popimages_votelimit'];
				$catinfo['title'] = construct_phrase($vbphrase['top_x_rated_images'], $ppg_options['gallery_popimagelimit']);

			break;
			default:
				$condition['doorderby'] = 'views';
				$orderby = 'views';
				$catinfo['title'] = construct_phrase($vbphrase['top_x_viewed_images'], $ppg_options['gallery_popimagelimit']);
		}

		$orderbysel["$orderby"] = 'selected="selected"';

		$condition['limit'] = $ppg_options['gallery_popimagelimit'];
		$condition['direction'] = 'DESC';
		$navname = $vbphrase['whats_popular'];
		$show['popimages'] = true;
		$show['disableimagedisplay'] = true;
		$catinfo['catid'] = 'popimages';

	break;

	// Favorites
	case 'favorites':

		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}
		
		$ppg_vars['top_h1_desc'] = '<a href="browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=subscriptions" title="' . $vbphrase['my_subscriptions'] . '">' . $vbphrase['my_subscriptions'] . '</a> &bull; <a href="browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=member&amp;imageuser=' . $vbulletin->userinfo['userid'] . '" title="' . $vbphrase['my_images'] . '">' . $vbphrase['my_images'] . '</a>';
		$catinfo['title'] = $vbphrase['my_favorites'];
		$navname = $vbphrase['my_favorites'];
		$catinfo['catid'] = 'favorites';
		$show['dir_search'] = true;
		$condition['fromtable'] = 'ppgal_favorites AS favorites';
		$condition['join'] = 'ppgal_images AS images';
		$wherequery[] = 'favorites.userid = ' . $vbulletin->userinfo['userid'];

		$show['speciallink'] = true;
		$ppg_vars['speciallink'] = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=member&amp;imageuser=' . $vbulletin->userinfo['userid'];
		$vbphrase['view_parent_category'] = $vbphrase['back_to_my_images'];

	break;

	// Subscriptions
	case 'subscriptions':

		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}
	
		$ppg_vars['top_h1_desc'] = '<a href="browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=favorites" title="' . $vbphrase['my_favorites'] . '">' . $vbphrase['my_favorites'] . '</a> &bull; <a href="browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=member&amp;imageuser=' . $vbulletin->userinfo['userid'] . '" title="' . $vbphrase['my_images'] . '">' . $vbphrase['my_images'] . '</a>';
	

		$catinfo['title'] = $vbphrase['my_subscriptions'];
		$navname = $vbphrase['my_subscriptions'];
		$catinfo['catid'] = 'subscriptions';
		$condition['fromtable'] = 'ppgal_subscribeimage AS subscribeimage';
		$condition['join'] = 'ppgal_images AS images';
		$wherequery[] = 'subscribeimage.userid = ' . $vbulletin->userinfo['userid'];

		if ($page == 1 OR !$page)
		{
			$getsubcats = $db->query_read("
					SELECT categories.*, subscribecat.catuserid, user.username AS catusername
					FROM " . TABLE_PREFIX . "ppgal_categories AS categories
					LEFT JOIN " . TABLE_PREFIX . "ppgal_subscribecat AS subscribecat ON (categories.catid = subscribecat.catid)
					LEFT JOIN " . TABLE_PREFIX . "user AS user ON (subscribecat.catuserid = user.userid)
					WHERE subscribecat.userid = '" . $vbulletin->userinfo['userid'] . "'
					ORDER BY displayorder
			");
			if ($db->num_rows($getsubcats))
			{
				$show['subcats'] = true;
				$vbphrase['sub_categories'] = $vbphrase['categories'];
				$catsinfo = array();
				while ($subcats = $vbulletin->db->fetch_array($getsubcats))
				{
					$subcats['level'] = 1;
					if ($subcats['catuserid'])
					{
						$subcats['userid'] = $subcats['catuserid'];
					}
					$catsinfo["$subcats[catid]"] = $subcats;
				}

				$show['subscribe_options'] = true;
				$subcatbits = print_categories(0, $catsinfo, true);
			}

			$db->free_result($getsubcats);
			unset($subcats);
		}
		$show['speciallink'] = true;
		$ppg_vars['speciallink'] = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=member&amp;imageuser=' . $vbulletin->userinfo['userid'];
		$vbphrase['view_parent_category'] = $vbphrase['back_to_my_images'];
	break;

	// Member
	case 'member':

		
		if (!$imageuser)
		{
			eval(standard_error(fetch_error('noid', $vbphrase['user'], $vbulletin->options['contactuslink'])));
		}

		$wherequery[] = 'images.userid = \'' . $imageuser . '\'';
		$show['dir_search'] = false;

		if ($page == 1 OR !$page)
		{
			$getsubcats = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_categories WHERE catuserid = '$imageuser'");
			while ($cats = $vbulletin->db->fetch_array($getsubcats))
			{
				$catsinfo["$cats[catid]"] = $cats;
				$catsinfo["$cats[catid]"]['level'] = 1;
			}

			$db->free_result($getsubcats);
			unset($cats);

			if (!empty($catsinfo))
			{
				$wherequery[] = 'images.catid NOT IN(' . implode(',', array_keys($catsinfo)) . ')';
				$show['subcats'] = true;
				$subcatbits = print_categories(0, $catsinfo, true);
				
			}
		}


	break;

	// Search Results
	case 'searchresults':

		$search = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_search WHERE searchid = '$searchid'");
		if (!$search['searchid'])
		{
			eval(standard_error(fetch_error('searchnoresults', '')));
		}
		$ppg_vars['top_h1_desc'] = '<dl class="submtitle"><dt>' . $vbphrase['key_words'] . ':&nbsp;</dt>';


		$condition['orderby'] = $search['orderby'];
		$catinfo['title'] = $vbphrase['search_results'];
		$navname = $vbphrase['search_results'];
		$wherequery[] = 'images.imageid IN(' . $search['imageids'] . ')';

		$search['keywords'] = explode(' ', stripslashes($search['string']));
		$comma = '';
		foreach ($search['keywords'] AS $key => $keyword)
		{
			if ($key > 0)
			{
				$comma = ' &nbsp; ';
			}
	
			$keywords .= "<dd> $comma <u>$keyword</u></dd>";
			
		}
		
		$ppg_vars['top_h1_desc'] .= $keywords;

		if($search['keywords'] AND $search['username'])
		{
			$ppg_vars['sep'] = '<dt>&nbsp;&nbsp;-&nbsp;&nbsp;</dt>';
			$ppg_vars['top_h1_desc'] .= $ppg_vars['sep'];

		}

		if ($search['username'])
		{
			$search['username'] = unserialize($search['username']);
			foreach ($search['username'] AS $iuserid => $username)
			{
				if($username != '')
				{
					$username = htmlspecialchars_uni($username);
					$search['usernames']["$iuserid"] = '<dd>&nbsp;<a href="' . $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $iuserid, 'username' =>  $username)) . '"><b>' . $username . '</b></a>&nbsp;</dd>';
				}

				// $search['usernames']["$userid"] = '<a href="' . $vbulletin->options['bburl'] . '/member.php?u=' . $userid . '"><b><u>' . $username . '</b></u></a>';
			}
			unset($iuserid);
			$search['usernames'] = implode(' ' . $vbphrase['or'] . ' ', $search['usernames']);
			$ppg_vars['top_h1_desc'] .= '<dt>' . $vbphrase['posts_made_by'] . '</dt>  ' . $search['usernames'];
		}
		$ppg_vars['top_h1_desc'] .=  '</dl>';

		$highlight['string'] = $search['string'];
		$highlight['fields'] = $search['sfields'];
		$highlight['wholeword'] = $search['wholeword'];


		$show['speciallink'] = true;
		$ppg_vars['speciallink'] = 'search.php' . $vbulletin->session->vars['sessionurl_q'];
		$vbphrase['view_parent_category'] = $vbphrase['back_to_main_searchpage'];


	break;

	// Browse category
	default:
		global $metabits;
		$metabits = array();
		$catid = intval($catid);

		// Join subscribecat if needed
		if ($_REQUEST['do'] == 'browseimages' AND $ppg_options['gallery_allowsubscribe'] AND $vbulletin->userinfo['userid'])
		{
			$catquery['subdirfields'] = ', NOT ISNULL(subscribecat.catid) AS subsribecatid, subscribecat.catuserid AS subcatuserid';
			$catquery['subdirjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_subscribecat AS subscribecat ON (categories.catid = subscribecat.catid AND subscribecat.userid = ' . $vbulletin->userinfo['userid'] . ')';
		}

		// Get category info
		$catinfo = $db->query_first("
				SELECT categories.catid, title, description, description_clean, hasimages, categories.catuserid, password, parent, parentlist, membercat, options, useroptions
				$catquery[subdirfields]
				FROM " . TABLE_PREFIX . "ppgal_categories AS categories
				$catquery[subdirjoin]
				WHERE categories.catid = '$catid'
		");
		unset($catquery);

		if (!$catinfo['catid'])
		{
			
			standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['contactuslink']));
		}

		if (!$categoryperms["$catinfo[catid]"]['canviewgallery'] OR !$categoryperms["$catinfo[catid]"]['canviewimages'])
		{
			print_no_permission();
		}

		check_category_password($catinfo['catid']);

		$wherequery[] = 'images.catid = \'' . $catid . '\'';
		$condition['stickyorder'] = 'sticky DESC,';

		if ($catinfo['catuserid'] AND $catinfo['catuserid'] != $vbulletin->userinfo['userid'] AND !is_category_mod($catinfo['catid']))
		{
			$useroptions = construct_cat_user_opts($catinfo['catid'], $catinfo['useroptions']);
			if (!$useroptions['allow_view'])
			{
				print_no_permission();
			}
		}

		if ($catinfo['membercat'])
		{
			
			if(isset($_REQUEST['userid']) AND intval($_REQUEST['userid']) > 0)
			{
				$userid = intval($_REQUEST['userid']);
			}
			// todo check allow subscribe etc...
			$show['category_tools'] = true;
			// todo check category catcreate
			$show['catcreate'] = true;

			$show['cat_search'] = iif($categoryperms["$catinfo[catid]"]['cansearchimages'], true);
			$show['unsubscribe_cat'] = iif($catinfo['subsribecatid'] AND $catinfo['subcatuserid'] == $userid, true);
            $show['quickupload'] = iif($ppg_options['gallery_showquickupload'] AND $categoryperms["$catinfo[catid]"]['canuploadimages'] AND $catinfo['hasimages'] == 1, true);



			$membsubcats = fetch_category_children($catinfo['catid']);
			$membercats = array();

			if (intval($userid))
			{
				$wherequery[] = 'userid = ' . $userid;

				if (!intval($page))
				{
					$membersubs = $db->query_read("
							SELECT *
							FROM " . TABLE_PREFIX . "ppgal_categories
							WHERE catuserid = '$userid' AND catid IN(" . implode(',', $membsubcats) . ")
							ORDER BY $ppg_options[gallery_catsorderby] $ppg_options[gallery_catsdirection]
					");
					while ($membsub = $vbulletin->db->fetch_array($membersubs))
					{
						$membsub['level'] = $categorycache["$membsub[catid]"]['level'] - $categorycache["$catinfo[catid]"]['level'];
						$membercats[] = $membsub;
					}

					$db->free_result($membersubs);
					unset($membsub);

					$membercats = construct_category_counters($membercats, $catinfo['catid']);

					if (!empty($membercats))
					{
						$subcatbits = print_categories($catinfo['catid'], $membercats);
						$show['subcats'] = true;


					}
				}
			}
			else
			{

				

				$show['noimagedisplay'] = true;
				$show['disableimagedisplay'] = true;
				$disableimagedisplay = true;

				// Letterbits
				$show['selectedletter'] = false;
				$show['letter_showall'] = false;
				$letter = '#';
				if ($ltr == 'nonalpha')
				{
					$show['selectedletter'] = true;
					$show['letter_showall'] = true;
				}
				
				$letter_all_url = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $catinfo['catid'];
				$letterurl = $letter_all_url .'&amp;ltr=nonalpha';
				//eval('$letterbits = "' . fetch_template('adv_gallery_letter') . '";');
				$templater = vB_Template::create('adv_gallery_letter');
					$templater->register('letter', $letter);
					$templater->register('letterurl', $letterurl);
					$templater->register('item', $item);
				$letterbits = $templater->render();
				// The rest of the alphabet
				$alphabet = range('A', 'Z');

				foreach($alphabet as $letter)
				{
					$show['selectedletter'] = ($ltr == $letter) ? true : false;
					if($show['selectedletter'] AND !$show['letter_showall'])
					{
						$show['letter_showall'] = true;
					}
					$letterurl = $letter_all_url .'&amp;ltr=' . $letter;
					//$letterurl = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'ltr=' . $letter . '&amp;c=' . $catinfo['catid'];
					//eval('$letterbits .= "' . fetch_template('adv_gallery_letter') . '";');
					$templater = vB_Template::create('adv_gallery_letter');
						$templater->register('letter', $letter);
						$templater->register('letterurl', $letterurl);
						$templater->register('item', $item);
					$letterbits .= $templater->render();
	
				}

				if ($ltr AND ($ltr == 'nonalpha' OR in_array($ltr, $alphabet)))
				{
					$letterquery = iif($ltr == 'nonalpha', 'AND username NOT REGEXP("^[a-zA-Z]")', 'AND username LIKE(\'' . $db->escape_string_like($ltr) . '%\')');
		
				}

				$catuserids = array();

				if (!empty($membsubcats))
				{
					$membsubinfo = array();
					$membersubs = $db->query_read("
							SELECT catid, catuserid, parent, imagecount, postcount, lastimageid, lastimagetitle, lastimageuserid, lastimageusername, lastimagedateline, lastpostid, lastpostimagetitle, lastpostuserid, lastpostusername, lastpostdateline, active, hasimages
							FROM " . TABLE_PREFIX . "ppgal_categories AS categories
							WHERE catid IN(" . implode(',', $membsubcats) . ") AND catid != $catinfo[catid] " . iif($ignusers, 'AND catuserid NOT IN(' . $ignusers . ')')
					);
					while ($membsub = $vbulletin->db->fetch_array($membersubs))
					{
						$membsub['username'] = $categorycache["$membsub[catid]"]['username'];
						if (!$membsub['username'])
						{
							$membsub['username'] = $vbphrase['unregistered'];
						}

						if ($ltr)
						{
							if (strtoupper($membsub['username']{0}) != $ltr)
							{
								continue;
							}
						}

						$membsub['level'] = 1;
						$membsub['imagecount'] += $membsubinfo["$membsub[catuserid]"]['imagecount'];
						$membsub['postcount'] += $membsubinfo["$membsub[catuserid]"]['postcount'];

						if ($membsub['lastimagedateline'] < $membsubinfo["$membsub[catuserid]"]['lastimagedateline'])
						{
							$membsub['lastimagedateline'] = $membsubinfo["$membsub[catuserid]"]['lastimagedateline'];
							$membsub['lastimageid'] = $membsubinfo["$membsub[catuserid]"]['lastimageid'];
							$membsub['lastimagetitle'] = $membsubinfo["$membsub[catuserid]"]['lastimagetitle'];
							$membsub['lastimageuserid'] = $membsubinfo["$membsub[catuserid]"]['lastimageuserid'];
							$membsub['lastimageusername'] = $membsubinfo["$membsub[catuserid]"]['lastimageusername'];
						}

						if ($membsub['lastpostdateline'] < $membsubinfo["$membsub[catuserid]"]['lastpostdateline'])
						{
							$membsub['lastpostdateline'] = $membsubinfo["$membsub[catuserid]"]['lastpostdateline'];
							$membsub['lastpostid'] = $membsubinfo["$membsub[catuserid]"]['lastpostid'];
							$membsub['lastpostimagetitle'] = $membsubinfo["$membsub[catuserid]"]['lastpostimagetitle'];
							$membsub['lastpostuserid'] = $membsubinfo["$membsub[catuserid]"]['lastpostuserid'];
							$membsub['lastpostusername'] = $membsubinfo["$membsub[catuserid]"]['lastpostusername'];
						}

						$membsubinfo["$membsub[catuserid]"] = $membsub;

						$catuserids["$membsub[username]"] = $membsub['catuserid'];
					}
					$db->free_result($membersubs);
					unset($membsub);
				}

				$userimages = array();
				
				
			
				$membcats = $db->query_read("
						SELECT DISTINCT userid, username
						FROM " . TABLE_PREFIX . "ppgal_images
						WHERE catid = '$catinfo[catid]' AND valid = 1 $letterquery " . iif($ignusers, 'AND userid NOT IN(' . $ignusers . ')')

				);


				while ($mcat = $vbulletin->db->fetch_array($membcats))
				{
					if (!$mcat['username'])
					{
						$mcat['username'] = $vbphrase['unregistered'];
					}
					$userimages[] = $mcat['userid'];
					$catuserids["$mcat[username]"] = $mcat['userid'];
				}

				$db->free_result($membcats);
				unset($mcat);

				$perpage = $ppg_options['gallery_catsperpage'];
				$pagenumber = intval($_REQUEST['pagenumber']);

				$catpagecount = sizeof($catuserids);

				if (!$pagenumber)
				{
					$pagenumber = 1;
				}

				$minlimit = intval(($pagenumber - 1) * $perpage + 1) - 1;
				$maxlimit = intval($pagenumber * $perpage) - 1;

				if ($maxlimit >= $catpagecount)
				{
					$maxlimit = $catpagecount - 1;
					if ($minlimit > $catpagecount)
					{
					  $minlimit = $catpagecount - $perpage;
					}
				}
				if ($minlimit <= 1)
				{
				  $minlimit = 0;
				}

				uksort($catuserids, 'strnatcasecmp');

				if (!empty($catuserids))
				{
					$useridquery = array();

					foreach ($catuserids AS $iusername => $iuserid)
					{
						if ($catuseridcount >= $minlimit AND $catuseridcount <= $maxlimit)
						{
							if (in_array($iuserid, $userimages))
							{
								$useridquery[] = $iuserid;
							}
							$username = $membsubinfo["$iuserid"]['username'];
							$membsubinfo["$iuserid"]['title'] = $username;
							$membsubinfo["$iuserid"]['catid'] = $catinfo['catid'];
							$membsubinfo["$iuserid"]['userid'] = $iuserid;
							$membsubinfo["$iuserid"]['catuserid'] = '';

							$membercats["$username"] = $membsubinfo["$iuserid"];
						}
						$catuseridcount++;
					}

					$catpagenav = construct_page_nav($pagenumber, $perpage, sizeof($catuserids), 'browseimages.php?' . construct_adv_sort_url());

					if (!empty($useridquery))
					{
						$getuserimages = $db->query_read("SELECT imageid, title, userid, username, posts, userid, dateline, lastpostusername, lastpostuserid, lastpostdateline FROM " . TABLE_PREFIX . "ppgal_images WHERE catid = '$catinfo[catid]' AND userid IN(" . implode(',', $useridquery) . ") AND valid = 1");
						while ($users = $vbulletin->db->fetch_array($getuserimages))
						{
							$uname = $users['username'];
							$membercats["$uname"]['title'] = $users['username'];
							$membercats["$uname"]['catid'] = $catinfo['catid'];
							$membercats["$uname"]['active'] = 1;
							$membercats["$uname"]['hasimages'] = 1;
							$membercats["$uname"]['level'] = 1;
							$membercats["$uname"]['userid'] = $users['userid'];
							$membercats["$uname"]['parent'] = $catinfo['catid'];
							$membercats["$uname"]['postcount'] += $users['posts'];
							$membercats["$uname"]['imagecount']++;

							if ($users['dateline'] > $membercats["$uname"]['lastimagedateline'])
							{
								$membercats["$uname"]['lastimageid'] = $users['imageid'];
								$membercats["$uname"]['lastimagetitle'] = $users['title'];
								$membercats["$uname"]['lastimageuserid'] = $users['userid'];
								$membercats["$uname"]['lastimageusername'] = $users['username'];
								$membercats["$uname"]['lastimagedateline'] = $users['dateline'];
							}
							if ($users['lastpostdateline'] > $membercats["$uname"]['lastpostdateline'])
							{
								$membercats["$uname"]['lastpostimageid'] = $users['imageid'];
								$membercats["$uname"]['lastpostuserid'] = $users['lastpostuserid'];
								$membercats["$uname"]['lastpostimagetitle'] = $users['title'];
								$membercats["$uname"]['lastpostusername'] = $users['lastpostusername'];
								$membercats["$uname"]['lastpostdateline'] = $users['lastpostdateline'];
							}
						}
						$db->free_result($getuserimages);
						unset($users);
					}

					$noimagedisplay = true;
					$show['disableimagedisplay'] = true;

					if (!empty($membercats))
					{
						uksort($membercats, 'strnatcasecmp');
						$subcatbits = print_categories('', $membercats, 'members');
						$show['subcats'] = true;

					}
				}
				else
				{
					$noimagedisplay = true;
					//eval('$imagebits = "' . fetch_template('adv_gallery_nodisplay') . '";');
					$templater = vB_Template::create('adv_gallery_nodisplay');
					$templater->register('colspan', $colspan);
					$imagebits = $templater->render();
					$pagedata['minlimit'] = 0;
				}
				
			}


				//print "test"; exit;
		}
		else // if membercat
		{
			if (!$catinfo['hasimages'])
			{
				$noimagedisplay = true;
				$show['noimagedisplay'] = true;
				$show['disableimagedisplay'] = true;
			}

			$show['unsubscribe_cat'] = iif($catinfo['subsribecatid'], true);

			$catopts["$catid"] = construct_cat_opts($catinfo['catid'], $catinfo['options']);

			$noimagedispaly = iif(!$catinfo['hasimages'] OR !$categoryperms["$catinfo[catid]"]['canviewimages'], true);

			$show['categoryhead'] = false;
			$show['category_tools'] = true;
			$show['cat_search'] = iif($categoryperms["$catinfo[catid]"]['cansearchimages'], true);

			$show['category'] = false;
			if($subcatbits = print_categories($catinfo['catid']))
			{

				$show['subcats'] = true;

			}

		}
		break;
				$show['speciallink'] = true;
		$ppg_vars['speciallink'] = 'search.php' . $vbulletin->session->vars['sessionurl_q'];
		$vbphrase['view_parent_category'] = $vbphrase['back_to_main_searchpage'];
}

$adv_sorturl = construct_adv_sort_url();

if (!isset($condition['fromtable']))
{
	$condition['fromtable'] = 'ppgal_images AS images';
}

if (in_array($_REQUEST['do'], array('browseimages', 'favorites', 'subscriptions', 'member', 'newimages', 'newposts', 'searchresults')))
{
	// Order By

	switch ($_REQUEST['do'])
	{
		case 'newimages':
			$condition['doorderby'] = 'dateline';
			$condition['direction'] = 'DESC';
		break;

		case 'newposts':
			$condition['doorderby'] = 'images.lastpostdateline DESC, imageid';
			$condition['direction'] = 'DESC';
		break;

		default:
			$condition['doorderby'] = construct_orderby();
			if ($condition['doorderby'] == $ppg_options['gallery_deforder'] OR !$orderby)
			{
				$orderby = $ppg_options['gallery_deforder'];
			}
	}

	if ($orderby == 'rating')
	{
		$condition['votequery'] = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
	}

	$ordersel = array();
	$ordersel["$orderby"] = 'selected="selected"';

	// Direction
	if (in_array($direction, array('DESC', 'ASC')))
	{
		$condition['direction'] = $direction;
	}
	else if (!$condition['direction'])
	{
		$condition['direction'] = $ppg_options['gallery_defdirection'];
	}

	$oppositesort = iif($condition['direction'] == 'ASC', 'DESC', 'ASC');

	$dirsel["$condition[direction]"] = 'selected="selected"';

	// Cutoff date
	if ($cutoffdate AND $cutoffdate != -1)
	{
		$wherequery[] = 'images.' . iif($_REQUEST['do'] == 'newposts', 'lastpost') . 'dateline > ' . iif($cutoffdate == 'lastvisit', $vbulletin->userinfo['lastvisit'], (time() - ($cutoffdate * 86400)));
	}

	if (!$cutoffdate OR $cutoffdate == -1)
	{
		$cutoffdate = 'all';
	}

	$datecutsel = array();
	$datecutsel["$cutoffdate"] = 'selected="selected"';

	$pparray = array();

	if ($ppg_options['gallery_imageperpage_multiplier'])
	{
		$ppmult = 0;

		$pp_sorturl = construct_adv_sort_url();

		while ($ppmult <= $ppg_options['gallery_imageperpage_multiplier'])
		{
			$ppmult++;
			$multvalue = $ppmult * $ppg_options['gallery_imagesperpage'];
			$pparray[] = $multvalue;
			//if ($show['popups'])
			//{
				//$perpageopts .= "' . fetch_template('adv_gallery_browseimages_perpageopts') . '";
				$templater = vB_Template::create('adv_gallery_browseimages_perpageopts');
				$templater->register('multvalue', $multvalue);
				$templater->register('pp_sorturl', $pp_sorturl);
				$perpageopts .= $templater->render();
			//}
			//else
			//{
			//	$perpageopts .= '<option ' . iif($multvalue == $perpage, 'selected="selected"') . ' value="' . $multvalue . '">' //.$multvalue . '</option>';
			//}
		}
	}

	/*if (!$show['popups'])
	{
		$perpagedisplay = construct_phrase($vbphrase['x_images_per_page'], '<form action="browseimages.php" method="get"><input type="hidden" name="catid" value="' . $catinfo['catid'] . '" /><select name="perpage" onchange="submit();">' . $perpageopts . '</select></form> &nbsp; ');
	}
*/
	if (!$show['noimagedisplay'])
	{
		$pagedata = fetch_page_data('browseimages', 'ppgal_images');
		$perpage = $pagedata['perpage'];
		$pagenumber = $pagedata['pagenumber'];
		$condition['limit'] = ($pagedata['minlimit'] - 1) . ',' . $pagedata['perpage'];
	}

	if (!$pagedata['count'])
	{
		$noimagedisplay = true;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $pagedata['count'], 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=' . $_REQUEST['do'] . $adv_sorturl);
}
if ($ppg_options['gallery_showcatdesc'])
{
	require_once(DIR . '/includes/functions_wysiwyg.php');
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
}

if (!$noimagedisplay)
{

	$imageids = array();
	$getids = $db->query_read("
			SELECT $condition[votequery] images.imageid
			FROM " . TABLE_PREFIX . $condition['fromtable'] . "
			" . iif($condition['join'], 'LEFT JOIN ' . TABLE_PREFIX . $condition['join'] . ' USING (imageid)') . "
  		" . iif(!empty($wherequery), 'WHERE ' . implode(' AND ', $wherequery)) . "
			ORDER BY $condition[stickyorder] $condition[doorderby] $condition[direction], images.imageid DESC
			LIMIT $condition[limit]
	");
	while ($images = $vbulletin->db->fetch_array($getids))
	{
		$imageids[] = $images['imageid'];
	}

	$db->free_result($getids);
	unset($images);

	if (!empty($imageids))
	{
		$query = fetch_image_fields();

		// require_once(DIR . '/includes/class_bbcode.php');
		
		// Get Images
		$getimages = $db->query_read("
				SELECT $condition[votequery] images.imageid, filename, originalname, thumbname, extension, images.title, images.catid, sticky, open $query[fields]
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				$query[tables]
				WHERE images.imageid IN(" . implode(',', $imageids) . ")
				ORDER BY $condition[stickyorder] $condition[doorderby] $condition[direction], imageid DESC
		");
		$counter = 0;
		$slidecount = 0;
		$cellwidth = round(100 / $ppg_options['gallery_columns']) . '%';
		$tmp_vars['meta_keyw'] = '';
		$tmp_vars['meta_img_desc'] = '';
		unset($query);
		while ($images = $vbulletin->db->fetch_array($getimages))
		{
			$counter++;
			$slidecount++;
			if($counter > 1)
			{
				$tmp_vars['meta_img_desc'] .= ',';
			}
			$tmp_vars['meta_keyw'] .= ' ' . $images['title'];
			$tmp_vars['meta_img_desc'] .= ' ' . $images['title'];
	        $images['title'] = vbchop($images['title'], 150); // image title chop // redo that... cause db field is not that long
			$imageusername = stripslashes($images['username']);
			$imagebits .= construct_imagebits($images);

		}

		$db->free_result($getimages);
		unset($images);


		$imagebits .= construct_empty_cellbits($ppg_options['gallery_columns']);

		if ($_REQUEST['do'] == 'member' OR ($_REQUEST['do'] == 'browseimages' AND $userid))
		{
			if($_REQUEST['do'] == 'member' AND $slidecount>1)
			{
				$show['slideshow'] = true;
				
				$ppg_vars['slides_link'] = '<a href="misc.php?' . $vbulletin->session->vars['sessionurl'] . 'do=slideshow&amp;imageuser=' . $imageuser . '">' . $vbphrase['view_slideshow'] . '</a>';

			}
			else
			{
				$ppg_vars['slides_link'] = '';
			}
			
			if($ppg_options['gallery_use_plurals_s'])
			{
				$catinfo['title'] = construct_phrase($vbphrase['usernames_images'], $imageusername, iif(substr( strtolower($imageusername), -1) != 's', $vbphrase['plural_s']));
			}
			else
			{
				$catinfo['title'] = construct_phrase($vbphrase['usernames_images'], $imageusername, $vbphrase['plural_s']);
			}
			$navname = $catinfo['title'];
			$show['parentcat'] = false;

			$tmpvar = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $imageuser, 'username' =>  $imageusername));
			if($ppg_options['gallery_use_plurals_s'])
			{
				$tmpvarhover = construct_phrase($vbphrase['x_profile'], $imageusername, iif(substr( strtolower($imageusername), -1) != 's', $vbphrase['plural_s']));
			}
			else
			{
				$tmpvarhover = construct_phrase($vbphrase['x_profile'], $imageusername, $vbphrase['plural_s']);
			}
			if($show['isuserblog'])
			{

				$tmpvarblog = $vbulletin->options['bburl'] . '/blog.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $imageuser;

				if($ppg_options['gallery_use_plurals_s'])
				{
					$tmpvarbloghover = construct_phrase($vbphrase['x_blog'], $imageusername, iif(substr( strtolower($imageusername), -1) != 's', $vbphrase['plural_s']));
					$ppg_vars['top_h1_desc'] = construct_phrase($vbphrase['visit_usernames_profile_or_blog'], $imageusername, iif(substr( strtolower($imageusername), -1) != 's', $vbphrase['plural_s']), $tmpvarhover,  $tmpvar, $tmpvarbloghover, $tmpvarblog);
				}
				else
				{
					$tmpvarbloghover = construct_phrase($vbphrase['x_blog'], $imageusername, $vbphrase['plural_s']);
					$ppg_vars['top_h1_desc'] = construct_phrase($vbphrase['visit_usernames_profile_or_blog'], $imageusername, $vbphrase['plural_s'], $tmpvarhover,  $tmpvar, $tmpvarbloghover, $tmpvarblog);
				}
				

				unset($tmpvar, $tmpvarblog, $tmpvarhover, $tmpvarbloghover);
			}
			else
			{
				if($ppg_options['gallery_use_plurals_s'])
				{
					$ppg_vars['top_h1_desc'] = construct_phrase($vbphrase['visit_usernames_profile'], $imageusername, iif(substr( strtolower($imageusername), -1) != 's', $vbphrase['plural_s']), $tmpvarhover, $tmpvar);
				}
				else
				{
					$ppg_vars['top_h1_desc'] = construct_phrase($vbphrase['visit_usernames_profile'], $imageusername, $vbphrase['plural_s'], $tmpvarhover, $tmpvar);
				}
				unset($tmpvar, $tmpvarhover);
			}
			if($ppg_vars['slides_link'] != '')
			{
				$ppg_vars['top_h1_desc'] = '<span style="float:'.$vbulletin->stylevars['right']['string'].';">' . $ppg_vars['slides_link'] . '</span>' . $ppg_vars['top_h1_desc'];
			}
			
		}
		else
		{
		

			if(!$ppg_vars['top_h1_desc'] AND $ppg_options['gallery_showcatdesc'])
			{
				$ppg_vars['top_h1_desc'] = $catinfo['description_clean'];


				// $bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
				if ($ppg_options['gallery_showcatdesc'])
				{
					$ppg_vars['top_h1_desc'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($ppg_vars['top_h1_desc']));
				}
			}
			$navname = $catinfo['title'];
		}
	
		if ($_REQUEST['do'] == 'browseimages')
		{
			$gallery_modcache = cache_gallery_mods();
			$mods = "";
			$donemods = array();

			foreach (explode(',', $catinfo['parentlist']) AS $parentid)
			{
				if ($gallery_modcache["$parentid"])
				{
					$show['comma_leader'] = false;
					foreach($gallery_modcache["$parentid"] AS $moderator)
					{
						if (!in_array($moderator['userid'], $donemods))
						{
							$donemods[] = $moderator['userid'];
							$moderator['link'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $moderator['userid'], 'username' =>  htmlspecialchars_uni($moderator['musername'])));					
							$templater = vB_Template::create('adv_gallery_moderator');
  							$templater->register('moderator', $moderator);
							$mods .= trim($templater->render());
							$show['comma_leader'] = true;
						}
					}
				}
			}
			$modcount = sizeof($donemods);
		}
	}
	else
	{
		
		$templater = vB_Template::create('adv_gallery_nodisplay');
		$templater->register('colspan', $colspan);
		$imagebits = $templater->render();
		$pagedata['minlimit'] = 0;
	}	
}
else
{
	$ppg_vars['top_h1_desc'] = $catinfo['description_clean'];

	if ($_REQUEST['do'] == 'member' OR ($_REQUEST['do'] == 'browseimages' AND $userid))
	{
		$thisuserid = ($_REQUEST['do'] == 'member') ? $imageuser : $userid;		

		$user = $db->query_first("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = '" . $thisuserid . "'");
		$imageusername = $user['username'];
		if($ppg_options['gallery_use_plurals_s'])
		{
			$catinfo['title'] = construct_phrase($vbphrase['usernames_images'], $imageusername, iif(substr($imageusername, -1) != 's', $vbphrase['plural_s']));
		}
		else
		{
			$catinfo['title'] = construct_phrase($vbphrase['usernames_images'], $imageusername, $vbphrase['plural_s']);
		}
		$navname = $catinfo['title'];

		$show['parentcat'] = false;
		

		$tmpvar = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $thisuserid, 'username' =>  $imageusername));
		if($ppg_options['gallery_use_plurals_s'])
		{
			$tmpvarhover = construct_phrase($vbphrase['x_profile'], $imageusername, iif(substr( strtolower($imageusername), -1) != 's', $vbphrase['plural_s']));
		}
		else
		{
			$tmpvarhover = construct_phrase($vbphrase['x_profile'], $imageusername, $vbphrase['plural_s']);
		}
		if($show['isuserblog'])
		{
			$tmpvarblog = $vbulletin->options['bburl'] . '/blog.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $thisuserid;
			if($ppg_options['gallery_use_plurals_s'])
			{
				$tmpvarbloghover = construct_phrase($vbphrase['x_blog'], $imageusername, iif(substr( strtolower($imageusername), -1) != 's', $vbphrase['plural_s']));
				$ppg_vars['top_h1_desc'] = construct_phrase($vbphrase['visit_usernames_profile_or_blog'], $imageusername, iif(substr( strtolower($imageusername), -1) != 's', $vbphrase['plural_s']), $tmpvarhover,  $tmpvar, $tmpvarbloghover, $tmpvarblog);
			}
			else
			{
				$tmpvarbloghover = construct_phrase($vbphrase['x_blog'], $imageusername, $vbphrase['plural_s']);
				$ppg_vars['top_h1_desc'] = construct_phrase($vbphrase['visit_usernames_profile_or_blog'], $imageusername, $vbphrase['plural_s'], $tmpvarhover,  $tmpvar, $tmpvarbloghover, $tmpvarblog);
			}
			unset($tmpvar, $tmpvarblog, $tmpvarhover, $tmpvarbloghover);
		}
		else
		{
			if($ppg_options['gallery_use_plurals_s'])
			{
				$ppg_vars['top_h1_desc'] = construct_phrase($vbphrase['visit_usernames_profile'], $imageusername, iif(substr( strtolower($imageusername), -1) != 's', $vbphrase['plural_s']), $tmpvarhover, $tmpvar);
			}
			else
			{
				$ppg_vars['top_h1_desc'] = construct_phrase($vbphrase['visit_usernames_profile'], $imageusername, $vbphrase['plural_s'], $tmpvarhover, $tmpvar);
			}
			unset($tmpvar, $tmpvarhover);
		}
	}

	if ($ppg_options['gallery_showcatdesc'])
	{
		// $bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
		$ppg_vars['top_h1_desc'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($ppg_vars['top_h1_desc']));	
	}
	$templater = vB_Template::create('adv_gallery_nodisplay');
	$templater->register('colspan', $colspan);
	$imagebits = $templater->render();
	$pagedata['minlimit'] = 0;
}

//$navname = $catinfo['title'];
	/* ##############  4.0 Category Jump ################################# */
if($ppg_options['gallery_enablecatjump'])
{
	$jumptitle = $catinfo['title'];
	switch ($_REQUEST['do'])
	{
		case 'favorites':
			if($_REQUEST['u'] AND !empty($_REQUEST['u']))
			{
				$jumptitle = $vbphrase['favorites'];
			}
			else
			{
				$jumptitle = $vbphrase['my_favorites'];
			}
			break;
		case 'subscriptions':
			$jumptitle = $vbphrase['my_subscriptions'];
			break;
		case 'newimages':
			$jumptitle = $vbphrase['whats_new'];
			break;
		case 'popimages':
			$jumptitle = $vbphrase['whats_popular'];
			break;
		case 'search':
		case 'searchresults':
			$jumptitle = $vbphrase['search'];
			break;
	}

	$navpopup = array(
		'id'    => 'bi_navpopup',
		'title' => $jumptitle,
		'link'  => 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $catid
	);
	$categoryjump =  print_galquick_jump($navpopup);
}
	/* ##############  /4.0 Category Jump ################################# */

if ($ppg_options['gallery_showcatdesc'])
{
//	require_once(DIR . '/includes/functions_wysiwyg.php');
//	require_once(DIR . '/includes/class_bbcode.php');
//	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
	$catinfo['description'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($catinfo['description']));
}
//$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());



if ($_REQUEST['do'] == 'browseimages')
{
	if ($catinfo['membercat'] AND $userid)
	{
		// do nothing		
	}
	if($catinfo['membercat'] AND !$userid)
	{

		$ppg_vars['top_h1_desc'] = $catinfo['description_clean'];
		
		//require_once(DIR . '/includes/functions_wysiwyg.php');
		//require_once(DIR . '/includes/class_bbcode.php');
		if ($ppg_options['gallery_showcatdesc'])
		{
			$ppg_vars['top_h1_desc'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($ppg_vars['top_h1_desc']));
		}

	}
	//$navbits = construct_dir_navbits($catinfo['parentlist']);
}

$ppg_options['nav_gallery_url']	  =  $ppg_options['gallery_url'] . '/index.php' .  $vbulletin->session->vars['sessionurl_q'];
$navbits["$ppg_options[nav_gallery_url]"] = $vbphrase['gallery'];

$navbits = construct_dir_navbits($catinfo['parentlist']);

if ($catinfo['membercat'] AND $userid)
{
	$navbits[''] = $navname;
	//$navbits = construct_navbits($navbits);
}
else if(intval($catid) == 0)
{
	$navbits[''] = $navname;
}




$navbits = construct_navbits($navbits);	
//print_r($navbits); exit;
	//array_pop($navbits);

	




//print ($navname);
$navdispnam = ($navname) ? $navname : $navbits['lastelement'];

//print $navdispnam ; exit;
// show popup search only to members...(others only get search link) can be modified with plugin
$show['popup_search'] = $show['member'];


/* ############### METATAGS ############ */

$ppg_vars['gallery_titletag'] = $catinfo['title'] . ' - ' . $ppg_options['gallery_title'] . " @ " . $vbulletin->options['hometitle'];
$ppg_vars['page_h1_title'] = $catinfo['title'];

$tmp_vars['subcatmetakw'] = '';
$tmp_vars['subcatmetakwsec'] = '';
$tmp_vars['subcatmetadesc'] = '';
if(!empty($metabits))
{
	foreach($metabits AS $metabit)
	{
		$tmp_vars['subcatmetadesc'] .=  ' ' . $metabit['title'];
		if($metabit['description'] != '')
		{
			$tmp_vars['subcatmetadesc'] .= ' - ' . $metabit['description'];
		}
		$tmp_vars['subcatmetadesc'] .= '. ';
		$tmp_vars['subcatmetakw'] .=  ' ' . $metabit['title'];
		//$tmp_vars['subcatmetakwsec'] .= ' ' . $metabit['description'];
	}
	unset($metabits, $metabit);
	//$tmp_vars['subcatmetakw'] .= ' ' . $tmp_vars['subcatmetakwsec'];

}
$tmp_vars['meta_keyw'] = $catinfo['title'] . ' ' . $tmp_vars['meta_keyw'] . ' ' . $tmp_vars['subcatmetakw'];
$tmp_vars['meta_desc'] =  $catinfo['title'];
if(isset($catinfo['description_clean']) AND $catinfo['description_clean'] != '')
{
	$tmp_vars['meta_desc'] .= ' - ' . $catinfo['description_clean'];
}
$tmp_vars['meta_desc'] .=   '. ' . $tmp_vars['subcatmetadesc'];
if(isset($tmp_vars['meta_img_desc']) AND $tmp_vars['meta_img_desc'] != '')
{
	$tmp_vars['meta_desc'] .=   ' ' . $vbphrase['images'] . ': ' . $tmp_vars['meta_img_desc'];
}

($hook = vBulletinHook::fetch_hook('ppgal_browse_complete')) ? eval($hook) : false;

// we add metatags here so we can change with hook...
// ########### Finish Metatags ##################
$headinclude = construct_metatags($headinclude, $tmp_vars['meta_keyw'], $tmp_vars['meta_desc']);
unset($tmp_vars);
/* ### Finish redering  navbar */
$templater = vB_Template::create('navbar');
$navbar = $templater->render();
$navbar = render_navbar_template($navbits);

/* ### Add announcement if active */
if($ppgal_announcement)
{
	$navbar = $navbar . $ppgal_announcement;
}
$pagedata['minlimit'] = vb_number_format($pagedata['minlimit']);
$pagedata['maxlimit'] = vb_number_format($pagedata['maxlimit']);
$pagedata['count'] = vb_number_format($pagedata['count']);

if ($ppg_options['gallery_showquickupload'] AND $_REQUEST['do'] == 'browseimages' AND $categoryperms["$catinfo[catid]"]['canuploadimages'] AND $catinfo['hasimages'] == 1 AND $catopts["$catinfo[catid]"]['open_for_images'] AND ($useroptions['allow_upload'] OR !$catinfo['catuserid'] OR $catinfo['catuserid'] == $vbulletin->userinfo['userid']))
{
	$show['quickupload'] = true;
}
if($show['quickupload'])
{
	// need to put this in extra if
	$customfields = construct_custom_fieldbits();
}


$ppg_vars['mods'] = $mods;
$ppg_vars['gallery_popimagelimit'] = $ppg_options['gallery_popimagelimit'];
$ppg_vars['gallery_allowreplies'] = $ppg_options['gallery_allowreplies'];
$ppg_vars['gallery_allowrating'] = $ppg_options['gallery_allowrating'];
$ppg_vars['gallery_showonoff'] = $ppg_options['gallery_showonoff'];
$ppg_vars['letter_all_url'] = $letter_all_url;
$ppg_vars['gallery_originalwindow'] = $ppg_options['gallery_originalwindow'];



/* Repacement for pagenav images.... as they are hardcoded in vbulletin... vbulletin says they will fix that in a couple of months (very low priority) we could use stylevar replacement, but that would trigger on ALL site pages, this is only needed in browseimages when page or catnav is called.. so we do it here the "clumsy" way */

if($pagenav OR $catpagenav)
{
	if($pagenav)
	{
		$pagenav = str_replace('"images/','"' . $vbulletin->options['bburl'] . '/images/', $pagenav);
	}
	else
	{
		$catpagenav = str_replace('"images/pagination','"' . $vbulletin->options['bburl'] . '/images/pagination', $catpagenav);
	}
}

$templater = vB_Template::create('ADV_GALLERY_BROWSEIMAGES');
	$templater->register_page_templates();
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('pagedata', $pagedata);
	$templater->register('search', $search);
	$templater->register('keywords', $keywords);
	$templater->register('catpagenav', $catpagenav);
	$templater->register('subcatbits', $subcatbits);
	$templater->register('dirsel', $dirsel);
	$templater->register('ordersel', $ordersel);
	$templater->register('datecutsel', $datecutsel);
	$templater->register('letterbits', $letterbits);
	$templater->register('imagebits', $imagebits);
	$templater->register('navbar', $navbar);
	$templater->register('catinfo', $catinfo);
	$templater->register('imageinfo', $imageinfo);
	$templater->register('perpageopts', $perpageopts);
	$templater->register('perpagedisplay', $perpagedisplay);
	$templater->register('pagenav', $pagenav);
	$templater->register('catid', $catid);
	$templater->register('userid', $userid);
	$templater->register('imageuser', $imageuser);
	$templater->register('orderby', $orderby);
	$templater->register('categoryjump', $categoryjump);
	$templater->register('customfields', $customfields);

print_output($templater->render());
exit; // not needed but...

?>