<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: gallery_usercp.php                                               ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// we keep this hardcoded... so does vbulletin with the attachment editor
$maxperpage = 50;
$defaultperpage = 10;

if ($_REQUEST['do'] == 'vbgalleryprofile')
{
	global $navclass, $ppg_options;
	// check permissions

	if(!is_array($ppg_options))
	{
		$ppg_options =& $vbulletin->adv_gallery_opt;
	}

    require_once(DIR . '/includes/functions_gallery_lite.php');
    $galleryperms = (!is_array($galleryperms) OR empty($galleryperms)) ? fetch_galperms() : $galleryperms;
	
    if (!$vbulletin->userinfo['userid'] OR !$galleryperms['canchangprofile'] OR !$vbulletin->adv_gallery_opt['add_ucp_changeprofile'])
    {
        print_no_permission();
    }

	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_UINT
	));


	if (($vbulletin->GPC['userid'] AND $vbulletin->GPC['userid'] != $vbulletin->userinfo['userid']) AND ($galleryperms['caneditothersimages'] AND $galleryperms['candeleteothers']))
	{
		// show someone else's images
		$userinfo = verify_id('user', $vbulletin->GPC['userid'], 1, 1);
		$myuserinfo =& $userinfo;
		
		$show['otheruser'] = true;
		$userid = $userinfo['userid'];
		$username = $userinfo['username'];
		
	}
	else
	{
		// show own images in user cp
		$userinfo =& $vbulletin->userinfo;
		$myuserinfo =& $vbulletin->userinfo;
		$show['otheruser'] = false;
		$userid = $vbulletin->userinfo['userid'];
		$username = $vbulletin->userinfo['username'];

	}

	// get checked
	$checked = array();
	$select = array();
    // Profile Active
    if($userinfo['profile_active']){
        $checked['profile_active'] = ' checked="checked" ';
		
    }
    if($userinfo['profile_tabfirst']){
        $checked['profile_tabfirst'] = ' checked="checked" ';
		
    }
    if($userinfo['profile_autosel']){
        $checked['profile_autosel'] = ' checked="checked" ';
		
    }	
    if($userinfo['profile_tabstats']){
        $checked['tabstats_active'] = ' checked="checked" ';
		
    }	

    if($userinfo['profile_tabthumbs']){
        $checked['tabthumbs_active'] = ' checked="checked" ';
		
    }	
    if($userinfo['profile_tabhighlight']){
        $checked['tabhighlight_active'] = ' checked="checked" ';
		
    }	
    if($userinfo['profile_tabstats']){
        $checked['tabstats_active'] = ' checked="checked" ';
		
    }
    
	if($userinfo['profile_showtitle']){
        $checked['showtitle'] = ' checked="checked" ';
		
    }
	if($userinfo['profile_showcat']){
        $checked['showcat'] = ' checked="checked" ';
		
    }
    if($userinfo['profile_showcontext']){
        $checked['showcontext'] = ' checked="checked" ';
		
    }
    if($userinfo['profile_contextfirst']){
        $checked['contextfirst'] = ' checked="checked" ';
    }

	if($userinfo['profile_showhtitle']){
        $checked['showhtitle'] = ' checked="checked" ';
		
    }
	if($userinfo['profile_husername']){
        $checked['husername'] = ' checked="checked" ';
		
    }
    if($userinfo['profile_showhcat']){
        $checked['showhcat'] = ' checked="checked" ';
		
    }
    if($userinfo['profile_showhcontext']){
        $checked['showhcontext'] = ' checked="checked" ';
    }

    // Image Order
    switch($userinfo['profile_orderby'])
    {
        case '1':  $select['newest'] = ' selected="selected" '; break;
        case '2':  $select['views'] = ' selected="selected" '; break;
        case '3':  $select['comments'] = ' selected="selected" '; break;
        case '4':  $select['rated'] = ' selected="selected" '; break;
        case '5':  $select['random'] = ' selected="selected" '; break;
    }


	$templatename = 'adv_gallery_usercp_setting';
	construct_usercp_nav('vbgoptions');


	//$navbits[''] = 'Gallery Profile Settings';

	$page_templater = vB_Template::create($templatename);
	$page_templater->register('navclass', $navclass);
	$page_templater->register('checked', $checked);
	$page_templater->register('myuserinfo', $myuserinfo);
	$page_templater->register('select', $select);
	$page_templater->register('profileprivacybits', $profileprivacybits);

	

	if ($userid == $vbulletin->userinfo['userid'])
	{
		$navbits[''] = $vbphrase['gallery_profile_settings'];
		$shelltemplatename = 'USERCP_SHELL';
	}
	else
	{
		// show some other user's images
		$pagetitle = construct_phrase($vbphrase['gallery_profile_settings_for_x'], $username);
		$navbits[''] = $pagetitle;
		$navbits = array(
			fetch_seo_url('member', $userinfo) => $vbphrase['view_profile'],
			'' => $pagetitle
		);

		$shelltemplatename = 'GENERIC_SHELL';
	}



}

// ############################### update vbgallery ###############################
if ($_POST['do'] == 'updatevbgallery')
{
    global $checked ;
	$tmp_vars = array();
    // permissions check
     require_once(DIR . '/includes/functions_gallery_lite.php');
    $galleryperms = (!is_array($galleryperms) OR empty($galleryperms)) ? fetch_galperms() : $galleryperms;


    if (!$vbulletin->userinfo['userid'] OR !$galleryperms['canchangprofile'] OR !$vbulletin->adv_gallery_opt['add_ucp_changeprofile'])
    {
        print_no_permission();
    }

    // All is ok, contenue :D
    $vbulletin->input->clean_array_gpc('p', array(
		'galoptions'				=> TYPE_ARRAY_BOOL,
		// sanitize properly
        'profile_exclude'           => TYPE_NOHTML,
        'profile_include'           => TYPE_NOHTML,

        'profile_limit'             => TYPE_INT,
        'profile_orderby'           => TYPE_INT,

		'otheruser'					=> TYPE_INT,
		'myuserid'					=> TYPE_UINT,
        'profile_cutoff'            => TYPE_INT
    ));

// clean properly comma list thx to kirby for pointing out danger.
	// clean exclude
	$tmp_vars['exclude_array'] = (strpos($vbulletin->GPC['profile_exclude'], ',') !== false) ?
		explode(',', $vbulletin->GPC['profile_exclude']) : 
		(
			(intval($vbulletin->GPC['profile_exclude'])>0) ? 
			array(0 => intval($vbulletin->GPC['profile_exclude'])): array(0 => 0)
		);

	foreach($tmp_vars['exclude_array'] AS $key => $var)
	{
		// make a clean array
		$tmp_vars['exclude_array_clean'][] = intval(trim($var));
	}
	// make new commalist
	$vbulletin->GPC['profile_exclude'] = implode(',', $tmp_vars['exclude_array_clean']);


	// clean include
	$tmp_vars['include_array'] = (strpos($vbulletin->GPC['profile_include'], ',') !== false) ?
		explode(',', $vbulletin->GPC['profile_include']) : 
		(
			(intval($vbulletin->GPC['profile_include'])>0) ? 
			array(0 => intval($vbulletin->GPC['profile_include'])): array(0 => 0)
		);

	foreach($tmp_vars['include_array'] AS $key => $var)
	{
		// make a clean array
		$tmp_vars['include_array_clean'][] = intval(trim($var));
	}

	// make new commalist
	$vbulletin->GPC['profile_include'] = implode(',', $tmp_vars['include_array_clean']);
	unset($tmp_vars);


	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_UINT
	));

	if(($vbulletin->GPC['otheruser'] ==1) AND ($vbulletin->GPC['userid'] == $vbulletin->GPC['myuserid']) )
	{
		$userid = $vbulletin->GPC['myuserid'];
		$show['otheruser'] = true;
	}
	else
	{
		$userid = $vbulletin->userinfo['userid'];
		$show['otheruser'] = false;
	}

    $db->query_write("
            UPDATE " . TABLE_PREFIX . "ppgal_user
            SET

            profile_active = '" . $vbulletin->GPC['galoptions']['profile_active'] . "',
			profile_tabfirst = '" . $vbulletin->GPC['galoptions']['profile_tabfirst'] . "',
            profile_autosel = '" . $vbulletin->GPC['galoptions']['profile_autosel'] . "',

            profile_tabstats = '" . $vbulletin->GPC['galoptions']['tabstats_active'] . "',
			profile_tabthumbs = '" . $vbulletin->GPC['galoptions']['tabthumbs_active'] . "',
			profile_tabhighlight = '" . $vbulletin->GPC['galoptions']['tabhighlight_active'] . "',
			profile_showtitle = '" . $vbulletin->GPC['galoptions']['showtitle'] . "',
			profile_showcat = '" . $vbulletin->GPC['galoptions']['showcat'] . "',
			profile_showcontext = '" . $vbulletin->GPC['galoptions']['showcontext'] . "',
			profile_contextfirst = '" . $vbulletin->GPC['galoptions']['contextfirst'] . "',
			profile_showhtitle = '" . $vbulletin->GPC['galoptions']['showhtitle'] . "',
			profile_husername = '" . $vbulletin->GPC['galoptions']['husername'] . "',
			profile_showhcat = '" . $vbulletin->GPC['galoptions']['showhcat'] . "',
			profile_showhcontext = '" . $vbulletin->GPC['galoptions']['showhcontext'] . "',

            profile_exclude = '" . $db->escape_string($vbulletin->GPC['profile_exclude']) . "',
            profile_include = '" . $db->escape_string($vbulletin->GPC['profile_include']) . "',
            profile_limit = '" . $vbulletin->GPC['profile_limit'] . "',
            profile_orderby = '" . $vbulletin->GPC['profile_orderby'] . "',
            profile_cutoff = '" . $vbulletin->GPC['profile_cutoff'] . "'


            WHERE userid = '". $userid . "'
    ");
	$userlink = '';
	if($show['otheruser'])
	{
		$userlink = '&amp;u=' . $userid;
	}

    $vbulletin->url = 'profile.php?' . $vbulletin->session->vars['sessionurl'] . 'do=vbgalleryprofile' . $userlink;
    eval(print_standard_redirect('redirect_updatethanks'));
}  

// ############################### List of images for current user ################
if ($_REQUEST['do'] == 'vbgeditimages')
{
	global $ppg_options;
	if(!is_array($ppg_options))
	{
		$ppg_options =& $vbulletin->adv_gallery_opt;
	}

    require_once(DIR . '/includes/functions_gallery_lite.php');
    $galleryperms = ((!is_array($galleryperms) OR empty($galleryperms)) OR !isset($galleryperms['gallery_maxdiskspace'])) ? fetch_galperms(1) : $galleryperms;

	if(!$galleryperms['canusemultiedit'] OR !$ppg_options['add_ucp_massedit'])
	{
		print_no_permission();
	}



	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_UINT
	));

	$show['image_list'] = true;

	if (!$vbulletin->GPC['userid'] OR $vbulletin->GPC['userid'] == $vbulletin->userinfo['userid'])
	{
		// show own images in user cp
		$userinfo =& $vbulletin->userinfo;
		$userid = $vbulletin->userinfo['userid'];
		$username = $vbulletin->userinfo['username'];
		$show['imagequota'] = true;
		
		if($galleryperms['candelete'])
		{
			$show['deleteoption'] = true;
		}

		// set page before error

	}
	else
	{
		// show someone else's images
		$userinfo = verify_id('user', $vbulletin->GPC['userid'], 1, 1);
		$userid = $userinfo['userid'];
		$username = $userinfo['username'];
		$show['imagequota'] = true;
		$show['otheruserid'] = true;
		$show['username'] = true;
		$galleryperms['gallery_maxdiskspace'] = fetch_userquota($userid);
		if($galleryperms['candeleteothers'])
		{
			$show['deleteoption'] = true;
		}		

	}

	// check permissions
	// for pageaccess

	$tmp_vars = array();
	$tmp_vars['canedit'] = $tmp_vars['candelete'] = false;
    if( !$vbulletin->userinfo['userid'] OR ($userid == $vbulletin->userinfo['userid'] AND $galleryperms['caneditimages']) OR ($userid != $vbulletin->userinfo['userid'] AND $galleryperms['caneditothersimages']) )
	{
		$tmp_vars['canedit'] = true;
	}
	else
	{
		print_no_permission();
	}


	

	construct_usercp_nav('vbgedit');
	// Get image count including non validated images

	$pagedata = $db->query_first("
	  		SELECT COUNT(imageid) AS count, SUM(filesize) AS normal, SUM(originalfilesize) AS original
	  		FROM " . TABLE_PREFIX . "ppgal_images
	  		WHERE userid = $userid
	  ");

	
	$totalimages = intval($pagedata['count']);

	$imagesum = $pagedata['normal'] + $pagedata['original'];

	if (!$totalimages AND $userid != $vbulletin->userinfo['userid'])
	{
		eval(standard_error(fetch_error('noimages')));
	}
	else if (!$totalimages)
	{
		$show['image_list'] = false;
		$show['imagequota'] = false;
	}
	else
	{

		if(isset($galleryperms['gallery_maxdiskspace']) AND ($galleryperms['gallery_maxdiskspace'] == 0) AND is_numeric($galleryperms['gallery_maxdiskspace']))
		{
			$totalsize = 100;
			$attachsize = 0;
		}
		else if(intval($galleryperms['gallery_maxdiskspace']) > 0)
		{
			if ($imagesum >= $galleryperms['gallery_maxdiskspace'])
			{
				$totalsize = 0;
				$attachsize = 100;
			}
			else
			{
				$attachsize = ceil($imagesum / $galleryperms['gallery_maxdiskspace'] * 100);
				$totalsize = 100 - $attachsize;
			}
		}
		else
		{
			// is not set (should never happen)
			$totalsize = 0;
			$attachsize = 100;
		}

		$attachlimit = vb_number_format($galleryperms['gallery_maxdiskspace'], 1, true);	

		$imagesum = vb_number_format($imagesum, 1, true);


		if ($galleryperms['gallery_maxdiskspace'] == 0)
		{
			$spacelimit = $vbphrase['unlimited'];

		}
		else
		{
			$spacelimit = vb_number_format($galleryperms['gallery_maxdiskspace'], 1, true);
		}

		sanitize_pageresults($totalimages, $pagenumber, $perpage, $maxperpage, $defaultperpage);

		$limitlower = ($pagenumber - 1) * $perpage + 1;
		$limitupper = ($pagenumber) * $perpage;

		if ($limitupper > $totalimages)
		{
			$limitupper = $totalimages;
			if ($limitlower > $totalimages)
			{
				$limitlower = $totalimages - $perpage;
			}
		}
		if ($limitlower <= 0)
		{
			$limitlower = 1;
		}

		$images = $db->query_read("
					SELECT images.imageid, images.title, images.catid, images.dateline, images.dateline_mod, images.userid, images.username, extension, filename, filesize, thumbname, originalname, originalfilesize, images.views, valid, categories.title AS cattitle
					FROM " . TABLE_PREFIX . "ppgal_images AS images
					LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (categories.catid = images.catid)
					WHERE userid = $userid
					ORDER BY dateline DESC
					LIMIT  " . ($limitlower - 1) . ", $perpage
				");


     	

	

		$sorturl = 'profile.php?' . $vbulletin->session->vars['sessionurl'] . 'do=vbgeditimages';
		if ($userid != $vbulletin->userinfo['userid'])
		{
			$sorturl .= "&amp;u=$userid";
		}
		if ($perpage != $defaultperpage)
		{
			$sorturl .= "&amp;pp=$perpage";
		}

		$pagenav = construct_page_nav($pagenumber, $perpage, $totalimages, $sorturl);
		$counter = 0;
		if(!function_exists('construct_image_url'))
		{
			require_once(DIR . '/includes/functions_gallery_lite.php');
		}
		$linkpage = ($pagenumber>1) ? '&amp;page=' . $pagenumber : '';
		$userurl = fetch_seo_url('member', $userinfo);


		while ($image =  $vbulletin->db->fetch_array($images))
		{
			$counter++;
			$image['url'] = construct_image_url($image, 'thumbname');
			$imgsize = ($image['originalname']) ? 'originalname' : 'filename';
			$image['largeurl'] = construct_image_url($image, $imgsize);
			
			$image['showimage'] = $ppg_options['gallery_url'] . '/showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . '&amp;c=member&imageuser=' . $image['userid'];

			$image['editimage_url'] = $ppg_options['gallery_url'] . '/editimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . '&amp;c=member&imageuser=' . $image['userid'] . '&amp;edit=1' . $linkpage;
			$image['originalfilesize'] = ($image['originalfilesize']) ? $image['originalfilesize'] : 0;
			$image['space'] = $image['filesize'] + $image['originalfilesize'];
			$image['space'] = vb_number_format($image['space'], 1, true);
		    $image['date'] = vbdate($vbulletin->options['dateformat'], $image['dateline'], true);
		    $image['time'] = vbdate($vbulletin->options['timeformat'], $image['dateline'], true);
			if(!$image['dateline_mod'] OR $image['dateline_mod'] == 0)
			{
				$image['moddate'] = $vbphrase['never'];
				$image['modtime'] = '';
			}
			else
			{
				$image['moddate'] = vbdate($vbulletin->options['dateformat'], $image['dateline_mod'], true);
				$image['modtime'] = vbdate($vbulletin->options['timeformat'], $image['dateline_mod'], true);
			}
		    $image['userlink'] = $userurl;
			$image['caturl'] = $ppg_options['gallery_url'] . '/browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $image['catid'];

			$show['not_valid'] = ($image['valid']) ? false : true;

			$image['alttext'] = $vbphrase['view_original'];
		
			$templater = vB_Template::create('adv_gallery_modifyimagebit');
	
			$templater->register('image', $image);
			$imagelistbits .= $templater->render();
		}
		$vbulletin->db->free_result($images);
		unset($image);
		$totalimages = vb_number_format($totalimages);

		$show['imagelimit'] = true;
		$show['currentattachsize'] = $attachsize;
		$show['totalattachsize'] = $totalsize;
		$show['thumbnails'] = true;
	}
	// add confirm dialog
	$vbphrase['js_confirm_delete'] = addslashes_js($vbphrase['confirm_delete']);

	// add new css
	if($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1)
	{
	    $tmp_css['background-color'] = $vbulletin->stylevars['ppg_thumb_framecolor']['color'];
		$tmp_css['border-color'] = $vbulletin->stylevars['ppg_thumb_border']['color'] ;
	}
	else
	{
	    $tmp_css['background-color'] = $vbulletin->stylevars['lightweightbox_background']['color'];
		$tmp_css['border-color'] = $vbulletin->stylevars['lightweightbox_border']['color'] ;
	}

	$tmp_css['img_max_width'] = ($vbulletin->stylevars['ppg_thumb_framewidth']['size'] + $vbulletin->stylevars['ppg_thumb_border']['width'])*2;
	$tmp_css['img_max_width'] = $ppg_options['gallery_thumbsize'] + $tmp_css['img_max_width'];

	$tmp_css['img_max_width'] = $tmp_css['img_max_width'] . $vbulletin->stylevars['ppg_thumb_framewidth']['units'];
	$tmp_css['img_max_a_width'] = $ppg_options['gallery_thumbsize'] + ($vbulletin->stylevars['padding']['size']*3);
	$tmp_css['img_max_a_width'] = $tmp_css['img_max_a_width'] . $vbulletin->stylevars['padding']['units'];
	
	$templater = vB_Template::create('adv_gallery_usercpcss');
	$templater->register('tmp_css', $tmp_css);
	$tmp_css['css_file'] = $templater->render();
	$headinclude .= $tmp_css['css_file'];
	unset($tmp_css);


	if ($userid == $vbulletin->userinfo['userid'])
	{
		// show $vbulletin->userinfo's images in usercp
		//construct_usercp_nav('images');
		$navbits[''] = construct_phrase($vbphrase['images_uploaded_by_x'], $vbulletin->userinfo['username']);
	}
	else
	{
		// show some other user's images
		$pagetitle = construct_phrase($vbphrase['images_uploaded_by_x'], $username);

		$navbits = array(
			fetch_seo_url('member', $userinfo) => $vbphrase['view_profile'],
			'' => $pagetitle
		);

		$shelltemplatename = 'GENERIC_SHELL';
	}

	$includecss['attachments'] = 'attachments';
	$includecss['lightbox'] = 'lightbox';

	$page_templater = vB_Template::create('adv_gallery_modifyimages');
	$page_templater->register('attachlimit', $attachlimit);
	$page_templater->register('attachsize', $attachsize);
	$page_templater->register('imagesum', $imagesum);
	$page_templater->register('spacelimit', $spacelimit);
	$page_templater->register('pagenav', $pagenav);
	$page_templater->register('pagenumber', $pagenumber);
	$page_templater->register('perpage', $perpage);

	$page_templater->register('template', $template);
	$page_templater->register('totalimages', $totalimages);
	$page_templater->register('totalsize', $totalsize);
	$page_templater->register('userid', $userid);
	$page_templater->register('username', $username);
	$page_templater->register('imagelistbits', $imagelistbits);
}
// delete images
if ($_POST['do'] == 'deleteimages')
{
	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'imagelist' => TYPE_ARRAY_BOOL,
		'perpage'         => TYPE_UINT,
		'pagenumber'      => TYPE_UINT,
		'userid'          => TYPE_UINT
	));

// check if allowed to delete others

	$idlist = array();
	foreach (array_keys($vbulletin->GPC['imagelist']) AS $imageid)
	{
		$idlist[] = intval($imageid);
	}

	if (empty($vbulletin->GPC['imagelist']) OR empty($idlist))
	{
		eval(standard_error(fetch_error('imagedel')));
	}

	if (!empty($idlist))
	{
		// do the delete stuff

		require_once(DIR . '/includes/functions_gallery.php');

		// ############################### Do Delete Images ###############################

		//print_r($idlist); exit;	




		$deletearray = array();
		$userpostsarray = array();
		$userlastimgarray = array();
		foreach ($idlist AS $imageid)
		{
			$tempuserarray = array();
			$templastimgarray = array();
			$image = $db->query_first("
				SELECT images.catid, images.userid, images.filename, images.thumbname, images.originalname, images.posts, images.valid, categories.catimage AS catimage, user.lastimageid AS lastimageid
				FROM " . TABLE_PREFIX . "ppgal_images AS images 
				LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
				LEFT JOIN " . TABLE_PREFIX . "ppgal_user AS user ON (user.userid = images.userid)
				WHERE imageid = '$imageid'
				
			");



			$categoryperms = fetch_category_perms();
			if (!is_category_mod($image['catid']) AND ((!$categoryperms["$image[catid]"]['candelete'] AND $vbulletin->userinfo['userid'] == $image['userid']) OR (!$categoryperms["$image[catid]"]['candeleteothers'] AND $vbulletin->userinfo['userid'] != $image['userid'])))
			{
				continue;

			}



			if (($image['catimage'] OR $image['catimage'] != '') AND (fetch_folder_url($image) . '/' . $image['thumbname'] == $image['catimage']))
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET catimage = '' WHERE catid = '$image[catid]'");
			}

			$image['override'] = 1; // this is to get rid of the bug below...
			if($image['lastimageid']==$imageid OR $image['override'])
			{
				$templastimgarray[] = $image['userid'];
			}
			$deletearray["$imageid"]['catid'] = $image['catid'];
			$deletearray["$imageid"]['userid'] = $image['userid'];
			$deletearray["$imageid"]['filename'] = $image['filename'];
			$deletearray["$imageid"]['thumbname'] = $image['thumbname'];
			$deletearray["$imageid"]['originalname'] = $image['originalname'];
			$deletearray["$imageid"]['posts'] = $image['posts'];

			$userposts = $db->query_read("
					SELECT userid FROM " . TABLE_PREFIX . "ppgal_posts
					WHERE imageid = $imageid AND visible=1
				");
			
			while ($userpost = $vbulletin->db->fetch_array($userposts))
			{
				$tempuserarray[] = $userpost['userid'];
			}
			$vbulletin->db->free_result($userposts);
			unset($userpost);
			if(!empty($tempuserarray))
			{
				$userpostsarray = array_unique(array_merge($userpostsarray,$tempuserarray));
			}

			if(!empty($templastimgarray))
			{
				$userlastimgarray = array_unique(array_merge($userlastimgarray,$templastimgarray));
			}
		}

		
		if (!empty($deletearray))
		{
			delete_images('', $deletearray);

			update_count_lite($currentcat);



			//update users
			if(!empty($userpostsarray))
			{
				foreach($userpostsarray AS $posterid)
				{
					if($posterid < 1)
					{
						continue;
					}

					$vbg_tp = $db->query_first("SELECT COUNT(postid) AS postcount FROM " . TABLE_PREFIX . "ppgal_posts WHERE userid = $posterid AND visible = 1");
	                $vbg_lp = $db->query_first("SELECT postid, title, dateline, visible FROM " . TABLE_PREFIX . "ppgal_posts WHERE userid = $posterid AND visible = 1 ORDER BY dateline DESC");

        			$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user
						SET
						pppcount = '$vbg_tp[postcount]',
						lastpostdate = '$vbg_lp[dateline]',
						lastpostid = '$vbg_lp[postid]',
						lastposttitle = '" . $db->escape_string($vbg_lp['title']) . "'
						WHERE userid = '$posterid'
					");

				}
				unset($userpostsarray, $posterid);
			}
			if(!empty($userlastimgarray))
			{
				foreach($userlastimgarray AS $posterid)
				{
					if($posterid < 1)
					{
						continue;
					}

					$vbg_ti = $db->query_first("SELECT COUNT(imageid) AS imagecount FROM " . TABLE_PREFIX . "ppgal_images WHERE userid = $posterid AND valid = 1");
	                $vbg_li = $db->query_first("SELECT imageid, title, dateline, valid FROM " . TABLE_PREFIX . "ppgal_images WHERE userid = $posterid AND valid = 1 ORDER BY dateline DESC");

        			$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user
						SET
						ppicount = '$vbg_ti[imagecount]',
						lastimagedate = '$vbg_li[dateline]',
						lastimageid = '$vbg_li[imageid]',
						lastimagetitle = '" . $db->escape_string($vbg_li['title']) . "'
						WHERE userid = '$posterid'
					");

				}
				unset($userlastimgarray, $posterid);


			}
			//$list3 = implode("," , array_unique(array_merge(explode(",",$list1),explode(",", $list2))));
		}

		// finished delete stuff...

	}

	// get clean redirect url
	$vbguseredit = ($vbulletin->userinfo['userid'] == $vbulletin->GPC['userid']) ? '' : '&amp;u=' . $vbulletin->GPC['userid'];
	$perpage = fetch_perpage($vbulletin->GPC['perpage'], $maxperpage, $defaultperpage);
	$ppedit = ($vbulletin->GPC['perpage'] != $defaultperpage) ? '&amp;pp=' . $vbulletin->GPC['perpage'] : '';
	$pagenumbedit =  (intval($vbulletin->GPC['pagenumber'])>1) ? '&amp;page=' . $vbulletin->GPC['pagenumber'] : '';

	$vbulletin->url = 'profile.php?' . $vbulletin->session->vars['sessionurl'] . 'do=vbgeditimages' . $vbguseredit . $ppedit . $pagenumbedit;
	eval(print_standard_redirect('adv_gallery_editimage_removed'));
}
?>