<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: forumhome_complete.php                                           ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/


/* ######################  FORUMHOME STATS ADD-ON ###################################*/
// Total Stats pulled from datastore
// This will show on ForumHome when it shows on Gallery Home.

if ($vbulletin->adv_gallery_opt['gallery_stats_forumhome'] AND is_array($vbulletin->ppg_stats))
{
	if(!is_array($ppg_options))
	{
		$ppg_options =& $vbulletin->adv_gallery_opt;
	}
	$total = array();
	foreach ($vbulletin->ppg_stats AS $totals)
	{
		$total[] = $totals;
	}
	unset($vbulletin->ppg_stats);
	$stats = array();
	$stats['images'] = $total['0']['images'];
	$stats['views'] = $total['0']['views'];
	$stats['posts'] = $total['0']['posts'];
	$stats['maxfilesize'] = $total['0']['filesize'];
	$stats['maxorigfilesize'] = $total['0']['origfilesize'];
	$stats['categories'] = $total['1']['categories'];
	$stats['memcat'] = $total['1']['membercat'];
	$stats['cards'] = $total['2']['cards'];
	unset($total);

	// Convert stats to clean numbers
	$stats['images'] = vb_number_format($stats['images']);
	$stats['views'] = vb_number_format($stats['views']);
	$stats['categories'] = vb_number_format($stats['categories']);
	$stats['memcat'] = vb_number_format($stats['memcat']);
	$stats['cards'] = vb_number_format($stats['cards']);
	$stats['posts'] = vb_number_format($stats['posts']);
	$stats['diskspace'] = vb_number_format($stats['maxfilesize'] + $stats['maxorigfilesize'], 1, true);

	$show['vbgstats'] = true;
	
	
	$ppg_vars['galtitle'] = htmlspecialchars_uni($ppg_options['gallery_title']);
	$ppg_vars['gallery_url'] = $ppg_options['gallery_url'];
	$show['gallery_stats_active'] = $ppg_options['gallery_stats_active'];
	$show['gallery_allowreplies'] = $ppg_options['gallery_allowreplies'];
	$show['gallery_enableecards'] = $ppg_options['gallery_enableecards'];

	// get stats position
	$ppg_vars['statspos_before']=false;
	$ppg_vars['statspos'] = $ppg_options['gallery_statspos'];
		switch ($ppg_vars['statspos']){
			case 1: $ppg_vars['statspos'] = 'pos1'; $ppg_vars['statspos_before']=true; break;
			case 2: $ppg_vars['statspos'] = 'pos1'; break;
			case 3: $ppg_vars['statspos'] = 'pos2'; $ppg_vars['statspos_before']=true; break;
			case 4: $ppg_vars['statspos'] = 'pos2'; break;
			case 5: $ppg_vars['statspos'] = 'pos3'; $ppg_vars['statspos_before']=true; break;
			case 6: $ppg_vars['statspos'] = 'pos3'; break;
			case 7: $ppg_vars['statspos'] = 'pos4'; $ppg_vars['statspos_before']=true; break;
			case 8: $ppg_vars['statspos'] = 'pos4'; break;
			case 9: $ppg_vars['statspos'] = 'pos5'; $ppg_vars['statspos_before']=true; break;
			case 10: $ppg_vars['statspos'] = 'pos5'; break;
			default:
				$ppg_vars['statspos'] = 'pos2';
		}

	$templater = vB_Template::create('adv_gallery_forumhome_stats');
		$templater->register('stats', $stats);
		$templater->register('ppg_vars', $ppg_vars);
	$ppg_vars['gallerystats'] = $templater->render();

	$ppg_vars['statspos'] = 'forumhome_wgo_' . $ppg_vars['statspos'];
	//skip_pos is defined in forumhome_start!!! 
	if($ppg_vars['skip_pos'])
	{
		if($ppg_vars['blockpos'] == 'above_stats' OR $ppg_vars['blockpos'] == 'below_stats' )
		{

			$ppg_vars['blocktitle'] = construct_phrase($vbphrase['x_from_y'], $vbphrase[$ppg_vars['imgtypes']],$ppg_options['gallery_title']);
			$templater = vB_Template::create('adv_gallery_forumhome_wgo');
				$templater->register('ppg_vars', $ppg_vars);
			$ppg_vars['homewgoimgs'] = $templater->render();
		
			if($ppg_vars['blockpos'] == 'above_stats')
			{
				$ppg_vars['gallerystats'] = $ppg_vars['homewgoimgs'] . $ppg_vars['gallerystats'];
			}
			else if($ppg_vars['blockpos'] == 'below_stats')
			{
				$ppg_vars['gallerystats'] .= $ppg_vars['homewgoimgs'];
			}
		}
	}
	else
	{
		if($ppg_vars['gal_imagebits_tmp'] != '' AND $ppg_vars['after_wgo'])
		{
			$ad_location['board_below_whats_going_on'] .= $ppg_vars['gal_imagebits_tmp']; 
		}
		else if($ppg_vars['gal_imagebits_tmp'] != '' AND $ppg_vars['after_forums'])
		{
			$ad_location['ad_forumhome_afterforums'] .= $ppg_vars['gal_imagebits_tmp']; 
		}
		else if($ppg_vars['gal_imagebits_tmp'] != '' AND $ppg_vars['below_navbar'])
		{
			$ad_location['ad_navbar_below'] .= $ppg_vars['gal_imagebits_tmp']; 
		}
	}
		
	if($ppg_vars['statspos_before'])
	{

		$template_hook[$ppg_vars[statspos]] = $ppg_vars['gallerystats'] . $template_hook[$ppg_vars[statspos]];
	}
	else
	{
		$template_hook[$ppg_vars[statspos]] .= $ppg_vars['gallerystats'];
	}
}
else
{
	//	stats are NOT shown we check if images are shown
//	stats are NOT shown we check if images are shown
	$ppg_vars['gallery_url'] = $ppg_options['gallery_url'];
	if($ppg_vars['skip_pos'])
	{
		
		$ppg_vars['blocktitle'] = construct_phrase($vbphrase['x_from_y'], $vbphrase[$ppg_vars['imgtypes']],$ppg_options['gallery_title']);

		$templater = vB_Template::create('adv_gallery_forumhome_wgo');
			$templater->register('ppg_vars', $ppg_vars);
		$ppg_vars['gallerystats'] = $templater->render();
		
		// get virtual stats position as stats is disabled
		$ppg_vars['statspos_before']=false;
		$ppg_vars['statspos'] = $ppg_options['gallery_statspos'];
		switch ($ppg_vars['statspos'])
		{
			case 1: $ppg_vars['statspos'] = 'pos1'; $ppg_vars['statspos_before']=true; break;
			case 2: $ppg_vars['statspos'] = 'pos1'; break;
			case 3: $ppg_vars['statspos'] = 'pos2'; $ppg_vars['statspos_before']=true; break;
			case 4: $ppg_vars['statspos'] = 'pos2'; break;
			case 5: $ppg_vars['statspos'] = 'pos3'; $ppg_vars['statspos_before']=true; break;
			case 6: $ppg_vars['statspos'] = 'pos3'; break;
			case 7: $ppg_vars['statspos'] = 'pos4'; $ppg_vars['statspos_before']=true; break;
			case 8: $ppg_vars['statspos'] = 'pos4'; break;
			case 9: $ppg_vars['statspos'] = 'pos5'; $ppg_vars['statspos_before']=true; break;
			case 10: $ppg_vars['statspos'] = 'pos5'; break;
			default:
				$ppg_vars['statspos'] = 'pos4';
		}
		$ppg_vars['statspos'] = 'forumhome_wgo_' . $ppg_vars['statspos'];
		if($ppg_vars['statspos_before'])
		{

			$template_hook[$ppg_vars[statspos]] = $ppg_vars['gallerystats'] . $template_hook[$ppg_vars[statspos]];
		}
		else
		{
			$template_hook[$ppg_vars[statspos]] .= $ppg_vars['gallerystats'];
		}

	}
	else
	{
		if($ppg_vars['gal_imagebits_tmp'] != '' AND $ppg_vars['after_wgo'])
		{
			$ad_location['board_below_whats_going_on'] .= $ppg_vars['gal_imagebits_tmp']; 
		}
		else if($ppg_vars['gal_imagebits_tmp'] != '' AND $ppg_vars['after_forums'])
		{
			$ad_location['ad_forumhome_afterforums'] .= $ppg_vars['gal_imagebits_tmp']; 
		}
		else if($ppg_vars['gal_imagebits_tmp'] != '' AND $ppg_vars['below_navbar'])
		{
			$ad_location['ad_navbar_below'] .= $ppg_vars['gal_imagebits_tmp']; 
		}
	}



}
if(is_array($ppg_options) AND is_array($ppg_vars))
{
	unset($ppg_options, $ppg_vars);
}
?>