<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: functions_gallery_lite.php                                       ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

if(!defined('THIS_SCRIPT')){exit;}

$gallerypermissionsbit = array(
	'canviewgallery'	 			=> 1,
	'canviewimages' 				=> 2,
	'moderateimages' 				=> 4,
	'moderateposts' 				=> 8,
	'cansearchimages' 			    => 16,
	'cansendimagetofriend' 	        => 32,
	'caneditimages' 				=> 64,
	'caneditothersimages' 	        => 128,
	'candelete' 					=> 256,
	'candeleteothers' 			    => 512,
	'canviewreplies' 				=> 1024,
	'canreplytoimages' 			    => 4096,
	'caneditposts' 					=> 2048,
	'caneditothersposts' 		    => 8192,
	'candeleteposts' 				=> 16384,
	'candeleteothersposts' 	        => 32768,
	'canrateimages' 				=> 65536,
	'canuploadimages'				=> 131072,
	'canuploadfromserver'		    => 262144,
	'cancreatecategories'		    => 524288,
	'canuploadasuser'				=> 1048576,
	'canviewlargimage'			    => 2097152,
	'cansendecard'					=> 4194304,
	'canvieworiginal'				=> 8388608,
	'canchangprofile'               => 16777216,
	'canviewprofiletab'             => 33554432,
	'canviewprofileblock'           => 67108864,
	'canviewforumhomeblock'         => 134217728,
	'canusemultiedit'				=> 268435456
);


// Category Options
$categoryopts = array(
'open_for_images'        => 1,
'open_for_posts'         => 2,
'allow_post_html'        => 4,
'allow_post_bbcode'      => 8,
'allow_post_smilies'     => 16,
'allow_post_icons'       => 32,
'allow_post_bbimgcode'   => 64,
'allow_post_icons'       => 128,
'allow_custom_html'      => 256,
'allow_custom_bbcode'    => 512,
'allow_custom_smilies'   => 1024,
'allow_custom_bbimgcode' => 2048,
'allow_desc_html'        => 4096,
'allow_desc_bbcode'      => 8192,
'allow_desc_smilies'     => 16384,
'allow_desc_icons'       => 32768,
'allow_desc_bbimgcode'   => 65536,
'canhavepassword'        => 131072,
'childpass'              => 262144,
'allow_ratings'          => 524288,
'allow_replies'          => 1048576,
'allow_desc_links'       => 2097152,
'allow_custom_links'     => 4194304
);

// User Category Options
$catuseropts = array(
'allow_view'   => 1,
'allow_upload' => 2,
'allow_reply'  => 4,
'allow_rating' => 8
);
// ######################## Check img cache ##########################
function check_imgext_cache($updatetime=0, $cache_refresh=0)
{
	$update_img_cache = false;
	if($cache_refresh != 0)
	{
		switch ($cache_refresh)
		{
			case 1: 
				// 1 minute
				$update_img_cache = (TIMENOW > ($updatetime+60)) ? true : false;
				break;
					case 2: 
						// 5 minutes
						$update_img_cache = (TIMENOW > ($updatetime+(60*5))) ? true : false;
						break;
					case 3: 
						// 15 minutes
						$update_img_cache = (TIMENOW > ($updatetime+(60*15))) ? true : false;
						break;
					case 4: 
						// 30 minutes
						$update_img_cache = (TIMENOW > ($updatetime+(60*30))) ? true : false;
						break;
					case 5: 
						// 60 minutes
						$update_img_cache = (TIMENOW > ($updatetime+(60*60))) ? true : false;
						break;
					case 6: 
						// 2 hours
						$update_img_cache = (TIMENOW > ($updatetime+(60*60*2))) ? true : false;
						break;
					case 7: 
						// 6 hours
						$update_img_cache = (TIMENOW > ($updatetime+(60*60*6))) ? true : false;
						break;
					case 8: 
						// 12 hours
						$update_img_cache = (TIMENOW > ($updatetime+(60*60*12))) ? true : false;
						break;
					case 9: 
						// 24 hours
						$update_img_cache = (TIMENOW > ($updatetime+(60*60*24))) ? true : false;
						break;
		}
	}
	return $update_img_cache;
}
// ######################## get imageblocktype ##########################
function create_stylesheet($cssname)
{
	global $vbulletin, $style;
	

	$cr = "\n";
	$css_file = $cr;
	$cssstart = '<link rel="stylesheet" type="text/css" href="';
	if($vbulletin->options['storecssasfile'])
	{
		$csspath = 'clientscript/vbulletin_css/style' . str_pad($style['styleid'], 5, '0', STR_PAD_LEFT) . $vbulletin->stylevars['textdirection']['string'][0] . '/';
	}
	else
	{
		$csspath = 'css.php?styleid=' . $vbulletin->userinfo['styleid'] . '&amp;langid=' . LANGUAGEID . '&amp;d=' . $style['dateline'] . '&amp;td=' . $vbulletin->stylevars['textdirection']['string'] . '&amp;sheet=';
	}
	$css_file .= $cssstart . $csspath . $cssname . '" ' . 'id="ppg-forumhome-css" />' . $cr;

	return $css_file;
}

function get_type_phrase($orderby=1)
{
	switch ($orderby)
	{
		case 2: $phrase = 'most_viewed_images'; break;
		case 3: $phrase = 'most_commented_images';break;
		case 4:	$phrase = 'popular_images'; break;
		case 5: $phrase = 'random_images'; break;
		case 6: $phrase = 'sticky_images'; break;
		default: 
			$phrase = 'newest_images';
	}	
	return $phrase;
}




function construct_home_sidebar($content)
{
	global $vbulletin, $vbphrase, $ppg_options;
	// activate sidebar if not active
	$vbulletin->options['enablesidebar'] = 1;
	$sidebarblock = array();
	$sbconfigcache = array();

	$sbconfigcache['html_content'] = $content;
	$imgtypephrase = get_type_phrase($ppg_options['add_home_sb_orderby']);


	$sbconfigcache['html_template'] = 'adv_gallery_sidebar_block';
	$sbconfigcache['html_type'] = 'html';

	$sidebarblock['configcache'] = serialize($sbconfigcache);
	unset($sbconfigcache);


	$sidebarblock['blockid'] = 999999999;
	$sidebarblock['blocktypeid'] = 3;
	$sidebarblock['title'] = $vbphrase[$imgtypephrase];
	$sidebarblock['description'] = 'vbgallery block';
	$sidebarblock['url'] = 'test.php';
	$sidebarblock['cachettl'] = 0;
	$sidebarblock['displayorder'] = 10;
	$sidebarblock['active'] = 1;
	$sidebarblock['productid'] = '';
	$sidebarblock['blocktypename'] = 'html';
	$sidebarblock['blocktypetitle'] = 'Custom HTML/PHP';
	$sidebarblock['blocktypedescription'] = ''; 
	$sidebarblock['allowcache'] = 0;

	$vbulletin->activeblocks = array_insert($vbulletin->activeblocks, $sidebarblock, $ppg_options['add_home_sb_position']);
			// $vbulletin->activeblocks[] = $sidebarblock;
	unset($sidebarblock);
	return true;
}

// ######################## Fetch Private Categories ##########################
function fetch_private_categories()
{
	global $categorycache, $categoryperms, $vbulletin;

	$privatecats = array();

	if (empty($categoryperms))
	{
		$categoryperms = fetch_category_perms();
	}

	if (!empty($categoryperms))
	{
		foreach ($categoryperms AS $catid => $cperms)
		{
			if (is_category_mod($catid))
			{
				continue;
			}

			if ($categorycache["$catid"]['catuserid'])
			{
				$useroptions = construct_cat_user_opts($catid, $categorycache["$catid"]['useroptions']);
				if (!$useroptions['allow_view'])
				{
					$privatecats[] = $catid;
				}
			}
			else
			{
				$catopts = construct_cat_opts($catid, $categorycache["$catid"]['options']);

				if ($catopts['canhavepassword'] AND !$categorycache["$catid"]['password'])
				{
					$parentlist = explode(',', $categorycache["$catid"]['parentlist']);

					if (!empty($parentlist))
					{
						foreach ($parentlist AS $pcatid)
						{
							$catopts = construct_cat_opts($pcatid, $categorycache["$pcatid"]['options']);
							if ($categorycache["$pcatid"]['password'] AND $catopts['childpass'])
							{
								if (fetch_bbarray_cookie('catpassword', $pcatid) != md5($vbulletin->userinfo['userid'] . $categorycache["$pcatid"]['password']))
								{
									$privatecats[] = $catid;
								}
							}
						}
					}
				}
			}

			if (($categorycache["$catid"]['password'] AND fetch_bbarray_cookie('catpassword', $catid) != md5($vbulletin->userinfo['userid'] . $categorycache["$catid"]['password'])) OR ((!$cperms['canviewimages'] OR !$cperms['canviewgallery'] OR !$categorycache["$catid"]['active']) AND !is_category_mod($catid)))
			{
				$privatecats[] = $catid;
			}
		}
	}
	return implode(',', $privatecats);
}

// #################### Construct Imagebits ######################
function construct_sidebar_imagebits(&$images, $highlight = '',$type=0)
{





}
// #################### Construct Imagebits ######################
function construct_free_imagebits(&$images, $highlight = '',$type=0)
{





}

// #################### Construct Imagebits ######################
function construct_imagebits(&$images, $highlight = '',$type=0)
{
	global $vbulletin, $ppg_options, $stylevar, $vbphrase, $show, $adv_sorturl, $catinfo, $counter, $cellwidth, $categoryperms, $showfields, $categorycache, $catopts, $bbcode_parser;

	$tmpvars = array();
	if($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1)
	{
		$tmpvars['albumclass'] = '_alt';
	}

	if ($counter > $ppg_options['gallery_columns'])
	{
		$imagebits .= '</tr><tr>';
		$counter = 1;
	}

	// check for imagebit lite
	$show['imgbit_lite'] = false;
	$show['imgbit_lite_block'] = false;
	
	$templatename = 'adv_gallery_imagebit_lite';

	if ($showfields['title'])
	{
		$images['title'] = htmlspecialchars_uni(stripslashes($images['title']));

		if (!$images['title'])
		{
			$images['title'] = htmlspecialchars_uni($images['filename']);
		}
	}


	if (!$catopts["$images[catid]"])
	{
		$catopts["$images[catid]"] = construct_cat_opts($images['catid'], $categorycache["$images[catid]"]['options']);
	}

	if ($images['originalname'])
	{
		if ($ppg_options['gallery_watermark'] AND $ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = 'displayimage.php?imageid=' . $images['imageid'] . '&original=1';
		}
		else if ($ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = construct_image_url($images, 'originalname');
		}
		else
		{
			$images['originalurl'] = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $images['imageid'] . '&amp;original=1';
		}
	}

	$images['username'] = htmlspecialchars_uni(stripslashes($images['username']));
	$images['userurl'] =  fetch_seo_url('member', array('userid' => $images['userid'],	'username' => $images['username']));

	$images['cattitle'] = htmlspecialchars_uni(stripslashes($images['cattitle']));
	if(!$show['imgbit_lite_block'] AND !$show['imgbit_lite'])
	{
		$images['views'] = vb_number_format($images['views']);
		$images['filesize'] = vb_number_format($images['filesize'], 1, true);
		$images['dateadded'] = vbdate($vbulletin->options['dateformat'], $images['dateline']);
		$images['timeadded'] = vbdate($vbulletin->options['timeformat'], $images['dateline']);
		$images['description'] = htmlspecialchars_uni(stripslashes($images['description']));
	
	
		if ($images['originalfilesize'])
		{
			$images['originalfilesize'] = vb_number_format($images['originalfilesize'], 1, true);
		}

		if ($categoryperms["$images[catid]"]['canviewreplies'])
		{
			$images['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $images['lastpostdateline']);
			$images['lastposttime'] = vbdate($vbulletin->options['timeformat'], $images['lastpostdateline']);
			$images['lastpostusername'] =  htmlspecialchars_uni(stripslashes($images['lastpostusername']));
			$images['lastpostuserurl'] =  fetch_seo_url('member', array('userid' => $images['lastpostuserid'],	'username' => $images['lastimageusername']));
			$images['replies'] = vb_number_format($images['posts']);
		}
		else
		{
			$images['replies'] = 0;
			$images['lastpostdateline'] = 0;
		}
	}
	$images['url'] = construct_image_url($images, 'thumbname');

// nomore show sticky, we use images[sticky]	instead of $show['sticky'] = false;


	$show['subscribed'] = false;
	if ($images['subid'])
	{
		$show['subscribed'] = true;
	}

	$images['rating'] = '';
	if ($images['votetotal'] AND $images['votenum'])
	{
		$images['truerating'] = vb_number_format($images['votetotal'] / $images['votenum'], 2);
		$images['rating'] = round($images['truerating']);
	}
		


 		$templater = vB_Template::create($templatename);
		$templater->register('adv_sorturl', $adv_sorturl);
		// we rename tmpvars to ppg_vars so we dont register ALL ppg_vars
		$templater->register('ppg_vars', $tmpvars);

		$templater->register('images', $images);
		$templater->register('cellwidth', $cellwidth);
		$templater->register('catinfo', $catinfo);
		$templater->register('showfields', $showfields);

        $imagebits .= '<td align="center" valign="top" width="20%">' . $templater->render() . '</td>'; 
	return $imagebits;
}




// ######################## Construct Empty Imagebits #########################
function construct_empty_cellbits($cells, $colspan = 0)
{
	global $counter, $ppg_options;

	$cellwidth = round(100 / $cells) . '%';

	if ($counter AND $counter != $cells)
	{
		for ($i = $counter; $i < $cells; $i++)
		{
			$emptycells .= '<td  ' . iif($colspan, 'colspan="' . $colspan . '"') . ' width="' . $cellwidth . '"></td>';
		}
	}
	return $emptycells;
}

// ######################### Fetch Category Permissions #######################
function fetch_category_perms($catid = 0, $ugid = '')
{
	global $vbulletin, $gallerypermissionsbit, $gallery_permissions, $galleryperms, $categorycache;

	if ($ugid)
	{
		$usergroupids = $ugid;
	}
	else
	{
		$usergroupids = fetch_membergroupids_array($vbulletin->userinfo);
	}

	$catperms = array();
	$categoryperms = array();

	if ($catid == 0)
	{
		foreach (array_keys($categorycache) AS $catid)
		{
			$thiscatperms = unserialize($categorycache["$catid"]['permissions']);

			if (empty($thiscatperms))
			{
				$catperms["$catid"] = $galleryperms;
				continue;
			}

			foreach ($usergroupids AS $usergroupid)
			{
				if (empty($thiscatperms["$usergroupid"]) AND $thiscatperms["$usergroupid"] != '0')
				{
					if (empty($gallery_permissions["$usergroupid"]))
					{
						$usergroupid = 1;
					}

					$categoryperms["$catid"] = $gallery_permissions["$usergroupid"]['gallery_perms'];
				}
				else
				{
					$categoryperms["$catid"] = $thiscatperms["$usergroupid"];
				}

				foreach ($gallerypermissionsbit AS $option => $value)
				{
					if (in_array($option, array('moderateimages', 'moderateposts')) AND $catperms["$catid"]["$option"] == 0 AND isset($catperms["$catid"]["$option"]))
					{
						continue;
					}
					if (!$catperms["$catid"]["$option"] OR in_array($option, array('moderateimages', 'moderateposts')))
					{
						$catperms["$catid"]["$option"] = 0;
						if ($categoryperms["$catid"] & $value)
						{
							$catperms["$catid"]["$option"] = 1;
						}
					}
				}
			}
		}
	}
	else
	{
		$thiscatperms = unserialize($categorycache["$catid"]['permissions']);

		foreach ($usergroupids AS $usergroupid)
		{
			if (empty($thiscatperms["$usergroupid"]) AND $thiscatperms["$usergroupid"] != '0')
			{
				$categoryperms = $gallery_permissions["$usergroupid"]['gallery_perms'];
			}
			else
			{
				$categoryperms |= $thiscatperms["$usergroupid"];
			}
			foreach ($gallerypermissionsbit AS $option => $value)
			{
				if (!$catperms["$option"] OR (in_array($option, array('moderateimages', 'moderateposts')) AND $catperms["$option"] == 0))
				{
					$catperms["$option"] = 0;
					if ($categoryperms & $value)
					{
						$catperms["$option"] = 1;
					}
				}
			}
		}
	}

	return $catperms;
}
// ######################### Find Category Mods #########################
function is_category_mod($catid)
{
	global $vbulletin, $permissions, $categorycache, $ppg_options;

	if (($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
	{
		return true;
	}
	else if ($categorycache["$catid"]['catuserid'] AND $vbulletin->userinfo['userid'] == $categorycache["$catid"]['catuserid'] AND $ppg_options['gallery_usercats_modopts'])
	{
		return true;
	}
	else
	{
		$gallery_modcache = cache_gallery_mods();

		foreach (explode(',', $categorycache["$catid"]['parentlist']) AS $parentid)
		{
			if ($gallery_modcache["$parentid"])
			{
				foreach($gallery_modcache["$parentid"] AS $moderator)
				{
					if ($vbulletin->userinfo['userid'] == $moderator['userid'])
					{
						return true;
					}
				}
			}
		}
	}
}

// ######################### Fetch Ignored Userids ############################
function fetch_ignored_users($catid = 0)
{
	global $vbulletin;
	$ignusers = array();
	if (!is_category_mod($catid))
	{
		$ignusers = fetch_coventry();
	}
	if ($vbulletin->userinfo['ignorelist'])
	{
		$ignusers = array_merge((array)$ignusers, (array)explode(' ', $vbulletin->userinfo['ignorelist']));
	}

	if (!empty($ignusers))
	{
		return implode(',', $ignusers);
	}
}
// ##################### Fetch other users diskquota ############################
function fetch_userquota($userid)
{
    global $vbulletin, $gallerypermissionsbit, $userinfo;


	$gallery_permissions =& $vbulletin->gallery_ugroups;
	$bbuserino['usergrouparray'] = fetch_membergroupids_array($userinfo);

	if (empty($bbuserinfo['usergrouparray']))
	{
		$bbuserinfo['usergrouparray'] = array(1);
	}

	foreach ($bbuserino['usergrouparray'] AS $usergroupid)
	{
		if (empty($gallery_permissions["$usergroupid"]))
		{
			$usergroupid = 1;
		}

		foreach ($gallery_permissions["$usergroupid"] AS $option => $value)
		{
			if ($option == 'gallery_maxdiskspace')
			{
				$space  = $value;
			}
		}
	}
	return $space;


}
// ##################### Fetch gallery permissions ############################
function fetch_galperms($ext=0)
{
    global $vbulletin, $gallerypermissionsbit;


	$gallery_permissions =& $vbulletin->gallery_ugroups;
	$bbuserino['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);


	if (empty($bbuserinfo['usergrouparray']))
	{
		$bbuserinfo['usergrouparray'] = array(1);
	}

	
	foreach ($bbuserino['usergrouparray'] AS $usergroupid)
	{
		if (empty($gallery_permissions["$usergroupid"]))
		{
			$usergroupid = 1;
		}

		foreach ($gallerypermissionsbit AS $option => $value)
		{
			if (in_array($option, array('moderateimages', 'moderateposts')) AND $galleryperms["$option"] == 0 AND isset($galleryperms["$option"]))
			{
				continue;
			}
			if (!$galleryperms["$option"] OR in_array($option, array('moderateimages', 'moderateposts')))
			{
				$galleryperms["$option"] = 0;
				if ($gallery_permissions["$usergroupid"]['gallery_perms'] & $value)
				{
					$galleryperms["$option"] = 1;
				}
			}
		}
		if($ext == 1)
		{
			foreach ($gallery_permissions["$usergroupid"] AS $option => $value)
			{
				if (($option == 'gallery_maxcats' AND !($gallery_permissions["$usergroupid"]['gallery_perms'] & $gallerypermissionsbit['cancreatecategories'])) OR ($option == 'gallery_maxdiskspace' AND !($gallery_permissions["$usergroupid"]['gallery_perms'] & $gallerypermissionsbit['canuploadimages'])))
				{
					continue;
				}
				if (((($value > $galleryperms["$option"] AND $galleryperms["$option"] != '0') OR !$value) AND $option != 'gallery_perms'))
				{
					$galleryperms["$option"] = $value;
				}
			}
		}
	}

	return $galleryperms;
}


// ############################ Construct Image URL ###########################
function construct_image_url($image, $filename = 'filename', $fulllink = false)
{
	global $ppg_options, $server, $userid;

    ($hook = vBulletinHook::fetch_hook('ppgal_construct_image_url')) ? eval($hook) : false;

	if (!in_array($image['extension'], array('gif', 'jpg', 'jpeg', 'png', 'psd', 'bmp')) OR ($filename == 'thumbname' AND !$image['thumbname']))
	{
		if ($fulllink){
			return '<a href="misc.php?' . $vbulletin->session->vars['sessionurl'] . 'do=downloadfile&amp;i=' . $image['imageid'] . '"><img alt="" border="0" src="' . $ppg_options['gallery_url'] . '/images/file_' . $image['extension'] . '.gif" /></a>';
		}else{
			return iif($filename == 'filename', $ppg_options['gallery_url'] . '/misc.php?do=downloadfile&amp;i=' . $image['imageid'], $ppg_options['gallery_url'] . '/images/file_' . $image['extension'] . '.gif');
		}
	}else{
		if ($fulllink){
			if ($filename == 'originalname'){
				$image['width'] = $image['originalwidth'];
				$image['height'] = $image['originalheight'];
			}

			return '<img title="' . $image['title'] . '" id="vbgbigimg" class="vbgbigimg" alt="' . $image['title'] . '" border="0" height="' . $image['height'] . '" src="' . iif($ppg_options['gallery_echoimage'], 'displayimage.php?' . $vbulletin->session->vars['sessionurl'] . 'imageid=' . $image['imageid'] . iif($filename == 'originalname', '&amp;original=1'), fetch_folder_url($image) . '/' . $image["$filename"]) . '" width="' . $image['width'] . '" />';

        }else{

            if ($server['upload'] AND $image['thumbname'] == $image['filename']){

            return $ppg_options['gallery_userfolderurl'] . '/' . $userid . '/' . $image["$filename"];

    			}
    			else if ($ppg_options['gallery_echoimage'] AND ($filename == 'filename' OR $filename == 'originalname'))
    			{
    				return $ppg_options['gallery_url'] . '/displayimage.php?imageid=' . $image['imageid'] . iif($filename == 'originalname', '&amp;original=1');
    			}else{

            return fetch_folder_url($image) . '/' . $image["$filename"];
			}
		}
	}
}


// ############################ Fetch Folder URL ################################
function fetch_folder_url($image, $foldersonly = '')
{
	global $ppg_options;

	if ($ppg_options['gallery_insafemode'])
	{
		return iif(!$foldersonly, $ppg_options['gallery_fileurl'], '');
	}

	return iif(!$foldersonly, $ppg_options['gallery_fileurl'] . '/') . implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY));
}

// ############################ Cache Moderators ############################
function cache_gallery_mods()
{
	global $vbulletin;

	if ($gallerymods =& $vbulletin->gal_mod_cache)
	{
		foreach ($gallerymods AS $moderator)
		{
			$moderator['musername'] = fetch_musername($moderator);
			$gallery_modcache["$moderator[catid]"]["$moderator[userid]"] = $moderator;
		}
	}
	return $gallery_modcache;
}
// ####################### Construct Category Options ########################
function construct_cat_opts($catid, $catint)
{
	global $categoryopts;

	foreach ($categoryopts AS $option => $value)
	{
		$catopts["$option"] = 0;
		if ($catint & $value)
		{
			$catopts["$option"] = 1;
		}
	}
	return $catopts;
}

// ####################### Construct Category User Options ############################
function construct_cat_user_opts($catid, $catint)
{
	global $catuseropts;

	foreach ($catuseropts AS $option => $value)
	{
		$useropts["$option"] = 0;
		if ($catint & $value)
		{
			$useropts["$option"] = 1;
		}
	}
	return $useropts;
}

/**
 * Function array_insert().
 *
 * Returns the new number of the elements in the array.
 *
 * @param array $array Array (by reference)
 * @param mixed $value New element
 * @param int $offset Position
 * @return int
 */
function array_insert(&$array, &$inset, $offset=0)
{
    if (is_array($array)) {
        $array  = array_values($array);
        $offset = intval($offset);
        if ($offset < 0 || $offset >= count($array)) {
            array_push($array, $inset);
        } elseif ($offset == 0) {
            array_unshift($array, $inset);
        } else {
            $temp  = array_slice($array, 0, $offset);
            array_push($temp, $inset);
            $array = array_slice($array, $offset);
            $array = array_merge($temp, $array);
        }
    } else {
        $array = array($inset);
    }
    return $array;
}


?>