<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: functions_gallery_imageedit.php                                  ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('LOCATION_BYPASS', 1);
if(!defined('THIS_SCRIPT')){exit;}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

($hook = vBulletinHook::fetch_hook('ppgal_imageedit_start')) ? eval($hook) : false;

if($ppg_options['gallery_resizemethod'] == 'GD2')
{
	require_once(DIR . '/includes/vbgallery/xba_unsharp_mask.php');
}

// #######################################################################
// Resize Image 
function resize_image($widthsize, $heightsize, $original = 0, $nameonly = false, $savepath = '')
{
	global $imageinfo, $ppg_options, $userid, $catoptions;

	if (empty($catoptions["$imageinfo[catid]"]))
	{
		$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
	}

	if ($heightsize AND $widthsize)
	{
		$heightpercent = $imageinfo['height'] / $heightsize;
		$widthpercent = $imageinfo['width'] / $widthsize;
	}

	if ($heightpercent > 1 OR $widthpercent > 1)
	{
		if ($widthpercent > $heightpercent)
		{
			$shrinkage = $widthsize / $imageinfo['width'];
		}
		else
		{
			$shrinkage = $heightsize / $imageinfo['height'];
		}

		$newheight = round($shrinkage * $imageinfo['height']);
		$newwidth = round($shrinkage * $imageinfo['width']);

		if ($savepath)
		{
			$savepath = $savepath;
		}
		else if ($original)
		{
			$savepath = $imageinfo['location'];
		}
		else if ($ppg_options['gallery_resizemethod'] == 'IM' OR (in_array($ppg_options['gallery_resizemethod'], array('GD1', 'GD2')) AND in_array($imageinfo['numericaltype'], array(1,2,3))))
		{
			$imageinfo['thumbname'] = $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension'];
			$savepath = $imageinfo['saveto'] . '/' . $imageinfo['thumbname'];
		}
		else
		{
			$imageinfo['thumbname'] = '';
		}

		if ($nameonly)
		{
			return $imageinfo;
		}

// ******************************************
// **********  Settings for square thumbnails
// ******************************************
		

		// Now let's resize it
		// this is for configuration: 

            // check for gif support..
            if (function_exists('imagegif') AND function_exists('imagecreatefromgif'))
            {
                $giftype = 1;
            }
            else 
            {
                $giftype = 0;
            }

		if (($ppg_options['gallery_squarethumbs'] == 1) AND $imageinfo['thumbname'] != '' AND ($ppg_options['gallery_resizemethod'] == 'GD2') AND ($original != 1) AND in_array($imageinfo['numericaltype'], array($giftype,2,3) ) )
		{ 
			// square thumbs with gd	
		

            
			if(intval($catoptions["$imageinfo[catid]"]['gallery_thumbsize'])>1)
			{
				$thumbnail_width = $catoptions["$imageinfo[catid]"]['gallery_thumbsize'];
				$thumbnail_height = $catoptions["$imageinfo[catid]"]['gallery_thumbsize'];
			}
			else
			{
				$thumbnail_width = $ppg_options['gallery_thumbsize'];
				$thumbnail_height = $ppg_options['gallery_thumbsize'];
			}
			

			$landscape = false;
			
			// the file exist is not sufficiant, because if originalname is empty.. the file still exists..for php (as the directory exitst)

			if( ($imageinfo['originalname']) AND (($imageinfo['originalwidth'] > 0) AND ($imageinfo['originalheight'] > 0)) )
			{
				//make thumb from original
				$src_pic = $imageinfo['saveto'] . '/' . $imageinfo['originalname'];
				$pic_width = $imageinfo['originalwidth'];
				$pic_height = $imageinfo['originalheight'];		
						
			}
			else
			{
				// make thumb from intermediate
				$src_pic = $imageinfo['location'];
				$pic_width = $imageinfo['width'];
				$pic_height = $imageinfo['height'];
			}

			if ($pic_width > $pic_height)
			{
				$landscape = true;
				if(!$imageinfo['cropid'])
				{
					$imageinfo['cropid'] = 2;

				}
			}
			else
			{
				if(!$imageinfo['cropid'])
				{
					if($ppg_options['gallery_autocrop'])
					{
						$imageinfo['cropid'] = 1;
					}
					else
					{
						$imageinfo['cropid'] = 2;
					}

				}
			}

			if($landscape)
			{
				$pseudo_pic_width = $pic_height;
				$pseudo_pic_height = $pic_height;
				$a = 0;
				$b = 0;
				$x = round(($pic_width-$pseudo_pic_height)/2);
				switch ($imageinfo['cropid'])
				{
					case 1:
						$x = 0;
						break;
					case 2:
						$x = round(($pic_width-$pseudo_pic_height)/2);
						break;
					case 3:
						$x = $pic_width-$pseudo_pic_height;
						break;
				}
				$y = 0;


			}
			else
			{
				$pseudo_pic_width = $pic_width;
				$pseudo_pic_height = $pic_width;
				$a = 0;
				$b = 0;
				$x = 0;
				switch ($imageinfo['cropid'])
				{
					case 1:
						$y = 0;
						break;
					case 2:
						$y = round(($pic_height-$pseudo_pic_width)/2);
						break;
					case 3:
						$y = $pic_height - $pseudo_pic_width;
						break;
				}

			}


			$resize_function = 'imagecopyresampled'; // we only have gd2


			switch ($imageinfo['numericaltype'])
			{
				// Gif Image $im = @ImageCreateFromGIF ($imgname);
				case 1:

					$src_img =  @ImageCreateFromGIF($src_pic);

					$dst_img = @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
					@imagecopyresampled($dst_img, $src_img, $a, $b, $x, $y, $thumbnail_width, $thumbnail_height, $pseudo_pic_width, $pseudo_pic_height);
					if($ppg_options['gallery_sharpenthumbs'] == 1)
					{
						$dst_img = sharpen($dst_img, 6);
					}
					@imageGif($dst_img, $savepath);

					break;
				// JPG Image
				case 2:

					$quality = $catoptions["$imageinfo[catid]"]['gallery_thumbquality'];
					if($quality)
					{
						if($quality != -1)
						{
							if ($quality > 0 AND $quality < 20)
							{
								$quality = 20;
							}
							if($quality > 90)
							{
								$quality = 90;			
							}
						}
					}
					else
					{
						$quality = -1;
					}
					$src_img = @imagecreatefromjpeg($src_pic);
					$dst_img = @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
					@imagecopyresampled($dst_img, $src_img, $a, $b, $x, $y, $thumbnail_width, $thumbnail_height, $pseudo_pic_width, $pseudo_pic_height);
					if($ppg_options['gallery_sharpenthumbs'] == 1)
					{
						$dst_img = sharpen($dst_img, 6);
					}

					@imagejpeg($dst_img, $savepath, $quality);

					break;
				// PNG Image
				case 3:
					$src_img = @imagecreatefrompng($src_pic);
					$dst_img = @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
					@imagecopyresampled($dst_img, $src_img, $a, $b, $x, $y, $thumbnail_width, $thumbnail_height, $pseudo_pic_width, $pseudo_pic_height);
					if($ppg_options['gallery_sharpenthumbs'] == 1)
					{
						$dst_img = sharpen($dst_img, 6);
					}
					@imagepng($dst_img, $savepath);
					break;
				default:
					$quality = $catoptions["$imageinfo[catid]"]['gallery_thumbquality'];
					if($quality)
					{
						if($quality != -1)
						{
							if ($quality > 0 AND $quality < 20)
							{
								$quality = 20;
							}
							if($quality > 90)
							{
								$quality = 90;			
							}
						}
					}
					else
					{
						$quality = -1;
					}
					$src_img = @imagecreatefromjpeg($src_pic);
					$dst_img = @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
					@$resize_function($dst_img, $src_img, $a, $b, $x, $y, $thumbnail_width, $thumbnail_height, $pseudo_pic_width, $pseudo_pic_height);

					if($ppg_options['sharpen'] == 1)
					{
						$dst_img = sharpen($dst_img, $ppg_options['sharpen_thumb']);
					}							
					@imagejpeg($dst_img, $savepath, $quality);

			}

			@chmod($savepath, 0777);
			@imagedestroy($src_img);
			@imagedestroy($dst_img);




		}
		else if (($ppg_options['gallery_squarethumbs'] == 1) AND $imageinfo['thumbname'] != '' AND ($ppg_options['gallery_resizemethod'] == 'IM') AND ($original != 1) AND in_array($imageinfo['numericaltype'], array(1,2,3) ) )
		{



			if(intval($catoptions["$imageinfo[catid]"]['gallery_thumbsize'])>1)
			{
				$thumbnail_width = $catoptions["$imageinfo[catid]"]['gallery_thumbsize'];
				$thumbnail_height = $catoptions["$imageinfo[catid]"]['gallery_thumbsize'];
			}
			else
			{
				$thumbnail_width = $ppg_options['gallery_thumbsize'];
				$thumbnail_height = $ppg_options['gallery_thumbsize'];
			}
			if($thumbnail_width > $thumbnail_height)
			{
				$thumbnail_size = $thumbnail_width;
			}
			else
			{
				$thumbnail_size = $thumbnail_height;
			}

			$landscape = false;
			
			// the file exist is not sufficiant, because if originalname is empty.. the file still exists..for php (as the directory exitst)

			if( ($imageinfo['originalname']) AND (($imageinfo['originalwidth'] > 0) AND ($imageinfo['originalheight'] > 0)) )
			{
				//make thumb from original
				$src_pic = $imageinfo['saveto'] . '/' . $imageinfo['originalname'];
				$pic_width = $imageinfo['originalwidth'];
				$pic_height = $imageinfo['originalheight'];		
						
			}
			else
			{
				// make thumb from intermediate
				$src_pic = $imageinfo['location'];
				$pic_width = $imageinfo['width'];
				$pic_height = $imageinfo['height'];
			}

			if ($pic_width > $pic_height)
			{
				$landscape = true;
				if(!$imageinfo['cropid'])
				{
					$imageinfo['cropid'] = 2;

				}
			}
			else
			{
				if(!$imageinfo['cropid'])
				{
					if($ppg_options['gallery_autocrop'])
					{
						$imageinfo['cropid'] = 1;
					}
					else
					{
						$imageinfo['cropid'] = 2;
					}

				}
			}



			$thumbRatio = 1; // square
			$inRatio = $pic_width/$pic_height;   
			$isLandscape = $inRatio > $thumbRatio;   
			$size = ($isLandscape ? '1000x' . $thumbnail_size : $thumbnail_size . 'x1000');
			if($isLandscape)
			{
				$yoff = 0;
				$x = round($thumbnail_size / ($pic_height/$pic_width));
				switch ($imageinfo['cropid'])
				{
					case 1:
						$xoff = 0;
					
						break;
					
					case 2:
						$xoff = round(($x - $thumbnail_size)/2);
						break;

					case 3:
						$xoff = $x - $thumbnail_size;
						break;

					default:
						$xoff = round(($x - $thumbnail_size)/2);

				}
			}
			else
			{
				$xoff = 0;
				$y = round($thumbnail_size / ($pic_width/$pic_height));
				switch ($imageinfo['cropid'])
				{
					case 1:
						print 'cropid='. $imageinfo['cropid'] . '<br />'; 
						$yoff = 0;
						break;
					
					case 2:
						$yoff = round(($y - $thumbnail_size)/2);
						break;

					case 3:
						$yoff = $y - $thumbnail_size;
						break;

					default:
						$yoff = round(($y - $thumbnail_size)/2);

				}
			}

			$quality = $catoptions["$imageinfo[catid]"]['gallery_thumbquality'];
			if($quality)
			{
				if ($quality == -1)
				{
					$quality = '';
				}
				else if ($quality < 20)
				{
					$quality = 20;
				}
				else if($quality > 90)
				{
					$quality = 90;			
				}
			}
			else
			{
				$quality = '';	
			}


			// we sharpen only jpgs
			$sharpen = ($imageinfo['numericaltype'] == 2 AND $ppg_options['gallery_sharpenthumbs']) ? " -sharpen 0x1 " : '';

			// added pdf for future use... ^^

			$IMcommand = '"' . $ppg_options['gallery_programpath'] . 'convert" ' . $imageinfo['location'] . iif(($imageinfo['extension'] == 'gif' OR $imageinfo['extension'] == 'pdf'), '[0]') . ' -thumbnail ' . $size . ' -crop ' . $thumbnail_size . 'x' . $thumbnail_size . '+' . $xoff . '+'. $yoff . ' -colorspace RGB -strip ' . $sharpen . iif(($quality != ''), ' -quality ' . $quality) . ' ' . $savepath;

			exec($IMcommand);

			if (!in_array($IMerror, array(0, 1)))
			{
				//@unlink($imageinfo['location']);
				eval(standard_error(fetch_error('adv_gallery_im_error', $vbulletin->options['contactuslink'], $IMerror, $IMcommand)));
			}



		}
		else
		{
			
			modify_image($savepath, $newwidth, $newheight, iif($original, $catoptions["$imageinfo[catid]"]['gallery_origquality'], $catoptions["$imageinfo[catid]"]['gallery_thumbquality']), 1);
		}


		// New image info if resizing original
		if ($original == 1)
		{
			$imageinfo['width'] = $newwidth;
			$imageinfo['height'] = $newheight;
			clearstatcache();
			$imageinfo['filesize'] = @filesize($imageinfo['location']);
		}
	}
	else
	{
		// Else we're not resizing
		if (!$original AND !$imageinfo['thumbname'])
		{
			$imageinfo['thumbname'] = $imageinfo['saveas'];
		}
	}

	return $imageinfo;
}

// ########################### Resize or Change Quality #######################
function modify_image($savepath, $width, $height, $quality, $thumb=0)
{
	global $ppg_options, $imageinfo, $vbulletin;

	switch ($ppg_options['gallery_resizemethod'])
	{
		// Use GD to Resize
		case 'GD1':
		case 'GD2':

			switch ($imageinfo['numericaltype'])
			{
				// JPG Image
				case 2:
					$src_img = @imagecreatefromjpeg($imageinfo['location']);
					if ($width AND $height)
					{
						if ($ppg_options['gallery_resizemethod'] == 'GD1')
						{
							$dst_img = @imagecreate($width, $height);
							@imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
						}
						else
						{
							$dst_img = @imagecreatetruecolor($width, $height);
							@imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
						
							if($thumb == 1 AND $ppg_options['gallery_sharpenthumbs'])
							{
								$dst_img = sharpen($dst_img, 6);
							}
							
							if($quality)
							{
								if ($quality == -1)
								{
									$quality = -1;
								}
								else if ($quality < 20)
								{
									$quality = 20;
								}
								else if($quality > 90)
								{
									$quality = 90;			
								}

							}
							else
							{
								$quality = 90;
							}
							
						}
					}
					else
					{
						$dst_img = $src_img;
					}



					@imagejpeg($dst_img, $savepath, $quality);
					@chmod($savepath, 0777);
					break;

			        // PNG Image
 		                case 3:
   		                $src_img = @imagecreatefrompng($imageinfo['location']);
   		                if ($ppg_options['gallery_resizemethod'] == 'GD1')
    		                {
    		                $dst_img = @imagecreate($width, $height);
    		                @imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
    		                }
    		                else
   		                {
   		                $dst_img = @imagecreatetruecolor($width, $height);
    		                @imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
     		                }
     		                @imagepng($dst_img, $savepath);
							@chmod($savepath, 0777);
    		                break;

				case 1:
					if (function_exists('imagegif') AND function_exists('imagecreatefromgif'))
					{
						$src_img = @imagecreatefromgif($imageinfo['location']);
						$trans = @imagecolortransparent($src_img);
						$dst_img = @imagecreate($width, $height);
						@imagepalettecopy($dst_img, $src_img);
						@imagefill($dst_img, 0, 0, $trans);
						@imagecolortransparent($dst_img, $trans);
						@imagecopyresized($dst_img,$src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
						@imagegif($dst_img, $savepath);
						@chmod($savepath, 0777);
					}
					break;
			}

			@imagedestroy($src_img);
			@imagedestroy($dst_img);

			break;

		// Use ImageMagick to Resize
		case 'IM':
			if($quality)
			{
				if ($quality == -1)
				{
					$quality = '';
				}
				else if ($quality < 20)
				{
					$quality = 20;
				}
				else if($quality > 90)
				{
					$quality = 90;			
				
				}
			}
			else
			{
				$quality = '';
			}

			// we sharpen only jpgs

			$sharpen = ($thumb==1 AND $imageinfo['numericaltype'] == 2 AND $ppg_options['gallery_sharpenthumbs']) ? " -sharpen 0x1 " : '';
		
			$IMcommand = '"' . $ppg_options['gallery_programpath'] . 'convert" ' . iif($width AND $height, '-size ' . $width . 'x' . $height. ' -geometry ' . $width . 'x' . $height) . $sharpen . iif($quality, ' -quality ' . $quality) . ' ' . $imageinfo['location'] . iif($imageinfo['extension'] == 'gif', '[0]') . ' ' . $savepath;

			exec($IMcommand);
			//print '<pre>' . $IMcommand . '<br />'; 
			//print_r($IMerror);
			//exit;
			if (!in_array($IMerror, array(0, 1)))
			{
				@unlink($imageinfo['location']);
				eval(standard_error(fetch_error('adv_gallery_im_error', $vbulletin->options['contactuslink'], $IMerror, $IMcommand)));
			}

			break;
	}
}

// ############################# Process Upload ###############################
function process_upload($thumbcreated = false, $new = true)
{
	global $db, $vbulletin, $galleryperms, $ppg_options, $imageinfo, $imageoptions, $customfields, $userinfo, $categoryperms, $imgtypearray, $filetypes, $userid, $username, $catoptions, $massimageinfo;
	static $errors;

	if (empty($catoptions["$imageinfo[catid]"]))
	{
		$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
	}

	$userinfo['usedspace'] += $imageinfo['filesize'];
	// Make sure the user has enough space on their account
	if ($galleryperms['gallery_maxdiskspace'] AND $galleryperms['gallery_maxdiskspace'] < $userinfo['usedspace'])
	{
		eval(standard_error(fetch_error('adv_gallery_nodiskspace', $imageinfo['filesize'], ($galleryperms['gallery_maxdiskspace'] - $userinfo['usedspace']))));
	}

	if (function_exists('exif_read_data'))
	{
		// try to read header exif
		$exif = @exif_read_data($ppg_options['gallery_filedirectory'] . '/' . implode('/', preg_split('//', $userid, -1, PREG_SPLIT_NO_EMPTY)) . '/' . $imageinfo['saveas'], 'EXIF');
	}
	$imageinfo = resize_image($catoptions["$imageinfo[catid]"]['gallery_thumbsize'], $catoptions["$imageinfo[catid]"]['gallery_thumbsize'], 0, iif($new OR $catoptions["$imageinfo[catid]"]['gallery_thumbsize'] != $catoptions["$massimageinfo[catid]"]['gallery_thumbsize'], false, true));

	// Get original image info
	if ($catoptions["$imageinfo[catid]"]['gallery_saveoriginal'] AND ($imageinfo['width'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'] OR $imageinfo['height'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height']))
	{
		$imageinfo['originalname'] = $imageinfo['shortname'] . '_original.' . $imageinfo['extension'];
		@copy($imageinfo['location'], $imageinfo['saveto'] . '/' . $imageinfo['originalname']);
		$imageinfo['originalfilesize'] = $imageinfo['filesize'];
		$imageinfo['originalwidth'] = $imageinfo['width'];
		$imageinfo['originalheight'] = $imageinfo['height'];
		// Reduce the quality if necessary
		// and reduce the size if necessary
		// resize original
		$fileresize = false;
		if(($ppg_options['gallery_resize_original']) AND ($imageinfo['originalname']))
		{	// resize if nessesary
			// first we check size

			// We know the file is bigger than the intermediate now we check if it is bigger than the size we allow
			if(($imageinfo['originalwidth'] > $ppg_options['gallery_resize_original']) OR ($imageinfo['originalheight'] > $ppg_options['gallery_resize_original']))
			{
				// it is bigger if we are here
				// so lets calculate the new size
				if ($imageinfo['originalwidth'] > $imageinfo['originalheight'])
				{
					$new_width = $ppg_options['gallery_resize_original'];
					$new_height = $ppg_options['gallery_resize_original'] * ($imageinfo['originalheight']/$imageinfo['originalwidth']);
				}
				else
				{
					$new_height = $ppg_options['gallery_resize_original'];
					$new_width = $ppg_options['gallery_resize_original'] * ($imageinfo['originalwidth']/$imageinfo['originalheight']);
				}

				$imageinfo['originalwidth'] = $new_width;
				$imageinfo['originalheight'] = $new_height;
				$fileresize = true; // we dont need filesize and qualitycheck anymore cause we are resizing anyway!
			}
		}
		// now we check the filesize in kb if its bigger than max
		// TODO ADD TO ACP $ppg_options['gallery_max_filesize_original']
		if((!$fileresize) AND isset($ppg_options['gallery_max_filesize_original']) AND ($ppg_options['gallery_max_filesize_original'] > 0) AND (($imageinfo['originalname'])) )
		{
			if($imageinfo['originalfilesize'] > $ppg_options['gallery_max_filesize_original'])
			{
				$fileresize = true; 
			}
		}
		
		
		// now we check if we have todo a resize
		if($fileresize)
		{
			$imageinfo['originalfilesize'] = @filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
			// now we update the used space
			$userinfo['usedspace'] = $userinfo['usedspace'] - $imageinfo['originalfilesize'];
			modify_image($imageinfo['saveto'] . '/' . $imageinfo['originalname'], $imageinfo['originalwidth'], $imageinfo['originalheight'], $catoptions["$imageinfo[catid]"]['gallery_origquality']);
			clearstatcache();

			// we get the new filesize
			$imageinfo['originalfilesize'] = @filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
			$userinfo['usedspace'] += $imageinfo['originalfilesize'];

		}		

	}

	$imageinfo = resize_image($filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'], $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height'], 1);

	// Watermark Image
	if ($catoptions["$imageinfo[catid]"]['gallery_watermark'] AND $ppg_options['gallery_permwatermark'])
	{
		watermark_image('normal', true);
		clearstatcache();
		$imageinfo['filesize'] = @filesize($imageinfo['location']);

		if ($imageinfo['originalname'])
		{
			watermark_image('original', true);
			$imageinfo['originalfilesize'] = @filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
		}
	}

	if (!trim($imageinfo['title']))
	{
    $imageinfo['title'] = $imageinfo['shortname'];
	}

    $imageinfo['title'] = str_replace("_", " ", $imageinfo['title']);
    $imageinfo['title'] = ucwords(strtolower($imageinfo['title']));

	$valid = iif($categoryperms["$imageinfo[catid]"]['moderateimages'], 0, 1);

	if ($new)
	{
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_images (title, description, keywords, catid, dateline, userid, username, extension, filename, filesize, width, height, thumbname, originalname, originalfilesize, originalwidth, originalheight, valid, open, ipaddress) VALUES ('" . addslashes(htmlspecialchars($imageinfo['title'])) . "', '" . addslashes($imageinfo['description']) . "', '" . addslashes(htmlspecialchars($imageinfo['keywords'])) . "', '$imageinfo[catid]', '" . time() . "', '$userid', '" . addslashes($username) . "', '$imageinfo[extension]', '" . addslashes($imageinfo['saveas']) . "', '$imageinfo[filesize]', '$imageinfo[width]', '$imageinfo[height]', '" . addslashes($imageinfo['thumbname']) . "', '" . htmlspecialchars(addslashes($imageinfo['originalname'])) . "', '$imageinfo[originalfilesize]', '$imageinfo[originalwidth]', '$imageinfo[originalheight]', '$valid', 1, '" . addslashes(IPADDRESS) . "')");
                 
		$newimageid = $db->insert_id();

        //update ppgal_user table

            $db->query_write("
                UPDATE " . TABLE_PREFIX . "ppgal_user
                SET ppicount = ppicount+1, lastimageid=$newimageid, lastimagetitle='" . addslashes(htmlspecialchars($imageinfo['title'])) . "', lastimagedate='" . time() . "'
                WHERE userid = '$userid'");
       
        // EXIF
		if (!empty($exif))
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_exif (imageid, exifinfo) VALUES ('$newimageid', '" . iif($exif, addslashes(serialize($exif))) . "')");
		}

		if ($imageoptions['favorite'])
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_favorites (userid, imageid) VALUES ('" . $vbulletin->userinfo['userid'] . "', '$newimageid')");
		}

		if ($imageoptions['subscribe'])
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_subscribeimage (userid, imageid) VALUES ('" . $vbulletin->userinfo['userid'] . "', '$newimageid')");
		}

		construct_customfields_sql($customfields, $newimageid);

		if ($valid)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET imagecount = imagecount+1, lastimageid = '$newimageid', lastimageuserid = '$userid', lastimageusername = '" . addslashes($username) . "', lastimagetitle = '" . htmlspecialchars(addslashes($imageinfo['title'])) . "', lastimagedateline = '" . TIMENOW . "' WHERE catid = '$imageinfo[catid]'");
        }

        build_gallery_stats();
	}
	else
	{

// update last updated
			
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET filename = '$imageinfo[saveas]', dateline_mod = '" . TIMENOW . "', extension = '$imageinfo[extension]', filesize = '$imageinfo[filesize]', width = '$imageinfo[width]', height = '$imageinfo[height]', thumbname = '$imageinfo[thumbname]', originalname = '$imageinfo[originalname]', originalfilesize = '$imageinfo[originalfilesize]', originalwidth = '$imageinfo[originalwidth]', originalheight = '$imageinfo[originalheight]', valid = '$valid', ipaddress = '" . IPADDRESS . "' WHERE imageid  = '$imageinfo[imageid]'");
		if (!empty($exif))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_exif SET exifinfo = '" . addslashes(serialize($exif)) . "' WHERE imageid = '$imageinfo[imageid]'");
		}
	}
	@chmod($imageinfo['location'], 0777);

    ($hook = vBulletinHook::fetch_hook('ppgal_process_upload')) ? eval($hook) : false;

	return $newimageid;
}

// ######################## Fetch Random Image Name ###########################
function fetch_random_imagename($filename, $existsarray)
{
	$randfilename = substr($filename, 0, strrpos($filename, '.')) . '_' . rand(0, 999999) . '.' . substr($filename, strrpos($filename, '.') + 1);

	if (!in_array($randfilename, $existsarray))
	{
		return $randfilename;
	}
	else
	{
		fetch_random_imagename();
	}
}

// stripos() needed because stripos is only present on PHP 5
if (!function_exists('stripos')) {
	function stripos($haystack,$needle,$offset = 0) {
		return(strpos(strtolower($haystack),strtolower($needle),$offset));
	}
}

// ############################# Fetch Image Info #############################
function fetch_image_info($location, $filename, $adduser = false)
{
	global $db, $ppg_options, $imageinfo, $folderstring, $server, $vbulletin, $userid;

	$imginfo['truename'] = $filename;
    $ext =  substr($filename,strrpos($filename,".")+1);
    $name = preg_replace( "/\.\w+$/U", "", $filename );
    $name = preg_replace("/[^a-z_.0-9-]/i", " ", $name);
   // $name = ereg_replace( '  +', '', $name );
	$name= preg_replace("/(\s){2,}/",'$1',$name);
    $name = str_replace(" ", "_", trim($name));

    // oops filename is empty.
    if(trim($name) == ''){$name = md5(uniqid(rand()));}
	//Change from photoPost ends here

    $filename = strtolower($name.'.'.$ext);


	$existsarray = array();
	$checkfilename = $adduser ?  $userid . '-' . $filename : $filename;
    $exists = $db->query_read("
            SELECT filename, originalname, thumbname
            FROM " . TABLE_PREFIX . "ppgal_images
            WHERE userid = '$userid'
            AND (filename LIKE '" . addslashes($checkfilename) . "%'
            OR thumbname LIKE '" . addslashes($checkfilename) . "%'
            OR originalname LIKE '" . addslashes($checkfilename) . "%')
    ");
    while ($exist = $db->fetch_array($exists))
	{
		$existsarray[] = $exist['filename'];
		$existsarray[] = $exist['thumbname'];
		$existsarray[] = $exist['originalname'];
	}
	$db->free_result($exists);
	unset($exist);


	if (!empty($existsarray))
	{
		$imginfo['filename'] = fetch_random_imagename($filename, $existsarray);
	}
	else
	{
		$imginfo['filename'] = $filename;
	}

	if ($server['upload'] AND $imageinfo['filename'] != $imginfo['truename'])
	{
		$imginfo['truename'] = $imginfo['filename'];
		@rename($location, $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'] . '/' . $imginfo['filename']);
		$location = $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'] . '/' . $imginfo['filename'];
	}

	$imginfo['saveas'] = iif($adduser, $userid . '-') . $imginfo['filename'];
	$imginfo['location'] = $location;

	$imginfo['saveto'] = $folderstring;

	$imginfo['shortname'] = substr($imginfo['filename'], 0, strrpos($imginfo['filename'], '.'));

	$imginfo['extension'] = strtolower(substr($imginfo['filename'], strrpos($imginfo['filename'], '.') + 1));

	$imagedata = @getimagesize($imginfo['location']);
	$imginfo['width'] = $imagedata[0];
	$imginfo['height'] = $imagedata[1];
	$imginfo['numericaltype'] = $imagedata[2];
	$imginfo['filesize'] = @filesize($imginfo['location']);

	return array_merge((array)$imageinfo, (array)$imginfo);
}

// ##################### Fetch Category Extension Info ########################
function fetch_cat_ext_info()
{
	global $db, $imageinfo;

	$filetypes = array();
	$gettypes = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_filetypes WHERE enabled = 1");
	while ($types = $db->fetch_array($gettypes))
	{
		$filetypes["$types[extension]"] = $types;
	}

	$db->free_result($gettypes);
	unset($types);

	$catfiletypes	= array();
	$cattypes = $db->query_read("SELECT catid, disext FROM " . TABLE_PREFIX . "ppgal_categories");
	while ($ctypes = $db->fetch_array($cattypes))
	{
		$ftypes = unserialize($ctypes['disext']);
		$catfiletypes["$ctypes[catid]"] = $filetypes;

		if (!empty($ftypes))
		{
			foreach ($ftypes AS $ext => $values)
			{
				if (!$values['enabled'])
				{
					unset($catfiletypes["$ctypes[catid]"]["$ext"]);
				}
				else
				{
					$catfiletypes["$ctypes[catid]"]["$ext"] = $values;
				}
			}
		}
	}

	$db->free_result($cattypes);
	unset($ctypes);


	return $catfiletypes;
}

// ############################### Check Image Errors #########################
function check_upload_errors()
{
	global $imageinfo, $db, $ppg_options, $galleryperms, $userinfo, $filetypes, $imgtypearray, $categorycache, $catfiletypes, $categoryperms, $custominfo, $_POST;

	if (!isset($errors))
	{
		$errors = array();
	}

    // Build a list of valid file types.
    $tempfiletypes = $filetypes["$imageinfo[catid]"];
    if ($categorycache["$imageinfo[catid]"]['disext'])
    {
         foreach ($tempfiletypes AS $ext => $extinfo)
         {
              if (in_array($extinfo['extensionid'], explode(',', $categorycache["$imageinfo[catid]"]['disext'])))
              {
                   unset($tempfiletypes["$ext"]);
              }
         }
    }

    // Hard-coded restricted extensions
    $forbidden_extensions = array(
        '.htm','.html','.shtm','.shtml','.php',
        '.php3','.php4','.php5','.php6','.asp','.aspx','.jsp', '.jsx', '.psp','.pl',
        '.pm', '.chl','.dbm', '.ipm','.cgi','.stx','.cfm','.cfml','.cms','.ars','.htaccess','.htpasswd',
        '.bat','.exe','.reg','.dll','.ini','.cfg', '.vbs', '.vbe',  '.phtm', '.phtml', '.scr', '.bin', '.pif', '.js',
        '.eml', '.css', '.sys', '.ocx', '.com', '.rpm', '.cab', '.bz2', '.msi', '.msp', '.xml', '.vxd', '.key'
    );


    foreach ($forbidden_extensions AS $forbidden_extension)
    {
         if (stripos($imageinfo['filename'],$forbidden_extension) !== false)
         {
              eval('$errors[] = "' . substr($imageinfo['filename'], strpos($imageinfo['filename'], '.') + 1) . ' = ' . fetch_error('adv_gallery_invalid_extension', implode(', ', array_keys($tempfiletypes))) . '";');
         }
    }

	// No catid
	if (!$imageinfo['catid'])
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_must_choose_category') . '";');
	}

	if (!$categoryperms["$imageinfo[catid]"]['canuploadimages'])
	{
		print_no_permission();
	}
	//check if read policy was checked
	if(THIS_SCRIPT == 'gallery_upload' AND $ppg_options['upload_readpolicy'])
	{
		if($_POST['imageoptions']['policy'] != 1)
		{
			eval('$errors[] = "' . fetch_error('adv_gallery_policy_not_agreed') . '";');
		}
	}
	// Open for images?
	$catopts = construct_cat_opts($imageinfo['catid'], $categorycache["$imageinfo[catid]"]['options']);
	if (!$catopts['open_for_images'] AND $imageinfo['catid'])
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_categoryclosed') . '";');
	}

	// Filesize
	if ($filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['filesize'] AND $imageinfo['filesize'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['filesize'])
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_imagetoobig', $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['filesize']) . '";');
	}

	// Extensions
	if (!in_array($imageinfo['extension'], array_keys($filetypes["$imageinfo[catid]"])) OR strstr($imageinfo['saveas'], '..'))
	{
		$tempfiletypes = $filetypes["$imageinfo[catid]"];
		if ($categorycache["$imageinfo[catid]"]['disext'])
		{
			foreach ($tempfiletypes AS $ext => $extinfo)
			{
				if (in_array($extinfo['extensionid'], explode(',', $categorycache["$imageinfo[catid]"]['disext'])))
				{
					unset($tempfiletypes["$ext"]);
				}
			}
		}
		eval('$errors[] = "' . fetch_error('adv_gallery_invalid_extension', implode(', ', array_keys($tempfiletypes))) . '";');
	}

	if ((!in_array($imageinfo['numericaltype'], array(1,2,3)) OR $imageinfo['numericaltype'] == 1 AND (!function_exists('imagegif') OR !function_exists('imagecreatefromgif'))) AND in_array($ppg_options['gallery_resizemethod'], array('GD1', 'GD2')) AND ($imageinfo['width'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'] OR $imageinfo['height'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height']))
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_imagetoolarge', $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'], $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height']) . '";');
	}
    // Min size upload
    if (in_array($imageinfo['extension'], array_keys($imgtypearray)))
	{
    if ($imageinfo['width'] < $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['min_width'] OR $imageinfo['height'] < $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['min_height'])
    {
    	eval('$errors[] = "' . fetch_error('adv_gallery_imagetoosmall', $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['min_width'], $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['min_height']) . '";');
    }
    }
	// Illegal filetypes
	if (in_array($imageinfo['extension'], array_keys($imgtypearray)) AND $imgtypearray["$imageinfo[extension]"] != $imageinfo['numericaltype'] AND !in_array($imageinfo['numericaltype'], array(4,13)))
	{
		eval('$errors[] = "' . fetch_error('upload_invalid_file') . '";');
	}

	// Description
	if (vbstrlen($imageinfo['description']) > $ppg_options['gallery_desclimit'])
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_description_toolong', vb_number_format(vbstrlen($imageinfo['description'])), $ppg_options['gallery_desclimit']) . '";');
	}

	// Required custom fields
	if (!empty($custominfo))
	{
		foreach ($custominfo AS $profilefield)
		{
			if ($profilefield['required'] AND !$_POST["field$profilefield[fieldid]"])
			{
				eval('$errors[] = "' . addslashes(fetch_error('requiredfieldmissing', $profilefield['title'])) . '";');
			}
		}
	}

	return $errors;
}

// ############################### Check Edit Errors #########################
function check_edit_errors()
{
	global $image, $db, $ppg_options, $galleryperms, $userinfo, $filetypes, $imgtypearray, $categorycache, $catfiletypes, $categoryperms, $custominfo, $_POST;

	if (!isset($errors))
	{
		$errors = array();
	}

   
	// Description
	if (vbstrlen($image['description']) > $ppg_options['gallery_desclimit'])
	{
		
		eval('$errors[] = "' . fetch_error('adv_gallery_description_toolong', vb_number_format(vbstrlen($image['description'])), $ppg_options['gallery_desclimit']) . '";');
	}

	// Required custom fields
	if (!empty($custominfo))
	{
		foreach ($custominfo AS $profilefield)
		{
			if ($profilefield['required'] AND !$_POST["field$profilefield[fieldid]"])
			{
				eval('$errors[] = "' . addslashes(fetch_error('requiredfieldmissing', $profilefield['title'])) . '";');
			}
		}
	}

	return $errors;
}

// ############################## Watermark Image #############################
function watermark_image($type, $perm = false)
{
	global $imageinfo, $ppg_options, $imgtypearray, $catoptions;

	if (empty($catoptions["$imageinfo[catid]"]))
	{
		$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
	}

	switch ($type)
	{
		case 'original':
			$imglocation = $imageinfo['saveto'] . '/' . $imageinfo['originalname'];
			$imgheight = $imageinfo['originalheight'];
			$imgwidth = $imageinfo['originalwidth'];
			break;
		default:
			$imglocation = $imageinfo['location'];
			$imgheight = $imageinfo['height'];
			$imgwidth = $imageinfo['width'];
	}

	if (in_array($imageinfo['extension'], array_keys($imgtypearray)))
	{
		$logoinfo = @getimagesize($catoptions["$imageinfo[catid]"]['gallery_watermark']);
		$logo['width'] = $logoinfo[0];
		$logo['height'] = $logoinfo[1];
		$logo['extension'] = substr($catoptions["$imageinfo[catid]"]['gallery_watermark'], strrpos($catoptions["$imageinfo[catid]"]['gallery_watermark'], '.') + 1);

		switch ($catoptions["$imageinfo[catid]"]['gallery_watermark_location']{0})
		{
			case 'n':
				$placementy = 0;
				break;
			case 'm':
				$placementy = round(($imgheight - $logo['height']) / 2);
				break;
			default:
				$placementy = $imgheight - $logo['height'];
		}

		switch($catoptions["$imageinfo[catid]"]['gallery_watermark_location']{1})
		{
			case 'w':
				$placementx = 0;
				break;
			case 'c':
				$placementx = round(($imgwidth - $logo['width']) / 2);
				break;
			default:
				$placementx = $imgwidth - $logo['width'];
		}

		if (in_array($ppg_options['gallery_resizemethod'], array('GD1', 'GD2')) OR !$perm)
		{
			if ($imgwidth > $logo['width'] AND $imgheight > $logo['height'] AND in_array($imageinfo['extension'], array('jpg', 'jpeg', 'png')))
			{

				switch($imageinfo['extension'])
				{
					case 'jpg':
					case 'jpeg':
						$mainimage = @imagecreatefromjpeg($imglocation);
						break;
					case 'png':
						$mainimage = @imagecreatefrompng($imglocation);
						break;
				}

				@ImageAlphaBlending($mainimage, true);

                switch ($logo['extension'])
				{
					case 'jpg':
					case 'jpeg':
						$logoimage = @imagecreatefromjpeg($catoptions["$imageinfo[catid]"]['gallery_watermark']);
						break;

					case 'png':
						$logoimage = @imagecreatefrompng($catoptions["$imageinfo[catid]"]['gallery_watermark']);
						break;
					case 'gif':
						if(function_exists("imagecreatefromgif"))
						{
							$logoimage = @imagecreatefromgif($catoptions["$imageinfo[catid]"]['gallery_watermark']);
						}
						else
						{
							// we throw error.. in display image..
							// this will give broken image in gallery.. but in future (2.5).. there will be a link in ACP ==> test watermark..
							// this will call displayimage directly.. dummyimage + watermark... if you call displayimage directly you will see the error message...
							echo 'ERROR: Your server has no GIF support in GD library!!! ==> Enable Gif support in PHP or use *.png watermark file instead!';
							exit;
						}
						break;
				}

				@imagecopy($mainimage, $logoimage, $placementx, $placementy, 0, 0, $logo['width'], $logo['height']);

				switch ($imageinfo['extension'])
				{
					case 'jpg':
					case 'jpeg':
						if ($perm)
						{
							@imagejpeg($mainimage, $imglocation, 80);
						}
						else
						{
							@imagejpeg($mainimage, '', 80);
						}
						break;
					case 'png':
						if ($perm)
						{
							@imagepng($mainimage, $imglocation);
						}
						else
						{
							@imagepng($mainimage, '');
						}
						break;
				}

				@imagedestroy($mainimage);
				@imagedestroy($logoimage);
			}
		}
		else
		{
			$IMcommand = '"' . $ppg_options['gallery_programpath'] . 'composite" -gravity northwest -geometry +' . $placementx . '+' . $placementy . ' ' . $catoptions["$imageinfo[catid]"]['gallery_watermark'] . ' ' . $imglocation . ' ' . $imglocation;

			@system($IMcommand, $IMerror);
		}
	}
}


function rotateImage($img, $rotation) {
  $width = imagesx($img);
  $height = imagesy($img);
  switch($rotation) {
    case 90: $newimg= @imagecreatetruecolor($height , $width );break;
    case 180: $newimg= @imagecreatetruecolor($width , $height );break;
    case 270: $newimg= @imagecreatetruecolor($height , $width );break;
    case 0: return $img;break;
    case 360: return $img;break;
  }
  if($newimg) {
    for($i = 0;$i < $width ; $i++) {
      for($j = 0;$j < $height ; $j++) {
        $reference = imagecolorat($img,$i,$j);
        switch($rotation) {
          case 90: if(!@imagesetpixel($newimg, ($height - 1) - $j, $i, $reference )){return false;}break;
          case 180: if(!@imagesetpixel($newimg, $width - $i, ($height - 1) - $j, $reference )){return false;}break;
          case 270: if(!@imagesetpixel($newimg, $j, $width - $i, $reference )){return false;}break;
        }
      }
    } return $newimg;
  }
  return false;
}

// ############################### Rotate Image ###############################
function rotate_image($imageinfo, $angle)
{
    global $ppg_options, $folderstring;

    $angle = 360 - $angle;

	$imgarray = array();
	if ($imageinfo['originalname'])
	{
		$imgarray[] = $imageinfo['originalname'];
	}
	$imgarray[] = $imageinfo['filename'];
	if ($imageinfo['thumbname'])
	{
		$imgarray[] = $imageinfo['thumbname'];
	}

	
	foreach ($imgarray AS $imagelocation)
	{
		$imagelocation = $folderstring . '/' . $imagelocation;
		switch ($ppg_options['gallery_resizemethod'])
		{
			case 'GD1':
			case 'GD2':

            // get the imagetype
            $imagedata = @getimagesize($imagelocation);
            $imageinfo['numericaltype'] = $imagedata[2];
            switch ($imageinfo['numericaltype'])
            {
                // JPG Image
                case 2:
				$tempimage = @imagecreatefromjpeg($imagelocation);

				//$tempimage = rotateImage($tempimage,$angle);
				
				$tempimage = @imagerotate($tempimage, $angle, 0);

				@imagejpeg($tempimage, $imagelocation, -1);
				@imagedestroy($tempimage);
				break;
                // PNG Image
                case 3:
                $tempimage = @imagecreatefrompng($imagelocation);
                $tempimage = @imagerotate($tempimage, $angle, 0);
                @imagepng($tempimage, $imagelocation);
                @imagedestroy($tempimage);
                break;
                // Gif Image
                case 1:
                $tempimage = @imagecreatefromgif($imagelocation);
                $tempimage = @imagerotate($tempimage, $angle, 0);
                @imagegif($tempimage, $imagelocation);
                @imagedestroy($tempimage);
                break;
            }
            @chmod($imagelocation, 0777);
            break;


			case 'IM':

				$IMcommand = '"' . $ppg_options['gallery_programpath'] . 'convert" -rotate ' . $angle . ' ' . $imagelocation . ' ' . $imagelocation;
				@system($IMcommand, $retval);
		}
	}
}

// ############################## Flip Image ##################################
function flip_image($imageinfo)
{
	global $flip, $ppg_options, $folderstring;

	$imgarray = array();

	$imgarray[] = $imageinfo['filename'];
	if ($imageinfo['thumbname'])
	{
		$imgarray[] = $imageinfo['thumbname'];
	}
	if ($imageinfo['originalname'])
	{
		$imgarray[] = $imageinfo['originalname'];
	}

	foreach ($imgarray AS $imglocation)
	{
		$imglocation = $folderstring . '/' . $imglocation;
	if (sizeof($flip) == 2)
		{
			$flipit = 'both';
		}
		else if (implode(',', $flip) == 'horizontal')
		{
			$flipit = 'flop';
		}
		else
		{
			$flipit = 'flip';
		}

		switch ($ppg_options['gallery_resizemethod'])
		{
			case 'GD1':
			case 'GD2':

                $imagedata = @getimagesize($imglocation);
                $imageinfo['numericaltype'] = $imagedata[2];
                switch ($imageinfo['numericaltype'])
                {
                    // JPG Image
                    case 2:
                        $imgsrc = @imagecreatefromjpeg($imglocation);
                        break;
                        // PNG Image
                    case 3:
						// TODO add support for alphastransparency !!!!!!
                        $imgsrc = @imagecreatefrompng($imglocation);
                        break;
                        // Gif Image
                    case 1:
                        $imgsrc = @imagecreatefromgif($imglocation);
                        break;
                }
                $width = @imagesx($imgsrc);
                $height = @imagesy($imgsrc);
                $imgdest = @imagecreatetruecolor($width, $height);
				for ($x = 0; $x < $width; $x++)
				{
					for ($y = 0 ; $y < $height; $y++)
					{
						switch ($flipit)
						{
							case 'flop':
                                @imagecopy($imgdest, $imgsrc, $width-$x-1, $y, $x, $y, 1, 1);
								break;
							case 'flip':
                                @imagecopy($imgdest, $imgsrc, $x, $height-$y-1, $x, $y, 1, 1);
								break;
							case 'both':
                                @imagecopy($imgdest, $imgsrc, $width-$x-1, $height-$y-1, $x, $y, 1, 1);
								break;
						}
					}
				}
                switch ($imageinfo['numericaltype'])
                {
                    // JPG Image
                    case 2:
                        @imagejpeg($imgdest, $imglocation, -1);
                        break;
                        // PNG Image
                    case 3:
                        @imagepng($imgdest, $imglocation);
                        break;
                        // Gif Image
                    case 1:
                        @imagegif($imgdest, $imglocation);
                        break;
                }
                @chmod($imglocation, 0777);
                @imagedestroy($imgsrc);
                @imagedestroy($imgdest);
				break;

			case 'IM':
				$IMcommand = '"' . $ppg_options['gallery_programpath'] . 'convert" ' . iif($flipit == 'both', '-flip -flop', '-' . $flipit) . ' ' . $imglocation . ' ' . $imglocation;
				@system($IMcommand, $retval);
		}
	}
}

// ########################### Construct Folder Path ##########################
function construct_folder_path()
{
	global $ppg_options, $userid, $vbulletin;

	if ($ppg_options['gallery_insafemode'])
	{
		return $ppg_options['gallery_filedirectory'];
	}

	$folders = preg_split('//', $userid, -1, PREG_SPLIT_NO_EMPTY);

	$folderstring = $ppg_options['gallery_filedirectory'];

	foreach ($folders AS $uid)
	{
		$folderstring .= '/' . $uid;
		if (!is_dir($folderstring))
		{
			@mkdir($folderstring, 0777);
			@chmod($folderstring, 0777);

			if ($fp = @fopen($folderstring . '/index.html', "w"))
			{
				@fputs ($fp, '');
				@fclose($fp);
			}
			else
			{
				eval(standard_error(fetch_error('adv_gallery_problem_creating_folder', $vbulletin->options['contactuslink'])));
			}
		}
	}
	return $folderstring;
}

// ######################## Fetch Advanced Cat Settings #######################
function fetch_adv_category_setting($catid)
{
	global $db, $ppg_options, $adv_category_options;

	$catoptions = array();
	$adv_options = $db->query_first("SELECT adv_setting FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid'");
	$adv_options = unserialize($adv_options['adv_setting']);

	foreach ($adv_category_options AS $varname)
	{
        $catoptions["$varname"] = $ppg_options["$varname"];
    }

    if (is_array($adv_options))
    {
        $catoptions = array_merge((array)$catoptions, (array)$adv_options);
	}

	return $catoptions;
}

?>