<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: functions_gallery_crop.php                                       ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/


/* ######################  editimages CROP TOOL ############################*/
// This will only work inside of editimage
if(THIS_SCRIPT != 'editimage'){exit;}
$catoptions["$image[catid]"] = fetch_adv_category_setting($image['catid']);
$folderstring = fetch_folder_path($imageinfo);

if($ppg_options['gallery_resizemethod'] == 'GD2' OR $ppg_options['gallery_resizemethod'] == 'GD1')
{

	if(intval($catoptions["$image[catid]"]['gallery_thumbsize'])>1)
	{
		$thumbnail_width = $catoptions["$imageinfo[catid]"]['gallery_thumbsize'];
		$thumbnail_height = $catoptions["$imageinfo[catid]"]['gallery_thumbsize'];
	}
	else
	{
		$thumbnail_width = $ppg_options['gallery_thumbsize'];
		$thumbnail_height = $ppg_options['gallery_thumbsize'];
	}
			

	$landscape = false;
			
	if( ($imageinfo['originalname']) AND (($imageinfo['originalwidth'] > 0) AND ($imageinfo['originalheight'] > 0)) )
	{
		//make thumb from original
		$src_pic = $folderstring . '/' . $imageinfo['originalname'];
		$pic_width = $imageinfo['originalwidth'];
		$pic_height = $imageinfo['originalheight'];		
						
	}
	else
	{
		// make thumb from intermediate
		$src_pic = $folderstring . '/' . $imageinfo['filename'];
		$pic_width = $imageinfo['width'];
		$pic_height = $imageinfo['height'];
	}

	if ($pic_width > $pic_height)
	{
		$landscape = true;
		if(!$imageinfo['cropid'])
		{
			$imageinfo['cropid'] = 2;
		}
	}
	else
	{
		if(!$imageinfo['cropid'])
		{
			if($ppg_options['gallery_autocrop'])
			{
				$imageinfo['cropid'] = 1;
			}
			else
			{
				$imageinfo['cropid'] = 2;
			}
		}
	}
	if($landscape)
	{
		$pseudo_pic_width = $pic_height;
		$pseudo_pic_height = $pic_height;
		$a = 0;
		$b = 0;
		$x = round(($pic_width-$pseudo_pic_height)/2);
		switch ($imageinfo['cropid'])
		{
			case 1:
				$x = 0;
				break;
			case 2:
				$x = round(($pic_width-$pseudo_pic_height)/2);
				break;
			case 3:
				$x = $pic_width-$pseudo_pic_height;
				break;
		}
		$y = 0;
	}
	else
	{
		$pseudo_pic_width = $pic_width;
		$pseudo_pic_height = $pic_width;
		$a = 0;
		$b = 0;
		$x = 0;
		switch ($imageinfo['cropid'])
		{
			case 1:
				$y = 0;
				break;
			case 2:
				$y = round(($pic_height-$pseudo_pic_width)/2);
				break;
			case 3:
				$y = $pic_height - $pseudo_pic_width;
				break;
		}

	}

	$resize_function = 'imagecopyresampled'; // we only have gd2
	$savepath = $folderstring . '/' . $imageinfo['thumbname'];
	switch (strtolower($imageinfo['extension']))
	{
		// Gif Image $im = @ImageCreateFromGIF ($imgname);
		case 'gif':
			$src_img =  @ImageCreateFromGIF($src_pic);
			$dst_img = @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
			@imagecopyresampled($dst_img, $src_img, $a, $b, $x, $y, $thumbnail_width, $thumbnail_height, $pseudo_pic_width, $pseudo_pic_height);
			if($ppg_options['gallery_sharpenthumbs'] == 1)
			{
				require_once(DIR . '/includes/vbgallery/xba_unsharp_mask.php');
				$dst_img = sharpen($dst_img, 6);
			}
			@imageGif($dst_img, $savepath);

			break;
		// JPG Image
		case 'jpeg':
		case 'jpg':

			$quality = $catoptions["$image[catid]"]['gallery_thumbquality'];
			if($quality)
			{
				if($quality != -1)
				{
					if ($quality > 0 AND $quality < 20)
					{
						$quality = 20;
					}
					if($quality > 90)
					{
						$quality = 90;			
					}
				}
			}
			else
			{
				$quality = -1;
			}
			$src_img = @imagecreatefromjpeg($src_pic);
			$dst_img = @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
			@imagecopyresampled($dst_img, $src_img, $a, $b, $x, $y, $thumbnail_width, $thumbnail_height, $pseudo_pic_width, $pseudo_pic_height);
			if($ppg_options['gallery_sharpenthumbs'] == 1)
			{
				require_once(DIR . '/includes/vbgallery/xba_unsharp_mask.php');
				$dst_img = sharpen($dst_img, 6);
			}
			@imagejpeg($dst_img, $savepath, $quality);

			break;
		// PNG Image
		case 'png':
			$src_img = @imagecreatefrompng($src_pic);
			$dst_img = @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
			@imagecopyresampled($dst_img, $src_img, $a, $b, $x, $y, $thumbnail_width, $thumbnail_height, $pseudo_pic_width, $pseudo_pic_height);
			if($ppg_options['gallery_sharpenthumbs'] == 1)
			{
				require_once(DIR . '/includes/vbgallery/xba_unsharp_mask.php');
				$dst_img = sharpen($dst_img, 6);
			}
			@imagepng($dst_img, $savepath);
			break;
		default:
			$quality = $catoptions["$image[catid]"]['gallery_thumbquality'];
			if($quality)
			{
				if($quality != -1)
				{
					if ($quality > 0 AND $quality < 20)
					{
						$quality = 20;
					}
					if($quality > 90)
					{
						$quality = 90;			
					}
				}
			}
			else
			{
				$quality = -1;
			}
			$src_img = @imagecreatefromjpeg($src_pic);
			$dst_img = @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
			@imagecopyresampled($dst_img, $src_img, $a, $b, $x, $y, $thumbnail_width, $thumbnail_height, $pseudo_pic_width, $pseudo_pic_height);
			if($ppg_options['sharpen'] == 1)
			{
				
				$dst_img = sharpen($dst_img, $ppg_options['sharpen_thumb']);
			}							
			@imagejpeg($dst_img, $savepath, $quality);
	}
	@chmod($savepath, 0777);
	@imagedestroy($src_img);
	@imagedestroy($dst_img);	

}
else if($ppg_options['gallery_resizemethod'] == 'IM')
{

	if(intval($catoptions["$image[catid]"]['gallery_thumbsize'])>1)
	{
		$thumbnail_width = $catoptions["$imageinfo[catid]"]['gallery_thumbsize'];
		$thumbnail_height = $catoptions["$imageinfo[catid]"]['gallery_thumbsize'];
	}
	else
	{
		$thumbnail_width = $ppg_options['gallery_thumbsize'];
		$thumbnail_height = $ppg_options['gallery_thumbsize'];
	}
	if($thumbnail_width > $thumbnail_height)
	{
		$thumbnail_size = $thumbnail_width;
	}
	else
	{
		$thumbnail_size = $thumbnail_height;
	}

	$landscape = false;
			
	// the file exist is not sufficiant, because if originalname is empty.. the file still exists..for php (as the directory exitst)

	if( ($imageinfo['originalname']) AND (($imageinfo['originalwidth'] > 0) AND ($imageinfo['originalheight'] > 0)) )
	{
		//make thumb from original
		$src_pic = 	$folderstring . '/' . $imageinfo['originalname'];
		$pic_width = $imageinfo['originalwidth'];
		$pic_height = $imageinfo['originalheight'];		
						
	}
	else
	{
		// make thumb from intermediate
		$src_pic = $folderstring . '/' . $imageinfo['filename'];
		$pic_width = $imageinfo['width'];
		$pic_height = $imageinfo['height'];
	}

	if ($pic_width > $pic_height)
	{
		$landscape = true;
		if(!$imageinfo['cropid'])
		{
			$imageinfo['cropid'] = 2;
		}
	}
	else
	{
		if(!$imageinfo['cropid'])
		{
			if($ppg_options['gallery_autocrop'])
			{
				$imageinfo['cropid'] = 1;
			}
			else
			{
				$imageinfo['cropid'] = 2;
			}
		}
	}

	$thumbRatio = 1; // square
	$inRatio = $pic_width/$pic_height;   
	$isLandscape = $inRatio > $thumbRatio;   
	$size = ($isLandscape ? '1000x' . $thumbnail_size : $thumbnail_size . 'x1000');
	if($isLandscape)
	{
		$yoff = 0;
		$x = round($thumbnail_size / ($pic_height/$pic_width));
		switch ($imageinfo['cropid'])
		{
			case 1:
				$xoff = 0;
				break;
			case 2:
				$xoff = round(($x - $thumbnail_size)/2);
				break;
			case 3:
				$xoff = $x - $thumbnail_size;
				break;
			default:
				$xoff = round(($x - $thumbnail_size)/2);
		}
	}
	else
	{
		$xoff = 0;
		$y = round($thumbnail_size / ($pic_width/$pic_height));
		switch ($imageinfo['cropid'])
		{
			case 1:
				$yoff = 0;
				break;
			case 2:
				$yoff = round(($y - $thumbnail_size)/2);
				break;
			case 3:
				$yoff = $y - $thumbnail_size;
				break;
			default:
				$yoff = round(($y - $thumbnail_size)/2);
		}
	}

	$quality = $catoptions["$imageinfo[catid]"]['gallery_thumbquality'];
	if($quality)
	{
		if ($quality == -1)
		{
			$quality = '';
		}
		else if ($quality < 20)
		{
			$quality = 20;
		}
		else if($quality > 90)
		{
			$quality = 90;			
		}
	}
	else
	{
		$quality = '';	
	}


	// we sharpen only jpgs
	$sharpen = ((strtolower($imageinfo['extension']) == 'jpg' OR strtolower($imageinfo['extension']) == 'jpeg') AND $ppg_options['gallery_sharpenthumbs']) ? " -sharpen 0x1 " : '';



	$savepath = $folderstring . '/' . $imageinfo['thumbname'];

	// added pdf for future use... ^^
	$IMcommand = '"' . $ppg_options['gallery_programpath'] . 'convert" ' . $src_pic . iif(($imageinfo['extension'] == 'gif' OR $imageinfo['extension'] == 'pdf'), '[0]') . ' -thumbnail ' . $size . ' -crop ' . $thumbnail_size . 'x' . $thumbnail_size . '+' . $xoff . '+'. $yoff . ' -colorspace RGB -strip ' . $sharpen . iif(($quality != ''), ' -quality ' . $quality) . ' ' . $savepath;

	exec($IMcommand);

	if (!in_array($IMerror, array(0, 1)))
	{
		//@unlink($imageinfo['location']);
		eval(standard_error(fetch_error('adv_gallery_im_error', $vbulletin->options['contactuslink'], $IMerror, $IMcommand)));
	}

}



?>