<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: functions_gallery.php                                            ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
// #################### DEFINE IMPORTANT CONSTANTS #######################
define('LOCATION_BYPASS', 1);
//if(!defined('THIS_SCRIPT')){exit;}
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = $specialtemplates = $globaltemplates = $actiontemplates = array();

/* get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array(); */


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ###################### Global Stuff #########################
($hook = vBulletinHook::fetch_hook('ppgal_func_start')) ? eval($hook) : false;

// Category Options
$categoryopts = array(
'open_for_images'        => 1,
'open_for_posts'         => 2,
'allow_post_html'        => 4,
'allow_post_bbcode'      => 8,
'allow_post_smilies'     => 16,
'allow_post_icons'       => 32,
'allow_post_bbimgcode'   => 64,
'allow_post_icons'       => 128,
'allow_custom_html'      => 256,
'allow_custom_bbcode'    => 512,
'allow_custom_smilies'   => 1024,
'allow_custom_bbimgcode' => 2048,
'allow_desc_html'        => 4096,
'allow_desc_bbcode'      => 8192,
'allow_desc_smilies'     => 16384,
'allow_desc_icons'       => 32768,
'allow_desc_bbimgcode'   => 65536,
'canhavepassword'        => 131072,
'childpass'              => 262144,
'allow_ratings'          => 524288,
'allow_replies'          => 1048576,
'allow_desc_links'       => 2097152,
'allow_custom_links'     => 4194304
);

// User Category Options
$catuseropts = array(
'allow_view'   => 1,
'allow_upload' => 2,
'allow_reply'  => 4,
'allow_rating' => 8
);

// Image Type Array
$imgtypearray = array(
'gif'	=> 1,
'jpg'	=> 2,
'png'	=> 3,
'swf'	=> 4,
'psd'	=> 5,
'bmp'	=> 6,
'tiff'  => 7,
'tiff'  => 8,
'jpc'   => 9,
'jp2'   => 10,
'jpx'   => 11,
'jb2'   => 12,
'swc'   => 13,
'iff'   => 14,
'wbmp'  => 15,
'xbm'   => 16
);

$adv_category_options = array(
'gallery_watermark',
'gallery_watermark_location',
'gallery_thumbsize',
'gallery_saveoriginal',
'gallery_thumbquality',
'gallery_origquality',
'gallery_uploadpostcount'
);

$gallerypermissionsbit = array(
	'canviewgallery'	 			=> 1,
	'canviewimages' 				=> 2,
	'moderateimages' 				=> 4,
	'moderateposts' 				=> 8,
	'cansearchimages' 			    => 16,
	'cansendimagetofriend' 	        => 32,
	'caneditimages' 				=> 64,
	'caneditothersimages' 	        => 128,
	'candelete' 					=> 256,
	'candeleteothers' 			    => 512,
	'canviewreplies' 				=> 1024,
	'canreplytoimages' 			    => 4096,
	'caneditposts' 					=> 2048,
	'caneditothersposts' 		    => 8192,
	'candeleteposts' 				=> 16384,
	'candeleteothersposts' 	        => 32768,
	'canrateimages' 				=> 65536,
	'canuploadimages'				=> 131072,
	'canuploadfromserver'		    => 262144,
	'cancreatecategories'		    => 524288,
	'canuploadasuser'				=> 1048576,
	'canviewlargimage'			    => 2097152,
	'cansendecard'					=> 4194304,
	'canvieworiginal'				=> 8388608,
	'canchangprofile'               => 16777216,
	'canviewprofiletab'             => 33554432,
	'canviewprofileblock'           => 67108864,
	'canviewforumhomeblock'         => 134217728,
	'canusemultiedit'				=> 268435456
);

// #############################################################################
/**
* Gets memory usage for upload 
*/
function getServMemory()
{
	$MB = 1048576;  // number of bytes in 1M
	$K64 = 65536;    // number of bytes in 64K
	$TWEAKFACTOR = 1.8;  // Or whatever works for you  it should work with 1.67 ... but 1.7 or 1.8 is safer.. depending on server settings
	if ($memoryLimit = @ini_get('memory_limit') AND $memoryLimit != -1)
	{
		$memoryLimit = @ini_get('memory_limit'); // we could leave this blank... i think
		$memoryLimit = vb_number_format( $memoryLimit, 0, false, null, '');
                    
	}
	else
	{
		$memoryLimit = 8 * $MB;
	}
	if (function_exists('memory_get_usage') && memory_get_usage())
	{
		// used memory
		$usedmem = memory_get_usage();

	}
	else
	{
		// we assume a user needs 7 MB... I have 4.4 average for vb3.84 and 6.8 in 4.01 (depends on products and plugins installed)
		$usedmem = 7*$MB;
	}


		$memoryNeeded = round( ( $tmpimgInfo[0] * $tmpimgInfo[1]
						* $tmpimgInfo['bits']
						* $tmpimgInfo['channels'] / 8
						+ $K64
							) * $TWEAKFACTOR
					);



}

// #############################################################################
/**
* Gets memory usage for upload file and spits out parameters for verbose error
*
* @param	string	Uploaded file

*/
function getMemoryForImage($tmp_file, $i=0)
{
	$MB = 1048576;  // number of bytes in 1M
	$K64 = 65536;    // number of bytes in 64K
	$TWEAKFACTOR = 1.8;  // Or whatever works for you  it should work with 1.67 ... but 1.7 or 1.8 is safer.. depending on server settings

	$tmpimgInfo = @getimagesize($tmp_file);
	if ($memoryLimit = @ini_get('memory_limit') AND $memoryLimit != -1)
	{
		$memoryLimit = @ini_get('memory_limit'); // we could leave this blank... i think
		$memoryLimit = vb_number_format( $memoryLimit, 0, false, null, '');
                    
	}
	else
	{
		$memoryLimit = 8 * $MB;
	}

	// we suppose png uses max channels =>3

	if(!$tmpimgInfo['channels'])
	{
		$tmpimgInfo['channels'] = 3;
	}

	$memoryNeeded = round( ( $tmpimgInfo[0] * $tmpimgInfo[1]
						* $tmpimgInfo['bits']
						* $tmpimgInfo['channels'] / 8
						+ $K64
							) * $TWEAKFACTOR
					);

	if (function_exists('memory_get_usage') && memory_get_usage())
	{
		// used memory
		$usedmem = memory_get_usage();

	}
	else
	{
		// we assume a user needs 7 MB... I have 4.4 average for vb3.84 and 6.8 in 4.01 (depends on products and plugins installed)
		$usedmem = 7*$MB;
	}
	if($i>0)
	{
		$usedmem = 0;
	}
	$memoryNeeded = $memoryNeeded+$usedmem;
	if($memoryNeeded>$memoryLimit)
	{
		//calculate image size factor...
		$factor = ((($memoryNeeded/$TWEAKFACTOR)-$K64)/($tmpimgInfo['channels'] / 8))/ $tmpimgInfo['bits'];
                                    
		$newfactor = ((($memoryLimit/$TWEAKFACTOR)-$K64)/($tmpimgInfo['channels'] / 8))/ $tmpimgInfo['bits'];
		$realfactor = $newfactor/$factor;
                    
		$newwidth =  $tmpimgInfo[0]* $realfactor;
		$newheight =  $tmpimgInfo[1]* $realfactor;
		$newwidthpercent = 10*($newwidth/100);
		$newheightpercent = 10*($newheight/100);

		$newwidth =  floor(($newwidth-$newwidthpercent)-1);
		$newheight =  floor(($newheight-$newheightpercent)-1);
		return array(true, $memoryNeeded, $memoryLimit, $tmpimgInfo[0], $tmpimgInfo[1], $newwidth, $newheight);
	}
	else
	{
		return array(false, $memoryNeeded, $memoryLimit, $tmpimgInfo[0], $tmpimgInfo[1], $newwidth, $newheight);

	}    
}



// #############################################################################
/**
* Halts execution and redirects to the specified URL invisibly and adds a jumpmark
*
* @param	string	Destination URL
* @param	string	Jump Anchor
*/
function exec_header_redirect_jump($url, $anchor='comments', $redirectcode = 302)
{
	global $vbulletin;

	$url = create_full_url($url);

	$url = str_replace('&amp;', '&', $url); // prevent possible oddity
	
	$url = $url . '#' . $anchor;

	if (strpos($url, "\r\n") !== false)
	{
		trigger_error("Header may not contain more than a single header, new line detected.", E_USER_ERROR);
	}

	header("Location: $url", 0, $redirectcode);

	if ($vbulletin->options['addheaders'] AND (SAPI_NAME == 'cgi' OR SAPI_NAME == 'cgi-fcgi'))
	{
		// see #24779
		switch($redirectcode)
		{
			case 301:
				header('Status: 301 Moved Permanently');
			case 302:
				header('Status: 302 Found');
				break;
		}
	}

	define('NOPMPOPUP', 1);
	if (defined('NOSHUTDOWNFUNC'))
	{
		exec_shut_down();
	}
	exit;
}
// ################ Gallery Announcement ##################
function gallery_head()
{
	global $vbulletin, $ppg_options, $catid, $imageid;
	// construct needed stuff js and css
	// save ressources and add constants here
	// javascript
	$cr = "\n";
	$addjs = '<script type="text/javascript">' . $cr . '<!--' . $cr;
	$addjs .= "	var imageid='" . intval($imageid) . "';" . $cr;
	$addjs .= "	var pageid='" . THIS_SCRIPT . "';" . $cr;
	$addjs .= "	var catid='" . intval($catid) . "';" . $cr;
	$addjs .= "	var GALLERY_URL='" . $ppg_options['gallery_url'] . "';" . $cr;
	$addjs .= '// -->' . $cr . '</script>' . $cr;
	// css we add here image backgrounds that cannot be added in stylesheets (Pathproblems)
	$addcss = '';
	if(!$ppg_options['layout_square_thumbs'])
	{
		// css for vertical align imagebit
		$addcss = '<style type="text/css" id="vbgallery_css">' . $cr;
		/*####### this is for vertical align middle for the imagebit #####*/
		
		// when border is set in acp... we will have
		// ($ppg_options['gallery_thumbsize'])+(2*$ppg_options['layout_imgbordersize'])+ 12;
		// ($ppg_options['gallery_thumbsize'])+(2*$ppg_options['layout_imgbordersize'])-2;
		//$addcss .= '.vgbimgbit { height:'. ($ppg_options['gallery_thumbsize']+12) .'px;line-height:'.$ppg_options['gallery_thumbsize']+10.'px;}' . $cr;
		/* BORDERSIZE WILL BE SET IN STYLEVAR !!!!*/
		
		$addcss .= '.vgbimgbit, .vgbimgbit_alt, .extra_img { height:'. ($ppg_options['gallery_thumbsize']+16) . 'px;line-height:' . ($ppg_options['gallery_thumbsize']+14) . 'px;}' . $cr;
	
		//	$addcss .= '#pagetitle a.gal_arrow_up {background: transparent url(' . $vbulletin->stylevars[$imgdirs['imgdir_statusicon']]['imagedir'] . '/arrow_left_40a.png) center 2px no-repeat;}' . $cr;
		$addcss .= '</style>' . $cr;
	}

	$addcss .= '<!--[if lt IE 8]>' . $cr;
	$addcss .= '<style type="text/css" id="bigimage_css">
	.vbgbigimg{
		padding:' . $vbulletin->stylevars['padding']['size'] . $vbulletin->stylevars['padding']['units'] . ';
		border:1px solid ' . $vbulletin->stylevars['lightweightbox_border']['color'] . ';
		background: ' . $vbulletin->stylevars['lightweightbox_background']['color'] . ' url(' . $ppg_options['gallery_url'] . '/images/misc/bglogo.png) center center no-repeat;
	}
	#infoblock li dl, #cam_info li dl, #cam_info ul li, .mbox{
		zoom:1;
	}

</style>' . $cr;
	$addcss .= '<![endif]-->' . $cr;

		$addcss .= '<!--[if lt IE 7]>' . $cr;
		$addcss .= '<style type="text/css" id="ie6_css">
	#cam_info .ovfwrap{
		height:150px;
	}
	.body_wrapper, #announcetxt p,#gal_announcement {
		zoom:1;
	}
	#sidebar_button_link{
		display:none;
	}


</style>' . $cr;
		$addcss .= '<![endif]-->' . $cr;

	return $cr . $addcss . $addjs;
}

// ########## array sort function ##########
function SortByDate_desc(&$a, &$b)
{
	if ($a['dateline'] == $b['dateline']) return 0;
	return ($a['dateline'] > $b['dateline']) ? -1 : 1;
}
// ########## check if file has extension and return it ##########
function get_ext( $filename )
{
	$pos = strrpos($filename, ".");
	if ($pos !== false)
	{ 
		return substr( $filename, $pos);
	}
	else
	{
		return false;
	}
}
// ################ Lite Errors for popups ##################
function vbglite_error()
{
	global $vbulletin, $footer, $header;
	$footer='';
	$header='';
	$vbulletin->templatecache['navbar'] = '';
}
// ################ Remove last comma for keywords ##################
function remove_last_comma($string='')
{
	if($string=='')
	{
		return $string;
	}

	if (function_exists('mb_strrpos'))
	{
		// no charset, is deprecated!
		$lastcomma = @mb_strrpos($string, ",");
	}
	else
	{
		$lastcomma = strrpos($string, ",");
	}
    


    $string = vbchop($string, $lastcomma);

	return $string;

}
// ################ Gallery Metatags ##################
function construct_metatags($headinclude, $metakw='',$metadc='')
{
	global $vbphrase, $ppg_options;
	global $thumburl, $thumbtitle;

	/* ### Set simple metatags #### */
	$globalkw = $ppg_options['gallery_title'] .',' . $vbphrase['gallery']; 
	$globaldesc =  construct_phrase($vbphrase['welcome_to_the_x'], $ppg_options['gallery_title']) . ' '; 
	switch(THIS_SCRIPT)
	{
		case 'gallery_index':
			$metakeyw =  $globalkw . $metakw;
			$metadesc = $globaldesc . $metadc;
			break;
		case 'showimage':
			$metakeyw =   $metakw . ' ' . $ppg_options['gallery_title'] .' ' . $vbphrase['gallery']; 
			$metadesc = $metadc . '. '. $globaldesc;

			break;
		case 'browseimages':
		$metakeyw =  $metakw . ' ' . $globalkw;
		$metadesc = $globaldesc . $metadc;

			break;
		case 'gallery_upload':
			$globalkw .= ' ' . $vbphrase['upload_image'];
			$globaldesc .= (!empty($vbphrase['upload_image_page_desc']))? ' - ' . $vbphrase['upload_image_page_desc'] : ' - ' . $vbphrase['upload_image'];
			$metakeyw =  $globalkw . $metakw;
			$metadesc = $globaldesc . $metadc;
			break;
		default:
		$metakeyw =  $globalkw;
		$metadesc = $globaldesc;		
	}
	
	($hook = vBulletinHook::fetch_hook('ppgal_misc_do_metatags')) ? eval($hook) : false;
	
	//clean metatags
	// remove conflicts with doublequotes in metatags
	// metakeyw first
	
	$metakeyw = vbstrtolower($metakeyw);

	$metakeyw = str_replace(array(',', '-'), array(' ', ''), $metakeyw);
	$metakeyw = str_replace(array(chr(10),chr(13),"\n","\cr","\t"), " ",  $metakeyw);
	$metakeyw = str_replace("  ", " ", $metakeyw);


	$metakeyw = explode(' ', $metakeyw);
	$cleankw = array();

	foreach($metakeyw AS $keyw)
	{
		$keyw = trim($keyw);
		if(vbstrlen($keyw)>3 AND !is_numeric($keyw))
		{
			$cleankw[] = $keyw;
		}
	}
	
	$metakeyw = array_unique($cleankw);

	$metakeyw = implode(",", $metakeyw);

	$metakeyw = unhtmlspecialchars($metakeyw);
	$metadesc = unhtmlspecialchars($metadesc);
	$metakeyw = str_replace(',,', ',', $metakeyw);
	$metakeyw = str_replace(array('&rsquo;', '&lsquo;', '&quot;', "'", '"', '<', '>','.','!','&amp;','&',';'), '', $metakeyw);
	$metakeyw = unhtmlspecialchars($metakeyw);
	$metadesc = str_replace(array('&quot;','"'), "'", $metadesc);
	$metadesc = str_replace('&amp;', " + ", $metadesc);
	$metadesc = str_replace(array('<', '>'), '', $metadesc);

	
	$metadesc = str_replace(array(chr(10),chr(13),"\n","\cr","\t"), " ",  $metadesc);
	$metadesc= preg_replace("/(\s){2,}/",'$1', $metadesc);
	
	$metakeyw= preg_replace("/(\s){2,}/",'$1', $metakeyw);
	$metakeyw = str_replace(" ", ",",  $metakeyw);
	$metadesc = str_replace(". .", ".",  $metadesc);

	$metakeyw = htmlspecialchars_uni(strip_tags(stripslashes($metakeyw)));
	$metadesc = htmlspecialchars_uni(strip_tags(stripslashes($metadesc)));

	// limit size of metatags 280 for keywords and 350 for description. 
	
	if(vbstrlen($metakeyw)>280)
	{
		$metakeyw = vbchop($metakeyw,280);
		$metakeyw = remove_last_comma($metakeyw);
	}

	$metadesc = (vbstrlen($metadesc)>350) ? vbchop($metadesc,346) . '...' :  $metadesc;

// Optimize for facebook

	if($ppg_options['facebook_opt'] AND THIS_SCRIPT == 'showimage')
	{
		$thumbtitle = str_replace(array('&quot;','"'), "'", $thumbtitle);
		$thumbtitle = '<meta name="title" content="' . $thumbtitle . '" />' . "\n";
		$thumbtitle .= '<link rel="image_src" href="' . $thumburl;
		// todo add other mimetypes: audio, flash movie
		$metadesc = $metadesc . '" />' . "\n" . $thumbtitle;
	}

	$headinclude = str_replace(array('|||VBGMETAKW|||','|||VBGMETADESC|||'), array($metakeyw,$metadesc), $headinclude);
	return $headinclude;
}
// ################ Gallery Announcement ##################
function construct_announcement()
{
	global $ppgal_announcement, $bbcode_parser, $vbulletin;

    require_once(DIR . '/includes/class_bbcode.php');
    require_once(DIR . '/includes/functions_wysiwyg.php');
    $bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
    $ppgal_announcement = $ppg_options['gallery_announcement'];

    $ppgal_announcement = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($ppgal_announcement));

	trim($ppgal_announcement);

	return $ppgal_announcement;
}

// ########################## Construct Categories ############################
function construct_categories($catinfo, $cat = 0)
{
	global $counter;

	if ($catinfo)
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$catarray[] = $cats;

				if ($subcat = construct_categories($catinfo, $cats['catid']))
				{
					$catarray = array_merge((array)$catarray, (array)$subcat);
				}
				$counter--;
			}
		}
	}
	return $catarray;
}

// ########################## Construct Categories ############################
function construct_category_counters($catinfo, $cat = 0)
{
	global $catscounter, $categoryperms, $ppg_options;

	if (!empty($catinfo))
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat AND $categoryperms["$cats[catid]"]['canviewgallery'] AND $cats['active'])
			{
				$catscounter++;
				$cats['level'] = $catscounter;

				unset($catinfo["$cats[catid]"]);

				if ($subcat = construct_category_counters($catinfo, $cats['catid']))
				{
					foreach ($subcat AS $subs)
					{
						$cats['imagecount'] += $subs['imagecount'];
						$cats['postcount'] += $subs['postcount'];
						if ($subs['lastimagedateline'] > $cats['lastimagedateline'])
						{
							$cats['lastimagedateline'] = $subs['lastimagedateline'];
							$cats['lastimageid'] = $subs['lastimageid'];
							$cats['lastimageusername'] = $subs['lastimageusername'];
							$cats['lastimageuserid'] = $subs['lastimageuserid'];
							$cats['lastimagetitle'] = $subs['lastimagetitle'];
						}
						if ($subs['lastpostdateline'] > $cats['lastpostdateline'])
						{
							$cats['lastpostid'] = $subs['lastpostid'];
							$cats['lastpostuserid'] = $subs['lastpostuserid'];
							$cats['lastpostusername'] = $subs['lastpostusername'];
							$cats['lastpostimagetitle'] = $subs['lastpostimagetitle'];
							$cats['lastpostdateline'] = $subs['lastpostdateline'];
						}

						if ($catscounter < $ppg_options['gallery_catdepth'] AND !$cats['membercat'])
						{
							$subcatarray["$subs[catid]"] = $subs;
						}
						else if ($catscounter <= $ppg_options['gallery_catdepth'] AND $ppg_options['gallery_showsubcats'])
						{
							$cats['subcats']["$subs[catid]"]['title'] = $subs['title'];
							$cats['subcats']["$subs[catid]"]['lastimagedateline'] = $subs['lastimagedateline'];
							$cats['subcats']["$subs[catid]"]['lastpostdateline'] = $subs['lastpostdateline'];
						}
					}
				}

				$catarray["$cats[catid]"] = $cats;

				if (!empty($subcatarray))
				{
					foreach ($subcatarray AS $subcatid => $subcatinfo)
					{
						$catarray["$subcatid"] = $subcatinfo;
					}
				}

				$catscounter--;
			}
		}
	}
	return $catarray;
}

// ################### Function to Print Categories ########################
function print_categories($cat = 0, $catinfo = '', $type = 'normal')
{
 
	global $db, $vbulletin, $permissions, $categorycache, $ppg_options, $vbcollapse, $stylevar, $vbphrase, $show, $categoryperms, $metabits, $thiscat_description_clean, $thiscat_description;

    require_once(DIR . '/includes/class_bbcode.php');
    require_once(DIR . '/includes/functions_wysiwyg.php');
    $bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());

	if (empty($catinfo))
	{
		$getcats = $db->query_read("
				SELECT catid, styleid, title, title_clean, description, description_clean, parent, hasimages, active, membercat, parentlist, catimage, imagecount, postcount, catuserid, useroptions, lastimageid, lastimagetitle, lastimageuserid, lastimageusername, lastimagedateline, lastpostid, lastpostuserid, lastpostusername, lastpostimagetitle, lastpostdateline, styleoverride
				FROM " . TABLE_PREFIX ."ppgal_categories
				ORDER BY $ppg_options[gallery_catsorderby] $ppg_options[gallery_catsdirection]
		");
		while ($categories = $vbulletin->db->fetch_array($getcats))
		{
			$catinfo[] = $categories;
			if($categories['catid']==$cat)
			{
				$thiscat_description = $categories['description'];
				$thiscat_description_clean = $categories['description_clean'];
			}
			
		}

		$db->free_result($getcats);
		unset($categories);

		$catinfo = construct_category_counters($catinfo, $cat);
		

		if (empty($catinfo))
		{
			return;
		}
	}

	$gallery_modcache = cache_gallery_mods();

	if (empty($categoryperms))
	{
		$categoryperms = fetch_category_perms();
	}

	// for use in catbit templates...
	$ppg_vars = array();
	$ppg_vars['gallery_showonoff'] = $ppg_options['gallery_showonoff'];
	$ppg_vars['gallery_fileurl'] =	$ppg_options['gallery_fileurl'];
	$ppg_vars['gallery_showslideshow'] = $ppg_options['gallery_showslideshow'];
	$ppg_vars['gallery_showcatuser'] = $ppg_options['gallery_showcatuser'];
	$ppg_vars['imagecount'] = $ppg_options['alt_imagecount'];
	$ppg_vars['moderator'] = $ppg_options['alt_moderator'];
	foreach ($catinfo AS $catid => $cats)
	{
				
		if (!$categoryperms["$cats[catid]"]['canviewgallery'] OR !$cats['active'] OR $cats['level'] > 2 OR $cats['level'] > $ppg_options['gallery_catdepth'])
		{
			continue;
		}

		if ($cats['catuserid'])
		{
			if ($cats['catuserid'] != $vbulletin->userinfo['userid'] AND !is_category_mod($cats['catid']))
			{
				$catuseropts = construct_cat_user_opts($catid, $cats['useroptions']);
				if (!$catuseropts['allow_view'])
				{
					continue;
				}
			}
			if (!$cats['catusername'])
			{
				$cats['catusername'] = htmlspecialchars_uni($categorycache["$cats[catid]"]['username']);
			}
			$cats['catuserpurl'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $cats['catuserid'], 'username' =>  $cats['catusername']));
		}
	
		$cats['title'] = htmlspecialchars_uni(stripslashes($cats['title']));
        $cats['description'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($cats['description']));

		$ppg_options['gallery_use_last_image'] = 1;
		if($cats['catimage'])
		{
			$cats['catimage'] = unserialize($cats['catimage']);
			$cats['catimageurl'] = $cats['catimage']['url'];
			$cats['catimagewidth'] = $cats['catimage']['w'];
			$cats['catimageheight'] = $cats['catimage']['h'];
			if($cats['catimage'] AND $vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1)
			{
				$ppg_vars['albumclass'] = '_alt';
			}
			if (($cats['catimagewidth'] > $ppg_options['gallery_catimage_size'] OR $cats['catimageheight'] > $ppg_options['gallery_catimage_size']) AND $ppg_options['gallery_catimage_size'])
			{
				$heightpercent = $cats['catimageheight'] / $ppg_options['gallery_catimage_size'];
				$widthpercent = $cats['catimagewidth'] / $ppg_options['gallery_catimage_size'];

				if ($widthpercent > $heightpercent)
				{
					$shrinkage = $ppg_options['gallery_catimage_size'] / $cats['catimagewidth'];
				}
				else
				{
					$shrinkage = $ppg_options['gallery_catimage_size'] / $cats['catimageheight'];
				}

				$cats['catimageheight'] = round($shrinkage * $cats['catimageheight']);
				$cats['catimagewidth'] = round($shrinkage * $cats['catimagewidth']);
			}
		}
		else if($ppg_options['gallery_use_last_image'] AND $cats['lastimageid'] AND $cats['lastimagecode'])
		{
			//get thumb from id
						$cats['lastimageid'] = 0;
			$cats['catimageurl'] = $cats['catimage']['url'];

		}
		else
		{
			$cats['catimageurl'] = '';
			$cats['catimagewidth'] = '';
			$cats['catimageheight'] = '';
		}
		if ($cats['hasimages'] == 1)
		{
			// Sub categories
			$subcatbits = '';
			
			if (!empty($cats['subcats']))
			{
				foreach ($cats['subcats'] AS $subcatid => $subcats)
				{
					if ($categoryperms["$subcatid"]['canviewgallery'])
					{
						if ($categorycache["$subcatid"]['catuserid'] AND !is_category_mod($subcatid) AND $categorycache["$subcatid"]['catuserid'] != $vbulletin->userinfo['userid'])
						{
							$useroptions = construct_cat_user_opts($subcatid, $categorycache["$subcatid"]['useroptions']);
							if (!$useroptions['allow_view'])
							{
								continue;
							}
						}

						$subcats['title'] = htmlspecialchars_uni(stripslashes($subcats['title']));
						$subonoff = iif($subcats['lastimagedateline'] > $vbulletin->userinfo['lastvisit'] OR $subcats['lastpostdateline'] > $vbulletin->userinfo['lastvisit'], 'new', 'old');

						
					

						$templater = vB_Template::create('adv_gallery_categorybit_subcat');
						$templater->register('subcats', $subcats);
						$templater->register('subonoff', $subonoff);
						$templater->register('subcatid', $subcatid);
						$subcatbits[] = $templater->render();
					}
				}
				if (!empty($subcatbits))
				{
					$subcatbits = '<span><b>' . $vbphrase['sub_categories'] . ':</b></span> ' . implode(', ', $subcatbits);
				}
			}
			// Moderators
			if($show['modcolumn'])
			{	
				$modcount = 0;
				foreach (explode(',', $cats['parentlist']) AS $parentid)
				{
					if ($gallery_modcache["$parentid"])
					{
						foreach ($gallery_modcache["$parentid"] AS $moderator)
						{
							if (!$donemods["$cats[catid]"]["$moderator[userid]"])
							{					   
								$donemods["$cats[catid]"]["$moderator[userid]"] = true;
								$moderator['link'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $moderator['userid'], 'username' =>  htmlspecialchars_uni($moderator['musername'])));
								$show['comma_leader'] = (!empty($cats['moderator']));
								$templater = vB_Template::create('adv_gallery_moderator');
  								$templater->register('moderator', $moderator);
								$cats['moderator'] .= trim($templater->render());

							}
						}
					}
				}
				unset($moderator);
			}

			$show['dateonly'] = false;

	 		if (!check_category_password($cats['catid'], false))
	 		{
	 			$show['dateonly'] = true;
	 		}

			if ($categoryperms["$cats[catid]"]['canviewimages'] OR $ppg_options['gallery_showimagecount'])
			{
				$cats['imagecount'] = vb_number_format($cats['imagecount']);

				if ($cats['lastimagedateline'])
				{
					$cats['lastimagetitle'] = fetch_trimmed_title(htmlspecialchars_uni(stripslashes($cats['lastimagetitle'])), $ppg_options['gallery_lastimage_maxlength']);
					$cats['lastupdateddate'] = vbdate($vbulletin->options['dateformat'], $cats['lastimagedateline']);
					$cats['lastupdatedtime'] = vbdate($vbulletin->options['timeformat'], $cats['lastimagedateline']);
					$cats['lastimageusername'] = htmlspecialchars_uni(stripslashes($cats['lastimageusername']));
					$cats['lastimagetitle'] = htmlspecialchars_uni(stripslashes($cats['lastimagetitle']));
					
					
				}
			}
			else
			{
				$cats['imagecount'] = 0;
				$cats['lastimageid'] = '';
			}

			if ($categoryperms["$cats[catid]"]['canviewreplies'] OR $ppg_options['gallery_showimagecount'])
			{
				$cats['postcount'] = vb_number_format($cats['postcount']);

				if ($cats['lastpostdateline'])
				{
					$cats['lastpostimagetitle'] = fetch_trimmed_title(htmlspecialchars_uni(stripslashes($cats['lastpostimagetitle'])), $ppg_options['gallery_lastimage_maxlength']);
					$cats['lastpostusername'] = htmlspecialchars_uni(stripslashes($cats['lastpostusername']));
					$cats['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $cats['lastpostdateline']);
					$cats['lastposttime'] = vbdate($vbulletin->options['timeformat'], $cats['lastpostdateline']);
				}
			}
			else
			{
				$cats['postcount'] = 0;
				$cats['lastpostid'] = '';
			}

			$onoff = 'old';
			if ($vbulletin->userinfo['lastvisit'] < $cats['lastimagedateline'])
			{
				$onoff = 'new';
			}


			

			$catcount++;
			//{vb:raw vboptions.bburl}/member.php?{vb:raw session.sessionurl}u={vb:raw cats.lastpostuserid}}
			// new !!! {vb:link member}because of phrasebug.. or because I am so stupid to figure it out...
			// we do it manually here...
			// ##################
			$ppg_vars['lastpostuserurl'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $cats['lastpostuserid'],	'username' => $cats['lastpostusername']));
			 
			$ppg_vars['lastimageuserurl'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $cats['lastimageuserid'],	'username' => $cats['lastimageusername']));
	

			// ################## metatags
			$i = $cats['catid'];
			$metabits[$i]['title'] = $cats['title_clean'];
			$metabits[$i]['description'] = '';
			$metabits[$i]['description'] = $cats['description_clean'];
			$metabits[$i]['lastimagetitle'] = $cats['lastimagetitle'];
			
			// ##################
			
			$templater = vB_Template::create('adv_gallery_categorybit_level' . $cats['level']);
			$templater->register('cats', $cats);
			$templater->register('onoff', $onoff);
			$templater->register('catcount', $catcount);
			$templater->register('subcatbits', $subcatbits);
			$templater->register('ppg_vars', $ppg_vars);

			$categorybits .= $templater->render();
			//eval('$categorybits .= "' . fetch_template('adv_gallery_categorybit_level' . $cats['level']) . '";');
			
			
		}
		else
		{
			
			// ################## metatags
			 // needed for metatags
				$i = $cats['catid'];
				$metabits[$i]['title'] = $cats['title_clean'];
				$metabits[$i]['description'] = '';
				$metabits[$i]['description'] = $cats['description_clean'];
				$metabits[$i]['lastimagetitle'] = $cats['lastimagetitle'];

			// strange enough... this is not needed anymore...!!!!
			//$catcollapse = $vbcollapse["collapseimg_catbit_" . $cats['catid'] . ""];
			//$catimgcollapse =& $vbcollapse["collapseimg_catbit_" . $cats['catid'] . ""];
				// print $catimgcollapse; exit;


			// for layout... replace empty description with:&nbsp;...
			//  maybe we dont need it.. but in top level cats it looks nicer.. if all are the same height..
			if(empty($cats['description']))
			{$cats['description'] = '&nbsp;';}
			$catcount++;
			
			$templater = vB_Template::create('adv_gallery_categorybit_main');
			$templater->register('cats', $cats);
			$templater->register('catcount',$catcount);
			//$templater->register('catimgcollapse', $catimgcollapse);
			$categorybits .= $templater->render(); 
				
			//eval('$categorybits .= "' . fetch_template('adv_gallery_categorybit_main') . '";');
		}
		//	print $categorybits;		
	}
	unset($catinfo);
	return $categorybits;

}
//////////////// Stats to print Polls ///////////////
function print_gal_statistic_result($date, $bar, $value, $width)
{
	global $stylevars, $vbulletin,$vbphrase;
	
	
	if($_REQUEST['do'] == 'posts')
	{
		$dophrase = $vbphrase['comments_dot'];
	}
	else
	{
		$dophrase = $vbphrase['uploads_dot'];
	}
	$ppg_vars['pollnumber'] = $bar;
	$templater = vB_Template::create('adv_gallery_stats_stat2');
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('bgclass', $bgclass);
	$templater->register('tablename', $tablename);
	$templater->register('date', $date);
	$templater->register('dophrase', $dophrase);
	$templater->register('bgclass', $bgclass);
	$templater->register('width', $width);
	$templater->register('value', $value);
	$sonuc .= $templater->render();

// eval('$sonuc .= "' . fetch_template('adv_gallery_stats_stat2') . '";');
	return $sonuc;
}
// ######################### Fetch Category Permissions #######################
function fetch_category_perms($catid = 0, $ugid = '')
{
	global $vbulletin, $gallerypermissionsbit, $gallery_permissions, $galleryperms, $categorycache;

	if ($ugid)
	{
		$usergroupids = $ugid;
	}
	else
	{
		$usergroupids = fetch_membergroupids_array($vbulletin->userinfo);
	}

	$catperms = array();
	$categoryperms = array();

	if ($catid == 0)
	{
		foreach (array_keys($categorycache) AS $catid)
		{
			$thiscatperms = unserialize($categorycache["$catid"]['permissions']);

			if (empty($thiscatperms))
			{
				$catperms["$catid"] = $galleryperms;
				continue;
			}

			foreach ($usergroupids AS $usergroupid)
			{
				if (empty($thiscatperms["$usergroupid"]) AND $thiscatperms["$usergroupid"] != '0')
				{
					if (empty($gallery_permissions["$usergroupid"]))
					{
						$usergroupid = 1;
					}

					$categoryperms["$catid"] = $gallery_permissions["$usergroupid"]['gallery_perms'];
				}
				else
				{
					$categoryperms["$catid"] = $thiscatperms["$usergroupid"];
				}

				foreach ($gallerypermissionsbit AS $option => $value)
				{
					if (in_array($option, array('moderateimages', 'moderateposts')) AND $catperms["$catid"]["$option"] == 0 AND isset($catperms["$catid"]["$option"]))
					{
						continue;
					}
					if (!$catperms["$catid"]["$option"] OR in_array($option, array('moderateimages', 'moderateposts')))
					{
						$catperms["$catid"]["$option"] = 0;
						if ($categoryperms["$catid"] & $value)
						{
							$catperms["$catid"]["$option"] = 1;
						}
					}
				}
			}
		}
	}
	else
	{
		$thiscatperms = unserialize($categorycache["$catid"]['permissions']);

		foreach ($usergroupids AS $usergroupid)
		{
			if (empty($thiscatperms["$usergroupid"]) AND $thiscatperms["$usergroupid"] != '0')
			{
				$categoryperms = $gallery_permissions["$usergroupid"]['gallery_perms'];
			}
			else
			{
				$categoryperms |= $thiscatperms["$usergroupid"];
			}
			foreach ($gallerypermissionsbit AS $option => $value)
			{
				if (!$catperms["$option"] OR (in_array($option, array('moderateimages', 'moderateposts')) AND $catperms["$option"] == 0))
				{
					$catperms["$option"] = 0;
					if ($categoryperms & $value)
					{
						$catperms["$option"] = 1;
					}
				}
			}
		}
	}

	return $catperms;
}

// ######################## Fetch Private Categories ##########################
function fetch_private_categories()
{
	global $categorycache, $categoryperms, $vbulletin;

	$privatecats = array();

	if (empty($categoryperms))
	{
		$categoryperms = fetch_category_perms();
	}

	if (!empty($categoryperms))
	{
		foreach ($categoryperms AS $catid => $cperms)
		{
			if (is_category_mod($catid))
			{
				continue;
			}

			if ($categorycache["$catid"]['catuserid'])
			{
				$useroptions = construct_cat_user_opts($catid, $categorycache["$catid"]['useroptions']);
				if (!$useroptions['allow_view'])
				{
					$privatecats[] = $catid;
				}
			}
			else
			{
				$catopts = construct_cat_opts($catid, $categorycache["$catid"]['options']);

				if ($catopts['canhavepassword'] AND !$categorycache["$catid"]['password'])
				{
					$parentlist = explode(',', $categorycache["$catid"]['parentlist']);

					if (!empty($parentlist))
					{
						foreach ($parentlist AS $pcatid)
						{
							$catopts = construct_cat_opts($pcatid, $categorycache["$pcatid"]['options']);
							if ($categorycache["$pcatid"]['password'] AND $catopts['childpass'])
							{
								if (fetch_bbarray_cookie('catpassword', $pcatid) != md5($vbulletin->userinfo['userid'] . $categorycache["$pcatid"]['password']))
								{
									$privatecats[] = $catid;
								}
							}
						}
					}
				}
			}

			if (($categorycache["$catid"]['password'] AND fetch_bbarray_cookie('catpassword', $catid) != md5($vbulletin->userinfo['userid'] . $categorycache["$catid"]['password'])) OR ((!$cperms['canviewimages'] OR !$cperms['canviewgallery'] OR !$categorycache["$catid"]['active']) AND !is_category_mod($catid)))
			{
				$privatecats[] = $catid;
			}
		}
	}
	return implode(',', $privatecats);
}

// ###################### Function to Construct Categories #####################
function construct_category_perms($catinfo, $cat = 0, $catpermissions)
{
	global $catperms;

	if ($catinfo)
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$catperms["$cats[catid]"] = $catpermissions["$cats[catid]"];

				if (!empty($catperms["$cats[parent]"]) AND empty($catperms["$cats[catid]"]))
				{
					$catperms["$cats[catid]"] = $catperms["$cats[parent]"];
				}

				construct_category_perms($catinfo, $cats['catid'], $catpermissions);
			}
		}
	}
	return $catperms;
}

// ############################## Update Category Cache ######################
function update_category_cache()
{
	global $db, $ppg_options, $vbulletin;

	$catsinfo = array();
	$catpermissions = array();

	$permissions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_permissions");
	while ($permission = $vbulletin->db->fetch_array($permissions))
	{
		$catpermissions["$permission[catid]"]["$permission[usergroupid]"] = $permission['permissions'];
	}

	$db->free_result($permissions);
	unset($permission);

	$users = array();

	if(!isset($ppg_options['gallery_catsorderby']) OR !isset($ppg_options['gallery_catsdirection']))
	{
		$ppg_options['gallery_catsorderby'] = 'displayorder';
		$ppg_options['gallery_catsdirection'] = 'ASC';
	}

	$getcats = $db->query_read("SELECT catid, styleid, title, title_clean, allowusercats, catuserid, membercat, parent, parentlist, childlist, hasimages, password, active, options, useroptions, styleoverride FROM " . TABLE_PREFIX ."ppgal_categories ORDER BY $ppg_options[gallery_catsorderby] $ppg_options[gallery_catsdirection], hasimages");
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		if ($categories['catuserid'])
		{
			$users[] = $categories['catuserid'];
		}
		$catsinfo[] = $categories;
	}

	if (!empty($catpermissions))
	{
		$catperms = construct_category_perms($catsinfo, 0, $catpermissions);
	}

	if (!empty($users))
	{
		$usernamecache = array();
		$getusers = $db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid IN(" . implode(',', $users) . ")");
		while ($user = $vbulletin->db->fetch_array($getusers))
		{
			$usernamecache["$user[userid]"] = $user['username'];
		}
		$db->free_result($getusers);
		unset($user);
	}

	$categoryinfo = array();

	if ($catinfo = construct_categories($catsinfo, 0, -1))
	{
		foreach ($catinfo AS $cats)
		{
			$categoryinfo["$cats[catid]"] = $cats;
			if ($catperms["$cats[catid]"])
			{
				$categoryinfo["$cats[catid]"]['permissions'] = serialize($catperms["$cats[catid]"]);
			}
			if ($cats['catuserid'])
			{
				$categoryinfo["$cats[catid]"]['username'] = $usernamecache["$cats[catuserid]"];
			}
		}
	}

	$db->free_result($getcats);
	build_datastore('gallery_c_cache',serialize($categoryinfo),1);
	unset($categories, $catinfo);
}

// ########################### Make Cat Select Field ##########################
function print_cat_select($selectedid = 0, $type)
{
	global $categorycache, $allowedparents, $vbulletin, $categoryperms, $category;
	switch ($type)
	{
		case 'catjump':
			$permissions = 'canviewgallery';
			break;

		case 'upload':
			$permissions = 'canuploadimages';
			break;

		case 'search':
			$permissions = 'cansearchimages';
			break;

		case 'managecats':
			$permissions = 'cancreatecategories';
			break;

		case 'admin':
			break;
	}
	
	if (!is_array($allowedparents))
	{
		$allowedparents = array();
	}

	if (!empty($categorycache))
	{
		if (empty($categoryperms))
		{
			$categoryperms = fetch_category_perms();
		}
		$opt_open_cats = array();
		foreach ($categorycache AS $cats)
		{
			$iscatmod = is_category_mod($cats['catid']);
			if ($type != 'admin' AND $cats['catuserid'] AND $cats['catuserid'] != $vbulletin->userinfo['userid'] AND !$iscatmod)
			{
				$useroptions = construct_cat_user_opts($cats['catid'], $categorycache["$cats[catid]"]['useroptions']);
				if (!$useroptions['allow_upload'] OR !$useroptions['allow_view'])
				{
					continue;
				}
			}

			$catopts = construct_cat_opts($cats['catid'], $cats['options']);

			if ($cats['parent'] != 0 AND !$categorycache["$cats[parent]"]['active'] AND (!$cats['catuserid'] OR $cats['catuserid'] != $vbulletin->userinfo['userid']))
			{
				$cats['active'] = 0;
				$categorycache["$cats[catid]"]['active'] = 0;
			}

			if ((($type == 'managecats' AND (!$cats['allowusercats'] AND !in_array($cats['catid'], $allowedparents)) OR $cats['catid'] == $category['catid'])) OR !$categoryperms["$cats[catid]"]["$permissions"] OR (!$iscatmod AND !$cats['active'] AND $type != 'admin' AND $cats['catid'] != $selectedid) OR (!$catopts['open_for_images'] AND $type == 'upload' AND $cats['hasimages']) OR !check_category_password($cats['catid'], false))
			{
				continue;
			}


            $dashes = '';
            if(intval($cats['level'])>1)
            {
                $cats['steplevel'] = $cats['level'] - 1;
                $dashes = str_repeat(' &nbsp;&nbsp; ', $cats['steplevel']);
            } 


			$selected = '';
			if ($selectedid == $cats['catid'])
			{
				$selected = ' selected="selected" ';
				$class = 'xxfjsel';
			}
			elseif ($cats['level'] <= 4)
			{
				$class = 'xxfjdpth' . $cats['level'];
			}
			else
			{
				$class = 'xxfjdpth';
			}
			if ((!$cats['hasimages'] AND $type == 'upload') OR (!$cats['allowusercats'] AND $cats['catuserid'] != $vbulletin->userinfo['userid'] AND $type == 'managecats'))
			{
			
				$opt_open_cats[$cats[catid]] = intval($cats['level']);

				if(!empty($opt_open_cats))
				{
					foreach($opt_open_cats AS $opencatid => $openlevel)
					{
						
						if($openlevel >= $cats['level'] AND $opencatid != $cats['catid'])
						{
							unset($opt_open_cats[$opencatid]);
							$options .=  '</optgroup>';
							
						}
						
					}
					unset($opencatid, $openlevel);
				}

				$options .=  '<optgroup label="&nbsp;&nbsp;&nbsp;' . $dashes . '' . stripslashes($cats['title']) . '">';
				$closegroup = true;
				
			
			}
			else
			{

				if(!empty($opt_open_cats))
				{
					foreach($opt_open_cats AS $opencatid => $openlevel)
					{
						if($openlevel >= $cats['level'] AND $opencatid != $cats['catid'])
						{
							unset($opt_open_cats[$opencatid]);
							$options .= '</optgroup>';
						}
					}
					unset($opencatid, $openlevel);
				}

				$spaces = ($cats['level'] == 1) ? '&nbsp;&nbsp;&nbsp;':'&nbsp;&nbsp;';
				$options .= '<option class="' . $class . '" value="' . $cats['catid'] . '" ' . $selected . '>'.$spaces . $dashes . stripslashes($cats['title']) . '</option>';
			}
		}


		if(!empty($opt_open_cats))
		{
			foreach($opt_open_cats AS $opencatid => $openlevel)
			{
				unset($opt_open_cats[$opencatid]);
				$options .= '</optgroup>';
			}
			unset($opencatid, $openlevel);
		}

		unset($cats, $catinfo);
	}
	 

	return $options;
}


// ############################ Category Jump #################################
function print_galquick_jump($navpopup = array(), $parentid = 0, $addbox = true)
{
	global $vbphrase, $categorycache, $allowedparents, $vbulletin, $categoryperms, $category;
	if($_REQUEST['jumpcreated'])
	{
		return '';
	}

	$permissions = 'canviewgallery';
	if (!is_array($allowedparents))
	{
		$allowedparents = array();
	}

	if (!empty($categorycache))
	{
		if (empty($categoryperms))
		{
			$categoryperms = fetch_category_perms();
		}
		if (!is_array($vbulletin->icatcache) OR empty($vbulletin->icatcache))
		{
			$vbulletin->icatcache = array();
			foreach ($categorycache AS $icatid => $icat)
			{
				$icat['parent'] = intval($icat['parent']);
				$vbulletin->icatcache["$icat[parent]"]["$icatid"] = $icatid;
			}
		}
			//print "<pre>";print_r($categoryperms);exit;
		if (empty($vbulletin->icatcache["$parentid"]) OR !is_array($vbulletin->icatcache["$parentid"]))
		{
			return;
		}
		foreach($vbulletin->icatcache["$parentid"] AS $catid)
		{
			$cats = $categorycache["$catid"];
			$iscatmod = is_category_mod($cats['catid']);

			if($cats['catuserid'] AND $cats['catuserid'] != $vbulletin->userinfo['userid'] AND !$iscatmod)
			{
				$useroptions = construct_cat_user_opts($cats['catid'], $categorycache["$cats[catid]"]['useroptions']);
				if (!$useroptions['allow_upload'] OR !$useroptions['allow_view'])
				{
					continue;
				}
			}

			$catopts = construct_cat_opts($cats['catid'], $cats['options']);

			if ($cats['parent'] != 0 AND !$categorycache["$cats[parent]"]['active'] AND (!$cats['catuserid'] OR $cats['catuserid'] != $vbulletin->userinfo['userid']))
			{
				$cats['active'] = 0;
				$categorycache["$cats[catid]"]['active'] = 0;
			}

			if (!$categoryperms["$cats[catid]"]["$permissions"] OR (!$iscatmod AND !$cats['active']) OR  !check_category_password($cats['catid'], false))
			{
				continue;
			}
			
			if(!$categoryperms["$cats[catid]"]["$permissions"])
			{
				continue;
			}
			else
			{
				$cats['depth'] = substr_count($cats['parentlist'], ',') ;
				$children = explode(',', trim($cats['childlist']));

				if (sizeof($children) <= 2)
				{
					$templater = vB_Template::create('adv_gallery_category_jump_link');
					$templater->register('cats', $cats);
					$jumpcatbits .= $templater->render();
				}
				else
				{
					if ($forumbits = print_galquick_jump($navpopup, $cats['catid'], false))
					{
						$templater = vB_Template::create('adv_gallery_category_jump_subforum');
							$cats['depth']++;
							$templater->register('cats', $cats);
							$templater->register('forumbits', $forumbits);
						$jumpcatbits .= $templater->render();
					}
					else
					{
						$templater = vB_Template::create('adv_gallery_category_jump_link');
							$templater->register('cats', $cats);
						$jumpcatbits .= $templater->render();
					}
				}
			}
		}

	}

	if ($addbox)
	{
		$templater = vB_Template::create('adv_gallery_category_jump');
		
		$templater->register('jumpcatbits', $jumpcatbits);
		$templater->register('navpopup', $navpopup);
		$categoryjump = $templater->render();

		// prevent galleryjump from being built more than once ( using superglobal $_REQUEST)
		$_REQUEST['jumpcreated'] = true;
		return $categoryjump;
	}
	else
	{
		return $jumpcatbits;
	}

}




// ######################### Check Password ############################
function check_category_password($catid, $printerror = true, $scriptname = 'browseimages')
{
	global $vbulletin, $categorycache;

	$catinfo = $categorycache["$catid"];

	$parentlist = explode(',', $catinfo['parentlist']);

	$catopts = construct_cat_opts($catinfo['catid'], $catinfo['options']);

	if ($catopts['canhavepassword'])
	{
		if (!empty($parentlist))
		{
			foreach ($parentlist AS $pcatid)
			{
				$catopts = construct_cat_opts($pcatid, $categorycache["$pcatid"]['options']);
				if ($categorycache["$pcatid"]['password'] AND $catopts['childpass'])
				{
					$parpass = true;
					$parcookiepass = fetch_bbarray_cookie('catpassword', $pcatid);
				}
				$cookiepass = fetch_bbarray_cookie('catpassword', $catid);
				$passcheck = md5($vbulletin->userinfo['userid'] . $categorycache["$catid"]['password']);

				if ($cookiepass == $passcheck OR $parcookiepass == $passcheck)
				{
					return true;
				}
			}
		}
		if (!$parpass AND !$catinfo['password'])
		{
			return true;
		}
		if ($printerror)
		{
			if(defined("VBGLITE"))
			{
				vbglite_error();
			}
			$sectoken = $vbulletin->userinfo['securitytoken']; 
			standard_error(fetch_error('adv_gallery_categorypassword', $vbulletin->session->vars['sessionurl'], $scriptpath, $catinfo['catid'],$sectoken));
		}
	}
	else if ($catinfo['password'])
	{
		if (fetch_bbarray_cookie('catpassword', $catinfo['catid']) == md5($vbulletin->userinfo['userid'] . $catinfo['password']))
		{
			return true;
		}
		else
		{
			if ($printerror)
			{
				if(defined("VBGLITE"))
				{
					vbglite_error();
				}
				$sectoken = $vbulletin->userinfo['securitytoken']; 
				standard_error(fetch_error('adv_gallery_categorypassword', $vbulletin->session->vars['sessionurl'], $scriptpath, $catinfo['catid'],$sectoken));
			}
			else
			{
				return false;
			}
		}
	}
	else
	{
		return true;
	}
}

// ########################## Fetch Allowed Parents ###########################
function fetch_allowed_parents()
{
	global $vbulletin, $categorycache;

	$allowedparents = array();
	if (!empty($categorycache))
	{
		foreach ($categorycache AS $cats)
		{
			if ($cats['catuserid'] == $vbulletin->userinfo['userid'])
			{
				foreach (explode(',', $cats['parentlist']) AS $parentid)
				{
					$allowedparents[] = $parentid;
				}
			}
		}
	}
	return $allowedparents;
}

// ######################## Children Stuff #############################

function rebuild_children($catid)
{
	global $db,$vbulletin;

	if ($catid == -1)
	{
		return '-1';
	}

	

	$getcats = $vbulletin->db->query_read("
		SELECT catid, parentlist
		FROM " . TABLE_PREFIX . "ppgal_categories ");
	$catlist = array();
	while ($getcat = $vbulletin->db->fetch_array($getcats))
	{
		if(!empty($getcat['parentlist']))
		{
			$getcat['parentarray'] = explode(",", $getcat['parentlist']);
		}
		else
		{
			$getcat['parentarray'] = array();
		}
		$catlist[] = $getcat;
		
	}


	//$vbulletin->$db->free_result($getcats);
	
	$childlist = $catid;
	foreach($catlist AS $cat)
	{

		if(in_array($catid,$cat['parentarray']))
		{
			if($catid != $cat['catid'])
			{
				$childlist .= ',' . $cat['catid'];
			}
		}
		

	}


	$childlist .= ',-1';

	return $childlist;

}
// ######################## Insert Childlist ###########################
function construct_childlist($catid = 0)
{
	global $db, $vbulletin;

	if (intval($catid)>0)
	{
		$clist = rebuild_children($catid);

	}
	else
	{
		$clist = $catid . ',-1';
	}
	//print 'inserted for catid:' . $catid . ' = ' .$clist;
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET childlist = '$clist' WHERE catid = '$catid'");
}
// ############################## Rebuild Children #############################

// rebuild  Childlist ###########################
function insert_category_childlist()
{
	global $db, $newcatid, $vbulletin;

	if (intval($newcatid)>0)
	{
		$clist = rebuild_children($newcatid);

	}
	else
	{
		$clist = $newcatid . ',-1';
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET childlist = '$clist' WHERE catid = '$newcatid'");
}

// ############################## Reconstruct Children #############################
function reconstruct_children($catid = 0)
{
	// construct for category
	if($catid != 0)
	{
		construct_childlist($catid);
	}

	global $db, $vbulletin;
	// construct for childcats
	$catarray = array();

	/*$getcats = $vbulletin->db->query_read("
		SELECT catid
		FROM " . TABLE_PREFIX . "ppgal_categories
		WHERE parentlist LIKE '%,$catid,%'
	");
*/


	$getcats = $db->query_read("SELECT catid FROM " . TABLE_PREFIX . "ppgal_categories ORDER BY displayorder DESC, hasimages");
	$counter = 0;
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		$catarray[] = $categories;
			
	}



	$db->free_result($getcats);
	unset($categories);

	foreach ($catarray as $cat)
	{
		//print '<br />'. $cat['catid'] . "<br />---------<br />";
		if($counter<1000)
		{
			$counter++;
			construct_childlist($cat['catid']);
		}
		else
		{
			//no childlist for categories over 1000 (performance)
			break;
		}

	}

	//construct for parent cats



}

// ######################### Parent stuff ##############################
// ####################### Insert Parentlist ###########################
function insert_category_parentlist($parentid)
{
	global $db, $newcatid, $vbulletin;

	if ($parentid)
	{
		$cat = $db->query_first("SELECT parentlist FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$parentid'");
	}

	if ($cat['parentlist'])
	{
		$plist = $newcatid . ',' . $cat['parentlist'];
	}
	elseif ($parentid)
	{
		$plist = $newcatid . ',' . $parentid;
	}
	else
	{
		$plist = $newcatid;
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET parentlist = '$plist' WHERE catid = '$newcatid'");
}


// ##################### Reconstruct Parents ######################
function reconstruct_parents($catid)
{
	rebuild_parents($catid);

	global $db, $vbulletin;

	$catarray = array();
	$getcats = $db->query_read("SELECT catid, parent FROM " . TABLE_PREFIX . "ppgal_categories ORDER BY displayorder ASC, hasimages");
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		$catarray[] = $categories;
	}

	$db->free_result($getcats);
	unset($categories);

	$catinfo = construct_categories($catarray, $catid, -1);
	if (!empty($catinfo))
	{
		foreach ($catinfo as $cats)
		{
			rebuild_parents($cats['catid']);
		}
	}
}



// ############################## Rebuild Parents #############################
function rebuild_parents($catid = 0)
{
	global $db, $vbulletin, $parentlist;

	$cats = array();

	$getcats = $db->query_read("SELECT catid, title, parent FROM " . TABLE_PREFIX . "ppgal_categories ORDER BY parent");
	while ($catinfo = $vbulletin->db->fetch_array($getcats))
	{
		$cats[] = $catinfo;
	}

	$db->free_result($getcats);
	unset($catinfo);

	foreach($cats AS $cat)
	{
		if ($catid != 0 AND $cat['catid'] != $catid)
		{
			continue;
		}
		$parentlist = array();
		$parentlist[] = $cat['catid'];
		construct_parents($cats, $cat['parent']);
		$plist = implode(',', $parentlist);

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET parentlist = '$plist' WHERE catid = '$cat[catid]'");

	}
}

// ################ Find Parent Directories ##################
function construct_parents($catinfo, $catid)
{
	global $parentlist;

	foreach ($catinfo AS $subs)
	{
		if ($subs['catid'] == $catid)
		{
			$parentlist[] = $subs['catid'];
			construct_parents($catinfo, $subs['parent']);
		}
	}
	return $parentlist;
}

// ####################### Construct Category Options ########################
function construct_cat_opts($catid, $catint)
{
	global $categoryopts;

	foreach ($categoryopts AS $option => $value)
	{
		$catopts["$option"] = 0;
		if ($catint & $value)
		{
			$catopts["$option"] = 1;
		}
	}
	return $catopts;
}

// ####################### Construct Category User Options ############################
function construct_cat_user_opts($catid, $catint)
{
	global $catuseropts;

	foreach ($catuseropts AS $option => $value)
	{
		$useropts["$option"] = 0;
		if ($catint & $value)
		{
			$useropts["$option"] = 1;
		}
	}
	return $useropts;
}

// ############################ Cache Moderators ############################
function cache_gallery_mods()
{
	global $vbulletin;

	if ($gallerymods =& $vbulletin->gal_mod_cache)
	{
		foreach ($gallerymods AS $moderator)
		{
			$moderator['musername'] = fetch_musername($moderator);
			$gallery_modcache["$moderator[catid]"]["$moderator[userid]"] = $moderator;
		}
	}
	return $gallery_modcache;
}

// ######################### Find Category Mods #########################
function is_category_mod($catid)
{
	global $vbulletin, $permissions, $categorycache, $ppg_options;

	if (($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
	{
		return true;
	}
	else if ($categorycache["$catid"]['catuserid'] AND $vbulletin->userinfo['userid'] == $categorycache["$catid"]['catuserid'] AND $ppg_options['gallery_usercats_modopts'])
	{
		return true;
	}
	else
	{
		$gallery_modcache = cache_gallery_mods();

		foreach (explode(',', $categorycache["$catid"]['parentlist']) AS $parentid)
		{
			if ($gallery_modcache["$parentid"])
			{
				foreach($gallery_modcache["$parentid"] AS $moderator)
				{
					if ($vbulletin->userinfo['userid'] == $moderator['userid'])
					{
						return true;
					}
				}
			}
		}
	}
}
// #################### Construct Imagebits ######################
function construct_free_imagebits(&$images, $highlight = '',$type=0)
{
	global $ppg_options, $stylevar, $vbulletin, $vbphrase, $show, $adv_sorturl, $catinfo, $counter, $cellwidth, $categoryperms, $showfields, $categorycache, $catopts, $bbcode_parser;

	

	$tmpvars = array();
	if($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1)
	{
		$tmpvars['albumclass'] = '_alt';
	}

	if ($counter > $ppg_options['gallery_columns'])
	{
		$imagebits .= '</tr><tr>';
		$counter = 1;
	}

	// check for imagebit lite
	$show['imgbit_lite'] = false;
	$show['imgbit_lite_block'] = false;
	if($vbulletin->stylevars['ppg_browseimg_imgbit_lite']['numeric'] == 1 AND $type !='block')
	{
		$templatename = 'adv_gallery_imagebit_lite';
		$show['imgbit_lite'] = true;
	}
	else if($vbulletin->stylevars['ppg_blocks_imgbit_lite']['numeric'] == 1 AND $type=='block') 
	{
		$show['imgbit_lite_block'] = true;
		$templatename = 'adv_gallery_imagebit_lite';
	}
	else
	{
		$templatename = 'adv_gallery_imagebit';
	}

	if ($showfields['title'])
	{
		$images['title'] = htmlspecialchars_uni(stripslashes($images['title']));

		if (!$images['title'])
		{
			$images['title'] = htmlspecialchars_uni($images['filename']);
		}
	}


	if (!$catopts["$images[catid]"])
	{
		$catopts["$images[catid]"] = construct_cat_opts($images['catid'], $categorycache["$images[catid]"]['options']);
	}

	if ($images['originalname'])
	{
		if ($ppg_options['gallery_watermark'] AND $ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = 'displayimage.php?imageid=' . $images['imageid'] . '&original=1';
		}
		else if ($ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = construct_image_url($images, 'originalname');
		}
		else
		{
			$images['originalurl'] = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $images['imageid'] . '&amp;original=1';
		}
	}

	$images['username'] = htmlspecialchars_uni(stripslashes($images['username']));
	$images['userurl'] =  fetch_seo_url('member', array('userid' => $images['userid'],	'username' => $images['username']));

	$images['cattitle'] = htmlspecialchars_uni(stripslashes($images['cattitle']));
	if(!$show['imgbit_lite_block'] AND !$show['imgbit_lite'])
	{
		$images['views'] = vb_number_format($images['views']);
		$images['filesize'] = vb_number_format($images['filesize'], 1, true);
		$images['dateadded'] = vbdate($vbulletin->options['dateformat'], $images['dateline']);
		$images['timeadded'] = vbdate($vbulletin->options['timeformat'], $images['dateline']);
		$images['description'] = htmlspecialchars_uni(stripslashes($images['description']));
	
	
		if ($images['originalfilesize'])
		{
			$images['originalfilesize'] = vb_number_format($images['originalfilesize'], 1, true);
		}

		if ($categoryperms["$images[catid]"]['canviewreplies'])
		{
			$images['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $images['lastpostdateline']);
			$images['lastposttime'] = vbdate($vbulletin->options['timeformat'], $images['lastpostdateline']);
			$images['lastpostusername'] =  htmlspecialchars_uni(stripslashes($images['lastpostusername']));
			$images['lastpostuserurl'] =  fetch_seo_url('member', array('userid' => $images['lastpostuserid'],	'username' => $images['lastimageusername']));
			$images['replies'] = vb_number_format($images['posts']);
		}
		else
		{
			$images['replies'] = 0;
			$images['lastpostdateline'] = 0;
		}
	}
	$images['url'] = construct_image_url($images, 'thumbname');

// nomore show sticky, we use images[sticky]	instead of $show['sticky'] = false;


	$show['subscribed'] = false;
	if ($images['subid'])
	{
		$show['subscribed'] = true;
	}

	$images['rating'] = '';
	if ($images['votetotal'] AND $images['votenum'])
	{
		$images['truerating'] = vb_number_format($images['votetotal'] / $images['votenum'], 2);
		$images['rating'] = round($images['truerating']);
	}
		


 		$templater = vB_Template::create($templatename);
		$templater->register('adv_sorturl', $adv_sorturl);
		// we rename tmpvars to ppg_vars so we dont register ALL ppg_vars
		$templater->register('ppg_vars', $tmpvars);

		$templater->register('images', $images);
		$templater->register('cellwidth', $cellwidth);
		$templater->register('catinfo', $catinfo);
		$templater->register('showfields', $showfields);

        $imagebits .= $templater->render(); 
	return $imagebits;
}
// #################### Construct Imagebits ######################
function construct_imagebits(&$images, $highlight = '',$type=0)
{
	global $ppg_options, $stylevar, $vbulletin, $vbphrase, $show, $adv_sorturl, $catinfo, $counter, $cellwidth, $categoryperms, $showfields, $categorycache, $catopts, $bbcode_parser;

	

	$tmpvars = array();
	if($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1)
	{
		$tmpvars['albumclass'] = '_alt';
	}

	if ($counter > $ppg_options['gallery_columns'])
	{
		$imagebits .= '</tr><tr>';
		$counter = 1;
	}

	// check for imagebit lite
	$show['imgbit_lite'] = false;
	$show['imgbit_lite_block'] = false;
	if($vbulletin->stylevars['ppg_browseimg_imgbit_lite']['numeric'] == 1 AND $type !='block')
	{
		$templatename = 'adv_gallery_imagebit_lite';
		$show['imgbit_lite'] = true;
	}
	else if($vbulletin->stylevars['ppg_blocks_imgbit_lite']['numeric'] == 1 AND $type=='block') 
	{
		$show['imgbit_lite_block'] = true;
		$templatename = 'adv_gallery_imagebit_lite';
	}
	else
	{
		$templatename = 'adv_gallery_imagebit';
	}

	if ($showfields['title'])
	{
		$images['title'] = htmlspecialchars_uni(stripslashes($images['title']));

		if (!$images['title'])
		{
			$images['title'] = htmlspecialchars_uni($images['filename']);
		}
	}


	if (!$catopts["$images[catid]"])
	{
		$catopts["$images[catid]"] = construct_cat_opts($images['catid'], $categorycache["$images[catid]"]['options']);
	}

	if ($images['originalname'])
	{
		if ($ppg_options['gallery_watermark'] AND $ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = 'displayimage.php?imageid=' . $images['imageid'] . '&original=1';
		}
		else if ($ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = construct_image_url($images, 'originalname');
		}
		else
		{
			$images['originalurl'] = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $images['imageid'] . '&amp;original=1';
		}
	}

	$images['username'] = htmlspecialchars_uni(stripslashes($images['username']));
	$images['userurl'] =  fetch_seo_url('member', array('userid' => $images['userid'],	'username' => $images['username']));

	$images['cattitle'] = htmlspecialchars_uni(stripslashes($images['cattitle']));
	if(!$show['imgbit_lite_block'] AND !$show['imgbit_lite'])
	{
		$images['views'] = vb_number_format($images['views']);
		$images['filesize'] = vb_number_format($images['filesize'], 1, true);
		$images['dateadded'] = vbdate($vbulletin->options['dateformat'], $images['dateline']);
		$images['timeadded'] = vbdate($vbulletin->options['timeformat'], $images['dateline']);
		$images['description'] = htmlspecialchars_uni(stripslashes($images['description']));
	
	
		if ($images['originalfilesize'])
		{
			$images['originalfilesize'] = vb_number_format($images['originalfilesize'], 1, true);
		}

		if ($categoryperms["$images[catid]"]['canviewreplies'])
		{
			$images['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $images['lastpostdateline']);
			$images['lastposttime'] = vbdate($vbulletin->options['timeformat'], $images['lastpostdateline']);
			$images['lastpostusername'] =  htmlspecialchars_uni(stripslashes($images['lastpostusername']));
			$images['lastpostuserurl'] =  fetch_seo_url('member', array('userid' => $images['lastpostuserid'],	'username' => $images['lastimageusername']));
			$images['replies'] = vb_number_format($images['posts']);
		}
		else
		{
			$images['replies'] = 0;
			$images['lastpostdateline'] = 0;
		}
	}
	$images['url'] = construct_image_url($images, 'thumbname');

// nomore show sticky, we use images[sticky]	instead of $show['sticky'] = false;


	$show['subscribed'] = false;
	if ($images['subid'])
	{
		$show['subscribed'] = true;
	}

	$images['rating'] = '';
	if ($images['votetotal'] AND $images['votenum'])
	{
		$images['truerating'] = vb_number_format($images['votetotal'] / $images['votenum'], 2);
		$images['rating'] = round($images['truerating']);
	}
		


 		$templater = vB_Template::create($templatename);
		$templater->register('adv_sorturl', $adv_sorturl);
		// we rename tmpvars to ppg_vars so we dont register ALL ppg_vars
		$templater->register('ppg_vars', $tmpvars);

		$templater->register('images', $images);
		$templater->register('cellwidth', $cellwidth);
		$templater->register('catinfo', $catinfo);
		$templater->register('showfields', $showfields);

        $imagebits .= $templater->render(); 
	return $imagebits;
}

// ######################## Construct Empty Imagebits #########################
function construct_empty_cellbits($cells, $colspan = 0)
{
	global $counter, $ppg_options;

	$cellwidth = round(100 / $cells) . '%';

	if ($counter AND $counter != $cells)
	{
		for ($i = $counter; $i < $cells; $i++)
		{
			$emptycells .= '<td  ' . iif($colspan, 'colspan="' . $colspan . '"') . ' width="' . $cellwidth . '"></td>';
		}
	}
	return $emptycells;
}

// ############################ Construct Image URL ###########################
function construct_image_url($image, $filename = 'filename', $fulllink = false)
{
	global $ppg_options, $server, $userid;

    ($hook = vBulletinHook::fetch_hook('ppgal_construct_image_url')) ? eval($hook) : false;

	if (!in_array($image['extension'], array('gif', 'jpg', 'jpeg', 'png', 'psd', 'bmp')) OR ($filename == 'thumbname' AND !$image['thumbname']))
	{
		if ($fulllink){
			return '<a href="misc.php?' . $vbulletin->session->vars['sessionurl'] . 'do=downloadfile&amp;i=' . $image['imageid'] . '"><img alt="" border="0" src="' . $ppg_options['gallery_url'] . '/images/file_' . $image['extension'] . '.gif" /></a>';
		}else{
			return iif($filename == 'filename', $ppg_options['gallery_url'] . '/misc.php?do=downloadfile&amp;i=' . $image['imageid'], $ppg_options['gallery_url'] . '/images/file_' . $image['extension'] . '.gif');
		}
	}else{
		if ($fulllink){
			if ($filename == 'originalname'){
				$image['width'] = $image['originalwidth'];
				$image['height'] = $image['originalheight'];
			}

			return '<img title="' . $image['title'] . '" id="vbgbigimg" class="vbgbigimg" alt="' . $image['title'] . '" border="0" height="' . $image['height'] . '" src="' . iif($ppg_options['gallery_echoimage'], 'displayimage.php?' . $vbulletin->session->vars['sessionurl'] . 'imageid=' . $image['imageid'] . iif($filename == 'originalname', '&amp;original=1'), fetch_folder_url($image) . '/' . $image["$filename"]) . '" width="' . $image['width'] . '" />';

        }else{

            if ($server['upload'] AND $image['thumbname'] == $image['filename']){

            return $ppg_options['gallery_userfolderurl'] . '/' . $userid . '/' . $image["$filename"];

    			}
    			else if ($ppg_options['gallery_echoimage'] AND ($filename == 'filename' OR $filename == 'originalname'))
    			{
    				return $ppg_options['gallery_url'] . '/displayimage.php?imageid=' . $image['imageid'] . iif($filename == 'originalname', '&amp;original=1');
    			}else{

            return fetch_folder_url($image) . '/' . $image["$filename"];
			}
		}
	}
}

// ############################ Fetch Folder URL ################################
function fetch_folder_url($image, $foldersonly = '')
{
	global $ppg_options;

	if ($ppg_options['gallery_insafemode'])
	{
		return iif(!$foldersonly, $ppg_options['gallery_fileurl'], '');
	}

	return iif(!$foldersonly, $ppg_options['gallery_fileurl'] . '/') . implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY));
}

// ############################ Fetch Folder URL ################################
function fetch_folder_path($image, $foldersonly = '')
{
	global $ppg_options;

	if ($foldersonly OR $ppg_options['gallery_insafemode'])
	{
		return $ppg_options['gallery_filedirectory'] . iif($foldersonly, '/');
	}
	else
	{
		return $ppg_options['gallery_filedirectory'] . '/' . implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY));
	}
}

// #################### Check Image ID ##########################
function check_image_id($imageid)
{
	global $vbphrase, $vbulletin;

	if (!$imageid OR intval($imageid)<1)
	{
		if(defined("VBGLITE"))
		{
			vbglite_error();
		}
		standard_error(fetch_error('noid', $vbphrase['image'], $vbulletin->options['contactuslink'] ));
	}
}

// ############################## Delete Images ###############################
function delete_images($imageid, $imagearray = '')
{
	global $db, $vbulletin, $ppg_options;

	if (!empty($imagearray))
	{
		$imageids = array_keys($imagearray);
		$delimages = implode(',', $imageids);
	}
	else
	{
		$delimages = $imageid;

		$imagearray = array();
		$getimages = $db->query_first("SELECT catid, userid, filename, originalname, thumbname, posts FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");


		$imagearray["$imageid"]['catid'] = $getimages['catid'];
		$imagearray["$imageid"]['userid'] = $getimages['userid'];
		$imagearray["$imageid"]['filename'] = $getimages['filename'];
		$imagearray["$imageid"]['originalname'] = $getimages['originalname'];
		$imagearray["$imageid"]['thumbname'] = $getimages['thumbname'];
		$imagearray["$imageid"]['posts'] = $getimages['posts'];

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET imagecount = imagecount-1, postcount = postcount-" . intval($imagearray['posts']) . " WHERE catid = '$imagearray[catid]'");
	}

	if ($delimages)
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_rate WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_favorites WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_subscribeimage WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_exif WHERE imageid IN ($delimages)");

		$usercounts = array();
		

		foreach ($imagearray AS $imageid => $image)
		{
			
			$folderstring = fetch_folder_path($image);

			$usercounts["$image[userid]"]++;

			@unlink($folderstring . '/' . $image['filename']);

			if ($image['thumbname'])
			{
		  		@unlink($folderstring . '/' . $image['thumbname']);
			}
			if ($image['originalname'])
			{
		  		@unlink($folderstring . '/' . $image['originalname']);
			}
			
		}
		
		foreach ($usercounts AS $userid => $postremove)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user SET ppicount = ppicount-$postremove WHERE userid = '$userid'");
		}
    }

	($hook = vBulletinHook::fetch_hook('ppgal_delete_image')) ? eval($hook) : false;
	print "aaaaaaa";
	build_gallery_stats();
	print "bbbbb";
}

// ############################ Fetch Image Fields ############################
function fetch_image_fields()
{
	global $showfield, $show;

	$query['fields'] = ' ,images.userid, images.username';

	if (!empty($showfield))
	{
		foreach ($showfield AS $fields)
		{
			switch ($fields)
			{
				case 'category':
					break;
				case 'dimensions':
					$query['fields'] .= ' ,width, height, originalwidth, originalheight';
					break;
				case 'user':
					break;
				case 'filesize':
					$query['fields'] .= ' ,filesize, originalfilesize';
					break;
				case 'lastpost':
					$query['fields'] .= ', images.lastpostdateline, images.lastpostuserid, images.lastpostusername';
					break;
				case 'rating':
					$query['fields'] .= ', votenum, votetotal';
					break;
				default:
					$query['fields'] .= iif($fields, ', images.' . $fields);
			}
		}
	}

	if ($show['category'])
	{
		$query['fields'] .= ', categories.title AS cattitle';
		$query['tables'] .= 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_categories AS categories USING (catid)';
	}

	return $query;
}

// ############################ Construct Orderby #############################
function construct_orderby()
{
	global $orderby, $ppg_options, $direction;

	switch ($orderby)
	{
		case 'title':
		case 'dateline':
		case 'lastpostdateline':
		case 'imageid':
		case 'posts':
		case 'views':
		case 'username':
			return 'images.' . $orderby;
			break;
		case 'rating':
			return 'voteavg ' . $direction . ', votenum';
			break;
		default:
			return 'images.' . $ppg_options['gallery_deforder'];
	}
}

// ########################## Highlight Keywords #########################
function highlight_keywords($string, $keywords, $wholeword)
{
	if ($keywords)
	{
		$words = explode(' ', $keywords);

		foreach ($words as $word)
		{
			if ($wholeword)
			{
				$word = ' ' . $word . ' ';
			}
			$position = 0;

			while ($position !== false)
			{
				$position = strpos(strtolower($string), strtolower($word), $position);

				if ($position !== false)
				{
					$replace_string = '<span class="highlight">' . substr($string, $position, strlen($word)) . '</span>';

					$string = substr_replace($string, $replace_string, $position, strlen($word));

					$position += strlen($replace_string);
				}
			}
		}
	}
	return $string;
}

// ######################### Create Custom Fields #######################
function construct_custom_fieldbits($imageinfo = '', $custominfo = '', $editing = false, $admin = false, $makearray = false)
{

	global $db, $vbulletin, $vbphrase, $show, $stylevar;

	if (empty($custominfo))
	{
		$custominfo = array();
		$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields ORDER BY displayorder");
		while ($field = $vbulletin->db->fetch_array($customfields))
		{
			$custominfo[] = $field;
		}
		$db->free_result($customfields);
		unset($field);
	}

	if (!empty($custominfo))
	{
		foreach ($custominfo AS $field)
		{

			if (!$field['required'] AND $show['quickupload'])
			{
				continue;
			}
			$show['reqfield'] = ($field['required']) ? true :false;
			$fieldname = 'field' . $field['fieldid'];
			$fieldtype = ($show['reqfield']) ? 'req_field' : 'field';

			$fieldid = $fieldtype . $field['fieldid'] . iif($makearray, '[' . $imageinfo['imageid'] . ']');
			$fieldidname = 'field' . $field['fieldid'] . iif($makearray, '[' . $imageinfo['imageid'] . ']');
			if ($field['options'])
			{
				$field['options'] = explode("\n", $field['options']);
			}

			switch($field['type'])
			{
				case 'textarea':
					$inputbox = '<textarea id="' . $fieldid . '" class="textbox" cols="40" name="' . $fieldidname . '" rows="6">' . htmlspecialchars($imageinfo["$fieldname"]) . '</textarea>';
					break;

				case 'select':
					$imageinfo["$fieldname"] = htmlspecialchars($imageinfo["$fieldname"]);
					$inputbox = '<select  id="' . $fieldid . '"  name="' . $fieldidname . '">';
					$inputbox .= '<option value="">' . $vbphrase['please_select_one'] . '</option>';
					foreach ($field['options'] AS $option)
					{
						$option = trim($option);
						$inputbox .= '<option ' . iif($imageinfo["$fieldname"] == $option, 'selected="selected"') . ' value="' . $option . '">' . $option . '</option>';
					}
					$inputbox .= '</select>';
					break;

				case 'radio':

					$imageinfo["$fieldname"] = htmlspecialchars_uni($imageinfo["$fieldname"]);

					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<label for="' . $fieldid . '_' . $key . '"><input id="' . $fieldid . '_' . $key . '" name="' . $fieldidname . '" ' . iif($imageinfo["$fieldname"] == $option, 'checked="checked"') . ' type="radio" value="' . $option . '">' . $option . '</label>';
					}
					break;

				case 'checkbox':

					if (!is_array($imageinfo["$fieldname"]) AND !$editing)
					{
						$imageinfo["$fieldname"] = array();
					}
					if ($editing)
					{
						$imageinfo["$fieldname"] = explode(', ', $imageinfo["$fieldname"]);
					}

					$optarray = array();
					foreach ($imageinfo["$fieldname"] AS $okey => $ovalue)
					{
						$optarray[] = htmlspecialchars_uni($ovalue);
					}

					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<label for="' . $fieldid . '_' . $key . '">';
			
						$inputbox .= '<input id="' . $fieldid . '_' . $key . '" name="' . $fieldidname . '[]" ' . iif(in_array($option, $optarray), 'checked="checked"') . ' type="checkbox" value="' . $option . '">' . $option . '</label><br />';
					}
					break;

				default:

					$inputbox = '<input  id="' . $fieldid . '"  class="textbox" name="' . $fieldidname . '" size="40" type="text" value="' . $imageinfo["$fieldname"] . '" />';

			}

			if ($admin)
			{
				print_label_row($field['title'], $inputbox);
			}
			else
			{
				$templater = vB_Template::create('adv_gallery_upload_custombits');
				$templater->register('inputbox', $inputbox);
				$templater->register('field', $field);
				//eval('$cfbits .= "' . fetch_template('adv_gallery_upload_custombits') . '";');
				$cfbits .= $templater->render();
			}
			unset($inputbox);
		}
	}
	return $cfbits;
}

// ######################## Sort custom fields to insert into the db ####################
function construct_customfields_sql($postfields = '', $imageid, $add = true, $makearray = false)
{
	global $db, $vbulletin, $imageinfo, $catopts, $categorycache;

	if (!empty($catopts))
	{
		$catopts = construct_cat_opts($imageinfo['catid'], $categorycache["$imageinfo[catid]"]['options']);

		if ($catopts['allow_custom_links'])
		{
			require_once(DIR . '/includes/functions_newpost.php');
		}
	}

	$cfields = array();
	$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields");
	while ($custom = $vbulletin->db->fetch_array($customfields))
	{
		$cfields["$custom[fieldid]"] = $custom;
	}

	$db->free_result($customfields);
	unset($custom);

	if ($cfields)
	{
		foreach ($cfields AS $field => $values)
		{
			$thisfield = 'field' . $field;

			if ($makearray)
			{
				$fieldname = $postfields["$thisfield"]["$imageid"];
			}
			else
			{
				$fieldname = $postfields["$thisfield"];
			}
			if (strlen($fieldname) > $values['maxlength'] AND $values['maxlength'])
			{
				$fieldname = substr($fieldname, 0, $values['maxlength']);
			}

			if ($catopts['allow_custom_links'])
			{
				$fieldname = convert_url_to_bbcode($fieldname);
			}
			if (is_array($fieldname))
			{
				$fieldname = implode(', ', $fieldname);
			}

			if ($add)
			{
				$insert['fields'] .= ',' . $thisfield;
				$insert['values'] .= ', \'' . addslashes($fieldname) . '\'';
			}
			else
			{
				$insert['fields'] .= ', ' . $thisfield . ' = \'' . addslashes($fieldname) . '\'';
			}
		}
	}

	if ($add)
	{
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_customfields_entries (imgid $insert[fields]) VALUES ($imageid $insert[values])");
	}
	else if ($insert['fields'])
	{
		$insert['fields'] = substr($insert['fields'], 1);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_customfields_entries SET $insert[fields] WHERE imgid = '$imageid'");
	}
}

function trim_c($b='',$c=''){

	$a='<' . '!' . '-- ' . 'P' . 'ow' . chr(101) . 'r' . chr(101) . chr(100) . ' ' . 'b' . trim($xmsquar) . 'y P' . chr(104) . 'o' . chr(116) . 'o' . '' . 'p' . '' . chr(111). 's' . chr(116) . ' :: ' . $b . ' :: ' . $c . ' --' . '>';
	return $a;
}
// ############################ Category Jump #################################
function print_category_jump($dcatid = 0)
{
	global $catid, $ppg_options, $_REQUEST, $vbphrase, $stylevar, $gobutton;

	if (!$ppg_options['gallery_enablecatjump'])
	{
		return;
	}
	switch ($_REQUEST['do'])
	{
		case 'favorites':
			break;
		case 'subscriptions':
			break;
		case 'newimages':
			break;
		case 'popimages':
			break;
		case 'search':
			break;
	}

	$action = $_REQUEST['do'];

	if ($_REQUEST['do'] == 'searchresults')
	{
		$action = 'search';
	}

	$doselect["$action"] = 'class="fjsel" selected="selected"';

	$options = print_cat_select($dcatid, 'catjump');

	eval('$categoryjump = "' . fetch_template('adv_gallery_categoryjump') . '";');

	return $categoryjump;
}

// ################# Construct the navbits for browseimages ######################
function construct_dir_navbits($parentlist)
{
	global $categorycache, $vbulletin, $cnavbits, $navbits, $ppg_options, $vbphrase;

	foreach (array_reverse(explode(',', $parentlist)) AS $key => $parent)
	{
		$catid = $categorycache["$parent"]['catid'];
		if ($getusername)
		{
			if ($categorycache["$catid"]['username'])
			{
				$catusername = $categorycache["$catid"]['username'];
				$catuserid = $categorycache["$catid"]['catuserid'];
				if($ppg_options['gallery_use_plurals_s'])
				{
					$cnavbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$getusername&amp;u=$catuserid"] = construct_phrase($vbphrase['usernames_images'], $catusername, iif(substr($catusername, -1) != 's', $vbphrase['plural_s']));
				}
				else
				{
					$cnavbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$getusername&amp;u=$catuserid"] = construct_phrase($vbphrase['usernames_images'], $catusername,  $vbphrase['plural_s']);
				}
			}
			$getusername = '';
		}

		$cnavbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$catid"] = stripslashes($categorycache["$parent"]['title']);

		if ($categorycache["$catid"]['membercat'])
		{
			$getusername = $catid;
		}
	}

	if (!empty($cnavbits))
	{
		return array_merge(iif(!empty($navbits), $navbits, array()), $cnavbits);
	}
}

// ############################# Adv Sorting URL ##############################
function construct_adv_sort_url($extra = '')
{
	global $_REQUEST;

	if ($_REQUEST['c'])
	{
		$_REQUEST['catid'] = $_REQUEST['c'];
	}

	if (in_array($_REQUEST['do'], array('favorites', 'popimages', 'subscriptions','newimages', 'newposts', 'member')))
	{
		$adv_sorturl = '&amp;catid=' . htmlspecialchars_uni($_REQUEST['do']);
	}
	else if ($_REQUEST['do'] == 'searchresults')
	{
		if ($extra)
		{
			$_REQUEST['searchid'] = $extra;
		}
		$adv_sorturl = '&amp;catid=searchresults';
	}
	else if (in_array($_REQUEST['catid'], array('favorites', 'popimages', 'showcase', 'subscriptions', 'newimages', 'newposts', 'member')))
	{
		$adv_sorturl = '&amp;catid=' . htmlspecialchars_uni($_REQUEST['catid']);
	}
	else if ($_REQUEST['catid']  == 'searchresults' )
	{
		$sidstr = '';
		if (intval($_REQUEST['searchid']))
		{
			$sidstr = '&amp;searchid=' . intval($_REQUEST['searchid']);
		}
		$adv_sorturl = '&amp;catid=' . htmlspecialchars_uni($_REQUEST['catid']) . $sidstr;
	}
	else
	{
		if($_REQUEST['do'] != 'ecard')
		{
			$adv_sorturl = '&amp;c=' . htmlspecialchars_uni($_REQUEST['catid']);
		}
	}

	$ordby = false;
	if ($_REQUEST['orderby'])
	{
		$adv_sorturl .= '&amp;orderby=' . htmlspecialchars_uni($_REQUEST['orderby']);
		$ordby = true;
	}
	if (in_array($_REQUEST['direction'], array('DESC', 'ASC')) AND $ordby)
	{
		$adv_sorturl .= '&amp;direction=' . $_REQUEST['direction'];
	}
	if (intval($_REQUEST['searchid']))
	{
		$adv_sorturl .= '&amp;searchid=' . $_REQUEST['searchid'];
	}
	if (intval($_REQUEST['imageuser']))
	{
		$adv_sorturl .= '&amp;imageuser=' . $_REQUEST['imageuser'];
	}
	if ($_REQUEST['cutoffdate'])
	{
		$adv_sorturl .= '&amp;cutoffdate=' . htmlspecialchars_uni($_REQUEST['cutoffdate']);
	}
	if(isset($_REQUEST['userid']) AND intval($_REQUEST['userid'])>0)
	{
		$adv_sorturl .= '&amp;userid=' . $_REQUEST['userid'];
	}
	if ($_REQUEST['ltr'])
	{
		$adv_sorturl .= '&amp;ltr=' . htmlspecialchars_uni($_REQUEST['ltr']);
	}

	return $adv_sorturl;
}

// ###################### Initial Update Counters Function ##################
function update_count($catid = 0, $imagecounters = true, $postcounters = true, $licounters = true)
{
	global $db, $vbulletin;

	if ($catid)
	{
		$catquery = "WHERE catid = '$catid'";
	}

	$getcats = $db->query_read("SELECT catid FROM " . TABLE_PREFIX . "ppgal_categories $catquery");
	while ($cats = $vbulletin->db->fetch_array($getcats))
	{
		if ($licounters)
		{
			$llfields = ', title, dateline, username, userid';
		}
		$imageids = array();
		$getimages = $db->query_read("SELECT imageid $llfields FROM " . TABLE_PREFIX . "ppgal_images WHERE catid = '$cats[catid]' AND valid = 1 ORDER BY dateline DESC");
		$imagecount = $db->num_rows($getimages);
		$counter = 0;
		while ($images = $vbulletin->db->fetch_array($getimages))
		{
			$counter++;
			if ($counter == 1 AND $licounters)
			{
				$cats['lastimageid'] = $images['imageid'];
				
				$cats['lastimagedate'] = $images['dateline'];
				$cats['lastimageuser'] = $images['username'];
				$cats['lastimagetitle'] = $images['title'];
				$cats['lastimageuserid'] = $images['userid'];
			}
			$imageids[] = $images['imageid'];
		}
		$db->free_result($getimages);
		unset($images);

		$cats['imagecount'] = $imagecount;

		if (!empty($imageids) AND $postcounters)
		{
			$imageids = implode(',', $imageids);

			$pcounter = 0;
			$getposts = $db->query_read("
					SELECT postid, posts.userid, posts.username, posts.dateline, images.title
					FROM " . TABLE_PREFIX . "ppgal_posts AS posts
					LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (posts.imageid = images.imageid)
					WHERE posts.imageid IN ($imageids) AND visible = 1
					ORDER BY dateline DESC
			");
			$postcount = $db->num_rows($getposts);
			while ($posts = $vbulletin->db->fetch_array($getposts))
			{
				$pcounter++;
				if ($pcounter == 1)
				{
					$cats['lastpostid'] = $posts['postid'];
					$cats['lastpostuserid'] = $posts['userid'];
					$cats['lastpostusername'] = $posts['username'];
					$cats['lastpostdateline'] = $posts['dateline'];
					$cats['lastpostimagetitle'] = $posts['title'];
				}

				$postids[] = $posts['postid'];
			}
			$db->free_result($getposts);
			unset($posts, $imageids);
			$cats['pcount'] = $postcount;
			
		}
		else
		{
			$cats['pcount'] = 0;
		}

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET " . iif($imagecounters, "imagecount = '$cats[imagecount]'") . "" . iif($postcounters, "" . iif($imagecounters, ',') . "postcount = '$cats[pcount]' ") . " " . iif($licounters, "" . iif($postcounters OR $imagecounters, ',') . "lastimageid = '$cats[lastimageid]', lastimagedateline = '$cats[lastimagedate]', lastimagetitle = '" . addslashes($cats['lastimagetitle']) . "', lastimageusername = '" . addslashes($cats['lastimageuser']) . "', lastimageuserid = '$cats[lastimageuserid]'") . " ,lastpostid = '$cats[lastpostid]', lastpostuserid = '$cats[lastpostuserid]', lastpostusername = '" . addslashes($cats['lastpostusername']) . "', lastpostdateline = '$cats[lastpostdateline]', lastpostimagetitle = '" . addslashes($cats['lastpostimagetitle']) . "'
 		WHERE catid = '$cats[catid]' AND hasimages = 1");
	}
	($hook = vBulletinHook::fetch_hook('ppgal_update_count')) ? eval($hook) : false;
}


// ###################### Lite Update Counters Function ##################
function update_count_lite($catid = 0, $imagecounters = true, $postcounters = true, $licounters = true)
{
	global $db, $vbulletin;

	if($catid)
	{
		$catquery = "WHERE catid = '$catid'";
	}
	// first get the cats
	$getcats = $db->query_read("SELECT catid, hasimages FROM " . TABLE_PREFIX . "ppgal_categories $catquery");
	while($cats = $db->fetch_array($getcats))
	{
		if($cats['hasimages'] != 1)
		{
			continue;
		}
		if ($licounters)
		{
			$llfields = ', title, dateline, username, userid';
		}
		//count images in cat
		$imagecount = 0;
		$imgcount = $db->query_first("SELECT COUNT(imageid) AS imgcount FROM " . TABLE_PREFIX . "ppgal_images WHERE catid = '$cats[catid]' AND valid = 1");
		$imagecount = $imgcount['imgcount'];

		// get last image
		if($imagecount > 0)
		{
			$images = $db->query_first("SELECT imageid $llfields FROM " . TABLE_PREFIX . "ppgal_images WHERE catid = '$cats[catid]' AND valid = 1 ORDER BY dateline DESC");

			if ($licounters)
			{
				$cats['lastimageid'] = $images['imageid'];
				$cats['lastimagedate'] = $images['dateline'];
				$cats['lastimageuser'] = $images['username'];
				$cats['lastimagetitle'] = $images['title'];
				$cats['lastimageuserid'] = $images['userid'];
			}
		}

		$cats['imagecount'] = $imagecount;

		// last posts
		$postcount = 0;
		if ($postcounters)
		{
			// get the amount of posts in cat
			
			$imgpostcount = $db->query_first("
				SELECT COUNT(postid) AS postcount 
				FROM " . TABLE_PREFIX . "ppgal_posts AS posts
				LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (posts.imageid = images.imageid)
			
				WHERE images.catid = '$cats[catid]' AND images.valid = 1 AND posts.visible = 1
			");
			$postcount = $imgpostcount['postcount'];


			// get last image
			if($postcount > 0)
			{
				$posts = $db->query_first("

					SELECT postid, posts.userid, posts.username, posts.dateline, images.title
					FROM " . TABLE_PREFIX . "ppgal_posts AS posts
					LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (posts.imageid = images.imageid)
					WHERE images.catid = '$cats[catid]' AND images.valid = 1 AND posts.visible = 1
					ORDER BY dateline DESC

				");

				$cats['lastpostid'] = $posts['postid'];
				$cats['lastpostuserid'] = $posts['userid'];
				$cats['lastpostusername'] = $posts['username'];
				$cats['lastpostdateline'] = $posts['dateline'];
				$cats['lastpostimagetitle'] = $posts['title'];
			}
		}
		$cats['pcount'] = $postcount;

		$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET " . iif($imagecounters, "imagecount = '$cats[imagecount]'") . "" . iif($postcounters, "" . iif($imagecounters, ',') . "postcount = '$cats[pcount]' ") . " " . iif($licounters, "" . iif($postcounters OR $imagecounters, ',') . "lastimageid = '$cats[lastimageid]', lastimagedateline = '$cats[lastimagedate]', lastimagetitle = '" . $db->escape_string($cats['lastimagetitle']) . "', lastimageusername = '" . $db->escape_string($cats['lastimageuser']) . "', lastimageuserid = '$cats[lastimageuserid]'") . " ,lastpostid = '$cats[lastpostid]', lastpostuserid = '$cats[lastpostuserid]', lastpostusername = '" . $db->escape_string($cats['lastpostusername']) . "', lastpostdateline = '$cats[lastpostdateline]', lastpostimagetitle = '" . $db->escape_string($cats['lastpostimagetitle']) . "'
 		WHERE catid = '$cats[catid]' AND hasimages = 1");
	}


	($hook = vBulletinHook::fetch_hook('ppgal_update_count')) ? eval($hook) : false;
}


// ########################## Validate New Images #############################
function validate_new_images($validateimage)
{
	global $db, $vbulletin, $ppg_options, $email, $dateline, $username, $userid, $title, $desc, $catid, $keywords, $views, $sendmail, $validateimage, $notes, $imagecat, $thumbname, $filename;

	if (is_array($validateimage))
	{
		$deletearray = array();
		foreach ($validateimage AS $key => $val)
		{
			if ($validateimage["$key"] == 3)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET valid = 0 WHERE imageid = '$key'");
			}
			if ($validateimage["$key"] == 2)
			{
				$deletearray["$key"]['catid'] = $catid["$key"];
				$deletearray["$key"]['filename'] = $filename["$key"];
				$deletearray["$key"]['thumbname'] = $thumbname["$key"];
				$deletearray["$key"]['userid'] = $userid["$key"];

				if ($sendmail["$key"] AND !empty($email["$key"]))
				{
					$mailusername = $username["$key"];
					$imagetitle = $title["$key"];
					$imageid = $key;

					eval(fetch_email_phrases('adv_gallery_deletion'));

					vbmail($email["$key"], $subject, $message);
				}
			}
			if ($validateimage["$key"] == 1)
			{

				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET title = '" . $vbulletin->db->escape_string($title["$key"]) . "', description = '" . $vbulletin->db->escape_string($desc["$key"]) . "', keywords = '" . $vbulletin->db->escape_string($keywords["$key"]) . "', views = '$views[$key]', catid = '$catid[$key]', notes = '" . $vbulletin->db->escape_string($notes["$key"]) . "', valid = 1 WHERE imageid = '$key'");

				construct_customfields_sql($_POST, $key, false, true);

				if ($sendmail["$key"] AND !empty($email["$key"]))
				{
					$mailusername = $username["$key"];
					$imagetitle = $title["$key"];
					$imageid = $key;

					eval(fetch_email_phrases('adv_gallery_validation'));

					vbmail($email["$key"], $subject, $message);
				}

				$cat = $db->query_first("SELECT lastimagedateline FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid[$key]'");

				if ($dateline["$key"] > $cat['lastimagedateline'])
				{
					$extrafields = ", lastimageid = '$key', lastimageusername = '" . addslashes($username["$key"]) . "', lastimagetitle = '" . addslashes(htmlspecialchars($title["$key"])) . "', lastimageuserid = '$userid[$key]', lastimagedateline = '$dateline[$key]'";
				}

				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET imagecount = imagecount+1 $extrafields WHERE catid = '$catid[$key]'");

                // Update user post counts
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user SET ppicount = ppicount+1 WHERE userid = '$userid[$key]'");
			}
		}
		if (!empty($deletearray))
		{
			delete_images('', $deletearray);
		}
	}
($hook = vBulletinHook::fetch_hook('ppgal_validate_image')) ? eval($hook) : false;
}

// ####################### Validate New Posts ######################
function validate_new_posts()
{
	global $db, $vbulletin, $ppg_options, $title, $message, $validatepost, $catid, $imageid, $userid, $username, $dateline, $imagetitle;

	if (is_array($validatepost))
	{
		foreach ($validatepost AS $key => $val)
		{
			if ($validatepost["$key"] == 2)
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_posts WHERE postid = '$key'");
			}

			if ($validatepost["$key"] == 1)
			{

				// Update image info
				$image = $db->query_first("SELECT lastpostdateline FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid[$key]'");
				if ($image['lastpostdateline'] < $dateline["$key"])
				{
					$lastpostquery = ", lastpostuserid = '$userid[$key]', lastpostusername = '" . addslashes($username["$key"]) . "', lastpostdateline = '$dateline[$key]'";
				}
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET posts = posts+1 $lastpostquery WHERE imageid = '$imageid[$key]'");
            $db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_posts SET visible = 1 WHERE postid = '$key'");
				// Send email to subscribed users
				send_subscribed_posts($imageid["$key"], true, $userid["$key"], $username["$key"], $message["$key"]);

				// Update image info
                $cat = $db->query_first("SELECT lastpostdateline FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid[$key]'");
				if ($cat['lastpostdateline'] < $dateline["$key"])
				{
					$lastpostcatquery = ", lastpostid = '$key', lastpostuserid = '$userid[$key]', lastpostusername = '" . addslashes($username["$key"]) . "', lastpostdateline = '$dateline[$key]', lastpostimagetitle = '" . addslashes($imagetitle[$key]) . "'";
				}

				// Update directory info
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET postcount = postcount+1 $lastpostcatquery WHERE catid = '$catid[$key]'");

                $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_posts SET visible = 1 WHERE postid = '$key'");
			}
		}
	}
($hook = vBulletinHook::fetch_hook('ppgal_validate_post')) ? eval($hook) : false;
}

// ############################# Subscribed Posts #########################
function send_subscribed_posts($imageid, $moderation = false, $userid = '', $username = '', $message = '')
{
	global $db, $vbulletin, $ppg_options, $post;

	if ($ppg_options['gallery_allowsubscribe'])
	{
		$image = $db->query_first("
                SELECT images.imageid, images.title, posts.dateline, categories.title AS cattitle
                FROM " . TABLE_PREFIX . "ppgal_images AS images
                LEFT JOIN " . TABLE_PREFIX . "ppgal_posts AS posts USING (imageid)
                LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (images.catid = categories.catid)
                WHERE images.imageid = '$imageid' ORDER BY dateline DESC LIMIT 1
        ");

		if (!$moderation)
		{
			$userid = $vbulletin->userinfo['userid'];
		}
		else
		{
			$post['message'] = $message;
			$vbulletin->userinfo['username'] = $username;
		}

		$image['title'] = stripslashes($image['title']);
		$image['category'] = stripslashes($image['cattitle']);

		$subscriptions = $db->query_read("
				SELECT subscriptions.userid, username, email
				FROM " . TABLE_PREFIX . "ppgal_subscribeimage AS subscriptions
				INNER JOIN " . TABLE_PREFIX . "user AS user USING (userid)
				WHERE imageid = '$imageid' AND user.lastactivity > '$image[dateline]' AND subscriptions.userid != '$userid'
		");
		while ($subscription = $vbulletin->db->fetch_array($subscriptions))
		{
			eval(fetch_email_phrases('adv_gallery_subscribe_image'));
			vbmail($subscription['email'], $subject, $message);
		}
		$db->free_result($subscriptions);
		unset($subscription);
	}
}

// ############################ Fetch Page Data ###############################
function fetch_page_data($script)
{
	global $db, $ppg_options, $condition, $pparray, $wherequery, $_REQUEST, $search;

	if ($_REQUEST['do'] != 'searchresults' OR $_REQUEST['do'] == 'searchresults' AND sizeof($wherequery) > 1)
	{
	  $pagedata = $db->query_first("
	  		SELECT COUNT(*) AS count
	  		FROM " . TABLE_PREFIX . $condition['fromtable'] . "
	  		" . iif($condition[join], 'LEFT JOIN ' . TABLE_PREFIX . $condition['join'] . ' USING (imageid)') . "
	  		" . iif(!empty($wherequery), 'WHERE ' . implode(' AND ', $wherequery)) . "
	  ");
	}
	else
	{
		$pagedata['count'] = $search['numresults'];
	}

	$pagedata['pagenumber'] = intval($_REQUEST['page']);

	// Work out pages & limits
	if (!$pagedata['pagenumber'])
	{
		$pagedata['pagenumber'] = 1;
	}

	if ($script == 'browseimages')
	{
		if ($script != 'gallery_mod')
    {
		if (intval($_REQUEST['perpage']))
		{
			set_bbarray_cookie('gallery_perpage', 1, $_REQUEST['perpage'], 1);
		}

		if (fetch_bbarray_cookie('gallery_perpage', 1))
		{
			$pagedata['perpage'] = fetch_bbarray_cookie('gallery_perpage', 1);
		}
	}
	}

	if (!intval($pagedata['perpage']) OR ($script == 'browseimages' AND !in_array($pagedata['perpage'], $pparray)))
	{
	  $pagedata['perpage'] = $ppg_options['gallery_imagesperpage'];
	}

	$pagedata['minlimit'] = intval(($pagedata['pagenumber'] - 1) * $pagedata['perpage'] + 1);
	$pagedata['maxlimit'] = intval($pagedata['pagenumber'] * $pagedata['perpage']);

	if ($pagedata['maxlimit'] > $pagedata['count'])
	{
		$pagedata['maxlimit'] = $pagedata['count'];
		if ($pagedata['minlimit'] > $pagedata['count'])
		{
		  $pagedata['minlimit'] = $pagedata['count'] - $pagedata['perpage'];
		}
	}
	if ($pagedata['minlimit'] <= 0)
	{
	  $pagedata['minlimit'] = 1;
	}

	$pagedata['pagecount'] = ceil($pagedata['count'] / $pagedata['perpage']);

	return $pagedata;
}

function empty_category($catid)
{
	global $db, $vbulletin;

	$deletearray = array();
	$images = $db->query_read("SELECT imageid, userid, filename, thumbname, originalname FROM " . TABLE_PREFIX . "ppgal_images WHERE catid = '$catid'");
	while ($image = $vbulletin->db->fetch_array($images))
	{
		$deletearray["$image[imageid]"]['catid'] = $catid;
		$deletearray["$image[imageid]"]['userid'] = $image['userid'];
		$deletearray["$image[imageid]"]['filename'] = $image['filename'];
		$deletearray["$image[imageid]"]['thumbname'] = $image['thumbname'];
		$deletearray["$image[imageid]"]['originalname'] = $image['originalname'];
	}
	$db->free_result($images);
	unset($image);
	if (is_array($deletearray))
	{
		delete_images('', $deletearray);
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET imagecount = 0, postcount = 0, catimage = '', lastpostusername = '', lastimageid = '', lastimagetitle = '', lastimageuserid = '', lastimageusername = '', lastimagedateline = '', lastpostid = '', lastpostimagetitle = '', lastpostuserid = '', lastpostusername = '', lastpostdateline = '' WHERE catid = '$catid'");

}

// ############################# Delete Category ##############################
function delete_category($catid)
{
	global $db, $ppg_options, $vbulletin;

	$getcatids = fetch_category_children($catid);
	
	$catids = implode(',', $getcatids);

	$deletearray = array();
	$images = $db->query_read("SELECT imageid, catid, userid, filename, originalname, thumbname FROM " . TABLE_PREFIX . "ppgal_images WHERE catid IN($catids)");
	while ($image = $vbulletin->db->fetch_array($images))
	{
		$deletearray["$image[imageid]"]['catid'] = $image['catid'];
		$deletearray["$image[imageid]"]['userid'] = $image['userid'];
		$deletearray["$image[imageid]"]['filename'] = $image['filename'];
		$deletearray["$image[imageid]"]['thumbname'] = $image['thumbname'];
		$deletearray["$image[imageid]"]['originalname'] = $image['originalname'];
	}
	$db->free_result($images);
	unset($image);
	
	if (is_array($deletearray) AND !empty($deletearray))
	{
		delete_images('', $deletearray);
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid IN($catids)");

($hook = vBulletinHook::fetch_hook('ppgal_delete_category')) ? eval($hook) : false;

update_category_cache();
}

// ######## Update child categories display order of a parent by title ( A,B,C order ) ##############
function update_category_displayorder($catid)
{
$getcats = $db->query_read("
        SELECT title, displayorder
        FROM " . TABLE_PREFIX . "ppgal_categories
        WHERE parent = '$catid'
        ORDER BY title ASC
");
	while ($category = $vbulletin->db->fetch_array($getcats))
	{
    $count = $count + 10;
      $db->query_write("
          UPDATE " . TABLE_PREFIX . "ppgal_categories
          SET displayorder = '$count'
          WHERE title = '" . addslashes($category[title]) . "'
          AND parent = '$catid'
      ");
	}

	$db->free_result($getcats);
	unset($category);
	update_category_cache();
}

// ########################### Find Category Children #########################
function fetch_category_children($cat = 0)
{
	global $categorycache;

	$getcatarray = construct_categories($categorycache, $cat);
	$catarray = array();
	$catarray[] = $cat;
	if (!empty($getcatarray))
	{
		foreach ($getcatarray AS $cats)
		{
			$catarray[] = $cats['catid'];
		}
	}
	return $catarray;
}


// ##################### Check Image Viewing Permissions ######################
function check_image_view($image, $scriptname = 'showimage')
{
	global $categoryperms, $categorycache, $vbulletin;

	check_image_id($image['imageid']);

	if (empty($categoryperms))
	{
		$categoryperms = fetch_category_perms();
	}

	if (!$categoryperms["$image[catid]"]['canviewlargimage'])
	{
		if(defined("VBGLITE"))
		{
			vbglite_error();
		}
		print_no_permission();
	}

	if ($categorycache["$image[catid]"]['catuserid'] AND !is_category_mod($image['catid']) AND $categorycache["$image[catid]"]['catuserid'] != $vbulletin->userinfo['userid'] AND (!$categorycache["$image[catid]"]['membercat'] OR $categorycache["$image[catid]"]['membercat'] AND $image['userid'] != $vbulletin->userinfo['userid']))
	{
		$useroptions = construct_cat_user_opts($image['catid'], $categorycache["$image[catid]"]['useroptions']);
		if (!$useroptions['allow_view'])
		{
			if(defined("VBGLITE"))
			{
				vbglite_error();
			}
			print_no_permission();
		}
	}

	check_category_password($image['catid'], true, $scriptname);
}

// ######################## Construct Replacement Array #######################
if (!function_exists('construct_replacement_array'))
{
	function construct_replacement_array($optreplace, $replacearray)
	{
		global $vbulletin;
		if (!empty($optreplace))
		{
			foreach ($optreplace AS $filename)
			{
				if (trim($filename))
				{
					$replacearray['find'][] = '"' . $filename;
					$replacearray['replace'][] = '"' . $vbulletin->options['bburl'] . '/' . $filename;
				}
			}
		}
		return array_merge((array)$optreplace, (array)$replacearray);
	}
}

// ######################### Fetch Ignored Userids ############################
function fetch_ignored_users($catid = 0)
{
	global $vbulletin;
	$ignusers = array();
	if (!is_category_mod($catid))
	{
		$ignusers = fetch_coventry();
	}
	if ($vbulletin->userinfo['ignorelist'])
	{
		$ignusers = array_merge((array)$ignusers, (array)explode(' ', $vbulletin->userinfo['ignorelist']));
	}

	if (!empty($ignusers))
	{
		return implode(',', $ignusers);
	}
}

// ####################### Update Stats Cache ##############################

function build_gallery_stats()
{
	// to make function work correctly..
	// $vbulletin->$db->free_result does not work!!!!! stops function without errors
	// remmed it out, does not make big diff, but I would like to understand..

	global $vbulletin;
	$totalcache = array();
	$totalcache1 = array();
	$totalcache2 = array();
	$totalcache3 = array();

    $timages = $vbulletin->db->query_read("
        SELECT COUNT(imageid) AS images,
        SUM(views) AS views,
        SUM(posts) AS posts,
        SUM(filesize) AS filesize,
        SUM(originalfilesize) AS origfilesize
        FROM " . TABLE_PREFIX . "ppgal_images
    ");

    while ($timage = $vbulletin->db->fetch_array($timages))
    {
       $totalcache1[] = $timage;
    }

	//$vbulletin->$db->free_result($timages);
	unset($timage);


    $tcats = $vbulletin->db->query_read("
        SELECT COUNT(catid) AS categories,
        SUM(membercat) AS membercat
        FROM " . TABLE_PREFIX . "ppgal_categories
    ");

    while ($tcat = $vbulletin->db->fetch_array($tcats))
    {
       $totalcache2[] = $tcat;
    }
	//$vbulletin->$db->free_result($tcats);
	unset($tcat);
    $tcards = $vbulletin->db->query_read("
        SELECT COUNT(cardid) AS cards
        FROM " . TABLE_PREFIX . "ppgal_ecards
    ");

    while ($tcard = $vbulletin->db->fetch_array($tcards))
    {
       $totalcache3[] = $tcard;
    }
	//$vbulletin->$db->free_result($tcards);
	unset($tcard);
	$totalcache = array_merge((array)$totalcache1, (array)$totalcache2, (array)$totalcache3);

	($hook = vBulletinHook::fetch_hook('ppgal_build_stats')) ? eval($hook) : false;

	build_datastore('ppg_stats', serialize($totalcache), 1);

}


($hook = vBulletinHook::fetch_hook('ppgal_func_complete')) ? eval($hook) : false;
?>