<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: gallery_stats.php                                                ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

if (!is_object($vbulletin->db))
{
	exit;
}

// all these stats are for that day
$timestamp = TIMENOW - 3600 * 23;

$month = date('n', $timestamp);
$day = date('j', $timestamp);
$year = date('Y', $timestamp);

$timestamp = mktime(0, 0, 0, $month, $day, $year);

// new e-cards
$newecard = $vbulletin->db->query_first("SELECT COUNT(cardid) AS total FROM " . TABLE_PREFIX . "ppgal_ecards WHERE dateline >= " . $timestamp);
$newecard['total'] = intval($newecard['total']);

// new images
$newimages = $vbulletin->db->query_first("SELECT COUNT(imageid) AS total FROM " . TABLE_PREFIX . "ppgal_images WHERE dateline >= " . $timestamp);
$newimages['total'] = intval($newimages['total']);

// new posts
$newposts = $vbulletin->db->query_first("SELECT COUNT(postid) AS total FROM " . TABLE_PREFIX . "ppgal_posts WHERE dateline >= " . $timestamp);
$newposts['total'] = intval($newposts['total']);

/*insert query*/
$vbulletin->db->query_write("
	INSERT IGNORE INTO " . TABLE_PREFIX . "ppgal_stats
		(dateline, necard, nimage, npost)
	VALUES
		($timestamp, $newecard[total], $newimages[total], $newposts[total])
");

log_cron_action('', $nextitem, 1);
?>