<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: adminfunctions_gallery.php                                       ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('LOCATION_BYPASS', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################



// #############################################################################
/**
* Recalculates forum parent and child lists, then saves them back to the forum table
*/
function build_category_genealogy()
{
	global $vbulletin;
	if (empty($vbulletin->gallery_c_cache))
	{
		return;
	}

	// build parent/child lists
	foreach ($vbulletin->gallery_c_cache AS $catid => $cat)
	{
		// parent list
		$i = 0;
		$curid = $catid;

		//$vbulletin->gallery_c_cache["$catid"]['parentlist'] = '';


		// child list
		$vbulletin->gallery_c_cache["$catid"]['childlist'] = $catid;
		fetch_forum_child_list($catid, $catid);
		$vbulletin->gallery_c_cache["$catid"]['childlist'] .= ',-1';
	}


	$childsql = '';
	foreach ($vbulletin->gallery_c_cache AS $catid => $cat)
	{
		$childsql .= "	WHEN $catid THEN '$cat[childlist]'
		";
	}

	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "ppgal_categories SET

			childlist = CASE catid
				$childsql
				ELSE childlist
			END
	");
}


// ####################### Update Settings Cache ##############################
function build_adv_settings()
{
	global $db, $vbulletin;

	$adv_options = array();
	$settings = $db->query_read("SELECT varname, value FROM " . TABLE_PREFIX . "ppgal_setting");
	while ($setting = $db->fetch_array($settings))
	{
		$adv_options["$setting[varname]"] = $setting['value'];
	}
	$db->free_result($settings);
	unset($setting);

	build_datastore('adv_gallery_opt',serialize($adv_options),1);
}

// ########################## Update Moderator Cache ##########################
function update_gallery_mod_cache()
{
	global $db;
	$getmods = $db->query_read("SELECT * FROM " . TABLE_PREFIX ."ppgal_moderator ORDER BY catid, username");
	while ($moderators = $db->fetch_array($getmods))
	{
		$mods[] = $moderators;
	}
	build_datastore('gal_mod_cache',serialize($mods),1);
	$db->free_result($getmods);
	unset($moderators, $mods);
}

// ######################## Make Category Select Field ########################
function print_category_select($selectname, $selectedid = 0, $nonevalue = 'None', $title = '', $disablecat = false, $nonele = 0, $dowidth = false)
{
	global $catselect, $categorycache;

  echo '<tr class="' . fetch_row_bgclass() . '" valign="top">';
  echo '<td>' . $title . '</td>';
  echo '<td>';

  echo '<select class="bginput" name="' . $selectname . '" size="1">';
	if ($nonevalue)
	{
	  echo '<option value="' . $nonele . '">' . $nonevalue . '</option>';
	}

	if (empty($catselect))
	{
		$catselect = construct_categories($categorycache, 0, -1);
	}

	foreach ($catselect as $cats)
	{
    $dashes = str_repeat(' &nbsp; &nbsp; ', $cats['level'] - 1);
		$selected = '';
		if ($selectedid == $cats['catid'])
		{
			$selected = 'selected="selected"';
			$class = 'fjsel';
		}
		elseif ($cats['level'] <= 4)
		{
			$class = 'fjdpth' . $cats['level'];
		}
		else
		{
			$class = 'fjdpth';
		}

		$options .= '<option class="' . $class . '" value="' . $cats['catid'] . '" ' . $selected . '>' . $dashes . '' . stripslashes($cats['title']) . '</option>';
	}

	echo $options;

  echo '</select>';
 	echo '</td></tr>';
	unset($options);
}

// ###################### Print Category Permissions Rows #####################
function print_category_perm_rows($catinfo, $cat = 0)
{
	global $counter, $vbulletin, $vbphrase, $categories, $hasperms;

	if ($catinfo)
	{
		$catarray = array();
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$categories .= '<ul class="lsq"><li><b>' . $cats['title'] . '</b> <span class="smallfont">( <a href="vba_gallery_admin.php?do=resetperms&amp;catid=' . $cats['catid'] . '">[Reset]</a> <a href="vba_gallery_admin.php?do=denyperms&amp;catid=' . $cats['catid'] . '">[Deny All]</a> )</li>';
				$categories .= '<ul class="usergroups">';

				foreach ($vbulletin->usergroupcache AS $group)
				{
					if ($hasperms["$group[usergroupid]"]["$cats[catid]"])
					{
						$categories .= '<li class="col-c">[<a href="vba_gallery_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
					}
					else if ($hasperms["$group[usergroupid]"]["$cats[parent]"])
					{
						$hasperms["$group[usergroupid]"]["$cats[catid]"] = true;
						$categories .= '<li class="col-i">[<a href="vba_gallery_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';

					}
					else
					{
						$categories .= '<li>[<a href="vba_gallery_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
					}
				}

				$categories .=  '</ul><br />';

				print_category_perm_rows($catinfo, $cats['catid']);
				$categories .=  '</ul>';
				$counter--;
			}
		}
	}
	return $categories;
}

// ######################## Print Permission Rows #############################
function print_permission_rows($category)
{
	global $vbphrase, $perms, $usergroup, $u;

	print_description_row($vbphrase['general_options'], 0, 2, 'thead');
	print_yes_no_row(iif($category, $vbphrase['can_view_category'], $vbphrase['can_view_gallery']), 'usergroup[canviewgallery]', $perms['canviewgallery'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_view_thumbnails'], 'usergroup[canviewimages]', $perms['canviewimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_view_large_images'], 'usergroup[canviewlargimage]', $perms['canviewlargimage'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_view_original_images'], 'usergroup[canvieworiginal]', $perms['canvieworiginal'], iif($category, 'js_set_custom();'));
    if (!$category)
  	{
    print_yes_no_row($vbphrase['can_view_forumhome_block'], 'usergroup[canviewforumhomeblock]', $perms['canviewforumhomeblock'], iif($category, 'js_set_custom();'));
    print_yes_no_row($vbphrase['can_view_profile_tab'], 'usergroup[canviewprofiletab]', $perms['canviewprofiletab'], iif($category, 'js_set_custom();'));
    print_yes_no_row($vbphrase['can_view_profile_block'], 'usergroup[canviewprofileblock]', $perms['canviewprofileblock'], iif($category, 'js_set_custom();'));


      // If usergroup = 1 (guest) do not allow  can_change_profile_settings
    if ($u != '1')
	{
		$vbphrase['can_use_multiedit'] = 'Can use Multieditor';
		print_yes_no_row($vbphrase['can_change_profile_settings'], 'usergroup[canchangprofile]', $perms['canchangprofile'], iif($category, 'js_set_custom();'));
		print_yes_no_row($vbphrase['can_use_multiedit'], 'usergroup[canusemultiedit]', $perms['canusemultiedit'], iif($category, 'js_set_custom();'));
    }else{

        construct_hidden_code('usergroup[canchangprofile]', '0');
        construct_hidden_code('usergroup[canusemultiedit]', '0');
      }
    }
	print_yes_no_row($vbphrase['moderate_this_groups_images'], 'usergroup[moderateimages]', $perms['moderateimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['moderate_this_groups_posts'], 'usergroup[moderateposts]', $perms['moderateposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_rate_images'], 'usergroup[canrateimages]', $perms['canrateimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_search_images'], 'usergroup[cansearchimages]', $perms['cansearchimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_send_images_friend'], 'usergroup[cansendimagetofriend]', $perms['cansendimagetofriend'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_send_ecards'], 'usergroup[cansendecard]', $perms['cansendecard'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_create_categories'], 'usergroup[cancreatecategories]', $perms['cancreatecategories'], iif($category, 'js_set_custom();'));

	if ($category){
		print_yes_no_row($vbphrase['can_upload_images'], 'usergroup[canuploadimages]', $perms['canuploadimages'], 'js_set_custom();');
	}else{
		print_input_row($vbphrase['maxumum_user_categories'], 'usergroup[gallery_maxcats]', $usergroup['gallery_maxcats'], iif($category, 'js_set_custom();'));
	}

	if (!$category)
	{
		print_description_row($vbphrase['uploading_options'], 0, 2, 'thead');
		print_yes_no_row($vbphrase['can_upload_images'], 'usergroup[canuploadimages]', $perms['canuploadimages']);
		print_yes_no_row($vbphrase['can_upload_images_from_server'], 'usergroup[canuploadfromserver]', $perms['canuploadfromserver']);
		print_yes_no_row($vbphrase['can_upload_as_other_users'], 'usergroup[canuploadasuser]', $perms['canuploadasuser']);
		print_input_row($vbphrase['space_images_may_consume'], 'usergroup[gallery_maxdiskspace]', $usergroup['gallery_maxdiskspace']);
	}

	print_description_row($vbphrase['image_editing_options'], 0, 2, 'thead');
	print_yes_no_row($vbphrase['can_edit_own_images'], 'usergroup[caneditimages]', $perms['caneditimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_own_images'], 'usergroup[candelete]', $perms['candelete'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_edit_others_images'], 'usergroup[caneditothersimages]', $perms['caneditothersimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_others_images'], 'usergroup[candeleteothers]', $perms['candeleteothers'], iif($category, 'js_set_custom();'));

	print_description_row($vbphrase['posting_options'], 0, 2, 'thead');
	print_yes_no_row($vbphrase['can_view_replies_to_images'], 'usergroup[canviewreplies]', $perms['canviewreplies'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_reply_to_images'], 'usergroup[canreplytoimages]', $perms['canreplytoimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_edit_own_posts'], 'usergroup[caneditposts]', $perms['caneditposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_own_posts'], 'usergroup[candeleteposts]', $perms['candeleteposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_edit_others_posts'], 'usergroup[caneditothersposts]', $perms['caneditothersposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_others_posts'], 'usergroup[candeleteothersposts]', $perms['candeleteothersposts'], iif($category, 'js_set_custom();'));

}

// ############################## Orphaned Files ##############################
function fetch_orphaned_files($dirname, $location = '')
{
	global $filenamecache, $folders, $ppg_options, $ofiles, $fcount;

	if (is_dir($dirname))
	{
		if ($dh = @opendir($dirname))
		{
			$userid = str_replace('/', '', $location);
			while (($filename = @readdir($dh)) !== false)
			{
				if (!in_array($filename, array('.', '..', 'index.html', '.htaccess', '.htpassword')))
				{
					$fcount++;
					if (is_dir($dirname . '/' . $filename))
					{
						fetch_orphaned_files($dirname . '/' . $filename, $location . '/' . $filename);
					}
					else
					{
						$ofiles[] = $location . '/' . $filename;
					}
				}
			}
		}
	}
	return $ofiles;
}


// ######################### Print Settings ###########################
function print_adv_setting_group($grouptitle, $revert = 1)
{
	global $settingscache, $grouptitlecache, $debug, $session, $vbphrase, $settingphrase, $stylevar, $categorycache;

	print_table_header(
		$settingphrase["settinggroup_$grouptitlecache[$grouptitle]"]
		 . iif($debug AND !$revert,
		 	'<span class="normal">' .
			construct_link_code($vbphrase['edit'], "vba_gallery_admin.php?$session[sessionurl]do=editgroup&amp;grouptitle=$grouptitle") .
			construct_link_code($vbphrase['delete'], "vba_gallery_admin.php?$session[sessionurl]do=removegroup&amp;grouptitle=$grouptitle") .
			construct_link_code($vbphrase['add_setting'], "vba_gallery_admin.php?$session[sessionurl]do=addsetting&amp;grouptitle=$grouptitle") .
			'</span>'
		)
	);

	foreach ($settingscache[$grouptitle] AS $settingid => $setting)
	{
		if ($setting['varname'] == 'portal_pagevar' AND $revert OR ($setting['varname'] == 'portal_version'))
		{
			continue;
		}

		print_description_row(
			'<div class="smallfont" style="float:' . $stylevar['right'] . '">' .
			iif($debug AND !$revert, construct_link_code($vbphrase['edit'], "vba_gallery_admin.php?$session[sessionurl]do=editsetting&varname=$setting[varname]") . construct_link_code($vbphrase['delete'], "vba_gallery_admin.php?$session[sessionurl]do=removesetting&varname=$setting[varname]")) . ' ' . iif($revert, '&nbsp; &nbsp; ' . $vbphrase['use_default'] . ' <input ' . iif($setting['default'], 'checked="checked"') . ' type="checkbox" name="usedefault[' . $setting['varname'] . ']" value="1" />') . '</div>
			<div>' . $settingphrase["setting_$setting[varname]_title"] . '<a name="' . $setting['varname'] . '"></a></div>',
			0, 2, 'optiontitle" title="$ppg_options[' . $setting['varname'] . ']"'
		);

		$description = '<div class="smallfont" title="$vboptions[' . $setting['varname'] . ']">' . $settingphrase["setting_$setting[varname]_desc"] . '</div>';
		$name = "setting[$setting[varname]]";
// added for piped optioncode
		if (preg_match('#^(select|selectmulti|radio):(piped|eval)(\r\n|\n|\r)(.*)$#siU', $setting['optioncode'], $matches))
		{
			$setting['optioncode'] = "$matches[1]:$matches[2]";
			$setting['optiondata'] = trim($matches[4]);
		}

		switch ($setting['optioncode'])
		{
			case '':
				print_input_row($description, $name, $setting['value'], 1, 40, '', '', iif($revert, 'bginput" onfocus="js_check_default(\'' . $setting['varname'] . '\');'));
				break;

			case 'textarea':
				print_textarea_row($description, $name, $setting['value'], 8, 40, '', '', '', iif($revert, 'bginput" onfocus="js_check_default(\'' . $setting['varname'] . '\');'));
				break;

			case 'yesno':
				print_yes_no_row($description, $name, $setting['value'], iif($revert, 'js_check_default(\'' . $setting['varname'] . '\');'));
				break;


			// added select:piped
			case 'select:piped':

				print_select_row($description, $name, fetch_piped_options($setting['optiondata']), $setting['value']);
				break;

			// added radio:piped
			case 'radio:piped':
				print_radio_row($description, $name, fetch_piped_options($setting['optiondata']), $setting['value'], 'smallfont');
			
				break;

			case 'catselect':

				$selectbox = '<select name="' . $name . '[]" multiple="multiple" style="width:275px" size="' . iif(sizeof($categorycache) > 10, 10, sizeof($categorycache)) . '">';

				$setting['value'] = explode(',', $setting['value']);
				foreach ($categorycache AS $cat)
				{
					$selectbox .= '<option value="' . $cat['catid'] . '" ' . iif(in_array($cat['catid'], $setting['value']),'selected="selected"') . '>' . str_repeat('--', $cat['level']) . $cat['title'] . '</option>';
				}
				$selectbox .= '</select>';

				print_label_row($description, $selectbox);
			break;

			default:
				eval("\$right = \"$setting[optioncode]\";");
				print_label_row($description, $right, '', 'top', $name);
		}
	}
}


function print_cell_row($array, $isheaderrow = false, $class = false, $i = 0, $valign = 'top', $column = false, $smallfont = false, $bgcolor="")
{
	global $colspan, $bgcounter, $stylevar;

	if (is_array($array))
	{
		$colspan = sizeof($array);
		if ($colspan)
		{
			$j = 0;
			$doecho = 0;

			if (!$class AND !$column AND !$isheaderrow)
			{
				$bgclass = fetch_row_bgclass();
			}
			elseif ($isheaderrow)
			{
				$bgclass = 'thead';
			}
			else
			{
				$bgclass = $class;
			}

			$bgcounter = iif($column, 0, $bgcounter);
			$out = "<tr valign=\"$valign\" align=\"center\">\n";

			foreach($array AS $key => $val)
			{
				$j++;
				if ($val == '' AND !is_int($val))
				{
					$val = '&nbsp;';
				}
				else
				{
					$doecho = 1;
				}

				if ($i++ < 1)
				{
					$align = " align=\"$stylevar[left]\"";
				}
				elseif ($j == $colspan AND $i == $colspan AND $j != 2)
				{
					$align = " align=\"$stylevar[right]\"";
				}
				else
				{
					$align = '';
				}

				if (!$class AND $column)
				{
					$bgclass = fetch_row_bgclass();
				}
				if ($smallfont)
				{
					$val = "<span class=\"smallfont\">$val</span>";
				}

                if($bgcolor=="") {
					$out .= "\t<td " . iif($column, " class=\"$bgclass\"", " class=\"$bgclass\"") . "$align>$val</td>\n";
				} else {
					 $out .= "\t<td style='background: $bgcolor; color:#001F30;' $align>$val</td>\n";
				}
                //$out .= "\t<td" . iif($column, " class=\"$bgclass\"", " class=\"$bgclass\"") . "$align>$val</td>\n";
			}

			$out .= "</tr>\n";

			if ($doecho)
			{
				echo $out;
			}
		}
	}
}

// check for index and add if not there.

function add_table_index($table, $column)
{
	global $db;
	$indexcheck = $db->query("SHOW KEYS FROM " . TABLE_PREFIX . $table);
	while ($check = $db->fetch_array($indexcheck))
	{
		if ($check['Column_name'] == $column AND $check['Seq_in_index'] == 1)
		{
			return;
		}
	}
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "$table ADD INDEX ($column)");
}

?>