<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: vba_gallery_admin.php                                            ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/


// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
$check_ini = false;
if (is_array($_REQUEST) AND !empty($_REQUEST['do']) AND in_array($_REQUEST['do'], array('rebuildthumbs', 'rebuildimageinfo', 'watermarkfiles', 'removeoriginals', 'storagemethod', 'fixproblems')))
{
	ini_set("memory_limit", "256M");
	ini_set("max_execution_time", 300); // 5 minutes.. if it times out then.. there is another problem
	if($check_ini)
	{
// todo.. in production set $check_ini to true ... => next version.. (code is only implemented in upload.php for the moment)
	}
}
// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'gallery_admin');
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);



// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'adv_gallery',
	'adv_gallery_cp',
	'cphome'
);

// get special data templates from the datastore
$specialtemplates = array(
	'adv_gallery_opt',
	'gallery_c_cache',
	'gallery_ugroups',
    'ppg_stats'
);

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_gallery.php');
require_once(DIR . '/includes/adminfunctions_gallery.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/adminfunctions.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################


$ppg_options =& $vbulletin->adv_gallery_opt;
$categorycache =& $vbulletin->gallery_c_cache;
$gallery_permissions =& $vbulletin->gallery_ugroups;
$totalcache =& $vbulletin->ppg_stats;



// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminvbgallery'))
{
    print_cp_no_permission();
}

// ################################# Nav menu #################################


print_cp_header($vbphrase['vba_gallery_admin']);

// Globalize common variables
$catid = intval($_REQUEST['catid']);
$imageid = intval($_REQUEST['imageid']);

// ######################### Custom Field Types ###############################
$customfieldtypes = array(
	'text' => $vbphrase['text_input_single_line'],
	'textarea' => $vbphrase['textarea_multiple_line'],
	'select' => $vbphrase['select_preset_options'],
	'radio' => $vbphrase['radio_options_must_choose'],
	'checkbox' => $vbphrase['checkbox_multiple_options']
);

// ########################### Modify Settings ################################
if ($_REQUEST['do'] == 'modifysettings')
{
	$debug = '';

    $settingphrase = array();
	$getphrases = $db->query_read("
			SELECT varname, text
			FROM " . TABLE_PREFIX . "phrase
			WHERE product = 'ppvbgallery'
            AND languageid IN(-1, 0, " . LANGUAGEID . ")
            ORDER BY languageid ASC");

	while($phrases = $vbulletin->db->fetch_array($getphrases))
	{
		$settingphrase["$phrases[varname]"] = stripslashes($phrases['text']);
	}

	require_once(DIR . '/includes/adminfunctions_options.php');

	if (function_exists('imagecreatetruecolor'))
	{
		$gdinfo = 2;
	}
	else if (function_exists('imagecreate'))
	{
		$gdinfo = 1;
	}
	else
	{
		$gdinfo = $vbphrase['n_a'];
	}
// removed ecard
	$settings = $db->query_read("
			SELECT adv_setting.*
			FROM " . TABLE_PREFIX . "ppgal_setting AS adv_setting
			LEFT JOIN " . TABLE_PREFIX . "ppgal_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE optioncode != 'hidden' AND (adv_settinggroup.grouptitle LIKE 'adv_gallery%' OR adv_settinggroup.grouptitle LIKE 'adv_gallery_global%') AND adv_settinggroup.grouptitle != 'adv_gallery_ecard' 
			ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $vbulletin->db->fetch_array($settings))
	{
		// hide settings that are not used....
		if (in_array($setting['varname'], array('gallery_allowposticons', 'gallery_allowsignatures', 'gallery_uploadflash')))
		{
			continue;

		}
		if ($setting['varname'] == 'gallery_version')
		{
			continue;
		}
		if ($setting['varname'] == 'gallery_usercats_defaultopts')
		{
			$setting['value'] = unserialize($setting['value']);
		}
		$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
		$grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
	}

	$db->free_result($settings);
	unset($setting);

	print_form_header('vba_gallery_admin', 'saveopts');
	foreach ($grouptitlecache AS $grouptitle)
	{
		print_adv_setting_group($grouptitle, 0);
				echo '<tbody>';

		print_description_row("<input type=\"submit\" class=\"button\" value=\" $vbphrase[save] \" tabindex=\"1\" title=\"" . $vbphrase['save_settings'] . "\" />", 0, 2, 'tfoot" style="padding:1px" align="right');
				echo '</tbody>';	
		print_table_break(' ');
	}
	print_submit_row();
}
  				


// ############################ Save Settings #################################
if ($_POST['do'] == 'saveopts')
{
	$setting = $_POST['setting'];

	$adv_setting = array();
	$getsettings = $db->query_read("
			SELECT varname, value
			FROM " . TABLE_PREFIX . "ppgal_setting
			WHERE varname LIKE 'gallery%'
			AND varname NOT IN('gallery_version', 'gallery_insafemode')
			");

	while ($settings = $vbulletin->db->fetch_array($getsettings))
	{
		$adv_setting["$settings[varname]"] = $setting["$settings[varname]"];

		if (($settings['varname'] == 'gallery_catsorderby' AND $settings['value'] != $setting['gallery_catsorderby']) OR ($settings['varname'] == 'gallery_catsdirection' AND $settings['value'] != $setting['gallery_catsdirection']))
		{
			$updatecatcache = true;
		}
	}

  foreach ($adv_setting AS $varname => $value)
  {
		if (in_array($varname, array('gallery_imagebitdisplay', 'gallery_imagebitdisplay_index', 'gallery_homeexcats')))
		{
			if (is_array($value))
			{
				$value = implode(',', $value);
			}
			else
			{
				$value = '';
			}
		}

		if ($varname == 'gallery_usercats_defaultopts')
		{
			$value = serialize($value);
		}

		if ($varname == 'gallery_htaccess')
		{
			if ($value)
			{
				if ($fp = @fopen($ppg_options['gallery_filedirectory'] . '/.htaccess', "w"))
				{
					$homeurl = parse_url($vbulletin->options['homeurl']);

					$extension = array();
					$extensions = $db->query_read("SELECT extension FROM " . TABLE_PREFIX . "ppgal_filetypes");
					while ($ext = $vbulletin->db->fetch_array($extensions))
					{
						$extension[] = strtolower($ext['extension']);
						$extension[] = strtoupper($ext['extension']);
					}

					@fputs ($fp, 'RewriteEngine on
RewriteCond %{HTTP_REFERER} !^$
RewriteCond %{HTTP_REFERER} !^http://(www\.)?' . iif(substr($homeurl['host'], 0, 4) == 'www.', substr($homeurl['host'], 4), $homeurl['host']) . '(/)?.*$ [NC]
RewriteRule .*\.(' . implode('|', $extension) . ')$ [F,NC]');
					@fclose($fp);
				}
			}
			else
			{
				@unlink($ppg_options['gallery_filedirectory'] . '/.htaccess');
			}
		}

		$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "ppgal_setting
				SET value = '" . addslashes($value) . "'
				WHERE varname = '$varname'
				");
	}

	build_adv_settings();

	if ($updatecatcache)
	{
		update_category_cache();
	}

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=modifysettings", 0);
}
// ########################### Modify Layout ################################

if ($_REQUEST['do'] == 'modifylayout')
{
	$debug = '';

    $settingphrase = array();
	$getphrases = $db->query_read("
        SELECT varname, text
        FROM " . TABLE_PREFIX . "phrase
        WHERE product = 'ppvbgallery'
        AND languageid IN(-1, 0, " . LANGUAGEID . ")
        ORDER BY languageid ASC");
	while($phrases = $vbulletin->db->fetch_array($getphrases))
	{
		$settingphrase["$phrases[varname]"] = stripslashes($phrases['text']);
	}

	require_once(DIR . '/includes/adminfunctions_options.php');

	$settings = $db->query_read("
			SELECT adv_setting.*
			FROM " . TABLE_PREFIX . "ppgal_setting AS adv_setting
			LEFT JOIN " . TABLE_PREFIX . "ppgal_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE optioncode != 'hidden' AND (adv_settinggroup.grouptitle LIKE 'layout_%' OR adv_settinggroup.grouptitle LIKE 'layout_%')
			ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $vbulletin->db->fetch_array($settings))
	{
		$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
		$grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
	}
		
	$db->free_result($settings);
	unset($setting);
	print_form_header('vba_gallery_admin', 'savelayout');

	foreach ($grouptitlecache AS $grouptitle)
	{
		print_adv_setting_group($grouptitle, 0);
		echo '<tbody>';
		print_description_row("<input type=\"submit\" class=\"button\" value=\" $vbphrase[save] \" tabindex=\"1\" title=\"" . $vbphrase['save_settings'] . "\" />", 0, 2, 'tfoot" style="padding:1px" align="right');
		echo '</tbody>';	
		print_table_break();
	}
	print_submit_row();
}

// ############################ Save Layout Settings #################################
if ($_POST['do'] == 'savelayout')
{
	$setting = $_POST['setting'];

	$adv_setting = array();
	$getsettings = $db->query_read("SELECT varname, value FROM " . TABLE_PREFIX . "ppgal_setting WHERE varname LIKE 'layout_%'");
	while ($settings = $vbulletin->db->fetch_array($getsettings))
	{
		$adv_setting["$settings[varname]"] = $setting["$settings[varname]"];
 	}

  foreach ($adv_setting AS $varname => $value)
  {
		if (in_array($varname, array('add_home_exclude', 'add_home_include', 'add_home_imagebitdisplay', 'add_profile_exclude', 'add_profile_include', 'add_profile_imagebitdisplay')))
		{
			if (is_array($value))
			{
				$value = implode(',', $value);
			}
			else
			{
				$value = '';
			}
		}

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_setting SET value = '" . addslashes($value) . "' WHERE varname = '$varname'");
	}

	build_adv_settings();

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=modifylayout", 0);
}

// ############################ Modify add-on Settings #################################
if ($_REQUEST['do'] == 'modifyaddon')
{
	$debug = '';

    $settingphrase = array();
	$getphrases = $db->query_read("
        SELECT varname, text
        FROM " . TABLE_PREFIX . "phrase
        WHERE product = 'ppvbgallery'
        AND languageid IN(-1, 0, " . LANGUAGEID . ")
        ORDER BY languageid ASC");
	while($phrases = $vbulletin->db->fetch_array($getphrases))
	{
		$settingphrase["$phrases[varname]"] = stripslashes($phrases['text']);
	}

	require_once(DIR . '/includes/adminfunctions_options.php');

	$settings = $db->query_read("
			SELECT adv_setting.*
			FROM " . TABLE_PREFIX . "ppgal_setting AS adv_setting
			LEFT JOIN " . TABLE_PREFIX . "ppgal_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE optioncode != 'hidden' AND (adv_settinggroup.grouptitle LIKE 'add_%' OR adv_settinggroup.grouptitle LIKE 'add_%')
			ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $vbulletin->db->fetch_array($settings))
	{
		$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
		$grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
	}

	$db->free_result($settings);
	unset($setting);
	print_form_header('vba_gallery_admin', 'saveaddon');

	foreach ($grouptitlecache AS $grouptitle)
	{
		print_adv_setting_group($grouptitle, 0);
		echo '<tbody>';
		print_description_row("<input type=\"submit\" class=\"button\" value=\" $vbphrase[save] \" tabindex=\"1\" title=\"" . $vbphrase['save_settings'] . "\" />", 0, 2, 'tfoot" style="padding:1px" align="right');
		echo '</tbody>';	
		
		
		print_table_break();
	}
	  print_submit_row();
}

// ############################ Save Settings #################################
if ($_POST['do'] == 'saveaddon')
{
	$setting = $_POST['setting'];

	$adv_setting = array();
	$getsettings = $db->query_read("SELECT varname, value FROM " . TABLE_PREFIX . "ppgal_setting WHERE varname LIKE 'add_%'");
	while ($settings = $vbulletin->db->fetch_array($getsettings))
	{
		$adv_setting["$settings[varname]"] = $setting["$settings[varname]"];
 	}

  foreach ($adv_setting AS $varname => $value)
  {
		if (in_array($varname, array('add_home_exclude', 'add_home_include', 'add_home_imagebitdisplay', 'add_profile_exclude', 'add_ucp_profile_exclude',  'add_ucp_profile_include','add_profile_include', 'add_profile_imagebitdisplay')))
		{
			if (is_array($value))
			{
				$value = implode(',', $value);
			}
			else
			{
				$value = '';
			}
		}

		
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_setting SET value = '" . addslashes($value) . "' WHERE varname = '$varname'");
	}

	build_adv_settings();

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=modifyaddon", 0);
}


// ##################### Edit Permissions For Usergroup #######################
if ($_REQUEST['do'] == 'permissions')
{
	$u = intval($_REQUEST['u']);

	$usergroups = $db->query_read("
			SELECT usergroupid, title
			FROM " . TABLE_PREFIX . "usergroup
			ORDER BY usergroupid
			");
		while ($usergroup = $vbulletin->db->fetch_array($usergroups)){
			$grouparray["$usergroup[usergroupid]"] = $usergroup['title'];
		}

	if ($u)
	{
		$usergroup = $gallery_permissions["$u"];
		$usergroup['title'] = $grouparray["$u"];
	}
	print_form_header('vba_gallery_admin', 'permissions', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header(iif($usergroup['usergroupid'], $usergroup['title'], $vbphrase['modify_permissions']));

	print_description_row('' . $vbphrase['usergroup'] . ': <select name="u" class="bginput" onchange="submit();">' . construct_select_options($grouparray, $u) . '</select> <input class="button" type="submit" value="' . $vbphrase['go'] . '" />', 0, 1, '', 'center');
	print_table_footer();

	if ($u)
	{
		print_form_header('vba_gallery_admin', 'updateperms');

		$perms = convert_bits_to_array($usergroup['gallery_perms'], $gallerypermissionsbit);

		print_label_row('<b>' . $usergroup['title'] . '</b>', '<input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 1);" type="button" value="' . $vbphrase['all_yes'] . '" /> <input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 0);" type="button" value="' . $vbphrase['all_no'] . '" />', 'tcat');

		construct_hidden_code('usergroupid', $u);
		construct_hidden_code('usergrouptitle', $usergroup['title']);

		print_permission_rows(false);

		print_submit_row($vbphrase['save']);
	}
}

// ########################### Do Update Permissions ##########################
if ($_POST['do'] == 'updateperms')
{
	$usergroup = $_POST['usergroup'];
	$usergroupid = intval($_POST['usergroupid']);
	$usergrouptitle = $_POST['usergrouptitle'];

	require_once(DIR . '/includes/functions_misc.php');
	$usergroup['gallery_perms'] = convert_array_to_bits($usergroup, $gallerypermissionsbit, 1);
	
	$galleryperms = $gallery_permissions;
	$galleryperms["$usergroupid"] = $usergroup;

	build_datastore('gallery_ugroups', serialize($galleryperms),1);

	define('CP_REDIRECT', "vba_gallery_admin.php?$session[sessionurl]do=permissions");
	print_stop_message('saved_usergroup_x_successfully', $usergrouptitle);

}

// ##################### Edit Permissions For Usergroup #######################
if ($_REQUEST['do'] == 'categorypermissions')
{
	$catinfo = array();

	$getcats = $db->query_read("SELECT catid, title, parent, hasimages, displayorder FROM " . TABLE_PREFIX . "ppgal_categories ORDER BY $ppg_options[gallery_catsorderby] $ppg_options[gallery_catsdirection], hasimages");
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		$catinfo[] = $categories;
	}

	$db->free_result($getcats);
	unset($categories);

	$usergroupperms = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_permissions");
	while ($uperms = $vbulletin->db->fetch_array($usergroupperms))
	{
		$usergroup['title'] = $vbulletin->usergroupcache["$u"]['title'];
		$hasperms["$uperms[usergroupid]"]["$uperms[catid]"] = true;
	}

	print_form_header('', '');
	print_table_header($vbphrase['category_permissions']);
	print_description_row('
		<div class="darkbg" style="border:2px inset">
			<ul class="darkbg">
				<li><b>' . $vbphrase['color_key'] . '</b></li>
				<li class="col-g">' . $vbphrase['standard_using_default_usergroup_permissions'] . '</li>
				<li class="col-c">' . $vbphrase['customized_using_custom_permissions_for_this_usergroup'] . '</li>
				<li class="col-i">' . $vbphrase['inherited_using_custom_permissions_from_parent_category'] . '</li>
			</ul>
		</div>
	');
	print_table_break();

	print_description_row('<div class="darkbg" style="border: 2px inset">' .

	print_category_perm_rows($catinfo, 0)

	);
	print_table_footer();

}

// ######################## Edit Permissions for Category #####################
if ($_REQUEST['do'] == 'editcategoryperms')
{
	$u = intval($_REQUEST['u']);
	$c = intval($_REQUEST['c']);

	?>
	<script type="text/javascript">
	<!--
	function js_set_custom()
	{
		if (document.cpform.useusergroup[1].checked == false)
		{
			if (confirm("<?php echo $vbphrase['for_setting_effect_permissions_for_usergroup_enabled']; ?>"))
			{
				document.cpform.useusergroup[1].checked = true;
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return true;
		}
	}
	// -->
	</script>
	<?php

	if ($usergroup = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_permissions WHERE usergroupid = '$u' AND catid = '$c'"))
	{
		$perms = convert_bits_to_array($usergroup['permissions'], $gallerypermissionsbit);
	}
	else
	{
		$perms = fetch_category_perms($c, explode(',', $u));
	}

	$usergroup['title'] = $vbulletin->usergroupcache["$u"]['title'];
	$category['title'] = $categorycache["$c"]['title'];

	print_form_header('vba_gallery_admin', 'doeditcatperms');
	construct_hidden_code('usergroup[usergroupid]', $u);
	construct_hidden_code('usergroup[catid]', $c);
	print_table_header(construct_phrase($vbphrase['edit_category_permissions_for_usergroup_x_in_category_y'], $usergroup['title'], $category['title']));

	print_description_row('
		<label for="use_default"><input ' . iif(!isset($usergroup['permissions']), ' checked="checked"') . ' id="use_default" name="useusergroup" onclick="this.form.reset(); this.checked=true;" type="radio" value="0" />' . $vbphrase['use_default_permissions_note_delete_previous_permissions_set'] . '</label>
		<br />
		<label for="use_custom"><input id="use_custom" ' . iif(isset($usergroup['permissions']), ' checked="checked"') . ' name="useusergroup" type="radio" value="1" />' . $vbphrase['use_custom_permissions'] . '</label>
	', 0, 2, 'tfoot', '' , 'mode');
	print_table_break();

	print_table_break();

	print_label_row('<b>' . $usergroup['title'] . '</b>',
		'<input id="checkall" name="checkall" onclick="js_check_all_option(this.form, 1); js_set_custom();" type="button" value="' . $vbphrase['all_yes'] . '" />
		<input id="checkall" name="checkall" onclick="js_check_all_option(this.form, 0); js_set_custom();" type="button" value="' . $vbphrase['all_no'] . '" />', 'tcat');

	construct_hidden_code('usergroupid', $usergroup['usergroupid']);
	construct_hidden_code('usergrouptitle', $usergroup['title']);

	print_permission_rows(true);

	print_submit_row($vbphrase['save']);
}

// ###################### Do Add/Edit Category Permissions ####################
if ($_POST['do'] == 'doeditcatperms')
{
	$usergroup = $_POST['usergroup'];
	$useusergroup = $_POST['useusergroup'];

	require_once(DIR . '/includes/functions_misc.php');
	$perms = convert_array_to_bits($usergroup, $gallerypermissionsbit, 1);

	$checkexists = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_permissions WHERE catid = '$usergroup[catid]' AND usergroupid = '$usergroup[usergroupid]'");

	if (!$useusergroup AND !empty($checkexists))
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_permissions WHERE usergroupid = '$usergroup[usergroupid]' AND catid = '$usergroup[catid]'");
	}

	if ($useusergroup)
	{
		if (empty($checkexists))
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_permissions (catid, usergroupid, permissions) VALUES ('$usergroup[catid]', '$usergroup[usergroupid]', '$perms')");
		}
		else
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_permissions SET permissions = '$perms' WHERE usergroupid = '$usergroup[usergroupid]' AND catid = '$usergroup[catid]'");
		}
	}
	update_category_cache();
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=categorypermissions", 0);
}

// ######################### Reset Category Permissions ######################
if ($_REQUEST['do'] == 'resetperms')
{
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_permissions WHERE catid = '$_REQUEST[catid]'");
	update_category_cache();

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=categorypermissions", 0);
}

// ############################ Deny All Permission ###########################
if ($_REQUEST['do'] == 'denyperms')
{
	$usergroups = $db->query_read("SELECT usergroupid FROM " . TABLE_PREFIX . "usergroup");
	while ($usergroup = $vbulletin->db->fetch_array($usergroups))
	{
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_permissions (catid, usergroupid, permissions) VALUES ('$_REQUEST[catid]', '$usergroup[usergroupid]', 0)");
	}

	update_category_cache();

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=categorypermissions", 0);
}

// ############################# Manage Categories ###########################
if ($_REQUEST['do'] == 'dirmanager')
{
	?>
	<script type="text/javascript">
	function js_dir_jump(catid)
	{
		action = eval("document.cpform.c" + catid + ".options[document.cpform.c" + catid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit':
				page = 'vba_gallery_admin.php?do=editcat&catid=';
				break;
			case 'remove':
				page = 'vba_gallery_admin.php?do=deletecat&catid=';
				break;
			case 'addsub':
				page = 'vba_gallery_admin.php?do=addcat&parentid=';
				break;
			case 'view':
				page = '<?php echo $ppg_options['gallery_url'] ?>/browseimages.php?c=';
				break;
			case 'empty':
				page = 'vba_gallery_admin.php?do=empty&catid=';
				break;
			case 'massedit':
				page = '../<?php echo $vbulletin->config['Misc']['modcpdir']; ?>/vba_gallery.php?do=massedit&catid=';
				break;
		}
		document.cpform.reset();

		window.location = page + catid + "&s=<?php echo $session['sessionhash']; ?>";
	}

	function js_mod_jump(catid)
	{
		modid = eval("document.cpform.m" + catid + ".options[document.cpform.m" + catid + ".selectedIndex].value");
		document.cpform.reset();
		switch (modid)
		{
			case 'addmod':
				window.location = "vba_gallery_admin.php?s=<?php echo $session['sessionhash']; ?>&do=addmoderator&catid=" + catid;
				break;
			default:

				window.location = "vba_gallery_admin.php?s=<?php echo $session['sessionhash']; ?>&do=editmoderator&modid=" + modid + "&catid=" + catid; break;
		}
	}

	</script>

	<?php

	$diroptions = array(
		'edit' => $vbphrase['edit_category'],
		'view' => $vbphrase['view_images'],
		'empty' => $vbphrase['empty_category'],
		'remove' => $vbphrase['remove_category'],
		'addsub' => $vbphrase['add_sub_category'],
		'massedit' => $vbphrase['mass_edit_delete']
	);

	print_form_header('vba_gallery_admin', 'doorder');
	print_table_header($vbphrase['edit_categories'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['controls'], $vbphrase['display_order'], $vbphrase['moderator']), 1);

	$getcats = $db->query_read("SELECT catid, title, parent, hasimages, displayorder FROM " . TABLE_PREFIX . "ppgal_categories ORDER BY $ppg_options[gallery_catsorderby] $ppg_options[gallery_catsdirection], hasimages");
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		$catinfo[] = $categories;
	}

	$db->free_result($getcats);
	unset($categories);

	// Get Moderator Info
	$mods = $db->query_read('SELECT * FROM ' . TABLE_PREFIX . 'ppgal_moderator');
	while ($gmods = $vbulletin->db->fetch_array($mods))
	{
		$gallerymods[] = $gmods;
	}

	$db->free_result($mods);
	unset($gmods);

	if ($gallerymods)
	{
		foreach ($gallerymods AS $moderator)
		{
			$gallery_modcache["$moderator[catid]"]["$moderator[userid]"] = $moderator;
		}
	}

	// Construct The Directories
	if ($catinfo = construct_categories($catinfo, 0, -1));
	{
		if (!empty($catinfo))
		{
			foreach ($catinfo as $cats)
			{
				// Figure out who moderates which category
				if ($gallery_modcache["$cats[catid]"])
				{
					$modcounts = 0;
					foreach($gallery_modcache["$cats[catid]"] AS $moderator)
					{
						$modcounts++;
						$modopts["$cats[catid]"] .= '<option value="' . $moderator['userid'] . '"> &nbsp; ' . $moderator['username'] . '</option>';
						$modcount["$cats[catid]"] = $modcounts;
					}
				}

				$cell = array();

				$cell[] = '<b>' . str_repeat('- - ', ($cats['level'] - 1)) . ' <a href="vba_gallery_admin.php?' . $session['sessionhash'] . 'do=editcat&amp;catid=' . $cats['catid'] . '">' . stripslashes($cats['title']) . '</a></b>';

				$cell[] = '<select name="c' . $cats['catid'] . '" onchange="js_dir_jump(' . $cats['catid'] . ');" class="bginput">' . construct_select_options($diroptions) . '</select><input class="button" type="button" value="' . $vbphrase['go'] . '" onclick="js_dir_jump(' . $cats['catid'] . ');" />';

				$cell[] = '<input type="text" class="bginput" name="order[' . $cats['catid'] . ']" size="3" title="' . $vbphrase['edit_display_order'] . '" value="' . $cats['displayorder'] . '" />';

				$cell[] = '<select class="bginput" name="m' . $cats['catid'] . '" onchange="js_mod_jump(' . $cats['catid']  . ');"><option value="0">' . $vbphrase['moderators'] . ' (' . vb_number_format($modcount["$cats[catid]"]) . ')</option>' . $modopts["$cats[catid]"] . '<option value="addmod">' . $vbphrase['add_moderator'] . '</option></select><input class="button" onclick="js_mod_jump(' . $cats['catid'] . ');" type="button" value="' . $vbphrase['go'] . '" />';

				print_cells_row($cell);
			}
		}
		unset($catinfo, $moderator, $gallery_modcache);
	}
	print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 4);
}

// ############################# Re-Order Categories ##########################
if ($_POST['do'] == 'doorder')
{

  foreach ($_POST['order'] AS $catid => $disorder)
  {
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET displayorder = '$disorder' WHERE catid = '$catid'");
  }
	update_category_cache();
	define('CP_REDIRECT', 'vba_gallery_admin.php?do=dirmanager' . $session['sessionurl']);
	print_stop_message('saved_display_order_successfully');
}

// ############################## Add/Edit Category ##########################
if (in_array($_REQUEST['do'], array('addcat', 'editcat')))
{

	?>
	<script type="text/javascript">
	<!--
	function js_check_default(varname)
	{
		document.cpform[ "usedefault[" + varname + "]" ].checked=false
	}
	// -->
	</script>
	<?php

	$parentid = intval($_REQUEST['parentid']);

	print_form_header('vba_gallery_admin', 'do' . $_REQUEST['do']);

	if ($_REQUEST['do'] == 'editcat')
	{
		$cat = $db->query_first("
				SELECT categories.*, user.username
				FROM " . TABLE_PREFIX . "ppgal_categories AS categories
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
				WHERE catid = '$catid'
		");
		construct_hidden_code('catinfo[catid]', $cat['catid']);
		construct_hidden_code('oldparentid', $cat['parent']);
		construct_hidden_code('oldpassword', $cat['password']);

		$options = convert_bits_to_array($cat['options'], $categoryopts);
		$useropts = convert_bits_to_array($cat['useroptions'], $catuseropts);
	}
	else
	{
		$cat['hasimages'] = 1;
		$cat['parent'] = $parentid;
		$cat['active'] = 1;
		$options['open_for_images'] = 1;
		$options['open_for_posts'] = 1;
		$options['allow_desc_html'] = 0;
		$options['allow_desc_bbcode'] = 1;
		$options['allow_desc_bbimgcode'] = 1;
		$options['allow_desc_smilies'] = 1;
		$options['allow_custom_html'] = 0;
		$options['allow_custom_bbcode'] = 1;
		$options['allow_custom_bbimgcode'] = 1;
		$options['allow_custom_smilies'] = 1;
		$options['allow_post_html'] = 0;
		$options['allow_post_bbcode'] = 1;
		$options['allow_post_bbimgcode'] = 1;
		$options['allow_post_smilies'] = 1;
		$options['allow_post_icons'] = 1;
		$options['allow_replies'] = 1;
		$options['allow_ratings'] = 1;
		$options['allow_custom_links'] = 1;
		$options['allow_desc_links'] = 1;
	}

	$catimage = unserialize($cat['catimage']);

	print_table_header(iif($_REQUEST['do'] == 'addcat', $vbphrase['add_category'], construct_phrase($vbphrase['x_y_id_z'], $vbphrase['edit_category'], $cat['title'], $cat['catid'])));
	print_input_row($vbphrase['title'], 'catinfo[title]', stripslashes(unhtmlspecialchars($cat['title'])));
	print_textarea_row($vbphrase['description'], 'catinfo[description]', stripslashes(unhtmlspecialchars($cat['description'])));
	print_input_row($vbphrase['display_order'] . iif($_REQUEST['do'] == 'addcat', $vbphrase['set_to_neg_1_first']), 'catinfo[displayorder]', $cat['displayorder']);
	print_category_select('catinfo[parent]', $cat['parent'], $vbphrase['none'], $vbphrase['category_parent']);
	print_input_row(construct_phrase($vbphrase['category_image'], $ppg_options['gallery_fileurl']), 'catinfo[catimage]', stripslashes($catimage['url']));

	print_table_header($vbphrase['style_options']);
	if (!isset($catinfo['styleid']) OR $catinfo['styleid'] == 0)
	{
		$catinfo['styleid'] = -1; // to get the "use default style" option selected
	}
	print_style_chooser_row('catinfo[styleid]', $cat['styleid'], $vbphrase['use_default_style'], $vbphrase['custom_gallery_style']);
	print_yes_no_row($vbphrase['override_style_choice'], 'catinfo[styleoverride]', $cat['styleoverride']);

	print_table_header($vbphrase['category_options']);
	print_input_row($vbphrase['email_addresses_notify_when_new_upload'], 'catinfo[newimageemail]', $cat['newimageemail']);
	print_input_row($vbphrase['email_addresses_notify_when_new_post'], 'catinfo[newpostemail]', $cat['newpostemail']);
	print_yes_no_row($vbphrase['act_as_category'], 'catinfo[hasimages]', $cat['hasimages']);
	print_yes_no_row($vbphrase['category_is_active_will_not_appear_ramians_accessible'], 'catinfo[active]', $cat['active']);
	print_yes_no_row($vbphrase['act_as_members_category'], 'catinfo[membercat]', $cat['membercat']);
	print_yes_no_row($vbphrase['allow_users_create_subcats'], 'catinfo[allowusercats]', $cat['allowusercats']);
	print_yes_no_row($vbphrase['category_is_open_for_images'], 'options[open_for_images]', $options['open_for_images']);
	print_yes_no_row($vbphrase['category_is_open_for_posts'], 'options[open_for_posts]', $options['open_for_posts']);
	print_yes_no_row($vbphrase['allow_replies'], 'options[allow_replies]', $options['allow_replies']);
	print_yes_no_row($vbphrase['allow_ratings'], 'options[allow_ratings]', $options['allow_ratings']);

	print_table_header($vbphrase['user_options']);
	print_input_row($vbphrase['category_owner_enter_username'], 'catinfo[catusername]', $cat['username']);
	print_yes_no_row($vbphrase['allow_other_users_view'], 'useropts[allow_view]', $useropts['allow_view']);
	print_yes_no_row($vbphrase['allow_other_users_upload'], 'useropts[allow_upload]', $useropts['allow_upload']);
	print_yes_no_row($vbphrase['allow_other_users_reply'], 'useropts[allow_reply]', $useropts['allow_reply']);
	print_yes_no_row($vbphrase['allow_other_users_rate'], 'useropts[allow_rating]', $useropts['allow_rating']);

	print_table_header($vbphrase['access_options']);
	print_input_row($vbphrase['category_password_acts_in_addition_other_permissions'], 'catinfo[password]', $cat['password']);
	print_yes_no_row($vbphrase['apply_this_password_to_child_categories'], 'options[childpass]', $options['childpass']);
	print_yes_no_row($vbphrase['can_have_password'], 'options[canhavepassword]', $options['canhavepassword']);

	print_table_header($vbphrase['image_description']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_desc_html]', $options['allow_desc_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_desc_bbcode]', $options['allow_desc_bbcode']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_desc_bbimgcode]', $options['allow_desc_bbimgcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_desc_smilies]', $options['allow_desc_smilies']);
	print_yes_no_row($vbphrase['automatically_parse_links_in_text'], 'options[allow_desc_links]', $options['allow_desc_links']);

	print_table_header($vbphrase['custom_fields']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_custom_html]', $options['allow_custom_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_custom_bbcode]', $options['allow_custom_bbcode']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_custom_bbimgcode]', $options['allow_custom_bbimgcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_custom_smilies]', $options['allow_custom_smilies']);
	print_yes_no_row($vbphrase['automatically_parse_links_in_text'], 'options[allow_custom_links]', $options['allow_custom_links']);

	print_table_header($vbphrase['posting_options']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_post_html]', $options['allow_post_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_post_bbcode]', $options['allow_post_bbcode']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_post_bbimgcode]', $options['allow_post_bbimgcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_post_smilies]', $options['allow_post_smilies']);
	print_yes_no_row($vbphrase['allow_icons'], 'options[allow_post_icons]', $options['allow_post_icons']);

	print_table_break();

    $settingphrase = array();
	$getphrases = $db->query_read("
        SELECT varname, text
        FROM " . TABLE_PREFIX . "phrase
        WHERE product = 'ppvbgallery'
        AND languageid IN(-1, 0, " . LANGUAGEID . ")
        ORDER BY languageid ASC");
	while($phrases = $vbulletin->db->fetch_array($getphrases))
	{
		$settingphrase["$phrases[varname]"] = stripslashes($phrases['text']);
	}

	require_once(DIR . '/includes/adminfunctions_options.php');

	foreach ($adv_category_options AS $varname)
	{
		$adv_options[] = '\'' . $varname . '\'';
	}

	$adv_opts = unserialize($cat['adv_setting']);

	$settings = $db->query_read("
			SELECT adv_setting.*
			FROM " . TABLE_PREFIX . "ppgal_setting AS adv_setting
			LEFT JOIN " . TABLE_PREFIX . "ppgal_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE adv_setting.varname IN(" . implode(', ', $adv_options) . ")
			ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $vbulletin->db->fetch_array($settings))
	{
		$setting['default'] = true;
		if (!empty($adv_opts))
		{
			foreach ($adv_opts AS $adv => $value)
			{
				if ($adv == $setting['varname'] AND $value != $setting['value'])
				{
					$setting['default'] = false;
					$setting['value'] = $value;
				}
			}
		}
		$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
		$grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
	}

	$db->free_result($settings);
	unset($setting);

	foreach ($grouptitlecache AS $grouptitle)
	{
		print_adv_setting_group($grouptitle);
		print_table_break();
	}

	print_table_header($vbphrase['allowed_filetypes'], 8);

	?>
	<script type="text/javascript">
	<!--
	function js_check_default(varname)
	{
		document.cpform[ "usedefault[" + varname + "]" ].checked=false
	}
	// -->
	</script>
	<?php

	$types = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_filetypes WHERE enabled = 1 ORDER BY extensionid");
	print_cell_row(array($vbphrase['extension'], $vbphrase['max_filesize'], $vbphrase['max_width'], $vbphrase['max_height'], $vbphrase['min_width'], $vbphrase['min_height'], $vbphrase['enabled'], $vbphrase['use_default']), 1);
	while ($type = $vbulletin->db->fetch_array($types))
	{
		$ctarray = unserialize($cat['disext']);

		$typevalue = &$type;
		if (!empty($ctarray["$type[extension]"]))
		{
			$typevalue = &$ctarray["$type[extension]"];
		}

		$cells = array();
		$cells[] = $type['extension'];
		$cells[] = '<input class="bginput" name="extensions[' . $type['extensionid'] . '][filesize]" onfocus="js_check_default(\'' . $type[extensionid] . '\');" size="10" type="text" value="' . $typevalue['filesize'] . '" />';
		$cells[] = '<input class="bginput" name="extensions[' . $type['extensionid'] . '][width]" onfocus="js_check_default(\'' . $type[extensionid] . '\');" size="4" type="text" value="' . $typevalue['width'] . '" />';
		$cells[] = '<input class="bginput" name="extensions[' . $type['extensionid'] . '][height]" onfocus="js_check_default(\'' . $type[extensionid] . '\');" size="4" type="text" value="' . $typevalue['height'] . '" />';
        $cells[] = '<input class="bginput" name="extensions[' . $type['extensionid'] . '][min_width]" onfocus="js_check_default(\'' . $type[extensionid] . '\');" size="4" type="text" value="' . $typevalue['min_width'] . '" />';
        $cells[] = '<input class="bginput" name="extensions[' . $type['extensionid'] . '][min_height]" onfocus="js_check_default(\'' . $type[extensionid] . '\');" size="4" type="text" value="' . $typevalue['min_height'] . '" />';

        if (!$typevalue['enabled'])
		{
			$noselected["$type[extensionid]"] = 'checked="checked"';
		}
		else
		{
			$yesselected["$type[extensionid]"] = 'checked="checked"';
		}
		$cells[] = '<label for="enabled_' . $type['extensionid'] . '_yes"><input id="enabled_' . $type['extensionid'] . '_yes" name="extensions[' . $type['extensionid'] . '][enabled]" ' . $yesselected["$type[extensionid]"] . ' onclick="js_check_default(\'' . $type[extensionid] . '\');" type="radio" value="1" />' . $vbphrase['yes'] . '</label> <label for="enabled_' . $type['extensionid'] . '_no"><input id="enabled_' . $type['extensionid'] . '_no" name="extensions[' . $type['extensionid'] . '][enabled]" ' . $noselected["$type[extensionid]"] . ' onclick="js_check_default(\'' . $type[extensionid] . '\');" type="radio" value="0" />' . $vbphrase['no'] . '</label>';

		$cells[] = '<input ' . iif(empty($ctarray["$type[extension]"]), 'checked="checked"') . ' type="checkbox" name="usedefault[' . $type['extensionid'] . ']" value="1" />';

		print_cell_row($cells);
	}

	print_submit_row($vbphrase['save'], $vbphrase['reset'], 8);

}

// ################################# Do Add Cat ###############################
if (in_array($_POST['do'], array('doaddcat', 'doeditcat')))
{
	$catinfo = $_POST['catinfo'];
	$options = $_POST['options'];
	$extensions = $_POST['extensions'];
	$usedefault = $_POST['usedefault'];
	$useropts = $_POST['useropts'];
	$setting = $_POST['setting'];

	if (!$catinfo['title'])
	{
		print_stop_message('adv_gallery_cant_have_category_without_title');
	}

	$catinfo['title'] = str_replace('&amp;', '&', $catinfo['title']);
	$catinfo['description'] = str_replace('&amp;', '&', $catinfo['description']);
    $catinfo['title_clean'] = htmlspecialchars_uni(str_replace('&amp;', '&', strip_tags($catinfo['title'])));
    $catinfo['description_clean'] = htmlspecialchars_uni(str_replace('&amp;', '&', strip_tags($catinfo['description'])));

	if (trim($catinfo['catimage']))
	{
		$catimage['url'] = $catinfo['catimage'];

		$thumbinfo = @getimagesize($ppg_options['gallery_filedirectory'] . '/' . $catimage['url']);
		$catimage['w'] = $thumbinfo[0];
		$catimage['h'] = $thumbinfo[1];

		$catinfo['catimage'] = serialize($catimage);
	}
	else
	{
		$catinfo['catimage'] = '';
	}

	$catinfo['catuserid'] = '';

	if ($catinfo['catusername'])
	{
		$user = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string($catinfo['catusername']) . "'");
		$catinfo['catuserid'] = $user['userid'];
		if (!$user['userid'])
		{
			print_stop_message('invalid_user_specified');
		}
	}
	unset($catinfo['catusername']);

	$disext = array();
	$fileext = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_filetypes");
	while ($ext = $vbulletin->db->fetch_array($fileext))
	{
		if (!$usedefault["$ext[extensionid]"] AND (!$extensions["$ext[extensionid]"]['enabled'] OR $ext['filesize'] != $extensions["$ext[extensionid]"]['filesize'] OR $extensions["$ext[extensionid]"]['height'] != $ext['height'] OR $extensions["$ext[extensionid]"]['width'] != $ext['width']))
		{
			$disext["$ext[extension]"]['enabled'] = $extensions["$ext[extensionid]"]['enabled'];
			$disext["$ext[extension]"]['filesize'] = $extensions["$ext[extensionid]"]['filesize'];
			$disext["$ext[extension]"]['width'] = $extensions["$ext[extensionid]"]['width'];
			$disext["$ext[extension]"]['height'] = $extensions["$ext[extensionid]"]['height'];
            $disext["$ext[extension]"]['min_width'] = $extensions["$ext[extensionid]"]['min_width'];
            $disext["$ext[extension]"]['min_height'] = $extensions["$ext[extensionid]"]['min_height'];
		}
	}

	if (!empty($disext))
	{
		$catinfo['disext'] = serialize($disext);
	}
	else
	{
		$catinfo['disext'] = '';
	}

	$defsettings = $db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "ppgal_setting AS adv_setting
			WHERE grouptitle LIKE 'adv_gallery%'
	");

	while ($defsetting = $vbulletin->db->fetch_array($defsettings))
	{
		if (!empty($setting))
		{
			foreach ($setting AS $varname => $value)
			{
				if ($varname == $defsetting['varname'] AND $value != $defsetting['value'] AND !$usedefault["$varname"])
				{
					$adv_setting["$varname"] = $value;
				}
			}
		}
	}
	$db->free_result($defsettings);
	unset($defsetting, $setting);

	if (!empty($adv_setting))
	{
		$catinfo['adv_setting'] = serialize($adv_setting);
	}
	else
	{
		$catinfo['adv_setting'] = '';
	}

	require_once(DIR . '/includes/functions_misc.php');

	$catinfo['options'] = convert_array_to_bits($options, $categoryopts);

	$catinfo['useroptions'] = convert_array_to_bits($useropts, $catuseropts);

	if ($_POST['do'] == 'doaddcat')
	{
		if ($catinfo['displayorder'] == -1)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET displayorder = displayorder+1 WHERE parent = '$catinfo[parentid]'");
			$catinfo['displayorder'] = 1;
		}

		$db->query_read(fetch_query_sql($catinfo, 'ppgal_categories'));

		$newcatid = $db->insert_id();

		insert_category_parentlist($catinfo['parent']);
		insert_category_childlist();

	}
	else
	{
		if ($catinfo['parent'] == $catinfo['catid'])
		{
			print_stop_message('adv_gallery_cant_parent_category_to_self');
		}

		$db->query_read(fetch_query_sql($catinfo, 'ppgal_categories', 'WHERE catid = \'' . $catinfo['catid'] . '\''));

		if ($_POST['oldparentid'] != $catinfo['parent'])
		{
			reconstruct_parents($catinfo['catid']);
			
		}
		reconstruct_children($catinfo['catid']);
		if ($catinfo['password'] AND $options['childpass'])
		{
			$getcatids = fetch_category_children($catinfo['catid']);
			$pcats = $db->query_read("SELECT catid, options FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid IN (" . implode(',', $getcatids) . ")");
			while ($pcat = $vbulletin->db->fetch_array($pcats))
			{
				$catopts = construct_cat_opts($pcat['catid'], $pcat['options']);

				if ($catopts['canhavepassword'])
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET password = '" . addslashes($catinfo['password']) . "' WHERE catid = '$pcat[catid]'");
				}
			}
		}
	}

	update_category_cache();

	print_cp_redirect('vba_gallery_admin.php?' . $session['sessionurl'] . 'do=dirmanager', 0);
}

// ################################ Delete Category ###########################
if ($_REQUEST['do'] == 'deletecat')
{
	print_form_header('vba_gallery_admin', 'dodeletecat');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_delete_category']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete Category ##########################
if ($_POST['do'] == 'dodeletecat')
{
	delete_category($_POST['catid']);
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=dirmanager", 0);
}

// ############################### Empty Category #############################
if ($_REQUEST['do'] == 'empty')
{
	print_form_header('vba_gallery_admin', 'doempty');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_empty_category']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Empty Category ############################
if ($_POST['do'] == 'doempty')
{
	empty_category($_POST['catid']);
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=dirmanager", 0);
}

// ############################### List Filetypes #############################
if ($_REQUEST['do'] == 'filetypes')
{
    print_form_header('vba_gallery_admin', 'addfiletype', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header($vbphrase['allowed_filetypes'], 8);
	print_cell_row(array($vbphrase['extension'], $vbphrase['max_filesize'], $vbphrase['max_width'], $vbphrase['max_height'], $vbphrase['min_width'], $vbphrase['min_height'], $vbphrase['enabled'], $vbphrase['controls']), 1);

	$types = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_filetypes ORDER BY extensionid");
	while ($type = $vbulletin->db->fetch_array($types))
	{
		$cells = array();
		$cells[] = $type['extension'];
		$cells[] = vb_number_format($type['filesize'], 1, true);
		$cells[] = $type['width'];
		$cells[] = $type['height'];
        $cells[] = $type['min_width'];
        $cells[] = $type['min_height'];
        $cells[] = iif($type['enabled'], $vbphrase['yes'], $vbphrase['no']);
		$cells[] = construct_link_code($vbphrase['edit'], 'vba_gallery_admin.php?do=editfiletype&amp;extid=' . $type['extensionid']) . construct_link_code($vbphrase['delete'], 'vba_gallery_admin.php?do=deletefiletype&extid=' . $type['extensionid']);
		print_cell_row($cells);
	}
	print_submit_row($vbphrase['add_filetype'], '', 8);

}
// ################################ Delete Filetype ###########################
if ($_REQUEST['do'] == 'deletefiletype')
{
  $extid = $_REQUEST['extid'];
  print_form_header('vba_gallery_admin', 'deletefile_type');
  construct_hidden_code('extid', $extid);
  print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_delete_filetype']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete Filetype ################################
if ($_REQUEST['do'] == 'deletefile_type')
{
  $filetype = $db->query_first("DELETE FROM " . TABLE_PREFIX . "ppgal_filetypes WHERE extensionid = '$_REQUEST[extid]'");
  print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=filetypes", 0);
}

// ############################# Edit Filetype ################################
if (in_array($_REQUEST['do'], array('addfiletype', 'editfiletype')))
{
	if ($_REQUEST['do'] == 'editfiletype')
	{
		$filetype = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_filetypes WHERE extensionid = '$_REQUEST[extid]'");
		$table_title = $vbphrase['edit_filetype'] . ': ' . $filetype['extension'];
		$form_action = 'doeditfiletype';
	}
	else
	{
		$table_title = $vbphrase['add_filetype'];
		$form_action = 'doaddfiletype';
		$filetype['enabled'] = true;
	}

	print_form_header('vba_gallery_admin', $form_action);
	print_table_header($table_title);

	if ($_REQUEST['do'] == 'editfiletype')
	{
		construct_hidden_code('filetype[extensionid]', $filetype['extensionid']);
	}

	print_input_row($vbphrase['extension'], 'filetype[extension]', $filetype['extension']);
	print_input_row($vbphrase['maximim_filesize_in_bytes'], 'filetype[filesize]', $filetype['filesize']);
	print_input_row($vbphrase['max_width'], 'filetype[width]', $filetype['width']);
	print_input_row($vbphrase['max_height'], 'filetype[height]', $filetype['height']);
    print_input_row($vbphrase['min_width'], 'filetype[min_width]', $filetype['min_width']);
    print_input_row($vbphrase['min_height'], 'filetype[min_height]', $filetype['min_height']);
    print_yes_no_row($vbphrase['enabled'], 'filetype[enabled]', $filetype['enabled']);

	print_submit_row();
}

// ########################### Do Add / Edit Filetype #########################
if (in_array($_POST['do'], array('doaddfiletype', 'doeditfiletype')))
{
	$filetype = $_POST['filetype'];

	if ($_POST['do'] == 'doaddfiletype')
	{
		$db->query_read(fetch_query_sql($filetype, 'ppgal_filetypes'));
	}
	else
	{
		$db->query_read(fetch_query_sql($filetype, 'ppgal_filetypes', 'WHERE extensionid = \'' . $filetype['extensionid'] . '\''));
	}

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=filetypes", 0);
}

// ################################ Add Moderator #############################
if ($_REQUEST['do'] == 'addmoderator')
{
	$cat = $db->query_first("SELECT catid, title FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid'");
	print_form_header('vba_gallery_admin', 'doaddmod');
	print_table_header($vbphrase['add_moderator'] . ' - ' . stripslashes($cat['title']));
	construct_hidden_code('catid', $cat['catid']);
	construct_hidden_code('cattitle', $cat['title']);
	print_description_row($vbphrase['add_moderator_note_permissions']);
	print_input_row($vbphrase['username']. ':', 'username');
	print_submit_row();
}

// ############################### Do Add Moderator ###########################
if ($_POST['do'] == 'doaddmod')
{
	$username = $_POST['username'];

	$user = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . addslashes($username) . "'");

	if (!$user['userid'])
	{
		print_stop_message('invalid_username_specified');
	}

	$ismod = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "ppgal_moderator WHERE userid = '$user[userid]' AND catid = '$catid'");

	if ($ismod['userid'])
	{
		print_stop_message('user_is_already_mod');
	}

	$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_moderator VALUES ('$user[userid]', '" . addslashes($username) . "', '$catid')");

	update_gallery_mod_cache();

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=dirmanager", 0);

}

// ############################### Edit Moderator #############################
if ($_REQUEST['do'] == 'editmoderator')
{
	$modid = intval($_REQUEST['modid']);

	$moderator = $db->query_first("
			SELECT moderator.userid, moderator.username, moderator.catid, categories.title
			FROM " . TABLE_PREFIX . "ppgal_moderator AS moderator
			INNER JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			WHERE userid = '$modid' AND moderator.catid = '$catid'
	");

	if (!$moderator['userid'])
	{
		print_stop_message('invalid_user_specified');
	}

	print_form_header('vba_gallery_admin', 'deletemod');
	construct_hidden_code('userid', $moderator['userid']);
	construct_hidden_code('catid', $moderator['catid']);
	print_table_header(construct_phrase($vbphrase['remove_x_from_moderating_y'], stripslashes($moderator['username']), stripslashes($moderator['title'])) . ' <input type="submit" value="' . $vbphrase['delete'] . '">');
	print_table_footer();
}

// ############################# Do Edit Moderator ############################
if ($_POST['do'] == 'deletemod')
{
	$userid = intval($_POST['userid']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_moderator WHERE userid = '$userid' AND catid = '$catid'");
	update_gallery_mod_cache();
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=dirmanager", 0);
}


// ############################ Manage Custom Fields ##########################
if ($_REQUEST['do'] == 'customfields')
{
	print_form_header('vba_gallery_admin', 'addcustomfield', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header($vbphrase['add_custom_field']);
	print_select_row($vbphrase['custom_field_type'], 'type', $customfieldtypes);
	print_submit_row($vbphrase['continue'], '');

	print_form_header('vba_gallery_admin', 'ordercustom');
	print_table_header($vbphrase['custom_fields'], 4);
	print_cell_row(array($vbphrase['title'], $vbphrase['type'], $vbphrase['display_order'], $vbphrase['controls']), 1, 'thead', -1);

	$getfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields ORDER BY displayorder");
	if ($db->num_rows($getfields))
	{
		while ($fields = $vbulletin->db->fetch_array($getfields))
		{
			$cells = array();
			$cells[] = $fields['title'];
			$cells[] = '<span class="smallfont">' . $customfieldtypes["$fields[type]"] . '</span>';
			$cells[] = '<input class="bginput" name="order[' . $fields['fieldid'] . ']" size="3" type="text" value="'  . $fields['displayorder'] . '" />';
			$cells[] = 	construct_link_code($vbphrase['edit'], 'vba_gallery_admin.php?do=editcustomfield&fieldid=' . $fields['fieldid']) . construct_link_code($vbphrase['delete'], 'vba_gallery_admin.php?do=removecustomfield&amp;fieldid=' . $fields['fieldid']);
			print_cell_row($cells, '', '', -1);

		}

		print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 4);

	}
	else
	{
		print_description_row($vbphrase['not_added_custom_fields'], '', 6);
	}
	print_table_footer();

}

// ############################ Re-Order Custom Fields ########################
if ($_POST['do'] == 'ordercustom')
{
	$order = $_POST['order'];

  foreach ($order AS $key => $disorder)
  {
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_customfields SET displayorder = '$disorder' WHERE fieldid = '$key'");
  }

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]&do=customfields", 0);
}

// ############################# Add Custom Field #############################
if (in_array($_REQUEST['do'], array('addcustomfield', 'editcustomfield')))
{
	$type = htmlspecialchars($_REQUEST['type']);
	$fieldid = intval($_REQUEST['fieldid']);

	print_form_header('vba_gallery_admin', 'do' . $_REQUEST['do']);

	if ($_REQUEST['do'] == 'editcustomfield')
	{
		$custom = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields WHERE fieldid = '$fieldid'");
		construct_hidden_code('custom[fieldid]', $custom['fieldid']);
		$type = $custom['type'];
	}

	construct_hidden_code('custom[type]', $type);
	print_table_header(iif($_REQUEST['do'] == 'addcustomfield', $vbphrase['add_custom_field'] . ' - ' . $customfieldtypes["$type"], $vbphrase['edit_custom_field'] . ' - ' . $custom['title']), 4);
	print_input_row($vbphrase['title'], 'custom[title]', $custom['title']);
	print_textarea_row($vbphrase['description'], 'custom[description]', $custom['description']);
	print_input_row($vbphrase['display_order'], 'custom[displayorder]', $custom['displayorder']);
	print_yes_no_row($vbphrase['field_required'], 'custom[required]', $custom['required']);
	print_yes_no_row($vbphrase['field_is_searchable'], 'custom[searchable]', iif($_REQUEST['do'] == 'addcustomfield', 1, $custom['searchable']));

	if (in_array($type, array('text', 'textarea')))
	{
		print_input_row($vbphrase['max_length_of_allowed_user_input'], 'custom[maxlength]', $custom['maxlength']);
	}
	else
	{
		print_textarea_row(construct_phrase($vbphrase['x_enter_the_options_that_the_user_can_choose_from'], $vbphrase['options']), 'custom[options]', unhtmlspecialchars($custom['options']));
	}

	print_submit_row();
}

// ############################ Do Add Custom Field ###########################
if (in_array($_POST['do'], array('doaddcustomfield', 'doeditcustomfield')))
{
	$custom = $_POST['custom'];

	if (!empty($custom))
	{
		$cfields = array();
		foreach ($custom AS $key => $value)
		{
			$cfields["$key"] = htmlspecialchars($value);
		}
	}

	$db->query_read(fetch_query_sql($cfields, 'ppgal_customfields', iif($_POST['do'] == 'doeditcustomfield', 'WHERE fieldid =  ' . $custom['fieldid'])));

	if ($_POST['do'] == 'doaddcustomfield')
	{
		$newfieldid = $db->insert_id();
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_customfields_entries ADD field$newfieldid MEDIUMTEXT NOT NULL");
	}

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]&do=customfields", 0);

}

// ############################ Delete Custom Field ###########################
if ($_REQUEST['do'] == 'removecustomfield')
{
	$custom = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields WHERE fieldid = '$_REQUEST[fieldid]'");

	print_form_header('vba_gallery_admin', 'doremovecustomfield');
	print_table_header($vbphrase['confirm_deletion']);
	construct_hidden_code('fieldid', $custom['fieldid']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_you_want_to_delete_the_x_called_y'], $vbphrase['custom_fields'], $custom['title'], $vbphrase['id'], $custom['fieldid'], ''));
	print_submit_row($vbphrase['yes'], $vbphrase['no']);
}

// ############################ Do Delete Custom Field ########################
if ($_POST['do'] == 'doremovecustomfield')
{
	$fieldid = intval($_POST['fieldid']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_customfields WHERE fieldid = '$fieldid'");
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_customfields_entries DROP field$fieldid");

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]&do=customfields", 0);
}

// ############################### View e-Cards ###############################
if ($_REQUEST['do'] == 'viewecards')
{
	$perpage = intval($_REQUEST['perpage']);
	$pagenumber = intval($_REQUEST['pagenumber']);

	if (!$perpage)
	{
		$perpage = 50;
	}

  $countcards = $db->query_first("SELECT COUNT(cardid) AS count FROM " . TABLE_PREFIX . "ppgal_ecards");

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$pagecount = ceil($countcards['count'] / $perpage);
	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	if ($maxlimit > $countcards['count'])
	{
		$maxlimit = $countcards['count'];
		if ($minlimit > $countcards['count'])
		{
		  $minlimit = $countcards['count'] - $perpage;
		}
	}
	if ($minlimit <= 0)
	{
	  $minlimit = 1;
	}

	$limit = ($minlimit - 1) . ',' . $perpage;

	print_form_header('vba_gallery_admin', 'viewecards');
	print_table_header($vbphrase['view_ecards'] , 6); // $vbphrase['view_ecards']
	print_cell_row(array($vbphrase['cardid'], $vbphrase['title'], $vbphrase['date'], $vbphrase['to'], $vbphrase['from'], $vbphrase['options']), 1, '', -1);

	$getcards = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_ecards ORDER BY cardid DESC LIMIT $limit");
	while ($card = $vbulletin->db->fetch_array($getcards))
	{
		$cells = array();
		$cells[] = $card['cardid'];
		$cells[] = stripslashes($card['title']);
		$cells[] = vbdate($vbulletin->options['dateformat'], $card['dateline']);
		$cells[] = iif($card['userid'], '<a href="' . $vbulletin->options['bburl'] . '/member.php?u=' . $card['userid'] . '" target="_blank">' . $card['tousername'] . '</a>', $card['tousername']);
		$cells[] = iif($card['fromuserid'], '<a href="' . $vbulletin->options['bburl'] . '/member.php?u=' . $card['fromuserid'] . '" target="_blank">' . $card['fromusername'] . '</a>', '<a href="mailto:' . $card['fromemail'] . '">' . $card['fromusername'] . '</a>');
		$cells[] =  construct_link_code($vbphrase['view'], $ppg_options['gallery_url'] . '/ecard.php?do=viewcard&amp;cardid=' . $card['cardid'], 1). ' ' . construct_link_code($vbphrase['delete'], 'vba_gallery_admin.php?do=removecard&cardid=' . $card['cardid']);

		print_cell_row($cells, '', '', -1);
	}

	if ($pagecount > 1)
	{
		$pagenav = $vbphrase['pages'] . '(' . $pagecount . ') &nbsp; ';
		$i = 0;
		while ($i++ < $pagecount)
		{
			$pagenav .= '<input class="button" name="pagenumber" type="submit" value="' . iif($i > 9, $i, " $i ") . '"' . iif($i == $pagenumber, ' disabled="disabled"') . ' /> ';
		}
	}
	print_table_header($pagenav, 6);

	print_table_footer();
}

// ############################### Delete e-Card ##############################
if ($_REQUEST['do'] == 'removecard')
{
	print_form_header('vba_gallery_admin', 'doremovecard');
	construct_hidden_code('cardid', $_REQUEST['cardid']);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_delete_this_ecard']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete e-Card #############################
if ($_POST['do'] == 'doremovecard')
{
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_ecards WHERE cardid = '$_POST[cardid]'");
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=viewecards", 0);
}

// ################################# Maintenance ##############################
if ($_REQUEST['do'] == 'maintenance')
{

	// Update category counters
	print_form_header('vba_gallery_admin', 'updatecounters');
	print_table_header($vbphrase['update_category_counters']);
	print_description_row(
		'<table width="100%" cellpadding="0" cellspacing="3"><tr><td>' . $vbphrase['update_category_counters_desc'] . '</td>
		<td nowrap="nowrap"><input checked="checked" name="imagecount" type="checkbox" value="1" /> ' . $vbphrase['image_counts'] . '<br />
		<input checked="checked" name="postcount" type="checkbox" value="1" /> ' . $vbphrase['post_counts'] . '<br />
		<input checked="checked" name="lastimages" type="checkbox" value="1" /> ' . $vbphrase['last_image_info']  . '
		</td></tr></table>'
	);
	print_submit_row($vbphrase['update_counters'], '');

	// Update Usernames
	print_form_header('vba_gallery_admin', 'updateusernames');
	print_table_header($vbphrase['update_usernames']);
	print_description_row($vbphrase['update_usernames_desc']);
	print_submit_row($vbphrase['update_usernames'], '');

	// Update User Posts's and Images
	print_form_header('vba_gallery_admin', 'updateuserposts');
	print_table_header($vbphrase['update_usercount']);
	print_description_row($vbphrase['update_usercount_desc']);
	print_submit_row($vbphrase['update_counters'], '');

	// Update Image Post Info
	print_form_header('vba_gallery_admin', 'updatelastpost');
	print_table_header($vbphrase['update_image_information']);
	print_description_row($vbphrase['update_image_info_desc']);
	print_submit_row($vbphrase['update_counters'], '');

    // Update Category Cache
	print_form_header('vba_gallery_admin', 'updatecatcache');
	print_table_header('Update Category Cache');
	print_description_row($vbphrase['update_image_info_desc']);
	print_submit_row($vbphrase['update_counters'], '');

	// Rebuild Thumbnails
	print_form_header('vba_gallery_admin', 'rebuildthumbs');
	print_table_header($vbphrase['rebuild_image_sizes']);
	print_description_row($vbphrase['rebuild_image_sizes_desc']);
	print_select_row($vbphrase['type'], 'thumbs', array(1 => $vbphrase['thumbnails'], 0 => $vbphrase['normal_images'], 2 => $vbphrase['category']), 1);
	print_category_select('catid', '', $vbphrase['all_categories'], $vbphrase['category']);
	print_select_row($vbphrase['per_page'] . ':', 'perpage', array(10 => 10, 25 => 25, 50 => 50, 75 => 75, 100 => 100));
	print_submit_row($vbphrase['rebuild_image_sizes'], '');

	// Rebuild Image Info
	print_form_header('vba_gallery_admin', 'rebuildimageinfo');
	print_table_header($vbphrase['rebuild_image_info']);
	print_description_row($vbphrase['rebuild_imageinfo_desc']);
	print_category_select('catid', '', $vbphrase['all_categories'], $vbphrase['category']);
	print_select_row($vbphrase['per_page'] . ':', 'perpage', array(10 => 10, 25 => 25, 50 => 50, 75 => 75, 100 => 100));
	print_submit_row($vbphrase['rebuild_image_info'], '');

        // Scan Database
	print_form_header('vba_gallery_admin', 'scandb');
	print_table_header($vbphrase['scan_database']);
	print_description_row($vbphrase['scan_database_for_problems_checks_orphan_broken_images']);
	print_submit_row($vbphrase['scan_database'], '');

        // Watermark Files
	print_form_header('vba_gallery_admin', 'watermarkfiles');
	print_table_header($vbphrase['watermark_files']);
	print_description_row(construct_phrase($vbphrase['watermark_files_desc'], $ppg_options['gallery_filesdirectory']));
	print_category_select('catid', '', $vbphrase['all_categories'], $vbphrase['category']);
	print_select_row($vbphrase['per_page'] . ':', 'perpage', array(10 => 10, 25 => 25, 50 => 50, 75 => 75, 100 => 100));
	print_submit_row($vbphrase['watermark_files'], '');

        // Remove Original Images
	print_form_header('vba_gallery_admin', 'removeoriginals');
	print_table_header($vbphrase['remove_original_images']);
	print_description_row($vbphrase['remove_original_images_desc']);
	print_category_select('catid', '', $vbphrase['all_categories'], $vbphrase['category']);
	print_select_row($vbphrase['per_page'] . ':', 'perpage', array(10 => 10, 25 => 25, 50 => 50, 75 => 75, 100 => 100));
	print_submit_row($vbphrase['remove_original_images'], '');


	// Safe mode bypass
	print_form_header('vba_gallery_admin', 'storage');
	print_table_header($vbphrase['change_file_storage_method']);
	print_description_row(construct_phrase($vbphrase['change_file_storage_method_desc'], '<b>' . iif($ppg_options['gallery_insafemode'], $vbphrase['off'], $vbphrase['on']) . '</b>'));
	print_submit_row($vbphrase['change_file_storage_method'], '');



}

// ################################ Safe mode bypass  ###########################
if ($_REQUEST['do'] == 'storage')
{
	print_form_header('vba_gallery_admin', 'storagemethod');
	print_table_header($vbphrase['change_file_storage_method']);
	print_description_row($vbphrase['change_file_storage_method_yes_no']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}


// ################################ Update Counters ###########################
if ($_REQUEST['do'] == 'updatecounters')
{
	$imagecount = intval($_REQUEST['imagecount']);
	$postcount = intval($_REQUEST['postcount']);
	$lastimages = intval($_REQUEST['lastimages']);

	if (!$imagecount AND !$postcount AND !$lastimages)
	{
		print_stop_message('adv_gallery_must_choose_update');
	}

	update_count(0, $imagecount, $postcount, $lastimages);
	define('CP_REDIRECT', 'vba_gallery_admin.php?do=maintenance');
	print_stop_message('adv_gallery_updated_counters');
}

// ####################### Credits and AdminCP Stats ##############################
if ($_REQUEST['do'] == 'stats')
{


	// ##### Need Moderate
	$imgcount = $db->query_first("SELECT COUNT(imageid) AS imgcount FROM " . TABLE_PREFIX . "ppgal_images WHERE valid = 0");
	$postcount = $db->query_first("SELECT COUNT(postid) AS postcount FROM " . TABLE_PREFIX . "ppgal_posts WHERE visible = 0");

    $total = array();
    foreach ($totalcache AS $totals)
    {
     $total[] = $totals;
    }

    $maximages = $total['0']['images'];
    $maxviews = $total['0']['views'];
    $maxposts = $total['0']['posts'];
    $maxfilesize = $total['0']['filesize'];
    $maxorigfilesize = $total['0']['origfilesize'];
    $maxcategories = $total['1']['categories'];
    $maxmembercat = $total['1']['membercat'];
    $maxcards = $total['2']['cards'];

    unset($total);

    // Total Stats
    $stats['images'] = vb_number_format($maximages);
    $stats['views'] = vb_number_format($maxviews);
    $stats['categories'] = vb_number_format($maxcategories);
    $stats['memcat'] = vb_number_format($maxmembercat);
    $stats['cards'] = vb_number_format($maxcards);
    $stats['posts'] = vb_number_format($maxposts);
    $stats['diskspace'] = vb_number_format($maxfilesize + $maxorigfilesize, 1, true);

    $cversion = @file_get_contents('http://www.photopost.com/members/vcheck.pl?p=11', 'r');

    if ($cversion > $ppg_options['gallery_version']){
	print_form_header('', '');
	print_table_header($vbphrase['welcome_to_vba_gallery_control_panel']);
	print_description_row(iif($cversion, construct_phrase($vbphrase['currently_running_latest_available'], $ppg_options['gallery_version'], $cversion, iif($cversion == $ppg_options['gallery_version'], $vbphrase['your_vba_version_up_to_date'], $vbphrase['newer_version_available'])), $vbphrase['version_info_unavailable']));
	print_table_footer();
	}


	    print_form_header('index', 'home');
	print_form_header('vba_gallery_admin', 'saveopts');
	print_table_header('PhotoPost vBGallery News');
	print_description_row("<iframe src=\"http://www.photopost.com/vbgnews.php?v={$ppg_options['gallery_version']}&cid=REPLACEME\" width=\"100%\" height=\"110\"></iframe>");
	print_table_footer();

	    print_form_header('index', 'home');
	    print_table_header('PhotoPost vBGallery Statistic', 6);

	    print_cell_row(array(
	        $vbphrase['adv_gallery_acp_totalimg'], $stats['images'],
	        $vbphrase['validate_new_images'], $imgcount['imgcount'] . ' ' . construct_link_code($vbphrase['view'], '../' . $vbulletin->config['Misc']['modcpdir'] . '/vba_gallery.php?' . $vbulletin->session->vars['sessionurl'] . "do=validateimages"),    ), 0, 0, -5, 'top', 1, 1);
	    print_cell_row(array(
	        $vbphrase['posts'], $stats['posts'],
	        $vbphrase['validate_new_posts'], $postcount['postcount'] . ' ' . construct_link_code($vbphrase['view'], '../' . $vbulletin->config['Misc']['modcpdir'] . '/vba_gallery.php?' . $vbulletin->session->vars['sessionurl'] . "do=validateposts"),    ), 0, 0, -5, 'top', 1, 1);
	    print_cell_row(array(
	        $vbphrase['adv_gallery_acp_totalcat'], $stats['categories'],
	        $vbphrase['adv_gallery_acp_totalecard'], $stats['cards'] . ' ' . construct_link_code($vbphrase['view'], '../' . $vbulletin->config['Misc']['admincpdir'] . '/vba_gallery_admin.php?' . $vbulletin->session->vars['sessionurl'] . "do=viewecards"), ), 0, 0, -5, 'top', 1, 1);
	    print_cell_row(array(
	        $vbphrase['adv_gallery_acp_totalspace'], $stats['diskspace'],
	        $vbphrase['adv_gallery_acp_totalviews'], $stats['views'], ), 0, 0, -5, 'top', 1, 1);
			print_cell_row(array(
					'<br />','',
					'',''), 0, 0, -5, 'top', 1, 1);
			print_cell_row(array(
	        'Installed Version', $ppg_options['gallery_version'],
	        'Latest Version', $cversion, ), 0, 0, -5, 'top', 1, 1);
		print_cell_row(array(
					$vbphrase['software_developed_by'], '	<a href="http://www.allenthusiast.com/" target="vbulletin">All Enthusiast, Inc.</a>	',
					$vbphrase['software_development'],'<a href="http://www.photopost.com/forum/member.ph' . 'p?u=1" target="vbulletin">ScottW</a>, <a href="http://www.photopost.com/forum/member.ph' . 'p?u=3774" target="vbulletin">Michael P</a>, <a href="http://www.photopost.com/forum/member.ph' . 'p?u=61725" target="vbulletin">Chuck S</a>,'), 0, 0, -5, 'top', 1, 1);
			print_cell_row(array(
					$vbphrase['product_manager'], '<a href="http://www.photopost.com/forum/member.ph' . 'p?u=3774" target="vbulletin">Michael P</a>',
					'', ' <a href="http://www.photopost.com/forum/member.ph' . 'p?u=79609" target="vbulletin">trackpads</a>, <a href="http://www.photopost.com/forum/member.ph' . 'p?u=174950" target="vbulletin">Zachariah</a>'), 0, 0, -5, 'top', 1, 1);
			print_cell_row(array(
					$vbphrase['business_development'], '<a href="http://www.photopost.com/forum/member.ph' . 'p?u=1" target="vbulletin">ScottW</a>',
					$vbphrase['graphics_development'], '<a href="http://www.photopost.com/forum/member.ph' . 'p?u=3774" target="vbulletin">Michael P</a>'), 0, 0, -5, 'top', 1, 1);
			print_cell_row(array($vbphrase['copyright_enforcement_by'], '<a href="http://www.photopost.com/ppost_contact.pl" target="vbulletin">Pirate Reports</a>',
			$vbphrase['useful_links'], '
		<form style="display:inline">
		<select onchange="if (this.options[this.selectedIndex].value != \'\') { window.open(this.options[this.selectedIndex].value); } return false;" tabindex="1" class="bginput">
			<option value="">-- ' . $vbphrase['useful_links'] . ' --</option>' . construct_select_options(array(
				'PhotoPost' => array(
					'http://www.photopost.com/' => $vbphrase['home_page'],
					'https://www.photopost.com/members/members.pl' => $vbphrase['members_area'],
					'http://www.photopost.com/forum/' => $vbphrase['community_forums']
				)
		)) . '</select>
		</form>
		'), 0, 0, -5, 'top', 1, 1);

	print_table_footer();


    print_table_start();
    print_table_header('Newest 20 Uploads', 5);

    $newimages = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_images ORDER BY dateline DESC LIMIT 0,20");
        while ($newimage = $db->fetch_array($newimages)){
            $n = $n+1;
            $newd = vbdate($vbulletin->options['dateformat'], $newimage['dateline']);
	        $newt = vbdate($vbulletin->options['timeformat'], $newimage['dateline']);
            $newtime = $newtime."$newt<br />";
            $newdate = $newdate."$newd<br />";
            $newext = $newext."".$newimage['extension']."<br />";
            $newtitle = $newtitle."$n. <a target=\"_blank\" href=\"$ppg_options[gallery_url]/showimage.php?i=".$newimage[imageid]."&catid=".$newimage[catid]."\">".$newimage[title]."</a><br />";
            $newusername = $newusername."<a target=\"_blank\" href=\"$ppg_options[gallery_url]/browseimages.php?do=member&imageuser=".$newimage[userid]."\">".$newimage[username]."</a> <br />";
        }

      echo "<tr align=\"left\" valign=\"top\">
              <td class=\"thead\">$vbphrase[image]</td>
              <td class=\"thead\" align=\"center\">$vbphrase[extension]</td>
              <td class=\"thead\" align=\"center\">$vbphrase[date]</td>
              <td class=\"thead\" align=\"center\">$vbphrase[time]</td>
              <td class=\"thead\" align=\"center\">$vbphrase[user]</td>
          </tr>";
      echo "<tr valign=\"top\">
              <td class=\"alt1\">$newtitle</td>
              <td class=\"alt1\" align=\"center\">$newext</td>
              <td class=\"alt1\" align=\"center\">$newdate</td>
              <td class=\"alt1\" align=\"center\">$newtime</td>
              <td class=\"alt1\" align=\"center\">$newusername</td>
          </tr>";
    print_table_footer();

}

// ############################### Do Maintenance #############################
if (in_array($_REQUEST['do'], array('rebuildthumbs', 'rebuildimageinfo', 'watermarkfiles', 'removeoriginals', 'storagemethod')))
{

	$perpage = intval($_REQUEST['perpage']);
	$pagenumber = intval($_REQUEST['pagenumber']);
	$thumbs = intval($_REQUEST['thumbs']);

	require_once(DIR . '/includes/functions_gallery_imageedit.php');

	if (!$perpage)
	{
		$perpage = 10;
	}

	$wherequery = array();
	$wherequery[] = 'valid = 1';
	if ($imageid)
	{
		$wherequery[] = 'imageid = ' . $imageid;
	}

	if ($catid)
	{
		$wherequery[] = 'catid = ' . $catid;
	}

	if ($_REQUEST['do'] == 'removeoriginals')
	{
		$wherequery[] = 'originalname != \'\'';
	}

  $countimages = $db->query_first("SELECT COUNT(imageid) AS count FROM " . TABLE_PREFIX . "ppgal_images AS images WHERE " . implode(' AND ', $wherequery));

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	if ($maxlimit > $countimages['count'])
	{
		$maxlimit = $countimages['count'];
		if ($minlimit > $countimages['count'])
		{
		  $minlimit = $countimages['count'] - $perpage;
		}
	}
	if ($minlimit <= 0)
	{
	  $minlimit = 1;
	}

	$lastpage = ceil($countimages['count'] / $perpage);

	if ($lastpage == 0)
	{
		$lastpage = 1;
	}

	$usno = '1';

	echo construct_phrase($vbphrase['page_x_of_y'], $pagenumber, $lastpage) . '<br /><br />';

	$getimages = $db->query_read("SELECT imageid, catid, userid, filename AS saveas, thumbname AS currentthumb, width, height, extension, originalname, originalwidth, originalheight FROM " . TABLE_PREFIX . "ppgal_images WHERE " . implode(' AND ', $wherequery) . " ORDER BY imageid DESC LIMIT " . ($minlimit - 1) . ", $perpage");
	while ($imageinfo = $vbulletin->db->fetch_array($getimages))
	{
		$userid = $imageinfo['userid'];

		$folderstring = fetch_folder_path($imageinfo);

		$imageinfo['filename'] = $imageinfo['saveas'];
		$imageinfo['saveto'] = $folderstring;
		$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
		$imageinfo['shortname'] = substr($imageinfo['filename'], 0, strrpos($imageinfo['filename'], '.'));

		switch ($_REQUEST['do'])
		{
			case 'storagemethod':

				if ($ppg_options['gallery_insafemode'])
				{
					$ppg_options['gallery_insafemode'] = 0;
					$userid = $imageinfo['userid'];
					$newfolderstring = construct_folder_path();
					$ppg_options['gallery_insafemode'] = 1;

					$strip = strlen($imageinfo['userid']) + 1;

					$newfilename = substr($imageinfo['filename'], $strip);

					$stquery = array();
					$stquery[] = 'filename = \'' . $newfilename . '\'';
					@copy($imageinfo['location'], $newfolderstring . '/' . $newfilename);
					@unlink($imageinfo['location']);
					if ($imageinfo['currentthumb'])
					{
						$newthumbname = substr($imageinfo['currentthumb'], $strip);

						$stquery[] = 'thumbname = \'' . $newthumbname . '\'';
						@copy($imageinfo['saveto'] . '/' . $imageinfo['currentthumb'], $newfolderstring . '/' . $newthumbname);
						@unlink($imageinfo['saveto'] . '/' . $imageinfo['currentthumb']);
					}
					if ($imageinfo['originalname'])
					{
						$neworigname = substr($imageinfo['originalname'], $strip);
						$stquery[] = 'originalname = \'' . $neworigname . '\'';
						@copy($imageinfo['saveto'] . '/' . $imageinfo['originalname'], $newfolderstring . '/' . $neworigname);
						@unlink($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
					}
				}
				else
				{
					$stquery = array();
					$stquery[] = 'filename = \'' . $imageinfo['userid'] . '-' . $imageinfo['filename'] . '\'';
					@copy($imageinfo['location'], $ppg_options['gallery_filedirectory'] . '/' . $imageinfo['userid'] . '-' . $imageinfo['filename']);
					@unlink($imageinfo['location']);
					if ($imageinfo['currentthumb'])
					{
						$stquery[] = 'thumbname = \'' . $imageinfo['userid'] . '-' . $imageinfo['currentthumb'] . '\'';
						@copy($imageinfo['saveto'] . '/' . $imageinfo['currentthumb'], $ppg_options['gallery_filedirectory'] . '/' . $imageinfo['userid'] . '-' . $imageinfo['currentthumb']);
						@unlink($imageinfo['saveto'] . '/' . $imageinfo['currentthumb']);
					}
					if ($imageinfo['originalname'])
					{
						$stquery[] = 'originalname = \'' . $imageinfo['userid'] . '-' . $imageinfo['originalname'] . '\'';
						@copy($imageinfo['saveto'] . '/' . $imageinfo['originalname'], $ppg_options['gallery_filedirectory'] . '/' . $imageinfo['userid'] . '-' . $imageinfo['originalname']);
						@unlink($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
					}
				}

				echo construct_phrase($vbphrase['moving_image'], $imageinfo['filename']);

				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET " . implode(', ', $stquery) . " WHERE imageid = '$imageinfo[imageid]'");

				break;

			case 'watermarkfiles':
				watermark_image('normal', true);

				if ($imageinfo['originalname'])
				{
					watermark_image('original', true);
				}
				break;

			case 'removeoriginals':
				@unlink($folderstring . '/' . $imageinfo['originalname']);
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET originalname = '', originalwidth = '', originalheight = '', originalfilesize = '' WHERE imageid = '$imageinfo[imageid]'");
				break;

			case 'rebuildthumbs':
				$imagedata = @getimagesize($imageinfo['location']);
				$imageinfo['numericaltype'] = $imagedata[2];
				$imageinfo['type'] = @image_type_to_mime_type($imagedata[2]);

				echo $vbphrase['resizing_image'] . ': ' . $imageinfo['imageid'] . ' (' . $imageinfo['saveas'] . ')<br />';

				if ($thumbs == 1)
				{
					if (empty($catoptions["$imageinfo[catid]"]))
					{
						$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
					}
                    if (in_array($imageinfo['extension'], array_keys($imgtypearray)))
                    {
                    //@unlink($folderstring . '/' . $imageinfo['currentthumb']);
                    @chmod($folderstring . '/' . $imageinfo['currentthumb'], 0777);
                    }
                    resize_image($catoptions["$imageinfo[catid]"]['gallery_thumbsize'], $catoptions["$imageinfo[catid]"]['gallery_thumbsize'], 0);
					if ($imageinfo['thumbname'] != $imageinfo['currentthumb'])
					{
						$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET thumbname = '" . addslashes($imageinfo['thumbname']) . "' WHERE imageid = '$imageinfo[imageid]'");
					}
				}
				if ($thumbs == 0)
                {
					$filetypes = fetch_cat_ext_info();

					if ($imageinfo['originalname'] AND $imageinfo['originalheight'] <= $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height'] AND $imageinfo['originalwidth'] <= $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'])
					{
						// Got original, but it's not big enough for an original
						@copy($imageinfo['saveto'] . '/' . $imageinfo['originalname'], $imageinfo['location']);
						@unlink($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
						$imageinfo['originalname'] = '';
						$imageinfo['originalwidth'] = '';
						$imageinfo['originalheight'] = '';
						$imageinfo['originalfilesize'] = '';
					}
					else if ($ppg_options['gallery_saveoriginal'] AND !$imageinfo['originalname'] AND ($imageinfo['width'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'] OR $imageinfo['height'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height']))
					{
						// Normal image is too big, need to save as original
						$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
						$imageinfo['originalname'] = $imageinfo['shortname'] . '_original.' . $imageinfo['extension'];
						copy($imageinfo['location'], $imageinfo['saveto'] . '/' . $imageinfo['originalname']);
						$imageinfo['originalfilesize'] = $imageinfo['filesize'];
						$imageinfo['originalwidth'] = $imageinfo['width'];
						$imageinfo['originalheight'] = $imageinfo['height'];
						// Reduce the quality if necessary
						if (!in_array($ppg_options['gallery_origquality'], array(-1, 100)) AND $imageinfo['numericaltype'] != 1)
						{
							modify_image($imageinfo['saveto'] . '/' . $imageinfo['originalname'], $imageinfo['width'], $imageinfo['height'], $ppg_options['gallery_origquality']);
							clearstatcache();
							$imageinfo['originalfilesize'] = @filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
						}
					}

					if ($imageinfo['originalname'])
					{
						$imageinfo['width'] = $imageinfo['originalwidth'];
						$imageinfo['height'] = $imageinfo['originalheight'];
						$savepath = $imageinfo['location'];
						$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['originalname'];
					}

					resize_image($filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'], $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height'], 1, false, $savepath);

			}

            if ($thumbs == 2){
            $getcats = $db->query_read("SELECT catid, catimage, title FROM " . TABLE_PREFIX . "ppgal_categories WHERE catimage != ''");
			while ($cat = $vbulletin->db->fetch_array($getcats))
			{
                $catimage = unserialize($cat['catimage']);
				$thumbinfo = @getimagesize($ppg_options['gallery_filedirectory'] . '/' . $catimage['url']);
				$catimage['w'] = $thumbinfo[0];
				$catimage['h'] = $thumbinfo[1];
				$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET catimage = '" . addslashes(serialize($catimage)) . "' WHERE catid = '$cat[catid]'");
                echo 'Updated: '.$cat['title'].' - ' . $ppg_options['gallery_filedirectory'] . '/' . $catimage['url'] . '<br />';
            }
            $db->free_result($getcats);
            unset($getcats, $cats);
            update_category_cache();
            $pagenumber = $lastpage;
            }
		}

		if ($_REQUEST['do'] == 'rebuildimageinfo' OR ($_REQUEST['do'] == 'rebuildthumbs' AND $thumbs == 0))
		{
			$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
            $imagedata = getimagesize($imageinfo['location']);

			clearstatcache();
			$imageinfo['width'] = $imagedata[0];
			$imageinfo['height'] = $imagedata[1];
			$imageinfo['filesize'] = @filesize($imageinfo['location']);

			if ($imageinfo['originalname'])
			{
				$origimagedata = @getimagesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
				$imageinfo['originalwidth'] = $origimagedata[0];
				$imageinfo['originalheight'] = $origimagedata[1];

				$imageinfo['originalfilesize'] = filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
				if (!$imageinfo['originalfilesize'] OR (in_array($imageinfo['extension'], array_keys($imgtypearray)) AND !$imageinfo['originalwidth']))
				{
					@unlink($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
					$imageinfo['originalname'] = '';
					$imageinfo['originalwidth'] = '';
					$imageinfo['originalheight'] = '';
					$imageinfo['originalfilesize'] = '';
				}
			}

			echo $vbphrase['rebuilding_image_info'] . ': ' . $imageinfo['imageid'] . ' (' . $imageinfo['saveas'] . ')<br /><br />';
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET filesize = '$imageinfo[filesize]', width = '$imageinfo[width]', height = '$imageinfo[height]', originalname = '$imageinfo[originalname]', originalwidth = '$imageinfo[originalwidth]', originalheight = '$imageinfo[originalheight]', originalfilesize = '$imageinfo[originalfilesize]' WHERE imageid = '$imageinfo[imageid]'");
		}
        flush();
	}

	$nextpage = $pagenumber+1;

	if ($pagenumber == $lastpage)
	{
		if ($_REQUEST['do'] == 'storagemethod')
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_setting SET value = " . iif($ppg_options['gallery_insafemode'], 0, 1) . " WHERE varname = 'gallery_insafemode'");

			build_adv_settings();
		}

        print_cp_redirect('vba_gallery_admin.php?' . $session['sessionurl'] . 'do=maintenance');
	}
	else
	{
		print_cp_redirect('vba_gallery_admin.php?' . $session['sessionurl'] . 'do=' . $_REQUEST['do'] . '&pagenumber=' . $nextpage . '&perpage=' . $perpage . '&catid=' . $catid . '&thumbs=' . $thumbs);
	}
}

// ############################### Scan Database ##############################
if ($_REQUEST['do'] == 'scandb')
{
	print_form_header('vba_gallery_admin', 'fixproblems');
	print_table_header('<span class="smallfont" style="float:' . $stylevar['right'] . '">' . $vbphrase['check_all'] . ' <input name="allbox" onclick="js_check_all(this.form);" type="checkbox" title="' . $vbphrase['check_all'] . '" /></span>' . $vbphrase['problems_found']);

	$filenamecache = array();
	$filedirsub = strlen($ppg_options['gallery_filedirectory']);

	$categories = $db->query_read("SELECT catid, title FROM " . TABLE_PREFIX . "ppgal_categories ORDER BY catid");
	while ($category = $vbulletin->db->fetch_array($categories))
	{
		$problems = array();

		$images = $db->query_read("SELECT imageid, userid, filename, thumbname, originalname FROM " . TABLE_PREFIX . "ppgal_images WHERE catid = '$category[catid]'");
		while ($image = $vbulletin->db->fetch_array($images))
		{
			$folderpath = fetch_folder_path($image);
			if ($image['thumbname'] AND !is_file($folderpath . '/' . $image['thumbname']))
			{
				$problems["$image[filename]"]['problem'] = 'broken_thumbnail';
				$problems["$image[filename]"]['imageid'] = $image['imageid'];
			}

			if (!is_file($folderpath . '/' . $image['filename']))
			{
				$problems["$image[filename]"]['problem'] = 'file_not_found';
				$problems["$image[filename]"]['imageid'] = $image['imageid'];
			}

			$shortfolderpath = substr($folderpath, $filedirsub);

			$filenamecache[] = $shortfolderpath . '/' . $image['filename'];
			if ($image['thumbname'])
			{
				$filenamecache[] = $shortfolderpath . '/' . $image['thumbname'];
			}
			if ($image['originalname'])
			{
				$filenamecache[] = $shortfolderpath . '/' . $image['originalname'];
			}
		}

		$db->free_result($images);
		unset($image);

		if (!empty($problems))
		{
			$counter = 0;
			echo '<tr class="thead"><td colspan="2"><b>' . construct_phrase($vbphrase['x_id_y'], '<a href="' . $ppg_options['gallery_url'] . '/browseimages.php?c=' . $category['catid'] . '" target="_blank">' . $category['title'] . '</a>', $category['catid']) . '</b></td></tr>';

			foreach ($problems AS $filename => $problem)
			{
				$totalcounter++;

				echo '<tr class="' . fetch_row_bgclass() . '"><td>' . $vbphrase["$problem[problem]"] . ': ';

				switch ($problem['problem'])
				{
					case 'file_not_found':
						echo '<a href="' . $ppg_options['gallery_url'] . '/showimage.php?i=' . $problem['imageid'] . '" target="_blank">' . $filename . '</a></td><td align="' . $stylevar['right'] . '" width="10%" nowrap="nowrap"><label for="fixproblem_' . $problem['imageid'] . '"><span class="smallfont">' . $vbphrase['delete'] . '</span> <input id="fixproblem_' . $problem['imageid'] . '" type="checkbox" checked="checked" name="fixproblem[' . $problem['imageid'] . ']" value="deleteimage"></label></td>';
						break;

					case 'broken_thumbnail':
						echo '<a href="' . $ppg_options['gallery_url'] . '/showimage.php?i=' . $problem['imageid'] . '" target="_blank">' . $filename . '</a></td><td align="' . $stylevar['right'] . '" width="10%" nowrap="nowrap"><label for="fixproblem_' . $problem['imageid'] . '"><span class="smallfont">' . $vbphrase['rebuild_thumbnails'] . '</span> <input id="fixproblem_' . $problem['imageid'] . '" type="checkbox" checked="checked" name="fixproblem[' . $problem['imageid'] . ']" value="thumb"></label></td>';
						break;

				}

				echo '</td></tr>';
			}
		}

		flush();
	}
	unset($problems);

	$ofiles = array();

	fetch_orphaned_files($ppg_options['gallery_filedirectory']);

	$orphans = array_diff($ofiles, $filenamecache);
	unset($ofiles, $filenamecache);

	if (!empty($orphans))
	{
		print_table_break();
		print_table_header($vbphrase['not_in_database']);

		foreach ($orphans AS $ofilename)
		{
			echo '<tr class="' . fetch_row_bgclass() . '"><td><a href="' . $ppg_options['gallery_fileurl'] . $ofilename . '" target="_blank">' . $ofilename . '</a></td><td width="10%" nowrap="nowrap"><label for="fixproblem_' . $ofilename . '"><span class="smallfont">' . $vbphrase['delete'] . '</span> <input id="fixproblem_' . $ofilename . '" name="fixproblem[' . $ofilename . ']" type="checkbox" checked="checked" value="deletefile"></label></td></tr>';

		}
	}

	print_table_break();

	print_description_row('<center>' . $vbphrase['total'] . ': ' . intval($totalcounter + sizeof($orphans)) . ' ' . $vbphrase['problems_found'] . '</center>');

	print_table_break();

	print_submit_row($vbphrase['fix_selected_problems'], '');

}

// ################################ Fix Problems ##############################
if ($_POST['do'] == 'fixproblems')
{
	$fixproblem = $_POST['fixproblem'];

	require_once(DIR . '/includes/functions_gallery_imageedit.php');

	if (!empty($fixproblem))
	{
		foreach ($fixproblem AS $id => $problem)
		{
			switch ($problem)
			{
				case 'deleteimage':
					delete_images($id);
					$updatecount = true;
					break;

				case 'deletefile':
					@unlink($ppg_options['gallery_filedirectory'] . $id);
					break;

				case 'thumb':

					$imageinfo = $db->query_first("SELECT imageid, catid, userid, filename AS saveas, thumbname AS currentthumb, width, height, extension FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$id' AND valid = 1");

					$userid = $imageinfo['userid'];

					$folderstring = fetch_folder_path($imageinfo);

					$imageinfo['filename'] = $imageinfo['saveas'];
					$imageinfo['saveto'] = $folderstring;
					$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
					$imageinfo['shortname'] = substr($imageinfo['filename'], 0, strrpos($imageinfo['filename'], '.'));

					$imagedata = @getimagesize($imageinfo['location']);
					$imageinfo['numericaltype'] = $imagedata[2];
					$imageinfo['type'] = @image_type_to_mime_type($imagedata[2]);

					if (empty($catoptions["$imageinfo[catid]"]))
					{
						$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
					}
					resize_image($catoptions["$imageinfo[catid]"]['gallery_thumbsize'], $catoptions["$imageinfo[catid]"]['gallery_thumbsize'], 0);

					resize_image($ppg_options['gallery_thumbsize'], $ppg_options['gallery_thumbsize'], 0);

					if ($imageinfo['thumbname'] != $imageinfo['currentthumb'])
					{
						$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET thumbname = '" . addslashes($imageinfo['thumbname']) . "' WHERE imageid = '$imageinfo[imageid]'");
					}

					break;
			}
		}
	}

	if ($updatecount)
	{
		update_count();
	}

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=maintenance");

}

// ############################# Update Usernames #############################
if ($_REQUEST['do'] == 'updateusernames')
{
	$users = $db->query_read("
			SELECT DISTINCT images.userid, images.username AS imageusername, user.username
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "user AS user USING (userid)
	");
	while ($user = $vbulletin->db->fetch_array($users))
	{
		if ($user['imageusername'] != $user['username'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET username = '" . addslashes($user['username']) . "' WHERE userid = '$user[userid]'");
		}
	}

	$db->free_result($users);
	unset($user);

	$users = $db->query_read("
			SELECT DISTINCT posts.userid, posts.username AS imageusername, user.username
			FROM " . TABLE_PREFIX . "ppgal_posts AS posts
			LEFT JOIN " . TABLE_PREFIX . "user AS user USING (userid)
	");
	while ($user = $vbulletin->db->fetch_array($users))
	{
		if ($user['imageusername'] != $user['username'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_posts SET username = '" . addslashes($user['username']) . "' WHERE userid = '$user[userid]'");
		}
	}

	print_stop_message('adv_gallery_updated_usernames');
}

// ############################# Update user image and post count #############################
if ($_REQUEST['do'] == 'updateuserposts'){
            // make sure user tables sync
            $users = $db->query_read("SELECT userid FROM " . TABLE_PREFIX . "user AS user");
            while ($user = $vbulletin->db->fetch_array($users))
            {
                $db->query_write("REPLACE INTO " . TABLE_PREFIX . "ppgal_user (userid) VALUES ($user[userid])");
            }
            unset($users);

            // find user values
        	$lastuploads = $db->query_read("SELECT userid FROM " . TABLE_PREFIX . "ppgal_user");
        	while ($last = $vbulletin->db->fetch_array($lastuploads))
        	{
                $totalposts = $db->query_first("SELECT COUNT(postid) AS postcount FROM " . TABLE_PREFIX . "ppgal_posts WHERE userid = $last[userid] AND visible = 1");
                $totalimages = $db->query_first("SELECT COUNT(imageid) AS imagecount FROM " . TABLE_PREFIX . "ppgal_images WHERE userid = $last[userid] AND valid = 1");
                $lastimage = $db->query_first("SELECT imageid, title, dateline, valid FROM " . TABLE_PREFIX . "ppgal_images WHERE userid = $last[userid] AND valid = 1 ORDER BY dateline DESC limit 1");
                $lastpost = $db->query_first("SELECT postid, title, dateline, visible FROM " . TABLE_PREFIX . "ppgal_posts WHERE userid = $last[userid] AND visible = 1 ORDER BY dateline DESC limit 1");

        		$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user
                    SET
                    ppicount = '$totalimages[imagecount]',
                    pppcount = '$totalposts[postcount]',
                    lastimageid = '$lastimage[imageid]',
                    lastimagedate = '$lastimage[dateline]',
                    lastimagetitle = '" . $db->escape_string($lastimage['title']) . "',
                    lastpostdate = '$lastpost[dateline]',
                    lastpostid = '$lastpost[postid]',
                    lastposttitle = '" . $db->escape_string($lastpost['title']) . "'
                    WHERE userid = '$last[userid]'
                ");
            }
            unset($lastuploads,$lastimage,$lastpost,$totalposts,$totalimages);
	        vbflush();

	define('CP_REDIRECT', 'vba_gallery_admin.php?do=maintenance');
	print_stop_message('adv_gallery_updated_counters');
}

// ############################ Update Last Post ##############################
if ($_REQUEST['do'] == 'updatelastpost')
{
	$images = $db->query_read("SELECT imageid, lastpostdateline, lastpostuserid, lastpostusername, posts FROM " . TABLE_PREFIX . "ppgal_images");
	while ($image = $vbulletin->db->fetch_array($images))
	{
		$postcount = $db->query_first("SELECT COUNT(postid) AS count FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid = '$image[imageid]' AND visible = 1");

		$posts = $db->query_first("SELECT userid, dateline, username FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid = '$image[imageid]' AND visible = 1 ORDER BY dateline DESC");

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET posts = '$postcount[count]', lastpostdateline = '$posts[dateline]', lastpostuserid = '$posts[userid]', lastpostusername = '" . addslashes($posts['username']) . "' WHERE imageid = '$image[imageid]'");

		unset($posts);
	}

	define('CP_REDIRECT', 'vba_gallery_admin.php?do=maintenance');
	print_stop_message('adv_gallery_updated_counters');
}


// ########################## Rebuild Parent Lists ############################
if ($_REQUEST['do'] == 'rebuildparents')
{
	reconstruct_children();
	rebuild_parents();
	echo 'Category Parents and Children rebuilt.';
}

// ######################### Update Category Cache ###########################
if ($_REQUEST['do'] == 'updatecatcache')
{
	update_category_cache();
	echo 'Category cache updated.';
    define('CP_REDIRECT', 'vba_gallery_admin.php?do=maintenance');
}

// ######################### Update Category Cache ###########################
if ($_REQUEST['do'] == 'updatesettingscache')
{
build_adv_settings();
build_language();
echo 'Settings cache updated.';
define('CP_REDIRECT', 'vba_gallery_admin.php?do=maintenance');
}

// ######################### Update User Groups ###########################
if ($_REQUEST['do'] == 'defaultpermissions')
{
	require_once(DIR . '/includes/functions_misc.php');
            $galleryperms = array();
			$ugroups = $db->query_read("SELECT usergroupid FROM " . TABLE_PREFIX . "usergroup");
			while ($ugroup = $vbulletin->db->fetch_array($ugroups))
			{
				$galleryperms["$ugroup[usergroupid]"]['gallery_perms'] = iif($ugroup['usergroupid'] == 6, 16777203, 15424639);
				$galleryperms["$ugroup[usergroupid]"]['gallery_maxdiskspace'] = 0;
				$galleryperms["$ugroup[usergroupid]"]['gallery_maxcats'] = 0;
			}

			build_datastore('gallery_ugroups',serialize($galleryperms),1);
}
// ######################### Fix Image Titles ###########################
if ($_REQUEST['do'] == 'fiximagetitles')
{
$massimageinfo = $db->query_read("SELECT imageid, title FROM " . TABLE_PREFIX . "ppgal_images");

  while ($image = $db->fetch_array($massimageinfo))
  {
  $image['title'] = str_replace("_", " ", $image['title']);
  $image['title'] = str_replace("-", " ", $image['title']);
  $image['title'] = ereg_replace( ' +', ' ', $image['title'] );
  $image['title'] = ucwords(strtolower($image['title']));

  $db->query_write("
      UPDATE " . TABLE_PREFIX . "ppgal_images
      SET title='" . $db->escape_string($image[title]) . "'
      WHERE imageid='" . $db->escape_string($image[imageid]) . "'
      ");

  echo "$title <br/>";
  }
  echo "Thanks";
}

print_cp_footer();

?>