<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: upload.php                                                       ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/
$ppg_options['gallery_filecheck'] = 1;
// ####################### SET PHP ENVIRONMENT ###########################

// server limits array
$slimit = array(
	'maxtime'	=> 180,
	'maxmem'	=> "128M",
	'maxpost'	=> "30M",
	'maxfile'	=> "30M",
	'active'	=> true
);

ini_set("memory_limit", $slimit['maxmem']);
ini_set("post_max_size", $slimit['maxpost']);
ini_set("upload_max_filesize", $slimit['maxfile']);
ini_set("max_execution_time", $slimit['maxtime']);

$slimit['active'] = (ini_get('max_execution_time') < $slimit['maxtime']) ? false : ((ini_get('memory_limit') == $slimit['maxmem']) ? true: false);

if($slimit['active'])
{
	$slimit['maxmem'] = ini_get("memory_limit");
	$slimit['maxpost'] = ini_get("post_max_size");
	$slimit['maxfile'] = ini_get("upload_max_filesize");
	$slimit['maxtime'] = ini_get("max_execution_time");
}

error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'gallery_upload');
define('CSRF_PROTECTION', true);
if(!empty($_REQUEST['do']) AND ($_REQUEST['do'] == 'viewextensions' OR $_REQUEST['do'] == 'viewcatextensions'))
{
	define('LOCATION_BYPASS', 1);
	define('NOPMPOPUP', 1);
}

if ($_REQUEST['do'] == 'viewextensions' OR $_REQUEST['do'] == 'viewcatextensions')
{
	define('VBGLITE', true);
}
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'adv_gallery_upload'
);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'ADV_GALLERY_UPLOAD',
	'ADV_GALLERY_UPLOAD_FLASH',
	'ADV_GALLERY_UPLOAD_APPROVE',
	'ADV_GALLERY_UPLOAD_EXTENSIONS',
	'adv_gallery_upload_approvebits',
	'adv_gallery_upload_extensionbits',
	'adv_gallery_nodisplay',
	'adv_gallery_upload_custombits',
	'STANDARD_ERROR_LITE'
);

// pre-cache templates used by specific actions
$actiontemplates = array();



// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');
require_once(DIR . '/includes/functions_gallery_imageedit.php');
require_once(DIR . '/includes/functions_newpost.php');

	  

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'upload';
}

// ###### Start Uploading
if ($_REQUEST['do'] == 'doupload')
{
	// clean this one !!!!
	$images = $_POST['images'];

	
    /*    we add this here.. so we can use it and replace the old below:
        $userfile = $vbulletin->input->clean_gpc('r', 'userfile', TYPE_ARRAY_STR); */

    $userfile = $vbulletin->input->clean_gpc('f', 'userfile', TYPE_ARRAY_FILE);

/**********************************************
FILE CHECK
**********************************************/
	if($ppg_options['gallery_filecheck'] == 1)
	{
		$tmpfile = array();
		$errCheck = false;
		$fcount = 0;
		$sFile = false;
		
		if(is_array($userfile) AND !empty($userfile))
		{    
			$fcount = 1;
			$sFile = true;
			// single upload type replace image etc...
			$tmpfile[0] = $userfile['tmp_name'];
			if($userfile['error'] != 0)
			{
				  $errCheck = true;
			}
			
		}
		else
		{
			
			// mult upload form
			if(is_array($_FILES) AND !empty($_FILES))
			{
				$fcount = count($_FILES);

				$xcount = 0;
				for($i=0;$i<$fcount; $i++)
				{
					if(!empty($_FILES['userfile'.$i]['tmp_name']))
					{
						$tmpfile[$xcount] = $_FILES['userfile'.$i]['tmp_name'];
						$xcount++;
					}
					//check for error and empty slot
					if($_FILES['userfile'.$i]['error'] != 0  AND (!empty($_FILES['userfile'.$i]['name']) AND !empty($_FILES['userfile'.$i]['tmp_name']) AND !empty($_FILES['userfile'.$i]['type']) AND $_FILES['userfile'.$i]['error'] != 4))
					{
						$errCheck = true;
					}
				}
			}
		}


		/*    verbose error messages... todo => put in phrases
			Some servers give numeric code some a definition.. we consider both... */
		if($errCheck)
		{
			function file_upload_error_message($error_code) {
					
				$errmessage="no message";
				
				switch ($error_code)
				{
					case 0: // UPLOAD_ERR_OK - no error
						$errmessage = 'No upload error';
						break;

					case 1: // UPLOAD_ERR_INI_SIZE
						$errmessage = 'The uploaded file exceeds the upload_max_filesize directive in php.ini';
						break;

					case 2: // UPLOAD_ERR_FORM_SIZE
						$errmessage = 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form';
						break;

					case 3: // UPLOAD_ERR_PARTIAL
						$errmessage = 'The uploaded file was only partially uploaded';
						break;

					case 4: // UPLOAD_ERR_NO_FILE
						$errmessage = 'No file was uploaded';
						break;

					// Note: there is no error with a value of 5

					case 6: // UPLOAD_ERR_NO_TMP_DIR
						$errmessage = 'Missing a temporary folder';
						break;

					case 7: // UPLOAD_ERR_CANT_WRITE
						$errmessage = 'Failed to write file to disk';
						break;

					case UPLOAD_ERR_EXTENSION:            
						$errmessage = 'File upload stopped by extension';
						break;

					default:
						$errmessage = 'Ooops - Unknown upload error';
				}
				return $errmessage;
			}
			
			//name
			$error_string = '<u><b>Following Error(s) occurred during Fileupload</b></u>:<br /><br />';
			if($sFile)
			{
				$showError = true;
						
				//construct server error string
				$error_string .= '<b>Error</b> uploading File: "' . $userfile['name'] . '".<br />Server Message: "<b>' . file_upload_error_message($userfile['error']) . '</b>"<br /><br />';

			}
			else
			{
				
				$showError = false;
				for($i=0;$i<$fcount; $i++)
				{            
					//check for error and empty slot again...
					if($_FILES['userfile'.$i]['error'] != 0  AND (!empty($_FILES['userfile'.$i]['name']) AND !empty($_FILES['userfile'.$i]['tmp_name']) AND !empty($_FILES['userfile'.$i]['type']) AND $_FILES['userfile'.$i]['error'] != 4))
					{
						$showError = true;
						
						//construct server error string
						$error_string .= '<b>Error</b> uploading File' . $i. ': "' . $_FILES['userfile'.$i]['name'] . '".<br />Server Message: "<b>' . file_upload_error_message($_FILES['userfile'.$i]['error']) . '</b>"<br /><br />';
					}
				}
				
			}
			if($showError)
			{
			   eval(standard_error($error_string));
			}

		}
			
		/*    We tried to set mem to 128M at start... if it worked, its ok.. but if not (server-settings etc... we throw error message)
			We do not check "$maxextime" (max executiontime) for the moment.. it will have to be a manual tweak ! */
			
		if(!$maxset)
		{
			$neededmem = 0; // 0 so we can globalize it..
			$tmpcount = count($tmpfile);
			$memerrormsg = '';
			$imgcount = 0;
			$printTotalMem = false;
			$totalMemerrorMsg = '';
			$showerror = false;
			
		

			for($i=0;$i<$tmpcount;$i++)
			{

		
				if($tmpcount == 1)
				{
					$filetobig = getMemoryForImage($tmpfile[$i]);
					 // we have a single fileupload
					
					if($filetobig[0])
					{
						if($filetobig[3] == 0)
						{
							$filetobig[3] = 1;
						}
						$pct = ($filetobig[5] / $filetobig[3])*100;
				

						$pct = number_format(($pct), 0)-1;
					
						$memerrormsg .= '<b>Upload Error:</b>';
						$memerrormsg .= '<br />Your file is to big: '.$filetobig[3].'x'.$filetobig[4] . ' pixel!';
						$memerrormsg .= '<br />Use your favorite graphicprogram to resize it to something <u>smaller</u> than:' . $filetobig[5].'x'.$filetobig[6];
						$memerrormsg .= '<br />or to ' . $pct . '%.' ;
						eval(standard_error($memerrormsg));
						exit; // not really needed
					}
				}
				else
				{
					$filetobig = getMemoryForImage($tmpfile[$i], $i);
					$imgcount = $i + 1;
					$neededmem = $neededmem + $filetobig[1] ;

					if($filetobig[0])
					{
						if($filetobig[3] == 0)
						{
							$filetobig[3] = 1;
						}
						$pct = ($filetobig[5] / $filetobig[3])*100;
						
						$pct = number_format(($pct), 0)-1;
						$showerror = true;

						$memerrormsg .= '<b>Upload Error file ' . $imgcount . ':</b>';
						$memerrormsg .= '<br />Your file is to big: '.$filetobig[3].'x'.$filetobig[4];
						$memerrormsg .= '<br />Use your favorite graphicprogram to resize it to something <u>smaller</u> than:' . $filetobig[5].'x'.$filetobig[6];
						$memerrormsg .= '<br />or to ' . $pct . '%' ;
						$memerrormsg .= '<br />----------------<br />' ;

					}

					if(($neededmem > $filetobig[2]) AND !$printTotalMem AND $i!=0)
					{
						$printTotalMem = true;
						$showerror = true;
						$totalMemerrorMsg .= '<b>The sum of your images is too big for upload!</b>';
						$totalMemerrorMsg .= '<br />Try uploading the files one by one';                    

					}
					// we could add other criteria here.. but those seem ok for a first test
				}
			} // end for loop
			if($showerror)
			{
			  eval(standard_error($memerrormsg . ' ' . $totalMemerrorMsg));
			}
		}
	}

/**********************************************
 END FILE CHECK
**********************************************/

	$imageinfo = $vbulletin->input->clean_gpc('r', 'imageinfo', TYPE_ARRAY_STR);
	$imageoptions = $vbulletin->input->clean_gpc('r', 'imageoptions', TYPE_ARRAY_STR);
	$server = $vbulletin->input->clean_gpc('r', 'server', TYPE_ARRAY_STR);
	$processfiles = $vbulletin->input->clean_gpc('r', 'processfiles', TYPE_ARRAY_STR);
	$doprocess = $vbulletin->input->clean_gpc('r', 'doprocess', TYPE_ARRAY_STR);
	$processedcatids = $vbulletin->input->clean_gpc('r', 'processedcatids', TYPE_ARRAY_STR);
	$page = $vbulletin->input->clean_gpc('r', 'page', TYPE_INT);
	$catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_INT);

	$massimageinfo['title'] = str_replace('&amp;', '&', $imageinfo['title']);
	$massimageinfo['catid'] = intval($imageinfo['catid']);
	$massimageinfo['description'] = str_replace('&amp;', '&', $imageinfo['description']);
	$massimageinfo['keywords'] = str_replace('&amp;', '&', $imageinfo['keywords']);
	$massimageinfo['asuser'] = str_replace('&amp;', '&', $imageinfo['asuser']);


	if (!$massimageinfo['catid'])
	{
	
		print_no_permission();
		eval(standard_error(fetch_error('adv_gallery_must_choose_category')));
	}
	$imageoptions['policy'] = intval($imageoptions['policy']);
	if($imageoptions['policy'] != $vbulletin->userinfo['upload_readpolicy'] AND $ppg_options['gallery_policy'])
	{
		// update policyread
		$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_user SET upload_readpolicy = $imageoptions[policy] WHERE userid = '" . $vbulletin->userinfo['userid'] . "' ");

	}

	if (vbstrlen($massimageinfo['description']) > $ppg_options['gallery_desclimit'])
	{
		eval(standard_error(fetch_error('adv_gallery_description_toolong', vb_number_format(vbstrlen($massimageinfo['description'])), $ppg_options['gallery_desclimit'])));
	}

	if ($imageinfo['asuser'] AND $imageinfo['asuser'] != $vbulletin->userinfo['username'] AND ($galleryperms['canuploadasuser']))
	{
		$user = $db->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string(htmlspecialchars_uni($imageinfo['asuser'])) . "'");
		if (!$user['userid'])
		{
			eval(standard_error(fetch_error('adv_gallery_upload_invaliduser')));
		}
		$userid = $user['userid'];
		$username = $user['username'];
	}
	else
	{
		$userid = $vbulletin->userinfo['userid'];
		$username = $vbulletin->userinfo['username'];
	}
	$massimageinfo['userid'] = $userid;

	$catopts = construct_cat_opts($massimageinfo['catid'], $categorycache["$massimageinfo[catid]"]['options']);

	if ($catopts['allow_desc_links'])
	{
		$massimageinfo['description'] = convert_url_to_bbcode($massimageinfo['description']);
		$imageinfo['description'] = convert_url_to_bbcode($imageinfo['description']);
	}

	$folderstring = construct_folder_path($massimageinfo);

	$categoryperms = fetch_category_perms();

	$userinfo = $db->query_first("SELECT SUM(filesize) AS normal, SUM(originalfilesize) AS original FROM " . TABLE_PREFIX . "ppgal_images WHERE userid = '$userid'");

	$userinfo['usedspace'] = $userinfo['normal'] + $userinfo['original'];

	$imageoptions['subscribe'] = intval($imageoptions['subscribe']);
	$imageoptions['favorite'] = intval($imageoptions['favorite']);

	if ($imageoptions['subscribe'])
	{
		$checked['subscribe'] = 'checked="checked"';
	}

	if ($imageoptions['favorite'])
	{
		$checked['favorite'] = 'checked="checked"';
	}

	$catoptions["$massimageinfo[catid]"] = fetch_adv_category_setting($massimageinfo['catid']);

	if (empty($processedcatids))
	{
		$processedcatids = array();
	}

	$filetypes = fetch_cat_ext_info();

	$nextpage = $page + 1;

	// Grab custom fields to display
	$custominfo = array();
	$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields ORDER BY displayorder");
	while ($field = $vbulletin->db->fetch_array($customfields))
	{
		$custominfo[] = $field;
	}
	$db->free_result($customfields);
	unset($field);

	// ######  Mass uploading from server
	if (!$page)
	{
		if ($server['upload'])
		{
			$processfiles = array();
			$errors = array();

			if (!($galleryperms['canuploadfromserver']))
			{
				print_no_permission();
			}

			$dir = $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'];

			if ($dh = @opendir($dir))
			{
				while (($file = readdir($dh)) !== false)
				{
					if ($file != '.' AND $file != '..')
					{
						$imagecount++;
						$imageinfo = fetch_image_info($dir . '/' . $file, $file, $ppg_options['gallery_insafemode']);
						$imageinfo['catid'] = $massimageinfo['catid'];
						$errors["$imageinfo[saveas]"] = check_upload_errors();
						@chmod($dir . '/' . $file, 0777);
						if (empty($errors["$imageinfo[saveas]"]))
						{
							$processfiles[] = $imageinfo['truename'];
						}
					}
				}
				closedir($dh);
			}
		}
		else
		{
			// ###################### Uploading Single File(s) ######################
			$server['process_number'] = $ppg_options['gallery_uploadinputs'];
			foreach ($_FILES AS $file)
			{
				
				
				if ($file['tmp_name'])
				{
					$gotfiles = true;
					$imageinfo = fetch_image_info($file['tmp_name'], $file['name'], $ppg_options['gallery_insafemode']);
					$imageinfo['catid'] = $massimageinfo['catid'];

					$errors["$imageinfo[saveas]"] = check_upload_errors();

					if (!empty($errors["$imageinfo[saveas]"]))
					{
						$show['errors'] = true;
					}
					else
					{
						$imagecount++;
						@move_uploaded_file($file['tmp_name'], $imageinfo['saveto'] . '/' . $imageinfo['saveas']);
						$processfiles[] = $imageinfo['saveas'];
					}
				}
			}

			if (!$gotfiles)
			{
				eval('$errors[\'\'][\'\'] = "' . fetch_error('upload_invalid_file') . '";');
			}
		}
	}
	

	// Print out any initial errors
	if (!empty($errors))
	{
		$cr = "\n";

		$ecount = 0;
		
		foreach ($errors AS $filename => $error)
		{
			if (!empty($error))
			{
				$show['errors'] = true;
				if(!$filename OR trim($filename) == '')
				{
					$filename = $vbphrase['n_a'];
				}
				if($ecount > 0)
				{
					$uploaderrors .= '<li class="errorfile bline"><span>' . $vbphrase['file'] . ': <span class="error">' . $filename . '</span></span>' . $cr;
				}
				else
				{
					$uploaderrors .= '<li class="errorfile"><span>' . $vbphrase['file'] . ': <span class="error">' . $filename . '</span></span>' . $cr;
				}

				$uploaderrors .=  '<ul>' . $cr; 
				foreach ($error AS $varname => $text)
				{
					$uploaderrors .= '<li>' . $text . '</li>'. $cr;
				}
				$uploaderrors .= '</ul></li>' . $cr; 
				$ecount++;
			}
		}
		if($ecount>0)
		{
			$uploaderrors = '<ul>' . $cr . $uploaderrors; 
			$uploaderrors .= '</ul>' . $cr;
			$vbphrase['process_files_desc'] = $vbphrase['process_files_err_desc'];
		}
		else
		{
			$vbphrase['process_files_desc'] = $vbphrase['complete_details_for_uploads'];
		}
	}


	// Only got 1 file?
	if (!$page AND sizeof($processfiles) == 1 AND !$show['errors'])
	{
		$singlefile = true;
		$fname = implode('', $processfiles);
		$images["$fname"] = &$imageinfo;
		$doprocess = &$processfiles;

		$imageinfo = fetch_image_info(iif($server['upload'], $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'], $folderstring) . '/' . $filename, $filename);
		resize_image($catoptions["$imageinfo[catid]"]['gallery_thumbsize'], $catoptions["$imageinfo[catid]"]['gallery_thumbsize']);

		$customfields = array();
		foreach ($custominfo AS $customfield)
		{
			$fieldvalue = $_POST["field$customfield[fieldid]"];
			unset($_POST["field$customfield[fieldid]"]);
			$_POST["field$customfield[fieldid]"]["$fname"] = $fieldvalue;
		}

		unset($processfiles);
	}

	// Process current approved images
	if (!empty($images))
	{
		if (!is_array($doprocess))
		{
			$doprocess = array();
		}
		foreach ($images AS $filename => $imageinfo)
		{
			$filename = stripslashes($filename);
			$imageinfo = fetch_image_info(iif($server['upload'], $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'], $folderstring) . '/' . $filename, $filename);

			$imageinfo['asuser'] = $massimageinfo['asuser'];
			if (in_array($filename, $doprocess))
			{
				$customfields = array();

				foreach ($custominfo AS $customfield)
				{
					$customfields["field$customfield[fieldid]"] = $_POST["field$customfield[fieldid]"]["$filename"];
				}

				$errors["$imageinfo[saveas]"] = check_upload_errors();

				if (!empty($errors["$imageinfo[saveas]"]))
				{
					@unlink($imageinfo['location']);
					@unlink($folderstring . '/' . $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension']);
				}
				else
				{
					if ($server['upload'])
					{
						@copy($imageinfo['location'], $imageinfo['saveto'] . '/' . $imageinfo['saveas']);
						@unlink($imageinfo['location']);
						$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
					}

					if (empty($catoptions["$imageinfo[catid]"]))
					{
						$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
					}

					$newimageid = process_upload(true);
					$imagecount++;

                    $catemails = $db->query_read("
                        SELECT catid, title, newimageemail
                        FROM " . TABLE_PREFIX . "ppgal_categories
                        WHERE catid = '$imageinfo[catid]'
                        ");
                    while ($catemail = $vbulletin->db->fetch_array($catemails))
                    {
                        $catemailid = $catemail['catid'];
                        $catemailtitle = $catemail['title'];
                        $catemailaddy = $catemail['newimageemail'];
                    }

                    if (!in_array($imageinfo['catid'], $processedcatids))
					{
						if ($categoryperms["$imageinfo[catid]"]['moderateimages'] OR $ppg_options['gallery_newimageemail_all'])
						{
							$sendmailto = array();
							$optmailer = array();

							if (!empty($catemailaddy))
							{
								$sendmailto = explode(' ', $catemailaddy);
							}

							if ($ppg_options['gallery_newimageemail'])
							{
								$optmailer = explode(' ', $ppg_options['gallery_newimageemail']);
							}

							$sendmailto = array_merge((array)$optmailer, (array)$sendmailto);

							if (!empty($sendmailto))
							{
								$cattitle = stripslashes($categorycache["$imageinfo[catid]"]['title']);
								foreach ($sendmailto AS $email)
								{
									eval(fetch_email_phrases('adv_gallery_newupload'));
									vbmail(trim($email), $subject, $message);
								}
							}
						}
						$processedcatids[] = $imageinfo['catid'];
					}
				}
			}
			else
			{
				@unlink($imageinfo['location']);
				@unlink($folderstring . '/' . $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension']);
			}
		}
		unset($images, $imageinfo);
	}

	// Process new files
	if (!empty($processfiles))
	{
		$processcount = 0;
		$categoryselect = print_cat_select($massimageinfo['catid'], 'upload');
		$show['tablerows'] = true;

		if (!empty($custominfo))
		{
			foreach ($custominfo AS $customfield)
			{
			if (($page AND is_array($_POST['defaultfields']["field$customfield[fieldid]"])) OR !$page AND is_array($_POST["field$customfield[fieldid]"]))
                {
                    foreach (iif($page, $_POST['defaultfields']["field$customfield[fieldid]"], $_POST["field$customfield[fieldid]"]) AS $field => $value)
                    {
                        $hiddencustomvalues .= '<input type="hidden" name="defaultfields[field' . $customfield['fieldid'] . '][' . $field . ']" value="' . addslashes(htmlspecialchars($value)) . '" />';

                    }
                }
                else
                {
                    $hiddencustomvalues .= '<input type="hidden" name="defaultfields[field' . $customfield['fieldid'] . ']" value="' . addslashes(htmlspecialchars(iif(!$page, $_POST["field$customfield[fieldid]"], $_POST['defaultfields']["field$customfield[fieldid]"]))) . '" />';
                }
			}
			unset($customfield);
		}
		$tmpvar = array();
		$tmpvar['gallery_allowfav'] = $ppg_options['gallery_allowfav'];
		$tmpvar['gallery_allowsubscribe'] = $ppg_options['gallery_allowsubscribe'];
		$show['interpage'] = true;
		$imgbit_tmp = array(); 
		if($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1)
		{
			$imgbit_tmp['albumclass'] = '_alt';
		}
		foreach ($processfiles AS $file)
		{
			if ($processcount < $server['process_number'])
			{
				$processcount++;

				$imageinfo['catid'] = $massimageinfo['catid'];

				$imageinfo = fetch_image_info(iif($server['upload'], $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'], $folderstring) . '/' . $file, $file);

				// Do another error check if we have a page specified just to be safe
				if ($page)
				{
					$errors["$imageinfo[saveas]"] = check_upload_errors();

					if (!empty($errors["$imageinfo[saveas]"]))
					{
						@unlink($imageinfo['location']);
						@unlink($folderstring . '/' . $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension']);
					}
				}

				if (!$massimageinfo['title'])
				{
					$massimageinfo['title'] = htmlspecialchars($imageinfo['shortname']);
					$unsettitle = true;
				}

                $massimageinfo['title'] = str_replace("_", " ", $massimageinfo['title']);
				// this is bad for foreign characters
			  //  $massimageinfo['title'] = ucwords(strtolower($massimageinfo['title']));

				$_POST['defaultfields']['imageid'] = $file;
				$_POST['imageid'] = $file;
				
				$custombits = construct_custom_fieldbits(iif($page, $_POST['defaultfields'], $_POST), $custominfo, false, false, true);

				$imageinfo['userid'] = $userid;

				if (empty($catoptions["$imageinfo[catid]"]))
				{
					$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
				}

				$imageinfo = resize_image($catoptions["$imageinfo[catid]"]['gallery_thumbsize'], $catoptions["$imageinfo[catid]"]['gallery_thumbsize']);

				$image['imageurl'] = construct_image_url($imageinfo, 'thumbname');

				$image['fullimageurl'] = iif($server['upload'], $ppg_options['gallery_userfolderurl'] . '/' . $vbulletin->userinfo['userid'], fetch_folder_url($imageinfo)) . '/' . $file;

				//eval('$imagebits .= "' . fetch_template('adv_gallery_upload_approvebits') . '";');

					$templater = vB_Template::create('adv_gallery_upload_approvebits');
					$templater->register('tmpvar', $tmpvar);
					$templater->register('ppg_vars', $imgbit_tmp);
					$templater->register('image', $image);
					$templater->register('file', $file);
					$templater->register('categoryselect', $categoryselect);
					$templater->register('checked', $checked);
					$templater->register('massimageinfo', $massimageinfo);
					$templater->register('custombits', $custombits);

					$imagebits .= $templater->render();

				unset($imageinfo);
				if ($unsettitle)
				{
					$massimageinfo['title'] = '';
				}
			}
			else
			{
				$hiddenbits .= '<input type="hidden" name="processfiles[]" value="' . htmlspecialchars_uni($file) . '" />';
			}
		}
		unset($tmpvar);
		$show['interpage'] = false;
	}
	else
	{
		
		$colspan = 3;
		$vbulletin->url = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $massimageinfo['catid'];
		//eval(print_standard_redirect());
//		eval('$imagebits = "' . fetch_template('adv_gallery_nodisplay') . '";');
			$templater = vB_Template::create('adv_gallery_nodisplay');
			$templater->register('colspan', $colspan);
			$imagebits = $templater->render();
	}

	if (!$server['upload'] AND empty($processfiles) AND !$show['errors'])
	{
		if ($categoryperms["$massimageinfo[catid]"]['moderateimages'])
		{
			eval(standard_error(fetch_error('adv_gallery_imageupload_approve', $vbulletin->session->vars['sessionurl'], $ppg_options['gallery_title'])));
		}
		else
		{
			if ($singlefile)
			{
				$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $newimageid . '&amp;c=' . $massimageinfo['catid'];
			}
			else
			{
				$vbulletin->url = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $massimageinfo['catid'];
			}
			eval(print_standard_redirect('adv_gallery_imageuploaded_noapprove'));
		}
	}
	else
	{
		if ($singlefile)
		{
			$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $newimageid . '&amp;c=' . $imageinfo['catid'];
			eval(print_standard_redirect('adv_gallery_imageuploaded_noapprove'));
		}
		else
		{
				  // draw nav bar
			$navbits = array();
			$navbits[$ppg_options['gallery_url'] . '/index.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['gallery'];


			$navbits[''] = $vbphrase['process_files'];
			$navbits = construct_navbits($navbits);

			$navbar = render_navbar_template($navbits);

			$ppg_vars['gallery_titletag'] = $vbphrase['process_files'];
			
			
			if (!empty($processedcatids))
			{
				foreach ($processedcatids AS $pcatid)
				{
					$hiddenbits .= '<input type="hidden" name="processedcatids[]" value="' . intval($pcatid) . '" />' . "\n";
				}
			}

		$headinclude = construct_metatags($headinclude);
		$headinclude = NOROBOTS . "\n" . $headinclude;

	 	$templater = vB_Template::create('ADV_GALLERY_UPLOAD_APPROVE');
		$templater->register_page_templates();
		$ppg_options['gallery_thumbandframesize'] = intval(($ppg_options['gallery_thumbsize']*2) - ($ppg_options['gallery_thumbsize']/2));
		
		$templater->register('gallery_thumbsize', $ppg_options['gallery_thumbandframesize']);
		$templater->register('ppg_vars', $ppg_vars);
		$templater->register('hiddencustomvalues', $hiddencustomvalues);
		$templater->register('hiddenbits', $hiddenbits);
			
		$templater->register('uploaderrors', $uploaderrors);
		$templater->register('imagebits', $imagebits);
		$templater->register('navbar', $navbar);
		$templater->register('imageoptions', $imageoptions);
		$templater->register('massimageinfo', $massimageinfo);
		$templater->register('catid', $catid);
		$templater->register('server', $server);
		$templater->register('nextpage', $nextpage);
		$templater->register('categorybits', $categorybits);
		$templater->register('gallery_title', $ppg_options['gallery_title']);

	  	print_output($templater->render());


			
		}
	}
}

// ############################## Main Upload Page ############################
if ($_REQUEST['do'] == 'upload')
{
	$catoptions = print_cat_select($catid, 'upload');

	if (!$catoptions)
	{
		print_no_permission();
	}

	$usedspace = $db->query_first("SELECT SUM(filesize) AS normal, SUM(originalfilesize) AS original FROM " . TABLE_PREFIX ."ppgal_images WHERE userid = '" . $vbulletin->userinfo['userid'] . "'");

	$usedspace['total'] = $usedspace['normal'] + $usedspace['original'];

	if ($galleryperms['gallery_maxdiskspace'] == 0)
	{
		$spacelimit = $vbphrase['unlimited'];
		$spaceremaining = $vbphrase['unlimited'];
		$bar['spaceremaining'] = 100;
		$bar['spaceused'] = 1;
	}
	else
	{
		$spacelimit = vb_number_format($galleryperms['gallery_maxdiskspace'], 1, true);
		$spaceremaining = vb_number_format($galleryperms['gallery_maxdiskspace'] - $usedspace['total'], 1, true);

		$bar['spaceused'] = round(($usedspace['total'] / $galleryperms['gallery_maxdiskspace']) * 100);
		$bar['spaceremaining'] = 100 - $bar['spaceused'];
	}

	if ($bar['spaceused'] >= 75)
	{
		$bar['color'] = 'red';
	}
	else if ($bar['spaceused'] >= 50)
	{
		$bar['color'] = 'yellow';
	}
	else
	{
		$bar['color'] = 'green';
	}

	$spaceused = vb_number_format($usedspace['total'], 1, true);

	if (($galleryperms['canuploadasuser']))
	{
		$show['userupload'] = true;
		$imageinfo['asuser'] = $vbulletin->userinfo['username'];
	}

	$userdirectory = $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'];

	if (($galleryperms['canuploadfromserver']))
	{
		$show['serverupload'] = true;
	}

	$ppg_vars['use_policy'] = $ppg_options['gallery_policy'];

	$customfieldbits = construct_custom_fieldbits($_POST);

	for ($i = 0; $i < $ppg_options['gallery_uploadinputs']; $i++)
	{
		$uploadbits .= '<div><input class="primary textbox" type="file" size="50" name="userfile' . $i . '" /></div>';
	}



	  // draw nav bar
	$navbits = array();
	$navbits[$ppg_options['gallery_url'] . '/index.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['gallery'];

	$navbits[''] = $vbphrase['upload_image'];
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);





	//eval('$navbar = "' . fetch_template('navbar') . '";');
	$templater = vB_Template::create('navbar');
			
	//$templater->register('template_hook', $template_hook);
	$navbar = $templater->render();
	$navbar = render_navbar_template($navbits);
	//eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');
   	if($ppgal_announcement)
	{
		$navbar = $navbar . $ppgal_announcement;
	}
   
   $templater = vB_Template::create('adv_gallery_navbar');
			
	$templater->register('gallerynav', $gallerynav);
	$gallerynav = $templater->render();
	$vbphrase['upload_image_page_desc'] = '';
	if($ppg_options['gallery_resize_original'])
	{
		$vbphrase['upload_image_page_desc'] = construct_phrase($vbphrase['upload_desc'], $ppg_options['gallery_resize_original'], $ppg_options['gallery_resize_original'] );
	}



			// javascript phrases
		$vbphrase['js_you_must_select_file'] = addslashes_js($vbphrase['you_must_select_file']);
		$vbphrase['js_you_must_select_cat'] = addslashes_js($vbphrase['you_must_select_cat']);
		$vbphrase['js_sorry_before_proceed'] = addslashes_js($vbphrase['sorry_before_proceed']);
		$vbphrase['js_you_must_agree_to_policy'] = addslashes_js($vbphrase['you_must_agree_to_policy']);

		$ppg_vars['spaceused'] = $spaceused;
		$ppg_vars['spacelimit'] = $spacelimit;
		$ppg_vars['spaceremaining'] = $spaceremaining;
		$ppg_vars['gallery_title'] = $ppg_options['gallery_title'];
		$ppg_vars['gallery_url'] = $ppg_options['gallery_url'];
		$ppg_vars['gallery_allowfav'] = $ppg_options['gallery_allowfav'];
		$ppg_vars['gallery_allowsubscribe'] = $ppg_options['gallery_allowsubscribe'];

		/* ### Set simple metatags #### */
		// remove conflicts with doublequotes in metatags
		$ppg_vars['gallery_titletag'] = htmlspecialchars_uni(strip_tags($vbphrase['upload_image'] . ' - ' . $ppg_options['gallery_title'])); 
		$headinclude = construct_metatags($headinclude);
		$headinclude = NOROBOTS . "\n" . $headinclude;




/*******************************************
calculate memory usage
********************************************/
// print_r($gallery_modcache); exit;
$show['admin_upl_info'] = false;
if (($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator'])  )
{
	$show['admin_upl_info'] = true;

	$ppg_vars['maxtime'] = $slimit['maxtime'] . ' ' . $vbphrase['seconds'];

	$ppg_vars['maxpost'] =  vb_number_format($slimit['maxpost'], 1, true);
	$ppg_vars['maxfile'] =  vb_number_format($slimit['maxfile'], 1, true);
	$ppg_vars['maxmem'] =  vb_number_format($slimit['maxmem'], 1, true);
	$ppg_vars['change'] =  ($slimit['active'])? $vbphrase['changed'] : $vbphrase['not_changed'];
}

unset($slimit);


//print "<pre>test:<br />"; print_r($slimit);exit;
$show['flashpage'] = false;


$show['sidebar'] = false;
$ppg_options['layout_showimagebar'] = 1;
$ppg_options['upload_sidebarposition'] = 1;
$ppg_vars['upload_sidebarposition'] = $ppg_options['upload_sidebarposition'];
$ppg_vars['this_catid'] = intval($catid);
$show['sidebar']  = true;

$checked['policy'] = ($vbulletin->userinfo['upload_readpolicy'] == 1) ? ' checked="checked" ': '';



    if ( $ppg_options['gallery_uploadflash'] )
    {
		$show['formcheck'] = true;
		$show['formcheck_full'] = false;
        // For flash uploader, we need to use sessions
        session_start();
        $_SESSION["file_info"] = array();
        $flash['filetypes'] = '*.jpg;*.jpeg;*.png;*.bmp;*.gif;*.mpg;*.avi;*.mp3;*.wav';
        $flash['maxfilesize'] = 9999999;
        $flash['session'] = session_id();
        $flash['userid'] = $_SESSION['userid'] = $vbulletin->userinfo['userid'];
        @mkdir( $userdirectory );
	    @chmod( $userdirectory, 0777 );
		
		$templater = vB_Template::create('ADV_GALLERY_UPLOAD_FLASH');

		$templater->register('flash', $flash);
	    //eval('print_output("' . fetch_template('ADV_GALLERY_UPLOAD_FLASH') . '");');
	}
	else
	{

		$show['formcheck'] = true;
		$show['formcheck_full'] = true;
		$templater = vB_Template::create('ADV_GALLERY_UPLOAD');
	}

		$templater->register_page_templates();
		$templater->register('uploadbits', $uploadbits);
		$templater->register('bar', $bar);
		
		$templater->register('navbar', $navbar);
		$templater->register('imageinfo', $imageinfo);
		$templater->register('ppg_vars', $ppg_vars);
		$templater->register('catoptions', $catoptions);
		$templater->register('checked', $checked);
		$templater->register('customfieldbits', $customfieldbits );
		$templater->register('userinfo', $userinfo);
		$templater->register('userdirectory', $userdirectory);

		print_output($templater->render());
	

}


// ########################## View Allowed Extensions #########################
// used not only in upload... also in editimages when replacing file!!!
if ($_REQUEST['do'] == 'viewextensions' OR $_REQUEST['do'] == 'viewcatextensions')
{


	require_once(DIR . '/includes/functions_gallery_imageedit.php');
	$categoryperms = fetch_category_perms();

	$filetypes = fetch_cat_ext_info();

	$bgclass = exec_switch_bg();
	if($_REQUEST['do'] == 'viewcatextensions')
	{
		$catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_INT);
		
		$cats = $categorycache[$catid];

			if ($cats['catuserid'] AND $cats['catuserid'] != $vbulletin->userinfo['userid'])
			{
				$useroptions = construct_cat_user_opts($cats['catid'], $categorycache["$cats[catid]"]['useroptions']);
				if (!$useroptions['allow_upload'] OR !$useroptions['allow_view'])
				{
					continue;
				}
			}
			$catopts = construct_cat_opts($cats['catid'], $cats['options']);

			if ($cats['parent'] != 0 AND !$categorycache["$cats[parent]"]['active'] AND (!$cats['catuserid'] OR $cats['catuserid'] != $vbulletin->userinfo['userid']))
			{
				$cats['active'] = 0;
				$categorycache["$cats[catid]"]['active'] = 0;
			}

			if ((!is_category_mod($cats['catid']) AND !$cats['active']) OR !$catopts['open_for_images'] OR !$categoryperms["$cats[catid]"]['canuploadimages'])
			{
				continue;
			}

			if ($cats['level'] > 1)
			{
			$dashes = str_repeat('--', $cats['level'] - 1);
			}

			$cats['extensions'] = '';
			$extcount = 0;
					$bg = exec_switch_bg();
					$bg = 'table'.$bg;
			foreach ($filetypes["$cats[catid]"] AS $extension => $values)
			{
				if ($extcount <1)
				{

				}
				if ($extcount == 2)
				{
					$bg = exec_switch_bg();
					$bg = 'table'.$bg;
					$cats['extensions'] .= '</tr><tr>';
					$extcount = 0;
				}

				$extcount++;
				
		

				$cats['extensions'] .= '<td width="50%" class="' . $bg . '"><table width="100%" cellpadding="0" cellspacing="0"><td  style="padding:0;" align="{vb:stylevar left}" class="sf" width="20%"><strong>' . $extension . '</strong></td><td class="smallfont" style="padding:0;margin:0;" width="35%">' . iif($values['filesize'], vb_number_format($values['filesize'], 1, true), $vbphrase['unlimited']) . '</td><td style="padding:0;margin:0;" class="sf" >' . iif($values['width'] AND $values['height'], $values['width'] . ' x ' . $values['height'], $vbphrase['n_a']) . '</td></tr></table></td>';

			}

			if ($extcount AND $extcount != 2)
			{
				for ($i = $extcount; $i < 2; $i++)
				{
					$cats['extensions'] .= '<td style="padding:0;" class="' . $bg . '">';
				}
			}
			
			
			$templater = vB_Template::create('adv_gallery_upload_extensionbits');
			$templater->register('dashes', $dashes);
			$templater->register('cats', $cats);

			$categorybits = $templater->render();

	}
	else
	{
		foreach ($categorycache AS $cats)
		{
			if ($cats['catuserid'] AND $cats['catuserid'] != $vbulletin->userinfo['userid'])
			{
				$useroptions = construct_cat_user_opts($cats['catid'], $categorycache["$cats[catid]"]['useroptions']);
				if (!$useroptions['allow_upload'] OR !$useroptions['allow_view'])
				{
					continue;
				}
			}
			$catopts = construct_cat_opts($cats['catid'], $cats['options']);

			if ($cats['parent'] != 0 AND !$categorycache["$cats[parent]"]['active'] AND (!$cats['catuserid'] OR $cats['catuserid'] != $vbulletin->userinfo['userid']))
			{
				$cats['active'] = 0;
				$categorycache["$cats[catid]"]['active'] = 0;
			}

			if ((!is_category_mod($cats['catid']) AND !$cats['active']) OR !$catopts['open_for_images'] OR !$categoryperms["$cats[catid]"]['canuploadimages'])
			{
				continue;
			}

			if ($cats['level'] > 1)
			{
			$dashes = str_repeat('--', $cats['level'] - 1);
			}

			$cats['extensions'] = '';
			$extcount = 0;
					$bg = exec_switch_bg();
					$bg = 'table'.$bg;
			foreach ($filetypes["$cats[catid]"] AS $extension => $values)
			{
				if ($extcount <1)
				{

				}
				if ($extcount == 2)
				{
					$bg = exec_switch_bg();
					$bg = 'table'.$bg;
					$cats['extensions'] .= '</tr><tr>';
					$extcount = 0;
				}

				$extcount++;
				
		

				$cats['extensions'] .= '<td width="50%" class="' . $bg . '"><table width="100%" cellpadding="0" cellspacing="0"><td  style="padding:0;" align="{vb:stylevar left}" class="sf" width="20%"><strong>' . $extension . '</strong></td><td class="smallfont" style="padding:0;margin:0;" width="35%">' . iif($values['filesize'], vb_number_format($values['filesize'], 1, true), $vbphrase['unlimited']) . '</td><td style="padding:0;margin:0;" class="sf" >' . iif($values['width'] AND $values['height'], $values['width'] . ' x ' . $values['height'], $vbphrase['n_a']) . '</td></tr></table></td>';

			}

			if ($extcount AND $extcount != 2)
			{
				for ($i = $extcount; $i < 2; $i++)
				{
					$cats['extensions'] .= '<td style="padding:0;" class="' . $bg . '">';
				}
			}
			
			
			$templater = vB_Template::create('adv_gallery_upload_extensionbits');
			$templater->register('dashes', $dashes);
			$templater->register('cats', $cats);

			$categorybits .= $templater->render();

			
		}
	}

 	$templater = vB_Template::create('ADV_GALLERY_UPLOAD_EXTENSIONS');
	$templater->register_page_templates();
	$templater->register('categorybits', $categorybits);
	$templater->register('title2', $ppg_options['gallery_title']);
  	print_output($templater->render());
}

?>