<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script:stats.php                                                         ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'gallery_stats');


// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
// needed for annoucement only (gotto change that)
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);
// pre-cache templates used by all actions
$globaltemplates = array(
    'ADV_GALLERY_STATS',
    'adv_gallery_stats_navbar',
    'adv_gallery_stats_nav1',
    'adv_gallery_stats_stat1',
    'adv_gallery_stats_stat2',
    'adv_gallery_stats_categories',
    'adv_gallery_stats_comments',
    'adv_gallery_stats_views',
    'adv_gallery_stats_upload',
    'adv_gallery_stats_close',
    'adv_gallery_stats_nodisplay',
	'adv_gallery_stats_sidebar'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################

require_once('./gallery_global.php');
//require_once(DIR . '/includes/adminfunctions.php');
//require_once(DIR . '/includes/functions_gallery.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################


if ($ppg_options['gallery_stats_active'] AND $show['stats'])
{

	$topuploads = intval($ppg_options['gallery_stats_uploads']);
	$topcomments = intval($ppg_options['gallery_stats_comments']);
	$topviewed = intval($ppg_options['gallery_stats_viewed']);
	$topcategories = intval($ppg_options['gallery_stats_categories']);

	if ($topuploads < 0)
	{
		$topuploads = 10;
	}

	if ($topcomments < 0)
	{
		$topcomments = 15;
	}

	if ($topviewed < 0)
	{
		$topviewed = 15;
	}

	if ($topcategories < 0)
	{
		$topcategories = 15;
	}
    if(!$galleryperms['canviewgallery'] OR !$galleryperms['canviewimages'])
	{
		print_no_permission();
	}

	$show['comments'] = ($ppg_options['gallery_allowreplies']) ? true : false;
	$show['ecards'] = ($ppg_options['gallery_enableecards']) ? true : false;

	if($_REQUEST['do']=='posts' AND !$show['comments'])
	{
		print_no_permission();
	}
	else if($_REQUEST['do']=='ecards' AND !$show['ecards'])
	{
		print_no_permission();
	}

// ######################### Sidebar STUFF on ALL Pages ##############################

// ######################### sidebar MOST UPLOADS ############################

	$get_stats_uploads = $db->query_read("
		SELECT user.userid, user.usergroupid, user.username, ppgal_user.ppicount
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "ppgal_user AS ppgal_user ON (ppgal_user.userid = user.userid)
		WHERE ppicount > 0
		ORDER BY ppicount DESC
		LIMIT $topuploads
	");

	if ($db->num_rows($get_stats_uploads))
	{
		while ($getstats_upload = $db->fetch_array($get_stats_uploads))
		{
			$getstats_upload['fullusername'] = strip_tags($getstats_upload['username']);
			$getstats_upload['username'] = strip_tags($getstats_upload['username']);
			$getstats_upload['musername'] = fetch_musername($getstats_upload);

			$templater = vB_Template::create('adv_gallery_stats_upload');
			$templater->register('ppg_vars', $ppg_vars);
			$templater->register('getstats_upload', $getstats_upload);
			$maxuploadxs .= $templater->render();

			// eval('$maxuploadxs .= "' . fetch_template('adv_gallery_stats_upload') . '";');
		}
		unset($getstats_upload);
	}
	else
	{
		$templater = vB_Template::create('adv_gallery_stats_nodisplay');
		$templater->register('ppg_vars', $ppg_vars);
		$maxuploadxs = $templater->render();
		//eval('$maxuploadxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
	}
	$db->free_result($get_stats_uploads);

// ######################### END /sidebar MOST UPLOADS ############################

// ######################### sidebar Most Popular Categories ############################

	$bestcatx = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "ppgal_categories
		WHERE imagecount > 0
		ORDER BY imagecount DESC
		LIMIT $topcategories
	");

	if ($db->num_rows($bestcatx))
	{
		while ($bestcat = $db->fetch_array($bestcatx))	
		{
			$templater = vB_Template::create('adv_gallery_stats_categories');
			$templater->register('ppg_vars', $ppg_vars);
			$templater->register('bestcat', $bestcat);
			$maxcatxs .= $templater->render();
             //   eval('$maxcatxs .= "' . fetch_template('adv_gallery_stats_categories') . '";');
		}
		unset($bestcat);
	}
	else
	{
		$templater = vB_Template::create('adv_gallery_stats_nodisplay');
		$templater->register('ppg_vars', $ppg_vars);
		$maxcatxs = $templater->render();
			// eval('$maxcatxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
	}

	$db->free_result($bestcatx);

// ######################### END /sidebar Most Popular Categories ############################

	if (empty($_REQUEST['do']))
    {
		
		// Most Comments on a image
		// only if comments are active
		if($ppg_options['gallery_allowreplies'])
		{
			$maxcommentx = $db->query_read("
				SELECT * FROM " . TABLE_PREFIX . "ppgal_images
				WHERE posts > 0
				ORDER BY posts DESC
				LIMIT $topcomments
			");

			if ($db->num_rows($maxcommentx))
			{
				while ($maxcomment = $db->fetch_array($maxcommentx))
				{
					$maxcomment['url'] = construct_image_url($maxcomment, 'thumbname');
					$maxcomment['title'] = str_replace('&amp;', '&', $maxcomment['title']);
					$maxcomment['description'] = str_replace('&amp;', '&', $maxcomment['description']);

					$templater = vB_Template::create('adv_gallery_stats_comments');
					$templater->register('ppg_vars', $ppg_vars);
					$templater->register('maxcomment', $maxcomment);
					$maxcommentxs .= $templater->render();
					// eval('$maxcommentxs .= "' . fetch_template('adv_gallery_stats_comments') . '";');
				}
				unset($maxcomment);
			}
			else
			{
				$templater = vB_Template::create('adv_gallery_stats_nodisplay');
				$templater->register('ppg_vars', $ppg_vars);
				$maxcommentxs = $templater->render();
				//eval('$maxcommentxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
			}
			$db->free_result($maxcommentx);

		}
		// Most Image Views
		$maxviewx = $db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "ppgal_images
			WHERE views > 0
			ORDER BY views DESC
			LIMIT $topviewed
		");

		if ($db->num_rows($maxviewx))
		{
			while ($maxview = $db->fetch_array($maxviewx))
			{
				$maxview['url'] = construct_image_url($maxview, 'thumbname');
				$maxview['title'] = htmlspecialchars_uni($maxview['title']);
				$maxview['title'] = str_replace('&amp;', '&', $maxview['title']);
				$maxview['description'] = htmlspecialchars_uni($maxview['description']);
				$maxview['description'] = str_replace('&amp;', '&', $maxview['description']);
				
				$templater = vB_Template::create('adv_gallery_stats_views');
				$templater->register('ppg_vars', $ppg_vars);
				$templater->register('maxview', $maxview);
				$maxviewxs .= $templater->render();
				// eval('$maxviewxs .= "' . fetch_template('adv_gallery_stats_views') . '";');
			}
			unset($maxview);
		}
		else
		{
			$templater = vB_Template::create('adv_gallery_stats_nodisplay');
			$templater->register('ppg_vars', $ppg_vars);
			$maxviewxs = $templater->render();
			// eval('$maxviewxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
		}
		$db->free_result($maxviewx);

		$templater = vB_Template::create('adv_gallery_stats_nav1');
		$templater->register('ppg_vars', $ppg_vars);
		
		$templater->register('maxcommentxs', $maxcommentxs);
		$templater->register('maxviewxs', $maxviewxs);
		$topresult = $templater->render();
}

$navbits = array();
$ppg_options['nav_gallery_url']	  =  $ppg_options['gallery_url'] . '/index.php' .  $vbulletin->session->vars['sessionurl_q'];
$navbits["$ppg_options[nav_gallery_url]"] = $vbphrase['gallery'];

$navbits[''] = "$vbphrase[stats_menu1]";

$tablename = "($vbphrase[adv_gallery_stats_navbar])";

// Poll Stats
if ($_REQUEST['do']=='ecards' OR $_REQUEST['do']=='uploads' OR $_REQUEST['do']=='posts')
{

    switch ($_REQUEST['do'])
    {
    	case 'ecards':
    		$type = 'necard';
    		$tablename = "$vbphrase[stats_ecard_stats]";
            $navbits[''] = "$vbphrase[stats_ecard_stats]";
            break;
    	case 'uploads':
    		$type = 'nimage';
    		$tablename = "$vbphrase[stats_upload_stats_stat]";
            $navbits[''] = "$vbphrase[stats_upload_stats_stat]";
            break;
    	case 'posts':
    		$type = 'npost';
    		$tablename = "$vbphrase[stats_most_comments]";
            $navbits[''] = "$vbphrase[stats_most_comments]";
            break;
    }

	$vbphrase['main_stats_page'] = construct_phrase($vbphrase['main_stats_page_x'], $tablename);
    $orderby = 'dateline ASC';
    $vbulletin->GPC['scope'] = 'daily';
    $sqlformat = '%w %U %m %Y';
    $phpformat = '! d, Y';

    $cutoff = intval($ppg_options['gallery_stats_days']);

    if($cutoff <= 0)
	{
		$cutoff = 30;
    }

    $start_time = TIMENOW - 3600 * 24 * $cutoff;
    $end_time = TIMENOW;

	$statistics = $db->query_read("
		SELECT SUM($type) AS total,
		DATE_FORMAT(from_unixtime(dateline), '$sqlformat') AS formatted_date,
		MAX(dateline) AS dateline
  		FROM " . TABLE_PREFIX . "ppgal_stats
		WHERE dateline >= $start_time
		AND dateline <= $end_time
		GROUP BY formatted_date
		" . (empty($vbulletin->GPC['nullvalue']) ? " HAVING total > 0 " : "") . "
		ORDER BY $orderby
	");
	$results = array();
	while ($pagestats = $db->fetch_array($statistics))
	{
		// we will now have each days total of the type picked and we can sort through it
		$month = strtolower(date('F', $pagestats['dateline']));
		$dates[] = str_replace(' ', '&nbsp;', str_replace('#', $vbphrase['week'] . '&nbsp;' . strftime('%U', $pagestats['dateline']), str_replace('!', $vbphrase["$month"], date($phpformat, $pagestats['dateline']))));
		$results[] = $pagestats['total'];
	}
	$db->free_result($statistics);
	unset($pagestats);

    if (!sizeof($results)){
		standard_error(fetch_error('no_matches_found'));
    }


// ############# get rid of poll image (save a query) ########################
	// we'll need a poll image
	/*
	$stylex = $db->query_first("
		SELECT stylevars FROM " . TABLE_PREFIX . "style
		WHERE styleid = " . $vbulletin->options['styleid'] . "
		LIMIT 1
	");
	$stylevars = unserialize($stylex['newstylevars']);
	unset($stylex);
	*/
	

   // eval('$topresult .= "' . fetch_template('adv_gallery_stats_stat1') . '";');

	$maxvalue = max($results);
	$i=0;
	foreach ($results as $key => $value)
	{
		$i++;
		$bar = ($i % 6) + 1;

		if ($maxvalue == 0){
			$percentage = 100;
		}else{
			$percentage = ceil(($value/$maxvalue) * 100);
		}
		// ############# !!!!!!!!!!!!!!!!!! ########################

		 $statresult .= print_gal_statistic_result($dates["$key"], $bar, $value, $percentage);
	}


	$templater = vB_Template::create('adv_gallery_stats_stat1');
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('stats', $stats);
	$templater->register('tablename', $tablename);
	$templater->register('statresult', $statresult);
	$templater->register('bgclass', $bgclass);
	$topresult = $templater->render();

}
$stats=array();
	// Total Stats pulled from datastore
	$stats['images'] = vb_number_format($maximages);
	$stats['views'] = vb_number_format($maxviews);
	$stats['categories'] = vb_number_format($maxcategories);
	$stats['memcat'] = vb_number_format($maxmembercat);
	$stats['cards'] = vb_number_format($maxcards);
	$stats['posts'] = vb_number_format($maxposts);
	$stats['diskspace'] = vb_number_format($maxfilesize + $maxorigfilesize, 1, true);



// ######################### Sidebar position & correction ############################

	// in stats we allways show sidebar
	$show['sidebar'] = true;

	if($ppg_options['gallery_stats_sidebar'])
	{
		$ppg_vars['sidebarpos'] = 'right';
	}
	else
	{
		$ppg_vars['sidebarpos'] = 'left';
	}
	if($vbulletin->stylevars['left']['string'] == 'right' AND $ppg_options['gallery_stats_sidebar_corr'])
	{
		$ppg_vars['sidebarpos'] = ($ppg_vars['sidebarpos'] == 'right') ? 'left' :'right';
	}
	// always opposite to sidebar
	$ppg_vars['contentpos'] =  ($ppg_vars['sidebarpos'] == 'left') ? 'right' :'left';

// ######################### END /Sidebar position correction ############################



	$templater = vB_Template::create('adv_gallery_stats_sidebar');
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('stats', $stats);
	$templater->register('maxuploadxs', $maxuploadxs);
		$templater->register('maxcatxs', $maxcatxs);
	$templater->register('adv_sorturl', $adv_sorturl);
	$templater->register('image', $image);
	$sidebar = $templater->render();

	// Page is open

	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$ppg_vars['gallery_title'] = $ppg_options['gallery_title'];


	/* ### Add announcement if active */
	if($ppgal_announcement)
	{
		$navbar = $navbar . $ppgal_announcement;
	}
	/* ### Construct metatags (not needed here as we have no follow but its nicer to have default tags) */	

	$headinclude = construct_metatags($headinclude);

	$templater = vB_Template::create('ADV_GALLERY_STATS');

	$templater->register_page_templates();
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('navbar', $navbar);
	$templater->register('sidebar', $sidebar);
	

	$templater->register('stats', $stats);
	$templater->register('topresult', $topresult);
	$templater->register('sidebar', $sidebar);

	print_output($templater->render());
}
else
{
	// Page is closed
	$navbits = array();
	$ppg_options['nav_gallery_url']	  =  $ppg_options['gallery_url'] . '/index.php' .  $vbulletin->session->vars['sessionurl_q'];
	$navbits["$ppg_options[nav_gallery_url]"] = $vbphrase['gallery'];
	
	$navbits[''] = "$vbphrase[stats_menu1]";

	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$ppg_vars['gallery_title'] = $ppg_options['gallery_title'];
	$templater = vB_Template::create('adv_gallery_stats_close');

	$templater->register_page_templates();
	$templater->register('ppg_vars', $ppg_vars);
	$templater->register('navbar', $navbar);
	$templater->register('sidebar', $sidebar);

	print_output($templater->render());
}
?>