<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: avatar.php                                                       ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'gallery_avatar');
define('VBGLITE', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'adv_gallery_editimg'
);

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
    'ADV_GALLERY_SETAVATAR'
	);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################

	require_once('./gallery_global.php');

// main setting

if(!$ppg_options['gallery_set_img_avatar'])
{
	print_no_permission();
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################


	$image = array();
	$image['imageid'] = $vbulletin->input->clean_gpc('g', 'imageid', TYPE_INT);
	$image['imageid'] = intval($image['imageid']);
	check_image_id($image['imageid']);
	$imageinfo = $db->query_first("
			SELECT imageid, catid, userid, filename, thumbname, originalname, width, height, originalwidth, originalheight, extension, valid
			FROM " . TABLE_PREFIX . "ppgal_images
			WHERE imageid = '$image[imageid]'
	");
	// check permissions
	$categoryperms = fetch_category_perms();

	$iscatmod = is_category_mod($image['catid']);

	$catopts = construct_cat_opts($imageinfo['catid'], $categorycache["$imageinfo[catid]"]['options']);

	if ((!$vbulletin->userinfo['userid'] OR ($imageinfo['userid'] != $vbulletin->userinfo['userid'] AND !$categoryperms["$imageinfo[catid]"]['caneditothersimages']) OR ($imageinfo['userid'] == $vbulletin->userinfo['userid'] AND !$categoryperms["$imageinfo[catid]"]['caneditimages'])) AND !$iscatmod)
	{
		print_no_permission();
	}
	if($imageinfo['valid'] != 1)
	{
		print_no_permission();
	}
	$userid = $imageinfo['userid'];
	$imageid = $image['imageid'];

	// get user's avatar

	require_once(DIR . '/includes/functions_user.php');
	$imageuserinfo = fetch_userinfo($userid, FETCH_USERINFO_AVATAR);

	fetch_avatar_from_userinfo($imageuserinfo, false, true);
	if(strpos($imageuserinfo['avatarurl'], $vbulletin->options['bburl']) === false) 
	{
		$imageuserinfo['avatarurl'] = $vbulletin->options['bburl'] . '/' . $imageuserinfo['avatarurl'];
	}
	

	// get thumbnail as avatar

	$imageinfo['thumburl'] = construct_image_url($imageinfo, 'thumbname');
	$imageinfo['imagebitclass'] = ($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1) ? '_alt' : '';
	$imageuserinfo['imagebitclass'] = $imageinfo['imagebitclass'];
	if($_REQUEST['do'] == 'doavatar')
	{
		$vbulletin->input->clean_array_gpc('p', array(
		'userid'    => TYPE_UINT,
		'avatarid'  => TYPE_INT,
		'avatarurl' => TYPE_STR,
		'resize'    => TYPE_BOOL,
		));

		//$useavatar = iif($vbulletin->GPC['avatarid'] == -1, 0, 1);
		$useavatar = 1;
		$userinfo =& $imageuserinfo;
		if (!$userinfo)
		{
			standard_error(fetch_error('invalid_user_specified'));
		
		}

		$vbulletin->GPC['avatarurl'] = $imageinfo['thumburl'];
		// init user datamanager
		$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_CP);
		$userdata->set_existing($userinfo);

		// custom avatar
		$vbulletin->input->clean_gpc('f', 'upload', TYPE_FILE);

		require_once(DIR . '/includes/class_upload.php');
		require_once(DIR . '/includes/class_image.php');

		$upload = new vB_Upload_Userpic($vbulletin);

		$upload->data =& datamanager_init('Userpic_Avatar', $vbulletin, ERRTYPE_CP, 'userpic');
		$upload->image =& vB_Image::fetch_library($vbulletin);
		$upload->userinfo =& $userinfo;

		cache_permissions($userinfo, false);

		// user's group doesn't have permission to use custom avatars so set override
		/*	check if user is admin or mod */

		if (!($userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar']))
		{
			if($iscatmod)
			{
				$userdata->set_bitfield('adminoptions', 'adminavatar', 1);
			}
			else
			{
				print_no_permission();
			}
		}


		if ($userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar'])
		{
			$upload->maxwidth = $userinfo['permissions']['avatarmaxwidth'];
			$upload->maxheight = $userinfo['permissions']['avatarmaxheight'];
			#$upload->maxuploadsize = $userinfo['permissions']['avatarmaxsize'];
			#$upload->allowanimation = ($userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['cananimateavatar']) ? true : false;
		}
		else
		{
			print_no_permission();
		}


		if (!$upload->process_upload($vbulletin->GPC['avatarurl']))
		{
			standard_error(fetch_error('there_were_errors_encountered_with_your_upload_x', $upload->fetch_error()));
		}
	
		$userdata->set('avatarid', 0);
		$userdata->save();

		$vbulletin->url = 'avatar.php?' . $vbulletin->session->vars['sessionurl'] . 'imageid=' . $image['imageid'] . '&amp;do=showavatar';
		eval(print_standard_redirect('saved_avatar_successfully'));

	}
	else if($_REQUEST['do'] == 'showavatar')
	{
		$templater = vB_Template::create('ADV_GALLERY_SETAVATAR');
		$templater->register_page_templates();

		$templater->register('imageuserinfo', $imageuserinfo);
		$templater->register('imageinfo', $imageinfo);

	  	print_output($templater->render());
	}
	else
	{
$show['thumbnail'] = true;
		$templater = vB_Template::create('ADV_GALLERY_SETAVATAR');
		$templater->register_page_templates();

		$templater->register('imageuserinfo', $imageuserinfo);
		$templater->register('imageinfo', $imageinfo);

	  	print_output($templater->render());
	}

?>