<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: xba_unsharp_mask.php                                             ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/



function sharpen($img, $sharpen=0)
{

	////////////////////////////////////////////////////////////////////////////////////////////////   
	////   
	////                  Unsharp Mask for PHP - version 2.1.1   
	////   
	////    Unsharp mask algorithm by Torstein Hnsi 2003-07.   
	////             thoensi_at_netcom_dot_no.   
	////               Please leave this notice.   
	////   
	///////////////////////////////////////////////////////////////////////////////////////////////   
    /*

    // $img is an image that is already created within php using
    // imgcreatetruecolor. No url! $img must be a truecolor image.

    // ****************************************************************************
    // ***************** begin configuration part *********************************
    // ***************** only touch this if you know what you are doing !!! *******
    // ****************************************************************************

    // ***** you can modify the sharpening parameters here... but attention.. it could give unpredictable results.
	*/

    if($sharpen > 0)
    {

        switch ($sharpen)
        {
            case 1:
                $amount = 110;
                $radius = 0.5;
                $threshold = 2;
                break;
            case 2:
                $amount = 250;
                $radius = 0.95;
                $threshold = 4;
                break;
            case 3:
                $amount = -80;
                $radius = -0.3;
                $threshold = -1.5;
                break;
            case 4:
                $amount = 90;
                $radius = 0.5;
                $threshold = 3;
                break;
			case 5: 
				$amount = 85; 
				$radius = 0.6; 
				$threshold = 4; 
				break; 
			case 6: 
				$amount = 85; 
				$radius = 0.55; 
				$threshold = 3; 
				break; 
            default:
                $sharpen = 0;
                break;
        }
       


		/*
			case 1: 
				$amount = 120; 
				$radius = 0.5; 
				$threshold = 3; 
				break; 

			case 2: 
				$amount = 150; 
				$radius = 0.75; 
				$threshold = 4; 
				break; 
			case 3: 
				$amount = -80; 
				$radius = -0.3; 
				$threshold = -1.5; 
				break; 
			case 4: 
				$amount = -160; 
				$radius = -0.5; 
				$threshold = -3; 
				break; 
			case 5: 
				$amount = 110; 
				$radius = 0.3; 
				$threshold = 1; 
				break; 
			default: 
				$sharpen = 0; 
				break; 


		*/
    }


//$amount = 50; $radius = 1; $threshold = 0;


    // ****************************************************************************
    // ***************** end of configuration part ********************************
    // ***************** dont touch below !!! *************************************
    // ****************************************************************************
    if($sharpen > 0)
    {
		// Attempt to calibrate the parameters to Photoshop:  
		if ($amount > 500)    $amount = 500;  
		$amount = $amount * 0.016;  
		if ($radius > 50)    $radius = 50;  
		$radius = $radius * 2;  
		if ($threshold > 255)    $threshold = 255;  
		  
		$radius = abs(round($radius));     // Only integers make sense.  
		if ($radius == 0) 
		{
			return $img;
		}  
		$w = imagesx($img); $h = imagesy($img);  
		$imgCanvas = imagecreatetruecolor($w, $h);  
		$imgBlur = imagecreatetruecolor($w, $h);  
		  

		// Gaussian blur matrix:  
		//                          
		//    1    2    1          
		//    2    4    2          
		//    1    2    1          
		//                          
		//////////////////////////////////////////////////  
			  

		if (function_exists('imageconvolution')) { // PHP >= 5.1   
				$matrix = array(   
				array( 1, 2, 1 ),   
				array( 2, 4, 2 ),   
				array( 1, 2, 1 )   
			);   
			imagecopy ($imgBlur, $img, 0, 0, 0, 0, $w, $h);  
			imageconvolution($imgBlur, $matrix, 16, 0);   
		}   
		else {   

		// Move copies of the image around one pixel at the time and merge them with weight  
		// according to the matrix. The same matrix is simply repeated for higher radii.  
			for ($i = 0; $i < $radius; $i++)    {  
				imagecopy ($imgBlur, $img, 0, 0, 1, 0, $w - 1, $h); // left  
				imagecopymerge ($imgBlur, $img, 1, 0, 0, 0, $w, $h, 50); // right  
				imagecopymerge ($imgBlur, $img, 0, 0, 0, 0, $w, $h, 50); // center  
				imagecopy ($imgCanvas, $imgBlur, 0, 0, 0, 0, $w, $h);  

				imagecopymerge ($imgBlur, $imgCanvas, 0, 0, 0, 1, $w, $h - 1, 33.33333 ); // up  
				imagecopymerge ($imgBlur, $imgCanvas, 0, 1, 0, 0, $w, $h, 25); // down  
			}  
		}  

		if($threshold>0){  
			// Calculate the difference between the blurred pixels and the original  
			// and set the pixels  
			for ($x = 0; $x < $w-1; $x++)    { // each row 
				for ($y = 0; $y < $h; $y++)    { // each pixel  
						  
					$rgbOrig = ImageColorAt($img, $x, $y);  
					$rOrig = (($rgbOrig >> 16) & 0xFF);  
					$gOrig = (($rgbOrig >> 8) & 0xFF);  
					$bOrig = ($rgbOrig & 0xFF);  
					  
					$rgbBlur = ImageColorAt($imgBlur, $x, $y);  
					  
					$rBlur = (($rgbBlur >> 16) & 0xFF);  
					$gBlur = (($rgbBlur >> 8) & 0xFF);  
					$bBlur = ($rgbBlur & 0xFF);  
					  
					// When the masked pixels differ less from the original  
					// than the threshold specifies, they are set to their original value.  
					$rNew = (abs($rOrig - $rBlur) >= $threshold)   
						? max(0, min(255, ($amount * ($rOrig - $rBlur)) + $rOrig))   
						: $rOrig;  
					$gNew = (abs($gOrig - $gBlur) >= $threshold)   
						? max(0, min(255, ($amount * ($gOrig - $gBlur)) + $gOrig))   
						: $gOrig;  
					$bNew = (abs($bOrig - $bBlur) >= $threshold)   
						? max(0, min(255, ($amount * ($bOrig - $bBlur)) + $bOrig))   
						: $bOrig;  
					  
					  
								  
					if (($rOrig != $rNew) || ($gOrig != $gNew) || ($bOrig != $bNew)) {  
							$pixCol = ImageColorAllocate($img, $rNew, $gNew, $bNew);  
							ImageSetPixel($img, $x, $y, $pixCol);  
						}  
				}  
			}  
		}  
		else{  
			for ($x = 0; $x < $w; $x++)    { // each row  
				for ($y = 0; $y < $h; $y++)    { // each pixel  
					$rgbOrig = ImageColorAt($img, $x, $y);  
					$rOrig = (($rgbOrig >> 16) & 0xFF);  
					$gOrig = (($rgbOrig >> 8) & 0xFF);  
					$bOrig = ($rgbOrig & 0xFF);  
					  
					$rgbBlur = ImageColorAt($imgBlur, $x, $y);  
					  
					$rBlur = (($rgbBlur >> 16) & 0xFF);  
					$gBlur = (($rgbBlur >> 8) & 0xFF);  
					$bBlur = ($rgbBlur & 0xFF);  
					  
					$rNew = ($amount * ($rOrig - $rBlur)) + $rOrig;  
						if($rNew>255){$rNew=255;}  
						elseif($rNew<0){$rNew=0;}  
					$gNew = ($amount * ($gOrig - $gBlur)) + $gOrig;  
						if($gNew>255){$gNew=255;}  
						elseif($gNew<0){$gNew=0;}  
					$bNew = ($amount * ($bOrig - $bBlur)) + $bOrig;  
						if($bNew>255){$bNew=255;}  
						elseif($bNew<0){$bNew=0;}  
					$rgbNew = ($rNew << 16) + ($gNew <<8) + $bNew;  
						ImageSetPixel($img, $x, $y, $rgbNew);  
				}  
			}  
		}  
		imagedestroy($imgCanvas);  
		imagedestroy($imgBlur);  

	}// end if $sharpen > 0

	return $img;
}
?>