<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: gallery_profile_block.php                                        ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/


/* ######################  PROFILE GALLERY TAB ADD-ON ###################################*/

/**
* Class for Profile Photopost vBgallery Block
*
*/
class vB_ProfileBlock_vBGallery extends vB_ProfileBlock
{
	/**
	* The name of the template to be used for the block
	*
	* @var string
	*/
	var $template_name = 'adv_gallery_member_block';
		
	function block_is_enabled()
	{
		// permissions are allready checked before this is called... so we return true anyway
		return true;
	}
	function confirm_empty_wrap()
	{
		return false;
	}

	function confirm_display()
	{
		// permissions are allready checked before this is called... so we return true anyway
		return true;
	}

	function prepare_output($id = '', $options = array())
	{
		global $ppg_options, $show, $vbphrase;

		//	get user title first

		if($ppg_options['gallery_use_plurals_s'])
		{
			$this->block_data['blocktitle'] = construct_phrase($vbphrase['usernames_gallery'], $this->profile->userinfo['username'], iif(substr( strtolower($this->profile->userinfo['username']), -1) != 's', $vbphrase['plural_s']));
		}
		else
		{
			$this->block_data['blocktitle'] = construct_phrase($vbphrase['usernames_gallery'], $this->profile->userinfo['username'], $vbphrase['plural_s']);
		}
		// show editlink
		if($this->registry->userinfo['userid'] AND $ppg_options['add_ucp_changeprofile'] AND ($this->profile->userinfo['userid'] == $this->registry->userinfo['userid']) AND $ppg_options['canchangprofile'])
		{
			$this->block_data['edit_link'] = '<a class="textcontrol" style="font-weight:normal;" href="profile.php?' . $this->registry->session->vars['sessionurl'] . 'do=vbgalleryprofile">' . $vbphrase['edit_gallery_block'] . '</a>';
			$show['editlink'] = true;
		}
		// show editlink
		
		if($this->registry->userinfo['userid'] AND $ppg_options['add_ucp_changeprofile'] AND ($this->profile->userinfo['userid'] != $this->registry->userinfo['userid']) AND ($ppg_options['caneditothersimages'] AND $ppg_options['candeleteothers']))
		{
			$this->block_data['adminedit_link'] = '<a class="textcontrol" style="font-weight:normal;" href="profile.php?' . $this->registry->session->vars['sessionurl'] . 'do=vbgalleryprofile&amp;u=' . $this->profile->userinfo['userid'] . '">' . $vbphrase['edit_users_gallery_block'] . '</a>';
			$this->block_data['edit_images_link'] = '<a class="textcontrol" style="font-weight:normal;" href="profile.php?' . $this->registry->session->vars['sessionurl'] . 'do=vbgeditimages&amp;u=' . $this->profile->userinfo['userid'] . '">' . $vbphrase['edit_users_images'] . '</a>';
			$show['admineditlink'] = true;
		}

		$tmp_vars['israting'] = false;	
		// clean orderby
		switch($ppg_options['add_ucp_profile_orderby'])
		{
			case '1':  
				$tmp_vars['orderby'] = 'dateline DESC'; 
				$tmp_vars['contextphrase'] = '';
				$tmp_vars['contexttitle'] = 'x_newest_uploads_by_y';
			
				break;
			case '2':  
				$tmp_vars['orderby'] = 'views DESC'; 
				$tmp_vars['contextphrase'] = 'views';
				$tmp_vars['contexttitle'] = 'x_most_viewed_uploads_by_y';
				$tmp_vars['contextfield'] = 'views';
				break;
			case '3':  
				$tmp_vars['orderby'] = 'posts DESC';
				$tmp_vars['contextphrase'] = 'comments';
				$tmp_vars['contexttitle'] = 'x_most_commented_uploads_by_y';	
				$tmp_vars['contextfield'] = 'posts';
				break;
			case '4':
				$tmp_vars['votequery'] = 'IF(votenum >= ' . $this->registry->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $this->registry->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
				$tmp_vars['orderby'] = 'voteavg DESC, votenum DESC';
				$tmp_vars['israting'] = true;
				$tmp_vars['contextphrase'] = 'rating';
				$tmp_vars['contexttitle'] = 'x_highest_rated_uploads_by_y';
				$tmp_vars['contextfield'] = 'voteavg';

				break;
			case '5':  
				$tmp_vars['orderby'] = 'RAND()'; 
				$tmp_vars['contextphrase'] = '';
				$tmp_vars['contexttitle'] = 'x_random_uploads_by_y';						
				break;
			default:  
				$tmp_vars['orderby'] = 'dateline DESC';
				$tmp_vars['contextphrase'] = '';
				$tmp_vars['contexttitle'] = 'x_newest_uploads_by_y';
		}

		$show['vbg_highlightblock'] = ($ppg_options['add_ucp_tabhighlight']) ? true : false;
		$show['vbg_thumbblock'] = ($ppg_options['add_ucp_profile_tabthumbs']) ? true : false;
		if(!$show['vbg_thumbblock'] AND $show['vbg_highlightblock'])
		{
			$ppg_options['add_ucp_profile_limit'] = ($ppg_options['add_ucp_profile_limit']>1) ? 1 : $ppg_options['add_ucp_profile_limit'];
		}
		$show['vbg_statsblock'] = ($ppg_options['add_ucp_tabstats_active']) ? true : false;

		// dont touch! - we get the more link if there are really more images... so we add 1
		$ppg_options['add_ucp_profile_limit_tmp'] = $ppg_options['add_ucp_profile_limit'] + 1;
		
		$tmp_vars['privatecatids'] = fetch_private_categories();
		// Get a list of categories to be EXCLUDED from our queries
		if ($tmp_vars['privatecatids'])
		{
			$tmp_vars['privcatids'] = 'images.catid NOT IN(' . $tmp_vars['privatecatids'] . ') AND ';
		}
		if($ppg_options['add_ucp_profile_cutoff'])
		{
			$tmp_vars['cutoffdate'] = ' AND images.dateline > ' . (time() - ($ppg_options['add_ucp_profile_cutoff'] * 86400));
		}
		if($ppg_options['add_ucp_profile_include'])
		{
			$catlimit = $ppg_options['add_ucp_profile_include'];
			$tmp_vars['include'] = ' AND images.catid IN (' . $catlimit . ') ';
		}
		if($ppg_options['add_ucp_profile_exclude'])
		{
			$notcat = $ppg_options['add_ucp_profile_exclude'];
			$tmp_vars['exclude'] = ' AND images.catid NOT IN (' . $notcat . ') ';
		}

		$userimages = $this->registry->db->query_read_slave("
			SELECT $tmp_vars[votequery] imageid, images.userid, images.username, images.title, images.views,images.posts, filename, width, height, thumbname, originalname, extension, images.catid , categories.title AS cattitle
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (categories.catid = images.catid)
			WHERE $tmp_vars[privcatids] valid = 1 AND images.userid = " . $this->profile->userinfo['userid'] . "
				$tmp_vars[cutoffdate]
				$tmp_vars[exclude]
				$tmp_vars[include]
			ORDER BY $tmp_vars[orderby]
			LIMIT " . $ppg_options['add_ucp_profile_limit_tmp'] . "
		");


		$this->block_data['imagebits'] = '';

		$image = array();

		if ($this->registry->db->num_rows($userimages))
		{
			
			// show slideshow if more than 1 image
			$show['slideslink'] = false;
			if($this->registry->db->num_rows($userimages) > 1)
			{
				$show['slideslink'] = true;
				$this->block_data['slides_link'] = '<a class="textcontrol" style="font-weight:normal;" href="' . $ppg_options['gallery_url'] . '/misc.php?' . $this->registry->session->vars['sessionurl'] . 'do=slideshow&amp;imageuser='.$this->profile->userinfo['userid'] . '">' . $vbphrase['view_as_slideshow'] . '</a>';

			}
			if($this->registry->db->num_rows($userimages) > $ppg_options['add_ucp_profile_limit'])
			{
				$show['vbg_morelink'] = true;
				$morephrase = construct_phrase($vbphrase['more_uploads_by_x'], $this->profile->userinfo['username']);
				$this->block_data['more_link'] = '<a class="textcontrol" style="font-weight:normal;" href="' . $ppg_options['gallery_url'] . '/browseimages.php?' . $this->registry->session->vars['sessionurl'] . 'catid=member&amp;imageuser='.$this->profile->userinfo['userid'] . '">' . htmlspecialchars_uni($morephrase) . '</a>';

			}

			/* highlight image */

			/* calculate local css for tablefree imgbit */
			$cssval = array();
			$cssval['cssopen'] = ' style="';
			$cssval['cssclose'] = '" ';
			$cssval['padding'] = $this->registry->stylevars['padding']['size']*2;
			$cssval['borderx2'] = ($this->registry->stylevars['ppg_thumb_border']['width']*2)+2; // we add 2px... doesnt harm

			$cssval['tmp'] = $ppg_options['gallery_thumbsize'] + (($this->registry->stylevars['ppg_thumb_framewidth']['size'] *2) + $cssval['borderx2']) + $cssval['padding'];
			$cssval['iblock1'] = $cssval['cssopen'] . 'margin:5px 0px; width:'.$cssval['tmp']. 'px;min-width:'.$cssval['tmp'].'px;' . $cssval['cssclose'];
			$cssval['tmp'] = $ppg_options['gallery_thumbsize'] + (($this->registry->stylevars['ppg_thumb_framewidth']['size'] *2) + $cssval['borderx2']);
			$cssval['icblock'] = $cssval['cssopen']. 'height:'.$cssval['tmp']. 'px;line-height:'.$cssval['tmp'].'px;' . $cssval['cssclose'];
			
			$tmp_vars['disp_none'] = 'nodisp';

			if($ppg_options['add_ucp_profile_showtitle'] OR $ppg_options['add_ucp_profile_showcat'] OR $ppg_options['add_ucp_profile_showcontext'])
			{
				$show['bottext'] = true;
			}
			$tmp_vars['albumclass'] = ($this->registry->stylevars['ppg_thumb_customstyle']['numeric'] == 1) ? '_alt' : '';
			$counter = 0;
			while ($image = $this->registry->db->fetch_array($userimages))
        	{
            	
				$counter++;
				$tmp_vars['sort_url'] = '&amp;catid=member&amp;imageuser=' . intval($image['userid']);
				$image['albumbitclass'] = $tmp_vars['albumclass'];

				if($counter == 1 AND $show['vbg_highlightblock'])
				{
					$image['url'] = construct_image_url($image, 'filename');
					$image['link'] = $ppg_options['gallery_url'] . '/showimage.php?' . $this->registry->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $tmp_vars['sort_url'];
		
					if($ppg_options['add_ucp_tabhighlight_size'] AND (($image['width']>$ppg_options['add_ucp_tabhighlight_size']) OR ($image['height']>$ppg_options['add_ucp_tabhighlight_size'])))
					{
						if($image['width']>$image['height'])
						{
							$image['dispwidth'] = $ppg_options['add_ucp_tabhighlight_size'];
							$image['dispheight'] = round( $ppg_options['add_ucp_tabhighlight_size'] / ($image['width']/$image['height'])); 
						}
						else
						{
							$image['dispheight'] = $ppg_options['add_ucp_tabhighlight_size'];
							$image['dispwidth'] = round( $ppg_options['add_ucp_tabhighlight_size'] / ($image['height']/$image['width']));
						}
						$image['height'] = $image['dispheight'];
						$image['width'] = $image['dispwidth'];
					}

				}
				else
				{
					if($counter > $ppg_options['add_ucp_profile_limit'])
					{
						$counter = $counter-1;
						break;
					}
		
					$image['url'] = construct_image_url($image, 'thumbname');
					$image['link'] = $ppg_options['gallery_url'] . '/showimage.php?' . $this->registry->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $tmp_vars['sort_url'];
				}
				if ($image['voteavg'])
				{
					$image['voteavg'] = vb_number_format($image['voteavg'], 2);
				}
					
				$image['alt'] = '';

				if($this->registry->stylevars['textdirection']['string'][0] == 'l')
				{
					if($ppg_options['add_ucp_profile_showhtitle'])
					{
						$image['alt'] .= $image['title'];
					}
					if($ppg_options['add_ucp_profile_husername'])
					{
						$image['alt'] .= ' ' . construct_phrase($vbphrase['by_x_nl'], $image['username']);
					}
					if($ppg_options['add_ucp_profile_showhcat'])
					{
						$image['alt'] .= ' ' . construct_phrase($vbphrase['in_x_nl'], $image['cattitle']);
					}
					if($ppg_options['add_ucp_profile_showhcontext'] AND $tmp_vars['contextphrase'] != '')
					{
						if($tmp_vars['israting'] AND $image[$tmp_vars['contextfield']] == 0)
						{
							$image[$tmp_vars['contextfield']] = $vbphrase['n_a'];
						}
						$image['alt'] .= ' || ' . $vbphrase[$tmp_vars['contextphrase']] . ': '. $image[$tmp_vars['contextfield']];
					}

				}
				else
				{
					if($ppg_options['add_ucp_profile_showhcontext'] AND $tmp_vars['contextphrase'] != '')
					{
						if($tmp_vars['israting'] AND $image[$tmp_vars['contextfield']] == 0)
						{
							$image[$tmp_vars['contextfield']] = $vbphrase['n_a'];
						}
						
						$image['alt'] .= 'x ' . $image[$tmp_vars['contextfield']] . ' :' . $vbphrase[$tmp_vars['contextphrase']] . ' || ';
					}

					if($ppg_options['add_ucp_profile_showhcat'])
					{
						$image['alt'] .= construct_phrase($vbphrase['in_x_nl'], $image['cattitle']) . ' ';
					}
					if($ppg_options['add_ucp_profile_husername'])
					{
						$image['alt'] .= construct_phrase($vbphrase['by_x_nl'], $image['username']) . ' ';
					}
					if($ppg_options['add_ucp_profile_showhtitle'])
					{
						$image['alt'] .= $image['title'];
					}
				}
				$image['alt'] = htmlspecialchars_uni($image['alt']);
				$image['titletag'] = $image['alt'];

				if($counter == 1 AND $show['vbg_highlightblock'])
				{
					$image['choptitle'] = $image['title'];
				}
				else
				{
					if($this->registry->stylevars['textdirection']['string'][0] == 'l')
					{
						$image['choptitle'] = (vbstrlen($image['title'])>25) ? trim(vbchop($image['title'],22)) . '...' : $image['title'];
					}
					else
					{
						$image['choptitle'] = (vbstrlen($image['title'])>25) ? '...' . trim(vbchop($image['title'],22)) : $image['title'];
					}
				}
				$image['choptitle'] = htmlspecialchars_uni($image['choptitle']);

				if($ppg_options['add_ucp_profile_contextfirst'])
				{
					if($ppg_options['add_ucp_profile_showcontext'] AND $tmp_vars['contextphrase'] != '')
					{
						if($tmp_vars['israting'] AND $image[$tmp_vars['contextfield']] == 0)
						{
							$image[$tmp_vars['contextfield']] = $vbphrase['n_a'];
						}

						$image['bottxt1'] =  '<dl style="display:inline;"><dt style="display:inline;">' . $vbphrase[$tmp_vars['contextphrase']] . '</dt> : <dd style="display:inline;">' . $image[$tmp_vars['contextfield']] . '</dd></dl>';					
						if($this->registry->stylevars['textdirection']['string'][0] == 'l')
						{
							$image['bottxt1'] = $vbphrase[$tmp_vars['contextphrase']] . ': ' . $image[$tmp_vars['contextfield']];
						}
						else
						{
							$image['bottxt1'] =  '<dl style="display:inline;"><dt style="display:inline;">'. $vbphrase[$tmp_vars['contextphrase']] . '</dt>: <dd style="display:inline;">' . $image[$tmp_vars['contextfield']].'</dd></dl>';		
						}
						$image['btl1class'] = 'mf nw';
					}
					else
					{
						$image['btl1class'] = $tmp_vars['disp_none'];
					}
					if($ppg_options['add_ucp_profile_showtitle'])
					{
						$image['bottxt2'] = '<a href="' . $image['link'] . '">' . $image['choptitle'] . '</a>';
						if($ppg_options['add_ucp_profile_showcontext'] AND $tmp_vars['contextphrase'] != '')
						{
							$image['btl2class'] = 'sf';
						}
						else
						{
							$image['btl2class'] = 'mf nw';
						}
					}
					else
					{
						$image['btl2class'] = $tmp_vars['disp_none'];
					}						
					if($ppg_options['add_ucp_profile_showcat'])
					{
						$image['bottxt3'] = construct_phrase($vbphrase['in_x'], $ppg_options['gallery_url'] . '/browseimages.php?'. $this->registry->session->vars['sessionurl'] . 'c=' . intval($image['catid']), htmlspecialchars_uni($image['cattitle']) );
						
						if($ppg_options['add_ucp_profile_showtitle'] OR ($ppg_options['add_ucp_profile_showcontext'] AND $tmp_vars['contextphrase'] != ''))
						{
							$image['btl3class'] = 'sf';
						}
						else
						{
							$image['btl3class'] = 'mf nw';
						}
					}
					else
					{
						$image['btl3class'] = $tmp_vars['disp_none'];
					}						
				}
				else
				{
					if($ppg_options['add_ucp_profile_showtitle'])
					{
						$image['bottxt1'] = '<a href="' . $image['link'] . '">' . $image['choptitle'] . '</a>';
						$image['btl1class'] = 'mf nw';
					}
					else
					{
						$image['btl1class'] = $tmp_vars['disp_none'];
					}
					if($ppg_options['add_ucp_profile_showcat'])
					{
						$image['bottxt2'] = construct_phrase($vbphrase['in_x'], $ppg_options['gallery_url'] . '/browseimages.php?'. $this->registry->session->vars['sessionurl'] . 'c=' . intval($image['catid']), htmlspecialchars_uni($image['cattitle']) );
						if($ppg_options['add_ucp_profile_showtitle'])
						{
							$image['btl2class'] = 'sf';
						}
						else
						{
							$image['btl2class'] = 'mf nw';
						}
					}
					else
					{
						$image['btl2class'] = $tmp_vars['disp_none'];
					}
					if($ppg_options['add_ucp_profile_showcontext'] AND $tmp_vars['contextphrase'] != '')
					{
						if($tmp_vars['israting'] AND $image[$tmp_vars['contextfield']] == 0)
						{
							$image[$tmp_vars['contextfield']] = $vbphrase['n_a'];
						}
						if($this->registry->stylevars['textdirection']['string'][0] == 'l')
						{
							$image['bottxt3'] = $vbphrase[$tmp_vars['contextphrase']] . ': '. $image[$tmp_vars['contextfield']];
						}
						else
						{
							$image['bottxt3'] = '<dl style="display:inline;"><dt style="display:inline;">'. $vbphrase[$tmp_vars['contextphrase']] . '</dt>: <dd style="display:inline;">' . $image[$tmp_vars['contextfield']].'</dd></dl>';		
						}
						if($ppg_options['add_ucp_profile_showtitle'] OR $ppg_options['add_ucp_profile_showcat'])
						{
							$image['btl3class'] = 'sf';
						}
						else
						{
							$image['btl3class'] = 'mf nw';
						}
					}
					else
					{
						$image['btl3class'] = $tmp_vars['disp_none'];
					}
				}
				$image['btbclass'] = 'tcap';

					
				if($counter == 1 AND $show['vbg_highlightblock'])
				{
					$templater = vB_Template::create('adv_gallery_member_highlight_block');
					$templater->register('image', $image);
					$templater->register('cssval', $cssval);
					$this->block_data['highlightblock'] = $templater->render();
				
				}
				else
				{
					$templater = vB_Template::create('adv_gallery_imgbit_free');
					$templater->register('image', $image);
					$templater->register('cssval', $cssval);
					$tmp_vars['imagebits'] .= $templater->render();
				}
				
            }
			$this->block_data['imagebits'] = '<ul id="ppgGalImageblock" class="ppgGal">' . $tmp_vars['imagebits'] . '</ul>';


			unset($image,$cssval);
			
			$this->block_data['images_block_title'] = construct_phrase($vbphrase[$tmp_vars['contexttitle']], $counter, $this->profile->userinfo['username']);
			
		}
		else
		{
			$show['vbg_highlightblock'] = false;
			$show['vbg_thumbblock'] = false;
		}

		unset($tmp_vars);

            // Totals
            //#######################################################################
            $mytotals = $this->registry->db->query_read_slave("
              SELECT
              SUM( views ) AS views,
              SUM( filesize ) AS normal,
              SUM( originalfilesize ) AS original,
              SUM( sticky ) AS sticky,
              SUM( votenum ) AS votenum
              FROM " . TABLE_PREFIX . "ppgal_images
              WHERE valid = 1 AND userid = " . $this->profile->userinfo['userid'] . "
            ");

            while ($mytotal = $this->registry->db->fetch_array($mytotals))
			{
            	$mytotal['total'] = $mytotal['normal'] + $mytotal['original'];
                $this->block_data['total_spaceused'] = vb_number_format($mytotal['total'], 1, true);
                $this->block_data['total_views'] = vb_number_format($mytotal['views']);
                $this->block_data['total_sticky'] = vb_number_format($mytotal['sticky']);
                $this->block_data['total_votes'] = vb_number_format($mytotal['votenum']);
			}
			unset($mytotal);
             //////////////////////////////////////////////////////////////////////////////////////////
	} // end prepare_output
	
} // end class

?>