<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: forumhome_start.php                                              ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/


/* ######################  FORUMHOME IMAGES ADD-ON ###################################*/
// This is the start of the forumhome add-on to display images
$tmp_vars = array();
/*
###################  
	Get permissions
###################
*/

if (!$vbulletin->adv_gallery_opt['gallery_stats_forumhome'] AND is_array($vbulletin->ppg_stats))
{
	unset($vbulletin->ppg_stats);
	$tmp_vars['nostats'] = true;
}
if ($vbulletin->adv_gallery_opt['gallery_active'] AND ($vbulletin->adv_gallery_opt['add_home_active'] OR $vbulletin->adv_gallery_opt['add_home_sidebar'] OR $vbulletin->adv_gallery_opt['add_home_header']))
{
	if(!is_array($ppg_options))
	{
		$ppg_options =& $vbulletin->adv_gallery_opt;
	}
	$ppg_vars = array();
	require_once(DIR . '/includes/functions_gallery_lite.php');
	$gallery_permissions =& $vbulletin->gallery_ugroups;
	$categorycache =& $vbulletin->gallery_c_cache;
    $galleryperms = (!is_array($galleryperms) OR empty($galleryperms)) ? fetch_galperms() : $galleryperms;
}
else
{
	if(is_array($galleryperms))
	{
		unset($galleryperms);
	}
	unset($vbulletin->gallery_ugroups,$vbulletin->gallery_c_cache);
	if($tmp_vars['nostats'])
	{
		unset($vbulletin->adv_gallery_opt);
		if(is_array($ppg_options))
		{
			unset($ppg_options);
		}
	}
}

if (!$vbulletin->adv_gallery_opt['gallery_stats_forumhome'] AND is_array($vbulletin->ppg_stats))
{
	unset($vbulletin->ppg_stats);
}
/*
#############  
	Get cache
#############
*/
if($galleryperms['canviewforumhomeblock'])
{
	$tmp_vars['use_cache'] = false;

	if($ppg_options['add_home_cache_refresh'])
	{
		$vbgimageblock =& $vbulletin->gallery_ext_img_cache;
		$tmp_vars['update_img_cache'] = false;
		if((!is_array($vbgimageblock) AND $ppg_options['add_home_cache_refresh']) OR empty($vbgimageblock['lastupdate']) )
		{
			$vbgimageblock = array();
			$vbgimageblock['lastupdate'] = 0;
		}


		$tmp_vars['update_img_cache'] = ($ppg_options['add_home_cache_refresh']) ? false : true;

		$tmp_vars['update_img_cache'] = (!$tmp_vars['update_img_cache']) ? check_imgext_cache($vbgimageblock['lastupdate'], 1) : $tmp_vars['update_img_cache'];

			
		// check if amount or type of images changed... if yes override and redo cache
		if(!$tmp_vars['update_img_cache'] AND ($vbgimageblock['block1_amount'] != $ppg_options['add_home_sb_limit'] OR $vbgimageblock['block2_amount'] != $ppg_options['add_home_limit'] OR $vbgimageblock['block3_amount'] != $ppg_options['add_home_hd_limit'] OR $vbgimageblock['block2_orderby'] != $ppg_options['add_home_orderby'] OR $vbgimageblock['block1_orderby'] != $ppg_options['add_home_sb_orderby'] OR $vbgimageblock['block3_orderby'] != $ppg_options['add_home_hd_orderby']))
		{
			$tmp_vars['update_img_cache'] = true;
		}
	
		if(!$tmp_vars['update_img_cache'] AND 
			($vbgimageblock['block2_active'] != $ppg_options['add_home_active'] 
			OR $vbgimageblock['block1_active'] != $ppg_options['add_home_sidebar']
			OR $vbgimageblock['block3_active'] != $ppg_options['add_home_header']))
		{
			$tmp_vars['update_img_cache'] = true;
		}

	}
	else
	{
		$tmp_vars['update_img_cache'] = true;
	}

	$tmp_vars['privatecatids'] = fetch_private_categories();

	if($ppg_options['add_home_cache_refresh'] == 0 OR !$ppg_options['add_home_cache_refresh'])
	{
		$tmp_vars['ignusers'] = fetch_ignored_users();
	}
	
	unset($galleryperms,$gallery_permissions,$categorycache,$vbulletin->gallery_ugroups,$vbulletin->gallery_c_cache);

	$vbgimageblock['lastupdate'] = ($tmp_vars['update_img_cache']) ? TIMENOW : $vbgimageblock['lastupdate'];
	$tmp_vars['get_blocks'] = true;
}
else
{
	unset($galleryperms,$gallery_permissions,$categorycache,$vbulletin->gallery_ugroups,$vbulletin->gallery_c_cache);
	$tmp_vars['update_img_cache'] = false;
	$tmp_vars['get_blocks'] = false;

}
/*
############## 
	Get Images
##############
*/

$ppg_options['add_home_titlechop']=20;

if($tmp_vars['get_blocks'])
{

	if($tmp_vars['update_img_cache'])
	{

		// Get a list of categories to be EXCLUDED from our queries
		if ($tmp_vars['privatecatids'])
		{
			$tmp_vars['privcatids'] = 'images.catid NOT IN(' . $tmp_vars['privatecatids'] . ') AND ';
		}
		/* ignore users wont work, if cache is on... */
		if($ppg_options['add_home_cache_refresh'] == 0 OR !$ppg_options['add_home_cache_refresh'])
		{
			
			if ($tmp_vars['ignusers'])
			{
				$tmp_vars['ignquery'] = 'AND images.userid NOT IN(' . $tmp_vars['ignusers'] . ')';
			}
		}
			
		$tmp_vars['homeimages_datecut'] = TIMENOW - (86400*$ppg_options['add_home_cutoff']);
		
		/*######### create header images #########*/

		if($ppg_options['add_home_header'])
		{

			$ppg_options['add_home_hd_orderby'] = (empty($ppg_options['add_home_hd_orderby'])) ? 10 : $ppg_options['add_home_hd_orderby'];

			switch ($ppg_options['add_home_hd_orderby'])
			{
				case 2: 
					$tmp_vars['hdorderby'] = 'views DESC';
					$tmp_vars['imgtypes'] = 'most_viewed_images';
					break;
				case 3:
					$tmp_vars['hdorderby'] = 'posts DESC';
					$tmp_vars['imgtypes'] = 'most_commented_images';
					break;
				case 4:
					$tmp_vars['votequery'] = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
					$tmp_vars['hdorderby'] = 'voteavg DESC, votenum DESC';
					$tmp_vars['imgtypes'] = 'popular_images';
					break;
				case 5:
					$tmp_vars['hdorderby'] = 'RAND()';
					$tmp_vars['imgtypes'] = 'random_images';
					break;
				case 6:
					$tmp_vars['hdorderby'] = 'RAND()';
					$tmp_vars['stickyquery'] = 1;
					$tmp_vars['imgtypes'] = 'sticky_images';
					break;
				default: 
					$tmp_vars['hdorderby'] = 'dateline DESC';
					$tmp_vars['imgtypes'] = 'newest_images';
			}	


			$hdimages = $db->query_read("
					SELECT $votequery imageid, images.userid, images.username, images.title, filename, thumbname, originalname, extension, images.catid , categories.title AS cattitle
					FROM " . TABLE_PREFIX . "ppgal_images AS images
					LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (categories.catid = images.catid)
					WHERE $tmp_vars[privcatids] valid = 1 $tmp_vars[ignquery]

						" . iif(isset($tmp_vars['stickyquery']), "AND sticky = 1 ") . "
						" . iif(!empty($ppg_options['add_home_cutoff']), "AND dateline >= $tmp_vars[homeimages_datecut]") . "
						" . iif(!empty($ppg_options['add_home_include']), "AND images.catid IN ($ppg_options[add_home_include])") . "
						" . iif(!empty($ppg_options['add_home_exclude']), "AND images.catid NOT IN ($ppg_options[add_home_exclude])") . "
					ORDER BY $tmp_vars[hdorderby]
					LIMIT " . $ppg_options['add_home_hd_limit'] . "
				");

			if($db->affected_rows())
			{
				$tmp_vars['lastbit'] = $db->affected_rows();
			}

			$tmp_vars['hdgal_imagebits'] = '';
			$image = array();

			$tmp_vars['albumclass'] = ($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1) ? '_alt' : '';

			$vbgimageblock['block3'] = array();
			$tmp_vars['disp_none'] = 'nodisp';


			$ppg_options['add_home_hd_size'] = intval($ppg_options['add_home_hd_size']);
			$ppg_options['add_home_hd_percent'] = intval($ppg_options['add_home_hd_percent']);
				// get header container height...
			$tmp_vars['hdgal_container_height'] = ($ppg_options['add_home_hd_size']>0) ? $ppg_options['add_home_hd_size'] : (($ppg_options['add_home_hd_percent']>0) ? round(($ppg_options['gallery_thumbsize']*$ppg_options['add_home_hd_percent'])/100) : 50);
			
			$show['toptext'] = false;
			$show['bottext'] = false;
			$counter = 0;
			while ($image =  $vbulletin->db->fetch_array($hdimages))
			{
				$counter++;
				$tmp_vars['sort_url'] = '&amp;c=' . $image['catid'];
				$image['url'] = construct_image_url($image, 'thumbname');
				$image['link'] = $ppg_options['gallery_url'] . '/showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $tmp_vars['sort_url'];

				$image['alt'] = htmlspecialchars_uni(construct_phrase($vbphrase['x_by_y'], $image['title'], $image['username']));
				$image['titletag'] = $image['alt'];

				$image['extra'] = ' style="height:'.$tmp_vars['hdgal_container_height'].'px;" ';
				$image['albumbitclass'] = '';
				if($counter == 1)
				{
					$image['albumbitclass'] = 'first';
				}
				else if($counter == $tmp_vars['lastbit'])
				{
					$image['albumbitclass'] = 'last';
				}

				$templater = vB_Template::create('adv_gallery_imgbit_free');
				$templater->register('image', $image);
				$imagebit_tmp = $templater->render();
				

				$tmp_vars['hdgal_imagebits'] .= $imagebit_tmp;
				$vbgimageblock['block3'][] = $imagebit_tmp;
			}

			$db->free_result($hdimages);
			unset($image, $imagebit_tmp);

			$tmp_vars['hdgal_imagebits'] = '<ul id="headerimgs" style="white-space:nowrap;" class="ppgGalheader">' . $tmp_vars['hdgal_imagebits'] . '</ul>';
			
			$tmp_vars['hdgal_imagebits'] = str_replace(array("\n","\r"),'',$tmp_vars['hdgal_imagebits']);
			$tmp_vars['hdgal_imagebits'] = preg_replace('/\s\s+/', ' ', $tmp_vars['hdgal_imagebits']);
			$tmp_vars['hdgal_imagebits'] = str_replace(array("> <",">	<"),'><',$tmp_vars['hdgal_imagebits']);
			$tmp_vars['hdgal_imagebits'] = '<div class="ppGaltopframe" style="height:' . ($tmp_vars['hdgal_container_height']+4) . 'px;border:none;">' . $tmp_vars['hdgal_imagebits'] . '</div><div class="galclear"></div>';


			$header .= $tmp_vars['hdgal_imagebits'];
			unset($imagebit_tmp);

		}

		/*######### create sidebar images #########*/

		if($ppg_options['add_home_sidebar'])
		{
			$ppg_options['add_home_sb_orderby'] = (empty($ppg_options['add_home_sb_orderby'])) ? 10 : $ppg_options['add_home_sb_orderby'];
			
			switch ($ppg_options['add_home_sb_orderby'])
			{
				case 2: $tmp_vars['sborderby'] = 'views DESC'; $tmp_vars['imgtypes'] = 'most_viewed_images'; break;
				case 3: $tmp_vars['sborderby'] = 'posts DESC'; $tmp_vars['imgtypes'] = 'most_commented_images';break;
				case 4:
					$votequery = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
					$tmp_vars['sborderby'] = 'voteavg DESC, votenum DESC';
					$tmp_vars['imgtypes'] = 'popular_images';
				break;
				case 5: $tmp_vars['sborderby'] = 'RAND()'; $tmp_vars['imgtypes'] = 'random_images'; break;
				case 6: $tmp_vars['sborderby'] = 'RAND()'; $tmp_vars['stickyquery'] = 1; $tmp_vars['imgtypes'] = 'sticky_images'; break;
				default: 
					$tmp_vars['sborderby'] = 'dateline DESC';
					$tmp_vars['imgtypes'] = 'newest_images';
			}	
			
			$counter = 0;
			$sbimages = $db->query_read("
				SELECT $votequery imageid, images.userid, images.username, images.title, filename, thumbname, originalname, extension, images.catid , categories.title AS cattitle
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (categories.catid = images.catid)
				WHERE $tmp_vars[privcatids] valid = 1 $tmp_vars[ignquery]

					" . iif(isset($tmp_vars['stickyquery']), "AND sticky = 1 ") . "
					" . iif(!empty($ppg_options['add_home_cutoff']), "AND dateline >= $tmp_vars[homeimages_datecut]") . "
					" . iif(!empty($ppg_options['add_home_include']), "AND images.catid IN ($ppg_options[add_home_include])") . "
					" . iif(!empty($ppg_options['add_home_exclude']), "AND images.catid NOT IN ($ppg_options[add_home_exclude])") . "
				ORDER BY $tmp_vars[sborderby]
				LIMIT " . $ppg_options['add_home_sb_limit'] . "
			");

			$tmp_vars['sbgal_imagebits'] = '';
			$image = array();
			
			$tmp_vars['albumclass'] = ($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1) ? '_alt' : '';

			$vbgimageblock['block1'] = array();
			$tmp_vars['disp_none'] = 'nodisp';

			while ($image =  $vbulletin->db->fetch_array($sbimages))
			{
				$counter++;
				$tmp_vars['sort_url'] = '&amp;c=' . $image['catid'];
				$image['url'] = construct_image_url($image, 'thumbname');
				$image['link'] = $ppg_options['gallery_url'] . '/showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $tmp_vars['sort_url'];
				
				$image['albumbitclass'] = $tmp_vars['albumclass'];

				if($vbulletin->stylevars['textdirection']['string'][0] == 'l')
				{
					$image['choptitle'] = (vbstrlen($image['title'])>$ppg_options['add_home_titlechop'])? trim(vbchop($image['title'],$ppg_options['add_home_titlechop'])) . '...' : $image['title'];
				}
				else
				{
					$image['choptitle'] = (vbstrlen($image['title'])>$ppg_options['add_home_titlechop'])? '...' . trim(vbchop($image['title'],$ppg_options['add_home_titlechop'])) : $image['title'];
				}
				$image['choptitle'] = htmlspecialchars_uni($image['choptitle']);
	
				$image['alt'] = htmlspecialchars_uni(construct_phrase($vbphrase['x_by_y'], $image['title'], $image['username']));
				$image['titletag'] = $image['alt'];

				$image['bottxt1'] = '<a href="' . $image['link'] . '">' . $image['choptitle'] . '</a>';
				$image['bottxt2'] = construct_phrase($vbphrase['in_x'], $ppg_options['gallery_url'] . '/browseimages.php?'. $vbulletin->session->vars['sessionurl'] . 'c=' . intval($image['catid']), htmlspecialchars_uni($image['cattitle']) );

				$show['bottext'] = true;
				$image['btbclass'] = 'tcap';
				$image['btl1class'] = 'mf nw';
				$image['btl2class'] = 'sf';
				$image['btl3class'] = $tmp_vars['disp_none'];

				$templater = vB_Template::create('adv_gallery_imgbit_free');
				$templater->register('image', $image);
				
				$imagebit_tmp = $templater->render();
				$tmp_vars['sbgal_imagebits'] .= $imagebit_tmp;
				$vbgimageblock['block1'][] = $imagebit_tmp;
			}

			$db->free_result($sbimages);
			unset($image, $imagebit_tmp);

			if($tmp_vars['sbgal_imagebits'] != '')
			{
					$tmp_vars['sbgal_imagebits'] = '<ul id="ppgalsb" class="ppgsbGal">' . $tmp_vars['sbgal_imagebits'] . '</ul>';
					$tmp_vars['sidebar_done'] = construct_home_sidebar($tmp_vars['sbgal_imagebits']);
			}

		}

		/*######### create main block images #########*/

		if($ppg_options['add_home_active'])
		{
			$ppg_options['add_home_orderby'] = (empty($ppg_options['add_home_orderby'])) ? 10 : $ppg_options['add_home_orderby'];
			$tmp_vars['imgtypes'] = 'images';
	
			switch ($ppg_options['add_home_orderby'])
			{
				case 2: $tmp_vars['orderby'] = 'views DESC'; $tmp_vars['imgtypes'] = 'most_viewed_images'; break;
				case 3: $tmp_vars['orderby'] = 'posts DESC'; $tmp_vars['imgtypes'] = 'most_commented_images';break;
				case 4:
					$votequery = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
					$tmp_vars['orderby'] = 'voteavg DESC, votenum DESC';
					$tmp_vars['imgtypes'] = 'popular_images';
					break;
				case 5: $tmp_vars['orderby'] = 'RAND()';$tmp_vars['imgtypes'] = 'random_images'; break;
				case 6: $tmp_vars['orderby'] = 'RAND()'; $tmp_vars['stickyquery'] = 1 ;$tmp_vars['imgtypes'] = 'sticky_images'; break;
				
				default: 
					$tmp_vars['orderby'] = 'dateline DESC';
					$tmp_vars['imgtypes'] = 'newest_images';
			}
			/* keep as we may one day switch back to tables
			$cellwidth = round(100 / $ppg_options['gallery_columns']) . '%';
			$linecounter = 0;
			*/
			$counter = 0;
			$images = $db->query_read("
				SELECT $votequery imageid, images.userid, images.title, images.username, filename, thumbname, originalname, extension, images.catid, categories.title AS cattitle
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (categories.catid = images.catid)
				WHERE $tmp_vars[privcatids] valid = 1 $tmp_vars[ignquery]
					
					" . iif(isset($tmp_vars['stickyquery']), "AND sticky = 1 ") . "
					" . iif(!empty($ppg_options['add_home_cutoff']), "AND dateline >= $tmp_vars[homeimages_datecut]") . "
					" . iif(!empty($ppg_options['add_home_include']), "AND images.catid IN ($ppg_options[add_home_include])") . "
					" . iif(!empty($ppg_options['add_home_exclude']), "AND images.catid NOT IN ($ppg_options[add_home_exclude])") . "
				ORDER BY $tmp_vars[orderby]
				LIMIT " . $ppg_options['add_home_limit'] . "
			");
			$tmp_vars['gal_imagebits'] = '';
			$image = array();
			$tmp_vars['albumclass'] = ($vbulletin->stylevars['ppg_thumb_customstyle']['numeric'] == 1) ? '_alt' : '';
			/* calculate local css for tablefree imgbit */
			$cssval = array();
			$cssval['cssopen'] = ' style="';
			$cssval['cssclose'] = '" ';
			$cssval['padding'] = $vbulletin->stylevars['padding']['size']*2;
			$cssval['borderx2'] = ($vbulletin->stylevars['ppg_thumb_border']['width']*2)+2; // we add 2px... doesnt harm

			$cssval['tmp'] = $ppg_options['gallery_thumbsize'] + (($vbulletin->stylevars['ppg_thumb_framewidth']['size'] *2) + $cssval['borderx2']) + $cssval['padding'];
			$cssval['iblock1'] = $cssval['cssopen'] . 'margin:5px 0px; width:'.$cssval['tmp']. 'px;min-width:'.$cssval['tmp'].'px;' . $cssval['cssclose'];
			$cssval['tmp'] = $ppg_options['gallery_thumbsize'] + (($vbulletin->stylevars['ppg_thumb_framewidth']['size'] *2) + $cssval['borderx2']);
			$cssval['icblock'] = $cssval['cssopen']. 'height:'.$cssval['tmp']. 'px;line-height:'.$cssval['tmp'].'px;' . $cssval['cssclose'];
			
			$vbgimageblock['block2'] = array();
			$tmp_vars['disp_none'] = 'nodisp';

			//$cssval['cellwidth'] = $cellwidth;
			
			while ($image =  $vbulletin->db->fetch_array($images))
			{
				$counter++;

				$image['albumbitclass'] = $tmp_vars['albumclass'];
				$tmp_vars['sort_url'] = '&amp;c=' . $image['catid'];
				$image['url'] = construct_image_url($image, 'thumbname');
				$image['link'] = $ppg_options['gallery_url'] . '/showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . $tmp_vars['sort_url'];

				$image['alt'] = htmlspecialchars_uni(construct_phrase($vbphrase['x_by_y'], $image['title'], $image['username']));
				$image['titletag'] = $image['alt'];

				if($vbulletin->stylevars['textdirection']['string'][0] == 'l')
				{
					$image['choptitle'] = (vbstrlen($image['title'])>$ppg_options['add_home_titlechop'])? vbchop($image['title'],$ppg_options['add_home_titlechop']) . '...' : $image['title'];
				}
				else
				{
					$image['choptitle'] = (vbstrlen($image['title'])>$ppg_options['add_home_titlechop'])? '...' . vbchop($image['title'],$ppg_options['add_home_titlechop']) : $image['title'];
				}
					
				$image['choptitle'] = htmlspecialchars_uni($image['choptitle']);

				$image['bottxt1'] = '<a href="' . $image['link'] . '">' . $image['choptitle'] . '</a>';

				$image['bottxt2'] = construct_phrase($vbphrase['in_x'], $ppg_options['gallery_url'] . '/browseimages.php?'. $vbulletin->session->vars['sessionurl'] . 'c=' . intval($image['catid']), htmlspecialchars_uni($image['cattitle']) );
			
				$image['btbclass'] = 'tcap';
				$show['bottext'] = true;
				$image['btl1class'] = 'mf nw';
				$image['btl2class'] = 'sf';
				$image['btl3class'] = $tmp_vars['disp_none'];
				
				$templater = vB_Template::create('adv_gallery_imgbit_free');
				$templater->register('image', $image);
				$templater->register('cssval', $cssval);
				$imagebit_tmp = $templater->render();
				$tmp_vars['gal_imagebits'] .= $imagebit_tmp;
				$vbgimageblock['block2'][] = $imagebit_tmp;

			}

			$db->free_result($images);
			unset($image, $cssval);

			if($tmp_vars['gal_imagebits'] != '')
			{
			
			// process imagebits
				$ppg_vars['skip_pos'] = false;
				$tmp_vars['imgtypes'] = get_type_phrase($ppg_options['add_home_orderby']);

				// get height of container... not needed as container allready constructed
				// $tmp_vars['container_height'] = $ppg_options['gallery_thumbsize'] + (($vbulletin->stylevars['ppg_thumb_framewidth']['size'] *2) + 10 + 10 + ($vbulletin->stylevars['ppg_thumb_border']['width']*2));
			
				$tmp_vars['gal_imagebits'] = '<ul id="ppgGalImageblock" class="ppgGal">' . $tmp_vars['gal_imagebits'] . '</ul>';

				$tmp_vars['blocktitle'] = construct_phrase($vbphrase['x_from_y'], $vbphrase[$tmp_vars['imgtypes']], $ppg_options['gallery_title']);
				$tmp_vars['blocktitleurl'] = $ppg_options['gallery_url'] . '/';
					


				/* ######################## Position Images	######################## */
				if(in_array($ppg_options['add_home_place'], array(8,7,6,3,2,1)) )
				{
					$show['norandh2'] = ($ppg_options['add_home_place'] == 1) ? true : false;
					$show['extra_spacer'] = ($ppg_options['add_home_place'] == 3) ? true : false; 
					$templater = vB_Template::create('adv_gallery_forumhome_block');
					$templater->register('imagebits', $tmp_vars['gal_imagebits']);
					$templater->register('blocktitle', $tmp_vars['blocktitle']);
					$templater->register('blocktitleurl', $tmp_vars['blocktitleurl']);
					$imagebit_tmp = $templater->render();
				}

				switch ($ppg_options['add_home_place'])
				{
					case 1: 
							$ppg_vars['below_navbar'] = true;
							$ppg_vars['gal_imagebits_tmp'] = $imagebit_tmp;
						break;
					case 2: 
							$template_hook['forumhome_above_forums'] = $imagebit_tmp . $template_hook['forumhome_above_forums'];
						break;
					case 3: 
							$template_hook['forumhome_below_forums'] = $imagebit_tmp . $template_hook['forumhome_below_forums'];
						break;

					case 4: 
							$ppg_vars['imgtypes'] = $tmp_vars['imgtypes'];
							$ppg_vars['blockpos'] = 'above_stats';
							$ppg_vars['skip_pos'] = true;
							$ppg_vars['gal_imagebits'] = $tmp_vars['gal_imagebits'];
						break;
					case 5:
							$ppg_vars['imgtypes'] = $tmp_vars['imgtypes'];						
							$ppg_vars['blockpos'] = 'below_stats';
							$ppg_vars['skip_pos'] = true;
							$ppg_vars['gal_imagebits'] = $tmp_vars['gal_imagebits'];
						break;
					case 6:
							$ppg_vars['imgtypes'] = $tmp_vars['imgtypes'];
							$ppg_vars['after_forums'] = true;
							$ppg_vars['gal_imagebits_tmp'] = $imagebit_tmp;
						break;
					case 7: 
							$ppg_vars['after_wgo'] = true;
							$ppg_vars['gal_imagebits_tmp'] = $imagebit_tmp;
						break;
					case 8: 
							$footer = $imagebit_tmp . $footer;
						break;
					case 9:
							$templater = vB_Template::create('adv_gallery_forumhome_block_bot');
							$templater->register('imagebits', $tmp_vars['gal_imagebits']);
							$templater->register('blocktitle', $tmp_vars['blocktitle']);
							$templater->register('blocktitleurl', $tmp_vars['blocktitleurl']);
							$imagebit_tmp = $templater->render();
							$footer .= $imagebit_tmp;
							
						break;
					default:
							$ppg_vars['imgtypes'] = $tmp_vars['imgtypes'];						
							$ppg_vars['blockpos'] = 'below_stats';
							$ppg_vars['skip_pos'] = true;
							$ppg_vars['gal_imagebits'] = $tmp_vars['gal_imagebits'];
				
				}
				unset($imagebit_tmp);


			}



		}

		/*#########  update cache #########*/
		if($ppg_options['add_home_cache_refresh'])
		{
			$vbgimageblock['block1_amount'] = $ppg_options['add_home_sb_limit'];
			$vbgimageblock['block2_amount'] = $ppg_options['add_home_limit'];
			$vbgimageblock['block3_amount'] = $ppg_options['add_home_hd_limit'];
			$vbgimageblock['block1_active'] = $ppg_options['add_home_sidebar'];
			$vbgimageblock['block2_active'] = $ppg_options['add_home_active'];
			$vbgimageblock['block3_active'] = $ppg_options['add_home_header'];
			$vbgimageblock['block1_orderby'] = $ppg_options['add_home_sb_orderby'];
			$vbgimageblock['block2_orderby'] = $ppg_options['add_home_orderby'];
			$vbgimageblock['block3_orderby'] = $ppg_options['add_home_hd_orderby'];
			build_datastore('gallery_ext_img_cache',serialize($vbgimageblock),1);
		}

		unset($vbgimageblock);
		if(is_array($vbulletin->gallery_ext_img_cache))
		{
			unset($vbulletin->gallery_ext_img_cache);
		}

	}
	else
	{
		/* use cached data */
		/*######### create sidebar #########*/
		if($ppg_options['add_home_sidebar'])
		{
			if(is_array($vbgimageblock['block1']))
			{
				foreach($vbgimageblock['block1'] AS $imgbit)
				{
					$tmp_vars['sbgal_imagebits'] .= $imgbit;
				}
				unset($imgbit);
			}
			else
			{
				$tmp_vars['sbgal_imagebits'] = $vbgimageblock['block1'];
			}

			$tmp_vars['sbgal_imagebits'] = '<ul id="ppgalsb" class="ppgsbGal">' . $tmp_vars['sbgal_imagebits'] . '</ul>';

			$tmp_vars['sidebar_done'] = construct_home_sidebar($tmp_vars['sbgal_imagebits']);
		}

		/*######### create headerimages #########*/

		if($ppg_options['add_home_header'])
		{
			$tmp_vars['hdgal_imagebits'] = '';
			if(is_array($vbgimageblock['block3']))
			{
				foreach($vbgimageblock['block3'] AS $imgbit)
				{
					$tmp_vars['hdgal_imagebits'] .= $imgbit;
				}
				unset($imgbit);
			}
			//print $tmp_vars['hdgal_imagebits'];exit;
			if($tmp_vars['hdgal_imagebits'] != '')
			{
				$tmp_vars['hdgal_container_height'] = ($ppg_options['add_home_hd_size']>0) ? $ppg_options['add_home_hd_size'] : (($ppg_options['add_home_hd_percent']>0) ? round(($ppg_options['gallery_thumbsize']*$ppg_options['add_home_hd_percent'])/100) : 50);

				$tmp_vars['hdgal_imagebits'] = '<ul id="headerimgs" style="white-space:nowrap;" class="ppgGalheader">' . $tmp_vars['hdgal_imagebits'] . '</ul>';

				$tmp_vars['hdgal_imagebits'] = str_replace(array("\n","\r"),'',$tmp_vars['hdgal_imagebits']);
				$tmp_vars['hdgal_imagebits'] = preg_replace('/\s\s+/', ' ', $tmp_vars['hdgal_imagebits']);
				$tmp_vars['hdgal_imagebits'] = str_replace(array("> <",">	<"),'><',$tmp_vars['hdgal_imagebits']);

				$imagebit_tmp = '<div class="ppGaltopframe" style="height:' . ($tmp_vars['hdgal_container_height'] + 4) . 'px;border:none;">' . $tmp_vars['hdgal_imagebits'] . '</div><div class="galclear"></div>';

				if(!isset($header))
				{
					// we have to render a dummy to get $header
					$templater = vB_Template::create('adv_gallery_imgbit_free');
					$tmp_vars['tmptest'] = $templater->render();
				}
				$header .= $imagebit_tmp;
				unset($imagebit_tmp);
			}
		}
		/*######### create main image block #########*/

		if($ppg_options['add_home_active'])
		{
			$tmp_vars['gal_imagebits'] = '';
			if(is_array($vbgimageblock['block2']))
			{
				foreach($vbgimageblock['block2'] AS $imgbit)
				{
					$tmp_vars['gal_imagebits'] .= $imgbit;
				}
				unset($imgbit);
			}
			else
			{
				$tmp_vars['gal_imagebits'] = $vbgimageblock['block2'];
			}
			if($tmp_vars['gal_imagebits'] != '')
			{
				// process imagebits
				$ppg_vars['skip_pos'] = false;
				$tmp_vars['imgtypes'] = get_type_phrase($ppg_options['add_home_orderby']);

				// get height of container... not needed as container allready constructed
				// $tmp_vars['container_height'] = $ppg_options['gallery_thumbsize'] + (($vbulletin->stylevars['ppg_thumb_framewidth']['size'] *2) + 10 + 10 + ($vbulletin->stylevars['ppg_thumb_border']['width']*2));
			
				$tmp_vars['gal_imagebits'] = '<ul id="ppgGalImageblock" class="ppgGal">' . $tmp_vars['gal_imagebits'] . '</ul>';

				$tmp_vars['blocktitle'] = construct_phrase($vbphrase['x_from_y'], $vbphrase[$tmp_vars['imgtypes']], $ppg_options['gallery_title']);
				$tmp_vars['blocktitleurl'] = $ppg_options['gallery_url'] . '/';
					


				/* ######################## Position Images	######################## */
				if(in_array($ppg_options['add_home_place'], array(8,7,6,3,2,1)) )
				{
					$show['norandh2'] = ($ppg_options['add_home_place'] == 1) ? true : false;
					$show['extra_spacer'] = ($ppg_options['add_home_place'] == 3) ? true : false; 
					$templater = vB_Template::create('adv_gallery_forumhome_block');
					$templater->register('imagebits', $tmp_vars['gal_imagebits']);
					$templater->register('blocktitle', $tmp_vars['blocktitle']);
					$templater->register('blocktitleurl', $tmp_vars['blocktitleurl']);
					$imagebit_tmp = $templater->render();
				}

				switch ($ppg_options['add_home_place'])
				{
					case 1: 
							$ppg_vars['below_navbar'] = true;
							$ppg_vars['gal_imagebits_tmp'] = $imagebit_tmp;
						break;
					case 2: 
							$template_hook['forumhome_above_forums'] = $imagebit_tmp . $template_hook['forumhome_above_forums'];
						break;
					case 3: 
							$template_hook['forumhome_below_forums'] = $imagebit_tmp . $template_hook['forumhome_below_forums'];
						break;

					case 4: 
							$ppg_vars['imgtypes'] = $tmp_vars['imgtypes'];						
							$ppg_vars['blockpos'] = 'above_stats';
							$ppg_vars['skip_pos'] = true;
							$ppg_vars['gal_imagebits'] = $tmp_vars['gal_imagebits'];
						break;
					case 5:
							$ppg_vars['imgtypes'] = $tmp_vars['imgtypes'];						
							$ppg_vars['blockpos'] = 'below_stats';
							$ppg_vars['skip_pos'] = true;
							$ppg_vars['gal_imagebits'] = $tmp_vars['gal_imagebits'];
						break;
					case 6:
							$ppg_vars['after_forums'] = true;
							$ppg_vars['gal_imagebits_tmp'] = $imagebit_tmp;
						break;
					case 7: 
							$ppg_vars['after_wgo'] = true;
							$ppg_vars['gal_imagebits_tmp'] = $imagebit_tmp;
						break;
					case 8: 
							$footer = $imagebit_tmp . $footer;
						break;
					case 9:
							$templater = vB_Template::create('adv_gallery_forumhome_block_bot');
							$templater->register('imagebits', $tmp_vars['gal_imagebits']);
							$templater->register('blocktitle', $tmp_vars['blocktitle']);
							$templater->register('blocktitleurl', $tmp_vars['blocktitleurl']);
							$imagebit_tmp = $templater->render();
							$footer .= $imagebit_tmp;
							
						break;
					default:
							$ppg_vars['imgtypes'] = $tmp_vars['imgtypes'];						
							$ppg_vars['blockpos'] = 'below_stats';
							$ppg_vars['skip_pos'] = true;
							$ppg_vars['gal_imagebits'] = $tmp_vars['gal_imagebits'];
				
				}
				unset($imagebit_tmp);
			}
		}
	}
	/* create stylesheet */
	if(!isset($headinclude))
	{
		$templater = vB_Template::create('adv_gallery_imgbit_free');
		$tmp_vars['tmptest'] = $templater->render();
	}
	$headinclude .= create_stylesheet('adv_gallery_forumhome.css');
}
unset($tmp_vars);
/* #####  /FORUMHOME IMAGES ADD-ON continued in forumhome complete #####*/
?>