<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: gallery_search.php                                               ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// hard coded because I dont know if options are available here
// AND they are not planned to be in ACP yet anyway 
// IF we implement gallery keyword cloud we activate it here
// for the moment the table does not exist!!!!
// so use_gal_keycloud MUST be false...

$ppg_options['use_gal_cloud'] = true;
// keyword cloud is not implemented yet ;-)
$ppg_options['use_gal_keycloud'] = false;
$ppg_options['searchid_limit'] = 20;




if (!is_object($vbulletin->db))
{
	exit;
}

// keep the last 10 searches...
$thissearcharray = array();
$thissearcharray[] = 0;
$do_work = true;
$limit = intval($ppg_options['searchid_limit']);
if($limit>0)
{
	$thiscronsearch = $vbulletin->db->query_read("SELECT searchid FROM " . TABLE_PREFIX . "ppgal_search
			ORDER BY dateline DESC
			LIMIT $limit
	");

	if ($vbulletin->db->affected_rows($thiscronsearch) <= 10)
	{
		$do_work = false;
	}
	else
	{
		$lastsearches = array();
		while ($lastsearches = $vbulletin->db->fetch_array($thiscronsearch))
		{ 
			$thissearcharray[] = $lastsearches['searchid'];
		}		
		unset($lastsearches);
	}
	$vbulletin->db->free_result($thiscronsearch);
}
if($do_work)
{
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_search WHERE dateline < " . (TIMENOW - 86400) . " AND searchid NOT IN(" . implode(',', $thissearcharray) . ")");
	$vbulletin->db->query_write("OPTIMIZE TABLE " . TABLE_PREFIX . "ppgal_search");
	$optimize_1 = true;
}
unset($thissearcharray);

/* ############### Prune Search Tag Cloud  ################ */
if($ppg_options['use_gal_cloud'])
{
	$prune_gal_tag_amount = 2000;
	$tag_buffer = 500;
	$tagssearch = $vbulletin->db->query_first("SELECT COUNT(timestamp) AS totaltags FROM " . TABLE_PREFIX . "ppgal_searchtags");

	if($tagssearch['totaltags']>$prune_gal_tag_amount)
	{
		$taglimit = ($tagssearch['totaltags'] - $prune_gal_tag_amount) + $tag_buffer;
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_searchtags ORDER BY timestamp ASC LIMIT $taglimit");
		if(!$optimize_1)
		{
			$vbulletin->db->query_write("OPTIMIZE TABLE " . TABLE_PREFIX . "ppgal_searchtags");
			$optimize_2 = true;
		}

	}
	unset($tagssearch);
}
/* ############### /Prune Search Tag Cloud  ################ */

/* ############### Prune Keyword Tag Cloud  ################ */
if($ppg_options['use_gal_keycloud'])
{
	$prune_gal_tag_amount = 2000;
	$tag_buffer = 500;
	$imgtagssearch = $vbulletin->db->query_first("SELECT COUNT(timestamp) AS totaltags FROM " . TABLE_PREFIX . "ppgal_img_tags");
	if($imgtagssearch['totaltags']== 0)
	{

	}
	if($imgtagssearch['totaltags']>$prune_gal_tag_amount)
	{
		$taglimit = ($imgtagssearch['totaltags'] - $prune_gal_tag_amount) + $tag_buffer;
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_img_tags ORDER BY timestamp ASC LIMIT $taglimit");
		if(!$optimize_2)
		{
			$vbulletin->db->query_write("OPTIMIZE TABLE " . TABLE_PREFIX . "ppgal_img_tags");
		}
	}
	unset($imgtagssearch);
	/* ############### /Prune Keyword Tag Cloud  ################ */
}


log_cron_action('', $nextitem, 1);

/* old
$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_search WHERE dateline < " . (TIMENOW - 86400) . "");
log_cron_action('', $nextitem, 1);
*/
?>