<?php
// This is copyright eXaltic.com, 2007 and may not be re-distributed
// without our permission. Please don't remove the link either.

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

require_once('./global.php');
require_once('./includes/adminfunctions_template.php');

print_cp_header('eXaltic path updater');

// Update them?
if ($_GET['do'] == 'update'){
	print '<h2>Updating template paths</h2>';

	if (is_array($_POST['updatestyle'])){
	// Make the IN part of the query
	$query_in = implode(',', array_keys($_POST['updatestyle']));

	// Get everything to be replaced
	$styleimages = $db->query("SELECT * FROM ". TABLE_PREFIX ."template WHERE (title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%')) AND styleid IN(". $query_in .")");

	$laststyle = false;

	// Loop through them
	while ($stylebit = $db->fetch_array($styleimages)){

		if ($stylebit['styleid'] !== $laststyle){
			$laststyle = $stylebit['styleid'];
			print '<h3>Updating style #'. $stylebit['styleid'] .'</h3>';
		}

		$varname = $stylebit['title'];

		if (strtoupper($varname) == 'EXTRA'){
			print ' &nbsp; Replacing CSS extra... ';
			$classarray = unserialize($stylebit['template']);
			// Grab the style first
			$oldbit = $classarray['all'];

			$classarray['all'] = preg_replace('/url\(([^\):;]+)\)/i', 'url('. $vbulletin->options['bburl'] .'/$1)', $oldbit);

			// It's already been done
			if ($oldbit === $classarray['all']){
				print '<em>Skipped</em><br />';
				continue;
			}

			$update = serialize($classarray);
		}
		else if (!($classarray = unserialize($stylebit['template']))){
			print ' &nbsp; Replacing StyleVar..... ';
			$path = $stylebit['template'];

			// It's absolute
			if (strpos($path, ':')){
				print '<em>Skipped</em><br />';
				continue;
			}

			// Grab the style first
			$update = $vbulletin->options['bburl'] .'/'. $path;
		}
		else {
			print ' &nbsp; Replacing CSS class... ';
			$oldbit = $classarray['background'];
			$classarray['background'] = preg_replace('/url\(([^\):;]+)\)/i', 'url('. $vbulletin->options['bburl'] .'/$1)', $oldbit);

			// It's already been done
			if ($oldbit === $classarray['background']){
				print '<em>Skipped</em><br />';
				continue;
			}

			$update = serialize($classarray);
		}

		// Replace it
		$db->query("
				UPDATE ". TABLE_PREFIX ."template SET template = '". $db->escape_string($update) ."' WHERE styleid = ". $stylebit['styleid'] ." AND title = '". $stylebit['title'] ."'
		");
		print '<strong>Done</strong><br />';
	}
	}

	// Get CMPS' settings
	$cmps_settings = $db->query("SELECT * FROM ". TABLE_PREFIX ."adv_setting WHERE varname = 'global_navbar_replace'");
	$row = $db->fetch_array($cmps_settings);

	print '<p>Updating CMPS settings... ';
	// Replace it
	$db->query("UPDATE ". TABLE_PREFIX ."adv_setting SET value = '". $db->escape_string($row['value']) ."' WHERE varname = 'global_header_replace'");
	print '<strong>Done</strong></p>';

	if (function_exists('build_adv_settings')){
		print '<p>Rebuilding CMPS settings... </p>';
		@build_adv_settings();
	}

	print '<p>Rebuilding styles... </p>';
	// Rebuilding styles
	build_all_styles(0, 0);
	print '<h3>Done</h3>';
}
else {
	print_form_header('exaltic_path', 'update');
	print_table_header('Update templates for vBadvanced');
	print_description_row('This will automatically update all image paths to be absolute. You only need to run this tool if you are using vBadvanced or another plug-in that requires full image paths. Why use this? Well because vBadvanced\'s path updater is only made for basic skins. It cannot handle backgrounds added to HTML elements or backgrounds in the EXTRA CSS section. This tool will not alter anything that vBadvanced already has or anything that is already absolute, so you don\'t have to worry about running it twice by accident.<p>Please select all the skins that you wish to be updated for use with vBadvanced. This includes any heavily customised skins.</p><strong>This tool is provided by <a href="http://exaltic.com">eXaltic</a> to be used with our skins.</strong>', 0, 5);
	print_table_break();

	print_table_header('Update Styles', 3);
	print_cells_row(array('<label id="allbox"><input type="checkbox" name="allbox" title="Check All" id="allbox" style="vertical-align: middle;" onclick="js_check_all(this.form);" /> Update?</label>', '<div style="text-align: center;">Style ID</div>', 'Style name'), true, false, -1, 'middle');

	// Grab all the styles
	$styles = $db->query("SELECT styleid, title FROM ". TABLE_PREFIX ."style WHERE  styleid != '-1' ORDER BY styleid, title");

	// Loop through them
	while ($style = $db->fetch_array($styles)){

		print_cells_row(array('<label for="updatestyle_'. $style['styleid'] .'" style="display: block;"><input type="checkbox" id="updatestyle_'. $style['styleid'] .'" name="updatestyle['. $style['styleid'] .']" value="1" /></label>',
			'<label for="updatestyle_'. $style['styleid'] .'" style="display: block; text-align: center;">'. $style['styleid'] .'</label>',
			'<label for="updatestyle_'. $style['styleid'] .'" style="display: block;">'. $style['title'] .'</label>',
		), false, false, -2);

	}

	print_submit_row('Update', 'Reset', 3);
}

print_cp_footer();
?>