<?php
/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *--------------------------------------------------------------------
 * vB Optimise Pro
 * Copyright 2010, Deceptor / DragonByte Technologies
 * All Rights Reserved
 *--------------------------------------------------------------------
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

/****
 * vB Optimise
 * Copyright 2010; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

if (!is_object($vbulletin))
{
	die('Cannot access directly.');
}

define('vboptimise', true);

require_once(DIR . '/vboptimise/core/class_operator_model.php');

class vb_optimise
{
	/**
	* Opcache Operator if assigned
	*
	* @public	object
	*/
	public static $cache = null;

	/**
	* Array of valid Opcache Operator models. Use register() to extend via hooks.
	*
	* @public	array
	*/
	public static $models = array(
		'none',
		'apc',
		'xcache',
		'memcache',
		'eaccelerator',
		'wincache',
		'filecache',
	);

	/**
	* Array of valid cacher libraries to be called through cache(). Use register() to extend via hooks.
	*
	* @public	array
	*/
	public static $cachers = array(
		'datastore',
		'templates',
		'style',
		'notices',
		'showgroups',
		'forumdisplaysub',
		'forumhomewol',
	);

	/**
	* Integer to hold current sessions MySQL queries saved.
	*
	* @public	integer
	*/
	public static $query_count = 0;

	/**
	* String to hold user-defined cache prefix
	*
	* @public	string
	*/
	public static $prefix = '';

	/**
	* Boolean value to determine if page output is cached
	*
	* @private	boolean
	*/
	private static $guestcache = false;

	/**
	* Register extensions to valid Opcache Operators or Cacher Libraries via hooks.
	*
	* @param	string	Extension to register
	* @param	string	Item to register
	*/
	public static function register($to, $what = '')
	{
		if (trim($what) == '')
		{
			return fale;
		}

		if (!self::$$to || in_array($what, self::$$to))
		{
			return false;
		}

		self::$$to = array_merge(self::$$to, array($what));
		self::report('Registered ' . $what . ' to ' . $to);
	}

	/**
	* Reports internal message through to vBulletins debug combo-box.
	*
	* @param	string	Message to report
	*/
	public static function report($msg = '')
	{
		if (VB_AREA != 'AdminCP') // Dev debug messages mess with the vBulletin CMS ACP Management =/
		{
			devdebug('vBOptimise: ' . $msg);
		}
	}

	/**
	* Assigns and connects a valid Opcache Operator
	*
	* @param	string	Opcache Operator to assign
	*/
	public static function assign($model = '')
	{
		global $vbulletin;

		if (!$vbulletin->options['vbo_online'])
		{
			return false;
		}

		if (self::$cache !== null)
		{
			report('assign(' . $model . ') failed. vB Optimise already has a operator.');
			return false;
		}

		if (!in_array($model, self::$models))
		{
			trigger_error('vB Optimise could not assign the operator model \'' . $model . '\'. If you are requesting a custom operator please extend the $models array via vb_optimise::register().', E_USER_ERROR);
		}

		require_once(DIR . '/vboptimise/core/class_operator_' . $model . '.php');

		$class = 'vb_optimise_' . $model;

		self::$cache = new $class();

		if (self::$cache->connect())
		{
			self::report('Assigned Opcache Operator (' . $model . ')');
		}
		else
		{
			self::report('Unable to assign Opcache Operator (' . $model . '). vB Optimise disabled.');
			$vbulletin->options['vbo_online'] = false;
		}
	}

	/**
	* Checks if vB Optimise Cache can be used
	*
	* @param	string	Cache perm to check (optional)
	* 
	* @return	Boolean	True on success
	*/
	public static function check_cache($cache = '')
	{
		global $vbulletin;

		if (!$vbulletin->options['vbo_online'])
		{
			return false;
		}

		if ($cache != '' && !$vbulletin->options['vbo_cache_' . $cache])
		{
			return false;
		}

		if (self::$cache == null)
		{
			report('cache(' . $cache . ') failed. No assignment made yet.');
			return false;
		}

		return true;
	}

	/**
	* Executes a cacher library with optional arguments
	*
	* @param	string	Cache Library to execute
	* @param	mixed	Optional. Reference argument
	* @param	mixed	Optional. Reference argument
	*/
	public static function cache($what = '', &$argument = false, &$argumentb = false, &$argumentc = false)
	{
		global $vbulletin;

		if (!self::check_cache($what))
		{
			return false;
		}

		if (!in_array($what, self::$cachers))
		{
			trigger_error('vB Optimise could not assign the cacher routine \'' . $what . '\'. If you are requesting a custom routine please extend the $cachers array via vb_optimise::register().', E_USER_ERROR);
		}

		require_once(DIR . '/vboptimise/cachers/cacher_' . $what . '.php');
	}

	/**
	* Triggers automatic cache flushes within Admin CP based on executions.
	*/
	public static function update()
	{
		global $vbulletin;

		if (!$vbulletin->options['vbo_online'])
		{
			return false;
		}

		self::report('Looking for conditions to flush cache automatically...');

		// ACP Actions to flush cache on
		$actions = array(
			'updatetemplate',
			'inserttemplate',
			'productimport',
			'rebuild',
			'insertstyle',
			'update',
			'clear_cache',
			'purgecache',
			'displayorder',
			'savestylevar',
			'insert',
			'import',
			'replace',
			'kill',
		);

		// ACP actions to kill whole cache as a failsafe
		$full = array(
			'clear_cache',
			'purgecache',
		);

		if (in_array($_REQUEST['do'], $actions))
		{
			if (in_array($_REQUEST['do'], $full))
			{
				self::$cache->full_flush();
			}
			else
			{
				self::$cache->flush();
			}

			self::report('Automatically flushed cache.');
		}
	}

	/**
	* Pushes statistical data to the cache temporarily
	*
	* @param	int	Number of queries saved.
	*/
	public static function stat($num = 0)
	{
		global $vbulletin;

		self::$query_count += $num;

		if (!$vbulletin->options['vbo_online'] || !$vbulletin->options['vbo_stat'])
		{
			return false;
		}

		if (self::$cache == null)
		{
			return false;
		}

		$stats = self::$cache->get('vb.optimiser.stats');
		$stats = intval($stats) + $num;

		if ($num > 0)
		{
			self::$cache->set('vb.optimiser.stats', $stats);
		}
		else
		{
			self::$cache->set('vb.optimiser.stats', 0);
		}
	}

	/**
	* Updates statistical database from cache
	*/
	public static function updatestats()
	{
		global $vbulletin;

		if (!$vbulletin->options['vbo_online'] || !$vbulletin->options['vbo_stat'])
		{
			return false;
		}

		require_once(DIR . '/includes/functions_misc.php');

		$date = $vbulletin->db->escape_string(gmdate('M jS', time()));
		$current = $vbulletin->db->query_first("select queries from " . TABLE_PREFIX . "vboptimise where dateline='" . $date . "'");
		$current = intval($current['queries']);
		$add = intval(vb_optimise::$cache->get('vb.optimiser.stats'));
		self::stat(0);
		
		if ($add > 0)
		{
			$vbulletin->db->query("replace into " . TABLE_PREFIX . "vboptimise (dateline, queries) values ('$date', " . ($current + $add) . ")");
		}

		$total = $vbulletin->db->query_first("select sum(queries) as total from " . TABLE_PREFIX . "vboptimise");
		$total = intval($total['total']);

		build_datastore('vbo_resource_savings', $total);
		
		self::report('Added ' . $add . ' count to the statistics.');
	}

	/**
	* Determines if the output should be cached or if cache should be served
	*/
	public static function start_guestcache($startup = true)
	{
		global $vbulletin;

		eval(base64_decode('DQoJCWdsb2JhbCAkZm9vdGVyLCAkdmJwaHJhc2U7DQoJCSRzdGF0ID0gJy5cJzwhLS1WQk9DUi0tPlwnJzsNCgkJJGZsYWcgPSBleHBsb2RlKCc8YnIgLz4nLCBjbGFzc19leGlzdHMoJ3ZCX1RlbXBsYXRlX1J1bnRpbWUnKSA/IHZCX1RlbXBsYXRlX1J1bnRpbWU6OnBhcnNlUGhyYXNlKCdwb3dlcmVkX2J5X3ZidWxsZXRpbicpIDogJHZicGhyYXNlWydwb3dlcmVkX2J5X3ZidWxsZXRpbiddKTsNCgkJJGZsYWcgPSAkZmxhZ1sxXTsNCg0KCQlpZiAodHJpbSgkZm9vdGVyKSA9PSAnJyAmJiAkc3RhcnR1cCkNCgkJew0KCQkJJHZidWxsZXRpbi0+cGx1Z2lubGlzdFsncGFyc2VfdGVtcGxhdGVzJ10gLj0gIlxyXG52Yl9vcHRpbWlzZTo6c3RhcnRfZ3Vlc3RjYWNoZShmYWxzZSk7IjsNCg0KCQkJaWYgKG1ldGhvZF9leGlzdHModkJ1bGxldGluSG9vaywgJ2luaXQnKSkNCgkJCXsNCgkJCQl2QnVsbGV0aW5Ib29rOjppbml0KCktPnNldF9wbHVnaW5saXN0KCR2YnVsbGV0aW4tPnBsdWdpbmxpc3QpOw0KCQkJfQ0KCQkJZWxzZQ0KCQkJew0KCQkJCXZCdWxsZXRpbkhvb2s6OnNldF9wbHVnaW5saXN0KCR2YnVsbGV0aW4tPnBsdWdpbmxpc3QpOw0KCQkJfQ0KCQl9DQoNCgkJaWYgKCEkc3RhcnR1cCkNCgkJew0KCQkJJGZsYWcgPSAndkJfVGVtcGxhdGVfUnVudGltZTo6cGFyc2VQaHJhc2UoInBvd2VyZWRfYnlfdmJ1bGxldGluIiknOw0KDQoJCQlpZiAoc3RycG9zKCR2YnVsbGV0aW4tPnRlbXBsYXRlY2FjaGVbJ2Zvb3RlciddLCAkZmxhZykgIT09IGZhbHNlKQ0KCQkJew0KCQkJCSR2YnVsbGV0aW4tPnRlbXBsYXRlY2FjaGVbJ2Zvb3RlciddID0gc3RyX3JlcGxhY2UoJGZsYWcsICRmbGFnIC4gJHN0YXQsICR2YnVsbGV0aW4tPnRlbXBsYXRlY2FjaGVbJ2Zvb3RlciddKTsNCgkJCX0NCgkJCWVsc2UNCgkJCXsNCgkJCQkkc3RhdCA9ICc8IS0tVkJPQ1ItLT4nOw0KCQkJCSR2YnVsbGV0aW4tPnRlbXBsYXRlY2FjaGVbJ2Zvb3RlciddIC49ICJcclxuIiAuICckZmluYWxfcmVuZGVyZWQgLj0gXCc8ZGl2IGlkPSJmb290ZXJfY29weXJpZ2h0IiBjbGFzcz0ic2hhZGUgZm9vdGVyX2NvcHlyaWdodCI+JyAuICRzdGF0IC4gJzwvZGl2PlwnOyc7DQoJCQl9DQoJCX0NCgkJZWxzZQ0KCQl7DQoJCQkkc3RhdCA9ICc8IS0tVkJPQ1ItLT4nOw0KCQkJaWYgKHN0cnBvcygkZm9vdGVyLCAkZmxhZykgIT09IGZhbHNlKQ0KCQkJew0KCQkJCSRmb290ZXIgPSBzdHJfcmVwbGFjZSgkZmxhZywgJGZsYWcgLiAkc3RhdCwgJGZvb3Rlcik7DQoJCQl9DQoJCQllbHNlDQoJCQl7DQoJCQkJJGZvb3RlciAuPSAnPGRpdiBjbGFzcz0ic21hbGxmb250Ij4nIC4gJHN0YXQgLiAnPC9kaXY+JzsNCgkJCX0NCgkJfQ0KDQoJCWlmICghJHN0YXJ0dXApDQoJCXsNCgkJCXJldHVybiBmYWxzZTsNCgkJfQ0KCQk='));

		if (!self::check_cache('guests'))
		{
			return false;
		}

		$check_post = $_POST;
		unset($check_post['ajax']);

		if ($vbulletin->userinfo['userid'] < 1 && sizeof($check_post) < 1)
		{
			self::$guestcache = true;
		}

		if (self::$guestcache && $page = self::$cache->get('pgc.' . self::key_guestcache()))
		{
			if ($page !== false)
			{
				if (TIMENOW < $page['ttl'])
				{
					$saved = ($page['queries'] - $vbulletin->db->querycount);
					$php = vb_number_format(microtime(true) - self::timestart(), 5);

					if ($saved > 0)
					{
						self::stat($saved);
					}

					self::report('Displaying guest cached content (saved: ' . ($saved) . ', remaining ttl: ' . ($page['ttl'] - TIMENOW) . ' seconds).');

					if ($vbulletin->options['vbo_guest_comment'])
					{				
						$page['output'] = str_replace('</body>', '<!-- vB Optimise Guest Cached Page / Generated in ' . $php . ' seconds with ' . $vbulletin->db->querycount . ' queries and ' . $saved . ' queries saved vs uncached --></body>', $page['output']);
					}

					// Kill all plugins, they ran when we cached the page - don't repeat
					$vbulletin->pluginlist = array();
					if (method_exists(vBulletinHook, 'init'))
					{
						vBulletinHook::init()->set_pluginlist($vbulletin->pluginlist);
					}
					else
					{
						vBulletinHook::set_pluginlist($vbulletin->pluginlist);
					}

					self::display_stats($null, $saved, $page['queries'], vb_number_format($page['php'] - $php, 5), $page['php']);

					print_output($page['output']);
				}
			}
		}

		unset($check_post);

		if (self::$guestcache)
		{
			self::report('Guest caching started.');

			if ($vbulletin->debug) // stops duplication
			{
				$vbulletin->debug = false;
			}
		}
	}

	/**
	* Saves guest output
	*/
	public static function finish_guestcache(&$output)
	{
		global $vbulletin;

		if (self::$guestcache)
		{
			self::$cache->set('pgc.' . self::key_guestcache(), array(
				'output'	=> $output,
				'queries'	=> ($vbulletin->db->querycount + self::$query_count),
				'ttl'		=> TIMENOW + ($vbulletin->options['vbo_cache_guests'] * 60),
				'time'		=> TIMENOW,
				'php'		=> vb_number_format(microtime(true) - self::timestart(), 5),
			));
			self::report('Assigned page to guest cache');
		}

		if (defined('VBO_CMS_TEMPLATES') && class_exists('vB_Template') && isset(vB_Template::$template_usage))
		{
			$vbo_cached = explode('|', VBO_CMS_TEMPLATES);

			if (is_array($vbo_cached))
			{
				foreach (vB_Template::$template_usage as $name => $usage)
				{
					if (in_array($name, $vbo_cached))
					{
						self::stat(1);
					}
				}
			}
		}

		self::display_stats($output, self::$query_count, ($vbulletin->db->querycount + self::$query_count), 0, 0, true);
	}

	protected static function timestart()
	{
		if (count(explode(' ', TIMESTART)) > 1)
		{
			list($usec, $sec) = explode(' ', TIMESTART);
			return ((float)$usec + (float)$sec);
		}

		return TIMESTART;
	}

	protected static function saved($saved, $original)
	{
		return $saved > 0 ? vb_number_format($saved / ($original / 100), 2) : 0;
	}

	/**
	* Output statistics
	*/
	public static function display_stats(&$pageoutput, $mysql_saved = 0, $mysql_total = 0, $php_saved = 0, $php_total = 0, $now = false)
	{
		eval(base64_decode('DQoJCWdsb2JhbCAkdmJ1bGxldGluLCAkdmJwaHJhc2U7DQoJCXN0YXRpYyAkdmJvc3RhdHMgPSBmYWxzZTsNCg0KCQlpZiAoISR2YnVsbGV0aW4tPm9wdGlvbnNbJ3Zib19vbmxpbmUnXSkNCgkJew0KCQkJcmV0dXJuIGZhbHNlOw0KCQl9DQoNCgkJaWYgKHRyaW0oJHZidWxsZXRpbi0+b3B0aW9uc1sndmJvX2JyYW5kaW5nX2ZyZWUnXSkgIT0gJycpDQoJCXsNCgkJCWlmICgkdmJ1bGxldGluLT5vcHRpb25zWyd2Ym9fYnJhbmRpbmdfZnJlZSddID09ICcxZmVmODgzMTI0NGM1ZWNhYjFkZGI4YWFlYzY5ZWExYycpDQoJCQl7DQoJCQkJcmV0dXJuIGZhbHNlOw0KCQkJfQ0KCQl9DQoNCgkJaWYgKCEkdmJvc3RhdHMgJiYgISRub3cpDQoJCXsNCgkJCSR2Ym9zdGF0cyA9IHRydWU7DQoNCgkJCSR2YnVsbGV0aW4tPnBsdWdpbmxpc3RbJ2dsb2JhbF9jb21wbGV0ZSddIC49ICJcclxuXHJcbnZiX29wdGltaXNlOjpkaXNwbGF5X3N0YXRzKFwkb3V0cHV0LCAkbXlzcWxfc2F2ZWQsICRteXNxbF90b3RhbCwgJHBocF9zYXZlZCwgJHBocF90b3RhbCk7IjsNCg0KCQkJaWYgKG1ldGhvZF9leGlzdHModkJ1bGxldGluSG9vaywgJ2luaXQnKSkNCgkJCXsNCgkJCQl2QnVsbGV0aW5Ib29rOjppbml0KCktPnNldF9wbHVnaW5saXN0KCR2YnVsbGV0aW4tPnBsdWdpbmxpc3QpOw0KCQkJfQ0KCQkJZWxzZQ0KCQkJew0KCQkJCXZCdWxsZXRpbkhvb2s6OnNldF9wbHVnaW5saXN0KCR2YnVsbGV0aW4tPnBsdWdpbmxpc3QpOw0KCQkJfQ0KDQoJCQlyZXR1cm4gZmFsc2U7DQoJCX0NCg0KCQkkZmxhZyA9ICc8IS0tVkJPQ1ItLT4nOw0KCQkkc3RhdCA9ICd2QnVsbGV0aW4gT3B0aW1pc2F0aW9uIGJ5IHZCIE9wdGltaXNlICg8IS0tVkJPX1NBVkVELS0+KS4nOw0KDQoJCWlmIChzdHJwb3MoJHBhZ2VvdXRwdXQsICRmbGFnKSAhPT0gZmFsc2UpDQoJCXsNCgkJCSRwYWdlb3V0cHV0ID0gc3RyX3JlcGxhY2UoJGZsYWcsICRmbGFnIC4gJzxiciAvPicgLiAkc3RhdCwgJHBhZ2VvdXRwdXQpOw0KCQl9DQoNCgkJaWYgKCR2YnVsbGV0aW4tPm9wdGlvbnNbJ3Zib19mb290ZXJfaW5mbyddKQ0KCQl7DQoJCQkkcGFnZW91dHB1dCA9IHN0cl9yZXBsYWNlKCcgLyBQSFAgMCUnLCAnJywgc3RyX3JlcGxhY2UoJzwhLS1WQk9fU0FWRUQtLT4nLCAnUmVkdWNlZCBvbiB0aGlzIHBhZ2U6IE15U1FMICcgLiBzZWxmOjpzYXZlZCgkbXlzcWxfc2F2ZWQsICRteXNxbF90b3RhbCkgLiAnJSAvIFBIUCAnIC4gc2VsZjo6c2F2ZWQoJHBocF9zYXZlZCwgJHBocF90b3RhbCkgLiAnJScsICRwYWdlb3V0cHV0KSk7DQoJCX0NCgkJZWxzZQ0KCQl7DQoJCQkkcGFnZW91dHB1dCA9IHN0cl9yZXBsYWNlKCcgKDwhLS1WQk9fU0FWRUQtLT4pJywgJycsICRwYWdlb3V0cHV0KTsNCgkJfQ0KCQk='));
	}

	/**
	* Generates a unique key to identify the page
	*/
	private static function key_guestcache()
	{
		global $vbulletin;
		static $key;

		if (!$key)
		{
			$key = md5(implode('', @array_merge(array(
				THIS_SCRIPT,
				$_COOKIE[COOKIE_PREFIX . 'userstyleid'],
				$_COOKIE[COOKIE_PREFIX . 'languageid'],
				$vbulletin->options['styleid'],
			), $_REQUEST)));
		}

		return $key;
	}
}
?>