/****
 * vB Optimise
 * Copyright 2010; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

_vBOptimise = function()
{
	// ###################################################
	// SCRIPT VARIABLES
	this.tests = new Array();
	this.test = -1;

	// ###################################################
	// PUSH LOADER METHOD
	this.push_loader = function(percent)
	{
		fetch_object('vbo_completed').style.width = percent + '%';
	}

	// ###################################################
	// INSERT CHART METHOD
	this.insert_chart = function(url, pass)
	{
		if (deconcept.SWFObjectUtil.getPlayerVersion().major >= 9)
		{
			vBOChart = new SWFObject(url + '/vboptimise/swf/vboptimise.swf?rev=1.1', 'vbo_chart_obj', '100%', '400', '9');
			vBOChart.addParam('menu', 'false');
			vBOChart.addParam('wmode', 'transparent');
			vBOChart.write('vbo_chart');

			this.update_chart(url + '/vboptimise.php?pass=' + pass + '&nocache=' + (Math.random() * 9999));
		}
		else
		{
			alert('You will need to install Flash Player to view this page.');
		}
	}

	// ###################################################
	// UPDATE CHART METHOD
	this.update_chart = function(url)
	{
		try
		{
			fetch_object('vbo_chart_obj').request_chart(url);
		}
		catch (e)
		{
			setTimeout("vBOptimise.update_chart('" + url + "');", 100);
		}
	}

	// ###################################################
	// RUN TEST METHOD
	this.run_test = function()
	{
		this.test++;

		if (typeof this.tests[this.test] == 'undefined')
		{
			this.completed();
			return false;
		}

		YAHOO.util.Connect.asyncRequest('POST', 'vboptimise.php', {
			success: this.ran_test,
			failure: this.test_error,
			timeout: vB_Default_Timeout,
			scope: this
		}, 'adminhash=' + ADMINHASH + '&securitytoken=' + SECURITYTOKEN + '&do=test&act=' + this.tests[this.test]);
	}

	// ###################################################
	// RAN TEST METHOD
	this.ran_test = function(ajax)
	{
		var failed = true;

		var xml_result = ajax.responseXML.getElementsByTagName('result');
		var xml_message = ajax.responseXML.getElementsByTagName('message');

		if (ajax.responseXML && xml_result.length > 0)
		{
			var result = xml_result[0].firstChild.nodeValue;
			var message = 'Test completed successfully'; // Should phrase this for future releases

			if (xml_message.length > 0)
			{
				message = xml_message[0].firstChild.nodeValue;
			}

			if (result == 'OK')
			{
				failed = false;
			}
		}

		fetch_object('vbo_' + this.tests[this.test]).getElementsByTagName('img')[0].src = '../vboptimise/images/vboptimise_' + (failed ? 'bad' : 'good') + '.png';

		if (message != '')
		{
			var insert_message = fetch_object('vbo_' + this.tests[this.test]).appendChild(document.createElement('span'));
			insert_message.className = 'smallfont';
			insert_message.appendChild(document.createTextNode('   ' + message));
		}

		this.run_test();
	}

	// ###################################################
	// AJAX ERROR
	this.test_error = function(ajax)
	{
		// Should not occur on pre-defined AJAX calls, but here it is for sanity
		alert('AJAX Failure\n\n' + ajax.statusText);
	}

	// ###################################################
	// COMPLETED METHOD
	this.completed = function()
	{
		// no need to do anything here really
	}
}

vBOptimise = new _vBOptimise();