<?php
/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *--------------------------------------------------------------------
 * vB Optimise Pro
 * Copyright 2010, Deceptor / DragonByte Technologies
 * All Rights Reserved
 *--------------------------------------------------------------------
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

/****
 * vB Optimise
 * Copyright 2010; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
class vb_optimise_db
{
	protected $dbobject = null;
	protected $cache = array();

	public function __construct($cache = array())
	{
		global $vbulletin;

		$this->dbobject = $vbulletin->db;
		$this->cache = $cache;
	}

	protected function restore()
	{
		global $vbulletin, $db;

		$vbulletin->db = $db = $this->dbobject;
		unset($this);
	}

	/**
	* Methods to execute a query
	* * * * * * * * * * * * * * * * * * * * * *
	*/
	public function query_read($sql = '')
	{
		return $this->query($sql);
	}

	public function query_read_slave($sql = '')
	{
		return $this->query($sql);
	}

	public function query_first_slave($sql)
	{
		$this->restore();
		return $this->query($sql);
	}

	public function query($sql = '')
	{
		return $this->cache;
	}

	/**
	* Methods to retrieve results
	* * * * * * * * * * * * * * * * * * * * * *
	*/

	public function fetch_array(&$cache)
	{
		global $vbulletin;

		if (is_array($cache))
		{
			$item = array_shift($cache);

			if (is_null($item))
			{
				$this->restore();
				return false;
			}

			return $item;
		}
		else
		{
			$this->restore();
			return $cache;
		}
	}
}