<?php
/*======================================================================*\
|| #################################################################### ||
|| # Helpful Answers Rating Script version 1.5.1
|| # Addon Copyright Ted Sindzinski
|| # Developed exclusively for vBulletin 3.7 and 3.8 
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2006 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'helpfulanswer');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('user', 'postbit');

// get special data templates from the datastore
$specialtemplates = array(
);

// pre-cache templates used by all actions
$globaltemplates = array(
'helpful_answers',
'helpful_answers_top',
'helpful_answers_top_bit'
);

// pre-cache templates used by specific actions
$actiontemplates = array(	
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// default action
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'topanswers';
}

// #############################################################################
// Show a list of the top rated threads
if ($_REQUEST['do'] == 'topanswers')
{

	if(!$vbulletin->options['helpans_top']){
		eval(standard_error(fetch_error('helpfulanswer_notop')));
	}

	if(!$vbulletin->options['helpans_limit']){
		$helpans_limit = 25;
	} else {
		$helpans_limit = intval($vbulletin->options['helpans_limit']);
	}

	if(!$vbulletin->options['helpans_stats_ten']){
		$helpful_orderby = "ORDER BY goodrank DESC";
		$helpful_bit_template = 'helpful_answers_top_bit';
	} else {
		$helpful_selectby = ',(goodrank/totalrank) as avgrank';
		$helpful_orderby = "ORDER BY avgrank DESC";
		$helpful_bit_template = 'helpful_answers_topten_bit';
	}

	// pretty simple page, just grab the top X posts
	$helpfulanswers = $db->query_read_slave("
		SELECT postid,post.title as posttile,post.goodrank,post.totalrank,thread.threadid,thread.title as title $helpful_selectby
		FROM " . TABLE_PREFIX . "post as post
		INNER JOIN " . TABLE_PREFIX . "thread AS thread ON(post.threadid = thread.threadid)
		WHERE goodrank > 0
		$helpful_orderby
		LIMIT 0,$helpans_limit
	");	
	while ($helpfulanswer = $db->fetch_array($helpfulanswers))
	{		
		$helpfulanswer['avgrank'] = number_format($helpfulanswer['avgrank'], 1, '.', ' ');
		$helpfulanswer['goodpercent'] = $helpfulanswer['goodrank'] / $helpfulanswer['totalrank'] * 100;
		$helpfulanswer['goodpercent'] = number_format($helpfulanswer['goodpercent'], 0);
		eval('$resultsbits .= "' . fetch_template($helpful_bit_template) . '";');
	}
	
	// build navbar
	$navbits = array('' => 'Most Helpful Answers');

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('helpful_answers_top') . '");');

}

// #############################################################################
// Process rating request with AJAX or normally
if ($_REQUEST['do'] == 'helpfulanswer' OR $_REQUEST['do'] == 'rate')
{
	
	$vbulletin->input->clean_array_gpc('r', array(
		'postid' 				=> TYPE_UINT,
		'rank' 					=> TYPE_UINT,
		'using_ajax'    => TYPE_UINT,
		'securitytoken' => TYPE_STR
	));
	
	$using_ajax = $vbulletin->GPC['using_ajax'];
	$securitytoken = $vbulletin->GPC['securitytoken'];
	$safeuserid = $vbulletin->userinfo['userid'];
	$saferank = $vbulletin->GPC['rank'];
	
	$foruminfo = fetch_foruminfo($threadinfo['forumid'], false);	
	
	// check if they selected a post
	if(!$vbulletin->GPC['postid']){
		$using_ajax ? exit : eval(standard_error(fetch_error('helpfulanswer_nopost', $vbphrase['post'], $vbulletin->options['contactuslink'])));
	}
	
	// check about the post
	if (!$postinfo['postid'] OR $postinfo['isdeleted'] OR (!$postinfo['visible'] AND !can_moderate($threadinfo['forumid'], 'canmoderateposts')))
	{
		$using_ajax ? exit : eval(standard_error(fetch_error('invalidid', $vbphrase['post'], $vbulletin->options['contactuslink'])));
	}
	
	// check about the thread
	if (!$threadinfo['threadid'] OR $threadinfo['isdeleted'] OR (!$threadinfo['visible'] AND !can_moderate($threadinfo['forumid'], 'canmoderateposts')))
	{
		$using_ajax ? exit : eval(standard_error(fetch_error('invalidid', $vbphrase['thread'], $vbulletin->options['contactuslink'])));
	}
		
	// check if forum allows helpfulanswers
	if(!$foruminfo['helpfulanswerbits'])
	{
		$using_ajax ? exit : eval(standard_error(fetch_error('helpfulanswer_notenabled', $vbphrase['post'], $vbulletin->options['contactuslink'])));
	}
	
	// check that they aren't trying to give a rank over 10
	if ($vbulletin->GPC['rank'] > 10)
	{
		$using_ajax ? exit : eval(standard_error(fetch_error('invalidid', $vbphrase['post'], $vbulletin->options['contactuslink']))); // fake error, they know what's up
	}
	
	// check if they have enough posts
	if($vbulletin->options['helpans_min'] AND $vbulletin->userinfo['posts'] < $vbulletin->options['helpans_minnum']){
		if($using_ajax){ 
			$helpful_answers_error = construct_phrase($vbphrase['helpfulanswer_toofew'],$vbulletin->options['helpans_minnum'],$vbulletin->userinfo['posts']);
			eval('print_output("' . fetch_template('helpful_answers_error') . '");'); 
			exit;
		} else { eval(standard_error(fetch_error('helpfulanswer_toofew',$vbulletin->options['helpans_minnum'],$vbulletin->userinfo['posts'])));}
	}
	
	// check that this isn't their post
	if (!$vbulletin->options['helpans_self'] AND $postinfo['userid'] == $vbulletin->userinfo['userid'])
	{
		if($using_ajax){ 
			$helpful_answers_error = $vbphrase['helpfulanswer_yourpost'];
			eval('print_output("' . fetch_template('helpful_answers_error') . '");'); 
			exit;
		} else { eval(standard_error(fetch_error('helpfulanswer_yourpost'))); }
	}	
		
	// check if the user has already rated the post
	$helpfulanswer = $db->query_first_slave("
		SELECT COUNT(helpfulanswerid) as count FROM " . TABLE_PREFIX . "helpfulanswer
		WHERE userid = $safeuserid AND postid = $postinfo[postid]
	");
	$count = $helpfulanswer['count'];
	
	if($count)
	{
		if($using_ajax){ 
			$helpful_answers_error = $vbphrase['helpfulanswer_alreadyset'];
			eval('print_output("' . fetch_template('helpful_answers_error') . '");'); 
			exit;
		} else { eval(standard_error(fetch_error('helpfulanswer_alreadyset'))); }
	}
	
	($hook = vBulletinHook::fetch_hook('helpfulanswers_prerate')) ? eval($hook) : false;
	
	// add the vote to the db log
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "helpfulanswer
		SET postid = $postinfo[postid], userid = $safeuserid, yesno = '$saferank', dateline = ". TIMENOW ."
	");	
	
	// figure out how to update the table
	// start by looking for a rank AND the 10 point scale
	if($vbulletin->options['helpans_rank_ten']){		
		$update_query = ", goodrank = goodrank + ". intval($vbulletin->GPC['rank']);			
		if($vbulletin->GPC['rank'] > 5){
			$helpful = 1;
		} else {
			$helpful = 0;
		}
	// no scale, now just look for a rank (good)
	} else if($vbulletin->GPC['rank']){
		$update_query = ", goodrank = goodrank + 1";
		$helpful = 1;
	// nada, it must be bad
	} else {
		$helpful = 0;
	}
	
	// update the post with the vote total
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "post
		SET totalrank = totalrank + 1
			$update_query
		WHERE postid = $postinfo[postid]
	");
		
	($hook = vBulletinHook::fetch_hook('helpfulanswers_dorate')) ? eval($hook) : false;
	
	// annon. tracking option loaded only if enabled AND cURL is installed
	if(extension_loaded('curl') AND $vbulletin->options['helpans_report']){
	
		// yay, we're on. THANK YOU for keeping this feature enabled
	
		// build the url to call up for tracking
		$tracksitename = strip_tags($_SERVER['SERVER_NAME']);
		$trackurl = "http://www.moderninsider.com/helpfulratings.php?do=rate&site=". $tracksitename ."&helpful=". $helpful;
				
		$curlHandle = curl_init();
		curl_setopt($curlHandle, CURLOPT_URL, $trackurl); 
		curl_setopt($curlHandle, CURLOPT_HEADER, 0); // this is annon. no headers should be sent
		curl_setopt($curlHandle, CURLOPT_TIMEOUT, 5); // wait 5 seconds for response	
		curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, 1); // dont show the page
		curl_setopt($curlHandle, CURLOPT_FAILONERROR, 1); // dont show errors
		curl_setopt($curlHandle, CURLOPT_MUTE, 1); // dont show output		
		$content = curl_exec($curlHandle); // make the connection
		curl_close($curlHandle); // close it all down
		
	}
	
	// ratings are posted, time to return the user to the thread
	if ($using_ajax)
	{		
		
		($hook = vBulletinHook::fetch_hook('helpfulanswers_show_ajax')) ? eval($hook) : false;
		
		// we're using ajax so get all the data to update the ratings bit
		$helpfulanswer = $db->query_first_slave("
			SELECT post.goodrank, post.totalrank
			FROM " . TABLE_PREFIX . "post AS post
      WHERE post.postid = $postinfo[postid]
    ");
		
		if($vbulletin->options['helpans_rank_ten']){
			
			$post['helpfulanswerid'] = 1; // they've rated it, duh
			$show['helpfulanswer'] = true; // yes they can see helpful answers on this post
			$show['rate_helpfulanswer'] = false; // no they can't rate this again
			$show['helpfulvoted'] = true;
			$post['avgrank'] = $helpfulanswer['goodrank'] / $helpfulanswer['totalrank']; // figure out the average vote on 10pts
			$post['avgrank'] = number_format($post['avgrank'], 1, '.', ' ');
			$post['totalvotes'] = $helpfulanswer['totalrank']; // figure out the number of votes
			$post['totalrank'] = $helpfulanswer['goodrank']; // figure out the total good points
			
			eval('$helpful_answers = "' . fetch_template('helpful_answers_ten') . '";'); // fetch the template		
			echo $helpful_answers; // print it back
			exit;
			
		} else {
			
			$post['totalrank'] = $helpfulanswer['totalrank']; // total rankings count
			$post['goodrank'] = $helpfulanswer['goodrank']; // good rankings count
			$post['badrank'] = $helpfulanswer['totalrank'] - $helpfulanswer['goodrank']; // bad rankings count
			$post['helpfulanswerid'] = 1; // they've rated it, duh
			$show['helpfulanswer'] = true; // yes they can see helpful answers on this post
			$show['rate_helpfulanswer'] = false; // no they can't rate this again
			$show['helpfulvoted'] = true;
			
			eval('$helpful_answers = "' . fetch_template('helpful_answers') . '";'); // fetch the template		
			echo $helpful_answers; // print it back
			exit;
			
		}
		
	} else {
		
		// we're not using ajax (boo) so just redirect em
		$vbulletin->url = "showthread.php?t=".$postinfo['threadid'];
		eval(print_standard_redirect('redirect_helpfulanswer_done'));
		
	}
	
}


/*======================================================================*\
|| ####################################################################
|| # Downloaded: 15:36, Sat Dec 16th 2006
|| # CVS: $RCSfile$ - $Revision: 15732 $
|| ####################################################################
\*======================================================================*/
?>