<?php
/**
 * @author        Uoc Nguyen (uocnb@joomsolutions.com)
 * @version       1.0
 * @package       ja
 * @subpackage    jaupdater\core\helper
 * @copyright     Copyright (C) 2009. All rights reserved.
 * @license       GNU/GPL
 */

// no direct access
defined( '_JA' ) or die( 'Restricted access' );

/**
 * Helper for archive action: compress, uncompress
 *
 * @author Uoc Nguyen
 */
class ArchiveHelper {

	/**
   *  Compress file as zip using pclzip library (thanhnv - use other lib now :D)
   *
   * @param $zipFile  string path to store zip file
   * @param $path {string | array()} path to file or directory to zip
   * @param $rmPath  boolean do not add full path to archive
   *
   * @return  boolean true if success, false if failure
   */
	function zip($zipFile, $path, $rmPath = false) {
		$oZip = new CreateZipFile();
		
		if (!is_array($path)) {
			$paths[] = $path;
		} else {
			$paths = $path;
		}
		foreach ($paths as $path) {
			if(is_file($path)) {
				$oZip->addDirectory($outputDir);
				$fileContents=file_get_contents($path);
				$oZip->addFile($fileContents, basename($path));
			} elseif (is_dir($path)) {
				$outputDir = str_replace(array(dirname($path), DS, '/'), '', $path) . DS;
				$oZip->zipDirectory($path, $outputDir);
			}
		}
		
		$fp = fopen($zipFile, "wb");
		$out = fwrite($fp, $oZip->getZippedfile());
		fclose($fp);
		
		return $out;
	}

	/**
   * Uncompress zip file using pclzip library
   *
   * @param $zipFile  string path to zip file
   * @param $extractPath  string path to location which will be extract to
   *
   * @return  boolean true if success, false if failure
   */
	function unZip($zipFile, $extractPath) {
		$pcl = new PclZip($zipFile);
		if(empty($pcl)) {
			return false;
		}
		$retVal = $pcl->extract(PCLZIP_OPT_PATH, $extractPath);
		$pcl->privCloseFd();
		return $retVal;
	}
}