<?php
/**
 * @author        Uoc Nguyen (uocnb@joomsolutions.com)
 * @version       1.0
 * @package       ja
 * @subpackage    jaupdater\core
 * @copyright     Copyright (C) 2009. All rights reserved.
 * @license       GNU/GPL
 */

// no direct access
defined( '_JA' ) or die( 'Restricted access' );

/**
 * This class will be use for store configuration for both client and service module
 *
 * @author Uoc Nguyen
 */
class UpdaterConfig {
  var $id = 0;

  /**
   *
   * @var Hash table to store configuration
   */
  var $configHash = array();

  function UpdaterConfig($configs = array()) {
    $this->id = rand();
    $this->apply($configs);
  }

  /**
   *  Use for batch config apply
   *
   * @param $configs
   */
  function apply($configs = array()) {
    foreach ($configs as $key=>$value) {
      $this->set($key, $value);
    }
  }

  /**
   *
   * @param $key
   * @param $value
   *
   * @return  boolean true if success, otherwise return false
   */
  function set($key, $value) {
    if (!empty($key)) {
      $this->configHash[$key] = $value;
      return true;
    }
    return false;
  }

  /**
   *
   * @param $key
   *
   * @return  mixed if option is not exists return null
   */
  function get($key) {
    if (array_key_exists($key, $this->configHash)) {
      return $this->configHash[$key];
    }
    return null;
  }

  /**
   *
   * @param $config  UpdaterConfig
   *
   * @return  boolean true if success, otherwise false is returned
   */
  function merge($config) {
    if (!empty($config) &&
        is_object($config)) {
      $this->configHash = array_merge($this->configHash, $config->configHash);
    }
  }

  /**
   *
   * @param $key
   *
   * @return  boolean true if config exists, otherwise return false
   */
  function remove($key) {
    if (array_key_exists($key, $this->configHash)) {
      unset($this->configHash[$key]);
      return true;
    }
    return false;
  }
}