<?php
/**
 * @author        Uoc Nguyen (uocnb@joomsolutions.com)
 * @version       1.0
 * @package       ja
 * @subpackage    jaupdater
 * @copyright     Copyright (C) 2009. All rights reserved.
 * @license       GNU/GPL
 */

// no direct access
defined( '_JA' ) or die( 'Restricted access' );

// This file will hold configuration for UpdaterClient
global $config;

$jConfig = new JConfig();
$params = &JComponentHelper::getParams( JACOMPONENT );

$data_folder = jaucGetDataFolder($params->get("DATA_FOLDER", "jaextmanager_data"));

define('JA_WORKING_DATA_FOLDER', $data_folder);

function jaucGetDataFolder($path) {
	$path = FileSystemHelper::clean($path . DS);
	$rootPath = FileSystemHelper::clean($_SERVER['DOCUMENT_ROOT']);
	return (strpos($path, $rootPath) === 0) ? $path : JPATH_ROOT . DS . $path;
}
//validate settings
function jaucValidServiceSettings($params) {
	$errMsg = "";
	if(!is_dir(JA_WORKING_DATA_FOLDER)) {
		if(!mkdir(JA_WORKING_DATA_FOLDER, 0777)) {
			$errMsg .= JText::_("JA Updater can not create below folder automatically. Please manual create and chmod it to wriable!") . "<br />";
			$errMsg .= "<i>".JA_WORKING_DATA_FOLDER."</i>";
		}
	} elseif(!is_writeable(JA_WORKING_DATA_FOLDER)) {
		if(!chmod(JA_WORKING_DATA_FOLDER, 0777)) {
			$errMsg .= JText::_("JA Updater can not automatically chmod for below folder to wriable. Please manual chmod it to wriable!") . "<br />";
			$errMsg .= "<i>".JA_WORKING_DATA_FOLDER."</i>";
		}
	} else {
		$fileAccess = JA_WORKING_DATA_FOLDER . ".htaccess";
		if(!is_file($fileAccess)) {
			$fp = fopen($fileAccess, 'wb');
			fwrite($fp, "Order deny,allow\r\nDeny from all");
			fclose($fp);
		}
	}
	if ( substr(PHP_OS,0,3) == 'WIN') {
		if(!is_dir(dirname($params->get("MYSQL_PATH")))) {
			$errMsg .= JText::_("Path to mysql CLI is not correct!") . "<br />";
		}
		if(!is_dir(dirname($params->get("MYSQLDUMP_PATH")))) {
			$errMsg .= JText::_("Path to mysql dump CLI is not correct!") . "<br />";
		}
	}
	/*if($errMsg != "") {
		$errMsg .= "<a href=\"index.php?option=".JACOMPONENT."&view=default&layout=config_service\" title=\"\">".JText::_('Click here to edit settings')."</a>";
		JError::raiseWarning(100, $errMsg);
	}*/
}
//option=com_jauc&view=default&layout=config_service
if(!(JRequest::getVar('option') == JACOMPONENT && JRequest::getVar('view') == 'default' && JRequest::getVar('layout') == 'config_service')) {
	jaucValidServiceSettings($params);
}
// Component config

$config = new UpdaterConfig(
		array(
			// Define the web service URI
			"WORKING_MODE"	=> $params->get("WORKING_MODE", "server"),
			"WS_URI"	=> $params->get("WS_URI", "http://dev.joomlart.com/jaupdater/service/"),
			//root path to installed product (is root path of website)
			//it is different from the concept of repo path on server
			"REPO_PATH" => JPATH_ROOT . DS,
			// MySQL info
			"MYSQL_HOST" 	=> $jConfig->host,
			"MYSQL_USER" 	=> $jConfig->user,
			"MYSQL_PASS" 	=> $jConfig->password,
			"MYSQL_DB" 		=> $jConfig->db,
			"MYSQL_DB_PREFIX" 	=> $jConfig->dbprefix,
			// Using for backup database
			"MYSQL_PATH" 		=> $params->get("MYSQL_PATH"),
			"MYSQLDUMP_PATH" 	=> $params->get("MYSQLDUMP_PATH")
		)
	);

ini_set('xdebug.max_nesting_level', 100);
ini_set('xdebug.var_display_max_depth', 100);
