<?php
/**
 * @author        Uoc Nguyen (uocnb@joomsolutions.com)
 * @version       1.0
 * @package       ja
 * @subpackage    jaupdater\client
 * @copyright     Copyright (C) 2009. All rights reserved.
 * @license       GNU/GPL
 */

// no direct access
//defined ( '_JEXEC' ) or die ( 'Restricted access' );
if(!defined('_JA'))
	define("_JA", "JoomlArt Enterprise");
define("_JA_ROOT", realpath(dirname(__FILE__)));

require_once(_JA_ROOT.DS."jaupdater".DS."JAUpdater.php");

if(defined('_JEXEC')) {
	include_once(_JA_ROOT . DS . "config_joomla.php");
} else {
	include_once(_JA_ROOT . DS . "config.php");
}

/**
 * Description
 *
 * @author JoomlArt
 */
class UpdaterClient {

	var $config, $lastAction;

	function UpdaterClient() {
		global $config;

		$this->config = new UpdaterConfig();

		if (!empty($config)) {
			$this->config->merge($config);
		}
	}
	
	function isLocalMode() {
		//only run on local mode on beta version
		//let wait for service mode on next release :)
		return 1;
		//return ($this->config->get("WORKING_MODE") == 'local') ? 1 : 0;
	}

	function invokeService($message) {
		$messageData = "json=".json_encode($message);
		$result = NetworkHelper::doPOST($this->config->get("WS_URI"), $messageData);
		$result = $this->getJsonObject($result);
		/*if (!empty($result->error)) {
			throw new Exception('Invoking service ['.$message->content->service.'] error '.$result->error);
		}*/
		return $result;
	}

	/**
   * Build service message
   *
   * @param $from string identify of this host
   * @param $to string name of web service
   * @param $content object service call and arguments
   *
   * @return Message
   */
	function buildMessage($content, $from = null, $to = null) {
		$from = empty($from) ? $_SERVER["REMOTE_ADDR"] : $from;
		$to = empty($to) ? "JAUpdater Web Service" : $to;
		return (new Message($content, $from, $to));
	}

	/**
   *
   * @param $data string json string
   *
   * @return object
   */
	function getJsonObject($data) {
		$result = json_decode($data["content"]);
		if (!empty($result) && !empty($result->content)) {
			return $result->content;
		} else {
			//echo $data["content"];
			return false;
			//throw new Exception("Invalid JSON data");
		}
	}
	
	function getListProducts($refresh = 0) {
		//cache client
		$dataDir = FileSystemHelper::clean(JA_WORKING_DATA_FOLDER);
		
		$productsFile = $dataDir . "jaupdater.products.json";
		$productList = null;
		if(file_exists($productsFile) && !$refresh) {
			$updateTime = filectime($productsFile);
			$currentTime = time();
			$cacheTimelife = 3 * 24 * 60 * 60; //3 days
			if($updateTime + $cacheTimelife > $currentTime) {
				$productList = json_decode(file_get_contents($productsFile));
			}
		}
		
		if(empty($productList)) {
			$content["service"] = "listProducts";
			$content["args"]["refresh"] = $refresh;
			
			$result = $this->invokeService($this->buildMessage($content));
			if (!empty($result->error)) {
				return false;
			} else {
				$productList = $result->response;
				//update cache
				$fp = fopen($productsFile, 'wb');
				fwrite($fp, json_encode($productList));
				fclose($fp);
			}
		}
		return $productList;
	}
	
	function getNewerVersions($product) {
		if($this->isLocalMode()) {
			return $this->getNewerVersionsLocal($product);
		}
		
		$content["service"] = "getNewerVersions";
		$pro = new jaProducts($product, $this->config);
		// Remove some unneeded information
		$content["args"]["product"] = $pro->getInfo();
		
		$result = $this->invokeService($this->buildMessage($content));
		if (!empty($result->error)) {
			return false;
		} else {
			return $result->response;
		}
	}
	/**
	 * @return same result with getNewerVersions but getting information from local repo
	 */
	function getNewerVersionsLocal($product) {
		if(!($productDir = $this->getLocalVersionsPath($product))) {
			return false;
		}
		
		if(!is_dir($productDir)) {
			return false;
		} else {
			$obj = new stdClass();
			$handle = opendir($productDir);
			
			$pro = new jaProducts($product, $this->config);
			while (($entry = readdir($handle)) !== false) {
				if(is_dir($productDir . $entry . DS) && $entry != '.' && $entry != '..') {
					$result = $this->isNewerVersion($entry, $product->version);
					if($result) {
						$aVersions = $pro->_parseListVersions($productDir . $entry . DS . basename($pro->configFile));
						
						$ver = new stdClass();
						$ver->type = $product->type;
						$ver->name = $product->name;
						$ver->extKey = $product->extKey;
						$ver->version = $entry;
						if($result == 2) {
							$ver->notSure = 1;
						}
						
						if(isset($aVersions[$entry]) && isset($aVersions[$entry]['changelogUrl'])) {
							$ver->changelogUrl = $aVersions[$entry]['changelogUrl'];
						}
						
						$obj->$entry = $ver;
					}
				}
			}
			closedir($handle);
			
			return $obj;
		}
	}

	function buildDiff($product, $newVersion) {
		if($this->isLocalMode()) {
			return $this->buildDiffLocal($product, $newVersion);
		}
		$pro = new jaProducts($product, $this->config);
		
		$content["service"] = "buildDiff";
		$content["args"]["product"] = $pro->getInfo();
		$content["args"]["newVersion"] = $newVersion;
		
		$result = $this->invokeService($this->buildMessage($content));
		if (!empty($result->error)) {
			return false;
		} else {
			return $result->response;
		}
	}
	
	/**
	 * @return same result with buildDiff but getting information from local repo
	 */

	function buildDiffLocal($product, $newVersion) {
		if(!($productDir = $this->getLocalVersionsPath($product))) {
			return false;
		}
		//
		$newVerDir = $productDir . $newVersion . DS;
		if(!is_dir($newVerDir)) {
			return false;
		}
		$vUpgrade = new stdClass();
		$vUpgrade->crc = $this->getVersionChecksum($newVerDir);
		//
		$orgVerDir = $productDir . $product->version . DS;
		if(is_dir($orgVerDir)) {
			$vServer = new stdClass();
			$vServer->crc = $this->getVersionChecksum($orgVerDir);
		}
		//
		$pro = new jaProducts($product, $this->config);
		$oldPro = $pro->getInfo();
		//
		$compare = new jaCompareTool();
		if(isset($vServer)) {
			return $compare->checkToUpgrade($oldPro, $vServer, $vUpgrade);
		} else {
			return $compare->checkToBuildUpgradePackage($oldPro, $vUpgrade);
		}
	}
	

	/**
	 * display diff view for update.joomlart.com
	 *
	 * @param unknown_type $extKey
	 * @param unknown_type $ver1
	 * @param unknown_type $ver2
	 * @return unknown
	 */
	function buildDiff2($uniqueKey, $version1, $version2) {
		
		$content["service"] = "buildDiff2";
		$content["args"]["uniqueKey"] = $uniqueKey;
		$content["args"]["version1"] = $version1;
		$content["args"]["version2"] = $version2;
		
		
		$result = $this->invokeService($this->buildMessage($content));
		if (!empty($result->error)) {
			return false;
		} else {
			return $result->response;
		}
	}

	/**
	 * with product get from local
	 *
	 * @param unknown_type $product
	 * @param unknown_type $logVersion
	 * @return unknown
	 */
	function getChangeLog($product, $logVersion) {
		if($this->isLocalMode()) {
			$changelog = $this->getChangeLogLocal($product, $logVersion);
			if($changelog !== false) {
				return $changelog;
			}
		}
		
		$pro = new jaProducts($product, $this->config);

		$content["service"] = "getChangeLog";
		$content["args"]["product"] = $pro->getInfo();
		$content["args"]["logVersion"] = $logVersion;

		$result = $this->invokeService($this->buildMessage($content));
		if (!empty($result->error)) {
			return false;
		} else {
			return $result->response;
		}
	}
	
	
	/**
	 * @return same result with buildDiff but getting information from local repo
	 */
	function getChangeLogLocal($product, $logVersion) {
		if(!($productDir = $this->getLocalVersionsPath($product))) {
			return false;
		}
		
		$logFile = $productDir . $logVersion . DS . "change_log.log";
		if(is_file($logFile)) {
			return file_get_contents($logFile);
		} else {
			return false;
		}
	}

	/**
	 * with product get from server
	 *
	 * @param unknown_type $product
	 * @param unknown_type $logVersion
	 * @return unknown
	 */
	function getChangeLog2($product, $logVersion) {
		$content["service"] = "getChangeLog";
		$content["args"]["product"] = $product;
		$content["args"]["logVersion"] = $logVersion;

		$result = $this->invokeService($this->buildMessage($content));
		if (!empty($result->error)) {
			return false;
		} else {
			return $result->response;
		}
	}

	/**
   * Do upgrade action
   */
	
	function doUpgrade($product, $upgradeVersion) {
		$pro = new jaProducts($product, $this->config);
		$upgradePackage = $this->_downloadUpgradePackage($pro, $upgradeVersion);
		if($upgradePackage === false) {
			return false;
		} else {
			if($pro->doUpgrade($upgradePackage) === false) {
				//throw new Exception('[UpdaterClient] Upgrade is fail', 100);
				return false;
			}
			return true;
		}
	}
	
	function _downloadUpgradePackage($product, $upgradeVersion) {
		if($this->isLocalMode()) {
			return $this->_downloadUpgradePackageLocal($product, $upgradeVersion);
		}
		
		$content["service"] = "downloadUpgradePackage";
		$content["args"]["product"] = $product->getInfo();
		$content["args"]["newVersion"] = $upgradeVersion;
		$message = "json=".json_encode($this->buildMessage($content));
		
		$tmpFile = tempnam(sys_get_temp_dir(), 'ja');
		$result = NetworkHelper::downloadFile($tmpFile, $this->config->get("WS_URI"), $message);
		$downloadedFile = $result["savePath"];
		if(!is_file($downloadedFile)) {
			//throw new Exception('[UpdaterClient] Fail to download upgrade package', 100);
			return false;
		} else {
			chmod($downloadedFile, 0644);
			return $downloadedFile;
		}
	}
	
	/**
	 * @return same result with _downloadUpgradePackage but getting information from local repo
	 */
	
	function _downloadUpgradePackageLocal($product, $upgradeVersion) {
		@set_time_limit(0);
		if($product->version == $upgradeVersion) {
			echo ("UpdaterService: cannot upgrade to same version");
			return false;
		}
		if(!($productDir = $this->getLocalVersionsPath($product))) {
			return false;
		}
		//
		$newVerDir = $productDir . $upgradeVersion . DS;
		if(!is_dir($newVerDir)) {
			return false;
		}
		$vUpgrade = new stdClass();
		$vUpgrade->crc = $this->getVersionChecksum($newVerDir);
		//
		$orgVerDir = $productDir . $product->version . DS;
		if(is_dir($orgVerDir)) {
			$vServer = new stdClass();
			$vServer->crc = $this->getVersionChecksum($orgVerDir);
		}
		//
		$pro = new jaProducts($product, $this->config);
		$oldPro = $pro->getInfo();
		//
		$pathPackageStore = $this->getLocalPatchPath($product);
		$package = sprintf("%s_%s_%s.zip", $product->extKey, $product->version, $upgradeVersion);
		$package = $pathPackageStore . $package;
		
		if(!is_file($package)) {
			
			$compare = new jaCompareTool();
			if(isset($vServer)) {
				$vResult = $compare->checkToBuildUpgradePackage($vServer, $vUpgrade);
			} else {
				$vResult = $compare->checkToBuildUpgradePackage($oldPro, $vUpgrade);
			}
			
			$tmpDir = FileSystemHelper::tmpDir(null, 'ja', 0777);
			$tmpDir = $tmpDir . $oldPro->extKey . DS;
			if(mkdir($tmpDir, 0777) === false) {
				echo ("UpdaterService: cannot build upgrade package");
				return false;
			}
			
			$infoFile = $tmpDir . "jaupdater.info.json";
			$fp = fopen($infoFile, 'wb');
			fwrite($fp, json_encode($vResult));
			fclose($fp);
			
			//echo $tmpDir;
			$this->_buildUpgradePackage($newVerDir, $tmpDir, $vResult);
			
			ArchiveHelper::zip($package, $tmpDir, true);
		}
		
		return $package;
	}
	
	function _buildUpgradePackage($src, $dst, $objectFilter) {
		$src = FileSystemHelper::clean($src);
		$dst = FileSystemHelper::clean($dst);
		
		if(is_dir($src)) {
			if (!is_dir($dst)) {
				mkdir($dst, 0777, true);
			}
			$dir = opendir($src);
		    while(false !== ( $file = readdir($dir)) ) {
		        if (( $file != '.' ) && ( $file != '..' )) {
		            if ( is_dir($src . DS . $file)) {
		            	if(isset($objectFilter->$file)) {
		                	$this->_buildUpgradePackage($src . DS . $file, $dst . DS . $file, $objectFilter->$file);
		            	}
		            }
		            else {
						if(isset($objectFilter->$file) && in_array($objectFilter->$file, array('new', 'updated'))) {
		                	copy($src . DS . $file, $dst . DS . $file);
						}
		            }
		        }
		    }
		    closedir($dir); 
		} elseif(is_file($src)) {
			$file = basename($src);
			if(is_dir($dst)) {
				$dst = FileSystemHelper::clean($dst . DS . $file);
			}
			if(isset($objectFilter->$file) && in_array($objectFilter->$file, array('new', 'updated'))) {
				copy($src, $dst);
			}
		}
	}

	
	function listBackupFiles($product, $upgradeVersion) {
		$folder = $this->getLocalBackupPath($product);
		
		$files = FileSystemHelper::files($folder);
		if($files){
			$aFiles = array();
			$i	= -1;
			foreach($files as $file){
				if(substr($file, strrpos($file, '.')) == ".zip") {
					if( strpos($file, $product->extKey) !== false){
						$i++;
						$aSegment = explode("_", $file);
						$cnt = count($aSegment);
						
						$aFiles[$i]['extID'] = implode("_", array_slice($aSegment, 0, $cnt-3));
						$aFiles[$i]['name'] = $file;
						$aFiles[$i]['date'] = date ("Y-m-d H:i:s", filemtime($folder.$file));
						$aFiles[$i]['version'] =  substr($aSegment[$cnt-3], 1);
						if(is_file($folder . $file . ".txt")) {
							$aFiles[$i]['comment'] = file_get_contents($folder . $file . ".txt");
						}
					}
				}
			}
			if ($i >= 0) {
				return $this->msort($aFiles, 'name');
			} else {
				//throw new Exception('[UpdaterClient->listBackupFiles] No backup file is found', 100);
				return null;
			}
		} else {
			//throw new Exception('[UpdaterClient->listBackupFiles] No backup file is found', 100);
			return null;
		}
	}
	
	function msort($array, $id="id") {
        $temp_array = array();
        while(count($array)>0) {
            $lowest_id = 0;
            $index=0;
            foreach ($array as $item) {
                if ($item[$id] > $array[$lowest_id][$id]) {
                    $lowest_id = $index;
                }
                $index++;
            }
            $temp_array[] = $array[$lowest_id];
            $array = array_merge(array_slice($array, 0,$lowest_id), array_slice($array, $lowest_id+1));
        }
        return $temp_array;
    }
	
	function doRecoveryFile($product, $file) {
		$folder = $this->getLocalBackupPath($product);
		
		$pro = new jaProducts($product, $this->config);
		$result = $pro->doRecovery($product, $folder, $file);
		
		if($result) {
			return $result;
		} else {
			//throw new Exception('[UpdaterClient->doRecoveryFile] Recovery is fail', 100);
			return false;
		}
	}
	
	/**
	 * LOCAL REPO METHODS
	 */
	/**
	 * method isNewerVersion
	 * @desc check if version 1 is newer than version 2
	 *
	 * @param string $ver1
	 * @param string $ver2
	 * @param boolean $equalIs
	 * @return 
	 * 0 - if version 1 is older than version 2
	 * 1 - if version 1 is newer than version 2
	 * 2 - if can not detect status
	 */
	function isNewerVersion($ver1, $ver2, $equalIs = false) {
		if($ver1 == $ver2) {
			return ($equalIs) ? 1 : 0;
		} else {
			$aVer1 = explode('.', $ver1);
			$aVer2 = explode('.', $ver2);
			$cnt1 = count($aVer1);
			$cnt2 = count($aVer2);
			$cnt = max($cnt1, $cnt2);
			
			
			$i = -1;
			/*check what is newer version*/
			$result = 1;
			//first: set ver1 as newer version, ver2 as older version
			while($i<$cnt) {
				$i++;
				if(isset($aVer1[$i]) && isset($aVer2[$i])) {
					if(intval($aVer1[$i]) < intval($aVer2[$i])) {
						$result = 0;
						break;
					} elseif (intval($aVer1[$i]) > intval($aVer2[$i])) {
						break;
					}
					if($i == $cnt - 1) {
						//two versions are the same
						//but one of which is Beta or Alpha version
						$result = 2;
					}
				} elseif(isset($aVer1[$i])) {
					break;
				} elseif(isset($aVer2[$i])) {
					$result = 0;
					break;
				}
			}
			return $result;
		}
	}
	
	function getLocalVersionsPath($product, $checkExists = true) {
		$path = JA_WORKING_DATA_FOLDER . $product->type . DS . $product->extKey . DS . "versions" . DS;
		if(is_dir($path) || !$checkExists) {
			return $path;
		} else {
			return false;
		}
	}
	
	function getLocalPatchPath($product) {
		$path = JA_WORKING_DATA_FOLDER . $product->type . DS . $product->extKey . DS . "patch" . DS;
		if(!is_dir($path)) {
			if(!FileSystemHelper::createDirRecursive($path, 0777)) {
				return false;
			}
		}
		return $path;
	}
	
	function getLocalBackupPath($product) {
		$path = JA_WORKING_DATA_FOLDER . $product->type . DS . $product->extKey . DS . "backup" . DS;
		if(!is_dir($path)) {
			if(!FileSystemHelper::createDirRecursive($path, 0777)) {
				return false;
			}
		}
		return $path;
	}
	
	function getVersionChecksum($path) {
		$cache = $path . "jaupdater.checksum.json";
		if(is_file($cache)) {
			return file_get_contents($cache);
		} else {
			$md5CheckSums = new CheckSumsMD5();
			$fp = fopen($cache, 'wb');
			$crc = $md5CheckSums->dumpCRCObject($path);
			$json = json_encode($crc);
			fwrite($fp, $json);
			fclose($fp);
			
			return $json;
		}
	}
}
