<?php
/*------------------------------------------------------------------------
# $JA#PRODUCT_NAME$ - Version $JA#VERSION$ - Licence Owner $JA#OWNER$
# ------------------------------------------------------------------------
# Copyright (C) 2004-2008 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
# @license - Copyrighted Commercial Software
# Author: J.O.O.M Solutions Co., Ltd
# Websites:  http://www.joomlart.com -  http://www.joomlancers.com
# This file may not be redistributed in whole or significant part.
-------------------------------------------------------------------------*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.helper' );
jimport( 'joomla.filesystem.file' );

class JaextmanagerHelper extends JComponentHelper {
	function JaextmanagerHelper() {
		
	}

	function loadExtension($obj, $type) {
		if(!is_object($obj) || !isset($obj->type) || !isset($obj->id)) {
			return false;
		}
		$obj->extId = $obj->type . "-" . $obj->id;//use type+id => unique id for each product of all extension types
		$obj->coreVersion = 'j15';//this com is worked on joomla 1.5.x, so all extensions have same core version with it.
		
		$method = '_load' . ucfirst(strtolower($type));
		if(!method_exists($this, $method)) 
			return false;
		return $this->$method($obj);
	}
	
	function _parseExtensionInfo($obj, $xmlfile) {
		if(JFile::exists($xmlfile)) {
			if ($data = JApplicationHelper::parseXMLInstallFile($xmlfile)) {
				$obj->configFile = $xmlfile;
				
				foreach($data as $key => $value) {
					$obj->$key = $value;
				}
				return $obj;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function _loadModule($obj) {
		$installDir = ($obj->client_id) ? JPATH_ADMINISTRATOR : JPATH_ROOT;
		$installDir .= DS . 'modules' . DS . $obj->extKey . DS;
		$installDir = JPath::clean($installDir);
		if(JFolder::exists($installDir) === false) {
			return false;
		}
		
		$xmlfile = $installDir . $obj->extKey . ".xml";
		return $this->_parseExtensionInfo($obj, $xmlfile);
	}
	
	function _loadPlugin($obj) {
		$installDir = JPATH_ROOT .DS . 'plugins' . DS . $obj->folder . DS;
		if(JFile::exists($installDir . $obj->extKey . ".php") === false) {
			return false;
		}
		
		$xmlfile = $installDir . $obj->extKey . ".xml";
		return $this->_parseExtensionInfo($obj, $xmlfile);
	}
	
	function _loadTemplate($obj) {
		$installDir = ($obj->client_id) ? JPATH_ADMINISTRATOR : JPATH_ROOT;
		$installDir .= DS . 'templates' . DS . $obj->extKey . DS;
		$installDir = JPath::clean($installDir);
		if(JFolder::exists($installDir) === false) {
			return false;
		}
		
		$xmlfile = $installDir . "templateDetails.xml";
		return $this->_parseExtensionInfo($obj, $xmlfile);
	}

	function _loadComponent($obj) {
		/* Get the component base directory */
		$adminDir = JPATH_ADMINISTRATOR .DS. 'components' . DS . $obj->extKey . DS;
		$siteDir = JPATH_SITE .DS. 'components' . DS . $obj->extKey . DS;
		
		$name1 = substr($obj->extKey, 4);
		$name2 = $obj->extKey;
		$aTry = array();
		$aTry[] = $adminDir . $name1 . ".xml";
		$aTry[] = $adminDir . $name2 . ".xml";
		$aTry[] = $siteDir . $name1 . ".xml";
		$aTry[] = $siteDir . $name2 . ".xml";
		
		$xmlfile = "";
		foreach($aTry as $file) {
			if(is_file($file)) {
				$xmlfile = $file;
				break;
			}
		}
		
		if(JFile::exists($xmlfile)) {
			return $this->_parseExtensionInfo($obj, $xmlfile);
		} else {
			return false;
		}
	}
}
