<?php
/*------------------------------------------------------------------------
# $JA#PRODUCT_NAME$ - Version $JA#VERSION$ - Licence Owner $JA#OWNER$
# ------------------------------------------------------------------------
# Copyright (C) 2004-2008 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
# @license - Copyrighted Commercial Software
# Author: J.O.O.M Solutions Co., Ltd
# Websites:  http://www.joomlart.com -  http://www.joomlancers.com
# This file may not be redistributed in whole or significant part.
-------------------------------------------------------------------------*/
// no direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );

class JaextmanagerControllerDefault extends JaextmanagerController {

	function __construct($default = array()) {
		parent::__construct($default);

		// Register Extra tasks
		$this->registerTask( 'back', 'back' );
		$this->registerTask( 'cancel', 'cancel' );
		$this->registerTask( 'compare', 'compare' );
		$this->registerTask( 'changelog', 'changelog' );
		$this->registerTask( 'checkupdate', 'checkUpdate' );
		$this->registerTask( 'upgrade', 'upgrade' );
		$this->registerTask( 'recovery', 'recovery' );
		$this->registerTask( 'rollback', 'rollback' );
		$this->registerTask( 'config_general_save', 'config_general_apply' );
	}

	/**
   * Display the list of import bills
   */
	function display() {
		parent::display();
	}

	function back() {
		$this->setRedirect($this->getLink());
	}

	function cancel() {
		$this->setRedirect( $this->getLink(), "Action canceled" );
	}

	function checkUpdate() {
		JRequest::setVar('layout', 'checkupdate');
		parent::display();
	}

	function upgrade() {
		if(strtoupper($_SERVER['REQUEST_METHOD']) != 'POST') {
			$this->setRedirect($this->getLink(), "Invalid Request!");
		}
		
		$message = '';
		$model = &$this->getModel('default');
		$version = $model->doUpgrade();
		if ($version === false) {
			$message = JText::_("Upgrade failured");
		} else {
			$message =  JText::_("Successfully upgraded to version " . $version);
		}
		die($message);
		// $this->setRedirect($this->getLink(), $message);
	}

	function recovery() {
		JRequest::setVar('layout', 'recovery');
		parent::display();
	}
	
	function doRecovery() {
		if(strtoupper($_SERVER['REQUEST_METHOD']) != 'POST') {
			$this->setRedirect($this->getLink(), "Invalid Request!");
		}
		JRequest::setVar('layout', 'doRecovery');
		parent::display();
	}

	function rollback() {
		$message = '';
		$model = &$this->getModel('default');
		$state = $model->rollback();
		if ($state === false) {
			$message = "Rollback failured";
		} else {
			$message =  "Successfully rollback [$state->name] to version: $state->version";
		}
		$this->setRedirect($this->getLink(), $message);
	}
	
	function compare() {
		JRequest::setVar('layout', 'diff_view');
		parent::display();
	}
	
	function changelog() {
		$message = '';
		$model = &$this->getModel('default');
		$log = $model->getChangeLog();
		echo nl2br($log);
		die();
	}
	
	function config_general_save(){
		$model = &$this->getModel('default');
		$param = $model->storeComponentParams();
		
		$this->setRedirect( "index.php?option=".JACOMPONENT."&view=default&layout=".JRequest::getVar("layout"), "Setting saved" );
	}
	
	function doUpload() {
		$model = $this->getModel ( 'uploader' );
		$result = $model->upload();
		
		JRequest::setVar('layout', 'uploader');
		parent::display();
	}
}
