<?php
/**
 * Default Model
 *
 * @package   Joomla
 * @subpackage  Updater
 * @since   1.5
 *
 * @desc modify from "Extension Manager Install Model" of "Installer Component"
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.model' );
jimport( 'joomla.installer.installer' );
jimport('joomla.installer.helper');

class JaextmanagerModelUploader extends JModel
{
	/** @var object JTable object */
	var $_table = null;

	/** @var object JTable object */
	var $_url = null;

	/**
	 * Overridden constructor
	 * @access	protected
	 */
	function __construct()
	{
		parent::__construct();

	}

	function upload()
	{
		global $mainframe;

		$this->setState('action', 'upload');

		switch(JRequest::getWord('installtype'))
		{
			case 'folder':
				$package = $this->_getPackageFromFolder();
				break;

			case 'upload':
				$package = $this->_getPackageFromUpload();
				break;

			case 'url':
				$package = $this->_getPackageFromUrl();
				break;

			default:
				JError::raiseWarning(100, JText::_('No Upload Type Found'));
				return false;
				break;
		}

		// Was the package unpacked?
		if (!$package) {
			JError::raiseWarning(100, JText::_('Unable to find install package'));
			return false;
		}
		
		$xmlfiles = JFolder::files($package['dir'], '.xml$', 1, true);
		if (!empty($xmlfiles)) {
			foreach ($xmlfiles as $file) {
				if(($data = JApplicationHelper::parseXMLInstallFile($file)) !== false) {
					if(isset($data['type'], $data['version'])) {
						$pathSrc = $package['dir'];
						if($data['type'] == 'template') {
							$extKey = strtolower(str_replace(" ", "_", $data['name']));
						} else {
							$fileName = basename($file);
							$extKey = substr($fileName, 0, strrpos($fileName, '.'));
						}
						$pathDst = JA_WORKING_DATA_FOLDER . $data['type'] . DS . $extKey . DS . "versions" . DS . $data['version'] . DS;
						if(is_dir($pathDst)) {
							JError::raiseWarning(100, JText::_('This version is alredy exists on your local repository'));
							return false;
						} else {
							FileSystemHelper::createDirRecursive(dirname($pathDst), 0777);
							if(JFolder::copy($pathSrc, $pathDst)) {
								JError::raiseNotice(101, JText::sprintf("Successfully uploaded version %s of '%s' to local repository", $data['version'], $data['name']));
								return true;
							} else {
								JError::raiseWarning(100, JText::sprintf("Fail upload version %s of '%s' to local repository", $data['version'], $data['name']));
								return false;
							}
						}
					}
				}
			}
		}
		
		// Cleanup the install files
		if (!is_file($package['packagefile'])) {
			$config =& JFactory::getConfig();
			$package['packagefile'] = $config->getValue('config.tmp_path').DS.$package['packagefile'];
		}

		JInstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);
		//
		JError::raiseWarning(100, JText::_('Package is not valid a extension of joomla. Please check again!'));
		return false;
	}

	/**
	 * @param string The class name for the installer
	 */
	function _getPackageFromUpload()
	{
		// Get the uploaded file information
		$userfile = JRequest::getVar('install_package', null, 'files', 'array' );
		//print_r($userfile);

		// Make sure that file uploads are enabled in php
		if (!(bool) ini_get('file_uploads')) {
			JError::raiseWarning('SOME_ERROR_CODE', JText::_('WARNINSTALLFILE'));
			return false;
		}

		// Make sure that zlib is loaded so that the package can be unpacked
		if (!extension_loaded('zlib')) {
			JError::raiseWarning('SOME_ERROR_CODE', JText::_('WARNINSTALLZLIB'));
			return false;
		}

		// If there is no uploaded file, we have a problem...
		if (!is_array($userfile) ) {
			JError::raiseWarning('SOME_ERROR_CODE', JText::_('No file selected'));
			return false;
		}

		// Check if there was a problem uploading the file.
		if ( $userfile['error'] || $userfile['size'] < 1 )
		{
			JError::raiseWarning('SOME_ERROR_CODE', JText::_('WARNINSTALLUPLOADERROR'));
			return false;
		}

		// Build the appropriate paths
		$config =& JFactory::getConfig();
		$tmp_dest 	= $config->getValue('config.tmp_path').DS.$userfile['name'];
		$tmp_src	= $userfile['tmp_name'];

		// Move uploaded file
		jimport('joomla.filesystem.file');
		$uploaded = JFile::upload($tmp_src, $tmp_dest);

		// Unpack the downloaded package file
		$package = JInstallerHelper::unpack($tmp_dest);

		return $package;
	}

	/**
	 * Install an extension from a directory
	 *
	 * @static
	 * @return boolean True on success
	 * @since 1.0
	 */
	function _getPackageFromFolder()
	{
		// Get the path to the package to install
		$p_dir = JRequest::getString('install_directory');
		$p_dir = JPath::clean( $p_dir );

		// Did you give us a valid directory?
		if (!is_dir($p_dir)) {
			JError::raiseWarning('SOME_ERROR_CODE', JText::_('Please enter a package directory'));
			return false;
		}

		// Detect the package type
		$type = JInstallerHelper::detectType($p_dir);

		// Did you give us a valid package?
		if (!$type) {
			JError::raiseWarning('SOME_ERROR_CODE', JText::_('Path does not have a valid package'));
			return false;
		}

		$package['packagefile'] = null;
		$package['extractdir'] = null;
		$package['dir'] = $p_dir;
		$package['type'] = $type;

		return $package;
	}

	/**
	 * Install an extension from a URL
	 *
	 * @static
	 * @return boolean True on success
	 * @since 1.5
	 */
	function _getPackageFromUrl()
	{
		// Get a database connector
		$db = & JFactory::getDBO();

		// Get the URL of the package to install
		$url = JRequest::getString('install_url');

		// Did you give us a URL?
		if (!$url) {
			JError::raiseWarning('SOME_ERROR_CODE', JText::_('Please enter a URL'));
			return false;
		}

		// Download the package at the URL given
		$p_file = JInstallerHelper::downloadPackage($url);

		// Was the package downloaded?
		if (!$p_file) {
			JError::raiseWarning('SOME_ERROR_CODE', JText::_('Invalid URL'));
			return false;
		}

		$config =& JFactory::getConfig();
		$tmp_dest 	= $config->getValue('config.tmp_path');

		// Unpack the downloaded package file
		$package = JInstallerHelper::unpack($tmp_dest.DS.$p_file);

		return $package;
	}
}