<?php

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.model' );
jimport('joomla.filesystem.file');

/**
 * Default Model
 *
 * @package   Joomla
 * @subpackage  Updater
 * @since   1.5
 */
class JaextmanagerModelDefault extends JModel {

	var $_components = array();
	var $_updateComponents = array();
	var $_updateExtensions = array();
	var $_bkPkgs = array();
	var $_component = null;

	/** @var object JPagination object */
	var $_pagination = null;
	
	var $coreCom;
	var $coreMod;
	var $corePlg;
	var $coreTpl;

	function __construct() {
		global $mainframe;

		parent::__construct();

		// Set state variables from the request
		$this->setState('pagination.limit', $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int'));
		$this->setState('pagination.offset',$mainframe->getUserStateFromRequest(JACOMPONENT.'.limitstart.update', 'limitstart', 0, 'int'));
		$this->setState('pagination.total', 0);
		
		//
		$this->coreCom = array("'com_banners'", "'com_weblinks'", "'com_contact'", "'com_poll'", "'com_newsfeeds'", "'com_user'", "'com_search'", "'com_wrapper'", "'com_mailto'", "'com_media'", "'com_content'", "'com_config'", "'com_installer'", "'com_languages'", "'com_massmail'", "'com_menus'", "'com_messages'", "'com_modules'", "'com_plugins'", "'com_templates'", "'com_users'", "'com_cache'", "'com_cpanel'");
		$this->coreMod = array("'mod_mainmenu'", "'mod_login'", "'mod_popular'", "'mod_latest'", "'mod_stats'", "'mod_unread'", "'mod_online'", "'mod_toolbar'", "'mod_quickicon'", "'mod_logged'", "'mod_footer'", "'mod_menu'", "'mod_submenu'", "'mod_status'", "'mod_title'", "'mod_poll'", "'mod_mainmenu'", "'mod_login'", "'mod_latestnews'", "'mod_stats'", "'mod_whosonline'", "'mod_mostread'", "'mod_archive'", "'mod_sections'", "'mod_newsflash'", "'mod_related_items'", "'mod_search'", "'mod_random_image'", "'mod_mainmenu'", "'mod_banners'", "'mod_mainmenu'", "'mod_wrapper'", "'mod_footer'", "'mod_feed'", "'mod_breadcrumbs'", "'mod_syndicate'", "'mod_banners'", "'mod_mainmenu'", "'mod_mainmenu'", "'mod_custom'", "'mod_feed'");
		$this->corePlg = array("'joomla'", "'ldap'", "'gmail'", "'openid'", "'joomla'", "'content'", "'contacts'", "'categories'", "'sections'", "'newsfeeds'", "'weblinks'", "'pagebreak'", "'vote'", "'emailcloak'", "'geshi'", "'loadmodule'", "'pagenavigation'", "'none'", "'tinymce'", "'xstandard'", "'image'", "'pagebreak'", "'readmore'", "'joomla'", "'blogger'", "'sef'", "'debug'", "'legacy'", "'cache'", "'log'", "'remember'", "'backlink'");
		$this->coreTpl = array("'khepri'");
	}

	function &getUri() {
		global $compUri;
		return "$compUri&view=update";
	}
	
	function &getConfigService() {
		global $jauc;
		
		$item	= $this->getComponentParams();
		
		$params = new JParameter( $item->params );
		//get mysql variables
		if ( substr(PHP_OS,0,3) == 'WIN') {
			$db =& JFactory::getDBO();
			$query = 'SHOW VARIABLES';
			$db->setQuery($query);
			$rs = $db->loadObjectList();
			$aMysqlVariables = array();
			foreach ($rs as $row) {
				$aMysqlVariables[$row->Variable_name] = $row->Value;
			}
			$pathMysql = (isset($aMysqlVariables['basedir'])) ? $aMysqlVariables['basedir'] . 'bin'.DS.'mysql' : 'mysql';
			$pathMysqldump = (isset($aMysqlVariables['basedir'])) ? $aMysqlVariables['basedir'] . 'bin'.DS.'mysqldump' : 'mysqldump';
		} else {
			$pathMysql = 'mysql';
			$pathMysqldump = 'mysqldump';
		}
		
		$params = &JComponentHelper::getParams( JACOMPONENT );
		$pathMysql 		= $params->get("MYSQL_PATH", $pathMysql);
		$pathMysqldump	= $params->get("MYSQLDUMP_PATH", $pathMysqldump);
		
		//validate settings
		jaucValidServiceSettings($params);
		//
		$params->set('MYSQL_PATH', $pathMysql);
		$params->set('MYSQLDUMP_PATH', $pathMysqldump);
		
		return $params;
	}
	
	function &getPagination() {
		
		return $this->_pagination;
	}
	
	function getListExtensions() {
		
		$lists = $this->_getUsListExtensions ();
		$total = $this->_getTotalExtensions($lists);
		if ($lists ['limit'] > $total) {
			$lists ['limitstart'] = 0;
		}
		if ($lists ['limit'] == 0) {
			$lists ['limit'] = $total;
		}
		
		if (empty($this->_updateExtensions)) {
			$this->_loadExtensions($lists['limitstart'], $lists['limit'], $lists);
		}
		
		jimport ( 'joomla.html.pagination' );
		$this->_pagination = new JPagination ( $total, $lists ['limitstart'], $lists ['limit'] );
		
		return $this->_updateExtensions;
		
	}
	/**
	 * get User State
	 *
	 * @return unknown
	 */
	function _splitTypes($cIds) {
		$aSupportedTypes = array('component', 'module', 'plugin', 'template');
		$aType = array();
		foreach ($cIds as $eId) {
			$id = explode('-', $eId);//format: type-id
			if(in_array($id[0], $aSupportedTypes) && isset($id[1])) {
				$aType[$id[0]][] = (int) $id[1];
			}
		}
		foreach ($aSupportedTypes as $type) {
			if(!isset($aType[$type])) {
				$aType[$type][] = 0;
			}
		}
		return $aType;
	}
	
	function _getUsListExtensions() {
		global $mainframe, $javconfig;
		$option='jauc';
		$lists = array ();
		$lists ['filter_order'] = $mainframe->getUserStateFromRequest ( $option . '.filter_order', 'filter_order', 't.id', 'string' );
		$lists ['filter_order_Dir'] = $mainframe->getUserStateFromRequest ( $option . '.filter_order_Dir', 'filter_order_Dir', 'desc', 'word' );
		$lists ['limit'] = $mainframe->getUserStateFromRequest ( $option . 'limit', 'limit', 20, 'int' );
		$lists ['limitstart'] = $mainframe->getUserStateFromRequest ( $option . '.limitstart', 'limitstart', 0, 'int' );
		$lists ['search'] = $mainframe->getUserStateFromRequest ( $option . '.search', 'search', JRequest::getVar( 'search', ''), 'string' );
		$lists ['status'] = $mainframe->getUserStateFromRequest ( $option . '.status', 'status', '0', 'int' );
		$lists ['extionsion_type'] = $mainframe->getUserStateFromRequest ( $option . '.extionsion_type', 'extionsion_type', JRequest::getVar( 'type', ''), 'string' );
		
		return $lists;
	}	
	
	function _getFilterExtensions() {
		$keyword = empty($lists['search']) ? '' : $lists['search'];
		
		//default filter
		$filterCom = " WHERE iscore = 0 AND `option` <> '' ";
		$filterMod = " WHERE iscore = 0 AND `module` <> '' ";
		$filterPlg = " WHERE iscore = 0 AND `element` <> '' ";
		$filterTpl = " WHERE 1 AND `template` <> '' ";
		
		//filter by core extensions
		$filterCom .= "AND `option` <> " . implode(" AND `option` <> ", $this->coreCom)." ";
		$filterMod .= "AND `module` <> " . implode(" AND `module` <> ", $this->coreMod)." ";
		$filterPlg .= "AND `element` <> " . implode(" AND `element` <> ", $this->corePlg)." ";
		$filterTpl .= "AND `template` <> " . implode(" AND `template` <> ", $this->coreTpl)." ";
		
		//filter by keyword
		$filterCom .= "AND (name LIKE '%{$keyword}%' OR '' = '{$keyword}') ";
		$filterMod .= "AND (title LIKE '%{$keyword}%' OR '' = '{$keyword}') ";
		$filterPlg .= "AND (name LIKE '%{$keyword}%' OR '' = '{$keyword}') ";
		$filterTpl .= "AND (template LIKE '%{$keyword}%' OR '' = '{$keyword}') ";
		
		//filter by extension id
		$cIds = JRequest::getVar('cId', array(), '', 'array');
		if(!empty($cIds)) {
			$aTypeId = $this->_splitTypes($cIds);
			$filterCom .= "AND id IN (".implode(',', $aTypeId['component']).") ";
			$filterMod .= "AND id IN (".implode(',', $aTypeId['module']).") ";
			$filterPlg .= "AND id IN (".implode(',', $aTypeId['plugin']).") ";
			$filterTpl .= "AND template IN (".implode(',', $aTypeId['template']).") ";
		}
		
		$aFilter = array(
					'com' => $filterCom, 
					'mod' => $filterMod, 
					'plg' => $filterPlg, 
					'tpl' => $filterTpl, 
					);
		return $aFilter;
	}
	
	function _getTotalExtensions($lists) {
		$db =& JFactory::getDBO();
		$type = (JRequest::getVar('type', '') != '') ? JRequest::getVar('type') : $lists['extionsion_type'];
		$aFilter = $this->_getFilterExtensions();
		
		$aUnion = array();
		$aUnion['component'] = "SELECT COUNT(id) AS cnt, `option` FROM #__components {$aFilter['com']} GROUP BY `option`";
		$aUnion['module'] 	= "SELECT COUNT(id) AS cnt, `module` FROM #__modules {$aFilter['mod']} GROUP BY `module`";
		$aUnion['plugin'] 	= "SELECT COUNT(id) AS cnt, `element` FROM #__plugins {$aFilter['plg']} GROUP BY `element`";
		$aUnion['template'] 	= "SELECT COUNT(*) AS cnt, `template` FROM #__templates_menu {$aFilter['tpl']} GROUP BY `template`";
		
		if(array_key_exists($type, $aUnion)) {
			$query = $aUnion[$type];
		} else {
			$query = implode(" UNION ", $aUnion);
		}
		$query = "
			SELECT COUNT(cnt) FROM (
				{$query}   
			) AS extensions
		";
		$db->setQuery ( $query );
		return $db->loadResult ();
	}
	
	function _loadExtensions($limitstart=0, $limit=20, $lists = array()) {
		global $mainframe, $option;
		$type = (JRequest::getVar('type', '') != '') ? JRequest::getVar('type') : $lists['extionsion_type'];
		$aFilter = $this->_getFilterExtensions();
		
		$db =& JFactory::getDBO();
		
		$aUnion = array();
		$aUnion['component'] = "
				SELECT 
					'component' AS `type`, `option` AS extKey,
					id, name, params, iscore, enabled, 
					`option`, '' AS module, '' AS element, '0' AS client_id, '' AS folder 
				FROM #__components 
				{$aFilter['com']} 
				GROUP BY `option`
				";
		$aUnion['module'] = "
				SELECT 
					'module' AS `type`, module AS extKey,
					id, title AS name, params, iscore, published AS enabled, 
					'' AS `option`, module, '' AS element, client_id, '' AS folder 
				FROM #__modules 
				{$aFilter['mod']} 
				GROUP BY `module`
				";
		$aUnion['plugin'] = "
				SELECT 
					'plugin' AS `type`, element AS extKey,
					id, name, params, iscore, published AS enabled, 
					'' AS `option`, '' AS module, element, '0' AS client_id, folder 
				FROM #__plugins 
				{$aFilter['plg']} 
				GROUP BY `element`
				";
		$aUnion['template'] = "
				SELECT 
					'template' AS `type`, template AS extKey,
					template AS id, template AS name, '' AS params, '0' AS iscore, '1' AS enabled, 
					'' AS `option`, '' AS module, '' AS element, client_id, '' AS folder 
				FROM #__templates_menu 
				{$aFilter['tpl']} 
				GROUP BY `template`
				";
		
		if(array_key_exists($type, $aUnion)) {
			$query = $aUnion[$type];
		} else {
			$query = implode(" UNION ", $aUnion);
		}
		
		$query .= "
				ORDER BY iscore, name
				LIMIT {$limitstart}, {$limit}";
		
		$db->setQuery($query);
		$rows = $db->loadObjectList();

		$this->_updateExtensions = array();
		$helper = new JaextmanagerHelper();
		foreach ($rows as $obj) {
			if (($obj = $helper->loadExtension($obj, $obj->type)) !== false) {
				$this->_updateExtensions[] = $obj;
			}
		}
	}
	
	function getListExtensionType() {
		$aData = array();
		$aData[] = JHTML::_( 'select.option', '', JText::_('-- All --') );
		$aData[] = JHTML::_( 'select.option', 'component', JText::_('Components') );
		$aData[] = JHTML::_( 'select.option', 'module', JText::_('Modules') );
		$aData[] = JHTML::_( 'select.option', 'plugin', JText::_('Plugins') );
		$aData[] = JHTML::_( 'select.option', 'template', JText::_('Templates') );
		return $aData;
	}
	
	function _getProduct() {
		$this->_updateExtensions = array();
		
		$cIds = JRequest::getVar('cId', array(), '', 'array');
		if(!isset($cIds[0])) {
			return false;
		}
		
		list($type, $id) = explode('-', $cIds[0]);
		JRequest::setVar('type', $type);
		
		$this->_loadExtensions();
		
		if(!isset($this->_updateExtensions[0])) {
			return false;
		}
		return $this->_updateExtensions[0];
	}

	//Step 1 - check update
	function getNewVersions() {
		global $jauc;
		
		$obj = $this->_getProduct();
		if($obj === false) {
			$css = "status-not-support";
			$status = JText::_('This extension is not supported!');
		}
		$uploadScript = " <br />[<a href=\"#\" onclick=\"jaCreatePopup('index.php?tmpl=component&option=".JACOMPONENT."&view=default&viewmenu=0&layout=uploader', 400, 300, '".JText::_("JA Uploader")."'); return false;\" title=\"".JText::_( "Upload version package")."\">".JText::_("Upload Now")."</a>]";
		$versionsNote = JText::_("
		A version is considerred as new version if we detect a higher number in XML file,<br /> 
		so please make sure the extension have proper and consistant versioning number system in all releases.<br />
		
		++++++++++++++++++++++<br />
		Samples of good versioning<br />
		- 1.0, 1.1, 1.2<br />
		- V1.0, V2.0<br />
		- Version 1.0, Version 2.0<br />
		- 1.0 Alpha, 1.1 Beta, 1.2 Stable<br />
		
		++++++++++++++++++++++++<br />
		Bad versioning we can't detect<br />
		- 1.0 Alpha 2, 1.0 Beta<br />
		- 1.0 Beta 1, 1.0 Beta 2 (<-- hard to tell Alpha 2 or Beta are higher, they are not interger )<br />
		- 1.0, 1.0.1. v2.1 (<-- not consistant)<br />
		");
		$versionsNote = preg_replace("/\r\n/", "", $versionsNote);
		
		$versions = $jauc->getNewerVersions($obj);
		if($versions === false) {
			$css = "status-not-uploaded";
			
			$tipid = uniqid("ja-tooltip-");
			$title = JText::sprintf("It seem no version of %s has been uploaded to %s", $obj->name, "<br /><strong>".$jauc->getLocalVersionsPath($obj, false) ."</strong><br />") ;
			$linkRepo = "<a id=\"{$tipid}\" class=\"ja-tips-title\" href=\"#\" title=\"\" >".JText::_("Repository")."</a>";
			$status = JText::sprintf("Sorry, no version uploaded in %s", $linkRepo);
			
			$script = jaEMTooltips($tipid, $title);
		} else {
		
			if (!is_object($versions)) {
				$css = "status-not-support";
				$status = JText::_('This extension is not supported!');
			} else {
				$extID 		= $obj->extId;
				$css = "status-new";
				
				$tipid 		= uniqid("ja-tooltip-");
				$title		= "<sup><a href=\"#\" id=\"{$tipid}\" class=\"ja-tips-title\" title=\"\">".JText::_("[?]")."</a></sup>";
				$status 	= JText::sprintf("New version found! %s", $title);
				$status		.= jaEMTooltips($tipid, $versionsNote);
				$lastest 	= '';
				
				$index		= 0;
				$showOnly	= 1;
				$more = 0;	
				foreach ($versions as $v => $vInfo) {
					$index++;
					if(isset($vInfo->lastest)) {
						$lastest = $vInfo->version;
					}
					/*if ( $index == $showOnly + 1 ) {
						$more = 1;
						$status .= '<br/> <a href="#" style="color:#800000" onclick="showMoreOlderVersion(this, \'olderVersion'.$extID.'\'); return false;">'.JText::_("More").'</a>';
						$status .= '<br/> <div id="olderVersion'.$extID.'" style="display:none">';
					}*/
					
					$status .= '<br />';
					$status .= "- {$v} <sup style=\"color:red;\">[New";
					$status .= (isset($vInfo->releaseDate) ? $vInfo->releaseDate . " - " : '').(isset($vInfo->lastest) ? JText::_('Lastest') : '');
					$status .= "]</sup>";
					if(isset($vInfo->notSure)) {
						$tipid = uniqid("ja-tooltip-");
						$title = "++++++++<br />".JText::sprintf("We can not detect which is a newer version between  %s and %s <br />",$obj->version, $v) . $versionsNote;
						$status .= "<sup style=\"color:#FF6600;\" id=\"{$tipid}\">[!Notice]</sup>";
						$status .= jaEMTooltips($tipid, $title);
					}
					if(isset($vInfo->changelogUrl)) {
						$status .= '<a href="'.$vInfo->changelogUrl.'" title="'.JText::_('Show Change Log').'" target="_blank" >'.JText::_('Change Log').'</a>';
					}
					$status .= ' - <a href="index.php?option='.JACOMPONENT.'&view=default&task=compare&cId[]='.$extID.'&version='.$v.'" title="'.JText::_('View difference between two versions').'">'.JText::_('Compare').'</a>';
					$status .= ' - <a href="#" onclick="doUpgrade(\''.$extID.'\', \''.$v.'\', \'LastCheckStatus_'.$extID.'\'); return false;" title="'.JText::_('Upgarde to new version now').'">'.JText::_('Upgrade Now').'</a>';
				}
				/*if ( $more ) {
					$status .= '</div>';
				}*/
				
				if($index == 0) {
					if($jauc->isLocalMode()) {
						$css = "status-normal";
						
						$tipid = uniqid("ja-tooltip-");
						$title = JText::sprintf("%s new versions are stored at %s If you have new version, Upload it or do it via FTP ", $obj->name, "<br /><strong>".$jauc->getLocalVersionsPath($obj, false) ."</strong><br />") ;
						$linkRepo = "<a id=\"{$tipid}\" class=\"ja-tips-title\" href=\"#\" title=\"\">".JText::_("Repository")."</a>";
						$status = JText::sprintf('No new version found in %s', $linkRepo);
						
						$script = jaEMTooltips($tipid, $title);
					} else {
						$css = "status-lastest";
						$status = JText::_('Sorry we cant tell if you are using latest version!');
					}
				}
			}
			
		}
		if($jauc->isLocalMode()) {
			$status .= $uploadScript;
		}
		$status = "<div class=\"{$css}\">{$status}</div>";
		if(isset($script)) {
			$status .= $script;
		}
		
		$this->storeLastCheck($obj->extId, addslashes($status));
		
		return $status;
	}
	
	// Store last check status
	function storeLastCheck($objID, $status){
		$db =& JFactory::getDBO();
		
		$query = "
			INSERT INTO #__jaem_log (ext_id, check_date, check_info)
			VALUES ('".$objID."', '".date('Y-m-d H:i:s')."', '".addslashes($status)."')
			ON DUPLICATE KEY UPDATE
				check_date = '".date('Y-m-d H:i:s')."',
				check_info = '".addslashes($status)."'";
		$db->setQuery($query);
		$db->query();
	}
	
	function getLastCheckStatus($listLog, $objID){
		foreach ($listLog as $item) {
			if($item->ext_id == $objID) {
				return stripcslashes($item->check_info);
			}
		}
		return '';
	}
	
	function getLastCheckObject(){
		$db =& JFactory::getDBO();
		
		$query = "SELECT * FROM #__jaem_log WHERE 1";
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		return $rows;
	}
	
	//2. Update view
	function getDiffView() {
		global $jauc;
		
		$obj = $this->_getProduct();
		if($obj === false) {
			return false;
		}
		$version 	= JRequest::getVar('version');
		
		$upgradeInfo = $jauc->buildDiff($obj, $version);
		if($upgradeInfo === false) {
			JError::raiseWarning(0, JText::_("Failured to build difference view."));
			return false;
		} else {
			$obj->diffInfo = $upgradeInfo;
			return $obj;
		}
		
		/*try{
			$upgradeInfo = $jauc->buildDiff($obj, $version);
			$obj->diffInfo = $upgradeInfo;
			return $obj;
		} catch( Exception $e ) {
			JError::raiseWarning(0, $e->getMessage());
			return false;
		}*/
	}
	
	//3. View change log
	function getChangeLog() {
		global $jauc;
		
		$obj = $this->_getProduct();
		if($obj === false) {
			return JText::_('This product is not supported!');
		}
		
		$version 	= JRequest::getVar('version');
		
		$log = $jauc->getChangeLog($obj, $version);
		if($log === false) {
			return JText::_("Fail to get change log");
		} else {
			return $log;
		}
		/*try {
			return $jauc->getChangeLog($obj, $version);
		} catch (Exception $e) {
			return $e->getMessage();
		}*/
	}
	
	//4. Do Upgrade
	function doUpgrade() {
		global $jauc;
		
		$obj = $this->_getProduct();
		if($obj === false) {
			return JText::_('This product is not supported!');
		}

		$version 	= JRequest::getVar('version');
		
		$obj->message = JRequest::getVar('comment', '');
		
		$result = $jauc->doUpgrade($obj, $version);
		if($result === false) {
			echo JText::_("Fail to upgrade");
			return false;
		} else {
			$message = JText::_("You have successfully upgraded from version {from_version} to version {to_version} at {time}");
			$message = str_replace(
						array('{from_version}', '{to_version}', '{time}'), 
						array($obj->version, $version, date('d M Y, H:i:s')), 
						$message);
			$this->storeLastCheck($obj->extId, $message);
			return $version;
		}
		/*try {
			$jauc->doUpgrade($obj, $version);
		} catch (Exception $e) {
			echo $e->getMessage();
			return false;
		}*/
		return $version;
	}
	
	//5. Rollback
	function rollback() {
		//need update
	}
	
	
	// Listing extension recover files 
	function getListRecoveryFiles(){
		global $jauc;
		
		$obj = $this->_getProduct();
		if($obj === false) {
			return JText::_('This product is not supported!');
		}
		$version 	= JRequest::getVar('version');
		
		$list = $jauc->listBackupFiles($obj, $version);
		if($list === false) {
			return false;
		} else {
			return $list;
		}
		
		/*try {
			$list = $jauc->listBackupFiles($obj, $version);
			return $list;
		} catch (Exception $e) {
			// echo $e->getMessage();
			return false;
		}*/
	}
	
	// Recovery file
	function doRecoveryFile(){
		global $jauc;
		
		$obj = $this->_getProduct();
		if($obj === false) {
			return JText::_('This product is not supported!');
		}
		$file 	= JRequest::getVar('file');
		
		$obj->message = JRequest::getVar('comment', '');
		
		$result = $jauc->doRecoveryFile($obj, $file);
		if($result === false) {
			echo JText::_("Fail to recovery");
			return false;
		} else {
			$this->storeLastCheck($obj->extId, JText::_("You are successfully rollback at ") . date('d M Y, H:i:s'));
			return $result;
		}
		
		/*try {
			$result = $jauc->doRecoveryFile($obj, $file);
			return $result;
		} catch (Exception $e) {
			echo $e->getMessage();
			return false;
		}*/
	}
	
	function getComponentParams(){
		$db =& JFactory::getDBO();
		$query = "SELECT * FROM #__components WHERE link = 'option=".JACOMPONENT."'";
		$db->setQuery($query);
		return $db->loadObject();
	}
	
	function storeComponentParams(){
		$db =& JFactory::getDBO();
		$query = "SELECT params FROM #__components WHERE link = 'option=".JACOMPONENT."'";
		$db->setQuery($query);
		$arr = $db->loadAssoc();
		$arr1 = explode("\n",$arr['params']);
		
		$str_save = "";
		$data = $_REQUEST['params'];
		
		foreach ($data as $k=>$v){
			$exist = false;
			foreach($arr1 as $i=>$j){
				$j = explode("=", $j);
				if($j[0] == $k){
					$arr1[$i] = $j[0]."=".$v;
					$exist = true;
				}
			}
			if( !$exist )
				$str_save .= "\n".$k."=".$v;
		}
		$arr1 = implode("\n", $arr1).$str_save;
		
		$query = "UPDATE #__components SET params ='". mysql_real_escape_string($arr1) ."' WHERE link = 'option=".JACOMPONENT."'";
		$db->setQuery($query);
		$db->query();
	}
}
