<?php defined('_JEXEC') or die('Restricted access');
//JHTML::_('stylesheet', 'tienda.css', 'media/com_tienda/css/');
JHTML::_('script', 'tienda.js', 'media/com_tienda/js/');
$state = @$this->state;
$items = @$this->items;
$citems = @$this->citems;
$cat_params = array();
if (@$this->cat->category_params !== '') {
	$cat_params = explode('|',@$this->cat->category_params);
}
$grid_params = array('width' => '200', 'height' => '133', 'title_height' => '50');
if (count($cat_params))
{
	foreach ($cat_params as $param)
	{
		$item = explode('=',$param);
		$key = $item[0];
		$grid_params[$key] = $item[1];
	}
}
?>

<div id="tienda" class="products default">
<h1><span><?php echo @$this->title; ?></span></h1>
    <?php if ($this->level > 1 ) : ?>
        <div id="tienda_breadcrumb">
			<div class="moduletable">
            <?php echo TiendaHelperCategory::getPathName($this->cat->category_id, 'links'); ?>
			</div>
        </div>
    <?php endif; ?>

    <div id="tienda_categories">
            
            <div class='category_description'><?php echo $this->cat->category_description; ?></div>

        <?php if (!empty($citems)) : ?>
            <div id="tienda_subcategories">
                <?php if ($this->level > 1) { echo '<h3>'.JText::_('Subcategories').'</h3>'; } ?>
                <?php foreach ($citems as $citem) : ?>
                    <div class="subcategory">
                        <?php if (!empty($citem->category_full_image) || TiendaConfig::getInstance()->get('use_default_category_image', '1')) : ?>
                            <div class="subcategory_thumb">
                                <a href="<?php echo JRoute::_( "index.php?option=com_tienda&view=products&filter_category=".$citem->category_id.$citem->slug ); ?>">
                                <?php echo TiendaHelperCategory::getImage($citem->category_id); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <div class="subcategory_name">
                            <a href="<?php echo JRoute::_( "index.php?option=com_tienda&view=products&filter_category=".$citem->category_id.$citem->slug ); ?>">
                            <?php echo $citem->category_name; ?>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
                <div class="reset"></div>
            </div>
        <?php endif; ?>

    </div>

    <?php if (!empty($items)) : ?>
    <form action="<?php echo JRoute::_( @$form['action']."&limitstart=".@$state->limitstart )?>" method="post" name="adminForm" enctype="multipart/form-data">

        <div id="tienda_products">
            <?php foreach ($items as $item) : ?>
            <div class="product_item" style="width: <?php echo $grid_params['width'] ?>px;">
                <div class="product_thumb" style="height: <?php echo $grid_params['height'] ?>px;">
					<a href="<?php echo JRoute::_( $item->link."&filter_category=".$this->cat->category_id ); ?>">
                            <?php echo TiendaHelperProduct::getImage($item->product_id, 'id', $item->product_name, 'thumb', false, true, $grid_params); ?>
                        </a>
                </div>

                <div class="product_info">
                    <div class="product_name">
                        <span>
                            <a href="<?php echo JRoute::_($item->link."&filter_category=".$this->cat->category_id ); ?>">
                            <?php echo $item->product_name; ?>
                            </a>
                        </span>
                    </div>

					<div class="product_price">
						<span><?php echo TiendaHelperBase::currency($item->price); ?></span>
                    </div>

                    <div class="product_buy">
						<a href="<?php echo JRoute::_( $item->link."&filter_category=".$this->cat->category_id ); ?>">
							<?php echo JText::_('Add to cart') ?>
						</a>
                    </div>
                </div>
            </div>
            
            <?php endforeach; ?>
			<div class="reset"></div>
            <div id="products_footer">
                <div id="results_counter" class="pagination"><?php echo @$this->pagination->getResultsCounter(); ?></div>
                <?php echo @$this->pagination->getListFooter(); ?>
            </div>
        </div>

    <?php echo $this->form['validate']; ?>
    </form>
    <?php endif; ?>

</div>