<?php
defined('_JEXEC') or die('Restricted access');
JHTML::_('stylesheet', 'menu.css', 'media/com_tienda/css/');
JHTML::_('stylesheet', 'tienda.css', 'media/com_tienda/css/');
JHTML::_('script', 'tienda.js', 'media/com_tienda/js/');
JHTML::_('script', 'joomla.javascript.js', 'includes/js/');
Tienda::load( 'TiendaGrid', 'library.grid' );
$items = @$this->items;
$state = @$this->state;
?>

<div class='componentheading'>
    <span><?php echo JText::_( "My Shopping Cart" ); ?></span>
</div>

    <?php echo TiendaMenu::display(); ?>
    
<div class="cartitems">
    <?php if (!empty($items)) { ?>
    <form action="<?php echo JRoute::_('index.php?option=com_tienda&view=carts&task=update'); ?>" method="post" name="adminForm" enctype="multipart/form-data">


        
        <table class="adminlist" style="clear: both;">
            <thead>
                <tr>
                    <th style="width: 20px;">
                	   <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( @$items ); ?>);" />
                    </th>
                    <th class="product" style="text-align: left;"><?php echo JText::_( "Product" ); ?></th>
                    <th class="quantity" style="width: 50px;"><?php echo JText::_( "Quantity" ); ?></th>
                    <th class="total" style="width: 50px;"><?php echo JText::_( "Total" ); ?></th>
                </tr>
            </thead>
            <tbody>
            <?php $i=0; $k=0; $subtotal = 0; ?> 
            <?php foreach ($items as $item) : ?>
                <tr class="row<?php echo $k; ?>">
                    <td style="width: 20px; text-align: center;">
                        <input type="checkbox" id="cb<?php echo $i; ?>" name="cid[<?php echo $item->product_id.".".$item->product_attributes; ?>]" value="<?php echo $item->product_id; ?>" onclick="isChecked(this.checked);" />
                    </td>
                    <td>
                        <a href="<?php echo JRoute::_("index.php?option=com_tienda&view=products&task=view&id=".$item->product_id); ?>">
                            <?php echo $item->product_name; ?>
                        </a>
                        <br/>
                        
                        <?php if (!empty($item->attributes_names)) : ?>
	                        <?php echo $item->attributes_names; ?>
	                        <br/>
	                    <?php endif; ?>
	                    <input name="product_attributes[<?php echo $item->product_id.".".$item->product_attributes; ?>]" value="<?php echo $item->product_attributes; ?>" type="hidden" />
	                    
                        <?php echo JText::_( "Price" ); ?>: <?php echo TiendaHelperBase::currency($item->product_price); ?> 
                    </td>
                    <td class="quantity" style="width: 50px; text-align: center;">
                        <input name="quantities[<?php echo $item->product_id.".".$item->product_attributes; ?>]" type="text" size="3" maxlength="3" value="<?php echo $item->product_qty; ?>" />
                    </td>
                    <td class="total"  style="text-align: right;">
                        <?php $itemsubtotal = $item->product_price * $item->product_qty; ?>
                        <?php $subtotal = $subtotal + $itemsubtotal; ?>
                        <?php echo TiendaHelperBase::currency($itemsubtotal); ?>
                    </td>
                </tr>
            <?php ++$i; $k = (1 - $k); ?>
            <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="2" style="text-align: left;">
                        <input type="submit" class="button" value="<?php echo JText::_('Remove Selected'); ?>" name="remove" />
                    </td>
                    <td colspan="2">
                        <input style="float: right;" type="submit" class="button" value="<?php echo JText::_('Update Quantities'); ?>" name="update" />
                    </td>
                </tr>
                <tr>
                    <td colspan="3" style="font-weight: bold;">
                        <?php echo JText::_( "Subtotal" ); ?>
                    </td>
                    <td style="text-align: right;">
                        <?php echo TiendaHelperBase::currency($subtotal); ?>
                    </td>
                </tr>
                <tr>
                	<td colspan="4" style="white-space: nowrap;">
                        <b><?php echo JText::_( "Tax and Shipping Totals" ); ?></b>
                        <br/>
                        <?php
                        		echo JText::_( "Calculated during checkout process" );
                    	?>
              	 	</td>
                </tr>
                <tr>
                    <td colspan="20" style="text-align: right;">
				        <div class="bottomCheckout">
				        <span>
				        <a href="<?php echo JRoute::_('index.php?option=com_tienda&view=checkout'); ?>">
				            <?php echo JText::_( "Begin Checkout" ); ?>
				        </a>
				        </span>
				        </div>
                    </td>
                </tr>
            </tfoot>
        </table>
    </form>
    <?php } else { ?>
    <p><?php echo JText::_( "No items in your cart" ); ?></p>
    <?php } ?>
</div>