/**
 * [YUI] Live Search
 * Main Script
 * Version 4.0.5
 * @author mad@Max
 */
(function(){
	var Y = YAHOO.util, D = Y.Dom, E = Y.Event, L = YAHOO.lang;
	L.augmentObject(YAHOO.vBulletin.lsa, {
		init: function(){
			E.removeListener(this.textobj, "focus", this.start);
			E.on(this.textobj, "blur", this.winop, this, true);
			E.on(this.textobj, "focus", this.winop, this, true);
			E.on(this.textobj, "keyup", function(e){
				e = e || window.event;
				var code = e.keyCode || e.which;
				// don't send if typing left and right arrow, whitespase, home and end
				if (PHP.in_array(code, [37, 39, 32, 36, 35]) > -1) 
				{
					return;
				}
				this.get();
			}, this, true);
			E.on("lsarld", "click", this.get, this, true);
			E.on("lsacls", "click", this.winop, this, true);
		},
		load: function(){
			YAHOO.util.Connect.asyncRequest("POST", this.bb + '/ajaxlivesearch.php?do=lsawin', {
				success: function(o){
					if (o.responseXML) 
					{
						this.cont = document.createElement("div");
						this.cont.id = "lsa_cont";
						this.cont.style.position = "absolute";
						this.cont.style.display = "none";
						this.cont.innerHTML = o.responseXML.getElementsByTagName("lsagetwin")[0].firstChild.nodeValue;
						document.body.appendChild(this.cont);
						this.textobj.value = '';
						this.resobj = D.get("lsa_results");
						this.init();
						new Y.DD(this.cont.id).setHandleElId("lsadd");
						this.winop();
						init_collapsers();
					}
				},
				failure: vBulletin_AJAX_Error_Handler,
				timeout: vB_Default_Timeout,
				scope: this
			}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=lsawin");
		},
		winop: function(e){
			if (this.cont.style.display == "none") 
			{
				this.textobj.value = '';
				this.resobj.innerHTML = vbphrase['lsa_wait'];
				this.cont.style.display = "block";
				center_element(this.cont);
			}
			else 
			{
				if (E.getTarget(do_an_e(e)).id == "lsacls") 
				{
					this.cont.style.display = "none";
				};
				this.textobj.value = this.textobj.value || vbphrase['live_search'];
			}
		},
		get: function(){
			// create word or couple words
			var str = PHP.trim(this.textobj.value), ww = D.get('lsawithword').value > 0, send = '';
			if (str.length >= this.min) 
			{
				send = str;
				if (!ww) 
				{
					var words = str.split(" ");
					send = '';
					for (var i in words) 
					{
						if (words[i].length < this.min){continue;}
						send += (send ? " " : "") + words[i];
					}
				}
			}
			
			if (send.length >= this.min) 
			{
				if (ww || !(words.length > 1 && send != str)) 
				{
					if (this.timeout){this.timeout.cancel();}
					this.timeout = L.later(500, this, this.send, send);
				}
			}
			else 
			{
				this.resobj.innerHTML = vbphrase['lsa_wait'];
			}
		},
		send: function(send){
			var pf = new vB_Hidden_Form(null), obj = this.resobj, load = D.get("lsaloading");
			pf.add_variables_from_object(D.get("lsform"));
			D.removeClass(load, "hidden");
			
			if (Y.Connect.isCallInProgress(this.req)) 
			{
				Y.Connect.abort(this.req);
			}
			
			var xml = new vB_AJAX_Handler(true);
			xml.callback = function(o){
				D.addClass(load, "hidden");
				obj.innerHTML = o.responseXML.getElementsByTagName("ajaxlivesearch")[0].firstChild.nodeValue;
			};
			xml.send("ajaxlivesearch.php?do=search", "&do=search&" + pf.build_query_string().replace(/lsazone=([a-z0-9]+)&/g, function($0, $1, pos){
				return (pos == 24 ? "lsazone=" : ",") + $1 + (RegExp.rightContext.search(/^lsasort/) == 0 ? "&" : "");
			}) + "keyword=" + PHP.urlencode(send));
			this.req = xml.conn;
		}
	});
}());