<?php
/*======================================================================*\
|| #################################################################### ||
|| # Username Request Viewing                                         # ||
|| # Copyright King Kovifor 2007                                     # ||
|| #    - CyberMama 2010                           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('user','cpglobal');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
        print_cp_no_permission();
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['unreq_acp_header']);

$pm =& datamanager_init('pm', $vbulletin, ERRTYPE_ARRAY);
$user =& datamanager_init('user', $vbulletin, ERRTYPE_ARRAY);

$vbulletin->input->clean_array_gpc('g',array('id' => TYPE_INT, 'ui' => TYPE_INT));

if(empty($_REQUEST['do']))
{
        print_table_start();
        print_table_header($vbphrase['unreq_acp_requests'],4);
        print_cells_row(array($vbphrase['unreq_acp_username'],$vbphrase['unreq_requested'],$vbphrase['unreq_date'], $vbphrase['unreq_acp_actions']),true);
        $sql = $db->query("SELECT * FROM `" . TABLE_PREFIX . "unreq`");

        if($db->num_rows($sql) < 1)
        {
                print_cells_row(array($vbphrase['unreq_acp_noreqs'],'','',''));
        }
        while($request = $db->fetch_array($sql))
        {
			           switch($request['status'])
                        {
							case'1':$status=$vbphrase['unreq_approved'];break;
							case'7':$status=$vbphrase['unreq_rejected'];break;
							case'9':$status=$vbphrase['unreq_requested'];break;
						}
                if($request['status'] == 1 || $request['status'] == 7)
                {
                        $actions = $status.'  <a href="unreq.php?do=unhist&amp;ui=' . $request['userid'] . '">'. $vbphrase['unreq_un_hist'] .'</a>';
                }
                else
                {
                        $actions = '<a href="unreq.php?do=approve&amp;id=' . $request['id'] . '">'. $vbphrase['unreq_acp_appove'] .'</a> - <a href="unreq.php?do=reject&amp;id=' . $request['id'] . '">'. $vbphrase['unreq_acp_reject'] .'</a> - <a href="unreq.php?do=unhist&amp;ui=' . $request['userid'] . '">'. $vbphrase['unreq_un_hist'] .'</a>';
                }
                $date = ($request['date'] == 0) ? $vbphrase['unreq_acp_unknown_date'] : vbdate($vbulletin->options['timeformat'],$request['date']) . ', ' . vbdate($vbulletin->options['dateformat'],$request['date']);
                print_cells_row(array($request['username'],$request['requested'], $date,$actions));
        }
        print_table_footer();
}

if($_REQUEST['do'] == 'reject')
{
        print_table_start();
        print_table_header($vbphrase['unreq_acp_results']);
        // Send Rejection Message
        $sql = $db->query("SELECT * FROM `" . TABLE_PREFIX . "unreq` WHERE `id`='" .$db->escape_string( $vbulletin->GPC['id']) . "'");
        $request = $db->fetch_array($sql);
        $userinfo = fetch_userinfo($vbulletin->options['unreq_fromid']);
        $pm->set('fromuserid', $vbulletin->options['unreq_fromid']);
         $pm->set('fromusername', $userinfo['username']);
        $pm->set_recipients($request['username'], $botpermissions);
       
        $pm->set('title', construct_phrase($vbphrase['unreq_userpm_title'],$vbphrase['unreq_rejected']));
        $pm->set('message', $vbphrase['unreq_userpm_rtxt']);
        $pm->set('dateline', TIMENOW);
        if(empty($pm->errors))
        {
                $pm_status = 'OK';
                $pm->save();
        }
        else
        {
                $pm_status = $vbphrase['unreq_acp_pm_failed'];
        }
        print_cells_row(array($vbphrase['unreq_acp_pm'],$pm_status));
        $db->query("UPDATE `" . TABLE_PREFIX . "unreq` SET `status`='7' WHERE `id`='" . $db->escape_string($vbulletin->GPC['id']) . "'");
        print_table_footer();
}

if($_REQUEST['do'] == 'approve')
{
        print_table_start();
        print_table_header($vbphrase['unreq_acp_results']);
        // Change Username
                // Build Request array
        $sql = $db->query("SELECT * FROM `" . TABLE_PREFIX . "unreq` WHERE `id`='" . $db->escape_string($vbulletin->GPC['id']) . "'");
        $request = $db->fetch_array($sql);
        $user->set_existing(fetch_userinfo($request['userid']));
                // Set Username to the new one.
        $user->set('username',$request['requested']);
                // Update Username
        $user->pre_save();
        if (!empty($user->errors))
        {
			$errors = "<ul>";
							foreach($user->errors As $err)
							{
								$errors .= '<li>' . $err . '</li>';
							}
							$errors .= '</ul>';
                eval(standard_error($errors));
        }
        else
        {
                $user->save();
        }
        $user->update_username($request['userid'],$request['requested']);
        print_cells_row(array(' ','OK'));
        $senderinfo=fetch_userinfo($vbulletin->options['unreq_fromid']);
        $pm->set('fromuserid', $vbulletin->options['unreq_fromid']);
         $pm->set('fromusername', $senderinfo['username']);
         $pm->set_recipients($request['requested'], $botpermissions);
        $pm->set('title', construct_phrase($vbphrase['unreq_userpm_title'],$vbphrase['unreq_approved']));
        $pm->set('message', construct_phrase($vbphrase['unreq_userpm_atxt'],$request['requested']));
       
        $pm->set('dateline', TIMENOW);
        if(empty($pm->errors))
        {
                $pm_status = 'OK';
                $pm->save();
        }
        else
        {
                $pm_status = $vbphrase['unreq_acp_pm_failed'];
        }
        print_cells_row(array($vbphrase['unreq_acp_pm'],$pm_status));
        if($vbulletin->options['unreq_thread'])
		{
			$posttext=construct_phrase($vbphrase['unreq_posttext'],$request['username'],$request['requested']);
					$postdm =& datamanager_init('Post', $vbulletin, ERRTYPE_ARRAY, 'threadpost');
					$postdm->set('threadid', $vbulletin->options['unreq_thread']);
					$postdm->set('userid', $vbulletin->options['unreq_fromid']);
					$postdm->set('pagetext', $posttext);
					$postdm->set('allowsmilie', '1');
					$postdm->set('visible', '1');
					$postdm->set('dateline', TIMENOW);
					$postdm->pre_save();
					if(!empty($postdm->errors)) 
						{
						    $errors = "<ul>";
							foreach($postdm->errors As $err)
							{
								$errors .= '<li>' . $err . '</li>';
							}
							$errors .= '</ul>';
							eval(standard_error($errors));
							print_cells_row(array($vbphrase['unreq_acp_postok'],'NO'));
						}
					else {
					$postdm->save();
					build_thread_counters($vbulletin->options['unreq_thread']);
			        $destthreadinfo = fetch_threadinfo($vbulletin->options['unreq_thread']);
			        build_forum_counters($destthreadinfo['forumid']);
					print_cells_row(array($vbphrase['unreq_acp_postok'],'OK'));
                          }
		}
        $db->query("UPDATE `" . TABLE_PREFIX . "unreq` SET `status`='1' WHERE `id`='" . $db->escape_string($vbulletin->GPC['id']) . "'");
        $db->query("DELETE FROM `" . TABLE_PREFIX . "unreq`  WHERE `userid`='" . $db->escape_string($request['userid']). "' AND status=9");
        print_table_footer();
}

if($_REQUEST['do'] == 'unhist' AND !empty($_GET['ui']))
{
        if(!empty($_GET['months']))
        {
                $days = 30*$_GET['months'];
                $time = time() - 60*60*24*$days;
                if(is_int($time))
                {
                        $sql = $db->query("SELECT * FROM `" . TABLE_PREFIX . "unreq` WHERE `userid`='" . $vbulletin->GPC['ui'] . "' AND `date` > $time");
                }
        }
        else
        {
                print_table_start();
                print '<form action="unreq.php?do=unhist&amp;ui=' . $vbulletin->GPC['ui'] . '" method="get">';
                print_table_header($vbphrase['unreq_acp_unhist_tip']);
                //print_cells_row(array($vbphrase['unreq_acp_unhist_tip_p1'],$vbphrase['unreq_acp_unhist_tip_p2']));
                print_cells_row(array($vbphrase['unreq_acp_unhist_tip_p1'],''));
                construct_hidden_code('do','unhist');
                construct_hidden_code('ui',$vbulletin->GPC['ui']);
                print_input_row($vbphrase['unreq_acp_months'], 'months');
                print_submit_row($vbphrase['unreq_acp_refine']);
                print '</form>';
                print_table_footer();
                $sql = $db->query("SELECT * FROM `" . TABLE_PREFIX . "unreq` WHERE `userid`='" . $vbulletin->GPC['ui'] . "'");
        }

        if($db->num_rows($sql) < 1)
        {
                print_table_start();
                print_table_header($vbphrase['unreq_un_hist']);
                print_cells_row(array($vbphrase['unreq_acp_no_unhist']));
                print_table_footer();
        }
        else
        {
                print_table_start();
                print_table_header($vbphrase['unreq_un_hist'],4);
                print_cells_row(array($vbphrase['unreq_acp_orininal'], $vbphrase['unreq_acp_new'], $vbphrase['unreq_status'], $vbphrase['unreq_date']),true);
                while($history = $db->fetch_array($sql))
                {
                        $date = ($history['date'] == 0) ? $vbphrase['unreq_acp_unknown_date'] : vbdate($vbulletin->options['timeformat'],$history['date']) . ', ' . vbdate($vbulletin->options['dateformat'],$history['date']);
                        switch($history['status'])
                        {
							case'1':$status=$vbphrase['unreq_approved'];break;
							case'7':$status=$vbphrase['unreq_rejected'];break;
							case'9':$status=$vbphrase['unreq_requested'];break;
						}
                        print_cells_row(array($history['username'], $history['requested'],$status,$date));
                }
                print_table_footer();
        }
}

if($_REQUEST['do'] == 'unhist' AND empty($_GET['ui']))
{
        print_table_start();
        print_table_header($vbphrase['unreq_acp_error']);
        print_cells_row(array($vbphrase['unreq_acp_no_un_spec']));
        print_table_footer();
        print_cp_redirect('unreq.php',10);
}
print_cp_footer();

?>
