<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Rotating Banner System                                                 # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2008-2010 - All Rights Reserved.     # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2008-2010 - All Rights Reserved
 * @version 2.2.2
 * @link www.pagerobot.com
 */

error_reporting(E_ALL & ~ E_NOTICE);
define('CVS_REVISION', '$RCSfile: admin_rbs_banner_list.php,v $ - $Revision: 1.2 $');

$phrasegroups = array();
$specialtemplates = array();

require_once './global.php';

// #############################################################################
// ######################### START MAIN SCRIPT #################################
// #############################################################################

if(!can_administer('canadminmaintain'))
{
    print_cp_no_permission();
}

log_admin_action();

print_cp_header($vbphrase['rbs_rotating_banner_system']);
print_form_header('admin_rbs');
print_table_header($vbphrase['rbs_banner_list'], 5);
print_cells_row(array($vbphrase['rbs_id'], $vbphrase['rbs_short_name'], $vbphrase['rbs_short_position'], $vbphrase['rbs_short_impressions'], $vbphrase['rbs_short_clicks']), true);

$SQL = "SELECT id, name, enabled, position, impressions, clicks, m_expired 
    FROM " . TABLE_PREFIX . "rbs_banners";

if(isset($_REQUEST['x']))
{
    // Show (not) expired items
    $x = intval($_REQUEST['x']);
    if($x)
    {
        // Get expired items
        $SQL .= " WHERE enddate<" . TIMENOW;
    }
    else
    {
        // Get not expired items
        $SQL .= " WHERE enddate>=" . TIMENOW;
    }
} elseif(isset($_REQUEST['e']))
{
    // Show (not) enabled items
    $e = intval($_REQUEST['e']);
    $SQL .= " WHERE enabled=$e";
} elseif(isset($_REQUEST['p']))
{
    // Show position 0...9 items
    $p = intval($_REQUEST['p']);
    $SQL .= " WHERE position=$p";
}
$SQL .= " ORDER BY id";


// Show items
$fmt = '<a href="admin_rbs.php?rbs_id=%d">%s</a>';
$n = 0;

$rss = $vbulletin->db->query_read($SQL);
while($rs = $vbulletin->db->fetch_array($rss))
{
    $id = sprintf($fmt, $rs['id'], vb_number_format($rs['id']));
    if(!$rs['name'])
    {
        $rs['name'] = $vbphrase['None'];
    }
    if($rs['m_expired'])
    {
        $rs['name'] = '*' . $rs['name'];
    }
    if($rs['enabled'])
    {
        $rs['name'] = '<b>' . htmlspecialchars_uni($rs['name']) . '</b>';
    }
    else
    {
        $rs['name'] = htmlspecialchars_uni($rs['name']);
    }

    $name = sprintf($fmt, $rs['id'], $rs['name']);
    $impressions = vb_number_format($rs['impressions']);
    $clicks = vb_number_format($rs['clicks']);
    $position = $rs['position'];
    print_cells_row(array($id, $name, $position, $impressions, $clicks), false, '', -1);
    $n++;
}

if(!$n)
{
    print_description_row($vbphrase['none'], false, 5);
}

print_table_footer();
print_cp_footer();
?>