<?php

/*============================*\
|| ########################## ||
|| # All Albums version 2.5 # ||
|| ########################## ||
\*============================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'all_albums');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('album', 'user');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'album_all_album_list',
	'album_all_albumbit',
	'album_all_sortarrow'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_album.php');
require_once(DIR . '/includes/functions_user.php');

if (!
	(
		$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_albums']
		AND
		$permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canviewmembers']
		AND
		$permissions['albumpermissions'] & $vbulletin->bf_ugp_albumpermissions['canviewalbum']
	)
)
{
	print_no_permission();
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

	$vbulletin->input->clean_array_gpc('r', array(
		'pagenumber' => TYPE_UINT,
		'sortfield' => TYPE_STR,
		'sortorder' => TYPE_STR,
		'query' => TYPE_STR
	));

	// Sort Order
	switch ($vbulletin->GPC['sortorder'])
	{
		case 'asc':
			$sortorder = 'asc';
			break;
		case 'desc':
			$sortorder = 'desc';
			break;
		default:
			$sortorder = $vbulletin->options['all_albums_default_sortorder'];
			break;
	}

	switch ($sortorder)
	{
		case 'asc':
			$oppositesort = 'desc';
			break;
		case 'desc':
			$oppositesort = 'asc';
			break;
	}
	
	// Sort Field
	switch ($vbulletin->GPC['sortfield'])
	{
		case 'title':
			$sortfield = 'title';
			break;
		case 'owner':
			$sortfield = 'owner';
			break;
		case 'pictures';
			$sortfield = 'pictures';
			break;
		case 'lastpicturedate';
			$sortfield = 'lastpicturedate';
			break;
		default:
			$sortfield = $vbulletin->options['all_albums_default_sortfield'];
			break;
	}

	switch ($sortfield)
	{
		case 'title':
			$sortname = 'album.title';
			break;
		case 'owner':
			$sortname = 'user.username';
			break;
		case 'pictures';
			$sortname = 'album.visible';
			break;
		case 'lastpicturedate';
			$sortname = 'album.lastpicturedate';
			break;
	}

	$searchquery = $vbulletin->GPC['query'];

	if ($searchquery && $vbulletin->options['all_albums_show_search_option'])
	{
		$searchwhere = "AND (album.title LIKE '%" . $db->escape_string($searchquery) . "%' OR album.description LIKE '%" . $db->escape_string($searchquery) . "%')";
		$searchquery = htmlspecialchars($searchquery);
	}

	eval('$sortarrow[' . $sortfield . '] = "' . fetch_template('album_all_sortarrow') . '";');

	$state = array('public');
	$state[] = 'private';
	$state[] = 'profile';

	$albumcount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "album AS album
		WHERE state IN ('" . implode("', '", $state) . "') $searchwhere
	");

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}

	$perpage = $vbulletin->options['albums_perpage'];
	$total_pages = max(ceil($albumcount['total'] / $perpage), 1); // handle the case of 0 albums
	$pagenumber = ($vbulletin->GPC['pagenumber'] > $total_pages ? $total_pages : $vbulletin->GPC['pagenumber']);
	$start = ($pagenumber - 1) * $perpage;

	// fetch data and prepare data
	$albums = $db->query_read("
		SELECT album.*,
			picture.pictureid, picture.extension, picture.idhash,
			picture.thumbnail_dateline, picture.thumbnail_width, picture.thumbnail_height,
			user.*
		FROM " . TABLE_PREFIX . "album AS album
		LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON (album.coverpictureid = picture.pictureid AND picture.thumbnail_filesize > 0)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (album.userid = user.userid)
		WHERE album.state IN ('" . implode("', '", $state) . "') $searchwhere
		ORDER BY $sortname $sortorder
		LIMIT $start, $perpage
	");

	$albumbits = '';
	while ($album = $db->fetch_array($albums))
	{
		if ($album['picturecount'])
		{
			$album['picturecount'] = vb_number_format($album['picturecount']);
		}
		else
		{
			$album['picturecount'] = vb_number_format($album['visible']);
		}
		$album['picturedate'] = vbdate($vbulletin->options['dateformat'], $album['lastpicturedate'], true);
		$album['picturetime'] = vbdate($vbulletin->options['timeformat'], $album['lastpicturedate']);

		$album['description_html'] = nl2br(fetch_word_wrapped_string(fetch_censored_text($album['description'])));
		$album['title_html'] = fetch_word_wrapped_string(fetch_censored_text($album['title']));

		$album['coverthumburl'] = ($album['pictureid'] ? fetch_picture_url($album, $album, true) : '');
		$album['coverdimensions'] = ($album['thumbnail_width'] ? "width=\"$album[thumbnail_width]\" height=\"$album[thumbnail_height]\"" : '');

		if ($album['state'] == 'private')
		{
			$show['personalalbum'] = true;
			$albumtype = $vbphrase['private_album_paren'];
			$can_view = can_view_private_albums($album['userid']);
		}
		else if ($album['state'] == 'profile')
		{
			$show['personalalbum'] = true;
			$albumtype = $vbphrase['profile_album_paren'];
			$can_view = can_view_profile_albums($album['userid']);
		}
		else
		{
			$show['personalalbum'] = false;
			$can_view = 'true';
		}

		$album['musername'] = fetch_musername($album);

		if ($can_view)
		{
			eval('$albumbits .= "' . fetch_template('album_all_albumbit') . '";');
		}
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $albumcount['total'],
		'all_albums.php?' . $vbulletin->session->vars['sessionurl'] . "sort=$sortfield&amp;order=$sortorder&amp;query=$searchquery", ''
	);

	// navbar and final output
	$navbits = construct_navbits(array(
		'all_albums.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['all_albums'],
		'' => $vbphrase['all_albums']
	));
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('album_all_album_list') . '");');

?>
