<?php

/*|===================================|*/
/*|  "  "         |*/
/*| for vb 3.6.x v 1.1.6 beta 3       |*/
/*| by kerk (http://vbsupport.org)    |*/
/*| & zCarot (http://vbhelp.org)      |*/
/*|===================================|*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################

define('THIS_SCRIPT', 'attaches');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('user', 'timezone', 'postbit', 'showthread', 'posting', 'forumdisplay', 'search');

$globaltemplates = array(
        'KR_ALL_ATTACHES_SHELL',
        'kr_all_attaches_list',
        'kr_all_attaches',
        'kr_all_attaches_sortarrow',
        'kr_all_attaches_sortoption',
        'kr_all_attaches_no_attachments',
        'KR_ALL_ATTACHES_FLIST',
        'kr_all_attaches_forumlist',
        'kr_all_attaches_forums',
        'kr_all_attaches_search',
        'kr_all_attaches_forums_sortarrow'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ####################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_search.php');
require_once(DIR . '/includes/functions_forumlist.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/functions_forumdisplay.php');
require_once(DIR . '/includes/functions_misc.php');

function in_string($needle, $haystack, $insensitive = 0)
{
   if ($insensitive)
   {
            return (false !== stristr($haystack, $needle)) ? true : false;
   }else{
            return (false !== strpos($haystack, $needle))  ? true : false;
   }
}

$ver = $vbulletin->options['kr_all_attaches_version']." - ".date('Y', TIMENOW);
eval(base64_decode('aWYoISR2ZXIpeyBleGl0OyB9'));
// ####################### START MAIN SCRIPT ############################
if(empty($_REQUEST['do']) OR ($_REQUEST['do'] == 'search' AND empty($_REQUEST['f'])))
{
        $_REQUEST['do'] = 'main';
}
if($vbulletin->options['useforumjump'] && $vbulletin->options['kr_all_attaches_useforumjump'])
{
        construct_forum_jump();
        $show['forumjump'] = true;
}
// ####################### FORUMS LIST START ############################
if($_REQUEST['do'] == 'main' AND empty($_REQUEST['f']))
{
  $forumperms = array();
  foreach($vbulletin->forumcache AS $forum)
  {
         $forumperms[$forum["forumid"]] = fetch_permissions($forum['forumid']);

         // ## HIDE FORUMS WITHOUT THE CANVIEW PERMISSION ##
         if (!($forumperms[$forum["forumid"]] & $vbulletin->bf_ugp_forumpermissions['canview']) AND !$vbulletin->options['showprivateforums'])
         {
              $hiddenforumids .= ',' . $forum['forumid'];
         }
  }
        $templatename = 'kr_all_attaches_forums';

        // Variables reused in templates
        $sortfield = $vbulletin->input->clean_gpc('r', 'sortfield', TYPE_STR);
        $sortorder = $vbulletin->input->clean_gpc('r', 'sortorder', TYPE_STR);
        $vbulletin->input->clean_array_gpc('r', array('forumid' => TYPE_INT));
        //$search = $vbulletin->input->clean_gpc('r', 'search', TYPE_STR);  // In future :)
// Make as default forumlist
if ($sortfield == '')
{
        $sortfield = $vbulletin->options['kr_all_attaches_sortfield'];
}
if ($sortorder == '')
{
        $sortorder = $vbulletin->options['kr_all_attaches_sortorder'];
}

        switch ($sortfield)
        {
                case 'forumid':
                        $sqlsort = 'forum.forumid';
                        break;
                case 'title':
                        $sqlsort = 'forum.title';
                        break;
                default:
                        $handled = false;
                        $sqlsort = 'forum.forumid';
                        $sortfield = $vbulletin->options['kr_all_attaches_sortfield'];
        }
        $sortorder = strtolower($sortorder);
        if ($sortorder != 'desc')
        {
                $sortorder = 'asc';
                $oppositesort = 'desc';
        }
        else
        {       //$sortorder = 'desc';
                $oppositesort = 'asc';
        }
        $forums = $db->query_read("
                             SELECT
                                COUNT(*) AS count,
                                SUM(filesize) AS totalsize,
                                SUM(counter) AS downloads,
                              attachment.postid, attachment.attachmentid, attachment.dateline,
                              post.threadid, post.postid,
                              thread.threadid, thread.forumid,
                              forum.forumid, forum.title
                             FROM " . TABLE_PREFIX . "attachment AS attachment
                             LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.postid = attachment.postid)
                             LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (thread.threadid = post.threadid AND thread.attach > 0)
                             LEFT JOIN " . TABLE_PREFIX . "forum AS forum ON (forum.forumid = thread.forumid)
                             LEFT JOIN " . TABLE_PREFIX . "deletionlog AS deletionlog ON(thread.threadid = deletionlog.primaryid AND type = 'thread')
                             WHERE forum.forumid NOT IN (0$hiddenforumids)
                             AND thread.visible = '1'
                             AND deletionlog.primaryid IS NULL
                             GROUP BY forum.forumid
                             ORDER BY $sqlsort $sortorder
        ");

        $template['kr_all_attaches_forumlist'] = '';
        while($forum = $db->fetch_array($forums))
        {
          $totalattachments = vb_number_format($forum['count']);
          $attachsum = vb_number_format($forum['totalsize'], 1, true);

          $forum['attachdate'] = vbdate($vbulletin->options['dateformat'], $forum[dateline]);
          $forum['attachtime'] = vbdate($vbulletin->options['timeformat'], $forum[dateline]);
          $forum['counter'] = vb_number_format($attach['counter']);
          $forum['size'] = vb_number_format($forum['size'], 1, true);
          eval('$template["kr_all_attaches_forumlist"] .= "' . fetch_template('kr_all_attaches_forumlist') . '";');
        }
        $sorturl = 'attaches.php?' . $vbulletin->session->vars['sessionurl'];

        eval('$kr_forums_sortarrow[' . $sortfield . '] = "' . fetch_template('kr_all_attaches_forums_sortarrow') . '";');

        $navbits['attaches.php'] = $vbphrase['kr_all_attaches_catalog'];
        $navbits[''] = $vbphrase['kr_all_attaches_catalog'];

        $shelltemplate = 'KR_ALL_ATTACHES_FLIST';
// ############### Forums List End, Start Page Output #################
    if ($templatename != '')
     {
        $navbits = construct_navbits($navbits);
        eval('$navbar = "' . fetch_template('navbar') . '";');
        eval('$KR_ALL_HTML_FORUMLIST = "' . fetch_template($templatename) . '";');
        eval('print_output("' . fetch_template($shelltemplate) . '");');
     }
}
// ####################### ATTACHMENTS LIST START #####################
if($_REQUEST['f'])
{
        // get permission to view forum
        $_permsgetter_ = 'forumdisplay';
        $forumperms = fetch_permissions($foruminfo['forumid']);
        if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']))
        {
                print_no_permission();
        }
        // disable thread preview if we can't view threads
        if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewthreads']))
        {
                $vbulletin->options['threadpreview'] = 0;
        }
        // get forum info
        $forum = fetch_foruminfo($forumid);
        $foruminfo =& $forum;

        if (!$foruminfo['forumid'])
        {
                eval(standard_error(fetch_error('invalidid', $vbphrase['forum'], $vbulletin->options['contactuslink'])));
        }

  $kr_usergroupid = true;
  if ($vbulletin->options['kr_all_attaches_ugpid']=='' OR $vbulletin->options['kr_all_attaches_ugpid']=='0')
  {
        $kr_usergroupid = false;
  }
        $kr_usergroupid = explode(",", $vbulletin->options['kr_all_attaches_ugpid']);
  // Denied access to usergroups in array
  if (in_array($vbulletin->userinfo['usergroupid'], $kr_usergroupid))
  {
        print_no_permission();
  }

        // Variables reused in templates
        $perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
        $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
        $sortfield = $vbulletin->input->clean_gpc('r', 'sortfield', TYPE_STR);
        $sortorder = $vbulletin->input->clean_gpc('r', 'sortorder', TYPE_STR);
        $ext = $vbulletin->input->clean_gpc('r', 'ext', TYPE_STR);
        $days = $vbulletin->input->clean_gpc('r', 'days', TYPE_INT);
        $vbulletin->input->clean_array_gpc('r', array('userid' => TYPE_UINT));
        $vbulletin->input->clean_array_gpc('r', array('forumid' => TYPE_INT));
        $search = $vbulletin->input->clean_gpc('r', 'search', TYPE_STR);
// Make as default attachment list
if ($sortfield == '')
{
        $sortfield = 'dateline';
}
if ($sortorder == '')
{
        $sortorder = 'desc';
}

        switch ($sortfield)
        {
                case 'username':
                        $sqlsort = 'user.username';
                        break;
                case 'filesize':
                        $sqlsort = 'attachment.filesize';
                        break;
                case 'dateline':
                        $sqlsort = 'attachment.dateline';
                        break;
                case 'downloads':
                        $sqlsort = 'attachment.counter';
                        break;
                case 'filename':
                        $sqlsort = 'attachment.filename';
                        break;
                default:
                        $handled = false;
                        $sqlsort = 'attachment.dateline';
                        $sortfield = 'dateline';
        }
        $sortorder = strtolower($sortorder);
        $sort = array($sortfield => 'selected="selected"');


        if ($sortorder != 'desc')
        {
                $order = array('asc' => 'selected="selected"');
                $sortorder = 'asc';
                $oppositesort = 'desc';
        }
        else
        {       //$sortorder = 'desc';
                $oppositesort = 'asc';
        }
   if($vbulletin->options['enablesearches'])
   {
        // Show Search Form to user, char. limit, etc...
        $_POST['fname'] = trim($_POST['fname']);
        $search_char = $vbulletin->options['kr_all_attaches_search_char'];
        $search_enabled = $vbulletin->options['kr_all_attaches_search_enabled'];
        if(empty($search_char) OR ($search_char < 3) OR ($search_char == 0))
        {
                $search_char = 3;
        }
        $show['search_form'] = $search_enabled == true ? true : false;
        $show['search_result'] = ($search_enabled AND !empty($_POST['fname']) AND strlen($_POST['fname']) >= $search_char) == true ? true : false;
        $vbphrase['kr_all_attaches_search_ignore'] = construct_phrase($vbphrase['kr_all_attaches_search_ignore'], $search_char);
        // Check charackter limit js
        $kr_js = "
                 <script type=\"text/javascript\">
                 <!--
                  function kr_submit()
                  {
                       if(document.krform.fname.value.length < $search_char)
                       {
                              toggle_collapse('errors');
                              return false;
                       }else{
                              return true;
                       }
                  }
                  function kr_hide_errors()
                  {
                       fetch_object('collapseobj_errors').style.display = 'none';
                       return false;
                  }
                 //-->
                 </script>";

        $errors = construct_phrase($vbphrase['kr_all_attaches_inforum_searchreq_less_x'], $search_char);
        eval('$kr_all_attaches_search .= "' . fetch_template('kr_all_attaches_search') . '";');
        // Search for files
        if($search_enabled AND $_REQUEST['do'] == 'search')
        {     // Start timer
              $searchstart = microtime();
              $where_file = '';
              if ($show['search_result'])
              {
                     $searchword = preg_replace('#"([^"]+)"#sie', "stripslashes(str_replace('*', ' ', '\\0'))", $_POST['fname']);
                     $searchword = sanitize_word_for_sql($searchword);
                     $where_file .= " AND attachment.filename LIKE '%".$db->escape_string_like(htmlspecialchars_uni($searchword))."%'";
              }else{
                     $where_file = '';
                     $no_attachments = construct_phrase($vbphrase['kr_all_attaches_inforum_searchreq_less_x'], $search_char);
                     eval('$kr_no_attaches = "' . fetch_template('kr_all_attaches_no_attachments') . '";');
              }
        }
    }
    if($_REQUEST['ext'])
    {
            $_REQUEST['ext'] = strtolower(htmlspecialchars_uni(strip_tags($_REQUEST['ext'])));
    }

  // Choice for period
  $daysarray = array("-1" => $vbphrase[beginning],
                     "1" => $vbphrase[last_day],
                     "2" => $vbphrase[last_2_days],
                     "7" => $vbphrase[last_week],
                     "10" => $vbphrase[last_10_days],
                     "14" => $vbphrase[last_2_weeks],
                     "30" => $vbphrase[last_month],
                     "45" => $vbphrase[last_45_days],
                     "60" => $vbphrase[last_2_months],
                     "75" => $vbphrase[last_75_days],
                     "100" => $vbphrase[last_100_days],
                     "365" => $vbphrase[last_year]
                   );
  $daysel = iif($days == -1, 'all', $days);
  $daysel = array($daysel => 'selected="selected"');

  if (empty($daysarray[$days]))
  {
           $days = -1;
  }

  $where_date = '';
  if ($days != -1)
  {
           $where_date .= " AND attachment.dateline > " . (TIMENOW - $days * 86400);
  }
  $dvalue = $daysarray[$days];

  foreach($daysarray AS $key => $val)
  {
           $dvalues .= "<option value=\"".$key."\" ".$daysel[$key].">".$val."</option>\n";
  }

  // Phrase in template "kr_all_attaches_sortoption"
  if($days != -1 AND $_REQUEST['ext'] == 'all')
  {
    $attaches_for_period = construct_phrase($vbphrase['kr_all_attaches_inforum_forperiod'], $foruminfo['forumid'], $foruminfo['title'], $dvalue);
  }
  elseif($days == -1 AND !empty($_REQUEST['ext']) AND $_REQUEST['ext'] != 'all')
  {
    $attaches_for_period = construct_phrase($vbphrase['kr_all_attaches_inforum_ext'], strtoupper($_REQUEST['ext']), $foruminfo['forumid'], $foruminfo['title']);
  }
  elseif($days != -1 AND !empty($_REQUEST['ext']) AND $_REQUEST['ext'] != 'all')
  {
    $attaches_for_period = construct_phrase($vbphrase['kr_all_attaches_inforum_ext_forperiod'], strtoupper($_REQUEST['ext']), $foruminfo['forumid'], $foruminfo['title'], $dvalue);
  }
  elseif($show['search_result'])
  {
     $attaches_for_period = construct_phrase($vbphrase['kr_all_attaches_inforum_search'], trim($_POST['fname']));
  }
  else
  {
    $attaches_for_period = construct_phrase($vbphrase['kr_all_attaches_inforum_all'], $foruminfo['forumid'], $foruminfo['title']);
  }

  if ((!empty($ext)) && ($ext != 'all'))
  {
    $where_ext .= " AND attachment.extension LIKE '".$db->escape_string_like(htmlspecialchars_uni(strtolower($vbulletin->GPC['ext'])))."'";
  }

  // Choice for extension
  $extsel = iif($ext == -1, 'all', $ext);
  $extsel = array($extsel => 'selected="selected"');
  $kr_all_attaches_ext = '<option value="all" '.$extsel['all'].'>&nbsp;'.$vbphrase['kr_all_attaches_all_ext'].'</option>';
  $extensions = $db->query_read(" SELECT extension
                                  FROM " . TABLE_PREFIX . "attachmenttype
                                  WHERE enabled = 1
                                ");
  while($ext = $db->fetch_array($extensions))
  {
       if(is_array($ext))
       {
           $kr_all_attaches_ext .= "<option value=\"".strtolower($ext['extension'])."\" ".$extsel[$ext['extension']].">&nbsp;&nbsp;".strtoupper($ext['extension'])."</option>\n";
           $array .= $ext['extension']." ";
       }
  }
   $array_ext = explode(' ', $array);

  // Attachments list per page
  if ($perpage != 'select')
  {
          $perpage = intval($perpage);
  }
  $ppsel = iif($perpage == '', 'select', $perpage);
  $ppsel = array($ppsel => 'selected="selected"');
  $kr_all_attaches_pp = "<option value=\"select\" ".$ppsel['select'].">".$vbphrase['kr_all_attaches_default']."</option>\n";
  $kr_pp = explode(",", $vbulletin->options['kr_all_attaches_pp']);
  foreach($kr_pp AS $i)
  {
    $kr_all_attaches_pp .= "<option value=\"".$i."\" ".$ppsel[$i].">&nbsp; ".$i." ".$vbphrase['kr_all_attaches_x_perpage']."</option>\n";
  }
        $templatename = 'kr_all_attaches';
        eval('$kr_sortoption = "' . fetch_template('kr_all_attaches_sortoption') . '";');
        // Attachment count
        $stats = $db->query_first("
                SELECT
                   COUNT(*) AS count,
                   SUM(filesize) AS totalsize,
                   SUM(counter) AS downloads, filename AS filename,
                 post.threadid, post.postid,
                 thread.threadid, thread.forumid,
                 forum.forumid, forum.title
                FROM " . TABLE_PREFIX . "attachment AS attachment
                LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.postid = attachment.postid)
                LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (thread.threadid = post.threadid)
                LEFT JOIN " . TABLE_PREFIX . "forum AS forum ON (forum.forumid = thread.forumid)
                WHERE forum.forumid = ".$forum['forumid']."
                $where_date $where_ext $where_file
                GROUP BY forum.forumid
                ORDER BY forum.forumid
        ");

        $totalattachments = intval($stats['count']);
        $attachsum = intval($stats['totalsize']);
        // Max Length of attach extensions Thanks zCarot! :)
        $ext_len = 0;
        foreach($array_ext AS $name => $length)
        {
              if (strlen($length) > $ext_len)
              {
                    $ext_len = strlen($length);
              }
        }
        if(strlen($_REQUEST['ext']) > $ext_len)
        {
               $_REQUEST['ext'] = substr($_REQUEST['ext'], 0, $ext_len);
        }

        if(!$totalattachments)
        {
                $no_attachments = $vbphrase['kr_all_attaches_no_attachments'];
                eval('$kr_no_attaches = "' . fetch_template('kr_all_attaches_no_attachments') . '";');
        }else{  // Go Go...
                $perpage = intval($perpage);
                $attachsum = vb_number_format($attachsum, 1, true);
                $maxperpage = 100;
                if($show['search_result'])
                {
                        $defaultperpage = 100;
                }else{
                        $defaultperpage = 20;
                }
                sanitize_pageresults($totalattachments, $pagenumber, $perpage, $maxperpage, $defaultperpage);

                $limitlower = ($pagenumber - 1) * $perpage + 1;
                $limitupper = ($pagenumber) * $perpage;

                if ($limitupper > $totalattachments)
                {
                        $limitupper = $totalattachments;
                        if ($limitlower > $totalattachments)
                        {
                                $limitlower = $totalattachments - $perpage;
                        }
                }
                if ($limitlower <= 0)
                {
                        $limitlower = 1;
                }

        $sorturl = 'attaches.php?' . $vbulletin->session->vars['sessionurl'] . "f=".$vbulletin->GPC['forumid'].""
                   /*. ($_REQUEST['do'] == 'search' ? "&amp;do=search" : "")*/
                   . (!empty($vbulletin->GPC['ext']) ? "&amp;ext=".$vbulletin->GPC['ext']."" : "")
                   . (!empty($vbulletin->GPC['days']) ? "&amp;days=$days" : "");

        eval('$kr_sortarrow[' . $sortfield . '] = "' . fetch_template('kr_all_attaches_sortarrow') . '";');

        $attaches = $db->query_read("
                SELECT
                  attachmentid, attachment.dateline, attachment.postid, filename, counter, extension, attachment.filesize AS size,
                  thread.forumid, thread.title AS t_title,
                  post.postid, post.username, post.threadid AS p_threadid, post.title AS p_title, post.dateline AS p_dateline, post.pagetext AS preview,
                  user.userid, IF(user.userid<>0, user.username, post.username) AS username,
                  forum.forumid, forum.title
                FROM " . TABLE_PREFIX . "attachment AS attachment
                LEFT JOIN " . TABLE_PREFIX . "post AS post ON (attachment.postid=post.postid)
                LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid)
                LEFT JOIN " . TABLE_PREFIX . "user AS user ON (attachment.userid = user.userid)
                LEFT JOIN " . TABLE_PREFIX . "forum AS forum ON (forum.forumid = thread.forumid)
                WHERE forum.forumid = ".$forum['forumid']."
                $where_date $where_ext $where_file
                ORDER BY $sqlsort $sortorder
                LIMIT ".($limitlower - 1).", $perpage ");
         }

        if($show['search_result'])
        {
                $searchtime = number_format(fetch_microtime_difference($searchstart), 3, '.', '');
                $vbphrase['kr_all_attaches_x_files_found'] = construct_phrase($vbphrase['kr_all_attaches_x_files_found'], $totalattachments);
        }

        $template['kr_all_attaches_list'] = '';
        while($attach = $db->fetch_array($attaches))
        {
           $attach['filename'] = htmlspecialchars_uni($attach['filename']);
           if (!$attach['p_title'])
           {
                $attach['p_title'] = '&laquo;' . $vbphrase['n_a'] . '&raquo;';
           }

          $attach['date'] = vbdate($vbulletin->options['dateformat'], $attach[dateline]);
          $attach['time'] = vbdate($vbulletin->options['timeformat'], $attach[dateline]);
          $attach['counter'] = vb_number_format($attach['counter']);
          $attach['preview'] = strip_quotes($attach['preview']);
          $attach['preview'] = htmlspecialchars_uni(fetch_trimmed_title(strip_bbcode($attach['preview'], false, true), $vbulletin->options['threadpreview']));
          $attach['size'] = vb_number_format($attach['size'], 1, true);
          $attach['extension'] = strtolower(file_extension($attach['filename']));
          $newwintypes = array('gif', 'jpg', 'jpe', 'jpeg', 'png');
          $show['newwindow'] = in_array($attach['extension'], $newwintypes) == true ? true : false;
          eval('$template["kr_all_attacheslist"] .= "' . fetch_template('kr_all_attaches_list') . '";');
        }

        $pagenav = construct_page_nav($pagenumber, $perpage, $totalattachments, $sorturl
                . (!empty($sortfield) ? "&amp;sort=$sortfield" : "")
                . (!empty($sortorder) ? "&amp;order=$sortorder" : "")
                . (!empty($vbulletin->GPC['perpage']) ? "&amp;pp=$perpage" : "")
        );

$navbits = array();
$parentlist = array_reverse(explode(',', substr($foruminfo['parentlist'], 0, -3)));
foreach ($parentlist AS $forumID)
{
        $forumTitle = $vbulletin->forumcache["$forumID"]['title'];
        $navbits['attaches.php?' . $vbulletin->session->vars['sessionurl'] . "f=$forumID"] = $forumTitle;
}

// pop the last element off the end of the $nav array so that we can show it without a link
array_pop($navbits);
$navbits['attaches.php'] = $vbphrase['kr_all_attaches_catalog'];
$navbits[''] = $foruminfo['title'];
// ############## Attachments List End, Start Page Output #############
$shelltemplate = 'KR_ALL_ATTACHES_SHELL';

     if ($templatename != '')
     {
        $navbits = construct_navbits($navbits);
        eval('$navbar = "' . fetch_template('navbar') . '";');
        eval('$KR_ALL_HTML = "' . fetch_template($templatename) . '";');
        eval('print_output("' . fetch_template($shelltemplate) . '");');
     }
}
?>