<?php
/**
 * Core Design TypoCSS plugin for Joomla! 1.5
 * @author      Daniel Rataj, <info@greatjoomla.com>
 * @package     Joomla 
 * @subpackage	Content
 * @category    Plugin
 * @version     1.0.6
 * @copyright   Copyright (C)  2007 - 2008 Core Design, http://www.greatjoomla.com
 * @license     http://creativecommons.org/licenses/by/3.0/legalcode Creative Commons
 */

defined('_JEXEC') or die('Restricted access');

class plgContentCdTypoCssHelper
{
    /**
     * Unordered List
     *
     * Generates an HTML unordered list from an single or multi-dimensional array.
     *
     * @access	public
     * @param	array
     * @param	mixed
     * @return	string
     */
    function CdTypoCssUl($list, $attributes = '')
    {
        return plgContentCdTypoCssHelper::_CdTypoCssUlList('ul', $list, $attributes);
    }
    // ------------------------------------------------------------------------

    /**
     * Generates the list
     *
     * Generates an HTML ordered list from an single or multi-dimensional array.
     *
     * @access	private
     * @param	string
     * @param	mixed		
     * @param	mixed		
     * @param	intiger		
     * @return	string
     */
    function _CdTypoCssUlList($type = 'ul', $list, $attributes = '', $depth = 0)
    {
        // If an array wasn't submitted there's nothing to do...
        if (!is_array($list))
        {
            return $list;
        }

        // Set the indentation based on the depth
        $out = str_repeat(" ", $depth);

        // Were any attributes submitted?  If so generate a string
        if (is_array($attributes))
        {
            $atts = '';
            foreach ($attributes as $key => $val)
            {
                $atts .= ' ' . $key . '="' . $val . '"';
            }
            $attributes = $atts;
        }

        // Write the opening list tag
        $out .= "<" . $type . $attributes . ">\n";

        // Cycle through the list elements.  If an array is
        // encountered we will recursively call _list()

        static $_last_list_item = '';
        foreach ($list as $key => $val)
        {
            $_last_list_item = $key;

            $out .= str_repeat(" ", $depth + 2);
            $out .= "<li>";

            if (!is_array($val))
            {
                $out .= $val;
            } else
            {
                $out .= $_last_list_item . "\n";
                $out .= _list($type, $val, '', $depth + 4);
                $out .= str_repeat(" ", $depth + 2);
            }

            $out .= "</li>\n";
        }

        // Set the indentation for the closing tag
        $out .= str_repeat(" ", $depth);

        // Write the closing list tag
        $out .= "</" . $type . ">\n";

        return $out;
    }
    // ------------------------------------------------------------------------
}

/**
 * Core Design TypoCSS replacer
 *
 * Replace {typography}{/typography}
 *
 * @access	public
 * @param	string $string
 * @return	string
 */
function plgContentCdTypoCSSReplacer(&$match)
{
    // define general regex

    if ($match[1])
    {
        $mode = $match[1];
    } else
    {
        // nothing to define
    }

    if ($match[2] and $match[3] and $match[4])
    {
        $float = 'float: ' . $match[3] . '; width: ' . $match[4] . '; margin: 5px; ';
    } else
    {
        $float = 'float: none; margin: 5px;';
    }

    if ($match[5] == '!border')
    {
        $border = 'border: none; ';
    } else
    {
        $border = '';
        // nothing to define
    }

    if ($match[6] == '!background')
    {
        $background = 'background-color: transparent; ';
    } else
    {
        $background = '';
        // nothing to define
    }

    if ($match[7])
    {
        $message = $match[7];
    } else
    {
        // nothing to define
    }
    // end

    $icons_array = explode('|', _ALLOWED_TYPES_ICON);
    $box_array = explode('|', _ALLOWED_TYPES_BOX);
    $quote_array = explode('|', _ALLOWED_TYPES_QUOTE);
    $title_array = explode('|', _ALLOWED_TYPES_TITLE);
    $list_array = explode('|', _ALLOWED_TYPES_LIST);
    $pre_array = explode('|', _ALLOWED_TYPES_PRE);
    $list_number_array = explode('|', _ALLOWED_TYPES_LIST_NUMBER);
    $dropcap_array = explode('|', _ALLOWED_TYPES_DROPCAP);
    $bubble_array = explode('|', _ALLOWED_TYPES_BUBBLE);
    $legend_array = explode('|', _ALLOWED_TYPES_LEGEND);

    if (in_array($mode, $icons_array))
    {
        $model = 'icon';
    } elseif (in_array($mode, $box_array))
    {
        $model = 'box';
    } elseif (in_array($mode, $quote_array))
    {
        $model = 'quote';
    } elseif (in_array($mode, $title_array))
    {
        $model = 'title';
    } elseif (in_array($mode, $list_array))
    {
        $model = 'list';
    } elseif (in_array($mode, $pre_array))
    {
        $model = 'pre';
    } elseif (in_array($mode, $list_number_array))
    {
        $model = 'list_number';
    } elseif (in_array($mode, $dropcap_array))
    {
        $model = 'dropcap';
    } elseif (in_array($mode, $bubble_array))
    {
        $model = 'bubble';
    } elseif (in_array($mode, $legend_array))
    {
        $model = 'legend';
    } else
    {
        // nothing to define, script is continuing...
    }

    switch ($model)
    {
        case 'icon':
            return '<p class="cd_typocss_' . $mode . '" style="' . $border . $background . $float .
                '"><span>' . $message . '</span></p>';
            break;
        case 'box':
            return '<div style="' . $float . '"><div class="cd_typocss_left_' . $mode .
                '"><div class="cd_typocss_lefttop_' . $mode .
                '"><span class="cd_typocss_topright_' . $mode .
                '">&nbsp;</span></div><div class="cd_typocss_right_' . $mode .
                '"><div class="cd_typocss_text_' . $mode . '">' . $message .
                '</div></div><div class="bottomleft_' . $mode . '"><span class="bottomright_' .
                $mode . '">&nbsp;</span></div></div></div>';
            break;
        case 'quote':
            return '<blockquote style="' . $float . '" class="cd_typocss_' . $mode . '"><p>' .
                $message . '</p></blockquote>';
            break;
        case 'title':
            return '<div class="cd_typocss_' . $mode . '"><div class="cd_typocss_' . $mode .
                '_in">' . $message . '</div></div>';
            break;
        case 'list':

            $list = explode('||', $message);
            $attributes = array('class' => 'cd_typocss_' . $mode . '');
            $message = plgContentCdTypoCssHelper::CdTypoCssUl($list, $attributes);
            return $message;
            break;

        case 'list_number':

            // replace startline with <ul><li>, || characters with </li><ul> and endline with </li></ul>
            $list_regex = '#\A\s?([0-9]{1,2})?\.\s?#';

            $list_replace = '<ol class="cd_typocss_' . $mode . '"><li class="' . $mode . '_\\1">';
            $message = preg_replace($list_regex, $list_replace, $message);

            $list_regex = '#\|\|\s?([0-9]{1,2})?\.\s?#';

            $list_replace = '</li><li class="' . $mode . '_\\1">';
            $message = preg_replace($list_regex, $list_replace, $message);

            $list_regex = '#\z#';
            $list_replace = '</li></ol>';
            $message = preg_replace($list_regex, $list_replace, $message);
            // end

            return $message;
            break;
        case 'pre':
            return '<pre class="cd_typocss_' . $mode . '">' . $message . '</pre>';
            break;
        case 'dropcap':

            $dropcap_regex = '#(\w){1}(.*)?#';
            $dropcap_replace = '<p><span class="cd_typocss_' . $mode . '">\\1</span>\\2</p>';
            $message = preg_replace($dropcap_regex, $dropcap_replace, $message);
            return $message;
            break;
        case 'bubble':

            if (preg_match('#\|\|#', $message))
            {
                $message = explode('||', $message);

                if (isset($message[0]) and $message[0])
                {
                    $title = $message[0];
                } else
                {
                    $title = '';
                }

                if (isset($message[1]) and $message[1])
                {
                    $message = $message[1];
                } else
                {
                    $message = '';
                }

                return '<div style="' . $float . '" class="' . $mode .
                    '"><div><div><div><div><div>' . $message .
                    '</div> </div> </div> </div> </div><span class="author">' . $title .
                    '</span> </div>';


            } else
            {
                $title = '';

                return '<div style="' . $float . '" class="' . $mode .
                    '"><div><div><div><div><div>' . $message .
                    '</div> </div> </div> </div> </div><span class="author">' . $title .
                    '</span> </div>';

            }
            break;
        case 'legend':

            if (preg_match('#\|\|#', $message))
            {
                $message = explode('||', $message);

                if (isset($message[0]) and $message[0])
                {
                    $title = $message[0];
                } else
                {
                    $title = '';
                }

                if (isset($message[1]) and $message[1])
                {
                    $message = $message[1];
                } else
                {
                    $message = '';
                }

                return '<div style="' . $float . '" class="cd_typocss_' . $mode . '"><h3>' . $title .
                    '</h3><p>' . $message . '</p></div>';
            } else
            {
                $title = '';

                return '<div style="' . $float . '" class="cd_typocss_' . $mode . '"><h3>' . $title .
                    '</h3><p>' . $message . '</p></div>';
            }
            break;

        default:
            // nothing to define...
            break;
    }
    return;
}
// ------------------------------------------------------------------------


?>
