<?php
/**
 * Core Design TypoCSS plugin for Joomla! 1.5
 * @author      Daniel Rataj, <info@greatjoomla.com>
 * @package     Joomla 
 * @subpackage	Content
 * @category    Plugin 
 * @version     1.0.6
 * @copyright   Copyright (C)  2007 - 2008 Core Design, http://www.greatjoomla.com
 * @license     http://creativecommons.org/licenses/by/3.0/legalcode Creative Commons
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import library dependencies
jimport('joomla.plugin.plugin');
jimport('joomla.filesystem.file');
// end

class plgContentcd_typocss extends JPlugin
{

    /**
     * Constructor
     *
     * For php4 compatability we must not use the __constructor as a constructor for plugins
     * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
     * This causes problems with cross-referencing necessary for the observer design pattern.
     *
     * @param object $subject The object to observe
     * @param object $params  The object that holds the plugin parameters
     * @since 1.5
     */
    function plgContentcd_typocss(&$subject)
    {
        parent::__construct($subject);
        
        // load plugin parameters
        $this->plugin = &JPluginHelper::getPlugin('content', 'cd_typocss');
        $this->params = new JParameter($this->plugin->params);
    }

    /**
     * Call the TypoCSS function
     *
     * Method is called by the view
     *
     * @param 	object		The article object.  Note $article->text is also available
     * @param 	object		The article params
     * @param 	int			The 'page' number
     */
    function onPrepareContent(&$article, &$params, $limitstart)
    {
        global $mainframe;

        $live_path = JURI::base(); // define live site

        // load function file
        $FunctionFile = dirname(__file__) . DS . 'cd_typocss' .
            DS . 'utils' . DS . 'php' . DS . 'helper.php';
        if (JFile::exists($FunctionFile))
        {
            require_once ($FunctionFile);
        } else
        {
            JError::raiseWarning('', JText::_('Core Design TypoCSS plugin: Can not load a helper file.'));
            return;
        }
        // end

        // attach CSS style
        JHTML::stylesheet('cd_typocss.css', $live_path .
            'plugins/content/cd_typocss/css/');

        // end

        // define allowed css types
        $allowed_types_icon =
            'icon_alert|icon_info|icon_download|icon_ok|icon_no|icon_storno|icon_lock|icon_help|icon_user|icon_refresh|icon_preferences|icon_print|icon_email|icon_calendar|icon_note|icon_link|icon_gonext|icon_search|icon_browser|icon_volume';
        $allowed_types_box =
            'box_white|box_lightblue|box_lightgreen|box_lightorange|box_blue|box_red|box_orange|box_yellow|box_green';
        $allowed_types_quote = 'quote|quote_life|quote_design';
        $allowed_types_title =
            'title_gray|title_blue|title_yellow|title_pink|title_green|title_orange|title_red';
        $allowed_types_list =
            'list_bullet_black|list_bullet_blue|list_bullet_red|list_bullet_green|list_bullet_purple|list_bullet_yellow|list_arrow_black|list_arrow_blue|list_arrow_red|list_arrow_green|list_arrow_purple|list_arrow_yellow|list_plus_black|list_plus_blue|list_plus_red|list_plus_green|list_plus_purple|list_plus_yellow';
        $allowed_types_list_number =
            'list_number_black|list_number_gray|list_number_red|list_number_blue|list_number_yellow|list_number_green|list_number_bullet_white|list_number_bullet_red|list_number_bullet_green|list_number_bullet_blue|list_number_bullet_violet';
        $allowed_types_pre =
            'pre_gray|pre_black|pre_blue|pre_red|pre_green|pre_purple|pre_yellow';
        $allowed_types_dropcap = 'dropcap';
        $allowed_types_bubble =
            'bubble_speech_rounded|bubble_speech_square|bubble_thinking_rounded|bubble_thinking_square|bubble_brain_rounded|bubble_brain_square|bubble_book_rounded|bubble_book_square|bubble_help_rounded|bubble_help_square|bubble_pencil_rounded|bubble_pencil_square';
        $allowed_types_legend = 'legend_gray|legend_blue|legend_green|legend_red|legend_pink|legend_orange|legend_violet';

        if (!defined('_ALLOWED_TYPES_ICON') and !defined('_ALLOWED_TYPES_BLOCK') and !
            defined('_ALLOWED_TYPES_QUOTE') and !defined('_ALLOWED_TYPES_TITLE') and !
            defined('_ALLOWED_TYPES_PRE') and !defined('_ALLOWED_TYPES_LIST_NUMBER') and !
            defined('_ALLOWED_TYPES_DROPCAP') and !defined('_ALLOWED_TYPES_BUBBLE') and !defined('_ALLOWED_TYPES_LEGEND'))
        {
            DEFINE('_ALLOWED_TYPES_ICON', $allowed_types_icon);
            DEFINE('_ALLOWED_TYPES_BOX', $allowed_types_box);
            DEFINE('_ALLOWED_TYPES_QUOTE', $allowed_types_quote);
            DEFINE('_ALLOWED_TYPES_TITLE', $allowed_types_title);
            DEFINE('_ALLOWED_TYPES_LIST', $allowed_types_list);
            DEFINE('_ALLOWED_TYPES_PRE', $allowed_types_pre);
            DEFINE('_ALLOWED_TYPES_LIST_NUMBER', $allowed_types_list_number);
            DEFINE('_ALLOWED_TYPES_DROPCAP', $allowed_types_dropcap);
            DEFINE('_ALLOWED_TYPES_BUBBLE', $allowed_types_bubble);
            DEFINE('_ALLOWED_TYPES_LEGEND', $allowed_types_legend);
        } else
        {
            // nothing to do...
        }

        // end


        // define the regular expression for the bot
        $regex = "#{typography(?:\s?(" . _ALLOWED_TYPES_ICON . '|' . _ALLOWED_TYPES_BOX .
        '|' . _ALLOWED_TYPES_QUOTE . '|' . _ALLOWED_TYPES_TITLE . '|' .
        _ALLOWED_TYPES_LIST . '|' . _ALLOWED_TYPES_PRE . '|' .
        _ALLOWED_TYPES_LIST_NUMBER . '|' . _ALLOWED_TYPES_DROPCAP . '|' .
        _ALLOWED_TYPES_BUBBLE . '|' . _ALLOWED_TYPES_LEGEND . ")?\s?(([leftrighno]+?)?\s?=\s?([0-9px%em]+?)?)?\s?(!border)?\s?(!background)?)?}(.*?){/typography}#is";
        // end

        // Explication:
        // $match[1]	-> type (alert, note, download...)
        // $match[2]	-> position left - right (float boxes)
        // $match[3]	-> position
        // $match[4]	-> width
        // $match[5]	-> border
        // $match[6]	-> background
        // $match[7]	-> message

        // replacement {typography}{/typography}
        $article->text = preg_replace_callback($regex, 'plgContentCdTypoCSSReplacer', $article->
            text);

    }
}
?>
