<?php
/* -*- mode: php; tab-width: 4; indent-tabs-mode: t; coding: utf-8 -*- */
/**
 * vbulletin add-on fussball-tippspiele
 *
 * php version 5
 * vbulletin 4
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @author  xwing <xwing@geb-team.de>
 * @version SVN: $Id: vbsoccer_livedata.php 1311 2010-05-05 20:07:17Z aa $
 */

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE & ~8192);

if (!is_object($vbulletin->db))
{
	exit;
}

if (empty($vbulletin->products['vbsoccer']))
{
	exit;
}

if (!defined('TIMENOW'))
{
	/** @ignore */
	define('TIMENOW', time());
}

/** vbsoccer functions */
require_once DIR . '/includes/functions_vbsoccer.php';
require_once DIR . '/includes/vbsoccer_services.php';
$services = new vbsoccer_Services($vbulletin);
$services->check_livescores();

if ($services->stop_livescore_cron === false)
{
	$result = $vbulletin->db->query_first("SELECT `nextrun` FROM `" . TABLE_PREFIX . "cron` WHERE `varname`='vbsoccer_fixtures'");

	if ($result['nextrun'] == 0)
	{
		$result['nextrun'] = TIMENOW;
	}

	// pruefen, ob es nicht beendete spiele vor dem naechsten job gibt
	if (!$vbulletin->db->query_first("
		SELECT id
		FROM `" . TABLE_PREFIX . "soccer_match`
		WHERE `match_is_finished` IN(0,2) AND `dateline`<" . (int) $result['nextrun'] . "
		"))
	{
		// livejob kann gestoppt werden. er wird beim naechsten lauf des fixtures-
		// jobs bei bedarf wieder aktiviert
		$services->stop_livescore_cron = true;
	}
}

if ($services->stop_livescore_cron === true)
{
	// keine aktuellen spiele gefunden. cronjob wieder deaktivieren!
	if ((defined('VB_AREA') AND VB_AREA == 'AdminCP') OR (defined('IN_CONTROL_PANEL') AND IN_CONTROL_PANEL === true))
	{
		// achtung, nicht wenn der job manuell aus dem acp gestartet wurde!
	}
	else
	{
		$vbulletin->db->query_write("
			UPDATE `" . TABLE_PREFIX . "cron`
			SET `minute`='0', `hour`=0, `nextrun`=0, `active`=0
			WHERE `varname`='vbsoccer_livedata'
			");
	}
}
