<?php
/* -*- mode: php; tab-width: 4; indent-tabs-mode: t; coding: utf-8 -*- */
/**
 * vbulletin add-on fussball-tippspiele
 *
 * php version 5
 * vbulletin 4
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @author  xwing <xwing@geb-team.de>
 * @version SVN: $Id: vbsoccer_fixtures.php 1307 2010-05-05 12:15:09Z aa $
 */

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE & ~8192);

if (!is_object($vbulletin->db))
{
	exit;
}

if (empty($vbulletin->products['vbsoccer']))
{
	exit;
}

/** vbsoccer functions */
require_once DIR . '/includes/functions_vbsoccer.php';

/** vbsoccer services functions */
require_once DIR . '/includes/vbsoccer_services.php';

$services = new vbsoccer_Services($vbulletin);
$services->check_fixtures();

unset($services);

// nachdem alle geaenderten ansetzungen und/oder ergebnisse aktualisiert wurden,
// muss dieser cronjob so geaendert werden, dass er in 110 bis 150 minuten
// erneut startet. der minutenwert wird zufaellig gewaehlt, damit nicht alle
// tippspiele zur gleichen zeit den datendienst abfragen und es dadurch zu
// ueberlastungen kommt.
//
// hat der benutzer den job aus dem ACP manuell gestartet, dann die naechste
// ausfuehrungszeit dieses jobs nicht anpassen!

if ((defined('VB_AREA') AND VB_AREA == 'AdminCP') OR
	(defined('IN_CONTROL_PANEL') AND IN_CONTROL_PANEL === true))
{
	// nichts aendern wenn im acp manuell gestartet
}
else
{
	$minutes = range(110, 150);
	shuffle($minutes);

	// naechste ausfuehrungszeit des cronjobs "konstruieren"
	$dt = new DateTime();
	$dt->modify('+' . next($minutes) . ' minute');

	$hour   = $dt->format('H');
	$minute = $dt->format('i');
	$dt->setTime($hour, $minute, 0);
	$nextrun = $dt->format('U');

	// format fuer vbulletin-cronjobs (0 => unix-timestamp des naechsten starts)
	$serialized_minutes = serialize(array(0 => (int) $minute));

	// naechste ausfuehrung des cronjobs speichern
	$vbulletin->db->query_write("
		UPDATE `" . TABLE_PREFIX . "cron`
		SET `minute`='" . $vbulletin->db->escape_string($serialized_minutes) . "',
			`hour`=" . (int) $hour . ",
			`nextrun`=" . $nextrun . "
		WHERE `varname`='vbsoccer_fixtures'
		");
}

// jetzt muss ermittelt werden, wann das naechste spiel stattfindet.
// der cronjob zum aktualisieren der spielergebnisse waehrend einem spiel muss
// mit dem anstoss des naechsten spiels gestartet werden.
// wird nachfolgend keine noch zu spielende ansetzung gefunden, wird der
// cronjob zum aktualisieren von ergebnissen deaktiviert.

// pruefen, wann das naechste spiel stattfindet oder eins laeuft
if (($nextmatchinfo = $vbulletin->db->query_first("
		SELECT MIN(`dateline`) AS `nextdateline`
		FROM `" . TABLE_PREFIX . "soccer_match`
		WHERE `match_is_finished` IN(0,2)
		")))
{
	// livecronjob ab spielbeginn starten

	$startminute = range(0, 9);
	shuffle($startminute);
	$i = next($startminute);

	// aktualisierungs-intervalle
	$serialized_minutes = serialize(range($i, (50+$i), 10));

	// der minutenwert von nextrun muss einem eintrag der intervalle entsprechen
	// sonst laufen die cron-funktionen amok und aendern sowohl startzeit als
	// auch intervalle!
	//
	// beispiel: anstoss ist 20:45 Uhr, minuten-intervalle sind 4, 14, 24, 34, ...
	// $nextrun muss 20:54 Uhr ergeben (letzter minutenwert eine '4')
	$extractedminutes = (int) ceil($nextmatchinfo['nextdateline'] / 60);
	$nextrun = ($extractedminutes - ($extractedminutes % 10) + $i) * 60;

	// naechste ausfuehrung speichern
	$vbulletin->db->query_write("
		UPDATE `" . TABLE_PREFIX . "cron`
		SET `minute`='" . $vbulletin->db->escape_string($serialized_minutes) . "',
			`hour`=-1, `nextrun`=" . (int) $nextrun . ", `active`=1
		WHERE `varname`='vbsoccer_livedata'
		");
}
else
{
	// kein spiel gefunden, was noch zu spielen ist. live-cronjob deaktivieren.
	$vbulletin->db->query_write("
		UPDATE `" . TABLE_PREFIX . "cron`
		SET `minute`='0', `hour`=0, `nextrun`=0, `active`=0
		WHERE `varname`='vbsoccer_livedata'
		");
}
